<?php
$header_phone = ot_get_option( 'header_phone', '' );
$header_email = ot_get_option( 'header_email', '' );
$social_links = ot_get_option( 'social_links', array() );
?>
<div id="leap-header" class="header header-vh header11">
    <div class="header-vh-wrapper mCustomScrollbar" data-mcs-theme="minimal">
    <div class="logo">
        <a title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" href="<?php echo esc_url( home_url( '/' ) ); ?>">
            <?php
            $logo         = ot_get_option( 'logo', '' );
            if ( $logo ) {
                ?>
                <img alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" src="<?php echo esc_url( $logo ) ?>" />
                <?php
            } else {
                echo '<h1>' . esc_html( get_bloginfo( 'name', 'display' ) ) . '</h1>';
            }
            ?>
        </a>
    </div>


    <div class="navbar-inner">
        <div class="nav-container">

            <?php
            $main_menu      = leap_get_assigned_menu_on_theme_location( 'main-menu' );
            $page_id        = leap_get_current_page_id();
            $page_main_menu = get_post_meta( $page_id, 'leap_main_menu', TRUE );

            if ( $page_main_menu ) {
                $main_menu = $page_main_menu;
            }

            $main_menu_obj = wp_get_nav_menu_object( $main_menu );
            if ( !empty( $main_menu_obj ) && $main_menu_obj->count > 0 ) {
                wp_nav_menu( array(
                    'theme_location' => 'main-menu',
                    'menu'           => $main_menu,
                    'container'      => 'div',
                    'container_id'   => 'main-menu-container',
                    'menu_id'        => 'main-menu',
                    'menu_class'     => 'sf-menu main-menu',
                    'depth'          => 2,
                    'fallback_cb'    => false,
                    'link_before'    => '<span>',
                    'link_after'     => '</span>'
                ) );
            }
            ?>
            <?php
            $mobile_menu = leap_get_assigned_menu_on_theme_location( 'mobile-main-menu' );

            if ( empty( $mobile_menu ) ) {
                $mobile_menu = $main_menu;
            }

            $mobile_menu_obj = wp_get_nav_menu_object( $mobile_menu );
            if ( !empty( $mobile_menu_obj ) && $mobile_menu_obj->count > 0 ) {
                wp_nav_menu( array(
                    'theme_location' => 'mobile-main-menu',
                    'menu'           => $mobile_menu,
                    'container'      => 'div',
                    'container_id'   => 'main-menu-mobile-container',
                    'menu_id'        => 'main-menu-mobile',
                    'menu_class'     => 'main-menu-mobile hidden',
                    'depth'          => 0,
                    'walker'         => '',
                    'fallback_cb'    => false,
                ) );
            }
            ?>
            <div id="mobile-menu"></div>
        </div>
    </div>

    <div class="bottom-bar">
        <?php
        $header_search = ot_get_option( 'header_search', 'on' );
        if ( $header_search == 'on' ) {
            ?>
            <div class="static-search">
                <form class="navbar-search" role="search" method="get" action="<?php echo esc_attr( home_url( '/' ) ); ?>">
                    <input name="s" type="text" class="form-control search-query" value="<?php echo get_search_query(); ?>" placeholder="<?php esc_attr_e( 'Search ...', 'wiz' ); ?>"/>
                    <button type="submit" class="btn"></button>
                </form>
            </div>
            <?php
        }
        ?>
        <?php
        if ( !empty( $header_phone ) || !empty( $header_email ) || !empty( $social_links ) ) {
            ?>
            <div class="contact-info">
                <?php echo $header_phone; ?><?php if ( $header_phone && $header_email ): ?><br /><?php endif; ?><?php echo $header_email; ?>
            </div>
            <div class="social-icons">
                <?php get_template_part( 'includes/social', 'icons' ); ?>
            </div>    
            <?php
        }
        ?>
    </div>
</div>
</div>
