<?php
$featured_image			 = ot_get_option( 'post_display_post_formats', 'yes' );
$featured_image_position = ot_get_option( 'post_formats_position', 'above-title' );
$meta_settings			 = ot_get_option( 'post_meta_settings', array() );
?>
<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="entry-wrapper">
		<div class="entry-header">
			<?php
			if ( ($featured_image == 'yes') && !post_password_required() && ( $featured_image_position == 'above-title' ) ) {
				if ( get_post_format() == 'audio' ) {
					$leap_format_audio_embed = get_post_meta( get_the_ID(), '_format_audio_embed', true );
					echo '<div class="entry-head"><div class="post-audio">' . do_shortcode( $leap_format_audio_embed ) . '</div></div>';
				} elseif ( get_post_format() == 'video' ) {
					$leap_format_video_embed = get_post_meta( get_the_ID(), '_format_video_embed', true );
					echo '<div class="entry-head"><div class="post-video">' . do_shortcode( $leap_format_video_embed ) . '</div></div>';
				} elseif ( get_post_format() == 'gallery' ) {
					$leap_format_gallery = get_post_meta( get_the_ID(), '_format_gallery', true );
					echo '<div class="entry-head"><div class="post-gallery">' . do_shortcode( $leap_format_gallery ) . '</div></div>';
				} elseif ( get_post_format() == 'link' ) {
					$leap_format_link_title	 = esc_html( get_post_meta( get_the_ID(), '_format_link_title', true ) );
					$leap_format_link_url	 = esc_url( get_post_meta( get_the_ID(), '_format_link_url', true ) );
					echo '<div class="entry-head"><div class="post-link"><h5><i class="fa fa-link"></i> ' . esc_html__( 'Visit URL:', 'wiz' ) . ' <a target="_blank" href="' . $leap_format_link_url . '">' . $leap_format_link_title . '</a></h5></div></div>';
				} elseif ( get_post_format() == 'quote' ) {
					$leap_format_quote = get_post_meta( get_the_ID(), '_format_quote', true );
					echo '<div class="entry-head"><div class="post-quote">' . do_shortcode( $leap_format_quote ) . '</div></div>';
				} else {
					if ( has_post_thumbnail() ) {
						$large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'large' );
						?>
						<div class="entry-head">				
							<div class="post-img">
								<a data-rel="prettyPhoto" href="<?php echo $large_image_url[ 0 ]; ?>"  title="<?php the_title_attribute(); ?>"><?php echo get_the_post_thumbnail( get_the_ID(), 'leap-portfolio-1col' ); ?></a>
							</div>
						</div>
						<?php
					}
				}
			}
			?>

			<?php //Post title  ?>
			<div class="entry-info">
				<?php if ( ot_get_option( 'display_post_title', 'no' ) == 'yes' ) { ?>
					<?php if ( ot_get_option( 'post_title_link', 'off' ) == 'off' ) { ?>
						<h1 class="entry-title"><?php esc_html_e( get_the_title() ); ?></h1>
					<?php } else { ?>	 	
						<h1 class="entry-title"><a href="<?php the_permalink() ?>" title="<?php the_title_attribute(); ?>"><?php esc_html_e( get_the_title() ); ?></a></h1>
					<?php } ?>
				<?php } ?>

				<div class="entry-meta">
					<?php leap_entry_meta( $meta_settings ); ?>
				</div>
			</div>
		</div>

		<div class="entry-content">

			<?php
			if ( ($featured_image == 'yes') && !post_password_required() && ( $featured_image_position == 'below-title' ) ) {

				if ( get_post_format() == 'audio' ) {
					$leap_format_audio_embed = get_post_meta( get_the_ID(), '_format_audio_embed', true );
					echo '<div class="post-format post-audio">' . do_shortcode( $leap_format_audio_embed ) . '</div>';
				} elseif ( get_post_format() == 'video' ) {
					$leap_format_video_embed = get_post_meta( get_the_ID(), '_format_video_embed', true );
					echo '<div class="post-format post-video">' . do_shortcode( $leap_format_video_embed ) . '</div>';
				} elseif ( get_post_format() == 'gallery' ) {
					$leap_format_gallery = get_post_meta( get_the_ID(), '_format_gallery', true );
					echo '<div class="post-format post-gallery">' . do_shortcode( $leap_format_gallery ) . '</div>';
				} elseif ( get_post_format() == 'link' ) {
					$leap_format_link_title	 = esc_html( get_post_meta( get_the_ID(), '_format_link_title', true ) );
					$leap_format_link_url	 = esc_url( get_post_meta( get_the_ID(), '_format_link_url', true ) );
					echo '<div class="post-format post-link"><h5><i class="fa fa-link"></i> ' . esc_html__( 'Visit URL:', 'wiz' ) . ' <a target="_blank" href="' . $leap_format_link_url . '">' . $leap_format_link_title . '</a></h5></div>';
				} elseif ( get_post_format() == 'quote' ) {
					$leap_format_quote = get_post_meta( get_the_ID(), '_format_quote', true );
					echo '<div class="post-format post-quote">' . do_shortcode( $leap_format_quote ) . '</div>';
				} else {
					if ( has_post_thumbnail() ) {
						$large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'large' );
						?>
						<div class="post-format post-img">
							<div class="leap-overlay item-img one">
								<a data-rel="prettyPhoto" href="<?php echo $large_image_url[ 0 ]; ?>"  title="<?php the_title_attribute(); ?>"><?php echo get_the_post_thumbnail( get_the_ID(), 'leap-portfolio-1col' ); ?></a>

							</div>
						</div>
						<?php
					}
				}
			}
			?>
			<div class="post-content">
				<?php the_content(); ?>
				<?php
				wp_link_pages( array(
					'before'		 => '<div class="pagination pagination-page"><strong>' . esc_html__( 'Pages', 'wiz' ) . ':</strong><ul class="clearfix">',
					'after'			 => '</ul></div>',
					'next_or_number' => 'number',
					'link_before'	 => '<span>',
					'link_after'	 => '</span>'
				) );
				?>
			</div>

		</div>

		<div class="entry-footer">
			<?php
			if ( in_array( 'tags', $meta_settings ) ) {
				$tag_list = get_the_tag_list( '', __( ', ', 'wiz' ) );
				if ( $tag_list ) {
					echo '<small class="entry-tags small"><i class="fa fa-tags"></i> ' . __( 'Tags', 'wiz' ) . ': ' . $tag_list . '</small>';
				}
			}

			$show_share_buttons = ot_get_option( 'show_share_buttons', array() );
			if ( in_array( 'post', $show_share_buttons ) ) {
				get_template_part( 'includes/share-buttons' );
			}
			?>
		</div>

	</div>
</div>