<?php
$blog_layout   = ot_get_option( 'search_layout', 'medium' );
$meta_settings = ot_get_option( 'search_meta_settings', array() );
?>

<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <div class="entry-wrapper">
        <div class="entry-header">
            <?php
            if ( ($blog_layout != 'classic') && !post_password_required() ) {
                // Audio
                if ( get_post_format() == 'audio' ) {
                    $leap_format_audio_embed = get_post_meta( get_the_ID(), '_format_audio_embed', true );
                    $format_content          = do_shortcode( $leap_format_audio_embed );
                    if ( $format_content ) {
                        echo '<div class="entry-head"><div class="post-audio">' . $format_content . '</div></div>';
                    }
                    // Video
                } elseif ( get_post_format() == 'video' ) {
                    $leap_format_video_embed = get_post_meta( get_the_ID(), '_format_video_embed', true );
                    $format_content          = do_shortcode( $leap_format_video_embed );
                    if ( $format_content ) {
                        echo '<div class="entry-head"><div class="post-video">' . $format_content . '</div></div>';
                    }
                    // Gallery
                } elseif ( get_post_format() == 'gallery' ) {
                    $leap_format_gallery = get_post_meta( get_the_ID(), '_format_gallery', true );
                    $format_content      = do_shortcode( $leap_format_gallery );
                    if ( $format_content ) {
                        echo '<div class="entry-head"><div class="post-gallery">' . $format_content . '</div></div>';
                    }
                    // Link
                } elseif ( get_post_format() == 'link' ) {
                    $leap_format_link_title = esc_html( get_post_meta( get_the_ID(), '_format_link_title', true ) );
                    $leap_format_link_url   = esc_url( get_post_meta( get_the_ID(), '_format_link_url', true ) );
                    if ( $leap_format_link_title && $leap_format_link_url ) {
                        echo '<div class="entry-head"><div class="post-link"><h5><i class="fa fa-link"></i> ' . esc_html__( 'Visit URL:', 'wiz' ) . ' <a target="_blank" href="' . $leap_format_link_url . '">' . $leap_format_link_title . '</a></h5></div></div>';
                    }
                    // Quote
                } elseif ( get_post_format() == 'quote' ) {
                    $leap_format_quote = get_post_meta( get_the_ID(), '_format_quote', true );
                    $format_content    = do_shortcode( $leap_format_quote );
                    if ( $format_content ) {
                        echo '<div class="entry-head"><div class="post-quote">' . $format_content . '</div></div>';
                    }
                    // Others
                } else {
                    if ( has_post_thumbnail() ) {
                        $large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'large' );

                        $blog_image_size = 'leap-portfolio-1col';

                        if ( $blog_layout == 'grid' ) {
                            //$blog_image_size = array(567, 'auto');
                            $blog_image_size = 'leap-portfolio-grid';
                        } elseif ( $blog_layout == 'large' ) {
                            $blog_image_size = 'leap-portfolio-1col';
                        } elseif ( $blog_layout == 'postformat' ) {
                            $blog_image_size = 'leap-portfolio-1col';
                        } elseif ( $blog_layout == 'small' ) {
                            $blog_image_size = 'leap-portfolio-2col';
                        }
                        ?>
                        <div class="entry-head">				
                            <div class="post-img">
                                <div class="leap-overlay item-img">
                                    <?php echo get_the_post_thumbnail( get_the_ID(), $blog_image_size ); ?>
                                    <div class="item-overlay">
                                        <div class="item-img-color"></div>
                                        <div class="item-details">
                                            <div class="item-links">
                                                <a class="item-link" href="<?php the_permalink() ?>" title="<?php the_title_attribute(); ?>"><?php esc_html_e( 'Link', 'wiz' ) ?></a>
                                                <a class="enlarge" data-rel="prettyPhoto" href="<?php echo $large_image_url[ 0 ]; ?>" title="<?php the_title_attribute(); ?>">
                                                    <?php echo __( 'Enlarge', 'wiz' ); ?>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php
                    }
                }
            }
            ?>

            <?php //Post title    ?>
            <div class="entry-info">
                <?php if ( $blog_layout == 'postformat' ) { ?>
                    <?php
                    if ( get_post_format() == 'audio' ) {
                        $post_format_class = 'audio';
                    } elseif ( get_post_format() == 'video' ) {
                        $post_format_class = 'video';
                    } elseif ( get_post_format() == 'aside' ) {
                        $post_format_class = 'aside';
                    } elseif ( get_post_format() == 'chat' ) {
                        $post_format_class = 'chat';
                    } elseif ( get_post_format() == 'gallery' ) {
                        $post_format_class = 'gallery';
                    } elseif ( get_post_format() == 'image' ) {
                        $post_format_class = 'image';
                    } elseif ( get_post_format() == 'link' ) {
                        $post_format_class = 'links';
                    } elseif ( get_post_format() == 'quote' ) {
                        $post_format_class = 'quote';
                    } elseif ( get_post_format() == 'status' ) {
                        $post_format_class = 'status';
                    } else {
                        $post_format_class = 'standard';
                    }
                    ?>
                    <div class="post-icon"><a class="dashicons dashicons-format-<?php echo $post_format_class; ?>" title="<?php get_post_format_string( get_post_format() ); ?>" href="<?php echo esc_url( get_post_format_link( get_post_format() ) ); ?>"></a></div>

                <?php } ?>

                <?php
                the_title( sprintf( '<h2 class="entry-title" itemprop="headline" title="%s"><a href="%s">', esc_html( get_the_title() ), esc_url( get_permalink() ) ), '</a></h2>' )
                ?>

                <div class="entry-meta">
                    <?php leap_entry_meta( $meta_settings ); ?>
                </div>
            </div>
        </div>

        <div class="entry-content">

            <?php
            //Featured image 
            if ( ($blog_layout == 'classic') && !post_password_required() ) {
                // Audio
                if ( get_post_format() == 'audio' ) {
                    $leap_format_audio_embed = get_post_meta( get_the_ID(), '_format_audio_embed', true );
                    $format_content          = do_shortcode( $leap_format_audio_embed );
                    if ( $format_content ) {
                        echo '<div class="post-format post-audio">' . $format_content . '</div>';
                    }
                    // Video
                } elseif ( get_post_format() == 'video' ) {
                    $leap_format_video_embed = get_post_meta( get_the_ID(), '_format_video_embed', true );
                    $format_content          = do_shortcode( $leap_format_video_embed );
                    if ( $format_content ) {
                        echo '<div class="post-format post-video">' . $format_content . '</div>';
                    }
                    // Gallery
                } elseif ( get_post_format() == 'gallery' ) {
                    $leap_format_gallery = get_post_meta( get_the_ID(), '_format_gallery', true );
                    $format_content      = do_shortcode( $leap_format_gallery );
                    if ( $format_content ) {
                        echo '<div class="post-format post-gallery">' . $format_content . '</div>';
                    }
                    // Link
                } elseif ( get_post_format() == 'link' ) {
                    $leap_format_link_title = esc_html( get_post_meta( get_the_ID(), '_format_link_title', true ) );
                    $leap_format_link_url   = esc_url( get_post_meta( get_the_ID(), '_format_link_url', true ) );
                    if ( $leap_format_link_title && $leap_format_link_url ) {
                        echo '<div class="post-format post-link"><h5><i class="fa fa-link"></i> ' . esc_html__( 'Visit URL:', 'wiz' ) . ' <a target="_blank" href="' . $leap_format_link_url . '">' . $leap_format_link_title . '</a></h5></div>';
                    }
                    // Quote
                } elseif ( get_post_format() == 'quote' ) {
                    $leap_format_quote = get_post_meta( get_the_ID(), '_format_quote', true );
                    $format_content    = do_shortcode( $leap_format_quote );
                    if ( $format_content ) {
                        echo '<div class="post-format post-quote">' . $format_content . '</div>';
                    }
                    // Standard
                } else {
                    if ( has_post_thumbnail() ) {
                        $large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'large' );
                        ?>
                        <div class="post-format post-img">
                            <div class="leap-overlay item-img">
                                <?php echo get_the_post_thumbnail( get_the_ID(), 'leap-portfolio-cat' ); ?>
                                <div class="item-overlay">
                                    <div class="item-img-color"></div>
                                    <div class="item-details">
                                        <div class="item-links">
                                            <a class="item-link" href="<?php the_permalink() ?>" title="<?php the_title_attribute(); ?>"><?php esc_html_e( 'Link', 'wiz' ) ?></a>
                                            <a class="enlarge" data-rel="prettyPhoto[posts_gal]" href="<?php echo $large_image_url[ 0 ]; ?>" title="<?php the_title_attribute(); ?>">
                                                <?php echo __( 'Enlarge', 'wiz' ); ?>
                                            </a>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                        <?php
                    }
                }
            }
            ?>
            <?php if ( leap_get_the_content() ) { ?>
                <div class="post-content">
                    <?php
                    if ( ot_get_option( 'search_display_format' ) == 'excerpt' ) {
                        echo leap_get_the_excerpt();
                    } else {
                        the_content( '<span>' . __( 'Read More', 'wiz' ) . '</span>' );
                        wp_link_pages( array(
                            'before'         => '<div class="pagination pagination-page"><strong>' . esc_html__( 'Pages', 'wiz' ) . ':</strong><ul class="clearfix">',
                            'after'          => '</ul></div>',
                            'next_or_number' => 'number',
                            'link_before'    => '<span>',
                            'link_after'     => '</span>'
                        ) );
                    }
                    ?>
                </div>
            <?php } ?>
        </div>

        <div class="entry-footer">
            <?php
            if ( in_array( 'tags', $meta_settings ) ) {
                $tag_list = get_the_tag_list( '', __( ', ', 'wiz' ) );
                if ( $tag_list ) {
                    echo '<small class="entry-tags small"><i class="fa fa-tags"></i> ' . __( 'Tags', 'wiz' ) . ': ' . $tag_list . '</small>';
                }
            }
            ?>
        </div>

    </div>
</div>