<?php do_action( 'leap_before_html_start_tag' ); ?>
<!DOCTYPE html>
<html class="no-js" <?php language_attributes(); ?> <?php leap_print_schema_org(); ?>>

    <head>
        <?php do_action( 'leap_after_head_start_tag' ); ?>
        <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
        <?php if ( ot_get_option( 'disable_responsive', 'no' ) == 'no' ) { ?>
            <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
        <?php } ?>
        <meta charset="<?php bloginfo( 'charset' ); ?>" />
        <!-- icons & favicons -->
        <?php if ( ot_get_option( 'favicon', '' ) ): ?>
            <link rel="shortcut icon" href="<?php echo esc_url( ot_get_option( 'favicon' ) ); ?>" type="image/x-icon" />
        <?php endif; ?>

        <?php if ( ot_get_option( 'iphone_icon', '' ) ): ?>
            <!-- For iPhone -->
            <link rel="apple-touch-icon-precomposed" href="<?php echo esc_url( ot_get_option( 'iphone_icon' ) ); ?>">
        <?php endif; ?>

        <?php if ( ot_get_option( 'iphone_icon_retina', '' ) ): ?>
            <!-- For iPhone 4 Retina display -->
            <link rel="apple-touch-icon-precomposed" sizes="114x114" href="<?php echo esc_url( ot_get_option( 'iphone_icon_retina' ) ); ?>">
        <?php endif; ?>

        <?php if ( ot_get_option( 'ipad_icon', '' ) ): ?>
            <!-- For iPad -->
            <link rel="apple-touch-icon-precomposed" sizes="72x72" href="<?php echo esc_url( ot_get_option( 'ipad_icon' ) ); ?>">
        <?php endif; ?>

        <?php if ( ot_get_option( 'ipad_icon_retina', '' ) ): ?>
            <!-- For iPad Retina display -->
            <link rel="apple-touch-icon-precomposed" sizes="144x144" href="<?php echo esc_url( ot_get_option( 'ipad_icon_retina' ) ); ?>">
        <?php endif; ?>

        <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />

        <?php wp_head(); ?>

    </head>

    <body <?php body_class(); ?>>

        <?php do_action( 'leap_after_body_start_tag' ); ?>
        <?php $header_layout = leap_get_option_with_default( 'header_layout', 'leap_header_layout' ); ?>
        <?php if ( $header_layout == 'header10' ) : ?>
            <?php get_template_part( 'includes/headers/header', '10' ); ?>
        <?php elseif ( $header_layout == 'header11' ) : ?>
            <?php get_template_part( 'includes/headers/header', '11' ); ?>
        <?php elseif ( $header_layout == 'header12' ) : ?>
            <?php get_template_part( 'includes/headers/header', '12' ); ?>
        <?php elseif ( $header_layout == 'header13' ) : ?>
            <?php get_template_part( 'includes/headers/header', '13' ); ?>
        <?php elseif ( $header_layout == 'header14' ) : ?>
            <?php get_template_part( 'includes/headers/header', '14' ); ?>
        <?php elseif ( $header_layout == 'header15' ) : ?>
            <?php get_template_part( 'includes/headers/header', '15' ); ?>
        <?php elseif ( $header_layout == 'header16' ) : ?>
                <?php get_template_part( 'includes/headers/header', '16' ); ?>
        <?php elseif ( $header_layout == 'header17' ) : ?>
                <?php get_template_part( 'includes/headers/header', '17' ); ?>
        <?php endif; ?>


        <div id="leap-wrapper" class="<?php echo leap_get_wrapper_class(); ?>">

            <?php
            // Display slider based on page id
            $slider_position = leap_get_option_with_default( 'slider_position', 'leap_slider_position' );
            if( 'above' == $slider_position && in_array( $header_layout, array('header1', 'header2', 'header3', 'header4', 'header5', 'header6', 'header7', 'header8', 'header9' ) ) ) {
                get_template_part( 'includes/slider' );
            }
            ?>
            
            <?php if ( $header_layout == 'header1' ) : ?>
                <?php get_template_part( 'includes/headers/header', '1' ); ?>
            <?php elseif ( $header_layout == 'header2' ) : ?>
                <?php get_template_part( 'includes/headers/header', '2' ); ?>
            <?php elseif ( $header_layout == 'header3' ) : ?>
                <?php get_template_part( 'includes/headers/header', '3' ); ?>
            <?php elseif ( $header_layout == 'header4' ) : ?>
                <?php get_template_part( 'includes/headers/header', '4' ); ?>
            <?php elseif ( $header_layout == 'header5' ) : ?>
                <?php get_template_part( 'includes/headers/header', '5' ); ?>
            <?php elseif ( $header_layout == 'header6' ) : ?>
                <?php get_template_part( 'includes/headers/header', '6' ); ?>
            <?php elseif ( $header_layout == 'header7' ) : ?>
                <?php get_template_part( 'includes/headers/header', '7' ); ?>
            <?php elseif ( $header_layout == 'header8' ) : ?>
                <?php get_template_part( 'includes/headers/header', '8' ); ?>
            <?php elseif ( $header_layout == 'header9' ) : ?>
                <?php get_template_part( 'includes/headers/header', '9' ); ?>
            <?php endif; ?>

            <?php
            // Display slider based on page id
            if ( ('below' == $slider_position && in_array( $header_layout, array( 'header1', 'header2', 'header3', 'header4', 'header5', 'header6', 'header7', 'header8', 'header9' ) )) || in_array( $header_layout, array( 'header10', 'header11', 'header12', 'header13', 'header14', 'header15', 'header16', 'header17' ) ) ) {
                get_template_part( 'includes/slider' );
            }
            ?>

            <?php
            // Header widget position
            get_template_part( 'includes/sidebar/header' );
            ?>

            <?php
            // Page Title
            $page_title_layout = ot_get_option( 'page_title_layout', 'title1' );
            ?>
            <?php if ( $page_title_layout == 'title1' ) : ?>
                <?php get_template_part( 'includes/titles/title', '1' ); ?>
            <?php elseif ( $page_title_layout == 'title2' ) : ?>
                <?php get_template_part( 'includes/titles/title', '2' ); ?>
            <?php elseif ( $page_title_layout == 'title3' ) : ?>
                <?php get_template_part( 'includes/titles/title', '3' ); ?>
            <?php endif; ?>

            <?php
            // Display Google map on contact page
            if ( (ot_get_option( 'display_google_map', 'off' ) == 'on') && is_page_template( 'page-contact-template.php' ) ) :
                ?>
                <div class="leap-contact-map">
                    <?php
                    $google_map_width      = ot_get_option( 'google_map_width', array( '100', '%' ) );
                    $google_map_width_unit = (!empty( $google_map_width[ 1 ] )) ? $google_map_width[ 1 ] : 'px';

                    $google_map_height      = ot_get_option( 'google_map_height', array( '350', 'px' ) );
                    $google_map_height_unit = (!empty( $google_map_height[ 1 ] )) ? $google_map_height[ 1 ] : 'px';

                    echo do_shortcode( '[leap_google_map width="' . $google_map_width[ 0 ] . $google_map_width_unit . '" height="' . $google_map_height[ 0 ] . $google_map_height_unit . '" lat="' . esc_attr( ot_get_option( 'google_map_lat', '' ) ) . '" lng="' . esc_attr( ot_get_option( 'google_map_lng', '' ) ) . '" zoom="' . absint( ot_get_option( 'google_map_zoom', '13' ) ) . '" map_type="' . esc_attr( ot_get_option( 'google_map_type', 'roadmap' ) ) . '" title="' . esc_attr( ot_get_option( 'info_box_title', '' ) ) . '"]' . ot_get_option( 'info_box_content', '' ) . '[/leap_google_map]' );
                    ?>
                </div>
            <?php endif; ?>


            <?php
            // Main Top widget position
            get_template_part( 'includes/sidebar/main-top' );
            ?>

            <?php
            // Main Top widget position
            get_template_part( 'includes/sidebar/header-full-width' );
            ?>

            <div id="leap-content">
                <?php
                // Main Content Top widget position
                get_template_part( 'includes/sidebar/main-content-top' );
                ?>

                <div id="content" class="sidebar-<?php echo leap_sidebar_position(); ?>">
                    <?php
                    $page_id              = leap_get_current_page_id();
                    $leap_container_class = apply_filters( 'leap_container_class', 'container-fluid' );
                    if ( is_page() && (get_page_template_slug( $page_id ) == 'page-100-width-template.php') ) {
                        $leap_container_class = 'page-full-width';
                    }
                    ?>
                    <div class="<?php echo $leap_container_class; ?>">
                        <div class="row">
