<?php
if ( !defined( 'ABSPATH' ) ) {
    die( 'No direct access allowed' );
}

/**
 * Woocommerce Action and Filter reference
 * http://docs.woothemes.com/document/hooks/
 */
global $yith_wcwl;
global $yith_woocompare;


// Remove woocommerce default styles to use theme styles
add_filter( 'woocommerce_enqueue_styles', '__return_false' );

// Remove woocommerce page title
add_filter( 'woocommerce_show_page_title', '__return_false' );

remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0 );
remove_action( 'woocommerce_sidebar', 'woocommerce_get_sidebar', 10 );
add_theme_support( 'wc-product-gallery-zoom' );
add_theme_support( 'wc-product-gallery-lightbox' );
add_theme_support( 'wc-product-gallery-slider' );


/**
 * Set breadcrumbs for woocommerce
 * @return array
 */
function leap_woocommerce_breadcrumb_defaults() {
    return array(
        'delimiter'   => '<span class="crumbs-delimiter">' . ot_get_option( 'delimiter', __( '&raquo;', 'wiz' ) ) . '</span>',
        'wrap_before' => '',
        'wrap_after'  => '',
        'before'      => '<span>',
        'after'       => '</span>',
        'home'        => '',
    );
}

add_filter( 'woocommerce_breadcrumb_defaults', 'leap_woocommerce_breadcrumb_defaults', 10 );

/**
 * Set woocommerce catalog image size
 * @param array $size
 * @return array
 */
function leap_wc_get_image_size_shop_catalog( $size ) {
    $size = array(
        'width'  => '400',
        'height' => '629',
        'crop'   => 1
    );
    return $size;
}

add_filter( 'woocommerce_get_image_size_shop_catalog', 'leap_wc_get_image_size_shop_catalog', 10, 1 );

/**
 * Set woocommerce single image size
 * @param array $size
 * @return array
 */
function leap_wc_get_image_size_shop_single( $size ) {
    $size = array(
        'width'  => '400',
        'height' => '629',
        'crop'   => 1
    );
    return $size;
}

add_filter( 'woocommerce_get_image_size_shop_single', 'leap_wc_get_image_size_shop_single', 10, 1 );

/**
 * Set woocommerce thumbnail image size
 * @param array $size
 * @return array
 */
function leap_wc_get_image_size_shop_thumbnail( $size ) {
    $size = array(
        'width'  => '90',
        'height' => '90',
        'crop'   => 1
    );
    return $size;
}

add_filter( 'woocommerce_get_image_size_shop_thumbnail', 'leap_wc_get_image_size_shop_thumbnail', 10, 1 );

/**
 * Get woocommerce columns number
 * @return int
 */
function leap_loop_columns() {
    if ( is_woocommerce() ) {
        $page_id = get_option( 'woocommerce_shop_page_id' );
    } else {
        $page_id = leap_get_current_page_id();
    }
    if ( leap_sidebar_position( $page_id ) == 'full' ) {
        return 4;
    } else {
        return 3;
    }
}

add_filter( 'loop_shop_columns', 'leap_loop_columns', 10 );

/**
 * Display cart icon on main menu
 * @global type $woocommerce
 * @param string $items
 * @param array $args
 * @return string
 */
function leap_cart_menu_item( $items, $args ) {
    if ( ot_get_option( 'display_cart_icon_on_main_menu' ) == 'on' ) {
        if ( $args->theme_location == 'main-menu' ) {
            global $woocommerce;
            $cart_url  = $woocommerce->cart->get_cart_url();
            $cart_icon = '<li class="menu-item menu-item-cart menu-item-no-megamenu"><a href="' . $cart_url . '"><i class="fa fa-shopping-cart"></i><span class="menu-item-cart-label">' . __( "Cart", "wiz" ) . '</span></a>
		<ul class="sub-menu">
			<li>
				<div class="widget_shopping_cart_content"></div>
			</li>
		</ul>
		</li>';
            $items     = $items . $cart_icon;
        }
    }
    return $items;
}

add_filter( 'wp_nav_menu_items', 'leap_cart_menu_item', 10, 2 );


// Add default wrappers

/**
 * woocommerce before main conten
 */
function leap_wrapper_start() {
    $page_id = get_option( 'woocommerce_shop_page_id' );
    if ( leap_sidebar_position( $page_id ) != 'full' ) {
        $col = leap_bws_col_class( 9 );
    } else {
        $col = leap_bws_col_class( 12 );
    }
    echo '<div id="main" class="' . $col . '">';
}

/**
 * woocommerce after main conten
 */
function leap_wrapper_end() {
    echo '</div>';
}

remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10 );
remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10 );
add_action( 'woocommerce_before_main_content', 'leap_wrapper_start', 10 );
add_action( 'woocommerce_after_main_content', 'leap_wrapper_end', 10 );

/**
 * shop Lisiting
 */

/**
 * Display Product thumbnail
 */
function leap_woocommerce_thumbnail() {
    global $product, $woocommerce;

    $items_in_cart = array();

    if ( $woocommerce->cart->get_cart() && is_array( $woocommerce->cart->get_cart() ) ) {
        foreach ( $woocommerce->cart->get_cart() as $cart ) {
            $items_in_cart[] = $cart[ 'product_id' ];
        }
    }

    $id      = get_the_ID();
    $in_cart = in_array( $id, $items_in_cart );
    $size    = 'shop_catalog';

    $gallery          = get_post_meta( $id, '_product_image_gallery', true );
    $attachment_image = '';
    if ( !empty( $gallery ) ) {
        $gallery          = explode( ',', $gallery );
        $first_image_id   = $gallery[ 0 ];
        $attachment_image = wp_get_attachment_image( $first_image_id, $size, false, array( 'class' => 'hover-image' ) );
    }

    if ( has_post_thumbnail() ) {
        $thumb_image = get_the_post_thumbnail( $id, $size );
    } else {
        $thumb_image = wc_placeholder_img( $size );
    }

    if ( $attachment_image ) {
        $classes = 'product-img thumbnail-gallery';
    } else {
        $classes = 'product-img';
    }

    echo '<span class="' . $classes . '">';
    echo $attachment_image;
    echo $thumb_image;
    if ( $in_cart ) {
        echo '<span class="cart-loading"><i class="fa fa-check-square-o"></i></span>';
    } else {
        echo '<span class="cart-loading"><i class="fa fa-spinner fa-spin"></i></span>';
    }
    echo '</span>';
}

remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10 );
add_action( 'woocommerce_before_shop_loop_item_title', 'leap_woocommerce_thumbnail', 10 );

/**
 * woocommerce before shop loop item
 * @param string $content
 */
function leap_woocommerce_before_shop_loop_item( $content ) {
    $content = '<div class="product-container">' . $content;
    echo $content;
}

add_action( 'woocommerce_before_shop_loop_item', 'leap_woocommerce_before_shop_loop_item', 5 );

/**
 * Begin product list details
 * @param string $content
 */
function leap_begin_product_list_details( $content ) {
    $content = '<div class="product-list-details">' . $content;
    echo $content;
}

add_action( 'woocommerce_before_shop_loop_item', 'leap_begin_product_list_details', 10 );

/**
 * Begin price rate
 * @param string $content
 */
function leap_begin_price_rate( $content ) {
    $content .= '<div class="product-price-rate">';
    echo $content;
}

add_action( 'woocommerce_after_shop_loop_item_title', 'leap_begin_price_rate', 4 );

remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10 );
remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5 );
add_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 5 );
add_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 10 );

/**
 * End price rate
 * @param string $content
 */
function leap_end_price_rate( $content ) {
    $content .= '</div>';
    echo $content;
}

add_action( 'woocommerce_after_shop_loop_item_title', 'leap_end_price_rate', 15 );

/**
 * End product list details
 * @param string $content
 */
function leap_end_product_list_details( $content ) {
    $content = '</div>' . $content;
    echo $content;
}

add_action( 'woocommerce_after_shop_loop_item', 'leap_end_product_list_details', 5 );


if ( isset( $yith_woocompare ) ) {
    remove_action( 'woocommerce_after_shop_loop_item', array( $yith_woocompare->obj, 'add_compare_link' ), 20 );
}

/**
 * woocommerce after shop loop item begin product hover
 * @param string $content
 */
function leap_woocommerce_after_shop_loop_item_begin_product_hover( $content ) {
    $content .= '<div class="product-list-hover">';
    echo $content;
}

add_action( 'woocommerce_after_shop_loop_item', 'leap_woocommerce_after_shop_loop_item_begin_product_hover', 10 );

remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );
add_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 15 );

/**
 * Before compare & wishlist
 * @param string $content
 */
function leap_before_compare_wishlist( $content ) {
    $content .= '<div class="product-list-buttons">';
    echo $content;
}

add_action( 'woocommerce_after_shop_loop_item', 'leap_before_compare_wishlist', 19 );

/**
 * wishlist button label
 * @return string
 */
function leap_yith_wcwl_button_label() {
    return __( 'Wishlist', 'wiz' );
}

add_filter( 'yith_wcwl_button_label', 'leap_yith_wcwl_button_label', 10 );

/**
 * browse wishlist label
 * @return string
 */
function leap_yith_browse_wishlist_label() {
    return '';
}

add_filter( 'yith-wcwl-browse-wishlist-label', 'leap_yith_browse_wishlist_label', 10 );

/**
 * replace wishlist translated text
 * @param string $translated_text
 * @param string $untranslated_text
 * @param string $domain
 * @return string
 */
function leap_wishlist_translate( $translated_text, $untranslated_text, $domain ) {
    if ( $domain == 'yit' ) {
        switch ( $translated_text ) {
            case 'Product added!' :
                $translated_text = __( 'Added', 'wiz' );
                break;
            case 'Compare' :
                $translated_text = __( 'Compare', 'wiz' );
                break;
        }
    }
    return $translated_text;
}

add_filter( 'gettext', 'leap_wishlist_translate', 20, 3 );

/**
 * after compare & wishlist
 * @param string $content
 */
function leap_after_compare_wishlist( $content ) {
    $content .= '</div>';
    echo $content;
}

add_action( 'woocommerce_after_shop_loop_item', 'leap_after_compare_wishlist', 26 );

/**
 * woocommerce_after_shop_loop_item
 * @param string $content
 */
function leap_woocommerce_after_shop_loop_item( $content ) {
    $content .= '</div>';
    echo $content;
}

add_action( 'woocommerce_after_shop_loop_item', 'leap_woocommerce_after_shop_loop_item', 30 );

// Product List buttons

/**
 * start_has_wishlist_compare
 */
function leap_start_has_wishlist_compare() {
    echo '<div class="has-wishlist-compare">';
}

/**
 * start_has_compare
 */
function leap_start_has_compare() {
    echo '<div class="has-compare">';
}

/**
 * start_has_wishlist
 */
function leap_start_has_wishlist() {
    echo '<div class="has-wishlist">';
}

/**
 * start_has_product_details
 */
function leap_start_has_product_details() {
    echo '<div class="has-details">';
}

/**
 * end_product_list_buttons
 */
function leap_end_product_list_buttons() {
    echo '</div>';
}

/**
 * get_product_url
 */
function leap_get_product_url() {
    global $product;
    echo '<a class="product-details-link" href="' . get_permalink( $product->get_id() ) . '">' . __( 'Details', 'wiz' ) . '</a>';
}

if ( isset( $yith_woocompare ) && isset( $yith_wcwl ) ) {
    add_action( 'woocommerce_after_shop_loop_item', 'leap_start_has_wishlist_compare', 19 );
    add_action( 'woocommerce_after_shop_loop_item', array( $yith_woocompare->obj, 'add_compare_link' ), 20 );
    add_action( 'woocommerce_after_shop_loop_item', 'leap_add_wishlist_link', 25 );
    add_action( 'woocommerce_after_shop_loop_item', 'leap_end_product_list_buttons', 26 );
} elseif ( isset( $yith_woocompare ) ) {
    add_action( 'woocommerce_after_shop_loop_item', 'leap_start_has_compare', 19 );
    add_action( 'woocommerce_after_shop_loop_item', array( $yith_woocompare->obj, 'add_compare_link' ), 20 );
    add_action( 'woocommerce_after_shop_loop_item', 'leap_get_product_url', 25 );
    add_action( 'woocommerce_after_shop_loop_item', 'leap_end_product_list_buttons', 26 );
} elseif ( isset( $yith_wcwl ) ) {
    add_action( 'woocommerce_after_shop_loop_item', 'leap_start_has_wishlist', 19 );
    add_action( 'woocommerce_after_shop_loop_item', 'leap_get_product_url', 20 );
    add_action( 'woocommerce_after_shop_loop_item', 'leap_add_wishlist_link', 25 );
    add_action( 'woocommerce_after_shop_loop_item', 'leap_end_product_list_buttons', 26 );
} else {
    add_action( 'woocommerce_after_shop_loop_item', 'leap_start_has_product_details', 19 );
    add_action( 'woocommerce_after_shop_loop_item', 'leap_get_product_url', 20 );
    add_action( 'woocommerce_after_shop_loop_item', 'leap_end_product_list_buttons', 21 );
}



// Product Page

/**
 * woocommerce single title
 */
function leap_woocommerce_template_single_title() {
    ?>
    <h3 itemprop="name" class="product_title entry-title"><?php the_title(); ?></h3>
    <?php
}

remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_title', 5 );
add_action( 'woocommerce_single_product_summary', 'leap_woocommerce_template_single_title', 5 );

/**
 * before single product buttons
 */
function leap_before_product_buttons() {
    echo '<div class="product-buttons">';
}

add_action( 'woocommerce_single_product_summary', 'leap_before_product_buttons', 30 );

/**
 * Display add to wishlist link
 * @param type $content
 */
function leap_add_wishlist_link( $content ) {
    global $product, $yith_wcwl;

    if ( isset( $yith_wcwl ) ) {

        $url = $yith_wcwl->get_wishlist_url();

        $content .= '<div class="leap-yith-wcwl-add-to-wishlist">';
        //$content .= '<i class="fa fa-heart-o"></i>';
        if ( $yith_wcwl->is_product_in_wishlist( $product->get_id() ) != 1 ) {
            $content .= do_shortcode( '[yith_wcwl_add_to_wishlist]' );
        } else {
            $content .= '<a href="' . esc_url( $url ) . '">' . __( 'Added', 'wiz' ) . '</a>';
        }
        $content .= '</div>';
        echo $content;
    }
}

add_action( 'woocommerce_single_product_summary', 'leap_add_wishlist_link', 31 );

/**
 * after single product buttons
 */
function leap_after_product_buttons() {
    echo '</div>';
}

add_action( 'woocommerce_single_product_summary', 'leap_after_product_buttons', 36 );

/**
 * woocommerce order button html
 * @return string
 */
function leap_woocommerce_order_button_html() {
    $order_button_text = apply_filters( 'woocommerce_order_button_text', __( 'Place order', 'woocommerce' ) );
    return '<input type="submit" class="button alt btn btn-leap btn-large" name="woocommerce_checkout_place_order" id="place_order" value="' . esc_attr( $order_button_text ) . '" data-value="' . esc_attr( $order_button_text ) . '" />';
}

add_filter( 'woocommerce_order_button_html', 'leap_woocommerce_order_button_html' );

/**
 * add to wishlist button html
 * @param string $template
 * @param string $wishlist_url
 * @param string $product_type
 * @param string $exists
 * @return string
 */
function leap_add_to_wishlist_button_html( $template, $wishlist_url,
                                           $product_type, $exists ) {
    $template = '<div class="leap-add-to-wishlist">' . $template . '</div>';
    return $template;
}

add_filter( 'yith_wcwl_add_to_wishlisth_button_html', 'leap_add_to_wishlist_button_html', 10, 4 );

/**
 * before woocommerce table
 */
function leap_before_woocommerce_table() {
    echo '<div class="table-responsive">';
}

/**
 * after woocommerce table
 */
function leap_after_woocommerce_table() {
    echo '</div>';
}

add_action( 'yith_wcwl_before_wishlist', 'leap_before_woocommerce_table' );
add_action( 'yith_wcwl_after_wishlist', 'leap_after_woocommerce_table' );
add_action( 'woocommerce_before_cart_table', 'leap_before_woocommerce_table' );
add_action( 'woocommerce_after_cart_table', 'leap_after_woocommerce_table' );

/**
 * woocommerce payment methods title'
 */
function leap_payment_methods_title() {
    echo '<h3 class="leap_order_payment_methods">' . __( "Payment Methods", "wiz" ) . '</h3>';
}

add_action( 'woocommerce_review_order_before_payment', 'leap_payment_methods_title' );

/**
 * set woocommerce pagination args
 * @return array
 */
function leap_woocommerce_pagination_args() {
    global $wp_query;
    return array(
        'base'      => str_replace( 999999999, '%#%', get_pagenum_link( 999999999 ) ),
        'format'    => '',
        'current'   => max( 1, get_query_var( 'paged' ) ),
        'total'     => $wp_query->max_num_pages,
        'prev_text' => '',
        'next_text' => '',
        'type'      => 'list',
        'end_size'  => 3,
        'mid_size'  => 3
    );
}

add_filter( 'woocommerce_pagination_args', 'leap_woocommerce_pagination_args' );

/**
 * get product search form
 * @return string
 */
function leap_get_product_search_form() {
    return '<form role="search" method="get" action="' . esc_url( home_url( '/' ) ) . '">
            <div>
                    <input type="text" class="form-control" value="' . get_search_query() . '" name="s" id="s" placeholder="' . __( "Search for products", "wiz" ) . '" />
                    <input type="submit" class="btn btn-default btn-leap" value="' . esc_attr__( 'Search', 'wiz' ) . '" />
                    <input type="hidden" name="post_type" value="product" />
            </div>
	</form>';
}

add_filter( 'get_product_search_form', 'leap_get_product_search_form', 10 );

/**
 * set woocommerce comment pagination args
 * @return array
 */
function leap_woocommerce_comment_pagination_args() {
    return array(
        'prev_text' => '',
        'next_text' => '',
        'type'      => 'list',
    );
}

add_filter( 'woocommerce_comment_pagination_args', 'leap_woocommerce_comment_pagination_args', 10 );

/**
 * set Add to wishlist params
 * @param type $additional_params
 * @return type
 */
function leap_yith_wcwl_add_to_wishlist_params( $additional_params ) {
    $additional_params[ 'already_in_wishslist_text' ] = __( 'Added', 'wiz' );
    $additional_params[ 'product_added_text' ]        = __( 'Added', 'wiz' );
    return $additional_params;
}

add_filter( 'yith_wcwl_add_to_wishlist_params', 'leap_yith_wcwl_add_to_wishlist_params', 10, 1 );
