<?php

class Leap_Youtube_Widget extends WP_Widget {

	function __construct() {
		$widget_ops	 = array( 'classname' => 'youtube-widget' );
		$control_ops = array( 'width' => 250, 'height' => 350, 'id_base' => 'youtube-widget' );
		parent::__construct( 'youtube-widget', 'LEAP: Youtube Channel', $widget_ops, $control_ops );
	}

	function widget( $args, $instance ) {
		extract( $args );

		$defaults	 = array( 'title' => __( 'Subscribe to our Channel', 'wiz' ), 'channel_name' => '', 'width' => '300px', 'height' => '105' );
		$instance	 = wp_parse_args( (array) $instance, $defaults );

		$title			 = apply_filters( 'widget_title', $instance[ 'title' ], $instance, $this->id_base );
		$channel_name	 = $instance[ 'channel_name' ];
		$width			 = $instance[ 'width' ];
		$height			 = $instance[ 'height' ];

		echo $before_widget;
		if ( !empty( $title ) ) {
			echo $before_title;
			echo $title;
			echo $after_title;
		}
		//Youtube Widget
			if( ! empty( $instance['channel_name'] ) ){

				wp_enqueue_script( 'leap-google-platform-js', '//apis.google.com/js/platform.js' );

				// Check if it is a channel or a user account
				if ( strpos( $instance['channel_name'], 'UC' ) === 0 ){
					$source = 'channelid';
				}
				else{
					$source = 'channel';
				}


				echo '
					<div class="youtube-box">
						<div class="g-ytsubscribe" data-'.$source.'="' .$instance['channel_name']. '" data-layout="full" data-count="default"></div>
					</div>
				';
			}
		?>
		<?php
		echo $after_widget;
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		$instance[ 'title' ]		 = sanitize_text_field( $new_instance[ 'title' ] );
		$instance[ 'channel_name' ]	 = sanitize_text_field( $new_instance[ 'channel_name' ] );
		$instance[ 'width' ]		 = sanitize_text_field( $new_instance[ 'width' ] );
		$instance[ 'height' ]		 = sanitize_text_field( $new_instance[ 'height' ] );
		return $instance;
	}

	function form( $instance ) {
		$defaults	 = array( 'title' => __( 'Subscribe to our Channel', 'wiz' ), 'channel_name' => '', 'width' => '300px', 'height' => '105' );
		$instance	 = wp_parse_args( (array) $instance, $defaults );
		?>

		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>">Title : </label>
			<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance[ 'title' ]; ?>" class="widefat" type="text" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'channel_name' ); ?>">Channel Name : </label>
			<input id="<?php echo $this->get_field_id( 'channel_name' ); ?>" name="<?php echo $this->get_field_name( 'channel_name' ); ?>" value="<?php echo $instance[ 'channel_name' ]; ?>" class="widefat" type="text" />
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'width' ); ?>">Width:</label>
			<input type="text" class="widefat" style="width: 50px;" id="<?php echo $this->get_field_id( 'width' ); ?>" name="<?php echo $this->get_field_name( 'width' ); ?>" value="<?php echo $instance[ 'width' ]; ?>" />
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'height' ); ?>">Height:</label>
			<input type="text" class="widefat" style="width: 50px;" id="<?php echo $this->get_field_id( 'height' ); ?>" name="<?php echo $this->get_field_name( 'height' ); ?>" value="<?php echo $instance[ 'height' ]; ?>" />
		</p>


		<?php
	}

}

function leap_youtube_widget_box() {
	register_widget( 'Leap_Youtube_Widget' );
}

add_action( 'widgets_init', 'leap_youtube_widget_box' );
