<?php

class Leap_Video_Widget extends WP_Widget {

	function __construct() {
		$widget_ops	 = array( 'classname' => 'video-widget', 'description' => '' );
		$control_ops = array( 'width' => 250, 'height' => 350, 'id_base' => 'video-widget' );
		parent::__construct( 'video-widget', 'LEAP: Video', $widget_ops, $control_ops );
	}

	function widget( $args, $instance ) {
		extract( $args );

		$defaults	 = array( 'title' => __( 'Featured Video', 'wiz' ), 'width' => '100%', 'height' => '210', 'embed_code' => '', 'youtube_video' => '', 'vimeo_video' => '' );
		$instance	 = wp_parse_args( (array) $instance, $defaults );

		$title			 = apply_filters( 'widget_title', $instance[ 'title' ], $instance, $this->id_base );
		$width			 = $instance[ 'width' ];
		$height			 = $instance[ 'height' ];
		$embed_code		 = $instance[ 'embed_code' ];
		$youtube_video	 = $instance[ 'youtube_video' ];
		$vimeo_video	 = $instance[ 'vimeo_video' ];

		echo $before_widget;
		if ( !empty( $title ) ) {
			echo $before_title;
			echo $title;
			echo $after_title;
		}
		?>

		<?php if ( $embed_code ): echo $embed_code ?>

		<?php elseif ( $youtube_video ): ?>
			<iframe width="<?php echo $width; ?>" height="<?php echo $height; ?>" src="http://www.youtube.com/embed/<?php echo $youtube_video ?>?rel=0&wmode=opaque" frameborder="0" allowfullscreen></iframe>
		<?php elseif ( $vimeo_video ): ?>
			<iframe src="http://player.vimeo.com/video/<?php echo $vimeo_video ?>?wmode=opaque" width="<?php echo $width; ?>" height="<?php echo $height; ?>" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>
		<?php endif; ?>



		<?php
		echo $after_widget;
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		$instance[ 'title' ]		 = sanitize_text_field( $new_instance[ 'title' ] );
		$instance[ 'width' ]		 = sanitize_text_field( $new_instance[ 'width' ] );
		$instance[ 'height' ]		 = sanitize_text_field( $new_instance[ 'height' ] );
		$instance[ 'embed_code' ]	 = $new_instance[ 'embed_code' ];
		$instance[ 'youtube_video' ] = sanitize_text_field( $new_instance[ 'youtube_video' ] );
		$instance[ 'vimeo_video' ]	 = sanitize_text_field( $new_instance[ 'vimeo_video' ] );
		return $instance;
	}

	function form( $instance ) {
		$defaults	 = array( 'title' => __( 'Featured Video', 'wiz' ), 'width' => '100%', 'height' => '210', 'embed_code' => '', 'youtube_video' => '', 'vimeo_video' => '' );
		$instance	 = wp_parse_args( (array) $instance, $defaults );
		?>

		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>">Title : </label>
			<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance[ 'title' ]; ?>" class="widefat" type="text" />
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'width' ); ?>">Width:</label>
			<input type="text" class="widefat" style="width: 50px;" id="<?php echo $this->get_field_id( 'width' ); ?>" name="<?php echo $this->get_field_name( 'width' ); ?>" value="<?php echo $instance[ 'width' ]; ?>" />
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'height' ); ?>">Height:</label>
			<input type="text" class="widefat" style="width: 50px;" id="<?php echo $this->get_field_id( 'height' ); ?>" name="<?php echo $this->get_field_name( 'height' ); ?>" value="<?php echo $instance[ 'height' ]; ?>" />
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'embed_code' ); ?>">Embed Code : </label>
			<textarea id="<?php echo $this->get_field_id( 'embed_code' ); ?>" name="<?php echo $this->get_field_name( 'embed_code' ); ?>" class="widefat" ><?php echo $instance[ 'embed_code' ]; ?></textarea>
		</p>
		<em style="display:block; border-bottom:1px solid #CCC; margin-bottom:15px;">OR</em>
		<p>
			<label for="<?php echo $this->get_field_id( 'youtube_video' ); ?>">Youtube Video ID : </label>
			<input id="<?php echo $this->get_field_id( 'youtube_video' ); ?>" name="<?php echo $this->get_field_name( 'youtube_video' ); ?>" value="<?php echo $instance[ 'youtube_video' ]; ?>" class="widefat" type="text" />
			<small>if video url : http://www.youtube.com/watch?v=UjXi6X-moxE  Enter above <strong>UjXi6X-moxE</strong></small>
		</p>
		<em style="display:block; border-bottom:1px solid #CCC; margin-bottom:15px;">OR</em>
		<p>
			<label for="<?php echo $this->get_field_id( 'vimeo_video' ); ?>">Vimeo Video ID : </label>
			<input id="<?php echo $this->get_field_id( 'vimeo_video' ); ?>" name="<?php echo $this->get_field_name( 'vimeo_video' ); ?>" value="<?php echo $instance[ 'vimeo_video' ]; ?>" class="widefat" type="text" />
			<small>if video url : http://vimeo.com/6184227  Enter above <strong>6184227</strong></small>
		</p>


		<?php
	}

}

function leap_video_widget_box() {
	register_widget( 'Leap_Video_Widget' );
}

add_action( 'widgets_init', 'leap_video_widget_box' );
