<?php

class Leap_Text_Html_Widget extends WP_Widget {

	function __construct() {
		$widget_ops	 = array( 'classname' => 'text-html' );
		$control_ops = array( 'width' => 250, 'height' => 350, 'id_base' => 'text-html-widget' );
		parent::__construct( 'text-html-widget', 'LEAP: Text or Html', $widget_ops, $control_ops );
	}

	function widget( $args, $instance ) {
		extract( $args );

		$defaults	 = array(
			'title'		 => __( 'Text', 'wiz' ),
			'center'	 => true,
			'text_code'	 => ''
		);
		$instance	 = wp_parse_args( (array) $instance, $defaults );

		$title		 = apply_filters( 'widget_title', $instance[ 'title' ], $instance, $this->id_base );
		$text_code	 = $instance[ 'text_code' ];

		$center	 = '';
		
		if ( !empty($instance[ 'center' ]) ) {
			$center	 = 'style="text-align:center;"';
		}

		echo $before_widget;
		if ( !empty( $title ) ) {
			echo $before_title;
			echo $title;
			echo $after_title;
		}
		echo '<div ' . $center . '>';
		echo do_shortcode( $text_code ) . '
				</div><div class="clear"></div>';
		echo $after_widget;
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		$instance[ 'title' ]	 = sanitize_text_field( $new_instance[ 'title' ] );
		$instance[ 'text_code' ] = $new_instance[ 'text_code' ];
		$instance[ 'center' ]	 = isset( $new_instance[ 'center' ] );
		return $instance;
	}

	function form( $instance ) {
		$defaults	 = array(
			'title'		 => __( 'Text', 'wiz' ),
			'center'	 => true,
			'text_code'	 => ''
		);
		$instance	 = wp_parse_args( (array) $instance, $defaults );
		?>

		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>">Title : </label>
			<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance[ 'title' ]; ?>" class="widefat" type="text" />
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'center' ); ?>">Center content :</label>
			<input id="<?php echo $this->get_field_id( 'center' ); ?>" name="<?php echo $this->get_field_name( 'center' ); ?>" value="true" <?php if ( $instance[ 'center' ] ) echo 'checked="checked"'; ?> type="checkbox" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'text_code' ); ?>">Text , Shortcodes or Html code : </label>
			<textarea rows="15" id="<?php echo $this->get_field_id( 'text_code' ); ?>" name="<?php echo $this->get_field_name( 'text_code' ); ?>" class="widefat" ><?php echo $instance[ 'text_code' ]; ?></textarea>
		</p>



		<?php
	}

}

function leap_text_html_widget() {
	register_widget( 'Leap_Text_Html_Widget' );
}

add_action( 'widgets_init', 'leap_text_html_widget' );
