<?php

class Leap_Tags_Widget extends WP_Widget {

	function __construct() {
		$widget_ops = array( 'classname' => 'leap_tags', 'description' => 'LEAP: Tags Widget' );

		$control_ops = array( 'id_base' => 'leap-tags-widget' );

		parent::__construct( 'leap-tags-widget', 'LEAP: Tags Widget', $widget_ops, $control_ops );
	}

	function widget( $args, $instance ) {
		extract( $args );

		$defaults	 = array( 'title' => 'Tags', 'number' => 10, 'orderby' => 'name', 'order' => 'ASC', 'exclude' => '', 'include' => '' );
		$instance	 = wp_parse_args( (array) $instance, $defaults );

		$title	 = apply_filters( 'widget_title', $instance[ 'title' ], $instance, $this->id_base );
		$number	 = $instance[ 'number' ];
		$orderby = $instance[ 'orderby' ];
		$order	 = $instance[ 'order' ];

		echo $before_widget;
		if ( !empty( $title ) ) {
			echo $before_title;
			echo $title;
			echo $after_title;
		}


		$tags_args = array(
			// Default is 'name'. Can be name, count, or nothing (will use term_id).
			'orderby'	 => $orderby,
			// Default is ASC. Can use DESC.
			'order'		 => $order,
			// The maximum number of terms to return. Default is empty.
			'number'	 => $number
		);

		$tags		 = get_tags( $tags_args );
		$tags_cloud	 = '<div class="post_tags">';
		foreach ( $tags as $tag ) {
			$tag_link = get_tag_link( $tag->term_id );

			$tags_cloud .= "<a href='{$tag_link}' title='{$tag->count} post' class='tag-link-{$tag->term_id} label tag-{$tag->slug}'>";
			$tags_cloud .= "{$tag->name}</a>";
		}
		$tags_cloud .= '</div>';
		echo $tags_cloud;

		echo $after_widget;
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		$instance[ 'title' ]	 = sanitize_text_field( $new_instance[ 'title' ] );
		$instance[ 'number' ]	 = absint( $new_instance[ 'number' ] );
		$instance[ 'orderby' ]	 = (in_array( $new_instance[ 'orderby' ], array( 'name', 'count' ) )) ? $new_instance[ 'orderby' ] : 'count';
		$instance[ 'order' ]	 = (in_array( $new_instance[ 'order' ], array( 'ASC', 'DESC' ) )) ? $new_instance[ 'order' ] : 'ASC';

		return $instance;
	}

	function form( $instance ) {
		$defaults	 = array( 'title' => 'Tags', 'number' => 10, 'orderby' => 'name', 'order' => 'ASC', 'exclude' => '', 'include' => '' );
		$instance	 = wp_parse_args( (array) $instance, $defaults );
		?>

		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>">Title:</label>
			<input class="widefat" style="width: 216px;" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance[ 'title' ]; ?>" />
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'number' ); ?>">Number:</label>
			<input type="text" class="widefat" style="width: 216px;" id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" value="<?php echo $instance[ 'number' ]; ?>" />
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'orderby' ); ?>">Order By:</label> 
			<select id="<?php echo $this->get_field_id( 'orderby' ); ?>" name="<?php echo $this->get_field_name( 'orderby' ); ?>" class="widefat" style="width:100%;">
				<option value="name" <?php if ( 'name' == $instance[ 'orderby' ] ) echo 'selected="selected"'; ?>>Name</option>
				<option value="count" <?php if ( 'count' == $instance[ 'orderby' ] ) echo 'selected="selected"'; ?>>Count</option>
			</select>
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'order' ); ?>">Order:</label> 
			<select id="<?php echo $this->get_field_id( 'order' ); ?>" name="<?php echo $this->get_field_name( 'order' ); ?>" class="widefat" style="width:100%;">
				<option value="ASC" <?php if ( 'ASC' == $instance[ 'order' ] ) echo 'selected="selected"'; ?>>ASC</option>
				<option value="DESC" <?php if ( 'DESC' == $instance[ 'order' ] ) echo 'selected="selected"'; ?>>DESC</option>
			</select>
		</p>
		<?php
	}

}

function leap_tags_widgets() {
	register_widget( 'Leap_Tags_Widget' );
}

add_action( 'widgets_init', 'leap_tags_widgets' );
