<?php

class Leap_Tabs_Widget extends WP_Widget {

	function __construct() {
		$widget_ops	 = array( 'classname' => 'leap-tabs' );
		$control_ops = array( 'width' => 250, 'height' => 350, 'id_base' => 'leap-tabs-widget' );
		parent::__construct( 'leap-tabs-widget', 'LEAP: Tabs', $widget_ops, $control_ops );
	}

	function widget( $args, $instance ) {
		extract( $args );
		
		$defaults	 = array(
			'popular'		 => 'true',
			'popular_label'	 => __( 'Popular', 'wiz' ),
			'popular_num'	 => '5',
			'popular_order'	 => '1',
			'recent'		 => 'true',
			'recent_label'	 => __( 'Recent', 'wiz' ),
			'recent_num'	 => '5',
			'recent_order'	 => '2',
			'random'		 => 'true',
			'random_label'	 => __( 'Random', 'wiz' ),
			'random_num'	 => '5',
			'random_order'	 => '3',
			'comment'		 => 'true',
			'comment_label'	 => __( 'Comments', 'wiz' ),
			'comment_num'	 => '5',
			'comment_order'	 => '4',
			'tags'			 => 'true',
			'tags_label'	 => __( 'Tags', 'wiz' ),
			'tags_num'		 => '5',
			'tags_order'	 => '5',
		);
		$instance	 = wp_parse_args( (array) $instance, $defaults );

		$tabs	 = array();
		$tabs[]	 = array(
			'type'	 => 'popular',
			'active' => $instance[ 'popular' ],
			'label'	 => $instance[ 'popular_label' ],
			'num'	 => $instance[ 'popular_num' ],
			'order'	 => $instance[ 'popular_order' ],
		);

		$tabs[] = array(
			'type'	 => 'recent',
			'active' => $instance[ 'recent' ],
			'label'	 => $instance[ 'recent_label' ],
			'num'	 => $instance[ 'recent_num' ],
			'order'	 => $instance[ 'recent_order' ],
		);

		$tabs[] = array(
			'type'	 => 'random',
			'active' => $instance[ 'random' ],
			'label'	 => $instance[ 'random_label' ],
			'num'	 => $instance[ 'random_num' ],
			'order'	 => $instance[ 'random_order' ],
		);

		$tabs[]	 = array(
			'type'	 => 'comment',
			'active' => $instance[ 'comment' ],
			'label'	 => $instance[ 'comment_label' ],
			'num'	 => $instance[ 'comment_num' ],
			'order'	 => $instance[ 'comment_order' ],
		);
		$tabs[]	 = array(
			'type'	 => 'tags',
			'active' => $instance[ 'tags' ],
			'label'	 => $instance[ 'tags_label' ],
			'num'	 => $instance[ 'tags_num' ],
			'order'	 => $instance[ 'tags_order' ],
		);

		// Sort tabs by order
		// http://stackoverflow.com/a/4508842/1794834
		$order = array();
		foreach ( $tabs as $key => $row ) {
			$order[ $key ] = $row[ 'order' ];
		}
		array_multisort( $order, SORT_ASC, $tabs );
        
		echo $before_widget;
		?>
		<div class="leap-sc-tabs horizontal style-1">
			<ul class="leap-tabs-titles">
				<?php
				foreach ( $tabs as $tab ) {
					if ( $tab[ 'active' ] == true ) {
						echo '<li><a href="#">' . $tab[ 'label' ] . '</a></li>';
					}
				}
				?>
			</ul>

			<?php
			foreach ( $tabs as $tab ) {
				if ( $tab[ 'active' ] == true ) {
					echo '<div id="">';

					if ( $tab[ 'type' ] == 'popular' )
						$this->wp_popular_posts( $tab[ 'num' ], true );
					elseif ( $tab[ 'type' ] == 'recent' )
						$this->wp_last_posts( $tab[ 'num' ], true );
					elseif ( $tab[ 'type' ] == 'random' )
						$this->wp_random_posts( $tab[ 'num' ], true );
					elseif ( $tab[ 'type' ] == 'comment' )
						$this->get_recent_commented( $tab[ 'num' ], 50 );
					elseif ( $tab[ 'type' ] == 'tags' )
						$this->get_popular_tags( $tab[ 'num' ], 50 );

					echo '</div>';
				}
			}
			?>

		</div>

		<?php
		echo $after_widget;
	}

	function update( $new_instance, $old_instance ) {
		$instance					 = $old_instance;
		
		$instance[ 'popular' ]		 = isset( $new_instance[ 'popular' ] );
		$instance[ 'popular_label' ] = sanitize_text_field( $new_instance[ 'popular_label' ] );
		$instance[ 'popular_num' ]	 = absint( $new_instance[ 'popular_num' ] );
		$instance[ 'popular_order' ] = absint( $new_instance[ 'popular_order' ] );

		$instance[ 'recent' ]		 = isset( $new_instance[ 'recent' ] );
		$instance[ 'recent_label' ]	 = sanitize_text_field( $new_instance[ 'recent_label' ] );
		$instance[ 'recent_num' ]	 = absint( $new_instance[ 'recent_num' ] );
		$instance[ 'recent_order' ]	 = absint( $new_instance[ 'recent_order' ] );

		$instance[ 'random' ]		 = isset( $new_instance[ 'random' ] );
		$instance[ 'random_label' ]	 = sanitize_text_field( $new_instance[ 'random_label' ] );
		$instance[ 'random_num' ]	 = absint( $new_instance[ 'random_num' ] );
		$instance[ 'random_order' ]	 = absint( $new_instance[ 'random_order' ] );

		$instance[ 'comment' ]		 = isset( $new_instance[ 'comment' ] );
		$instance[ 'comment_label' ] = sanitize_text_field( $new_instance[ 'comment_label' ] );
		$instance[ 'comment_num' ]	 = absint( $new_instance[ 'comment_num' ] );
		$instance[ 'comment_order' ] = absint( $new_instance[ 'comment_order' ] );

		$instance[ 'tags' ]			 = isset( $new_instance[ 'tags' ] );
		$instance[ 'tags_label' ]	 = sanitize_text_field( $new_instance[ 'tags_label' ] );
		$instance[ 'tags_num' ]		 = absint( $new_instance[ 'tags_num' ] );
		$instance[ 'tags_order' ]	 = absint( $new_instance[ 'tags_order' ] );
		return $instance;
	}

	function form( $instance ) {
		$defaults	 = array(
			'popular'		 => 'true',
			'popular_label'	 => __( 'Popular', 'wiz' ),
			'popular_num'	 => '5',
			'popular_order'	 => '1',
			'recent'		 => 'true',
			'recent_label'	 => __( 'Recent', 'wiz' ),
			'recent_num'	 => '5',
			'recent_order'	 => '2',
			'random'		 => 'true',
			'random_label'	 => __( 'Random', 'wiz' ),
			'random_num'	 => '5',
			'random_order'	 => '3',
			'comment'		 => 'true',
			'comment_label'	 => __( 'Comments', 'wiz' ),
			'comment_num'	 => '5',
			'comment_order'	 => '4',
			'tags'			 => 'true',
			'tags_label'	 => __( 'Tags', 'wiz' ),
			'tags_num'		 => '5',
			'tags_order'	 => '5',
		);
		$instance	 = wp_parse_args( (array) $instance, $defaults );
		?>

		<!-- Popular Tab -->
		<p>
			<input id="<?php echo $this->get_field_id( 'popular' ); ?>" name="<?php echo $this->get_field_name( 'popular' ); ?>" value="true" <?php if ( $instance[ 'popular' ] ) echo 'checked="checked"'; ?> type="checkbox" />
			<label for="<?php echo $this->get_field_id( 'popular' ); ?>"><b>Popular Posts</b></label>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'popular_label' ); ?>">Label: </label>
			<input id="<?php echo $this->get_field_id( 'popular_label' ); ?>" name="<?php echo $this->get_field_name( 'popular_label' ); ?>" value="<?php echo $instance[ 'popular_label' ]; ?>" type="text" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'popular_num' ); ?>">Number: </label>
			<input id="<?php echo $this->get_field_id( 'popular_num' ); ?>" name="<?php echo $this->get_field_name( 'popular_num' ); ?>" value="<?php echo $instance[ 'popular_num' ]; ?>" type="text" size="3" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'popular_order' ); ?>">Order: </label>
			<input id="<?php echo $this->get_field_id( 'popular_order' ); ?>" name="<?php echo $this->get_field_name( 'popular_order' ); ?>" value="<?php echo $instance[ 'popular_order' ]; ?>" type="text" size="3" />
		</p>

		<hr />

		<!-- Recent Tab -->
		<p>
			<input id="<?php echo $this->get_field_id( 'recent' ); ?>" name="<?php echo $this->get_field_name( 'recent' ); ?>" value="true" <?php if ( $instance[ 'recent' ] ) echo 'checked="checked"'; ?> type="checkbox" />
			<label for="<?php echo $this->get_field_id( 'recent' ); ?>"><b>Recent Posts</b></label>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'recent_label' ); ?>">Label: </label>
			<input id="<?php echo $this->get_field_id( 'recent_label' ); ?>" name="<?php echo $this->get_field_name( 'recent_label' ); ?>" value="<?php echo $instance[ 'recent_label' ]; ?>" type="text" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'recent_num' ); ?>">Number: </label>
			<input id="<?php echo $this->get_field_id( 'recent_num' ); ?>" name="<?php echo $this->get_field_name( 'recent_num' ); ?>" value="<?php echo $instance[ 'recent_num' ]; ?>" type="text" size="3" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'recent_order' ); ?>">Order: </label>
			<input id="<?php echo $this->get_field_id( 'recent_order' ); ?>" name="<?php echo $this->get_field_name( 'recent_order' ); ?>" value="<?php echo $instance[ 'recent_order' ]; ?>" type="text" size="3" />
		</p>

		<hr />

		<!-- Random Tab -->
		<p>
			<input id="<?php echo $this->get_field_id( 'random' ); ?>" name="<?php echo $this->get_field_name( 'random' ); ?>" value="true" <?php if ( $instance[ 'random' ] ) echo 'checked="checked"'; ?> type="checkbox" />
			<label for="<?php echo $this->get_field_id( 'random' ); ?>"><b>Random Posts</b></label>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'random_label' ); ?>">Label: </label>
			<input id="<?php echo $this->get_field_id( 'random_label' ); ?>" name="<?php echo $this->get_field_name( 'random_label' ); ?>" value="<?php echo $instance[ 'random_label' ]; ?>" type="text" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'random_num' ); ?>">Number: </label>
			<input id="<?php echo $this->get_field_id( 'random_num' ); ?>" name="<?php echo $this->get_field_name( 'random_num' ); ?>" value="<?php echo $instance[ 'random_num' ]; ?>" type="text" size="3" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'random_order' ); ?>">Order: </label>
			<input id="<?php echo $this->get_field_id( 'random_order' ); ?>" name="<?php echo $this->get_field_name( 'random_order' ); ?>" value="<?php echo $instance[ 'random_order' ]; ?>" type="text" size="3" />
		</p>

		<hr />

		<!-- Recent Comments Tab -->
		<p>
			<input id="<?php echo $this->get_field_id( 'comment' ); ?>" name="<?php echo $this->get_field_name( 'comment' ); ?>" value="true" <?php if ( $instance[ 'comment' ] ) echo 'checked="checked"'; ?> type="checkbox" />
			<label for="<?php echo $this->get_field_id( 'comment' ); ?>"><b>Recent Comments</b></label>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'comment_label' ); ?>">Label: </label>
			<input id="<?php echo $this->get_field_id( 'comment_label' ); ?>" name="<?php echo $this->get_field_name( 'comment_label' ); ?>" value="<?php echo $instance[ 'comment_label' ]; ?>" type="text" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'comment_num' ); ?>">Number: </label>
			<input id="<?php echo $this->get_field_id( 'comment_num' ); ?>" name="<?php echo $this->get_field_name( 'comment_num' ); ?>" value="<?php echo $instance[ 'comment_num' ]; ?>" type="text" size="3" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'comment_order' ); ?>">Order: </label>
			<input id="<?php echo $this->get_field_id( 'comment_order' ); ?>" name="<?php echo $this->get_field_name( 'comment_order' ); ?>" value="<?php echo $instance[ 'comment_order' ]; ?>" type="text" size="3" />
		</p>

		<hr />

		<!-- Tags Tab -->
		<p>
			<input id="<?php echo $this->get_field_id( 'tags' ); ?>" name="<?php echo $this->get_field_name( 'tags' ); ?>" value="true" <?php if ( $instance[ 'tags' ] ) echo 'checked="checked"'; ?> type="checkbox" />
			<label for="<?php echo $this->get_field_id( 'tags' ); ?>"><b>Tags</b></label>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'tags_label' ); ?>">Label: </label>
			<input id="<?php echo $this->get_field_id( 'tags_label' ); ?>" name="<?php echo $this->get_field_name( 'tags_label' ); ?>" value="<?php echo $instance[ 'tags_label' ]; ?>" type="text" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'tags_num' ); ?>">Number: </label>
			<input id="<?php echo $this->get_field_id( 'tags_num' ); ?>" name="<?php echo $this->get_field_name( 'tags_num' ); ?>" value="<?php echo $instance[ 'tags_num' ]; ?>" type="text" size="3" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'tags_order' ); ?>">Order: </label>
			<input id="<?php echo $this->get_field_id( 'tags_order' ); ?>" name="<?php echo $this->get_field_name( 'tags_order' ); ?>" value="<?php echo $instance[ 'tags_order' ]; ?>" type="text" size="3" />
		</p>

		<?php
	}

	/* ----------------------------------------------------------------------------------- */
	# Get Popular posts 
	/* ----------------------------------------------------------------------------------- */

	function wp_popular_posts( $numberOfPosts = 5, $thumb = true ) {
		global $wpdb, $post;
		$orig_post = $post;

		$popularposts = get_posts( 'orderby=comment_count&numberposts=' . $numberOfPosts );
		foreach ( $popularposts as $post ): setup_postdata( $post );
			?>
			<li <?php echo ($thumb ? 'class="thumb"' : ''); ?> >
				<?php if ( function_exists( "has_post_thumbnail" ) && has_post_thumbnail() && $thumb ) : ?>			
					<div class="wdg-post">
						<a href="<?php the_permalink(); ?>" title="<?php printf( __( 'Permalink to %s', 'wiz' ), the_title_attribute( 'echo=0' ) ); ?>"><?php the_post_thumbnail( 'leap-thumbnail' ); ?></a>
					</div><!-- wdg-post /-->
				<?php endif; ?>
				<div class="wdg-posttitle"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></div>
				<small class="small"><?php echo get_the_date(); ?></small>
			</li>
			<?php
		endforeach;
		$post = $orig_post;
	}

	/* ----------------------------------------------------------------------------------- */
	# Get Random posts 
	/* ----------------------------------------------------------------------------------- */

	function wp_random_posts( $numberOfPosts = 5, $thumb = true ) {
		global $post;
		$orig_post = $post;

		$lastPosts = get_posts( 'orderby=rand&numberposts=' . $numberOfPosts );
		foreach ( $lastPosts as $post ): setup_postdata( $post );
			?>
			<li <?php echo ($thumb ? 'class="thumb"' : ''); ?> >
				<?php if ( function_exists( "has_post_thumbnail" ) && has_post_thumbnail() && $thumb ) : ?>			
					<div class="wdg-post">
						<a href="<?php the_permalink(); ?>" title="<?php printf( __( 'Permalink to %s', 'wiz' ), the_title_attribute( 'echo=0' ) ); ?>"><?php the_post_thumbnail( 'leap-thumbnail' ); ?></a>
					</div><!-- wdg-post /-->
				<?php endif; ?>
				<div class="wdg-posttitle"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></div>
				<small class="small"><?php echo get_the_date(); ?></small>
			</li>
			<?php
		endforeach;
		$post = $orig_post;
	}

	/* ----------------------------------------------------------------------------------- */
	# Get Most Racent posts
	/* ----------------------------------------------------------------------------------- */

	function wp_last_posts( $numberOfPosts = 5, $thumb = true ) {
		global $post;
		$orig_post = $post;

		$lastPosts = get_posts( 'numberposts=' . $numberOfPosts );
		foreach ( $lastPosts as $post ): setup_postdata( $post );
			?>
			<li <?php echo ($thumb ? 'class="thumb"' : ''); ?> >
				<?php if ( function_exists( "has_post_thumbnail" ) && has_post_thumbnail() && $thumb ) : ?>			
					<div class="wdg-post">
						<a href="<?php the_permalink(); ?>" title="<?php printf( __( 'Permalink to %s', 'wiz' ), the_title_attribute( 'echo=0' ) ); ?>"><?php the_post_thumbnail( 'leap-thumbnail' ); ?></a>
					</div><!-- wdg-post /-->
				<?php endif; ?>
				<div class="wdg-posttitle"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></div>
				<small class="small"><?php echo get_the_date(); ?></small>
			</li>
			<?php
		endforeach;
		$post = $orig_post;
	}

	/* ----------------------------------------------------------------------------------- */
	# Get commented posts 
	/* ----------------------------------------------------------------------------------- */

	function get_recent_commented( $comment_posts = 5, $avatar_size = 50 ) {
		$comments = get_comments( 'status=approve&post_type=post&number=' . $comment_posts );
		foreach ( $comments as $comment ) {
			?>
			<li>
				<div class="wdg-post">
					<?php echo get_avatar( $comment, $avatar_size ); ?>
				</div>
				<a href="<?php echo get_permalink( $comment->comment_post_ID ); ?>#comment-<?php echo $comment->comment_ID; ?>">
					<?php echo strip_tags( $comment->comment_author ); ?>: <?php echo wp_html_excerpt( $comment->comment_content, 60, '...' ); ?> </a>
			</li>
			<?php
		}
	}

	/* ----------------------------------------------------------------------------------- */
	# Get commented posts 
	/* ----------------------------------------------------------------------------------- */

	function get_popular_tags( $num = 5, $avatar_size = 50 ) {
		$tags_args = array(
			'orderby'	 => 'count',
			'order'		 => 'DESC',
			'number'	 => $num
		);

		$tags		 = get_tags( $tags_args );
		$tags_cloud	 = '<div class="post_tags">';
		foreach ( $tags as $tag ) {
			$tag_link = get_tag_link( $tag->term_id );

			$tags_cloud .= "<a href='{$tag_link}' title='{$tag->count} post' class='tag-link-{$tag->term_id} label tag-{$tag->slug}'>";
			$tags_cloud .= "{$tag->name}</a>";
		}
		$tags_cloud .= '</div>';
		echo $tags_cloud;
	}

}

function leap_tabs_widget() {
	register_widget( 'Leap_Tabs_Widget' );
}

add_action( 'widgets_init', 'leap_tabs_widget' );