<?php

class leap_soundcloud_widget extends WP_Widget {

	function __construct() {
		$widget_ops	 = array( 'classname' => 'leap-soundcloud' );
		$control_ops = array( 'width' => 250, 'height' => 350, 'id_base' => 'tie-soundcloud-widget' );
		parent::__construct( 'tie-soundcloud-widget', 'LEAP: SoundCloud', $widget_ops, $control_ops );
	}

	function widget( $args, $instance ) {
		extract( $args );

		$defaults	 = array( 'title' => 'SoundCloud', 'url' => '', 'width' => '100%', 'height' => '166', 'autoplay' => '' );
		$instance	 = wp_parse_args( (array) $instance, $defaults );

		$title		 = apply_filters( 'widget_title', $instance[ 'title' ], $instance, $this->id_base );
		$url		 = $instance[ 'url' ];
		$width		 = $instance[ 'width' ];
		$height		 = $instance[ 'height' ];
		$autoplay	 = $instance[ 'autoplay' ];

		$play	 = 'false';
		if ( !empty( $autoplay ) )
			$play	 = 'true';

		echo $before_widget;
		if ( !empty( $title ) ) {
			echo $before_title;
			echo $title;
			echo $after_title;
		}

		echo '<iframe width="' . $width . '" height="' . $height . '" scrolling="no" frameborder="no" src="https://w.soundcloud.com/player/?url=' . $url . '&amp;auto_play=' . $autoplay . '&amp;show_artwork=true"></iframe>';
		echo $after_widget;
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		$instance[ 'title' ]	 = sanitize_text_field( $new_instance[ 'title' ] );
		$instance[ 'url' ]		 = esc_url( $new_instance[ 'url' ] );
		$instance[ 'width' ]	 = sanitize_text_field( $new_instance[ 'width' ] );
		$instance[ 'height' ]	 = sanitize_text_field( $new_instance[ 'height' ] );
		$instance[ 'autoplay' ]	 = sanitize_text_field( $new_instance[ 'autoplay' ] );
		return $instance;
	}

	function form( $instance ) {
		$defaults	 = array( 'title' => 'SoundCloud', 'url' => '', 'width' => '100%', 'height' => '166', 'autoplay' => '' );
		$instance	 = wp_parse_args( (array) $instance, $defaults );
		?>

		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>">Title : </label>
			<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance[ 'title' ]; ?>" class="widefat" type="text" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'url' ); ?>">URL :</label>
			<input id="<?php echo $this->get_field_id( 'url' ); ?>" name="<?php echo $this->get_field_name( 'url' ); ?>" value="<?php echo $instance[ 'url' ]; ?>" type="text" class="widefat" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'width' ); ?>">Width:</label>
			<input type="text" class="widefat" style="width: 50px;" id="<?php echo $this->get_field_id( 'width' ); ?>" name="<?php echo $this->get_field_name( 'width' ); ?>" value="<?php echo $instance[ 'width' ]; ?>" />
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'height' ); ?>">Height:</label>
			<input type="text" class="widefat" style="width: 50px;" id="<?php echo $this->get_field_id( 'height' ); ?>" name="<?php echo $this->get_field_name( 'height' ); ?>" value="<?php echo $instance[ 'height' ]; ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'autoplay' ); ?>">Autoplay :</label>
			<input id="<?php echo $this->get_field_id( 'autoplay' ); ?>" name="<?php echo $this->get_field_name( 'autoplay' ); ?>" value="true" <?php if ( $instance[ 'autoplay' ] ) echo 'checked="checked"'; ?> type="checkbox" />
		</p>


		<?php
	}

}

function leap_soundcloud_widget() {
	register_widget( 'leap_soundcloud_widget' );
}

add_action( 'widgets_init', 'leap_soundcloud_widget' );
