<?php

class Leap_Separator_Widget extends WP_Widget {

	function __construct() {
		$widget_ops = array( 'classname' => 'separator_widget' );

		$control_ops = array( 'id_base' => 'separator-widget' );

		parent::__construct( 'separator-widget', esc_html__( 'LEAP: Separator Widget', 'wiz' ), $widget_ops, $control_ops );
	}

	function widget( $args, $instance ) {
		extract( $args );

		$defaults	 = array( 'color' => '#E5E5E5' );
		$instance	 = wp_parse_args( (array) $instance, $defaults );

		$color	 = $instance[ 'color' ];
		$style	 = '';
		if ( !empty( $color ) ) {
			$style = 'style="border-top-color: ' . $color . ';"';
		}
		echo "<div " . $style . " class='widget separator-widget'></div>";
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		$instance[ 'color' ] = leap_sanitize_hex_color( $new_instance[ 'color' ] );
		return $instance;
	}

	function form( $instance ) {
		$defaults	 = array( 'color' => '#E5E5E5' );
		$instance	 = wp_parse_args( (array) $instance, $defaults );
		?>

		<p>Separator Widget</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'color' ); ?>">Color: </label>
			<input id="<?php echo $this->get_field_id( 'color' ); ?>" name="<?php echo $this->get_field_name( 'color' ); ?>" value="<?php echo $instance[ 'color' ]; ?>" class="widefat" type="text" />
		</p>

		<?php
	}

}

function leap_separator_widget() {
	register_widget( 'Leap_Separator_Widget' );
}

add_action( 'widgets_init', 'leap_separator_widget' );
