<?php

class Leap_Posts_List_widget extends WP_Widget {

	function __construct() {
		$widget_ops	 = array( 'classname' => 'posts-list' );
		$control_ops = array( 'width' => 250, 'height' => 350, 'id_base' => 'posts-list-widget' );
		parent::__construct( 'posts-list-widget', 'LEAP: Posts list', $widget_ops, $control_ops );
	}

	function widget( $args, $instance ) {
		extract( $args );
		
		$defaults	 = array( 'title' => __( 'Posts list', 'wiz' ), 'no_of_posts' => '5', 'posts_order' => 'latest', 'thumb' => 'true' );
		$instance	 = wp_parse_args( (array) $instance, $defaults );

		$title		 = apply_filters( 'widget_title', $instance[ 'title' ], $instance, $this->id_base );
		$no_of_posts = $instance[ 'no_of_posts' ];
		$posts_order = $instance[ 'posts_order' ];
		$thumb		 = $instance[ 'thumb' ];

		echo $before_widget;
		if ( !empty( $title ) ) {
			echo $before_title;
			echo $title;
			echo $after_title;
		}
		?>
		<ul>
			<?php
			if ( $posts_order == 'popular' )
				$this->wp_popular_posts( $no_of_posts, $thumb );

			elseif ( $posts_order == 'random' )
				$this->wp_random_posts( $no_of_posts, $thumb );
			else
				$this->wp_last_posts( $no_of_posts, $thumb )
				?>	
		</ul>
		<div class="clear"></div>
		<?php
		echo $after_widget;
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		$instance[ 'title' ]		 = sanitize_text_field( $new_instance[ 'title' ] );
		$instance[ 'no_of_posts' ]	 = absint( $new_instance[ 'no_of_posts' ] );
		$instance[ 'posts_order' ]	 = (in_array( $new_instance[ 'posts_order' ], array( 'latest', 'popular', 'random' ) )) ? $new_instance[ 'posts_order' ] : 'latest';
		$instance[ 'thumb' ]		 = isset( $new_instance[ 'thumb' ] );
		return $instance;
	}

	function form( $instance ) {
		$defaults	 = array( 'title' => __( 'Posts list', 'wiz' ), 'no_of_posts' => '5', 'posts_order' => 'latest', 'thumb' => 'true' );
		$instance	 = wp_parse_args( (array) $instance, $defaults );
		?>

		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>">Title : </label>
			<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance[ 'title' ]; ?>" class="widefat" type="text" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'no_of_posts' ); ?>">Number of posts to show: </label>
			<input id="<?php echo $this->get_field_id( 'no_of_posts' ); ?>" name="<?php echo $this->get_field_name( 'no_of_posts' ); ?>" value="<?php echo $instance[ 'no_of_posts' ]; ?>" type="text" size="3" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'posts_order' ); ?>">Posts order : </label>
			<select id="<?php echo $this->get_field_id( 'posts_order' ); ?>" name="<?php echo $this->get_field_name( 'posts_order' ); ?>" >
				<option value="latest" <?php
				if ( $instance[ 'posts_order' ] == 'latest' )
					echo "selected=\"selected\"";
				else
					echo "";
				?>>Most recent</option>
				<option value="random" <?php
				if ( $instance[ 'posts_order' ] == 'random' )
					echo "selected=\"selected\"";
				else
					echo "";
				?>>Random</option>
				<option value="popular" <?php
				if ( $instance[ 'posts_order' ] == 'popular' )
					echo "selected=\"selected\"";
				else
					echo "";
				?>>Popular</option>
			</select>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'thumb' ); ?>">Display Thumbinals : </label>
			<input id="<?php echo $this->get_field_id( 'thumb' ); ?>" name="<?php echo $this->get_field_name( 'thumb' ); ?>" value="true" <?php if ( $instance[ 'thumb' ] ) echo 'checked="checked"'; ?> type="checkbox" />
		</p>

		<?php
	}

	/* ----------------------------------------------------------------------------------- */
	# Get Popular posts 
	/* ----------------------------------------------------------------------------------- */

	function wp_popular_posts( $pop_posts = 5, $thumb = true ) {
		global $wpdb, $post;
		$orig_post = $post;

		$popularposts = get_posts( 'orderby=comment_count&numberposts=' . $pop_posts );
		foreach ( $popularposts as $post ): setup_postdata( $post );
			?>
			<li <?php echo ($thumb ? 'class="thumb"' : ''); ?> >
				<?php if ( function_exists( "has_post_thumbnail" ) && has_post_thumbnail() && $thumb ) : ?>			
					<div class="wdg-post">
						<a href="<?php the_permalink(); ?>" title="<?php printf( __( 'Permalink to %s', 'wiz' ), the_title_attribute( 'echo=0' ) ); ?>"><?php the_post_thumbnail( 'leap-thumbnail' ); ?></a>
					</div><!-- wdg-post /-->
			<?php endif; ?>
				<div class="wdg-posttitle"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></div>
				<small class="small"><?php echo get_the_date(); ?></small>
			</li>
			<?php
		endforeach;
		$post = $orig_post;
	}

	/* ----------------------------------------------------------------------------------- */
	# Get Random posts 
	/* ----------------------------------------------------------------------------------- */

	function wp_random_posts( $numberOfPosts = 5, $thumb = true ) {
		global $post;
		$orig_post = $post;

		$lastPosts = get_posts( 'orderby=rand&numberposts=' . $numberOfPosts );
		foreach ( $lastPosts as $post ): setup_postdata( $post );
			?>
			<li <?php echo ($thumb ? 'class="thumb"' : ''); ?> >
				<?php if ( function_exists( "has_post_thumbnail" ) && has_post_thumbnail() && $thumb ) : ?>			
					<div class="wdg-post">
						<a href="<?php the_permalink(); ?>" title="<?php printf( __( 'Permalink to %s', 'wiz' ), the_title_attribute( 'echo=0' ) ); ?>"><?php the_post_thumbnail( 'leap-thumbnail' ); ?></a>
					</div><!-- wdg-post /-->
			<?php endif; ?>
				<div class="wdg-posttitle"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></div>
				<small class="small"><?php echo get_the_date(); ?></small>
			</li>
			<?php
		endforeach;
		$post = $orig_post;
	}

	/* ----------------------------------------------------------------------------------- */
	# Get Most Racent posts
	/* ----------------------------------------------------------------------------------- */

	function wp_last_posts( $numberOfPosts = 5, $thumb = true ) {
		global $post;
		$orig_post = $post;

		$lastPosts = get_posts( 'numberposts=' . $numberOfPosts );
		foreach ( $lastPosts as $post ): setup_postdata( $post );
			?>
			<li <?php echo ($thumb ? 'class="thumb"' : ''); ?> >
				<?php if ( function_exists( "has_post_thumbnail" ) && has_post_thumbnail() && $thumb ) : ?>			
					<div class="wdg-post">
						<a href="<?php the_permalink(); ?>" title="<?php printf( __( 'Permalink to %s', 'wiz' ), the_title_attribute( 'echo=0' ) ); ?>"><?php the_post_thumbnail( 'leap-thumbnail' ); ?></a>
					</div><!-- wdg-post /-->
			<?php endif; ?>
				<div class="wdg-posttitle"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></div>
				<small class="small"><?php echo get_the_date(); ?></small>
			</li>
			<?php
		endforeach;
		$post = $orig_post;
	}

}

function leap_posts_list_widget() {
	register_widget( 'Leap_Posts_List_widget' );
}

add_action( 'widgets_init', 'leap_posts_list_widget' );
