<?php

class Leap_Posts_Images extends WP_Widget {

	function __construct() {
		$widget_ops	 = array( 'classname' => 'news-pic' );
		$control_ops = array( 'width' => 250, 'height' => 350, 'id_base' => 'news-pic-widget' );
		parent::__construct( 'news-pic-widget', 'LEAP: Posts in Images', $widget_ops, $control_ops );
	}

	function widget( $args, $instance ) {
		extract( $args );

		$defaults	 = array( 'title' => __( 'Posts in Images', 'wiz' ), 'no_of_posts' => '12', 'cats_id' => '1', 'posts_order' => 'latest' );
		$instance	 = wp_parse_args( (array) $instance, $defaults );

		$title		 = apply_filters( 'widget_title', $instance[ 'title' ], $instance, $this->id_base );
		$no_of_posts = $instance[ 'no_of_posts' ];
		$cats_id	 = $instance[ 'cats_id' ];
		$posts_order = $instance[ 'posts_order' ];

		echo $before_widget;
		if ( !empty( $title ) ) {
			echo $before_title;
			echo $title;
			echo $after_title;
		}
		?>
		<?php $this->wp_last_news_pic( $posts_order, $no_of_posts, $cats_id ) ?>	
		<div class="clear"></div>
		<?php
		echo $after_widget;
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		$instance[ 'title' ]		 = sanitize_text_field( $new_instance[ 'title' ] );
		$instance[ 'no_of_posts' ]	 = absint( $new_instance[ 'no_of_posts' ] );
		$instance[ 'cats_id' ]		 = implode( ',', array_map( 'absint', $new_instance[ 'cats_id' ]) );
		$instance[ 'posts_order' ]	 = (in_array( $new_instance[ 'posts_order' ], array( 'latest', 'random' ) )) ? $new_instance[ 'posts_order' ] : 'latest';

		return $instance;
	}

	function form( $instance ) {
		$defaults	 = array( 'title' => __( 'Posts in Images', 'wiz' ), 'no_of_posts' => '12', 'cats_id' => '1', 'posts_order' => 'latest' );
		$instance	 = wp_parse_args( (array) $instance, $defaults );

		$categories_obj	 = get_categories();
		$categories		 = array();

		foreach ( $categories_obj as $pn_cat ) {
			$categories[ $pn_cat->cat_ID ] = $pn_cat->cat_name;
		}
		?>

		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>">Title : </label>
			<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance[ 'title' ]; ?>" class="widefat" type="text" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'no_of_posts' ); ?>">Number of posts to show: </label>
			<input id="<?php echo $this->get_field_id( 'no_of_posts' ); ?>" name="<?php echo $this->get_field_name( 'no_of_posts' ); ?>" value="<?php echo $instance[ 'no_of_posts' ]; ?>" type="text" size="3" />
		</p>
		<p>
			<?php $cats_id = explode( ',', $instance[ 'cats_id' ] ); ?>
			<label for="<?php echo $this->get_field_id( 'cats_id' ); ?>">Category : </label>
			<select multiple="multiple" id="<?php echo $this->get_field_id( 'cats_id' ); ?>[]" name="<?php echo $this->get_field_name( 'cats_id' ); ?>[]">
				<?php foreach ( $categories as $key => $option ) { ?>
					<option value="<?php echo $key ?>" <?php
					if ( in_array( $key, $cats_id ) ) {
						echo ' selected="selected"';
					}
					?>><?php echo $option; ?></option>
						<?php } ?>
			</select>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'posts_order' ); ?>">Posts order : </label>
			<select id="<?php echo $this->get_field_id( 'posts_order' ); ?>" name="<?php echo $this->get_field_name( 'posts_order' ); ?>" >
				<option value="latest" <?php
				if ( $instance[ 'posts_order' ] == 'latest' )
					echo "selected=\"selected\"";
				else
					echo "";
				?>>Most recent</option>
				<option value="random" <?php
				if ( $instance[ 'posts_order' ] == 'random' )
					echo "selected=\"selected\"";
				else
					echo "";
				?>>Random</option>
			</select>
		</p>

		<?php
	}

	/* ----------------------------------------------------------------------------------- */
# News In Picture
	/* ----------------------------------------------------------------------------------- */

	function wp_last_news_pic( $order, $numberOfPosts = 12, $cats = 1 ) {
		global $post;
		$orig_post = $post;

		if ( $order == 'random' )
			$lastPosts	 = get_posts( $args		 = array( 'numberposts' => $numberOfPosts, 'orderby' => 'rand', 'category' => $cats ) );
		else
			$lastPosts	 = get_posts( $args		 = array( 'numberposts' => $numberOfPosts, 'category' => $cats ) );
		get_posts( 'category=' . $cats . '&numberposts=' . $numberOfPosts );

		foreach ( $lastPosts as $post ): setup_postdata( $post );
			?>

			<?php if ( function_exists( "has_post_thumbnail" ) && has_post_thumbnail() ) : ?>
				<div class="wdg-post">
					<a class="ttip" title="<?php the_title(); ?>" href="<?php the_permalink(); ?>" ><?php the_post_thumbnail( 'leap-thumbnail' ); ?></a>
				</div><!-- wdg-post /-->
			<?php endif; ?>

			<?php
		endforeach;
		$post = $orig_post;
	}

}

function leap_posts_images_widget() {
	register_widget( 'Leap_Posts_Images' );
}
add_action( 'widgets_init', 'leap_posts_images_widget' );