<?php

class Leap_Login_Form_Widget extends WP_Widget {

    /**
     * Widget setup.
     */
    function __construct() {
        /* Widget settings. */
        $widget_ops = array( 'classname' => 'loginform', 'description' => esc_html__( 'A user login form.', 'wiz' ) );

        /* Widget control settings. */
        $control_ops = array( 'width' => 150, 'height' => 350, 'id_base' => 'loginform-widget' );

        /* Create the widget. */
        parent::__construct( 'loginform-widget', esc_html__( 'LEAP: Login Form', 'wiz' ), $widget_ops, $control_ops );
    }

    /**
     * How to display the widget on the screen.
     */
    function widget( $args, $instance ) {
        extract( $args );

        /* Set up some default widget settings. */
        $defaults = array( 'title' => 'Login Form' );
        $instance = wp_parse_args( (array) $instance, $defaults );

        /* Our variables from the widget settings. */
        $title = apply_filters( 'widget_title', $instance[ 'title' ], $instance, $this->id_base );

        echo $before_widget;
        if ( !empty( $title ) ) {
            echo $before_title;
            echo $title;
            echo $after_title;
        }

        global $user_identity;
        $redirect = ( is_ssl() ? 'https://' : 'http://' ) . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
        ?>
        <?php if ( is_user_logged_in() ) : ?>
            <p><?php esc_html_e( 'You are logged in as', 'wiz' ); ?> <strong><?php echo $user_identity ?></strong>.</p>	
            <ul>
                <li><a href="<?php echo esc_url( get_dashboard_url() ); ?>"><?php _e( 'Dashboard', 'wiz' ) ?> </a></li>
                <li><a href="<?php echo esc_url( get_edit_user_link() ); ?>"><?php _e( 'Your Profile', 'wiz' ) ?> </a></li>
                <li><a href="<?php echo esc_url( wp_logout_url( $redirect ) ); ?>"><?php _e( 'Logout', 'wiz' ) ?> </a></li>
            </ul>
        <?php else : ?>
            <div>
                <?php wp_login_form( array() ); ?>
            </div>
            <ul>
                <?php if ( get_option( 'users_can_register' ) ) : ?>
                    <li><a href="<?php echo esc_url( wp_registration_url() ); ?>"><?php esc_attr_e( 'Register', 'wiz' ); ?></a></li>
                <?php endif; ?>
                <li><a href="<?php echo esc_url( wp_lostpassword_url() ); ?>"><?php esc_attr_e( 'Lost your password?', 'wiz' ); ?></a></li>
            </ul>
        <?php
        endif;
        /* After widget (defined by themes). */
        echo $after_widget;
    }

    /**
     * Update the widget settings.
     */
    function update( $new_instance, $old_instance ) {
        $instance = $old_instance;

        /* Strip tags for title to remove HTML (important for text inputs). */
        $instance[ 'title' ] = sanitize_text_field( $new_instance[ 'title' ] );

        return $instance;
    }

    /**
     * Displays the widget settings controls on the widget panel.
     * Make use of the get_field_id() and get_field_name() function
     * when creating your form elements. This handles the confusing stuff.
     */
    function form( $instance ) {

        /* Set up some default widget settings. */
        $defaults = array( 'title' => 'Login Form' );
        $instance = wp_parse_args( (array) $instance, $defaults );
        ?>

        <!-- Widget Title: Text Input -->
        <p>
            <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php esc_html_e( 'Title:', 'wiz' ); ?></label>
            <input id="<?php echo $this->get_field_id( 'title' ); ?>" type="text" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance[ 'title' ]; ?>" style="width:100%;" />
        </p>

        <?php
    }

}

function leap_login_form_load_widgets() {
    register_widget( 'Leap_Login_Form_Widget' );
}

add_action( 'widgets_init', 'leap_login_form_load_widgets' );
