<?php

class Leap_Google_Map_Widget extends WP_Widget {

	/**
	 * Widget setup.
	 */
	function __construct() {
		/* Widget settings. */
		$widget_ops = array( 'classname' => 'widget_googlemap', 'description' => esc_html__( 'A Google Map widget.', 'wiz' ) );

		/* Widget control settings. */
		$control_ops = array( 'width' => 350, 'height' => 350, 'id_base' => 'googlemap-widget' );

		/* Create the widget. */
		parent::__construct( 'googlemap-widget', esc_html__( 'LEAP: Google Map', 'wiz' ), $widget_ops, $control_ops );
	}

	/**
	 * How to display the widget on the screen.
	 */
	function widget( $args, $instance ) {
		extract( $args );

		$defaults	 = array( 'title' => esc_html__( 'Google Map', 'wiz' ), 'googlemap_code' => '' );
		$instance	 = wp_parse_args( (array) $instance, $defaults );

		/* Our variables from the widget settings. */
		$title			 = apply_filters( 'widget_title', $instance[ 'title' ], $instance, $this->id_base );
		$googlemap_code	 = $instance[ 'googlemap_code' ];

		/* Display the widget title if one was input (before and after defined by themes). */
		echo $before_widget;
		if ( !empty( $title ) ) {
			echo $before_title;
			echo $title;
			echo $after_title;
		}

		/* Display the widget title if one was input (before and after defined by themes). */
		if ( $googlemap_code )
			echo $googlemap_code;

		/* After widget (defined by themes). */
		echo $after_widget;
	}

	/**
	 * Update the widget settings.
	 */
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		$instance[ 'title' ]			 = sanitize_text_field( $new_instance[ 'title' ] );
		$instance[ 'googlemap_code' ]	 = $new_instance[ 'googlemap_code' ];

		return $instance;
	}

	/**
	 * Displays the widget settings controls on the widget panel.
	 * Make use of the get_field_id() and get_field_name() function
	 * when creating your form elements. This handles the confusing stuff.
	 */
	function form( $instance ) {

		/* Set up some default widget settings. */
		$defaults	 = array( 'title' => esc_html__( 'Google Map', 'wiz' ), 'googlemap_code' => '' );
		$instance	 = wp_parse_args( (array) $instance, $defaults );
		?>

		<!-- Widget Title: Text Input -->
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php esc_html_e( 'Title:', 'wiz' ); ?></label>
			<input id="<?php echo $this->get_field_id( 'title' ); ?>" type="text" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance[ 'title' ]; ?>" style="width:100%;" />
		</p>
		<!-- Widget Title: Text Area Input -->
		<p>
			<label for="<?php echo $this->get_field_id( 'googlemap_code' ); ?>"><?php esc_html_e( 'Google Map Code:', 'wiz' ); ?></label>
			<textarea id="<?php echo $this->get_field_id( 'googlemap_code' ); ?>" class="code" style="width: 100%;" rows="10" cols="20" name="<?php echo $this->get_field_name( 'googlemap_code' ); ?>"><?php
				if ( $instance[ 'googlemap_code' ] ) {
					echo esc_textarea( $instance[ 'googlemap_code' ] );
				}
				?></textarea>
		</p>

		<?php
	}

}

function leap_google_map_load_widgets() {
	register_widget( 'Leap_Google_Map_Widget' );
}

add_action( 'widgets_init', 'leap_google_map_load_widgets' );
