<?php

class Leap_Google_Badge_Widget extends WP_Widget {

	function __construct() {
		$widget_ops	 = array( 'classname' => 'google-badge-widget' );
		$control_ops = array( 'width' => 250, 'height' => 350, 'id_base' => 'google-badge-widget' );
		parent::__construct( 'google-badge-widget', 'LEAP: Google+ Badge', $widget_ops, $control_ops );
	}

	function widget( $args, $instance ) {
		extract( $args );
		
		$defaults	 = array( 'title' => __( 'Follow us on Google+', 'wiz' ), 'page_url' => '', 'layout' => '', 'width' => '180', 'theme' => '', 'cover_photo' => '', 'tagline' => '' );
		$instance	 = wp_parse_args( (array) $instance, $defaults );

		$title		 = apply_filters( 'widget_title', $instance[ 'title' ], $instance, $this->id_base );
		$page_url	 = $instance[ 'page_url' ];
		$layout		 = $instance[ 'layout' ];
		$width		 = $instance[ 'width' ];
		$theme		 = $instance[ 'theme' ];
		$cover_photo = $instance[ 'cover_photo' ];
		$tagline	 = $instance[ 'tagline' ];

		echo $before_widget;
		if ( !empty( $title ) ) {
			echo $before_title;
			echo $title;
			echo $after_title;
		}
		?>
		<div class="google-box">

			<!-- Place this tag where you want the widget to render. -->
			<div class="g-page" data-width="<?php echo $width; ?>" data-href="<?php echo $page_url; ?>" data-layout="<?php echo $layout; ?>" data-theme="<?php echo $theme; ?>" <?php if ( $layout == 'portrait' ) : ?>data-showcoverphoto="<?php echo $cover_photo; ?>" data-showtagline="<?php echo $tagline; ?>"<?php endif; ?> data-rel="publisher"></div>

			<!-- Place this tag after the last widget tag. -->
			<script type="text/javascript">
				( function () {
					var po = document.createElement( 'script' );
					po.type = 'text/javascript';
					po.async = true;
					po.src = 'https://apis.google.com/js/plusone.js';
					var s = document.getElementsByTagName( 'script' )[0];
					s.parentNode.insertBefore( po, s );
				} )();
			</script>

		</div>
		<?php
		echo $after_widget;
	}

	function update( $new_instance, $old_instance ) {
		$instance					 = $old_instance;
		$instance[ 'title' ]		 = sanitize_text_field( $new_instance[ 'title' ] );
		$instance[ 'page_url' ]		 = esc_url( $new_instance[ 'page_url' ] );
		$instance[ 'layout' ]		 = (in_array( $new_instance[ 'layout' ], array( 'portrait', 'landscape' ) )) ? $new_instance[ 'layout' ] : 'portrait';
		$instance[ 'width' ]		 = absint( $new_instance[ 'width' ] );
		$instance[ 'theme' ]		 = (in_array( $new_instance[ 'theme' ], array( 'light', 'dark' ) )) ? $new_instance[ 'theme' ] : 'light';
		$instance[ 'cover_photo' ]	 = (in_array( $new_instance[ 'cover_photo' ], array( 'true', 'false' ) )) ? $new_instance[ 'cover_photo' ] : 'true';
		$instance[ 'tagline' ]		 = (in_array( $new_instance[ 'tagline' ], array( 'true', 'false' ) )) ? $new_instance[ 'tagline' ] : 'true';
		return $instance;
	}

	function form( $instance ) {
		$defaults	 = array( 'title' => __( 'Follow us on Google+', 'wiz' ), 'page_url' => '', 'layout' => '', 'width' => '180', 'theme' => '', 'cover_photo' => '', 'tagline' => '' );
		$instance	 = wp_parse_args( (array) $instance, $defaults );
		?>

		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>">Title: </label>
			<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance[ 'title' ]; ?>" class="widefat" type="text" />
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'page_url' ); ?>">Page Url: </label>
			<input id="<?php echo $this->get_field_id( 'page_url' ); ?>" name="<?php echo $this->get_field_name( 'page_url' ); ?>" value="<?php echo $instance[ 'page_url' ]; ?>" class="widefat" type="text" />
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'layout' ); ?>">Layout:</label> 
			<select id="<?php echo $this->get_field_id( 'layout' ); ?>" name="<?php echo $this->get_field_name( 'layout' ); ?>" >
				<option value="portrait" <?php if ( 'portrait' == $instance[ 'layout' ] ) echo 'selected="selected"'; ?>>Portrait</option>
				<option value="landscape" <?php if ( 'landscape' == $instance[ 'layout' ] ) echo 'selected="selected"'; ?>>Landscape</option>
			</select>
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'width' ); ?>">Width: </label>
			<input id="<?php echo $this->get_field_id( 'width' ); ?>" name="<?php echo $this->get_field_name( 'width' ); ?>" value="<?php echo $instance[ 'width' ]; ?>" type="number" min="180" max="450" />
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'theme' ); ?>">Color theme:</label> 
			<select id="<?php echo $this->get_field_id( 'theme' ); ?>" name="<?php echo $this->get_field_name( 'theme' ); ?>">
				<option value="light" <?php if ( 'light' == $instance[ 'theme' ] ) echo 'selected="selected"'; ?>>Light</option>
				<option value="dark" <?php if ( 'dark' == $instance[ 'theme' ] ) echo 'selected="selected"'; ?>>Dark</option>
			</select>
		</p>

		<p>Portrait layput settings</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'cover_photo' ); ?>">Cover Photo:</label> 
			<select id="<?php echo $this->get_field_id( 'cover_photo' ); ?>" name="<?php echo $this->get_field_name( 'cover_photo' ); ?>">
				<option value="true" <?php if ( 'true' == $instance[ 'cover_photo' ] ) echo 'selected="selected"'; ?>>Enabled</option>
				<option value="false" <?php if ( 'false' == $instance[ 'cover_photo' ] ) echo 'selected="selected"'; ?>>Disabled</option>
			</select>
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'tagline' ); ?>">Tagline:</label> 
			<select id="<?php echo $this->get_field_id( 'tagline' ); ?>" name="<?php echo $this->get_field_name( 'tagline' ); ?>">
				<option value="true" <?php if ( 'true' == $instance[ 'tagline' ] ) echo 'selected="selected"'; ?>>Enabled</option>
				<option value="false" <?php if ( 'false' == $instance[ 'tagline' ] ) echo 'selected="selected"'; ?>>Disabled</option>
			</select>
		</p>

		<?php
	}

}

function leap_google_badge_widget_box() {
	register_widget( 'Leap_Google_Badge_Widget' );
}

add_action( 'widgets_init', 'leap_google_badge_widget_box' );