<?php

class Leap_Flickr_Widget extends WP_Widget {

	function __construct() {
		$widget_ops	 = array( 'classname' => 'flickr', 'description' => 'The most recent photos from flickr.' );
		$control_ops = array( 'id_base' => 'flickr-widget' );
		parent::__construct( 'flickr-widget', 'LEAP: Flickr', $widget_ops, $control_ops );
	}

	function widget( $args, $instance ) {
		extract( $args );
		
		$defaults	 = array( 'title' => 'Photos from Flickr', 'screen_name' => '', 'number' => 6, 'api' => '' );
		$instance	 = wp_parse_args( (array) $instance, $defaults );

		$title		 = apply_filters( 'widget_title', $instance[ 'title' ], $instance, $this->id_base );
		$screen_name = $instance[ 'screen_name' ];
		$number		 = $instance[ 'number' ];
		$api		 = $instance[ 'api' ];
		if ( empty( $api ) ) {
			$api = 'c9d2c2fda03a2ff487cb4769dc0781ea';
		}

		echo $before_widget;
		if ( !empty( $title ) ) {
			echo $before_title;
			echo $title;
			echo $after_title;
		}

		if ( $screen_name && $number && $api ) {
			?>
			<div class="flickr-images">
				<script type="text/javascript">
					function jsonFlickrApi( rsp ) {
						if ( rsp.stat != "ok" ) {
							// If this executes, something broke!
							return;
						}

						//variable "s" is going to contain 
						//all the markup that is generated by the loop below
						var s = "";

						//this loop runs through every item and creates HTML 
						for ( var i = 0; i < rsp.photos.photo.length; i++ ) {
							photo = rsp.photos.photo[ i ];

							//notice that "t.jpg" is where you change the
							//size of the image
							t_url = "http://farm" + photo.farm +
								".static.flickr.com/" + photo.server + "/" +
								photo.id + "_" + photo.secret + "_" + "s.jpg";

							p_url = "http://www.flickr.com/photos/" +
								photo.owner + "/" + photo.id;

							s += '<div class="wdg-post flickr_badge_image"><a href="' + p_url + '">' + '<img alt="' +
								photo.title + '"src="' + t_url + '"/>' + '</a></div>';
						}

						document.write( s );
					}
				</script>
				<script type="text/javascript" src="https://api.flickr.com/services/rest/?format=json&amp;method=flickr.photos.search&amp;user_id=<?php echo $screen_name; ?>&amp;api_key=<?php echo $api; ?>&amp;media=photos&amp;per_page=<?php echo $number; ?>&amp;privacy_filter=1"></script>
			</div>
			<?php
		}

		echo $after_widget;
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		$instance[ 'title' ]		 = sanitize_text_field( $new_instance[ 'title' ] );
		$instance[ 'screen_name' ]	 = sanitize_text_field($new_instance[ 'screen_name' ]);
		$instance[ 'number' ]		 = absint($new_instance[ 'number' ]);
		$instance[ 'api' ]			 = sanitize_text_field($new_instance[ 'api' ]);

		return $instance;
	}

	function form( $instance ) {
		$defaults	 = array( 'title' => 'Photos from Flickr', 'screen_name' => '', 'number' => 6, 'api' => '' );
		$instance	 = wp_parse_args( (array) $instance, $defaults );
		?>

		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>">Title:</label>
			<input type="text" class="widefat" style="width: 216px;" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance[ 'title' ]; ?>" />
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'screen_name' ); ?>">Flickr ID(<a href="<?php echo esc_url( 'http://idgettr.com/' ) ?>">Get your flickr ID</a>):</label>
			<input type="text" class="widefat" style="width: 216px;" id="<?php echo $this->get_field_id( 'screen_name' ); ?>" name="<?php echo $this->get_field_name( 'screen_name' ); ?>" value="<?php echo $instance[ 'screen_name' ]; ?>" />
		</p>


		<p>
			<label for="<?php echo $this->get_field_id( 'number' ); ?>">Number of photos to show:</label>
			<input type="text" class="widefat" style="width: 30px;" id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" value="<?php echo $instance[ 'number' ]; ?>" />
		</p>

		<p>
			<label for="<?php echo $this->get_field_id( 'api' ); ?>">API key (Get your key from <a href="<?php echo esc_url( 'https://www.flickr.com/services/apps/create/apply' ) ?>" target="_blank">The App Garden</a>):</label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'api' ); ?>" name="<?php echo $this->get_field_name( 'api' ); ?>" value="<?php echo $instance[ 'api' ]; ?>" />
		</p>

		<?php
	}

}

function leap_flickr_load_widgets() {
	register_widget( 'Leap_Flickr_Widget' );
}

add_action( 'widgets_init', 'leap_flickr_load_widgets' );
