<?php

class Leap_Feedburner_Widget extends WP_Widget {

	function __construct() {
		$widget_ops	 = array( 'classname' => 'widget-feedburner', 'description' => 'Subscribe to feedburner via email' );
		$control_ops = array( 'width' => 250, 'height' => 350, 'id_base' => 'widget-feedburner' );
		parent::__construct( 'widget-feedburner', 'LEAP: Feedburner Widget ', $widget_ops, $control_ops );
	}

	function widget( $args, $instance ) {
		extract( $args );
		
		$defaults	 = array( 'title' => __( 'FeedBurner Widget', 'wiz' ), 'text_code' => __( 'Subscribe to our email newsletter.', 'wiz' ), 'feedburner' => '' );
		$instance	 = wp_parse_args( (array) $instance, $defaults );

		$title		 = apply_filters( 'widget_title', $instance[ 'title' ], $instance, $this->id_base );
		$text_code	 = $instance[ 'text_code' ];
		$feedburner	 = $instance[ 'feedburner' ];

		echo $before_widget;
		if ( !empty( $title ) ) {
			echo $before_title;
			echo $title;
			echo $after_title;
		}

		echo '<div class="widgetContainer widget-feedburner-counter">';
		if ( $text_code ) {
			echo '<p>' . do_shortcode( $text_code ) . '</p>';
		}
		?>
		<form action="http://feedburner.google.com/fb/a/mailverify" method="post" target="popupwindow" onsubmit="window.open( 'http://feedburner.google.com/fb/a/mailverify?uri=<?php echo $feedburner; ?>', 'popupwindow', 'scrollbars=yes,width=550,height=520' );
						return true">
			<div class="form-group">
				<input class="form-control feedburner-email" type="text" name="email" value="" placeholder="<?php _e( 'Enter your e-mail address', 'wiz' ); ?>">
				<input type="hidden" value="<?php echo $feedburner; ?>" name="uri">
				<input type="hidden" name="loc" value="en_US">	
			</div >		
			<input class="feedburner-subscribe pull-right btn btn-leap" type="submit" name="submit" value="<?php _e( 'Subscribe', 'wiz' ); ?>"> 

		</form>
		</div>
		<?php
		echo $after_widget;
	}

	function update( $new_instance, $old_instance ) {
		$instance					 = $old_instance;
		$instance[ 'title' ]		 = sanitize_text_field( $new_instance[ 'title' ] );
		$instance[ 'text_code' ]	 = $new_instance[ 'text_code' ];
		$instance[ 'feedburner' ]	 = sanitize_text_field( $new_instance[ 'feedburner' ] );
		return $instance;
	}

	function form( $instance ) {
		$defaults	 = array( 'title' => __( 'FeedBurner Widget', 'wiz' ), 'text_code' => __( 'Subscribe to our email newsletter.', 'wiz' ), 'feedburner' => '' );
		$instance	 = wp_parse_args( (array) $instance, $defaults );
		?>

		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>">Title : </label>
			<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance[ 'title' ]; ?>" class="widefat" type="text" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'text_code' ); ?>">Text above Email Input Field : <small>( support : Html & Shortcodes )</small> </label>
			<textarea rows="5" id="<?php echo $this->get_field_id( 'text_code' ); ?>" name="<?php echo $this->get_field_name( 'text_code' ); ?>" class="widefat" ><?php echo $instance[ 'text_code' ]; ?></textarea>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'feedburner' ); ?>">Feedburner ID : </label>
			<input id="<?php echo $this->get_field_id( 'feedburner' ); ?>" name="<?php echo $this->get_field_name( 'feedburner' ); ?>" value="<?php echo $instance[ 'feedburner' ]; ?>" class="widefat" type="text" />
			<br />
			<small>http://feeds.feedburner.com/<b>Feedburner ID</b></small>
		</p>


		<?php
	}

}

function leap_feedburner_widget() {
	register_widget( 'Leap_Feedburner_Widget' );
}

add_action( 'widgets_init', 'leap_feedburner_widget' );
