<?php

class Leap_Facebook_Like_Widget extends WP_Widget {

    function __construct() {
        $widget_ops = array( 'classname' => 'facebook_like', 'description' => 'Adds support for Facebook Like Box.' );

        $control_ops = array( 'id_base' => 'facebook-like-widget' );

        parent::__construct( 'facebook-like-widget', 'LEAP: Facebook Like Box', $widget_ops, $control_ops );
    }

    function widget( $args, $instance ) {
        extract( $args );

        $defaults = array( 'title' => 'Find us on Facebook', 'page_url' => '', 'app_id' => '', 'tabs' => '', 'width' => '268', 'height' => '280', 'small_header' => false, 'hide_cover' => false, 'show_facepile' => true, 'hide_cta' => false, 'language' => 'en_US' );
        $instance = wp_parse_args( (array) $instance, $defaults );

        $title         = apply_filters( 'widget_title', $instance[ 'title' ], $instance, $this->id_base );
        $page_url      = $instance[ 'page_url' ];
        $app_id        = $instance[ 'app_id' ];
        $tabs          = $instance[ 'tabs' ];
        $width         = $instance[ 'width' ];
        $height        = $instance[ 'height' ];
        $small_header  = $instance[ 'small_header' ] ? 'true' : 'false';
        $hide_cover    = $instance[ 'hide_cover' ] ? 'true' : 'false';
        $show_facepile = $instance[ 'show_facepile' ] ? 'true' : 'false';
        $hide_cta      = $instance[ 'hide_cta' ] ? 'true' : 'false';
        $language      = $instance[ 'language' ];

        echo $before_widget;
        if ( !empty( $title ) ) {
            echo $before_title;
            echo $title;
            echo $after_title;
        }

        if ( $page_url ):
            ?>

            <div id="fb-root"></div>
            <script>( function ( d, s, id ) {
                    var js, fjs = d.getElementsByTagName( s )[0];
                    if ( d.getElementById( id ) )
                        return;
                    js = d.createElement( s );
                    js.id = id;
                    js.src = "//connect.facebook.net/<?php echo esc_attr( $language ); ?>/sdk.js#xfbml=1&version=v2.5&appId=<?php echo esc_attr( $app_id ); ?>";
                        fjs.parentNode.insertBefore( js, fjs );
                }( document, 'script', 'facebook-jssdk' ) );</script>

            <div class="fb-page"
                 data-href="<?php echo esc_url( $page_url ); ?>"
                 data-width="<?php echo esc_attr( $width ); ?>"
                 data-height="<?php echo esc_attr( $height ); ?>"
                 data-tabs="<?php echo esc_attr( $tabs ); ?>"
                 data-small-header="<?php echo $small_header ?>"
                 data-adapt-container-width="true"
                 data-hide-cover="<?php echo $hide_cover ?>"
                 data-show-facepile="<?php echo $show_facepile ?>"
                 data-hide-cta="<?php echo $hide_cta ?>"></div>


            <?php
        endif;

        echo $after_widget;
    }

    function update( $new_instance, $old_instance ) {
        $instance = $old_instance;

        $instance[ 'title' ]         = sanitize_text_field( $new_instance[ 'title' ] );
        $instance[ 'page_url' ]      = esc_url( $new_instance[ 'page_url' ] );
        $instance[ 'app_id' ]        = sanitize_text_field( $new_instance[ 'app_id' ] );
        $instance[ 'tabs' ]          = sanitize_text_field( $new_instance[ 'tabs' ] );
        $instance[ 'width' ]         = absint( $new_instance[ 'width' ] );
        $instance[ 'height' ]        = absint( $new_instance[ 'height' ] );
        $instance[ 'small_header' ]  = isset( $new_instance[ 'small_header' ] );
        $instance[ 'hide_cover' ]    = isset( $new_instance[ 'hide_cover' ] );
        $instance[ 'show_facepile' ] = isset( $new_instance[ 'show_facepile' ] );
        $instance[ 'hide_cta' ]      = isset( $new_instance[ 'hide_cta' ] );
        $instance[ 'language' ]      = sanitize_text_field( $new_instance[ 'language' ] );

        return $instance;
    }

    function form( $instance ) {
        $defaults = array( 'title' => 'Find us on Facebook', 'page_url' => '', 'app_id' => '', 'tabs' => '', 'width' => '268', 'height' => '280', 'small_header' => false, 'hide_cover' => false, 'show_facepile' => true, 'hide_cta' => false, 'language' => 'en_US' );
        $instance = wp_parse_args( (array) $instance, $defaults );
        ?>

        <p>
            <label for="<?php echo $this->get_field_id( 'title' ); ?>">Title:</label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance[ 'title' ]; ?>" />
        </p>

        <p>
            <label for="<?php echo $this->get_field_id( 'page_url' ); ?>">The URL of the Facebook Page:</label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'page_url' ); ?>" name="<?php echo $this->get_field_name( 'page_url' ); ?>" value="<?php echo $instance[ 'page_url' ]; ?>" />
        </p>
        
        <p>
            <label for="<?php echo $this->get_field_id( 'app_id' ); ?>">App Id:</label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'app_id' ); ?>" name="<?php echo $this->get_field_name( 'app_id' ); ?>" value="<?php echo $instance[ 'app_id' ]; ?>" /><br>
            <small>Get Facebook application id from <a target="_blank" href="<?php echo esc_url( 'https://developers.facebook.com/apps/' ) ?>">here</a></small>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id( 'tabs' ); ?>">Tabs:</label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'tabs' ); ?>" name="<?php echo $this->get_field_name( 'tabs' ); ?>" value="<?php echo $instance[ 'tabs' ]; ?>" /><br>
            <small>Tabs to render i.e. timeline, events, messages. Use a comma-separated list to add multiple tabs, i.e. timeline, events.</small>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id( 'width' ); ?>">Width:</label>
            <input type="number" class="widefat" style="width: 50px;" id="<?php echo $this->get_field_id( 'width' ); ?>" name="<?php echo $this->get_field_name( 'width' ); ?>" value="<?php echo $instance[ 'width' ]; ?>" /> px<br>
            <small>The pixel width of the plugin. Min. is 180 & Max. is 500</small>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id( 'height' ); ?>">Height:</label>
            <input type="number" class="widefat" style="width: 50px;" id="<?php echo $this->get_field_id( 'height' ); ?>" name="<?php echo $this->get_field_name( 'height' ); ?>" value="<?php echo $instance[ 'height' ]; ?>" /> px<br>
            <small>The pixel height of the plugin. Min. is 70</small>
        </p>

        <p>
            <input class="checkbox" type="checkbox" <?php checked( $instance[ 'small_header' ], true ); ?> id="<?php echo $this->get_field_id( 'small_header' ); ?>" name="<?php echo $this->get_field_name( 'small_header' ); ?>" /> 
            <label for="<?php echo $this->get_field_id( 'small_header' ); ?>">Use Small Header</label><br>
            <small>Use the small header instead</small>
        </p>

        <p>
            <input class="checkbox" type="checkbox" <?php checked( $instance[ 'hide_cover' ], true ); ?> id="<?php echo $this->get_field_id( 'hide_cover' ); ?>" name="<?php echo $this->get_field_name( 'hide_cover' ); ?>" /> 
            <label for="<?php echo $this->get_field_id( 'hide_cover' ); ?>">Hide Cover</label><br>
            <small>Hide cover photo in the header</small>
        </p>

        <p>
            <input class="checkbox" type="checkbox" <?php checked( $instance[ 'show_facepile' ], true ); ?> id="<?php echo $this->get_field_id( 'show_facepile' ); ?>" name="<?php echo $this->get_field_name( 'show_facepile' ); ?>" /> 
            <label for="<?php echo $this->get_field_id( 'show_facepile' ); ?>">Show profile photos</label><br>
            <small>Show profile photos when friends like this</small>
        </p>

        <p>
            <input class="checkbox" type="checkbox" <?php checked( $instance[ 'hide_cta' ], true ); ?> id="<?php echo $this->get_field_id( 'hide_cta' ); ?>" name="<?php echo $this->get_field_name( 'hide_cta' ); ?>" /> 
            <label for="<?php echo $this->get_field_id( 'hide_cta' ); ?>">Hide call to action</label><br>
            <small>Hide the custom call to action button (if available)</small>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id( 'language' ); ?>">Language:</label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'language' ); ?>" name="<?php echo $this->get_field_name( 'language' ); ?>" value="<?php echo $instance[ 'language' ]; ?>" /><br>
            <small>Supported locales are referenced in the <a href="<?php echo esc_url( 'https://www.facebook.com/translations/FacebookLocales.xml' ); ?>" target="_blank">Facebook Locales XML file</a>. </small>
        </p>
        <?php
    }

}

function leap_facebook_like_load_widgets() {
    register_widget( 'Leap_Facebook_Like_Widget' );
}

add_action( 'widgets_init', 'leap_facebook_like_load_widgets' );
