<?php

class Leap_Contact_Info_Widget extends WP_Widget {

	function __construct() {
		$widget_ops	 = array( 'classname' => 'contact_info', 'description' => '' );
		$control_ops = array( 'id_base' => 'contact_info-widget' );
		parent::__construct( 'contact_info-widget', 'LEAP: Contact Info', $widget_ops, $control_ops );
	}

	function widget( $args, $instance ) {
		extract( $args );
		
		$defaults	 = array(
			'title'		 => 'Contact Info',
			'address'	 => '',
			'phone'		 => '',
			'mobile'	 => '',
			'fax'		 => '',
			'email'		 => '',
			'emailtxt'	 => '',
			'web'		 => '',
			'webtxt'	 => ''
		);
		$instance	 = wp_parse_args( (array) $instance, $defaults );
		
		$title = apply_filters( 'widget_title', $instance[ 'title' ], $instance, $this->id_base );

		echo $before_widget;
		if ( !empty( $title ) ) {
			echo $before_title;
			echo $title;
			echo $after_title;
		}
		?>
		<?php if ( $instance[ 'address' ] ): ?>
			<div class="address"><i class="fa fa-home"></i> <span><?php _e( 'Address', 'wiz' ); ?>:</span> <?php echo $instance[ 'address' ]; ?></div>
		<?php endif; ?>

		<?php if ( $instance[ 'phone' ] ): ?>
			<div class="phone"><i class="fa fa-phone"></i> <span><?php _e( 'Phone', 'wiz' ); ?>:</span> <?php echo $instance[ 'phone' ]; ?></div>
		<?php endif; ?>

		<?php if ( $instance[ 'mobile' ] ): ?>
			<div class="mobile"><i class="fa fa-mobile"></i> <span><?php _e( 'Mobile', 'wiz' ); ?>:</span> <?php echo $instance[ 'mobile' ]; ?></div>
		<?php endif; ?>

		<?php if ( $instance[ 'fax' ] ): ?>
			<div class="fax"><i class="fa fa-envelope-o"></i> <span><?php _e( 'Fax', 'wiz' ); ?>:</span> <?php echo $instance[ 'fax' ]; ?></div>
		<?php endif; ?>

		<?php if ( $instance[ 'email' ] ): ?>
			<div class="email"><i class="fa fa-envelope"></i> <span><?php _e( 'Email', 'wiz' ); ?>:</span> <a href="mailto:<?php echo $instance[ 'email' ]; ?>"><?php
					if ( $instance[ 'emailtxt' ] ) {
						echo $instance[ 'emailtxt' ];
					} else {
						echo $instance[ 'email' ];
					}
					?></a></div>
		<?php endif; ?>

		<?php if ( $instance[ 'web' ] ): ?>
			<div class="web"><i class="fa fa-globe"></i> <span><?php _e( 'Website', 'wiz' ); ?>:</span>  <a href="<?php echo $instance[ 'web' ]; ?>"><?php
					if ( $instance[ 'webtxt' ] ) {
						echo $instance[ 'webtxt' ];
					} else {
						echo $instance[ 'web' ];
					}
					?></a></div>
		<?php endif; ?>
		<?php
		echo $after_widget;
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		$instance[ 'title' ]	 = sanitize_text_field($new_instance[ 'title' ]);
		$instance[ 'address' ]	 = sanitize_text_field($new_instance[ 'address' ]);
		$instance[ 'phone' ]	 = sanitize_text_field($new_instance[ 'phone' ]);
		$instance[ 'mobile' ]	 = sanitize_text_field($new_instance[ 'mobile' ]);
		$instance[ 'fax' ]		 = sanitize_text_field($new_instance[ 'fax' ]);
		$instance[ 'email' ]	 = sanitize_email($new_instance[ 'email' ]);
		$instance[ 'emailtxt' ]	 = sanitize_text_field($new_instance[ 'emailtxt' ]);
		$instance[ 'web' ]		 = esc_url($new_instance[ 'web' ]);
		$instance[ 'webtxt' ]	 = sanitize_text_field($new_instance[ 'webtxt' ]);

		return $instance;
	}

	function form( $instance ) {
		$defaults	 = array(
			'title'		 => 'Contact Info',
			'address'	 => '',
			'phone'		 => '',
			'mobile'	 => '',
			'fax'		 => '',
			'email'		 => '',
			'emailtxt'	 => '',
			'web'		 => '',
			'webtxt'	 => ''
		);
		$instance	 = wp_parse_args( (array) $instance, $defaults );
		?>
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>">Title:</label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance[ 'title' ]; ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'address' ); ?>">Address:</label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'address' ); ?>" name="<?php echo $this->get_field_name( 'address' ); ?>" value="<?php echo $instance[ 'address' ]; ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'phone' ); ?>">Phone:</label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'phone' ); ?>" name="<?php echo $this->get_field_name( 'phone' ); ?>" value="<?php echo $instance[ 'phone' ]; ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'mobile' ); ?>">Mobile:</label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'mobile' ); ?>" name="<?php echo $this->get_field_name( 'mobile' ); ?>" value="<?php echo $instance[ 'mobile' ]; ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'fax' ); ?>">Fax:</label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'fax' ); ?>" name="<?php echo $this->get_field_name( 'fax' ); ?>" value="<?php echo $instance[ 'fax' ]; ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'email' ); ?>">Email:</label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'email' ); ?>" name="<?php echo $this->get_field_name( 'email' ); ?>" value="<?php echo $instance[ 'email' ]; ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'emailtxt' ); ?>">Email Link Text:</label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'emailtxt' ); ?>" name="<?php echo $this->get_field_name( 'emailtxt' ); ?>" value="<?php echo $instance[ 'emailtxt' ]; ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'web' ); ?>">Website URL (with HTTP):</label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'web' ); ?>" name="<?php echo $this->get_field_name( 'web' ); ?>" value="<?php echo $instance[ 'web' ]; ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'webtxt' ); ?>">Website URL Text:</label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'webtxt' ); ?>" name="<?php echo $this->get_field_name( 'webtxt' ); ?>" value="<?php echo $instance[ 'webtxt' ]; ?>" />
		</p>
		<?php
	}

}

function leap_contact_info_load_widgets() {
	register_widget( 'Leap_Contact_Info_Widget' );
}

add_action( 'widgets_init', 'leap_contact_info_load_widgets' );