<?php

class Leap_Comments_Avatar_Widget extends WP_Widget {

	function __construct() {
		$widget_ops	 = array( 'classname' => 'comments-avatar' );
		$control_ops = array( 'width' => 250, 'height' => 350, 'id_base' => 'comments_avatar-widget' );
		parent::__construct( 'comments_avatar-widget', 'LEAP: Recent Comments with avatar', $widget_ops, $control_ops );
	}

	function widget( $args, $instance ) {
		extract( $args );
		
		$defaults	 = array( 'title' => __( 'Recent Comments', 'wiz' ), 'no_of_comments' => '5', 'avatar_size' => '50' );
		$instance	 = wp_parse_args( (array) $instance, $defaults );

		$title			 = apply_filters( 'widget_title', $instance[ 'title' ], $instance, $this->id_base );
		$no_of_comments	 = $instance[ 'no_of_comments' ];
		$avatar_size	 = $instance[ 'avatar_size' ];

		echo $before_widget;
		if ( !empty( $title ) ) {
			echo $before_title;
			echo $title;
			echo $after_title;
		}
		?>
		<ul>	
			<?php $this->get_recent_commented( $no_of_comments, $avatar_size ); ?>
		</ul>
		<?php
		echo $after_widget;
	}

	function update( $new_instance, $old_instance ) {
		$instance						 = $old_instance;
		$instance[ 'title' ]			 = sanitize_text_field( $new_instance[ 'title' ] );
		$instance[ 'no_of_comments' ]	 = absint( $new_instance[ 'no_of_comments' ] );
		$instance[ 'avatar_size' ]		 = absint( $new_instance[ 'avatar_size' ] );
		return $instance;
	}

	function form( $instance ) {
		$defaults	 = array( 'title' => __( 'Recent Comments', 'wiz' ), 'no_of_comments' => '5', 'avatar_size' => '50' );
		$instance	 = wp_parse_args( (array) $instance, $defaults );
		?>

		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>">Title : </label>
			<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance[ 'title' ]; ?>" class="widefat" type="text" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'avatar_size' ); ?>"> Avatar Size : </label>
			<input id="<?php echo $this->get_field_id( 'avatar_size' ); ?>" name="<?php echo $this->get_field_name( 'avatar_size' ); ?>" value="<?php echo $instance[ 'avatar_size' ]; ?>"  type="text" size="3" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'no_of_comments' ); ?>">Number of comments to show:  </label>
			<input id="<?php echo $this->get_field_id( 'no_of_comments' ); ?>" name="<?php echo $this->get_field_name( 'no_of_comments' ); ?>" value="<?php echo $instance[ 'no_of_comments' ]; ?>" type="text" size="3" />
		</p>


		<?php
	}

	/* ----------------------------------------------------------------------------------- */
# Get commented posts 
	/* ----------------------------------------------------------------------------------- */

	function get_recent_commented( $comment_posts = 5, $avatar_size = 50 ) {
		$comments = get_comments( 'status=approve&number=' . $comment_posts );
		foreach ( $comments as $comment ) {
			?>
			<li>
				<div class="wdg-post">
					<?php echo get_avatar( $comment, $avatar_size ); ?>
				</div>
				<a href="<?php echo get_permalink( $comment->comment_post_ID ); ?>#comment-<?php echo $comment->comment_ID; ?>">
					<?php echo strip_tags( $comment->comment_author ); ?>: <?php echo wp_html_excerpt( $comment->comment_content, 60, '...' ); ?> </a>
			</li>
			<?php
		}
	}

}

function leap_comments_avatar_widget() {
	register_widget( 'Leap_Comments_Avatar_Widget' );
}

add_action( 'widgets_init', 'leap_comments_avatar_widget' );
