<?php

class Leap_Category_Tree_Widget extends WP_Widget {

    function __construct() {
        $widget_ops  = array( 'classname' => 'category-posts' );
        $control_ops = array( 'width' => 250, 'height' => 350, 'id_base' => 'category-tree-widget' );
        parent::__construct( 'category-tree-widget', 'LEAP: Category Tree', $widget_ops, $control_ops );
    }

    function widget( $args, $instance ) {
        extract( $args );

        $defaults = array( 'title' => __( 'Category Tree', 'wiz' ), 'cats_id' => '1' );
        $instance = wp_parse_args( (array) $instance, $defaults );

        $title       = apply_filters( 'widget_title', $instance[ 'title' ], $instance, $this->id_base );
        $cat_id      = $instance[ 'cat_id' ];

        echo $before_widget;
        if ( !empty( $title ) ) {
            echo $before_title;
            echo $title;
            echo $after_title;
        }
        ?>

        <?php $this->hierarchical_category_tree( $cat_id ); ?>


        <div class="clear"></div>
        <?php
        echo $after_widget;
    }

    function update( $new_instance, $old_instance ) {
        $instance                  = $old_instance;
        $instance[ 'title' ]       = sanitize_text_field( $new_instance[ 'title' ] );
        $instance[ 'cat_id' ]      = absint( $new_instance[ 'cat_id' ] );
        return $instance;
    }

    function form( $instance ) {
        $defaults = array( 'title' => __( 'Category Posts', 'wiz' ), 'cat_id' => '1' );
        $instance = wp_parse_args( (array) $instance, $defaults );

        $categories_obj = get_categories();
        $categories     = array();

        foreach ( $categories_obj as $pn_cat ) {
            $categories[ $pn_cat->cat_ID ] = $pn_cat->cat_name;
        }
        ?>

        <p>
            <label for="<?php echo $this->get_field_id( 'title' ); ?>">Title : </label>
            <input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance[ 'title' ]; ?>" class="widefat" type="text" />
        </p>
        <p>
            <?php $cats_id = explode( ',', $instance[ 'cat_id' ] ); ?>
            <label for="<?php echo $this->get_field_id( 'cat_id' ); ?>">Category : </label>
            <select id="<?php echo $this->get_field_id( 'cat_id' ); ?>" name="<?php echo $this->get_field_name( 'cat_id' ); ?>">
                <?php foreach ( $categories as $key => $option ) { ?>
                    <option value="<?php echo $key ?>" <?php
                    if ( in_array( $key, $cats_id ) ) {
                        echo ' selected="selected"';
                    }
                    ?>><?php echo $option; ?></option>
                        <?php } ?>
            </select>
        </p>

        <?php
    }

    function category_has_children( $cat_id = 0 ) {
        $childrens = get_categories( array( 'child_of' => 0, 'parent' => $cat_id, 'hide_empty' => 0 ) );
        if ( count( $childrens ) > 0 ) {
            return true;
        }
        return false;
    }

    function hierarchical_category_tree( $cat ) {

        $next = get_categories( 'hide_empty=false&parent=' . $cat );

        if ( $next ) {
            echo '<ul class="cats-tree">';
            foreach ( $next as $cat ) {
                echo '<li class="child-cat">';
                echo '<a href="' . get_category_link( $cat->term_id ) . '" title="' . $cat->name . '" ' . '> ' . $cat->name . '</a>  ';
                if ( $this->category_has_children( $cat->term_id ) ) {
                    $this->hierarchical_category_tree( $cat->term_id );
                } else {
                    $this->wp_last_posts_cat( $cat->term_id );
                }
            }
            echo '</li>';
            echo '</ul>';
        }
    }
    
    function wp_last_posts_cat( $cats = 1 ) {
        global $post;
        $orig_post = $post;
        $lastPosts = get_posts( 'category=' . $cats . '&numberposts=-1' );
        ?>
        <ul class="posts-tree">
            <?php
            foreach ( $lastPosts as $post ): setup_postdata( $post );
                ?>
                <li class="child-post"><a href="<?php the_permalink(); ?>" title="<?php echo the_title_attribute( 'echo=0' ); ?>"><?php echo esc_html( get_the_title() ); ?></a></li>
                <?php
            endforeach;
            ?>
        </ul>
        <?php
        $post = $orig_post;
    }

}

function leap_category_tree_widget() {
    register_widget( 'Leap_Category_Tree_Widget' );
}

add_action( 'widgets_init', 'leap_category_tree_widget' );
