<?php

class Leap_Category_Posts_Widget extends WP_Widget {

    function __construct() {
        $widget_ops  = array( 'classname' => 'category-posts' );
        $control_ops = array( 'width' => 250, 'height' => 350, 'id_base' => 'category-posts-widget' );
        parent::__construct( 'category-posts-widget', 'LEAP: Category Posts List', $widget_ops, $control_ops );
    }

    function widget( $args, $instance ) {
        extract( $args );

        $defaults = array( 'title' => __( 'Category Posts', 'wiz' ), 'no_of_posts' => '5', 'cats_id' => '1', 'thumb' => 'true', 'date' => 'true' );
        $instance = wp_parse_args( (array) $instance, $defaults );

        $title       = apply_filters( 'widget_title', $instance[ 'title' ], $instance, $this->id_base );
        $no_of_posts = $instance[ 'no_of_posts' ];
        $cats_id     = $instance[ 'cats_id' ];
        $thumb       = $instance[ 'thumb' ];
        $date        = $instance[ 'date' ];

        echo $before_widget;
        if ( !empty( $title ) ) {
            echo $before_title;
            echo $title;
            echo $after_title;
        }
        ?>
        <ul>
            <?php $this->wp_last_posts_cat( $no_of_posts, $thumb, $cats_id, $date ) ?>	
        </ul>
        <div class="clear"></div>
        <?php
        echo $after_widget;
    }

    function update( $new_instance, $old_instance ) {
        $instance                  = $old_instance;
        $instance[ 'title' ]       = sanitize_text_field( $new_instance[ 'title' ] );
        $instance[ 'no_of_posts' ] = absint( $new_instance[ 'no_of_posts' ] );
        $instance[ 'cats_id' ]     = implode( ',', array_map( 'absint', $new_instance[ 'cats_id' ] ) );
        $instance[ 'thumb' ]       = isset( $new_instance[ 'thumb' ] );
        $instance[ 'date' ]        = isset( $new_instance[ 'date' ] );
        return $instance;
    }

    function form( $instance ) {
        $defaults = array( 'title' => __( 'Category Posts', 'wiz' ), 'no_of_posts' => '5', 'cats_id' => '1', 'thumb' => 'true', 'date' => 'true' );
        $instance = wp_parse_args( (array) $instance, $defaults );

        $categories_obj = get_categories();
        $categories     = array();

        foreach ( $categories_obj as $pn_cat ) {
            $categories[ $pn_cat->cat_ID ] = $pn_cat->cat_name;
        }
        ?>

        <p>
            <label for="<?php echo $this->get_field_id( 'title' ); ?>">Title : </label>
            <input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance[ 'title' ]; ?>" class="widefat" type="text" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id( 'no_of_posts' ); ?>">Number of posts to show: </label>
            <input id="<?php echo $this->get_field_id( 'no_of_posts' ); ?>" name="<?php echo $this->get_field_name( 'no_of_posts' ); ?>" value="<?php echo $instance[ 'no_of_posts' ]; ?>" type="text" size="3" />
        </p>
        <p>
            <?php $cats_id = explode( ',', $instance[ 'cats_id' ] ); ?>
            <label for="<?php echo $this->get_field_id( 'cats_id' ); ?>">Category : </label>
            <select multiple="multiple" id="<?php echo $this->get_field_id( 'cats_id' ); ?>[]" name="<?php echo $this->get_field_name( 'cats_id' ); ?>[]">
                <?php foreach ( $categories as $key => $option ) { ?>
                    <option value="<?php echo $key ?>" <?php
                    if ( in_array( $key, $cats_id ) ) {
                        echo ' selected="selected"';
                    }
                    ?>><?php echo $option; ?></option>
                        <?php } ?>
            </select>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id( 'thumb' ); ?>">Display Thumbinals : </label>
            <input id="<?php echo $this->get_field_id( 'thumb' ); ?>" name="<?php echo $this->get_field_name( 'thumb' ); ?>" value="true" <?php if ( $instance[ 'thumb' ] ) echo 'checked="checked"'; ?> type="checkbox" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id( 'date' ); ?>">Display Date : </label>
            <input id="<?php echo $this->get_field_id( 'date' ); ?>" name="<?php echo $this->get_field_name( 'date' ); ?>" value="true" <?php if ( $instance[ 'date' ] ) echo 'checked="checked"'; ?> type="checkbox" />
        </p>

        <?php
    }

    /* ----------------------------------------------------------------------------------- */
# Get Most Racent posts from Category
    /* ----------------------------------------------------------------------------------- */

    function wp_last_posts_cat( $numberOfPosts = 5, $thumb = true, $cats = 1,
                                $date = true ) {
        global $post;
        $orig_post = $post;
        if ( !$numberOfPosts ) {
            $numberOfPosts = 5;
        }
        $lastPosts = get_posts( 'category=' . $cats . '&numberposts=' . $numberOfPosts );
        foreach ( $lastPosts as $post ): setup_postdata( $post );
            ?>
            <li <?php echo ($thumb ? 'class="thumb"' : ''); ?> >
                <?php if ( function_exists( "has_post_thumbnail" ) && has_post_thumbnail() && $thumb ) : ?>			
                    <div class="wdg-post">
                        <a href="<?php the_permalink(); ?>" title="<?php echo the_title_attribute( 'echo=0' ); ?>"><?php the_post_thumbnail( 'leap-thumbnail' ); ?></a>
                    </div><!-- wdg-post /-->
                <?php endif; ?>
                <div class="wdg-posttitle"><a href="<?php the_permalink(); ?>" title="<?php echo the_title_attribute( 'echo=0' ); ?>"><?php echo esc_html( get_the_title() ); ?></a></div>
                <?php if ( $date ) { ?>
                    <small class="small"><?php echo get_the_date(); ?></small>
                <?php } ?>
            </li>
            <?php
        endforeach;
        $post = $orig_post;
    }

}

function leap_category_posts_widget() {
    register_widget( 'Leap_Category_Posts_Widget' );
}

add_action( 'widgets_init', 'leap_category_posts_widget' );
