<?php

class Leap_Author_Post_Widget extends WP_Widget {

    function __construct() {
        $widget_ops = array( 'classname' => 'widget_author_posts' );
        parent::__construct( 'author_post_widget', 'LEAP: Posts By Post Author', $widget_ops );
    }

    function widget( $args, $instance ) {
        extract( $args );

        $defaults = array( 'no_of_posts' => '5', 'see_all' => 'true' );
        $instance = wp_parse_args( (array) $instance, $defaults );

        if ( is_single() ) {

            $no_of_posts = $instance[ 'no_of_posts' ];
            $see_all     = $instance[ 'see_all' ];

            //$postid = get_the_ID();
            $authorID = get_the_author_meta( 'ID' );
            if ( !$no_of_posts ) {
                $no_of_posts = 5;
            }
            $args     = array( 'author' => $authorID, 'post__not_in' => array( get_the_ID() ), 'posts_per_page' => $no_of_posts );
            $my_query = new wp_query( $args );
            if ( $my_query->have_posts() ) {
                echo $before_widget;
                echo $before_title;
                printf( __( 'By %s', 'wiz' ), esc_html( get_the_author() ) );
                echo $after_title;
                ?>
                <ul>
                    <?php
                    while ( $my_query->have_posts() ) {
                        $my_query->the_post();
                        ?>
                        <li><a href="<?php the_permalink() ?>" title="<?php echo the_title_attribute( 'echo=0' ); ?>"><?php echo esc_html( get_the_title() ); ?></a></li>
                    <?php } ?>
                </ul>
                <?php if ( $see_all ) : ?>
                    <a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"> <?php _e( 'All', 'wiz' ) ?> (<?php echo count_user_posts( $authorID ) ?>)</a>
                <?php endif; ?>

                <?php
                wp_reset_postdata();
                echo $after_widget;
            }
        }
    }

    function update( $new_instance, $old_instance ) {
        $instance                  = $old_instance;
        $instance[ 'no_of_posts' ] = absint( $new_instance[ 'no_of_posts' ] );
        $instance[ 'see_all' ]     = isset( $new_instance[ 'see_all' ] );
        return $instance;
    }

    function form( $instance ) {
        $defaults = array( 'no_of_posts' => '5', 'see_all' => 'true' );
        $instance = wp_parse_args( (array) $instance, $defaults );
        ?>

        <p><em style="color:red;">This Widget appears in single post only.</em></p>

        <p>
            <label for="<?php echo $this->get_field_id( 'no_of_posts' ); ?>">Number of posts to show: </label>
            <input id="<?php echo $this->get_field_id( 'no_of_posts' ); ?>" name="<?php echo $this->get_field_name( 'no_of_posts' ); ?>" value="<?php echo esc_attr( $instance[ 'no_of_posts' ] ); ?>" type="text" size="3" />
        </p>

        <p>
            <label for="<?php echo $this->get_field_id( 'see_all' ); ?>">Display ( see all ) link : </label>
            <input id="<?php echo $this->get_field_id( 'see_all' ); ?>" name="<?php echo $this->get_field_name( 'see_all' ); ?>" value="true" <?php if ( $instance[ 'see_all' ] ) echo 'checked="checked"'; ?> type="checkbox" />
        </p>

        <?php
    }

}

function leap_author_post_widget_box() {
    register_widget( 'Leap_Author_Post_Widget' );
}

add_action( 'widgets_init', 'leap_author_post_widget_box' );
