<?php

if ( !defined( 'ABSPATH' ) ) {
    die( 'No direct access allowed' );
}

/**
 * Register widget positions styler post type
 */
       
function leap_sidebar_post_type() {
    $regsiter_post_type = 'register_' . 'post_type';
    $regsiter_post_type( 'leap-sidebar-style', array(
        'labels'              => array(
            'name'               => __( 'Widget Positions Styler', 'wiz' ),
            'singular_name'      => __( 'Widget Positions Style', 'wiz' ),
            'add_new'            => __( 'Add New', 'wiz' ),
            'add_new_item'       => __( 'Add New', 'wiz' ),
            'edit'               => __( 'Edit', 'wiz' ),
            'edit_item'          => __( 'Edit', 'wiz' ),
            'new_item'           => __( 'New', 'wiz' ),
            'view'               => __( 'View', 'wiz' ),
            'view_item'          => __( 'View', 'wiz' ),
            'search_items'       => __( 'Search', 'wiz' ),
            'not_found'          => __( 'No widget positions styles found', 'wiz' ),
            'not_found_in_trash' => __( 'No widget positions styles found in Trash', 'wiz' ),
            'parent'             => __( 'Parent', 'wiz' )
        ),
        'public'              => false,
        'exclude_from_search' => true,
        'publicly_queryable'  => false,
        'show_ui'             => true,
        'show_in_menu'        => 'themes.php',
        'menu_position'       => 20,
        'supports'            => array( 'title' ),
        'rewrite'             => false,
        'can_export'          => true,
        'has_archive'         => true
    )
    );
}

add_action( 'init', 'leap_sidebar_post_type' );

/**
 * Remove the slug div on widget positions post type
 * as it may cause conflict to customers
 */
function leap_sidebar_style_remove_slug_div() {
    global $post;
    if ( is_admin() && (get_post_type( $post ) == 'leap_sidebar_style') ) {
        echo '<style type="text/css"> #edit-slug-box { display: none; }</style>';
    }
}

add_action( 'admin_head', 'leap_sidebar_style_remove_slug_div' );

/**
 * Register meta boxes for widget positions
 */
function _leap_sidebars_styles_meta_box() {

    $leap_sidebars_styles_meta_box_side = array(
        'id'       => 'leap_sidebars_styles_meta_box',
        'title'    => 'Widget Positions Styles',
        'desc'     => '',
        'pages'    => array( 'page', 'post', 'leap-portfolio' ),
        'context'  => 'side',
        'priority' => 'low',
        'fields'   => array(
            array(
                'id'           => 'leap_sidebars_style',
                'label'        => 'Choose Widget Positions Style',
                'desc'         => '',
                'std'          => '',
                'type'         => 'custom-post-type-select',
                'rows'         => '',
                'post_type'    => 'leap-sidebar-style',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'remove-border',
                'condition'    => '',
                'operator'     => 'and'
            )
        )
    );

    $leap_sidebars_styles_meta_box = array(
        'id'       => 'leap_widget_positions_meta_box',
        'title'    => 'Leap Widget Positions Styles',
        'desc'     => '',
        'pages'    => array( 'leap-sidebar-style' ),
        'context'  => 'normal',
        'priority' => 'high',
        'fields'   => array(
            array(
                'id'           => 'tab_leap_sidebar_header',
                'label'        => 'Header',
                'desc'         => '',
                'std'          => '',
                'type'         => 'tab',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_desc_header_widget_position',
                'label'        => 'Header Widget Position',
                'desc'         => 'Header Widget Position',
                'std'          => '',
                'type'         => 'textblock',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'title-block',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_header_sidebar_background',
                'label'        => 'Background',
                'desc'         => '',
                'std'          => '',
                'type'         => 'background',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_header_sidebar_parallax_background_image',
                'label'        => 'Parallax Background Image',
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'select',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Default',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'on',
                        'label' => 'On',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'off',
                        'label' => 'Off',
                        'src'   => ''
                    )
                ),
            ),
            array(
                'id'           => 'leap_header_sidebar_typography',
                'label'        => 'Typography',
                'desc'         => '',
                'std'          => '',
                'type'         => 'typography',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_header_sidebar_widget_title_typography',
                'label'        => 'Widget Title Typography',
                'desc'         => '',
                'std'          => '',
                'type'         => 'typography',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_header_sidebar_meta_color',
                'label'        => 'Meta Typography',
                'desc'         => 'Used for date, author, categories, tags, comments,... etc.',
                'std'          => '',
                'type'         => 'colorpicker',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_header_sidebar_links_color',
                'label'        => 'Links Color',
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_header_sidebar_list_divider_color',
                'label'        => 'List Divider Color',
                'desc'         => '',
                'std'          => '',
                'type'         => 'colorpicker',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_header_sidebar_button_color_options',
                'label'        => 'Button Color Options',
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_header_sidebar_button_radius',
                'label'        => 'Button Radius',
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'select',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Default',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'on',
                        'label' => 'On',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'off',
                        'label' => 'Off',
                        'src'   => ''
                    )
                ),
            ),
            array(
                'id'           => 'leap_header_sidebar_input_color_options',
                'label'        => 'Input Color Options',
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_header_sidebar_spacing',
                'label'        => 'Sidebar Spacing',
                'desc'         => '',
                'std'          => '',
                'type'         => 'spacing',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_header_sidebar_top_border',
                'label'        => 'Top Border',
                'desc'         => '',
                'std'          => '',
                'type'         => 'border',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_header_sidebar_bottom_border',
                'label'        => 'Bottom Border',
                'desc'         => '',
                'std'          => '',
                'type'         => 'border',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'tab_leap_sidebar_maintop',
                'label'        => 'Main Top',
                'desc'         => '',
                'std'          => '',
                'type'         => 'tab',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_desc_maintop_widget_position',
                'label'        => 'Main Top Widget Position',
                'desc'         => 'Main Top Widget Position',
                'std'          => '',
                'type'         => 'textblock',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'title-block',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_maintop_sidebar_background',
                'label'        => 'Background',
                'desc'         => '',
                'std'          => '',
                'type'         => 'background',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_maintop_sidebar_parallax_background_image',
                'label'        => 'Parallax Background Image',
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'select',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Default',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'on',
                        'label' => 'On',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'off',
                        'label' => 'Off',
                        'src'   => ''
                    )
                ),
            ),
            array(
                'id'           => 'leap_maintop_sidebar_typography',
                'label'        => 'Typography',
                'desc'         => '',
                'std'          => '',
                'type'         => 'typography',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_maintop_sidebar_widget_title_typography',
                'label'        => 'Widget Title Typography',
                'desc'         => '',
                'std'          => '',
                'type'         => 'typography',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_maintop_sidebar_meta_color',
                'label'        => 'Meta Typography',
                'desc'         => 'Used for date, author, categories, tags, comments,... etc.',
                'std'          => '',
                'type'         => 'colorpicker',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_maintop_sidebar_links_color',
                'label'        => 'Links Color',
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_maintop_sidebar_list_divider_color',
                'label'        => 'List Divider Color',
                'desc'         => '',
                'std'          => '',
                'type'         => 'colorpicker',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_maintop_sidebar_button_color_options',
                'label'        => 'Button Color Options',
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_maintop_sidebar_button_radius',
                'label'        => 'Button Radius',
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'select',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Default',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'on',
                        'label' => 'On',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'off',
                        'label' => 'Off',
                        'src'   => ''
                    )
                ),
            ),
            array(
                'id'           => 'leap_maintop_sidebar_input_color_options',
                'label'        => 'Input Color Options',
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_maintop_sidebar_spacing',
                'label'        => 'Sidebar Spacing',
                'desc'         => '',
                'std'          => '',
                'type'         => 'spacing',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_maintop_sidebar_top_border',
                'label'        => 'Top Border',
                'desc'         => '',
                'std'          => '',
                'type'         => 'border',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_maintop_sidebar_bottom_border',
                'label'        => 'Bottom Border',
                'desc'         => '',
                'std'          => '',
                'type'         => 'border',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'tab_leap_sidebar_headerfull',
                'label'        => 'Header Full Width',
                'desc'         => '',
                'std'          => '',
                'type'         => 'tab',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_desc_headerfull_widget_position',
                'label'        => 'Header Full Width Widget Position',
                'desc'         => 'Header Full Width Widget Position',
                'std'          => '',
                'type'         => 'textblock',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'title-block',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_headerfull_sidebar_background',
                'label'        => 'Background',
                'desc'         => '',
                'std'          => '',
                'type'         => 'background',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_headerfull_sidebar_parallax_background_image',
                'label'        => 'Parallax Background Image',
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'select',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Default',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'on',
                        'label' => 'On',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'off',
                        'label' => 'Off',
                        'src'   => ''
                    )
                ),
            ),
            array(
                'id'           => 'leap_headerfull_sidebar_typography',
                'label'        => 'Typography',
                'desc'         => '',
                'std'          => '',
                'type'         => 'typography',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_headerfull_sidebar_widget_title_typography',
                'label'        => 'Widget Title Typography',
                'desc'         => '',
                'std'          => '',
                'type'         => 'typography',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_headerfull_sidebar_meta_color',
                'label'        => 'Meta Typography',
                'desc'         => 'Used for date, author, categories, tags, comments,... etc.',
                'std'          => '',
                'type'         => 'colorpicker',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_headerfull_sidebar_links_color',
                'label'        => 'Links Color',
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_headerfull_sidebar_list_divider_color',
                'label'        => 'List Divider Color',
                'desc'         => '',
                'std'          => '',
                'type'         => 'colorpicker',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_headerfull_sidebar_button_color_options',
                'label'        => 'Button Color Options',
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_headerfull_sidebar_button_radius',
                'label'        => 'Button Radius',
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'select',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Default',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'on',
                        'label' => 'On',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'off',
                        'label' => 'Off',
                        'src'   => ''
                    )
                ),
            ),
            array(
                'id'           => 'leap_headerfull_sidebar_input_color_options',
                'label'        => 'Input Color Options',
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_headerfull_sidebar_spacing',
                'label'        => 'Sidebar Spacing',
                'desc'         => '',
                'std'          => '',
                'type'         => 'spacing',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_headerfull_sidebar_top_border',
                'label'        => 'Top Border',
                'desc'         => '',
                'std'          => '',
                'type'         => 'border',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_headerfull_sidebar_bottom_border',
                'label'        => 'Bottom Border',
                'desc'         => '',
                'std'          => '',
                'type'         => 'border',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'tab_leap_sidebar_maincontenttop',
                'label'        => 'Main Content Top',
                'desc'         => '',
                'std'          => '',
                'type'         => 'tab',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_desc_maincontenttop_widget_position',
                'label'        => 'Main Content Top Widget Position',
                'desc'         => 'Main Content Top Widget Position',
                'std'          => '',
                'type'         => 'textblock',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'title-block',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_maincontenttop_sidebar_background',
                'label'        => 'Background',
                'desc'         => '',
                'std'          => '',
                'type'         => 'background',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_maincontenttop_sidebar_parallax_background_image',
                'label'        => 'Parallax Background Image',
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'select',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Default',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'on',
                        'label' => 'On',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'off',
                        'label' => 'Off',
                        'src'   => ''
                    )
                ),
            ),
            array(
                'id'           => 'leap_maincontenttop_sidebar_typography',
                'label'        => 'Typography',
                'desc'         => '',
                'std'          => '',
                'type'         => 'typography',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_maincontenttop_sidebar_widget_title_typography',
                'label'        => 'Widget Title Typography',
                'desc'         => '',
                'std'          => '',
                'type'         => 'typography',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_maincontenttop_sidebar_meta_color',
                'label'        => 'Meta Typography',
                'desc'         => 'Used for date, author, categories, tags, comments,... etc.',
                'std'          => '',
                'type'         => 'colorpicker',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_maincontenttop_sidebar_links_color',
                'label'        => 'Links Color',
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_maincontenttop_sidebar_list_divider_color',
                'label'        => 'List Divider Color',
                'desc'         => '',
                'std'          => '',
                'type'         => 'colorpicker',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_maincontenttop_sidebar_button_color_options',
                'label'        => 'Button Color Options',
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_maincontenttop_sidebar_button_radius',
                'label'        => 'Button Radius',
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'select',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Default',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'on',
                        'label' => 'On',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'off',
                        'label' => 'Off',
                        'src'   => ''
                    )
                ),
            ),
            array(
                'id'           => 'leap_maincontenttop_sidebar_input_color_options',
                'label'        => 'Input Color Options',
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_maincontenttop_sidebar_spacing',
                'label'        => 'Sidebar Spacing',
                'desc'         => '',
                'std'          => '',
                'type'         => 'spacing',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_maincontenttop_sidebar_top_border',
                'label'        => 'Top Border',
                'desc'         => '',
                'std'          => '',
                'type'         => 'border',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_maincontenttop_sidebar_bottom_border',
                'label'        => 'Bottom Border',
                'desc'         => '',
                'std'          => '',
                'type'         => 'border',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'tab_leap_sidebar_contenttop',
                'label'        => 'Content Top',
                'desc'         => '',
                'std'          => '',
                'type'         => 'tab',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_desc_contenttop_widget_position',
                'label'        => 'Content Top Widget Position',
                'desc'         => 'Content Top Widget Position',
                'std'          => '',
                'type'         => 'textblock',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'title-block',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_contenttop_sidebar_background',
                'label'        => 'Background',
                'desc'         => '',
                'std'          => '',
                'type'         => 'background',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_contenttop_sidebar_parallax_background_image',
                'label'        => 'Parallax Background Image',
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'select',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Default',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'on',
                        'label' => 'On',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'off',
                        'label' => 'Off',
                        'src'   => ''
                    )
                ),
            ),
            array(
                'id'           => 'leap_contenttop_sidebar_typography',
                'label'        => 'Typography',
                'desc'         => '',
                'std'          => '',
                'type'         => 'typography',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_contenttop_sidebar_widget_title_typography',
                'label'        => 'Widget Title Typography',
                'desc'         => '',
                'std'          => '',
                'type'         => 'typography',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_contenttop_sidebar_meta_color',
                'label'        => 'Meta Typography',
                'desc'         => 'Used for date, author, categories, tags, comments,... etc.',
                'std'          => '',
                'type'         => 'colorpicker',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_contenttop_sidebar_links_color',
                'label'        => 'Links Color',
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_contenttop_sidebar_list_divider_color',
                'label'        => 'List Divider Color',
                'desc'         => '',
                'std'          => '',
                'type'         => 'colorpicker',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_contenttop_sidebar_button_color_options',
                'label'        => 'Button Color Options',
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_contenttop_sidebar_button_radius',
                'label'        => 'Button Radius',
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'select',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Default',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'on',
                        'label' => 'On',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'off',
                        'label' => 'Off',
                        'src'   => ''
                    )
                ),
            ),
            array(
                'id'           => 'leap_contenttop_sidebar_input_color_options',
                'label'        => 'Input Color Options',
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_contenttop_sidebar_spacing',
                'label'        => 'Sidebar Spacing',
                'desc'         => '',
                'std'          => '',
                'type'         => 'spacing',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_contenttop_sidebar_top_border',
                'label'        => 'Top Border',
                'desc'         => '',
                'std'          => '',
                'type'         => 'border',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_contenttop_sidebar_bottom_border',
                'label'        => 'Bottom Border',
                'desc'         => '',
                'std'          => '',
                'type'         => 'border',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'tab_leap_sidebar_contentbottom',
                'label'        => 'Content Bottom',
                'desc'         => '',
                'std'          => '',
                'type'         => 'tab',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_desc_contentbottom_widget_position',
                'label'        => 'Content Bottom Widget Position',
                'desc'         => 'Content Bottom Widget Position',
                'std'          => '',
                'type'         => 'textblock',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'title-block',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_contentbottom_sidebar_background',
                'label'        => 'Background',
                'desc'         => '',
                'std'          => '',
                'type'         => 'background',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_contentbottom_sidebar_parallax_background_image',
                'label'        => 'Parallax Background Image',
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'select',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Default',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'on',
                        'label' => 'On',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'off',
                        'label' => 'Off',
                        'src'   => ''
                    )
                ),
            ),
            array(
                'id'           => 'leap_contentbottom_sidebar_typography',
                'label'        => 'Typography',
                'desc'         => '',
                'std'          => '',
                'type'         => 'typography',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_contentbottom_sidebar_widget_title_typography',
                'label'        => 'Widget Title Typography',
                'desc'         => '',
                'std'          => '',
                'type'         => 'typography',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_contentbottom_sidebar_meta_color',
                'label'        => 'Meta Typography',
                'desc'         => 'Used for date, author, categories, tags, comments,... etc.',
                'std'          => '',
                'type'         => 'colorpicker',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_contentbottom_sidebar_links_color',
                'label'        => 'Links Color',
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_contentbottom_sidebar_list_divider_color',
                'label'        => 'List Divider Color',
                'desc'         => '',
                'std'          => '',
                'type'         => 'colorpicker',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_contentbottom_sidebar_button_color_options',
                'label'        => 'Button Color Options',
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_contentbottom_sidebar_button_radius',
                'label'        => 'Button Radius',
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'select',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Default',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'on',
                        'label' => 'On',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'off',
                        'label' => 'Off',
                        'src'   => ''
                    )
                ),
            ),
            array(
                'id'           => 'leap_contentbottom_sidebar_input_color_options',
                'label'        => 'Input Color Options',
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_contentbottom_sidebar_spacing',
                'label'        => 'Sidebar Spacing',
                'desc'         => '',
                'std'          => '',
                'type'         => 'spacing',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_contentbottom_sidebar_top_border',
                'label'        => 'Top Border',
                'desc'         => '',
                'std'          => '',
                'type'         => 'border',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_contentbottom_sidebar_bottom_border',
                'label'        => 'Bottom Border',
                'desc'         => '',
                'std'          => '',
                'type'         => 'border',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'tab_leap_sidebar_maincontentbottom',
                'label'        => 'Main Content Bottom',
                'desc'         => '',
                'std'          => '',
                'type'         => 'tab',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_desc_maincontentbottom_widget_position',
                'label'        => 'Main Content Bottom Widget Position',
                'desc'         => 'Main Content Bottom Widget Position',
                'std'          => '',
                'type'         => 'textblock',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'title-block',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_maincontentbottom_sidebar_background',
                'label'        => 'Background',
                'desc'         => '',
                'std'          => '',
                'type'         => 'background',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_maincontentbottom_sidebar_parallax_background_image',
                'label'        => 'Parallax Background Image',
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'select',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Default',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'on',
                        'label' => 'On',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'off',
                        'label' => 'Off',
                        'src'   => ''
                    )
                ),
            ),
            array(
                'id'           => 'leap_maincontentbottom_sidebar_typography',
                'label'        => 'Typography',
                'desc'         => '',
                'std'          => '',
                'type'         => 'typography',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_maincontentbottom_sidebar_widget_title_typography',
                'label'        => 'Widget Title Typography',
                'desc'         => '',
                'std'          => '',
                'type'         => 'typography',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_maincontentbottom_sidebar_meta_color',
                'label'        => 'Meta Typography',
                'desc'         => 'Used for date, author, categories, tags, comments,... etc.',
                'std'          => '',
                'type'         => 'colorpicker',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_maincontentbottom_sidebar_links_color',
                'label'        => 'Links Color',
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_maincontentbottom_sidebar_list_divider_color',
                'label'        => 'List Divider Color',
                'desc'         => '',
                'std'          => '',
                'type'         => 'colorpicker',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_maincontentbottom_sidebar_button_color_options',
                'label'        => 'Button Color Options',
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_maincontentbottom_sidebar_button_radius',
                'label'        => 'Button Radius',
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'select',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Default',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'on',
                        'label' => 'On',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'off',
                        'label' => 'Off',
                        'src'   => ''
                    )
                ),
            ),
            array(
                'id'           => 'leap_maincontentbottom_sidebar_input_color_options',
                'label'        => 'Input Color Options',
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_maincontentbottom_sidebar_spacing',
                'label'        => 'Sidebar Spacing',
                'desc'         => '',
                'std'          => '',
                'type'         => 'spacing',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_maincontentbottom_sidebar_top_border',
                'label'        => 'Top Border',
                'desc'         => '',
                'std'          => '',
                'type'         => 'border',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_maincontentbottom_sidebar_bottom_border',
                'label'        => 'Bottom Border',
                'desc'         => '',
                'std'          => '',
                'type'         => 'border',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'tab_leap_sidebar_footerfull',
                'label'        => 'Footer Full Width',
                'desc'         => '',
                'std'          => '',
                'type'         => 'tab',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_desc_footerfull_widget_position',
                'label'        => 'Footer Full Width Widget Position',
                'desc'         => 'Footer Full Width Widget Position',
                'std'          => '',
                'type'         => 'textblock',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'title-block',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_footerfull_sidebar_background',
                'label'        => 'Background',
                'desc'         => '',
                'std'          => '',
                'type'         => 'background',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_footerfull_sidebar_parallax_background_image',
                'label'        => 'Parallax Background Image',
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'select',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Default',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'on',
                        'label' => 'On',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'off',
                        'label' => 'Off',
                        'src'   => ''
                    )
                ),
            ),
            array(
                'id'           => 'leap_footerfull_sidebar_typography',
                'label'        => 'Typography',
                'desc'         => '',
                'std'          => '',
                'type'         => 'typography',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_footerfull_sidebar_widget_title_typography',
                'label'        => 'Widget Title Typography',
                'desc'         => '',
                'std'          => '',
                'type'         => 'typography',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_footerfull_sidebar_meta_color',
                'label'        => 'Meta Typography',
                'desc'         => 'Used for date, author, categories, tags, comments,... etc.',
                'std'          => '',
                'type'         => 'colorpicker',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_footerfull_sidebar_links_color',
                'label'        => 'Links Color',
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_footerfull_sidebar_list_divider_color',
                'label'        => 'List Divider Color',
                'desc'         => '',
                'std'          => '',
                'type'         => 'colorpicker',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_footerfull_sidebar_button_color_options',
                'label'        => 'Button Color Options',
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_footerfull_sidebar_button_radius',
                'label'        => 'Button Radius',
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'select',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Default',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'on',
                        'label' => 'On',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'off',
                        'label' => 'Off',
                        'src'   => ''
                    )
                ),
            ),
            array(
                'id'           => 'leap_footerfull_sidebar_input_color_options',
                'label'        => 'Input Color Options',
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_footerfull_sidebar_spacing',
                'label'        => 'Sidebar Spacing',
                'desc'         => '',
                'std'          => '',
                'type'         => 'spacing',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_footerfull_sidebar_top_border',
                'label'        => 'Top Border',
                'desc'         => '',
                'std'          => '',
                'type'         => 'border',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_footerfull_sidebar_bottom_border',
                'label'        => 'Bottom Border',
                'desc'         => '',
                'std'          => '',
                'type'         => 'border',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'tab_leap_sidebar_mainbottom',
                'label'        => 'Main Bottom',
                'desc'         => '',
                'std'          => '',
                'type'         => 'tab',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_desc_mainbottom_widget_position',
                'label'        => 'Main Bottom Widget Position',
                'desc'         => 'Main Bottom Widget Position',
                'std'          => '',
                'type'         => 'textblock',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'title-block',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_mainbottom_sidebar_background',
                'label'        => 'Background',
                'desc'         => '',
                'std'          => '',
                'type'         => 'background',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_mainbottom_sidebar_parallax_background_image',
                'label'        => 'Parallax Background Image',
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'select',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Default',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'on',
                        'label' => 'On',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'off',
                        'label' => 'Off',
                        'src'   => ''
                    )
                ),
            ),
            array(
                'id'           => 'leap_mainbottom_sidebar_typography',
                'label'        => 'Typography',
                'desc'         => '',
                'std'          => '',
                'type'         => 'typography',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_mainbottom_sidebar_widget_title_typography',
                'label'        => 'Widget Title Typography',
                'desc'         => '',
                'std'          => '',
                'type'         => 'typography',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_mainbottom_sidebar_meta_color',
                'label'        => 'Meta Typography',
                'desc'         => 'Used for date, author, categories, tags, comments,... etc.',
                'std'          => '',
                'type'         => 'colorpicker',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_mainbottom_sidebar_links_color',
                'label'        => 'Links Color',
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_mainbottom_sidebar_list_divider_color',
                'label'        => 'List Divider Color',
                'desc'         => '',
                'std'          => '',
                'type'         => 'colorpicker',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_mainbottom_sidebar_button_color_options',
                'label'        => 'Button Color Options',
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_mainbottom_sidebar_button_radius',
                'label'        => 'Button Radius',
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'select',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Default',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'on',
                        'label' => 'On',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'off',
                        'label' => 'Off',
                        'src'   => ''
                    )
                ),
            ),
            array(
                'id'           => 'leap_mainbottom_sidebar_input_color_options',
                'label'        => 'Input Color Options',
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_mainbottom_sidebar_spacing',
                'label'        => 'Sidebar Spacing',
                'desc'         => '',
                'std'          => '',
                'type'         => 'spacing',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_mainbottom_sidebar_top_border',
                'label'        => 'Top Border',
                'desc'         => '',
                'std'          => '',
                'type'         => 'border',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_mainbottom_sidebar_bottom_border',
                'label'        => 'Bottom Border',
                'desc'         => '',
                'std'          => '',
                'type'         => 'border',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'tab_leap_sidebar_footer',
                'label'        => 'Footer',
                'desc'         => '',
                'std'          => '',
                'type'         => 'tab',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_desc_footer_widget_position',
                'label'        => 'Footer Widget Position',
                'desc'         => 'Footer Widget Position',
                'std'          => '',
                'type'         => 'textblock',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'title-block',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_footer_sidebar_background',
                'label'        => 'Background',
                'desc'         => '',
                'std'          => '',
                'type'         => 'background',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_footer_sidebar_parallax_background_image',
                'label'        => 'Parallax Background Image',
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'select',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Default',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'on',
                        'label' => 'On',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'off',
                        'label' => 'Off',
                        'src'   => ''
                    )
                ),
            ),
            array(
                'id'           => 'leap_footer_sidebar_typography',
                'label'        => 'Typography',
                'desc'         => '',
                'std'          => '',
                'type'         => 'typography',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_footer_sidebar_widget_title_typography',
                'label'        => 'Widget Title Typography',
                'desc'         => '',
                'std'          => '',
                'type'         => 'typography',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_footer_sidebar_meta_color',
                'label'        => 'Meta Typography',
                'desc'         => 'Used for date, author, categories, tags, comments,... etc.',
                'std'          => '',
                'type'         => 'colorpicker',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_footer_sidebar_links_color',
                'label'        => 'Links Color',
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_footer_sidebar_list_divider_color',
                'label'        => 'List Divider Color',
                'desc'         => '',
                'std'          => '',
                'type'         => 'colorpicker',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_footer_sidebar_button_color_options',
                'label'        => 'Button Color Options',
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_footer_sidebar_button_radius',
                'label'        => 'Button Radius',
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'select',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Default',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'on',
                        'label' => 'On',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'off',
                        'label' => 'Off',
                        'src'   => ''
                    )
                ),
            ),
            array(
                'id'           => 'leap_footer_sidebar_input_color_options',
                'label'        => 'Input Color Options',
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_footer_sidebar_spacing',
                'label'        => 'Sidebar Spacing',
                'desc'         => '',
                'std'          => '',
                'type'         => 'spacing',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_footer_sidebar_top_border',
                'label'        => 'Top Border',
                'desc'         => '',
                'std'          => '',
                'type'         => 'border',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_footer_sidebar_bottom_border',
                'label'        => 'Bottom Border',
                'desc'         => '',
                'std'          => '',
                'type'         => 'border',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            )
        )
    );

    ot_register_meta_box( $leap_sidebars_styles_meta_box_side );
    ot_register_meta_box( $leap_sidebars_styles_meta_box );
}

add_action( 'admin_init', '_leap_sidebars_styles_meta_box' );
