<?php
if ( !defined( 'ABSPATH' ) ) {
    die( 'No direct access allowed' );
}

// http://wordpress.org/plugins/widget-attributes/

/*
 * Version: 0.2.1
 */

if ( !class_exists( 'Leap_Widget_Attributes' ) ) {

    class Leap_Widget_Attributes {

        const VERSION = '0.2.1';

        /**
         * Initialize plugin
         */
        public static function setup() {
            if ( is_admin() ) {
                // Add necessary input on widget configuration form
                add_action( 'in_widget_form', array( __CLASS__, '_input_fields' ), 10, 3 );

                // Save widget attributes
                add_filter( 'widget_update_callback', array( __CLASS__, '_save_attributes' ), 10, 4 );

                // https://core.trac.wordpress.org/ticket/25809
                // Enqueue widgets admin scripts
                add_action( 'admin_enqueue_scripts', array( __CLASS__, 'enqueue_scripts' ), 10 );

                // Enqueue widgets admin scripts
                add_action( 'admin_footer-widgets.php', array( __CLASS__, 'print_scripts' ), 9999 );
            } else {
                // Insert attributes into widget markup
                add_filter( 'dynamic_sidebar_params', array( __CLASS__, '_insert_attributes' ) );
            }
        }

        /**
         * Enqueue widgets admin scripts
         * @param string $hook_suffix
         */
        public static function enqueue_scripts( $hook_suffix ) {
            if ( 'widgets.php' !== $hook_suffix ) {
                return;
            }

            wp_enqueue_style( 'wp-color-picker' );
            wp_enqueue_script( 'wp-color-picker' );
            wp_enqueue_script( 'underscore' );
        }

        /**
         * Enqueue widgets admin scripts
         */
        public static function print_scripts() {
            ?>
            <style type="text/css">
                .wp-picker-container {
                    clear: both;
                    width: 100%;
                }
            </style>
            <script type="text/javascript">
                ( function ( $ ) {
                    function initColorPicker( widget ) {
                        widget.find( '.color-picker' ).wpColorPicker( {
                            change: _.throttle( function () { // For Customizer
                                $( this ).trigger( 'change' );
                            }, 3000 )
                        } );
                    }

                    function onFormUpdate( event, widget ) {
                        initColorPicker( widget );
                    }

                    $( document ).on( 'widget-added widget-updated', onFormUpdate );

                    $( document ).ready( function () {
                        $( '#widgets-right .widget:has(.color-picker)' ).each( function () {
                            initColorPicker( $( this ) );
                        } );
                    } );
                }( jQuery ) );
            </script>
            <?php
        }

        /**
         * Inject input fields into widget configuration form
         *
         * @since 0.1
         * @wp_hook action in_widget_form
         *
         * @param object $widget Widget object
         *
         * @return NULL
         */
        public static function _input_fields( $widget, $return, $instance ) {
            $instance = self::_get_attributes( $instance );
            ?>
            <p>
                <?php
                printf(
                '<label for="%s">%s</label>', esc_attr( $widget->get_field_id( 'widget-style' ) ), esc_html__( 'Style', 'wiz' )
                )
                ?>

                <select id="<?php echo esc_attr( $widget->get_field_id( 'widget-style' ) ); ?>" name="<?php echo esc_attr( $widget->get_field_name( 'widget-style' ) ); ?>" class="widefat" >
                    <option value="" <?php
                    if ( esc_attr( $instance[ 'widget-style' ] ) == '' )
                        echo "selected=\"selected\"";
                    else
                        echo "";
                    ?>>Default</option>
                    <option value="style1" <?php
                    if ( esc_attr( $instance[ 'widget-style' ] ) == 'style1' )
                        echo "selected=\"selected\"";
                    else
                        echo "";
                    ?>>Style1</option>
                    <option value="style2" <?php
                    if ( esc_attr( $instance[ 'widget-style' ] ) == 'style2' )
                        echo "selected=\"selected\"";
                    else
                        echo "";
                    ?>>Style2</option>
                    <option value="style3" <?php
                    if ( esc_attr( $instance[ 'widget-style' ] ) == 'style3' )
                        echo "selected=\"selected\"";
                    else
                        echo "";
                    ?>>Style3</option>
                    <option value="style4" <?php
                    if ( esc_attr( $instance[ 'widget-style' ] ) == 'style4' )
                        echo "selected=\"selected\"";
                    else
                        echo "";
                    ?>>Style4</option>
                    <option value="style5" <?php
                    if ( esc_attr( $instance[ 'widget-style' ] ) == 'style5' )
                        echo "selected=\"selected\"";
                    else
                        echo "";
                    ?>>Style5</option>
                    <option value="style6" <?php
                    if ( esc_attr( $instance[ 'widget-style' ] ) == 'style6' )
                        echo "selected=\"selected\"";
                    else
                        echo "";
                    ?>>Style6</option>
                    <option value="style7" <?php
                    if ( esc_attr( $instance[ 'widget-style' ] ) == 'style7' )
                        echo "selected=\"selected\"";
                    else
                        echo "";
                    ?>>Style7</option>
                    <option value="style8" <?php
                    if ( esc_attr( $instance[ 'widget-style' ] ) == 'style8' )
                        echo "selected=\"selected\"";
                    else
                        echo "";
                    ?>>Style8</option>
                    <option value="style9" <?php
                    if ( esc_attr( $instance[ 'widget-style' ] ) == 'style9' )
                        echo "selected=\"selected\"";
                    else
                        echo "";
                    ?>>Style9</option>
                    <option value="style10" <?php
                    if ( esc_attr( $instance[ 'widget-style' ] ) == 'style10' )
                        echo "selected=\"selected\"";
                    else
                        echo "";
                    ?>>Style10</option>
                    <option value="style11" <?php
                    if ( esc_attr( $instance[ 'widget-style' ] ) == 'style11' )
                        echo "selected=\"selected\"";
                    else
                        echo "";
                    ?>>Style11</option>
                </select>
            </p>
            <p>
                <?php
                printf(
                '<label for="%s">%s</label>', esc_attr( $widget->get_field_id( 'widget-style-color' ) ), esc_html__( 'Color', 'wiz' )
                )
                ?>
                <?php
                printf(
                '<input type="text" id="%s" name="%s" value="%s" class="widefat color-picker" />', esc_attr( $widget->get_field_id( 'widget-style-color' ) ), esc_attr( $widget->get_field_name( 'widget-style-color' ) ), esc_attr( $instance[ 'widget-style-color' ] )
                )
                ?>
            </p>
            <p>
                <?php
                printf(
                '<label for="%s">%s</label>', esc_attr( $widget->get_field_id( 'widget-class' ) ), esc_html__( 'Class(es)', 'wiz' )
                )
                ?>
                <?php
                printf(
                '<input type="text" id="%s" name="%s" value="%s" class="widefat" />', esc_attr( $widget->get_field_id( 'widget-class' ) ), esc_attr( $widget->get_field_name( 'widget-class' ) ), esc_attr( $instance[ 'widget-class' ] )
                )
                ?>
            </p>

            <p>
                <?php
                printf(
                '<label for="%s">%s</label>', esc_attr( $widget->get_field_id( 'widget-icon' ) ), esc_html__( 'Icon', 'wiz' )
                )
                ?>
                <?php
                printf(
                '<input type="text" id="%s" name="%s" value="%s" size="3" class="widefat iconpicker-input" />', esc_attr( $widget->get_field_id( 'widget-icon' ) ), esc_attr( $widget->get_field_name( 'widget-icon' ) ), esc_attr( $instance[ 'widget-icon' ] )
                )
                ?>
                Ex: <b>fa fa-flag</b> <a target="_blank" href="http://fortawesome.github.io/Font-Awesome/icons/">Icons List</a>
            </p>

            <p>
                <?php
                printf(
                '<label for="%s">%s</label>', esc_attr( $widget->get_field_id( 'widget-margin-top' ) ), esc_html__( 'Margin Top', 'wiz' )
                )
                ?>
                <?php
                printf(
                '<input type="text" id="%s" name="%s" value="%s" size="3" class="widefat" />', esc_attr( $widget->get_field_id( 'widget-margin-top' ) ), esc_attr( $widget->get_field_name( 'widget-margin-top' ) ), esc_attr( $instance[ 'widget-margin-top' ] )
                )
                ?>
                In Pixel. Ex: 10
            </p>

            <p>
                <?php
                printf(
                '<label for="%s">%s</label>', esc_attr( $widget->get_field_id( 'widget-margin-bottom' ) ), esc_html__( 'Margin Bottom', 'wiz' )
                )
                ?>
                <?php
                printf(
                '<input type="text" id="%s" name="%s" value="%s" size="3" class="widefat" />', esc_attr( $widget->get_field_id( 'widget-margin-bottom' ) ), esc_attr( $widget->get_field_name( 'widget-margin-bottom' ) ), esc_attr( $instance[ 'widget-margin-bottom' ] )
                )
                ?>
                In Pixel. Ex: 10
            </p>
            <?php
            return null;
        }

        /**
         * Get default attributes
         *
         * @since 0.1
         *
         * @param array $instance Widget instance configuration
         *
         * @return array
         */
        private static function _get_attributes( $instance ) {
            $instance = wp_parse_args(
            $instance, array(
                'widget-style'         => '',
                'widget-style-color'   => '',
                'widget-class'         => '',
                'widget-icon'          => '',
                'widget-margin-top'    => '',
                'widget-margin-bottom' => '',
            )
            );

            return $instance;
        }

        /**
         * Save attributes upon widget saving
         *
         * @since 0.1
         * @wp_hook filter widget_update_callback
         *
         * @param array  $instance     Current widget instance configuration
         * @param array  $new_instance New widget instance configuration
         * @param array  $old_instance Old Widget instance configuration
         * @param object $widget       Widget object
         *
         * @return array
         */
        public static function _save_attributes( $instance, $new_instance,
                                                 $old_instance, $widget ) {
            $instance[ 'widget-style' ]         = $instance[ 'widget-style-color' ]   = $instance[ 'widget-class' ]         = $instance[ 'widget-icon' ]          = $instance[ 'widget-margin-top' ]    = $instance[ 'widget-margin-bottom' ] = '';


            // Style
            //if (!empty($new_instance['widget-style'])) {
            $instance[ 'widget-style' ] = (in_array( $new_instance[ 'widget-style' ], array( '', 'style1', 'style2', 'style3', 'style4', 'style5', 'style6', 'style7', 'style8', 'style9', 'style10', 'style11' ) )) ? $new_instance[ 'widget-style' ] : '';
            //}

            if ( !empty( $new_instance[ 'widget-style-color' ] ) ) {
                $instance[ 'widget-style-color' ] = leap_sanitize_hex_color( $new_instance[ 'widget-style-color' ] );
            }

            // Classes
            if ( !empty( $new_instance[ 'widget-class' ] ) ) {
                $classes                    = array_map( 'sanitize_html_class', explode( ' ', $new_instance[ 'widget-class' ] ) );
                $instance[ 'widget-class' ] = implode( ' ', $classes );
            } else {
                $instance[ 'widget-class' ] = '';
            }

            // Icon
            if ( !empty( $new_instance[ 'widget-icon' ] ) ) {
                $icons                     = array_map( 'sanitize_html_class', explode( ' ', $new_instance[ 'widget-icon' ] ) );
                $instance[ 'widget-icon' ] = implode( ' ', $icons );
            }

            // margin top
            if ( isset( $new_instance[ 'widget-margin-top' ] ) ) {
                $instance[ 'widget-margin-top' ] = ( is_numeric( $new_instance[ 'widget-margin-top' ] ) || ($new_instance[ 'widget-margin-top' ] == 0) ) ? $new_instance[ 'widget-margin-top' ] : '';
            }

            // margin bottom
            if ( isset( $new_instance[ 'widget-margin-bottom' ] ) ) {
                $instance[ 'widget-margin-bottom' ] = ( is_numeric( $new_instance[ 'widget-margin-bottom' ] ) ) ? $new_instance[ 'widget-margin-bottom' ] : '';
            }

            return $instance;
        }

        /**
         * Insert attributes into widget markup
         *
         * @since 0.1
         * @filter dynamic_sidebar_params
         *
         * @param array $params Widget parameters
         *
         * @return Array
         */
        public static function _insert_attributes( $params ) {
            global $wp_registered_widgets;

            $widget_id  = $params[ 0 ][ 'widget_id' ];
            $widget_obj = $wp_registered_widgets[ $widget_id ];

            if (
            !isset( $widget_obj[ 'callback' ][ 0 ] ) || !is_object( $widget_obj[ 'callback' ][ 0 ] )
            ) {
                return $params;
            }

            $widget_options = get_option( $widget_obj[ 'callback' ][ 0 ]->option_name );
            if ( empty( $widget_options ) )
                return $params;

            $widget_num = $widget_obj[ 'params' ][ 0 ][ 'number' ];
            if ( empty( $widget_options[ $widget_num ] ) )
                return $params;

            $instance = $widget_options[ $widget_num ];

            $widget_style = ot_get_option( 'widget_style', 'style1' );
            if ( !empty( $instance[ 'widget-style' ] ) ) {
                $widget_style = $instance[ 'widget-style' ];
            }

            ob_start();

            if ( $widget_style == 'style1' ) {
                ?>
                <style type="text/css" scoped>
                    #<?php echo $widget_id ?> .widget-title {
                        <?php if ( !empty( $instance[ 'widget-style-color' ] ) ) { ?>
                            color: <?php echo $instance[ 'widget-style-color' ]; ?> !important;
                <?php } ?>
                    }
                </style>
            <?php } elseif ( $widget_style == 'style2' ) { ?>
                <style type="text/css" scoped>
                    #<?php echo $widget_id ?> .widget-title {
                        <?php if ( !empty( $instance[ 'widget-style-color' ] ) ) { ?>
                            color: <?php echo $instance[ 'widget-style-color' ]; ?> !important;
                <?php } ?>
                    }
                </style>
            <?php } elseif ( $widget_style == 'style3' ) { ?>
                <style type="text/css" scoped>
                    #<?php echo $widget_id ?> .widget-title {
                        <?php if ( !empty( $instance[ 'widget-style-color' ] ) ) { ?>
                            background-color: <?php echo $instance[ 'widget-style-color' ]; ?> !important;
                <?php } ?>
                    }
                    #<?php echo $widget_id ?> .widget-head {
                        <?php if ( !empty( $instance[ 'widget-style-color' ] ) ) { ?>
                            border-color: <?php echo $instance[ 'widget-style-color' ]; ?> !important;
                <?php } ?>
                    }
                </style>
            <?php } elseif ( $widget_style == 'style4' ) { ?>
                <style type="text/css" scoped>
                    #<?php echo $widget_id ?> .widget-title {
                <?php if ( !empty( $instance[ 'widget-style-color' ] ) ) { ?>
                            color: <?php echo $instance[ 'widget-style-color' ]; ?> !important;
                            border-color: <?php echo $instance[ 'widget-style-color' ]; ?> !important;
                <?php } ?>
                    }
                </style>
            <?php } elseif ( $widget_style == 'style5' ) { ?>
                <style type="text/css" scoped>
                    #<?php echo $widget_id ?> .widget-title {
                        <?php if ( !empty( $instance[ 'widget-style-color' ] ) ) { ?>
                            color: <?php echo $instance[ 'widget-style-color' ]; ?> !important;
                <?php } ?>
                    }
                    #<?php echo $widget_id ?> .widget-content {
                        <?php if ( !empty( $instance[ 'widget-style-color' ] ) ) { ?>
                            border-bottom-color: <?php echo $instance[ 'widget-style-color' ]; ?> !important;
                <?php } ?>
                    }
                </style>
            <?php } elseif ( $widget_style == 'style6' ) { ?>
                <style type="text/css" scoped>
                    #<?php echo $widget_id ?> .widget-head {
                        <?php if ( !empty( $instance[ 'widget-style-color' ] ) ) { ?>
                            background-color: <?php echo $instance[ 'widget-style-color' ]; ?> !important;
                <?php } ?>
                    }
                </style>
            <?php } elseif ( $widget_style == 'style7' ) { ?>
                <style type="text/css" scoped>
                    #<?php echo $widget_id ?> .widget-head {
                        <?php if ( !empty( $instance[ 'widget-style-color' ] ) ) { ?>
                            background-color: <?php echo $instance[ 'widget-style-color' ]; ?> !important;
                <?php } ?>
                    }
                </style>
            <?php } elseif ( $widget_style == 'style8' ) { ?>
                <style type="text/css" scoped>
                    #<?php echo $widget_id ?> .widget-title {
                        <?php if ( !empty( $instance[ 'widget-style-color' ] ) ) { ?>
                            color: <?php echo $instance[ 'widget-style-color' ]; ?> !important;
                <?php } ?>
                    }
                    #<?php echo $widget_id ?> .widget-head {
                        <?php if ( !empty( $instance[ 'widget-style-color' ] ) ) { ?>
                            border-color: <?php echo $instance[ 'widget-style-color' ]; ?> !important;
                <?php } ?>
                    }
                </style>
            <?php } elseif ( $widget_style == 'style9' ) { ?>
                <style type="text/css" scoped>
                    #<?php echo $widget_id ?> .widget-title {
                <?php if ( !empty( $instance[ 'widget-style-color' ] ) ) { ?>
                            color: <?php echo $instance[ 'widget-style-color' ]; ?> !important;
                            border-color: <?php echo $instance[ 'widget-style-color' ]; ?> !important;
                <?php } ?>

                    }
                    #<?php echo $widget_id ?> .widget-title:before {
                        <?php if ( !empty( $instance[ 'widget-style-color' ] ) ) { ?>
                            border-bottom-color: <?php echo $instance[ 'widget-style-color' ]; ?> !important;
                <?php } ?>
                    }
                </style>
                <?php } elseif ( $widget_style == 'style10' ) { ?>
                <style type="text/css" scoped>
                    #<?php echo $widget_id ?>.widget {
                <?php if ( !empty( $instance[ 'widget-style-color' ] ) ) { ?>
                            background-color: <?php echo $instance[ 'widget-style-color' ]; ?> !important;
                <?php } ?>
                    }
                </style>
                <?php } elseif ($widget_style == 'style11') { ?>
                <style type="text/css" scoped>
                    #<?php echo $widget_id ?> .widget-title:after {
                        <?php if (!empty($instance['widget-style-color'])) { ?>
                            background-color: <?php echo $instance['widget-style-color']; ?> !important;
                        <?php } ?>
                    }
                </style>
                <?php
            }
            ?>
            <style type="text/css" scoped>
                #<?php echo $widget_id ?> {
                    <?php if ( isset( $instance[ 'widget-margin-top' ] ) ) : ?>
                        margin-top: <?php echo $instance[ 'widget-margin-top' ]; ?>px !important;
                    <?php endif; ?>
                    <?php if ( isset( $instance[ 'widget-margin-bottom' ] ) ) : ?>
                        margin-bottom: <?php echo $instance[ 'widget-margin-bottom' ]; ?>px !important;
            <?php endif; ?>
                }
            </style>
            <?php
            $widget_styles = ob_get_contents();
            ob_end_clean();

            if ( empty( $widget_styles ) ) {
                $widget_styles = '';
            }

            $leap_widget_class = '';
            if ( !empty( $widget_style ) ) {
                $leap_widget_class .= 'leap-widget-' . $widget_style;
            }

            if ( !empty( $instance[ 'widget-class' ] ) ) {
                $leap_widget_class .= ' ' . $instance[ 'widget-class' ];
            }

            if ( !empty( $leap_widget_class ) ) {
                $params[ 0 ][ 'before_widget' ] = '<div id="leap-' . $widget_id . '" class ="' . $leap_widget_class . '">' . $widget_styles . $params[ 0 ][ 'before_widget' ];
                $params[ 0 ][ 'after_widget' ]  = $params[ 0 ][ 'after_widget' ] . '</div>';
            }

            return $params;
        }

    }

}

add_action( 'widgets_init', array( 'Leap_Widget_Attributes', 'setup' ) );
