<?php

if ( !defined( 'ABSPATH' ) ) {
    die( 'No direct access allowed' );
}

if ( !function_exists( 'leap_vc_get_cats' ) ) {

    /**
     * Get a list for all categories for a certain taxonomy to use on VC
     * @param string $tax taxonomy name
     * @return array
     */
    function leap_vc_get_cats( $tax ) {
        $categories_obj = get_terms( $tax, array( 'hide_empty' => false ) );

        $categories = array();
        foreach ( $categories_obj as $category_obj ) {
            if ( is_object( $category_obj ) ) {
                $categories[ $category_obj->name ] = $category_obj->slug;
            }
        }
        return $categories;
    }

}

if ( !function_exists( 'leap_vc_get_woocommerce_cats_slug' ) ) {

    /**
     * Get a list for all woocommerce categories to use on VC
     * @return array
     */
    function leap_vc_get_woocommerce_cats_slug() {
        $categories_obj = get_terms( 'product_cat', array( 'hide_empty' => false ) );

        $categories = array();
        foreach ( $categories_obj as $category_obj ) {
            if ( is_object( $category_obj ) ) {
                $categories[ $category_obj->name ] = $category_obj->slug;
            }
        }

        return $categories;
    }

}

/**
 * Add our shortcodes as addons on Visual Composer
 */
function leap_vc_shortcodes() {

    $post_categories      = leap_vc_get_cats( 'category' );
    $portfolio_categories = leap_vc_get_cats( 'leap-portfolio-category' );

    $animation_types = array(
        ''                   => 'None',
// Attention Seekers
        'bounce'             => 'bounce',
        'flash'              => 'flash',
        'pulse'              => 'pulse',
        'rubberBand'         => 'rubberBand',
        'shake'              => 'shake',
        'swing'              => 'swing',
        'tada'               => 'tada',
        'wobble'             => 'wobble',
// Bouncing Entrances
        'bounceIn'           => 'bounceIn',
        'bounceInDown'       => 'bounceInDown',
        'bounceInLeft'       => 'bounceInLeft',
        'bounceInRight'      => 'bounceInRight',
        'bounceInUp'         => 'bounceInUp',
// Bouncing Exits
        'bounceOut'          => 'bounceOut',
        'bounceOutDown'      => 'bounceOutDown',
        'bounceOutLeft'      => 'bounceOutLeft',
        'bounceOutRight'     => 'bounceOutRight',
        'bounceOutUp'        => 'bounceOutUp',
// Fading Entrances
        'fadeIn'             => 'fadeIn',
        'fadeInDown'         => 'fadeInDown',
        'fadeInDownBig'      => 'fadeInDownBig',
        'fadeInLeft'         => 'fadeInLeft',
        'fadeInLeftBig'      => 'fadeInLeftBig',
        'fadeInRight'        => 'fadeInRight',
        'fadeInRightBig'     => 'fadeInRightBig',
        'fadeInUp'           => 'fadeInUp',
        'fadeInUpBig'        => 'fadeInUpBig',
// Fading Exits
        'fadeOut'            => 'fadeOut',
        'fadeOutDown'        => 'fadeOutDown',
        'fadeOutDownBig'     => 'fadeOutDownBig',
        'fadeOutLeft'        => 'fadeOutLeft',
        'fadeOutLeftBig'     => 'fadeOutLeftBig',
        'fadeOutRight'       => 'fadeOutRight',
        'fadeOutRightBig'    => 'fadeOutRightBig',
        'fadeOutUp'          => 'fadeOutUp',
        'fadeOutUpBig'       => 'fadeOutUpBig',
// Flippers
        'flip'               => 'flip',
        'flipInX'            => 'flipInX',
        'flipInY'            => 'flipInY',
        'flipOutX'           => 'flipOutX',
        'flipOutY'           => 'flipOutY',
// Lightspeed
        'lightSpeedIn'       => 'lightSpeedIn',
        'lightSpeedOut'      => 'lightSpeedOut',
// Rotating Entrances
        'rotateIn'           => 'rotateIn',
        'rotateInDownLeft'   => 'rotateInDownLeft',
        'rotateInDownRight'  => 'rotateInDownRight',
        'rotateInUpLeft'     => 'rotateInUpLeft',
        'rotateInUpRight'    => 'rotateInUpRight',
//Rotating Exits
        'rotateOut'          => 'rotateOut',
        'rotateOutDownLeft'  => 'rotateOutDownLeft',
        'rotateOutDownRight' => 'rotateOutDownRight',
        'rotateOutUpLeft'    => 'rotateOutUpLeft',
        'rotateOutUpRight'   => 'rotateOutUpRight',
// Specials
        'hinge'              => 'hinge',
        'rollIn'             => 'rollIn',
        'rollOut'            => 'rollOut',
// Zoom Entrances
        'zoomIn'             => 'zoomIn',
        'zoomInDown'         => 'zoomInDown',
        'zoomInLeft'         => 'zoomInLeft',
        'zoomInRight'        => 'zoomInRight',
        'zoomInUp'           => 'zoomInUp',
//Zoom Exits
        'zoomOut'            => 'zoomOut',
        'zoomOutDown'        => 'zoomOutDown',
        'zoomOutLeft'        => 'zoomOutLeft',
        'zoomOutRight'       => 'zoomOutRight',
        'zoomOutUp'          => 'zoomOutUp'
    );

    $url_target = array(
        'Default' => '',
        'Blank'   => '_blank',
        'Parent'  => '_parent',
        'Self'    => '_self',
        'Top'     => '_top'
    );

    $families = array_flip( leap_all_font_families() );

    vc_map( array(
        'name'     => __( 'Leap Image Box', 'wiz' ),
        'base'     => 'leap_image_box',
        'class'    => '',
        'category' => __( 'Leap Addons', 'wiz' ),
        'icon'     => get_template_directory_uri() . '/functions/vc/icons/leap-image-box.png',
        'params'   => array(
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Layout', 'wiz' ),
                'param_name'  => 'layout',
                'value'       => array(
                    'Title on top'  => 'title-top',
                    'Image on top'  => 'image-top',
                    'Image on side' => 'image-side'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Center Box', 'wiz' ),
                'param_name'  => 'centerbox',
                'value'       => array(
                    'No'  => 'no',
                    'Yes' => 'yes'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Title Font Family', 'wiz' ),
                'param_name'  => 'font_family',
                'value'       => $families,
                'group'       => __( 'Typography', 'wiz' )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Title Font Size', 'wiz' ),
                'param_name'  => 'font_size',
                'value'       => '',
                'description' => '',
                'group'       => __( 'Typography', 'wiz' )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Title Line Height', 'wiz' ),
                'param_name'  => 'line_height',
                'value'       => '',
                'description' => '',
                'group'       => __( 'Typography', 'wiz' )
            ),
            array(
                'type'        => 'attach_image',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Image', 'wiz' ),
                'param_name'  => 'image',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => '',
                'heading'     => __( 'Title', 'wiz' ),
                'param_name'  => 'title',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textarea_html',
                'holder'      => 'div',
                'class'       => '',
                'heading'     => __( 'Content', 'wiz' ),
                'param_name'  => 'content',
                'value'       => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec at hendrerit ipsum. Nullam tincidunt tortor pulvinar sem sagittis fermentum.',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Link', 'wiz' ),
                'param_name'  => 'link',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Link Text', 'wiz' ),
                'param_name'  => 'linktext',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Target', 'wiz' ),
                'param_name'  => 'linktarget',
                'value'       => $url_target,
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Image Effect', 'wiz' ),
                'param_name'  => 'image_effect',
                'value'       => array(
                    'No'  => 'no',
                    'Yes' => 'yes'
                ),
                'description' => '',
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Title Color', 'wiz' ),
                'param_name'  => 'titlecolor',
                'value'       => '',
                'description' => '',
                'group'       => __( 'Color', 'wiz' )
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Background color', 'wiz' ),
                'param_name'  => 'backgroundcolor',
                'value'       => '',
                'description' => '',
                'group'       => __( 'Color', 'wiz' )
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Link color', 'wiz' ),
                'param_name'  => 'linkcolor',
                'value'       => '',
                'description' => '',
                'group'       => __( 'Color', 'wiz' )
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Hover Title Color', 'wiz' ),
                'param_name'  => 'hover_titlecolor',
                'value'       => '',
                'description' => '',
                'group'       => __( 'Hover', 'wiz' )
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Hover Text Color', 'wiz' ),
                'param_name'  => 'hover_textcolor',
                'value'       => '',
                'description' => '',
                'group'       => __( 'Hover', 'wiz' )
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Hover Background color', 'wiz' ),
                'param_name'  => 'hover_backgroundcolor',
                'value'       => '',
                'description' => '',
                'group'       => __( 'Hover', 'wiz' )
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Hover Link color', 'wiz' ),
                'param_name'  => 'hover_linkcolor',
                'value'       => '',
                'description' => '',
                'group'       => __( 'Hover', 'wiz' )
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Animation Type', 'wiz' ),
                'param_name'  => 'animationtype',
                'value'       => $animation_types,
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Animation Speed', 'wiz' ),
                'param_name'  => 'animationspeed',
                'value'       => '',
                'description' => __( 'In seconds', 'wiz' )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Animation Delay', 'wiz' ),
                'param_name'  => 'animationdelay',
                'value'       => '',
                'description' => __( 'In seconds', 'wiz' )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Animation Iteration', 'wiz' ),
                'param_name'  => 'animationiteration',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Animation Offset', 'wiz' ),
                'param_name'  => 'animationoffset',
                'value'       => '',
                'description' => ''
            ),
        )
    ) );

    $families = array_flip( leap_all_font_families() );

// Icon Box
    vc_map( array(
        'name'     => __( 'Leap Icon Box', 'wiz' ),
        'base'     => 'leap_icon_box',
        'class'    => '',
        'category' => __( 'Leap Addons', 'wiz' ),
        'icon'     => get_template_directory_uri() . '/functions/vc/icons/leap-icon-box.png',
        'params'   => array(
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Layout', 'wiz' ),
                'param_name'  => 'layout',
                'value'       => array(
                    'Icon with title' => 'icon-with-title',
                    'Icon on top'     => 'icon-on-top',
                    'Icon on side'    => 'icon-on-side',
                    'Icon boxed'      => 'icon-boxed'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Background color', 'wiz' ),
                'param_name'  => 'backgroundcolor',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => '',
                'heading'     => __( 'Title', 'wiz' ),
                'param_name'  => 'title',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Title Color', 'wiz' ),
                'param_name'  => 'titlecolor',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Circle', 'wiz' ),
                'param_name'  => 'circle',
                'value'       => array(
                    'Yes' => 'yes',
                    'No'  => 'no'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Circle Color', 'wiz' ),
                'param_name'  => 'circlecolor',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Circle Border Color', 'wiz' ),
                'param_name'  => 'circlebordercolor',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Icon', 'wiz' ),
                'param_name'  => 'icon',
                'value'       => '',
                'description' => __( 'Ex. <b>chevron-right</b> <a target="_blank" href="http://fortawesome.github.io/Font-Awesome/icons/">Icon List</a>' ,'wiz' )
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Icon Color', 'wiz' ),
                'param_name'  => 'iconcolor',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'attach_image',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Icon Image', 'wiz' ),
                'param_name'  => 'iconimage',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Icon Image Width', 'wiz' ),
                'param_name'  => 'iconimagewidth',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Icon Image Height', 'wiz' ),
                'param_name'  => 'iconimageheight',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textarea_html',
                'holder'      => 'div',
                'class'       => '',
                'heading'     => __( 'Content', 'wiz' ),
                'param_name'  => 'content',
                'value'       => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec at hendrerit ipsum. Nullam tincidunt tortor pulvinar sem sagittis fermentum.',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Link', 'wiz' ),
                'param_name'  => 'link',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Link color', 'wiz' ),
                'param_name'  => 'linkcolor',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Link Text', 'wiz' ),
                'param_name'  => 'linktext',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Target', 'wiz' ),
                'param_name'  => 'linktarget',
                'value'       => $url_target,
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Animation Type', 'wiz' ),
                'param_name'  => 'animationtype',
                'value'       => $animation_types,
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Animation Speed', 'wiz' ),
                'param_name'  => 'animationspeed',
                'value'       => '',
                'description' => __( 'In seconds', 'wiz' )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Animation Delay', 'wiz' ),
                'param_name'  => 'animationdelay',
                'value'       => '',
                'description' => __( 'In seconds', 'wiz' )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Animation Iteration', 'wiz' ),
                'param_name'  => 'animationiteration',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Animation Offset', 'wiz' ),
                'param_name'  => 'animationoffset',
                'value'       => '',
                'description' => ''
            ),
        )
    ) );
    // Icon Box 2
    vc_map( array(
        'name'     => __( 'Leap Icon Box 2', 'wiz' ),
        'base'     => 'leap_icon_box_2',
        'class'    => '',
        'category' => __( 'Leap Addons', 'wiz' ),
        'icon'     => get_template_directory_uri() . '/functions/vc/icons/leap-icon-box.png',
        'params'   => array(  
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Icon to display', 'wiz' ),
                'param_name'  => 'icon_to_display',
                'value'       => array(
                    'Font Icon' => 'icon',
                    'Custom Image' => 'image'
                )
            ),
            array(
                'type'        => 'attach_image',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Image', 'wiz' ),
                'param_name'  => 'image',
                'value'       => '',
                'description' => '',
                'dependency'  => array(
                    'element' => 'icon_to_display',
                    'value'   => 'image',
                )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Size', 'wiz' ),
                'param_name'  => 'size',
                'value'       => '75x75',
                'description' => 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Example: 200x100 (Width x Height)).',
                'dependency'  => array(
                    'element' => 'icon_to_display',
                    'value'   => 'image',
                )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Icon', 'wiz' ),
                'param_name'  => 'icon',
                'value'       => '',
                'description' => __( 'Ex. <b>chevron-right</b> <a target="_blank" href="http://fortawesome.github.io/Font-Awesome/icons/">Icon List</a>' ,'wiz' ),
                'dependency'  => array(
                    'element' => 'icon_to_display',
                    'value'   => 'icon',
                )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Icon Size', 'wiz' ),
                'param_name'  => 'icon_size',
                'value'       => '',
                'description' => '',
                'dependency'  => array(
                    'element' => 'icon_to_display',
                    'value'   => 'icon',
                )
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Icon Color', 'wiz' ),
                'param_name'  => 'icon_color',
                'value'       => '',
                'description' => '',
                'group'       => __( 'Colors', 'wiz' ),
                'dependency'  => array(
                    'element' => 'icon_to_display',
                    'value'   => 'icon',
                )
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Icon Hover Color', 'wiz' ),
                'param_name'  => 'icon_hover_color',
                'value'       => '',
                'description' => '',
                'group'       => __( 'Colors', 'wiz' ),
                'dependency'  => array(
                    'element' => 'icon_to_display',
                    'value'   => 'icon',
                )
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Hover Animation', 'wiz' ),
                'param_name'  => 'hover_animation',
                'value'       => array(
                    'Pulse' => 'hvr-pulse-grow',
                    'Rotate'     => 'rotate',
                    'Buzz'    => 'hvr-buzz',
                    '3D Rotate'    => 'd-rotate',
                    'Drop Shadow'    => 'hvr-float-shadow',
                    'Wobble Vertical' => 'hvr-wobble-vertical'
                    )
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Box Align', 'wiz' ),
                'param_name'  => 'box_align',
                'value'       => array(
                    'Center' => 'center',
                    'Right'     => 'right',
                    'Left'    => 'left'
                    )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => '',
                'heading'     => __( 'Title', 'wiz' ),
                'param_name'  => 'title',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Title Heading', 'wiz' ),
                'param_name'  => 'title_heading',
                'value'       => array(
                    'H1' => 'h1',
                    'H2' => 'h2',
                    'H3' => 'h3',
                    'H4' => 'h4',
                    'H5' => 'h5',
                    'H6' => 'h6'
                ),
                'std' => 'h2',
                'save_always' => true,
                'description' => ''
            ),  
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Title Color', 'wiz' ),
                'param_name'  => 'title_color',
                'value'       => '',
                'description' => '',
                'group'       => __( 'Colors', 'wiz' )
            ),
            array(
                'type'        => 'textarea_html',
                'holder'      => 'div',
                'class'       => '',
                'heading'     => __( 'Content', 'wiz' ),
                'param_name'  => 'content',
                'value'       => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec at hendrerit ipsum. Nullam tincidunt tortor pulvinar sem sagittis fermentum.',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => '',
                'heading'     => __( 'Read More Text', 'wiz' ),
                'param_name'  => 'readmore_text',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Read More Icon', 'wiz' ),
                'param_name'  => 'readmore_icon',
                'value'       => '',
                'description' => __( 'Ex. <b>chevron-right</b> <a target="_blank" href="http://fortawesome.github.io/Font-Awesome/icons/">Icon List</a>' ,'wiz' )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Read More Link', 'wiz' ),
                'param_name'  => 'readmore_link',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Read More Size', 'wiz' ),
                'param_name'  => 'readmore_size',
                'value'       => '',
                'description' => 'Ex. 15px'
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Read More Icon Size', 'wiz' ),
                'param_name'  => 'readmore_icon_size',
                'value'       => '',
                'description' => 'Ex. 15px'
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Read More Color', 'wiz' ),
                'param_name'  => 'readmore_color',
                'value'       => '',
                'description' => '',
                'group'       => __( 'Colors', 'wiz' )
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Read More Hover Color', 'wiz' ),
                'param_name'  => 'readmore_hover_color',
                'value'       => '',
                'description' => '',
                'group'       => __( 'Colors', 'wiz' )
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Content Background Color', 'wiz' ),
                'param_name'  => 'content_background_color',
                'value'       => '',
                'description' => '',
                'group'       => __( 'Colors', 'wiz' )
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Content Border Color', 'wiz' ),
                'param_name'  => 'content_border_color',
                'value'       => '',
                'description' => '',
                'group'       => __( 'Colors', 'wiz' )
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Content Border Hover Color', 'wiz' ),
                'param_name'  => 'content_border_hover_color',
                'value'       => '',
                'description' => '',
                'group'       => __( 'Colors', 'wiz' )
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Background Color', 'wiz' ),
                'param_name'  => 'background_color',
                'value'       => '',
                'description' => '',
                'group'       => __( 'Colors', 'wiz' )
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Back Icon Color', 'wiz' ),
                'param_name'  => 'back_icon_color',
                'value'       => '',
                'description' => '',
                'group'       => __( 'Colors', 'wiz' )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Padding Top', 'wiz' ),
                'param_name'  => 'padding_top',
                'value'       => '',
                'description' => '',
                'group'       => __( 'Design', 'wiz' )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Padding Bottom', 'wiz' ),
                'param_name'  => 'padding_bottom',
                'value'       => '',
                'description' => '',
                'group'       => __( 'Design', 'wiz' )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Padding Right', 'wiz' ),
                'param_name'  => 'padding_right',
                'value'       => '',
                'description' => '',
                'group'       => __( 'Design', 'wiz' )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Padding Left', 'wiz' ),
                'param_name'  => 'padding_left',
                'value'       => '',
                'description' => '',
                'group'       => __( 'Design', 'wiz' )
            )
        )
    ) );

// Recent Posts
    vc_map( array(
        'name'     => __( 'Leap Recent Posts', 'wiz' ),
        'base'     => 'leap_recentposts',
        'class'    => '',
        'category' => __( 'Leap Addons', 'wiz' ),
        'icon'     => get_template_directory_uri() . '/functions/vc/icons/leap-recent-posts.png',
        'params'   => array(
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Style', 'wiz' ),
                'admin_label' => true,
                'param_name'  => 'style',
                'value'       => array(
                    'Style 1' => 'style-1',
                    'Style 2' => 'style-2',
                    'Style 3' => 'style-3',
                    'Style 4' => 'style-4'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Number of Posts', 'wiz' ),
                'param_name'  => 'posts',
                'value'       => '5',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Columns', 'wiz' ),
                'param_name'  => 'columns',
                'value'       => '3',
                'description' => ''
            ),
            array(
                'type'        => 'checkbox',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Categories', 'wiz' ),
                'param_name'  => 'cats',
                'value'       => $post_categories,
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Display Read More', 'wiz' ),
                'param_name'  => 'readmore',
                'value'       => array(
                    'Yes' => 'yes',
                    'No'  => 'no'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Excerpt Length', 'wiz' ),
                'param_name'  => 'excerptlength',
                'value'       => '',
                'description' => 'Leave empty to use the default length which is 55.'
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Title Color', 'wiz' ),
                'param_name'  => 'titlecolor',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Meta Color', 'wiz' ),
                'param_name'  => 'metacolor',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Text Color', 'wiz' ),
                'param_name'  => 'textcolor',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Read More Color', 'wiz' ),
                'param_name'  => 'morecolor',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Animation Type', 'wiz' ),
                'param_name'  => 'animationtype',
                'value'       => $animation_types,
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Animation Speed', 'wiz' ),
                'param_name'  => 'animationspeed',
                'value'       => '',
                'description' => __( 'In seconds', 'wiz' )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Animation Delay', 'wiz' ),
                'param_name'  => 'animationdelay',
                'value'       => '',
                'description' => __( 'In seconds', 'wiz' )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Animation Iteration', 'wiz' ),
                'param_name'  => 'animationiteration',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Animation Offset', 'wiz' ),
                'param_name'  => 'animationoffset',
                'value'       => '',
                'description' => ''
            ),
        )
    ) );


//Leap Button
     vc_map( array(
        'name'     => __( 'Leap Button', 'wiz' ),
        'base'     => 'leap_button',
        'class'    => '',
        'category' => __( 'Leap Addons', 'wiz' ),
        'icon'     => get_template_directory_uri() . '/functions/vc/icons/leap-button.png',
        'params'   => array(
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Button Alignment', 'wiz' ),
                'admin_label' => true,
                'param_name'  => 'align',
                'value'       => array(
                    'None'   => 'none',
                    'Left'   => 'left',
                    'Center' => 'center',
                    'Right'  => 'right'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'textarea_html',
                'holder'      => 'div',
                'class'       => '',
                'heading'     => __( 'Content', 'wiz' ),
                'param_name'  => 'content',
                'value'       => 'Button Content',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Link', 'wiz' ),
                'param_name'  => 'link',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Target', 'wiz' ),
                'param_name'  => 'target',
                'value'       => $url_target,
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Custom Class', 'wiz' ),
                'param_name'  => 'class',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Font Family', 'wiz' ),
                'param_name'  => 'leap_btn_font_family',
                'value'       => $families,
                'group'       => __( 'Typography', 'wiz' )
            ),            
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Font Size', 'wiz' ),
                'param_name'  => 'leap_btn_font_size',
                'value'       => '',
                'description' => '',
                'group'       => __( 'Typography', 'wiz' )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Line Height', 'wiz' ),
                'param_name'  => 'line_height',
                'value'       => '',
                'description' => '',
                'group'       => __( 'Typography', 'wiz' )
            ),
             array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => '',
                'admin_label' => true,
                'heading'     => __( 'Button Title Color', 'wiz' ),
                'param_name'  => 'button_title_color',
                'value'       => '',
                'description' => '',
                 'group'       => __( 'Colors', 'wiz' )
               
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => '',
                'admin_label' => true,
                'heading'     => __( 'Background Color', 'wiz' ),
                'param_name'  => 'background_color',
                'value'       => '',
                'description' => '',
                'group'       => __( 'Colors', 'wiz' )
              
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => '',
                'admin_label' => true,
                'heading'     => __( 'Hover Title Color', 'wiz' ),
                'param_name'  => 'hover_title_color',
                'value'       => '',
                'description' => '',
                'group'       => __( 'Colors', 'wiz' )
               
            ),          
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => '',
                'admin_label' => true,
                'heading'     => __( 'Hover Background Color', 'wiz' ),
                'param_name'  => 'hover_background_color',
                'value'       => '',
                'group'       => __( 'Colors', 'wiz' )
            ),
          array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Border Style', 'wiz' ),
                'param_name'  => 'borderstyle',
                'value'       => array(
                    'None'  => 'none',
                    'solid'  => 'solid',
                    'Dashed' => 'dashed',
                    'Dotted' => 'dotted',
                    'Double'  => 'double',
                    'Inset'  => 'inset',
                    'Outset'  => 'outset',
                ),
                'description' => '',
        
                'group'       => __( 'Styling', 'wiz' )
            ),
             array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Border Radius', 'wiz' ),
                'param_name'  => 'borderradius',
                'value'       => '',
                'description' => '',
                 'dependency'  => array(
                  'element' => 'borderstyle',
                  'value'   => array( 'solid' , 'dashed' ,'dotted', 'double' , 'inset','outset' )
                ),
                'group'       => __( 'Styling', 'wiz' )
            ),
              array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Border Width', 'wiz' ),
                'param_name'  => 'borderwidth',
                'value'       => '',
                'description' => '',
                 'dependency'  => array(
                  'element' => 'borderstyle',
                  'value'   => array( 'solid' , 'dashed','dotted' , 'double' , 'inset','outset' )
                ),
                'group'       => __( 'Styling', 'wiz' )
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Border color', 'wiz' ),
                'param_name'  => 'bordercolor',
                'value'       => '',
                'description' => '',
                'dependency'  => array(
                  'element' => 'borderstyle',
                  'value'   => array( 'solid' , 'dashed' ,'dotted', 'double' , 'inset','outset' )
                ),
                'group'       => __( 'Styling', 'wiz' )
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Border Color On Hover', 'wiz' ),
                'param_name'  => 'bordercolor_hover',
                'value'       => '',
                'description' => '',
                'dependency'  => array(
                  'element' => 'borderstyle',
                  'value'   => array( 'solid' , 'dashed' ,'dotted', 'double' , 'inset','outset' )
                ),
                'group'       => __( 'Styling', 'wiz' )
            ),
             array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Padding Top', 'wiz' ),
                'param_name'  => 'padding_top',
                'value'       => '',
                'description' => 'Ex. 15px',
                'group'       => __( 'Styling', 'wiz' )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Padding Bottom', 'wiz' ),
                'param_name'  => 'padding_bottom',
                'value'       => '',
                'description' => 'Ex. 15px',
               'group'       => __( 'Styling', 'wiz' )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Padding Right', 'wiz' ),
                'param_name'  => 'padding_right',
                'value'       => '',
                'description' => 'Ex. 15px',
                'group'       => __( 'Styling', 'wiz' )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Padding Left', 'wiz' ),
                'param_name'  => 'padding_left',
                'value'       => '',
                'description' => 'Ex. 15px',
                'group'       => __( 'Styling', 'wiz' )
            ),
        )
    ) );

// Separators
    vc_map( array(
        'name'     => __( 'Leap Separator', 'wiz' ),
        'base'     => 'leap_separator',
        'class'    => '',
        'category' => __( 'Leap Addons', 'wiz' ),
        'icon'     => get_template_directory_uri() . '/functions/vc/icons/leap-separator.png',
        'params'   => array(
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Style', 'wiz' ),
                'admin_label' => true,
                'param_name'  => 'style',
                'value'       => array(
                    'Solid'         => 'solid',
                    'Dashed'        => 'dashed',
                    'Dotted'        => 'dotted',
                    'Double'        => 'double',
                    'Top Shadow'    => 'top-shadow',
                    'Bottom Shadow' => 'bottom-shadow',
                ),
                'description' => ''
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => '',
                'admin_label' => true,
                'heading'     => __( 'Border Color', 'wiz' ),
                'param_name'  => 'color',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Border Width', 'wiz' ),
                'param_name'  => 'width',
                'value'       => '80%',
                'description' => 'Separator width in percents.'
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Margin Top', 'wiz' ),
                'param_name'  => 'margintop',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Margin Bottom', 'wiz' ),
                'param_name'  => 'marginbottom',
                'value'       => '',
                'description' => ''
            ),
        )
    ) );


// Title
    vc_map( array(
        'name'     => __( 'Leap Title', 'wiz' ),
        'base'     => 'leap_title',
        'class'    => '',
        'category' => __( 'Leap Addons', 'wiz' ),
        'icon'     => get_template_directory_uri() . '/functions/vc/icons/leap-title.png',
        'params'   => array(
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => '',
                'admin_label' => true,
                'heading'     => __( 'Content', 'wiz' ),
                'param_name'  => 'content',
                'value'       => 'Title goes here',
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Heading', 'wiz' ),
                'param_name'  => 'heading',
                'value'       => array(
                    'H1' => 'h1',
                    'H2' => 'h2',
                    'H3' => 'h3',
                    'H4' => 'h4',
                    'H5' => 'h5',
                    'H6' => 'h6'
                ),
                'std' => 'h2',
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Align', 'wiz' ),
                'param_name'  => 'align',
                'value'       => array(
                    'None'   => 'none',
                    'Left'   => 'left',
                    'Center' => 'center',
                    'Right'  => 'right',
                ),
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Font Family', 'wiz' ),
                'param_name'  => 'font_family',
                'value'       => $families,
                'group'       => __( 'Typography', 'wiz' )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Font Size', 'wiz' ),
                'param_name'  => 'font_size',
                'value'       => '',
                'description' => '',
                'group'       => __( 'Typography', 'wiz' )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Line Height', 'wiz' ),
                'param_name'  => 'line_height',
                'value'       => '',
                'description' => '',
                'group'       => __( 'Typography', 'wiz' )
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => '',
                'admin_label' => true,
                'heading'     => __( 'Colors', 'wiz' ),
                'param_name'  => 'color',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Title Style', 'wiz' ),
                'param_name'  => 'style',
                'value'       => array(
                    'Style1' => 'style1',
                    'Style2' => 'style2',
                    'Style3' => 'style3',
                    'Style4' => 'style4',
                    'Style5' => 'style5',
                    'Style6' => 'style6',
                    'Style7' => 'style7',
                    'Style8' => 'style8'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => '',
                'admin_label' => true,
                'heading'     => __( 'Background Color', 'wiz' ),
                'param_name'  => 'background_color',
                'value'       => '',
                'description' => '',
                'dependency'  => array(
                    'element' => 'style',
                    'value'   => 'style3',
                    'value'   => 'style4',
                )
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => '',
                'admin_label' => true,
                'heading'     => __( 'Line Color', 'wiz' ),
                'param_name'  => 'border_color',
                'value'       => '',
                'description' => '',
                'dependency'  => array(
                    'element' => 'style',
                    'value'   => 'style3',
                )
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Strip', 'wiz' ),
                'param_name'  => 'strip',
                'value'       => array(
                    'Yes' => 'yes',
                    'No'  => 'no'
                ),
                'description' => '',
                'dependency'  => array(
                    'element' => 'style',
                    'value'   => 'style1',
                )
            ),
            array(
                'type'        => 'attach_image',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Image', 'wiz' ),
                'param_name'  => 'image',
                'value'       => '',
                'description' => '',
                'dependency'  => array(
                    'element' => 'style',
                    'value'   => 'style1',
                )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Strip Height', 'wiz' ),
                'param_name'  => 'strip_height',
                'value'       => '',
                'description' => '',
                'dependency'  => array(
                    'element' => 'style',
                    'value'   => 'style1',
                )
            ),
          array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Icon', 'wiz' ),
                'param_name'  => 'icon',
                'value'       => '',
                'description' => __( 'Ex. <b>chevron-right</b> <a target="_blank" href="http://fortawesome.github.io/Font-Awesome/icons/">Icon List</a>' ,'wiz' )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Margin Top', 'wiz' ),
                'param_name'  => 'margin_top',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Margin Bottom', 'wiz' ),
                'param_name'  => 'margin_bottom',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Style8 Strip Height', 'wiz' ),
                'param_name'  => 'style8_strip_height',
                'value'       => '',
                'description' => '',
                'dependency'  => array(
                    'element' => 'style',
                    'value'   => 'style8',
                )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Style8 Strip Width', 'wiz' ),
                'param_name'  => 'style8_strip_width',
                'value'       => '',
                'description' => '',
                'dependency'  => array(
                    'element' => 'style',
                    'value'   => 'style8',
                )
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Style8 Strip Color', 'wiz' ),
                'param_name'  => 'style8_strip_color',
                'value'       => '',
                'description' => '',
                'dependency'  => array(
                    'element' => 'style',
                    'value'   => 'style8',
                )
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Style8 Strip Align', 'wiz' ),
                'param_name'  => 'style8_strip_align',
                'value'       => array(
                    'None'   => 'none',
                    'Left'   => 'left',
                    'Center' => 'center',
                    'Right'  => 'right',
                ),
                'description' => '',
                'dependency'  => array(
                    'element' => 'style',
                    'value'   => 'style8',
                )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Style8 Top Spacing', 'wiz' ),
                'param_name'  => 'style8_strip_top_spacing',
                'value'       => '',
                'description' => '',
                'dependency'  => array(
                    'element' => 'style',
                    'value'   => 'style8',
                )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Style8 Bottom Spacing', 'wiz' ),
                'param_name'  => 'style8_strip_bottom_spacing',
                'value'       => '',
                'description' => '',
                'dependency'  => array(
                    'element' => 'style',
                    'value'   => 'style8',
                )
            ),
        )
    ) );


// Tagline
    vc_map( array(
        'name'     => __( 'Leap Tagline Box', 'wiz' ),
        'base'     => 'leap_tagline_box',
        'class'    => '',
        'category' => __( 'Leap Addons', 'wiz' ),
        'icon'     => get_template_directory_uri() . '/functions/vc/icons/leap-tagline-box.png',
        'params'   => array(
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Style', 'wiz' ),
                'param_name'  => 'style',
                'value'       => array(
                    'Tagline 1' => 'tagline-1',
                    'Tagline 2' => 'tagline-2',
                    'Tagline 3' => 'tagline-3',
                    'Tagline 4' => 'tagline-4'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Title', 'wiz' ),
                'param_name'  => 'title',
                'value'       => '',
                'description' => ''
            ),
            /*
              array(
              'type' => 'textarea',
              'holder' => 'div',
              'class' => 'hidden',
              'admin_label' => true,
              'heading' => __('Description', 'wiz'),
              'param_name' => 'content',
              'value' => '',
              'description' => ''
              ),
             */
            array(
                'type'        => 'textarea_html',
                'holder'      => 'div',
                'class'       => '',
                'heading'     => __( 'Content', 'wiz' ),
                'param_name'  => 'content',
                'value'       => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Cras nec lacus vel dolor euismod fringilla. In egestas arcu nisl, gravida varius lectus eleifend eu.',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Button Content', 'wiz' ),
                'param_name'  => 'button',
                'value'       => 'Button Text',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Link', 'wiz' ),
                'param_name'  => 'link',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Target', 'wiz' ),
                'param_name'  => 'target',
                'value'       => $url_target,
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Center Text', 'wiz' ),
                'param_name'  => 'centertext',
                'value'       => array(
                    'No'  => 'no',
                    'Yes' => 'yes'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Background color', 'wiz' ),
                'param_name'  => 'backgroundcolor',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Title Color', 'wiz' ),
                'param_name'  => 'titlecolor',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Text Color', 'wiz' ),
                'param_name'  => 'textcolor',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Border Size', 'wiz' ),
                'param_name'  => 'bordersize',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Border color', 'wiz' ),
                'param_name'  => 'bordercolor',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Border Style', 'wiz' ),
                'param_name'  => 'borderstyle',
                'value'       => array(
                    'solid'  => 'solid',
                    'Dashed' => 'dashed',
                    'Dotted' => 'dotted'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Custom Class', 'wiz' ),
                'param_name'  => 'class',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Animation Type', 'wiz' ),
                'param_name'  => 'animationtype',
                'value'       => $animation_types,
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Animation Speed', 'wiz' ),
                'param_name'  => 'animationspeed',
                'value'       => '',
                'description' => __( 'In seconds', 'wiz' )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Animation Delay', 'wiz' ),
                'param_name'  => 'animationdelay',
                'value'       => '',
                'description' => __( 'In seconds', 'wiz' )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Animation Iteration', 'wiz' ),
                'param_name'  => 'animationiteration',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Animation Offset', 'wiz' ),
                'param_name'  => 'animationoffset',
                'value'       => '',
                'description' => ''
            ),
        )
    ) );


// Portfolio Slider
    vc_map( array(
        'name'     => __( 'Leap Portfolio Slider', 'wiz' ),
        'base'     => 'leap_portfolio_slider',
        'class'    => '',
        'category' => __( 'Leap Addons', 'wiz' ),
        'icon'     => get_template_directory_uri() . '/functions/vc/icons/leap-portfolio-slider.png',
        'params'   => array(
            array(
                'type'        => 'checkbox',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Portfolio Categories', 'wiz' ),
                'param_name'  => 'cats',
                'value'       => $portfolio_categories,
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Number of Items', 'wiz' ),
                'param_name'  => 'num',
                'value'       => '10',
                'description' => ''
            ),
        )
    ) );

// QR Code
    vc_map( array(
        'name'     => __( 'Leap QR Code', 'wiz' ),
        'base'     => 'leap_qr',
        'class'    => '',
        'category' => __( 'Leap Addons', 'wiz' ),
        'icon'     => get_template_directory_uri() . '/functions/vc/icons/leap-qr-code.png',
        'params'   => array(
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Text', 'wiz' ),
                'param_name'  => 'text',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Width', 'wiz' ),
                'param_name'  => 'width',
                'value'       => '150',
                'description' => ''
            ),
        )
    ) );

// Quote
    vc_map( array(
        'name'     => __( 'Leap Quote', 'wiz' ),
        'base'     => 'leap_quote',
        'class'    => '',
        'category' => __( 'Leap Addons', 'wiz' ),
        'icon'     => get_template_directory_uri() . '/functions/vc/icons/leap-quote.png',
        'params'   => array(
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Style', 'wiz' ),
                'param_name'  => 'style',
                'value'       => array(
                    'Single Quotes'                 => 'single-quotes',
                    'Single Quotes with Background' => 'single-quotes-bg',
                    'Double Quotes'                 => 'double-quotes',
                    'Double Quotes with Background' => 'double-quotes-bg'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Background color', 'wiz' ),
                'param_name'  => 'bg_color',
                'value'       => '',
                'dependency'  => array(
                    'element' => 'style',
                    'value'   => array( 'single-quotes-bg', 'double-quotes-bg' ),
                ),
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Icon Size', 'wiz' ),
                'param_name'  => 'icon_size',
                'value'       => '',
                'description' => 'Ex. 15px'
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Icon color', 'wiz' ),
                'param_name'  => 'icon_color',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Padding Right', 'wiz' ),
                'param_name'  => 'padding_right',
                'value'       => '',
                'description' => 'Ex. 15px'
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Padding Left', 'wiz' ),
                'param_name'  => 'padding_left',
                'value'       => '',
                'description' => 'Ex. 15px'
            ),
            array(
                'type'        => 'textarea_html',
                'holder'      => 'div',
                'class'       => '',
                'heading'     => __( 'Content', 'wiz' ),
                'param_name'  => 'content',
                'value'       => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec at hendrerit ipsum. Nullam tincidunt tortor pulvinar sem sagittis fermentum.',
                'description' => ''
            ),
        )
    ) );

// RSS Feed
    vc_map( array(
        'name'     => __( 'Leap RSS Feed', 'wiz' ),
        'base'     => 'leap_rss',
        'class'    => '',
        'category' => __( 'Leap Addons', 'wiz' ),
        'icon'     => get_template_directory_uri() . '/functions/vc/icons/leap-rss-feed.png',
        'params'   => array(
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Number', 'wiz' ),
                'param_name'  => 'number',
                'value'       => '5',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Feed', 'wiz' ),
                'param_name'  => 'feed',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Date', 'wiz' ),
                'param_name'  => 'date',
                'value'       => array(
                    'Yes' => 'yes',
                    'No'  => 'no'
                ),
                'description' => ''
            ),
        )
    ) );

// Progress Bar
    vc_map( array(
        'name'     => __( 'Leap Progress Bar', 'wiz' ),
        'base'     => 'leap_progress_bar',
        'class'    => '',
        'category' => __( 'Leap Addons', 'wiz' ),
        'icon'     => get_template_directory_uri() . '/functions/vc/icons/leap-progress-bar.png',
        'params'   => array(
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Percentage', 'wiz' ),
                'param_name'  => 'percentage',
                'value'       => '25',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Label', 'wiz' ),
                'param_name'  => 'label',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Color', 'wiz' ),
                'param_name'  => 'color',
                'value'       => '#337ab7',
                'description' => ''
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Label Color', 'wiz' ),
                'param_name'  => 'labelcolor',
                'value'       => '#ffffff',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Height', 'wiz' ),
                'param_name'  => 'height',
                'value'       => '20px',
                'description' => ''
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Bar Background Color', 'wiz' ),
                'param_name'  => 'bgcolor',
                'value'       => '#f5f5f5',
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Striped', 'wiz' ),
                'param_name'  => 'striped',
                'value'       => array(
                    'Yes' => 'yes',
                    'No'  => 'no'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Animated', 'wiz' ),
                'param_name'  => 'animated',
                'value'       => array(
                    'Yes' => 'yes',
                    'No'  => 'no'
                ),
                'description' => ''
            ),
        )
    ) );

// Alert Box
    vc_map( array(
        'name'     => __( 'Leap Alert Box', 'wiz' ),
        'base'     => 'leap_alert_box',
        'class'    => '',
        'category' => __( 'Leap Addons', 'wiz' ),
        'icon'     => get_template_directory_uri() . '/functions/vc/icons/leap-alret-box.png',
        'params'   => array(
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Title', 'wiz' ),
                'param_name'  => 'title',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Type', 'wiz' ),
                'param_name'  => 'type',
                'value'       => array(
                    'Warning' => 'alert-warning',
                    'Info'    => 'alert-info',
                    'Success' => 'alert-success',
                    'Danger'  => 'alert-danger'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Icon', 'wiz' ),
                'param_name'  => 'icon',
                'value'       => array(
                    'Yes' => 'yes',
                    'No'  => 'no'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Close', 'wiz' ),
                'param_name'  => 'close',
                'value'       => array(
                    'Yes' => 'yes',
                    'No'  => 'no'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'textarea_html',
                'holder'      => 'div',
                'class'       => '',
                'heading'     => __( 'Content', 'wiz' ),
                'param_name'  => 'content',
                'value'       => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec at hendrerit ipsum. Nullam tincidunt tortor pulvinar sem sagittis fermentum.',
                'description' => ''
            ),
        )
    ) );

// Blog
    vc_map( array(
        'name'     => __( 'Leap Blog', 'wiz' ),
        'base'     => 'leap_blog',
        'class'    => '',
        'category' => __( 'Leap Addons', 'wiz' ),
        'icon'     => get_template_directory_uri() . '/functions/vc/icons/leap-blog.png',
        'params'   => array(
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Layout', 'wiz' ),
                'admin_label' => true,
                'param_name'  => 'layout',
                'value'       => array(
                    'Grid'         => 'grid',
                    'Classic'      => 'classic',
                    'Large'        => 'large',
                    'Large Modern' => 'large-modern',
                    'Right/Left Image' => 'rightleft-image',
                    'Medium'       => 'medium',
                    'Post Format'  => 'postformat'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Image Height for Right/Left blog style', 'wiz' ),
                'param_name'  => 'rightleft_image_height',
                'value'       => '',
                'description' => '',
                'dependency'  => array(
                    'element' => 'layout',
                    'value'   => 'rightleft-image',
                )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Number of Posts', 'wiz' ),
                'param_name'  => 'number_posts',
                'value'       => '5',
                'description' => ''
            ),
            array(
                'type'        => 'checkbox',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Categories', 'wiz' ),
                'param_name'  => 'cats',
                'value'       => $post_categories,
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Excerpt', 'wiz' ),
                'param_name'  => 'excerpt',
                'value'       => array(
                    'Yes' => 'yes',
                    'No'  => 'no'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Excerpt Length', 'wiz' ),
                'param_name'  => 'excerptlength',
                'value'       => '55',
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Author Meta', 'wiz' ),
                'param_name'  => 'meta_author',
                'value'       => array(
                    'Yes' => 'yes',
                    'No'  => 'no'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Categories Meta', 'wiz' ),
                'param_name'  => 'meta_categories',
                'value'       => array(
                    'Yes' => 'yes',
                    'No'  => 'no'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Comments Meta', 'wiz' ),
                'param_name'  => 'meta_comments',
                'value'       => array(
                    'Yes' => 'yes',
                    'No'  => 'no'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Date Meta', 'wiz' ),
                'param_name'  => 'meta_date',
                'value'       => array(
                    'Yes' => 'yes',
                    'No'  => 'no'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Tags Meta', 'wiz' ),
                'param_name'  => 'meta_tags',
                'value'       => array(
                    'Yes' => 'yes',
                    'No'  => 'no'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Paging', 'wiz' ),
                'param_name'  => 'paging',
                'value'       => array(
                    'Yes' => 'yes',
                    'No'  => 'no'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Share Buttons', 'wiz' ),
                'param_name'  => 'share_buttons',
                'value'       => array(
                    'Yes' => 'yes',
                    'No'  => 'no'
                ),
                'description' => ''
            ),
        )
    ) );


    vc_map( array(
        'name'     => __( 'Leap Portfolio', 'wiz' ),
        'base'     => 'leap_portfolio',
        'class'    => '',
        'category' => __( 'Leap Addons', 'wiz' ),
        'icon'     => get_template_directory_uri() . '/functions/vc/icons/leap-portfolio.png',
        'params'   => array(
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Layout', 'wiz' ),
                'param_name'  => 'layout',
                'value'       => array(
                    'Grid'         => 'grid',
                    'One Column'   => '1col',
                    'Two Column'   => '2col',
                    'Three Column' => '3col',
                    'Four Column'  => '4col'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'checkbox',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Categories', 'wiz' ),
                'param_name'  => 'cats',
                'value'       => $portfolio_categories,
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Number of posts per page', 'wiz' ),
                'param_name'  => 'num',
                'value'       => '10',
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Display items without featured image', 'wiz' ),
                'param_name'  => 'without_featured_image',
                'value'       => array(
                    'Yes' => 'yes',
                    'No'  => 'no'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Order', 'wiz' ),
                'param_name'  => 'order',
                'value'       => array(
                    'Descending' => 'DESC',
                    'Ascending'  => 'ASC'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Order By', 'wiz' ),
                'param_name'  => 'orderby',
                'value'       => array(
                    'Date'   => 'date',
                    'Title'  => 'title',
                    'Random' => 'rand'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Filter', 'wiz' ),
                'param_name'  => 'filter',
                'value'       => array(
                    'Yes' => 'yes',
                    'No'  => 'no'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Show Titles', 'wiz' ),
                'param_name'  => 'titles',
                'value'       => array(
                    'Yes' => 'yes',
                    'No'  => 'no'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Show Categories', 'wiz' ),
                'param_name'  => 'categories',
                'value'       => array(
                    'Yes' => 'yes',
                    'No'  => 'no'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Show Descriptions', 'wiz' ),
                'param_name'  => 'descriptions',
                'value'       => array(
                    'Yes' => 'yes',
                    'No'  => 'no'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Excerpt Length', 'wiz' ),
                'param_name'  => 'excerptlength',
                'value'       => '',
                'description' => 'Leave empty to use the default length which is 55.'
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Display Read More Button', 'wiz' ),
                'param_name'  => 'readmore_button',
                'value'       => array(
                    'Yes' => 'yes',
                    'No'  => 'no'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Display Visit Project Button', 'wiz' ),
                'param_name'  => 'visit_button',
                'value'       => array(
                    'Yes' => 'yes',
                    'No'  => 'no'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Separator', 'wiz' ),
                'param_name'  => 'separator',
                'value'       => array(
                    'Yes' => 'yes',
                    'No'  => 'no'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Paging', 'wiz' ),
                'param_name'  => 'paging',
                'value'       => array(
                    'Yes' => 'yes',
                    'No'  => 'no'
                ),
                'description' => ''
            )
        )
    ) );


    vc_map( array(
        'name'     => __( 'Leap Person', 'wiz' ),
        'base'     => 'leap_person',
        'class'    => '',
        'category' => __( 'Leap Addons', 'wiz' ),
        'icon'     => get_template_directory_uri() . '/functions/vc/icons/leap-person.png',
        'params'   => array(
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Name', 'wiz' ),
                'param_name'  => 'name',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Name Color', 'wiz' ),
                'param_name'  => 'namecolor',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'attach_image',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Picture', 'wiz' ),
                'param_name'  => 'picture',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Size', 'wiz' ),
                'param_name'  => 'size',
                'value'       => '75x75',
                'description' => 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Example: 200x100 (Width x Height)).'
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Type', 'wiz' ),
                'param_name'  => 'type',
                'value'       => array(
                    'Polaroid' => 'polaroid',
                    'Rounded'  => 'rounded',
                    'Circle'   => 'circle'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Title', 'wiz' ),
                'param_name'  => 'title',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Title Text Color', 'wiz' ),
                'param_name'  => 'titlecolor',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'FaceBook', 'wiz' ),
                'param_name'  => 'facebook',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Twitter', 'wiz' ),
                'param_name'  => 'twitter',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'LinkedIn', 'wiz' ),
                'param_name'  => 'linkedin',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Dribbble', 'wiz' ),
                'param_name'  => 'dribbble',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Google+', 'wiz' ),
                'param_name'  => 'googlep',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Email', 'wiz' ),
                'param_name'  => 'email',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Target', 'wiz' ),
                'param_name'  => 'linktarget',
                'value'       => $url_target,
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Center', 'wiz' ),
                'param_name'  => 'center',
                'value'       => array(
                    'No'  => 'no',
                    'Yes' => 'yes'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'textarea_html',
                'holder'      => 'div',
                'class'       => '',
                'heading'     => __( 'Content', 'wiz' ),
                'param_name'  => 'content',
                'value'       => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec at hendrerit ipsum. Nullam tincidunt tortor pulvinar sem sagittis fermentum.',
                'description' => ''
            ),
        )
    ) );
vc_map( array(
        'name'     => __( 'Leap Person 2', 'wiz' ),
        'base'     => 'leap_person_2',
        'class'    => '',
        'category' => __( 'Leap Addons', 'wiz' ),
        'icon'     => get_template_directory_uri() . '/functions/vc/icons/leap-person.png',
        'params'   => array(
            array(
                'type'        => 'attach_image',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Picture', 'wiz' ),
                'param_name'  => 'picture',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Hover Image Effect', 'wiz' ),
                'param_name'  => 'hover_image_effect',
                'value'       => array(
                    'Zoom In' => 'zoom-in',
                    'Zoom Out'=> 'zoom-out',
                    'Scale'   => 'scale',
                    'Grayscale'    => 'grayscale',
                    'Blur'    => 'blur'
                    )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Size', 'wiz' ),
                'param_name'  => 'size',
                'value'       => 'full',
                'description' => 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Example: 200x100 (Width x Height)).'
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Name', 'wiz' ),
                'param_name'  => 'name',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Name Text Color', 'wiz' ),
                'param_name'  => 'name_color',
                'value'       => '',
                'description' => '',
                'group'       => __( 'Colors', 'wiz' )
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Name Heading', 'wiz' ),
                'param_name'  => 'name_heading',
                'value'       => array(
                    'H1' => 'h1',
                    'H2' => 'h2',
                    'H3' => 'h3',
                    'H4' => 'h4',
                    'H5' => 'h5',
                    'H6' => 'h6'
                ),
                'std' => 'h2',
                'save_always' => true,
                'description' => '',
                'group'       => __( 'Typography', 'wiz' )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Ttile', 'wiz' ),
                'param_name'  => 'title',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Title Text Color', 'wiz' ),
                'param_name'  => 'title_color',
                'value'       => '',
                'description' => '',
                'group'       => __( 'Colors', 'wiz' )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Title Font Size', 'wiz' ),
                'param_name'  => 'title_font_size',
                'value'       => '',
                'description' => '',
                'group'       => __( 'Typography', 'wiz' )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'FaceBook', 'wiz' ),
                'param_name'  => 'facebook',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Twitter', 'wiz' ),
                'param_name'  => 'twitter',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'LinkedIn', 'wiz' ),
                'param_name'  => 'linkedin',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Dribbble', 'wiz' ),
                'param_name'  => 'dribbble',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Google+', 'wiz' ),
                'param_name'  => 'googlep',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Email', 'wiz' ),
                'param_name'  => 'email',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Social Color', 'wiz' ),
                'param_name'  => 'social_color',
                'value'       => '',
                'description' => '',
                'group'       => __( 'Colors', 'wiz' )
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Social Hover Color', 'wiz' ),
                'param_name'  => 'social_hover_color',
                'value'       => '',
                'description' => '',
                'group'       => __( 'Colors', 'wiz' )
            ),
            array(
                'type'        => 'textarea_html',
                'holder'      => 'div',
                'class'       => '',
                'heading'     => __( 'Content', 'wiz' ),
                'param_name'  => 'content',
                'value'       => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec at hendrerit ipsum. Nullam tincidunt tortor pulvinar sem sagittis fermentum.',
                'description' => ''
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Content Background Color', 'wiz' ),
                'param_name'  => 'content_background_color',
                'value'       => '',
                'description' => '',
                'group'       => __( 'Colors', 'wiz' )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Border Bottom Width', 'wiz' ),
                'param_name'  => 'border_bottom_width',
                'value'       => '',
                'description' => ''
            ),
        )
    ) );
    vc_map( array(
        'name'     => __( 'Leap Flickr', 'wiz' ),
        'base'     => 'leap_flickr',
        'class'    => '',
        'category' => __( 'Leap Addons', 'wiz' ),
        'icon'     => get_template_directory_uri() . '/functions/vc/icons/leap-flickr.png',
        'params'   => array(
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Account Id', 'wiz' ),
                'param_name'  => 'account_id',
                'value'       => '',
                'description' => 'Get it from <a target="_blank" href="http://www.idgettr.com">idGettr</a>'
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Number', 'wiz' ),
                'param_name'  => 'number',
                'value'       => '5',
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Order by', 'wiz' ),
                'param_name'  => 'orderby',
                'value'       => array(
                    'Latest' => 'latest',
                    'Random' => 'random'
                ),
                'description' => ''
            ),
        )
    ) );

    vc_map( array(
        'name'     => __( 'Leap Gap', 'wiz' ),
        'base'     => 'leap_gap',
        'class'    => '',
        'category' => __( 'Leap Addons', 'wiz' ),
        'icon'     => get_template_directory_uri() . '/functions/vc/icons/leap-gap.png',
        'params'   => array(
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Height', 'wiz' ),
                'param_name'  => 'height',
                'value'       => '20px',
                'description' => ''
            ),
        )
    ) );

    vc_map( array(
        'name'     => __( 'Leap Google Font', 'wiz' ),
        'base'     => 'leap_google_font',
        'class'    => '',
        'category' => __( 'Leap Addons', 'wiz' ),
        'icon'     => get_template_directory_uri() . '/functions/vc/icons/leap-google-fonts.png',
        'params'   => array(
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Font Family', 'wiz' ),
                'param_name'  => 'family',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Font Size', 'wiz' ),
                'param_name'  => 'size',
                'value'       => '20px',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Line Height', 'wiz' ),
                'param_name'  => 'lineheight',
                'value'       => '20px',
                'description' => ''
            ),
            array(
                'type'        => 'textarea_html',
                'holder'      => 'div',
                'class'       => '',
                'heading'     => __( 'Content', 'wiz' ),
                'param_name'  => 'content',
                'value'       => 'Lorem ipsum dolor sit amet.',
                'description' => ''
            ),
        )
    ) );



    /**
     * Video Shortcode
     */
    vc_map( array(
        'name'     => __( 'Leap Video', 'wiz' ),
        'base'     => 'leap_video',
        'class'    => '',
        'category' => __( 'Leap Addons', 'wiz' ),
        'icon'     => get_template_directory_uri() . '/functions/vc/icons/leap-video.png',
        'params'   => array(
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Video Type', 'wiz' ),
                'param_name'  => 'video_type',
                'value'       => array(
                    'Youtube'     => 'youtube',
                    'Vimeo'       => 'vimeo',
                    'Dailymotion' => 'dailymotion'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Video Id', 'wiz' ),
                'param_name'  => 'video_id',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Width', 'wiz' ),
                'param_name'  => 'width',
                'value'       => '550',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Height', 'wiz' ),
                'param_name'  => 'height',
                'value'       => '300',
                'description' => ''
            )
        )
    ) );

    /**
     * Soundcloud Shortcode
     */
    vc_map( array(
        'name'     => __( 'Leap Soundcloud', 'wiz' ),
        'base'     => 'leap_soundcloud',
        'class'    => '',
        'category' => __( 'Leap Addons', 'wiz' ),
        'icon'     => get_template_directory_uri() . '/functions/vc/icons/leap-soundcloud.png',
        'params'   => array(
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'URL', 'wiz' ),
                'param_name'  => 'url',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Display Comments', 'wiz' ),
                'param_name'  => 'comments',
                'value'       => array(
                    'True'  => 'true',
                    'False' => 'false'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Auto Play', 'wiz' ),
                'param_name'  => 'auto_play',
                'value'       => array(
                    'False' => 'false',
                    'True'  => 'true'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Width', 'wiz' ),
                'param_name'  => 'width',
                'value'       => '100%',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Height', 'wiz' ),
                'param_name'  => 'height',
                'value'       => '118',
                'description' => ''
            )
        )
    ) );


    /**
     * Toggle Shortcode
     */
    vc_map( array(
        'name'     => __( 'Leap Toggle', 'wiz' ),
        'base'     => 'leap_toggle',
        'class'    => '',
        'category' => __( 'Leap Addons', 'wiz' ),
        'icon'     => get_template_directory_uri() . '/functions/vc/icons/leap-toggle.png',
        'params'   => array(
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Style', 'wiz' ),
                'param_name'  => 'style',
                'value'       => array(
                    'Style 1' => 'style-1',
                    'Style 2' => 'style-2',
                    'Style 3' => 'style-3'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Open', 'wiz' ),
                'param_name'  => 'open',
                'value'       => array(
                    'Yes' => 'yes',
                    'No'  => 'no'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Title', 'wiz' ),
                'param_name'  => 'title',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textarea_html',
                'holder'      => 'div',
                'class'       => '',
                'heading'     => __( 'Content', 'wiz' ),
                'param_name'  => 'content',
                'value'       => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec at hendrerit ipsum. Nullam tincidunt tortor pulvinar sem sagittis fermentum.',
                'description' => ''
            )
        )
    ) );


    /**
     * iframe Shortcode
     */
    vc_map( array(
        'name'     => __( 'Leap Iframe', 'wiz' ),
        'base'     => 'leap_iframe',
        'class'    => '',
        'category' => __( 'Leap Addons', 'wiz' ),
        'icon'     => get_template_directory_uri() . '/functions/vc/icons/leap-iframe.png',
        'params'   => array(
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'URL', 'wiz' ),
                'param_name'  => 'url',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Width', 'wiz' ),
                'param_name'  => 'width',
                'value'       => '500',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Height', 'wiz' ),
                'param_name'  => 'height',
                'value'       => '300',
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Scrolling', 'wiz' ),
                'param_name'  => 'scrolling',
                'value'       => array(
                    'No'  => 'no',
                    'Yes' => 'yes'
                ),
                'description' => ''
            )
        )
    ) );

// Image
    vc_map( array(
        'name'     => __( 'Leap Image', 'wiz' ),
        'base'     => 'leap_image',
        'class'    => '',
        'category' => __( 'Leap Addons', 'wiz' ),
        'icon'     => get_template_directory_uri() . '/functions/vc/icons/leap-image.png',
        'params'   => array(
            array(
                'type'        => 'attach_image',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Image', 'wiz' ),
                'param_name'  => 'image',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Image Alt Text', 'wiz' ),
                'param_name'  => 'imagealt',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Image Width', 'wiz' ),
                'param_name'  => 'width',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Image Height', 'wiz' ),
                'param_name'  => 'height',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Align', 'wiz' ),
                'param_name'  => 'align',
                'value'       => array(
                    'None'   => 'none',
                    'Left'   => 'left',
                    'Center' => 'center',
                    'Right'  => 'right',
                ),
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Light Box', 'wiz' ),
                'param_name'  => 'lightbox',
                'value'       => array(
                    'No'  => 'no',
                    'Yes' => 'yes'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Border Size', 'wiz' ),
                'param_name'  => 'bordersize',
                'value'       => '0px',
                'description' => ''
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Border color', 'wiz' ),
                'param_name'  => 'bordercolor',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Border Style', 'wiz' ),
                'param_name'  => 'borderstyle',
                'value'       => array(
                    'solid'  => 'solid',
                    'Dashed' => 'dashed',
                    'Dotted' => 'dotted'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Padding', 'wiz' ),
                'param_name'  => 'padding',
                'value'       => '0px',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Margin Top', 'wiz' ),
                'param_name'  => 'margintop',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Margin Right', 'wiz' ),
                'param_name'  => 'marginright',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Margin Bottom', 'wiz' ),
                'param_name'  => 'marginbottom',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Margin Left', 'wiz' ),
                'param_name'  => 'marginleft',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Background color', 'wiz' ),
                'param_name'  => 'backgroundcolor',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Custom Class', 'wiz' ),
                'param_name'  => 'class',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Animation Type', 'wiz' ),
                'param_name'  => 'animationtype',
                'value'       => $animation_types,
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Animation Speed', 'wiz' ),
                'param_name'  => 'animationspeed',
                'value'       => '',
                'description' => __( 'In seconds', 'wiz' )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Animation Delay', 'wiz' ),
                'param_name'  => 'animationdelay',
                'value'       => '',
                'description' => __( 'In seconds', 'wiz' )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Animation Iteration', 'wiz' ),
                'param_name'  => 'animationiteration',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Animation Offset', 'wiz' ),
                'param_name'  => 'animationoffset',
                'value'       => '',
                'description' => ''
            ),
        )
    ) );













    // Nested Shortcodes
    vc_map( array(
        "name"                    => __( "Leap Testimonials", 'wiz' ),
        "base"                    => "leap_testimonials",
        'category'                => __( 'Leap Addons', 'wiz' ),
        'icon'                    => get_template_directory_uri() . '/functions/vc/icons/leap-testimonials.png',
        "as_parent"               => array( 'only' => 'leap_testimonial' ),
        "content_element"         => true,
        "show_settings_on_create" => true,
        "params"                  => array(
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Background Color', 'wiz' ),
                'param_name'  => 'backgroundcolor',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Border Color', 'wiz' ),
                'param_name'  => 'bordercolor',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Name Color', 'wiz' ),
                'param_name'  => 'namecolor',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Company Color', 'wiz' ),
                'param_name'  => 'companycolor',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Display Controls', 'wiz' ),
                'param_name'  => 'controls',
                'value'       => array(
                    'Yes' => 'yes',
                    'No'  => 'no'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Rotate Time', 'wiz' ),
                'param_name'  => 'timeout',
                'value'       => '4000',
                'description' => __( 'Time in millisecond. 4000 = 4 seconds.', 'wiz' )
            ),
        ),
        "js_view"                 => 'VcColumnView'
    ) );
    vc_map( array(
        "name"            => __( "Leap Testimonial", 'wiz' ),
        "base"            => "leap_testimonial",
        "content_element" => true,
        "as_child"        => array( 'only' => 'leap_testimonials' ),
        'icon'            => get_template_directory_uri() . '/functions/vc/icons/leap-testimonials.png',
        "params"          => array(
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Name', 'wiz' ),
                'param_name'  => 'name',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'attach_image',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Image', 'wiz' ),
                'param_name'  => 'image',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Size', 'wiz' ),
                'param_name'  => 'size',
                'value'       => '75x75',
                'description' => __( 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Example: 200x100 (Width x Height)).', 'wiz' )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Company', 'wiz' ),
                'param_name'  => 'company',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Link', 'wiz' ),
                'param_name'  => 'link',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Target', 'wiz' ),
                'param_name'  => 'linktarget',
                'value'       => $url_target,
                'description' => ''
            ),
            array(
                'type'        => 'textarea_html',
                'holder'      => 'div',
                'class'       => '',
                'heading'     => __( 'Content', 'wiz' ),
                'param_name'  => 'content',
                'value'       => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec at hendrerit ipsum. Nullam tincidunt tortor pulvinar sem sagittis fermentum.',
                'description' => ''
            )
        )
    ) );


// Shortcodes Testimonials 2            
vc_map( array(
        'name'     =>esc_html__( 'Leap Testimonials 2', 'wiz' ),
        'base'     => 'leap_testimonials_2',
        'class'    => '',
        'category' =>esc_html__( 'Leap Addons', 'wiz' ),
        'icon'     => get_template_directory_uri() . '/functions/vc/icons/leap-testimonials.png',
        'params'   => array(
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     =>esc_html__( 'Person Name', 'wiz' ),
                'param_name'  => 'name',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'attach_image',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     =>esc_html__( 'Image', 'wiz' ),
                'param_name'  => 'image',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     =>esc_html__( 'Size', 'wiz' ),
                'param_name'  => 'size',
                'value'       => '75x75',
                'description' =>esc_html__( 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Example: 200x100 (Width x Height)).', 'wiz' )
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     =>esc_html__( 'Person Image Shap', 'wiz' ),
                'param_name'  => 'person_image_shape',
                'value'       => array(
                    'Circle'  => 'circle',
                    'Rounded' => 'rounded',
                    'Square'  => 'square'
                    )
                ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     =>esc_html__( 'Image Border Width', 'wiz' ),
                'param_name'  => 'image_border_width',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     =>esc_html__( 'Image Border Color', 'wiz' ),
                'param_name'  => 'image_border_color',
                'value'       => '',
                'description' => '',
                'group'       =>esc_html__( 'Color', 'wiz' )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     =>esc_html__( 'Company', 'wiz' ),
                'param_name'  => 'company',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     =>esc_html__( 'Link', 'wiz' ),
                'param_name'  => 'link',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     =>esc_html__( 'Target', 'wiz' ),
                'param_name'  => 'linktarget',
                'value'       => $url_target,
                'description' => ''
            ),
            array(
                'type'        => 'textarea_html',
                'holder'      => 'div',
                'class'       => '',
                'heading'     =>esc_html__( 'Content', 'wiz' ),
                'param_name'  => 'content',
                'value'       => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec at hendrerit ipsum. Nullam tincidunt tortor pulvinar sem sagittis fermentum.',
                'description' => ''
            ),
                        array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     =>esc_html__( 'Testimonial Margin Left', 'wiz' ),
                'param_name'  => 'testimonial_margin_left',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     =>esc_html__( 'Testimonial Margin Right', 'wiz' ),
                'param_name'  => 'testimonial_margin_right',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     =>esc_html__( 'Quote Icons Size', 'wiz' ),
                'param_name'  => 'quote_icons_size',
                'value'       => '',
                'description' => '',
                'group'       =>esc_html__( 'Typography', 'wiz' )
            ),  
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     =>esc_html__( 'Quote Icons Color', 'wiz' ),
                'param_name'  => 'quote_icons_color',
                'value'       => '',
                'description' => '',
                'group'       =>esc_html__( 'Color', 'wiz' )
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     =>esc_html__( 'Person Name Font Family', 'wiz' ),
                'param_name'  => 'person_name_font_family',
                'value'       => $families,
                'group'       =>esc_html__( 'Typography', 'wiz' )
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     =>esc_html__( 'Person Name Heading', 'wiz' ),
                'param_name'  => 'person_name_heading',
                'value'       => array(
                    'H1' => 'h1',
                    'H2' => 'h2',
                    'H3' => 'h3',
                    'H4' => 'h4',
                    'H5' => 'h5',
                    'H6' => 'h6'
                ),
                'std' => 'h4',
                'save_always' => true,
                'description' => '',
                'group'       =>esc_html__( 'Typography', 'wiz' )
            ), 
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     =>esc_html__( 'Person Name Color', 'wiz' ),
                'param_name'  => 'person_name_color',
                'value'       => '',
                'description' => '',
                'group'       =>esc_html__( 'Color', 'wiz' )
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     =>esc_html__( 'Company Name Font Family', 'wiz' ),
                'param_name'  => 'company_name_font_family',
                'value'       => $families,
                'group'       =>esc_html__( 'Typography', 'wiz' )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     =>esc_html__( 'Company Name Size', 'wiz' ),
                'param_name'  => 'company_name_size',
                'value'       => '',
                'description' => '',
                'group'       =>esc_html__( 'Typography', 'wiz' )
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     =>esc_html__( 'Company Name Color', 'wiz' ),
                'param_name'  => 'company_name_color',
                'value'       => '',
                'description' => '',
                'group'       =>esc_html__( 'Color', 'wiz' )
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     =>esc_html__( 'Separator Color', 'wiz' ),
                'param_name'  => 'separator_color',
                'value'       => '',
                'description' => '',
                'group'       =>esc_html__( 'Color', 'wiz' )
            )
            )
    ) );

    vc_map( array(
        "name"                    => __( "Leap Clients", 'wiz' ),
        "base"                    => "leap_clients",
        'category'                => __( 'Leap Addons', 'wiz' ),
        'icon'                    => get_template_directory_uri() . '/functions/vc/icons/leap-clients.png',
        "as_parent"               => array( 'only' => 'leap_client' ),
        "content_element"         => true,
        "show_settings_on_create" => false,
        "params"                  => array(
        ),
        "js_view"                 => 'VcColumnView'
    ) );
    vc_map( array(
        "name"            => __( "Leap Client", 'wiz' ),
        "base"            => "leap_client",
        'icon'            => get_template_directory_uri() . '/functions/vc/icons/leap-clients.png',
        "content_element" => true,
        "as_child"        => array( 'only' => 'leap_clients' ),
        "params"          => array(
            array(
                'type'        => 'attach_image',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Image', 'wiz' ),
                'param_name'  => 'image',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Link', 'wiz' ),
                'param_name'  => 'link',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Target', 'wiz' ),
                'param_name'  => 'linktarget',
                'value'       => $url_target,
                'description' => ''
            )
        )
    ) );



    vc_map( array(
        "name"                    => __( "Leap Accordion", 'wiz' ),
        "base"                    => "leap_accordion",
        'category'                => __( 'Leap Addons', 'wiz' ),
        'icon'                    => get_template_directory_uri() . '/functions/vc/icons/leap-accordion.png',
        "as_parent"               => array( 'only' => 'leap_accordion_item' ),
        "content_element"         => true,
        "show_settings_on_create" => true,
        "params"                  => array(
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Style', 'wiz' ),
                'param_name'  => 'style',
                'value'       => array(
                    'Style 1' => 'style-1',
                    'Style 2' => 'style-2',
                    'Style 3' => 'style-3'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Title Text Color', 'wiz' ),
                'param_name'  => 'title_color',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Title Text Hover Color', 'wiz' ),
                'param_name'  => 'title_hover_color',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Title Background Color', 'wiz' ),
                'param_name'  => 'title_bg',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Title Background Hover Color', 'wiz' ),
                'param_name'  => 'title_hover_bg',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => false,
                'heading'     => __( 'Content Background Color', 'wiz' ),
                'param_name'  => 'content_bg',
                'value'       => '',
                'description' => ''
            ),
        ),
        "js_view"                 => 'VcColumnView'
    ) );
    vc_map( array(
        "name"            => __( "Leap Accordion Item", 'wiz' ),
        "base"            => "leap_accordion_item",
        'icon'            => get_template_directory_uri() . '/functions/vc/icons/leap-accordion.png',
        "content_element" => true,
        "as_child"        => array( 'only' => 'leap_accordion' ),
        "params"          => array(
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Title', 'wiz' ),
                'param_name'  => 'title',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textarea_html',
                'holder'      => 'div',
                'class'       => '',
                'heading'     => __( 'Content', 'wiz' ),
                'param_name'  => 'content',
                'value'       => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec at hendrerit ipsum. Nullam tincidunt tortor pulvinar sem sagittis fermentum.',
                'description' => ''
            )
        )
    ) );



    vc_map( array(
        "name"                    => __( "Leap List", 'wiz' ),
        "base"                    => "leap_ul",
        'category'                => __( 'Leap Addons', 'wiz' ),
        'icon'                    => get_template_directory_uri() . '/functions/vc/icons/leap-list.png',
        "as_parent"               => array( 'only' => 'leap_li' ),
        "content_element"         => true,
        "show_settings_on_create" => false,
        "params"                  => array(
        ),
        "js_view"                 => 'VcColumnView'
    ) );
    vc_map( array(
        "name"            => __( "Leap List Item", 'wiz' ),
        "base"            => "leap_li",
        'icon'            => get_template_directory_uri() . '/functions/vc/icons/leap-list.png',
        "content_element" => true,
        "as_child"        => array( 'only' => 'leap_ul' ),
        "params"          => array(
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Icon Name', 'wiz' ),
                'param_name'  => 'icon',
                'value'       => 'fa-chevron-right',
                'description' => ''
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'admin_label' => true,
                'heading'     => __( 'Icon Color', 'wiz' ),
                'param_name'  => 'iconcolor',
                'value'       => '#000000',
                'description' => ''
            ),
            array(
                'type'        => 'textarea_html',
                'holder'      => 'div',
                'class'       => '',
                'heading'     => __( 'Content', 'wiz' ),
                'param_name'  => 'content',
                'value'       => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec at hendrerit ipsum. Nullam tincidunt tortor pulvinar sem sagittis fermentum.',
                'description' => ''
            )
        )
    ) );

    // Full Width Container
    vc_map( array(
        'name'                    => __( 'Leap Full Width Container', 'wiz' ),
        'base'                    => 'leap_fullwidth',
        'class'                   => '',
        'category'                => __( 'Leap Addons', 'wiz' ),
        'icon'                    => get_template_directory_uri() . '/functions/vc/icons/leap-full-width-container.png',
        "as_parent"               => array( 'except' => '' ),
        "content_element"         => true,
        "show_settings_on_create" => true,
        "js_view"                 => 'VcColumnView',
        'params'                  => array(
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Background color', 'wiz' ),
                'param_name'  => 'backgroundcolor',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'attach_image',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Background Image', 'wiz' ),
                'param_name'  => 'backgroundimage',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Background Repeat', 'wiz' ),
                'param_name'  => 'backgroundrepeat',
                'value'       => array(
                    'No Repeat'                          => 'no-repeat',
                    'Repeat Vertically and Horizontally' => 'repeat',
                    'Repeat Horizontally'                => 'repeat-x',
                    'Repeat Vertically'                  => 'repeat-y'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Background Position', 'wiz' ),
                'param_name'  => 'backgroundposition',
                'value'       => array(
                    'Left Top'      => 'left top',
                    'Left Center'   => 'left center',
                    'Left Bottom'   => 'left bottom',
                    'Right Top'     => 'right top',
                    'Right Center'  => 'right center',
                    'Right Bottom'  => 'right bottom',
                    'Center Top'    => 'center top',
                    'Center Center' => 'center center',
                    'Center Bottom' => 'center bottom'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Background Attachment', 'wiz' ),
                'param_name'  => 'backgroundattachment',
                'value'       => array(
                    'Scroll' => 'scroll',
                    'Fixed'  => 'fixed',
                ),
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Parallax Background', 'wiz' ),
                'param_name'  => 'parallax',
                'value'       => array(
                    'No'  => 'no',
                    'Yes' => 'yes',
                ),
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Border Size', 'wiz' ),
                'param_name'  => 'bordersize',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'colorpicker',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Border color', 'wiz' ),
                'param_name'  => 'bordercolor',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Border Style', 'wiz' ),
                'param_name'  => 'borderstyle',
                'value'       => array(
                    'solid'  => 'solid',
                    'Dashed' => 'dashed',
                    'Dotted' => 'dotted'
                ),
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Padding Top', 'wiz' ),
                'param_name'  => 'paddingtop',
                'value'       => '20px',
                'description' => __( 'In pixels', 'wiz' )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Padding Bottom', 'wiz' ),
                'param_name'  => 'paddingbottom',
                'value'       => '20px',
                'description' => __( 'In pixels', 'wiz' )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Content Padding Left', 'wiz' ),
                'param_name'  => 'contentpaddingleft',
                'value'       => '',
                'description' => __( 'In pixels', 'wiz' )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Content Padding Right', 'wiz' ),
                'param_name'  => 'contentpaddingright',
                'value'       => '',
                'description' => __( 'In pixels', 'wiz' )
            ),
            /*
              array(
              'type' => 'textarea_html',
              'holder' => 'div',
              'class' => '',
              'heading' => __('Content', 'wiz'),
              'param_name' => 'content',
              'value' => '',
              'description' => ''
              ),
             */
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Class', 'wiz' ),
                'param_name'  => 'class',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Id', 'wiz' ),
                'param_name'  => 'id',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'dropdown',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Animation Type', 'wiz' ),
                'param_name'  => 'animationtype',
                'value'       => $animation_types,
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Animation Speed', 'wiz' ),
                'param_name'  => 'animationspeed',
                'value'       => '',
                'description' => __( 'In seconds', 'wiz' )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Animation Delay', 'wiz' ),
                'param_name'  => 'animationdelay',
                'value'       => '',
                'description' => __( 'In seconds', 'wiz' )
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Animation Iteration', 'wiz' ),
                'param_name'  => 'animationiteration',
                'value'       => '',
                'description' => ''
            ),
            array(
                'type'        => 'textfield',
                'holder'      => 'div',
                'class'       => 'hidden',
                'heading'     => __( 'Animation Offset', 'wiz' ),
                'param_name'  => 'animationoffset',
                'value'       => '',
                'description' => ''
            ),
        )
    ) );



//Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
    if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {

        class WPBakeryShortCode_Leap_Fullwidth extends WPBakeryShortCodesContainer {
            
        }

        class WPBakeryShortCode_Leap_Testimonials extends WPBakeryShortCodesContainer {
            
        }

        class WPBakeryShortCode_Leap_Clients extends WPBakeryShortCodesContainer {
            
        }

        class WPBakeryShortCode_Leap_Accordion extends WPBakeryShortCodesContainer {
            
        }

        class WPBakeryShortCode_Leap_Ul extends WPBakeryShortCodesContainer {
            
        }

    }
    if ( class_exists( 'WPBakeryShortCode' ) ) {

        class WPBakeryShortCode_Leap_Testimonial extends WPBakeryShortCode {
            
        }

        class WPBakeryShortCode_Leap_Client extends WPBakeryShortCode {
            
        }

        class WPBakeryShortCode_Leap_Accordion_Item extends WPBakeryShortCode {
            
        }

        class WPBakeryShortCode_Leap_Li extends WPBakeryShortCode {
            
        }

    }
}

add_action( 'vc_before_init', 'leap_vc_shortcodes' );
