<?php

if ( !defined( 'ABSPATH' ) ) {
    die( 'No direct access allowed' );
}

function leap_theme_upgrade( $old_version, $new_version ) {

    /*
     * Use new portfolio fields generator
     */
    if ( version_compare( $old_version, '2.0.0', '<' ) ) {
        $saved_options    = get_option( ot_options_id() );
        $portfolio_fields = array(
            array(
                'title'    => 'URL',
                'id'       => 'project_link',
                'type'     => 'leap_link',
                'options'  => '',
                'position' => 'right',
            ),
            array(
                'title'    => 'Date',
                'id'       => 'leap_project_date',
                'type'     => 'text',
                'options'  => '',
                'position' => 'right'
            ),
            array(
                'title'    => 'Client',
                'id'       => 'leap_project_client',
                'type'     => 'text',
                'options'  => '',
                'position' => 'right'
            ),
            array(
                'title'    => 'Copyright',
                'id'       => 'leap_project_copyright',
                'type'     => 'text',
                'options'  => '',
                'position' => 'right'
            ),
            array(
                'title'    => 'Video',
                'id'       => 'leap_project_video_code22',
                'type'     => 'text',
                'options'  => '',
                'position' => 'bottom'
            )
        );

        $saved_options[ 'portfolio_fields' ] = $portfolio_fields;

        update_option( ot_options_id(), $saved_options );

        // Update portfolio posts to use the new portfolio link field
        $args = array(
            'post_type'   => 'leap-portfolio',
            'post_status' => 'any'
        );

        $the_query = new WP_Query( $args );

        if ( $the_query->have_posts() ) {
            while ( $the_query->have_posts() ) {
                $the_query->the_post();

                $project_link_data = array(
                    'text' => get_post_meta( $the_query->post->ID, 'leap_project_url_text', true ),
                    'url'  => get_post_meta( $the_query->post->ID, 'leap_project_url', true )
                );

                update_post_meta( $the_query->post->ID, 'project_link', $project_link_data );
            }
        }
        /* Restore original Post Data */
        wp_reset_postdata();
    }
    
    /*
     * Update tax-meta-class to use WP 4.4 native term meta
     */
    if ( version_compare( $old_version, '2.6.0', '<' ) ) {
        require get_template_directory() . '/functions/tax-meta/migration/tax_to_term_meta.php';
        new tax_to_term_meta();
    }
    
    /*
     * header position option
     */
    if ( version_compare( $old_version, '2.6.3', '<' ) ) {
        $saved_options    = get_option( ot_options_id() );

        $saved_options[ 'header_position' ] = 'static';
        $saved_options[ 'slider_position' ] = 'below';
        
        update_option( ot_options_id(), $saved_options );

        // Update portfolio posts to use the new portfolio link field
        $args = array (
            'post_type'              => array( 'page' ),
            'post_status'            => array( 'any' ),
            'meta_query'             => array(
                array(
                    'key'       => 'leap_slider_type',
                    'value'     => 'none',
                    'compare'   => '!=',
                    'type'      => 'CHAR',
                ),
            ),
        );

        $the_query = new WP_Query( $args );

        if ( $the_query->have_posts() ) {
            while ( $the_query->have_posts() ) {
                $the_query->the_post();

                $leap_slider_type = get_post_meta( $the_query->post->ID, 'leap_slider_type', true );
                if( 'none' != $leap_slider_type ) {
                    update_post_meta( $the_query->post->ID, 'leap_header_position', 'absolute' );
                }
            }
        }
        /* Restore original Post Data */
        wp_reset_postdata();
    }
}

add_action( 'leap_theme_upgrade', 'leap_theme_upgrade', 10, 2 );
