<?php

if ( !defined( 'ABSPATH' ) ) {
    die( 'No direct access allowed' );
}

/**
 * Initialize the theme options.
 */
add_action( 'init', 'leap_theme_options' );

/**
 * Build the theme settings
 */
function leap_theme_options() {

    /* OptionTree is not loaded yet, or this is not an admin request */
    if ( !function_exists( 'ot_settings_id' ) || !is_admin() )
        return false;

    /**
     * Get a copy of the saved settings array. 
     */
    $saved_settings = get_option( ot_settings_id(), array() );

    /**
     * Custom settings array that will eventually be 
     * passes to the OptionTree Settings API Class.
     */
    $custom_settings = array(
        'contextual_help' => array(
            'sidebar' => ''
        ),
        'sections'        => array(
            array(
                'id'    => 'general',
                'title' => __( 'General', 'wiz' )
            ),
            array(
                'id'    => 'fonts_manager',
                'title' => __( 'Fonts Manager', 'wiz' )
            ),
            array(
                'id'    => 'smart_skin',
                'title' => __( 'Smart Skin', 'wiz' )
            ),
            array(
                'id'    => 'header',
                'title' => __( 'Header', 'wiz' )
            ),
            array(
                'id'    => 'page_title',
                'title' => __( 'Page Title Bar', 'wiz' )
            ),
            array(
                'id'    => 'footer',
                'title' => __( 'Footer', 'wiz' )
            ),
            array(
                'id'    => 'content',
                'title' => __( 'Content', 'wiz' )
            ),
            array(
                'id'    => 'responsive',
                'title' => __( 'Responsive', 'wiz' )
            ),
            array(
                'id'    => 'sidebars',
                'title' => __( 'Sidebars', 'wiz' )
            ),
            array(
                'id'    => 'widget_positions',
                'title' => __( 'Widget Positions', 'wiz' )
            ),
            array(
                'id'    => 'blog',
                'title' => __( 'Blog', 'wiz' )
            ),
            array(
                'id'    => 'single_post',
                'title' => __( 'Single Post', 'wiz' )
            ),
            array(
                'id'    => 'archive_category',
                'title' => __( 'Archive/Category', 'wiz' )
            ),
            array(
                'id'    => 'comments',
                'title' => __( 'Comments', 'wiz' )
            ),
            array(
                'id'    => 'search_page',
                'title' => __( 'Search Page', 'wiz' )
            ),
            array(
                'id'    => 'portfolio',
                'title' => __( 'Portfolio', 'wiz' )
            ),
            array(
                'id'    => 'social_media',
                'title' => __( 'Social  Media', 'wiz' )
            ),
            array(
                'id'    => 'seo',
                'title' => __( 'SEO', 'wiz' )
            ),
            array(
                'id'    => 'webmaster_tools',
                'title' => __( 'Webmaster Tools', 'wiz' )
            ),
            array(
                'id'    => 'favicons',
                'title' => __( 'Favicons', 'wiz' )
            ),
            array(
                'id'    => 'banners',
                'title' => __( 'Banners', 'wiz' )
            ),
            array(
                'id'    => 'contacts',
                'title' => __( 'Contacts', 'wiz' )
            ),
            array(
                'id'    => 'custom_css',
                'title' => __( 'Custom CSS', 'wiz' )
            ),
            array(
                'id'    => 'advanced',
                'title' => __( 'Advanced', 'wiz' )
            ),
            array(
                'id'    => 'theme_updates',
                'title' => __( 'Theme Updates', 'wiz' )
            ),
            array(
                'id'    => 'export_import',
                'title' => __( 'Export/Import', 'wiz' )
            ),
            array(
                'id'    => 'system_info',
                'title' => __( 'System Info', 'wiz' )
            )
        ),
        'settings'        => array(
            array(
                'id'           => 'accordion_layout_settings_start',
                'label'        => __( 'Layout Settings', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_start',
                'section'      => 'general',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'container_width',
                'label'        => __( 'Container Width', 'wiz' ),
                'desc'         => '',
                'std'          => array( 1140, 'px' ),
                'type'         => 'measurement',
                'section'      => 'general',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'layout',
                'label'        => __( 'Layout', 'wiz' ),
                'desc'         => __( 'Select boxed or wide layout.', 'wiz' ),
                'std'          => 'wide',
                'type'         => 'radio',
                'section'      => 'general',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'wide',
                        'label' => __( 'Wide', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'boxed',
                        'label' => __( 'Boxed', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'framed',
                        'label' => __( 'Framed', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'background_inner',
                'label'        => __( 'Layout Background', 'wiz' ),
                'desc'         => __( 'Works as website background in wide layout and as inner area background for boxed layout.', 'wiz' ),
                'std'          => '',
                'type'         => 'background',
                'section'      => 'general',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'framed_size',
                'label'        => __( 'Framed Style', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'spacing',
                'section'      => 'general',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'layout:is(framed)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'frame_color',
                'label'        => __( 'Frame Color', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'colorpicker',
                'section'      => 'general',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'layout:is(framed)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'background_type_outer',
                'label'        => __( 'Background Type For Outer Area', 'wiz' ),
                'desc'         => __( 'For boxed layout only.', 'wiz' ),
                'std'          => 'custom_background',
                'type'         => 'radio',
                'section'      => 'general',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'layout:is(boxed)',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'custom_background',
                        'label' => __( 'Custom Background', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'pattern',
                        'label' => __( 'Pattern', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'choose_pattern_outer',
                'label'        => __( 'Choose Pattern For Outer Area', 'wiz' ),
                'desc'         => '',
                'std'          => 'pattern1',
                'type'         => 'radio-image',
                'section'      => 'general',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'layout:is(boxed),background_type_outer:is(pattern)',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'pattern1',
                        'label' => __( 'Pattern1', 'wiz' ),
                        'src'   => 'pattern/preview/pattern1.jpg'
                    ),
                    array(
                        'value' => 'pattern2',
                        'label' => __( 'Pattern2', 'wiz' ),
                        'src'   => 'pattern/preview/pattern2.jpg'
                    ),
                    array(
                        'value' => 'pattern3',
                        'label' => __( 'Pattern3', 'wiz' ),
                        'src'   => 'pattern/preview/pattern3.jpg'
                    ),
                    array(
                        'value' => 'pattern4',
                        'label' => __( 'Pattern4', 'wiz' ),
                        'src'   => 'pattern/preview/pattern4.jpg'
                    ),
                    array(
                        'value' => 'pattern5',
                        'label' => __( 'Pattern5', 'wiz' ),
                        'src'   => 'pattern/preview/pattern5.jpg'
                    ),
                    array(
                        'value' => 'pattern6',
                        'label' => __( 'Pattern6', 'wiz' ),
                        'src'   => 'pattern/preview/pattern6.jpg'
                    ),
                    array(
                        'value' => 'pattern7',
                        'label' => __( 'Pattern7', 'wiz' ),
                        'src'   => 'pattern/preview/pattern7.jpg'
                    ),
                    array(
                        'value' => 'pattern8',
                        'label' => __( 'Pattern8', 'wiz' ),
                        'src'   => 'pattern/preview/pattern8.jpg'
                    ),
                    array(
                        'value' => 'pattern9',
                        'label' => __( 'Pattern9', 'wiz' ),
                        'src'   => 'pattern/preview/pattern9.jpg'
                    ),
                    array(
                        'value' => 'pattern10',
                        'label' => __( 'Pattern10', 'wiz' ),
                        'src'   => 'pattern/preview/pattern10.jpg'
                    ),
                    array(
                        'value' => 'pattern11',
                        'label' => __( 'Pattern11', 'wiz' ),
                        'src'   => 'pattern/preview/pattern11.jpg'
                    ),
                    array(
                        'value' => 'pattern12',
                        'label' => __( 'Pattern12', 'wiz' ),
                        'src'   => 'pattern/preview/pattern12.jpg'
                    ),
                    array(
                        'value' => 'pattern13',
                        'label' => __( 'Pattern13', 'wiz' ),
                        'src'   => 'pattern/preview/pattern13.jpg'
                    ),
                    array(
                        'value' => 'pattern14',
                        'label' => __( 'Pattern14', 'wiz' ),
                        'src'   => 'pattern/preview/pattern14.jpg'
                    ),
                    array(
                        'value' => 'pattern15',
                        'label' => __( 'Pattern15', 'wiz' ),
                        'src'   => 'pattern/preview/pattern15.jpg'
                    ),
                    array(
                        'value' => 'pattern16',
                        'label' => __( 'Pattern16', 'wiz' ),
                        'src'   => 'pattern/preview/pattern16.jpg'
                    ),
                    array(
                        'value' => 'pattern17',
                        'label' => __( 'Pattern17', 'wiz' ),
                        'src'   => 'pattern/preview/pattern17.jpg'
                    ),
                    array(
                        'value' => 'pattern18',
                        'label' => __( 'Pattern18', 'wiz' ),
                        'src'   => 'pattern/preview/pattern18.jpg'
                    )
                )
            ),
            array(
                'id'           => 'custom_background_outer',
                'label'        => __( 'Custom Background For Outer Area', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'background',
                'section'      => 'general',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'layout:is(boxed),background_type_outer:is(custom_background)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'custom_retina_background_outer',
                'label'        => __( 'Custom Retina Background For Outer Area', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'upload',
                'section'      => 'general',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'layout:is(boxed),background_type_outer:is(custom_background)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'retina_background_dimensions_outer',
                'label'        => __( 'Normal background Dimensions for Retina background For Outer Area', 'wiz' ),
                'desc'         => __( 'If retina background is uploaded, please enter the normal background (1x) version width and height. Do not enter the retina background width or height.', 'wiz' ),
                'std'          => '',
                'type'         => 'dimension',
                'section'      => 'general',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'layout:is(boxed),background_type_outer:is(custom_background)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'smooth_scroll',
                'label'        => __( 'Smooth Scroll', 'wiz' ),
                'desc'         => '',
                'std'          => 'on',
                'type'         => 'on-off',
                'section'      => 'general',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'accordion_layout_settings_end',
                'label'        => __( 'Layout Settings End', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_end',
                'section'      => 'general',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'clear-both',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'accordion_sidebar_widget_settings_start',
                'label'        => __( 'Default Sidebar & Widget Settings', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_start',
                'section'      => 'general',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'sidebar_position',
                'label'        => __( 'Sidebar Position', 'wiz' ),
                'desc'         => __( 'Select the default position of the sidebar. This will take effect for new pages/posts.', 'wiz' ),
                'std'          => 'right',
                'type'         => 'radio-image',
                'section'      => 'general',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'right',
                        'label' => __( 'Right', 'wiz' ),
                        'src'   => 'sidebar/right-sidebar.png'
                    ),
                    array(
                        'value' => 'left',
                        'label' => __( 'Left', 'wiz' ),
                        'src'   => 'sidebar/left-sidebar.png'
                    ),
                    array(
                        'value' => 'full',
                        'label' => __( 'Full Width', 'wiz' ),
                        'src'   => 'sidebar/no-sidebar.png'
                    )
                )
            ),
            array(
                'id'           => 'widget_style',
                'label'        => __( 'Default Widget Style', 'wiz' ),
                'desc'         => '',
                'std'          => 'style1',
                'type'         => 'select',
                'section'      => 'general',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'style1',
                        'label' => __( 'Style 1', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'style2',
                        'label' => __( 'Style 2', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'style3',
                        'label' => __( 'Style 3', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'style4',
                        'label' => __( 'Style 4', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'style5',
                        'label' => __( 'Style 5', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'style6',
                        'label' => __( 'Style 6', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'style7',
                        'label' => __( 'Style 7', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'style8',
                        'label' => __( 'Style 8', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'style9',
                        'label' => __( 'Style 9', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'style10',
                        'label' => __( 'Style 10', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'style11',
                        'label' => __( 'Style 11', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'leap_default_sidebar_style',
                'label'        => __( 'Default Widget Positions Style', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'custom-post-type-select',
                'section'      => 'general',
                'rows'         => '',
                'post_type'    => 'leap-sidebar-style',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'accordion_sidebar_widget_settings_end',
                'label'        => __( 'Default Sidebar & Widget Settings End', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_end',
                'section'      => 'general',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'clear-both',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'accordion_header_footer_codes_start',
                'label'        => __( 'Header & Footer Custom Codes', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_start',
                'section'      => 'general',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'head_code',
                'label'        => __( 'Head Code', 'wiz' ),
                'desc'         => __( 'Any code you place here will appear in the head section of every page of your blog. This is useful when you need to add javascript or css to all pages.', 'wiz' ),
                'std'          => '',
                'type'         => 'textarea-simple',
                'section'      => 'general',
                'rows'         => '7',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'footer_code',
                'label'        => __( 'Footer Code', 'wiz' ),
                'desc'         => __( 'The following code will add to the footer before the closing  tag. Useful if you need to Javascript or tracking code.', 'wiz' ),
                'std'          => '',
                'type'         => 'textarea-simple',
                'section'      => 'general',
                'rows'         => '7',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'accordion_header_footer_codes_end',
                'label'        => __( 'Header & Footer Custom Codes End', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_end',
                'section'      => 'general',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'clear-both',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'desc_google_fonts',
                'label'        => __( 'Add Google Fonts', 'wiz' ),
                'desc'         => __( 'Add Google Fonts', 'wiz' ),
                'std'          => '',
                'type'         => 'textblock',
                'section'      => 'fonts_manager',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'title-block',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'google_fonts_key',
                'label'        => __( 'Google Fonts API Key', 'wiz' ),
                'desc'         => __( 'It\'s recommended to enter your own Google Font API Key to make sure Google fonts will work properly and to get google fonts library updates. To learn more about Fonts manager click <a href="http://www.leap13.com/2015/08/26/fonts-manager/" target="_blank">here</a>', 'wiz' ),
                'std'          => '',
                'type'         => 'text',
                'section'      => 'fonts_manager',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'google_fonts',
                'label'        => __( 'Google Fonts Collection', 'wiz' ),
                'desc'         => __( 'Add Google fonts that you will use on the website here. Adding too much fonts will negatively impact your page load speed. After adding the Google fonts and click on "Save Changes" button, Newly added fonts will be automatically populated on all LeapPanel typography options.', 'wiz' ),
                'std'          => array(
                    array(
                        'family'   => 'opensans',
                        'variants' => array( 'regular' ),
                        'subsets'  => array(),
                    ),
                    array(
                        'family'   => 'roboto',
                        'variants' => array( 'regular' ),
                        'subsets'  => array(),
                    ),
                ),
                'type'         => 'google-fonts',
                'section'      => 'fonts_manager',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'remove-border',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'desc_custom_fonts',
                'label'        => __( 'Add Custom Fonts', 'wiz' ),
                'desc'         => __( 'Add Custom Fonts', 'wiz' ),
                'std'          => '',
                'type'         => 'textblock',
                'section'      => 'fonts_manager',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'title-block',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'custom_fonts',
                'label'        => __( 'Upload Custom Fonts', 'wiz' ),
                'desc'         => __( 'You can add unlimited number of custom fonts to youe website. After adding the custom fonts and click on "Save Changes" button, All typography options will be automatically populated with the new fonts.', 'wiz' ),
                'std'          => '',
                'type'         => 'list-item',
                'section'      => 'fonts_manager',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'remove-border not-sortable',
                'condition'    => '',
                'operator'     => 'and',
                'settings'     => array(
                    array(
                        'id'           => 'eot_file',
                        'label'        => __( 'Upload EOT File', 'wiz' ),
                        'desc'         => '',
                        'std'          => '',
                        'type'         => 'upload',
                        'rows'         => '',
                        'post_type'    => '',
                        'taxonomy'     => '',
                        'min_max_step' => '',
                        'class'        => '',
                        'condition'    => '',
                        'operator'     => 'and'
                    ),
                    array(
                        'id'           => 'woff2_file',
                        'label'        => __( 'Upload WOFF2 File', 'wiz' ),
                        'desc'         => '',
                        'std'          => '',
                        'type'         => 'upload',
                        'rows'         => '',
                        'post_type'    => '',
                        'taxonomy'     => '',
                        'min_max_step' => '',
                        'class'        => '',
                        'condition'    => '',
                        'operator'     => 'and'
                    ),
                    array(
                        'id'           => 'woff_file',
                        'label'        => __( 'Upload WOFF File', 'wiz' ),
                        'desc'         => '',
                        'std'          => '',
                        'type'         => 'upload',
                        'rows'         => '',
                        'post_type'    => '',
                        'taxonomy'     => '',
                        'min_max_step' => '',
                        'class'        => '',
                        'condition'    => '',
                        'operator'     => 'and'
                    ),
                    array(
                        'id'           => 'ttf_file',
                        'label'        => __( 'Upload TTF File', 'wiz' ),
                        'desc'         => '',
                        'std'          => '',
                        'type'         => 'upload',
                        'rows'         => '',
                        'post_type'    => '',
                        'taxonomy'     => '',
                        'min_max_step' => '',
                        'class'        => '',
                        'condition'    => '',
                        'operator'     => 'and'
                    ),
                    array(
                        'id'           => 'svg_file',
                        'label'        => __( 'Upload SVG File', 'wiz' ),
                        'desc'         => '',
                        'std'          => '',
                        'type'         => 'upload',
                        'rows'         => '',
                        'post_type'    => '',
                        'taxonomy'     => '',
                        'min_max_step' => '',
                        'class'        => '',
                        'condition'    => '',
                        'operator'     => 'and'
                    )
                )
            ),
            array(
                'id'           => 'smart_skin_desc',
                'label'        => __( 'smart_skin_desc', 'wiz' ),
                'desc'         => __( 'Smart Skin controls and changes your entire website color scheme, Select whether you want light to dark theme then select from readymade Smart Skins available and/or customize your own Smart Skin. <a href="https://youtu.be/hsVqOQoF4DM" target="_blank">Click here</a> to Watch Smart Skin video tutorial.', 'wiz' ),
                'std'          => '',
                'type'         => 'textblock',
                'section'      => 'smart_skin',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'desc',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'theme_skin',
                'label'        => __( 'Light Or Dark Theme?', 'wiz' ),
                'desc'         => __( 'Select whether you want your theme light or dark. It important to choose even if you will create your own Smart Skin as your choice affects how Smart Skin behaves.', 'wiz' ),
                'std'          => 'light',
                'type'         => 'select',
                'section'      => 'smart_skin',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'light',
                        'label' => __( 'Light', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'dark',
                        'label' => __( 'Dark', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'light_ready_made_smart_skins',
                'label'        => __( 'Choose from Ready-made Smart Skins', 'wiz' ),
                'desc'         => __( 'You can choose from the ready made smart skins below and save to apply it to the entire theme. Also after choosing the skin you prefer you still can customize it  below in "Customize Smart Skin" section.', 'wiz' ),
                'std'          => 'ss1',
                'type'         => 'radio-image',
                'section'      => 'smart_skin',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'remove-border',
                'condition'    => 'theme_skin:is(light)',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'ss1',
                        'label' => __( 'SS1', 'wiz' ),
                        'src'   => 'skins/ss1.png'
                    ),
                    array(
                        'value' => 'ss2',
                        'label' => __( 'SS2', 'wiz' ),
                        'src'   => 'skins/ss2.png'
                    ),
                    array(
                        'value' => 'ss3',
                        'label' => __( 'SS3', 'wiz' ),
                        'src'   => 'skins/ss3.png'
                    ),
                    array(
                        'value' => 'ss4',
                        'label' => __( 'SS4', 'wiz' ),
                        'src'   => 'skins/ss4.png'
                    ),
                    array(
                        'value' => 'ss5',
                        'label' => __( 'SS5', 'wiz' ),
                        'src'   => 'skins/ss5.png'
                    ),
                    array(
                        'value' => 'ss6',
                        'label' => __( 'SS6', 'wiz' ),
                        'src'   => 'skins/ss6.png'
                    ),
                    array(
                        'value' => 'ss7',
                        'label' => __( 'SS7', 'wiz' ),
                        'src'   => 'skins/ss7.png'
                    ),
                    array(
                        'value' => 'ss8',
                        'label' => __( 'SS8', 'wiz' ),
                        'src'   => 'skins/ss8.png'
                    ),
                    array(
                        'value' => 'ss9',
                        'label' => __( 'SS9', 'wiz' ),
                        'src'   => 'skins/ss9.png'
                    )
                )
            ),
            array(
                'id'           => 'dark_ready_made_smart_skins',
                'label'        => __( 'Choose from Ready-made Smart Skins', 'wiz' ),
                'desc'         => __( 'You can choose from the ready made smart skins below and save to apply it to the entire theme. Also after choosing the skin you prefer you still can customize it  below in "Customize Smart Skin" section.', 'wiz' ),
                'std'          => '',
                'type'         => 'radio-image',
                'section'      => 'smart_skin',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'remove-border',
                'condition'    => 'theme_skin:is(dark)',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'ssd1',
                        'label' => __( 'SSD1', 'wiz' ),
                        'src'   => 'skins/ssd1.png'
                    ),
                    array(
                        'value' => 'ssd2',
                        'label' => __( 'SSD2', 'wiz' ),
                        'src'   => 'skins/ssd2.png'
                    ),
                    array(
                        'value' => 'ssd3',
                        'label' => __( 'SSD3', 'wiz' ),
                        'src'   => 'skins/ssd3.png'
                    ),
                    array(
                        'value' => 'ssd4',
                        'label' => __( 'SSD4', 'wiz' ),
                        'src'   => 'skins/ssd4.png'
                    )
                )
            ),
            array(
                'id'           => 'customize_smart_skin',
                'label'        => __( 'Customize Smart Skin', 'wiz' ),
                'desc'         => __( 'Customize Smart Skin', 'wiz' ),
                'std'          => '',
                'type'         => 'textblock',
                'section'      => 'smart_skin',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'title-block',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'customize_smart_skin_desc',
                'label'        => __( 'customize_smart_skin_desc', 'wiz' ),
                'desc'         => __( 'It\'s recommended to read help notes below which describes what theme elements will be affected when changing each value from below before you start customizing the Smart Skin. Also you can use Smart Skin Generator to instantly generate a complete Smart Skin from 2 colors.<br><br><a href="http://www.leap13.com/website-clolor-scheme-generator-smart-skin-generator/" target="_blank"><b>Launch Smart Skin Generator</b></a>', 'wiz' ),
                'std'          => '',
                'type'         => 'textblock',
                'section'      => 'smart_skin',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'desc',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'primary_color',
                'label'        => __( 'Primary Color', 'wiz' ),
                'desc'         => '',
                'std'          => '#f67207',
                'type'         => 'colorpicker',
                'section'      => 'smart_skin',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'smart_skin_typography',
                'label'        => __( 'Content &amp; Widget Typography Colors', 'wiz' ),
                'desc'         => '',
                'std'          => array(
                    't1' => '#1c1c1c',
                    't2' => '#4c4c4c',
                    't3' => '#6c6c6c'
                ),
                'type'         => 'link-color',
                'section'      => 'smart_skin',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'smart_skin_backgrounds',
                'label'        => __( 'Content &amp; Widget Backgrounds, Borders &amp; Separator Colors', 'wiz' ),
                'desc'         => '',
                'std'          => array(
                    'b1' => '#e3e3e3',
                    'b2' => '#f7f7f7',
                    'b3' => '#fcfcfc'
                ),
                'type'         => 'link-color',
                'section'      => 'smart_skin',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'smart_skin_footer',
                'label'        => __( 'Footer Typography &amp; Backgrounds Colors', 'wiz' ),
                'desc'         => '',
                'std'          => array(
                    'ft' => '#ffffff',
                    'fb' => '#2c2c2c'
                ),
                'type'         => 'link-color',
                'section'      => 'smart_skin',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'smart_skin_colors_desc',
                'label'        => __( 'smart_skin_colors_desc', 'wiz' ),
                'desc'         => __( '<table>
	<tr>
		<td><b>Primary Color</b></td>
		<td>
			Used for buttons background (a darker shade from it used for mouseover) , a hover color for links and image\'s overlay color, etc.
		</td>
	</tr>
	<tr><td></td><td></td></tr>
	<tr><td></td><td></td></tr>
	<tr><td colspan="2"><h4 style="margin:0 0 3px 0;">Content & Widget Typography Colors</h4></td></tr>
	<tr>
		<td style="vertical-align: top;"><b>T1</b></td>
		<td>
			Used for all titles from H1 to H6, widget titles, main menu links and all other body links.
		</td>
	</tr>
	<tr><td></td><td></td></tr>
	<tr>
		<td style="vertical-align: top;"><b>T2</b></td>
		<td>
			Used for body text, forms input text and a lighter tint of it used for meta data,icon sharing box and main menu separators.
		</td>
	</tr>
	<tr><td></td><td></td></tr>
	<tr>
		<td style="vertical-align: top;"><b>T3</b></td>
		<td>
			Used for page titles , breadcrumbs and subtitle.
		</td>
	</tr>
	<tr><td></td><td></td></tr>
	<tr><td></td><td></td></tr>
	<tr><td colspan="2"><h4 style="margin:0 0 3px 0;">Content & Widget Backgrounds, Borders & Separator Colors</h4></td></tr>
	<tr>
		<td style="vertical-align: top;"><b>B1</b></td>
		<td>
			Used for all input fields borders, all borders, all separators, all dividers, image borders. (a tint from it used for the submenu background, many elements backgrounds like quotes, testimonials, accordion, taglines).
		</td>
	</tr>
	<tr><td></td><td></td></tr>
	<tr>
		<td style="vertical-align: top;"><b>B2</b></td>
		<td>
			Used for page title background.
		</td>
	</tr>
	<tr><td></td><td></td></tr>
	<tr>
		<td style="vertical-align: top;"><b>B3</b></td>
		<td>
			Used for body background color, (a tint from it used for the input background).
		</td>
	</tr>
	<tr><td></td><td></td></tr>
	<tr><td></td><td></td></tr>
	<tr><td colspan="2"><h4 style="margin:0 0 3px 0;">Footer Typography & Backgrounds Colors</h4></td></tr>
	<tr>
		<td style="vertical-align: top;"><b>FT</b></td>
		<td>
			Used for footer titles and links, a darker shades of it used for footer body text, meta data and separators.
		</td>
	</tr>
	<tr><td></td><td></td></tr>
	<tr>
		<td style="vertical-align: top;"><b>FB</b></td>
		<td>
			Used for footer background, a darker shades of it used for footer buttons, input background and copyright bar background.
		</td>
	</tr>
</table>', 'wiz' ),
                'std'          => '',
                'type'         => 'textblock',
                'section'      => 'smart_skin',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'desc',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'accordion_header_layout_start',
                'label'        => __( 'Header Layout', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_start',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'header_layout',
                'label'        => __( 'Select a Header Layout', 'wiz' ),
                'desc'         => '',
                'std'          => 'header1',
                'type'         => 'radio-image',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'header1',
                        'label' => __( 'Header1', 'wiz' ),
                        'src'   => 'headers/header1.png'
                    ),
                    array(
                        'value' => 'header2',
                        'label' => __( 'Header 2', 'wiz' ),
                        'src'   => 'headers/header2.png'
                    ),
                    array(
                        'value' => 'header3',
                        'label' => __( 'Header 3', 'wiz' ),
                        'src'   => 'headers/header3.png'
                    ),
                    array(
                        'value' => 'header4',
                        'label' => __( 'Header 4', 'wiz' ),
                        'src'   => 'headers/header4.png'
                    ),
                    array(
                        'value' => 'header5',
                        'label' => __( 'Header 5', 'wiz' ),
                        'src'   => 'headers/header5.png'
                    ),
                    array(
                        'value' => 'header6',
                        'label' => __( 'Header 6', 'wiz' ),
                        'src'   => 'headers/header6.png'
                    ),
                    array(
                        'value' => 'header7',
                        'label' => __( 'Header 7', 'wiz' ),
                        'src'   => 'headers/header7.png'
                    ),
                    array(
                        'value' => 'header8',
                        'label' => __( 'Header 8', 'wiz' ),
                        'src'   => 'headers/header8.png'
                    ),
                    array(
                        'value' => 'header9',
                        'label' => __( 'Header 9', 'wiz' ),
                        'src'   => 'headers/header9.png'
                    ),
                    array(
                        'value' => 'header10',
                        'label' => __( 'Header 10', 'wiz' ),
                        'src'   => 'headers/header10.png'
                    ),
                    array(
                        'value' => 'header11',
                        'label' => __( 'Header 11', 'wiz' ),
                        'src'   => 'headers/header11.png'
                    ),
                    array(
                        'value' => 'header12',
                        'label' => __( 'Header 12', 'wiz' ),
                        'src'   => 'headers/header12.png'
                    ),
                    array(
                        'value' => 'header13',
                        'label' => __( 'Header 13', 'wiz' ),
                        'src'   => 'headers/header13.png'
                    ),
                    array(
                        'value' => 'header14',
                        'label' => __( 'Header 14', 'wiz' ),
                        'src'   => 'headers/header14.png'
                    ),
                    array(
                        'value' => 'header15',
                        'label' => __( 'Header 15', 'wiz' ),
                        'src'   => 'headers/header15.png'
                    ),
                    array(
                        'value' => 'header16',
                        'label' => __( 'Header 16', 'wiz' ),
                        'src'   => 'headers/header16.png'
                    ),
                    array(
                        'value' => 'header17',
                        'label' => __( 'Header 17', 'wiz' ),
                        'src'   => 'headers/header17.png'
                    ),
                    array(
                        'value' => 'none',
                        'label' => __( 'None', 'wiz' ),
                        'src'   => 'headers/none.png'
                    )
                )
            ),
            array(
                'id'           => 'header_position',
                'label'        => __( 'Header Position', 'wiz' ),
                'desc'         => '',
                'std'          => 'absolute',
                'type'         => 'select',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'header_layout:is(header7),header_layout:is(header8),header_layout:is(header9),header_layout:is(header17)',
                'operator'     => 'or',
                'choices'      => array(
                    array(
                        'value' => 'absolute',
                        'label' => __( 'Absolute', 'wiz' )
                    ),
                    array(
                        'value' => 'static',
                        'label' => __( 'Static', 'wiz' )
                    )
                )
            ),
            array(
                'id'           => 'slider_position',
                'label'        => __( 'Slider Position', 'wiz' ),
                'desc'         => __('Select if the slider shows below or above the header. This will not be effective on vertical headers.', 'wiz'),
                'std'          => 'below',
                'type'         => 'select',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'header_layout:is(header1),header_layout:is(header2),header_layout:is(header3),header_layout:is(header4),header_layout:is(header5),header_layout:is(header6),header_layout:is(header7),header_layout:is(header8),header_layout:is(header9),header_layout:is(header17)',
                'operator'     => 'or',
                'choices'      => array(
                    array(
                        'value' => 'above',
                        'label' => __( 'Above Header', 'wiz' )
                    ),
                    array(
                        'value' => 'below',
                        'label' => __( 'Below Header', 'wiz' )
                    )
                )
            ),
            array(
                'id'           => 'vh_width',
                'label'        => __( 'Vertical Header Width', 'wiz' ),
                'desc'         => '',
                'std'          => array( 250, 'px' ),
                'type'         => 'measurement',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'header_layout:is(header10),header_layout:is(header11),header_layout:is(header12),header_layout:is(header13)',
                'operator'     => 'or'
            ),
            array(
                'id'           => 'vh_shadow',
                'label'        => __( 'Vertical Header Shadow', 'wiz' ),
                'desc'         => '',
                'std'          => 'off',
                'type'         => 'on-off',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'header_layout:is(header10),header_layout:is(header11),header_layout:is(header12),header_layout:is(header13)',
                'operator'     => 'or'
            ),
            array(
                'id'           => 'vh_border',
                'label'        => __( 'Vertical Header Border', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'border',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'header_layout:is(header10),header_layout:is(header11),header_layout:is(header12),header_layout:is(header13)',
                'operator'     => 'or'
            ),
            array(
                'id'           => 'icon_spacing',
                'label'        => __( 'Icon Spacing', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'spacing',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'header_layout:is(header14)',
                'operator'     => 'or'
            ),
            array(
                'id'           => 'vh_icon_colors',
                'label'        => __( 'Header Icon Color Options', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'header_layout:is(header12),header_layout:is(header13),header_layout:is(header14),header_layout:is(header15),header_layout:is(header17)',
                'operator'     => 'or'
            ),
            array(
                'id'           => 'header_spacing',
                'label'        => __( 'Header Spacing Options Options', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'spacing',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'header_layout:is(header15),header_layout:is(header16),header_layout:is(header17)',
                'operator'     => 'or'
            ),
            array(
                'id'           => 'sticky_text_color',
                'label'        => __( 'Text Color In Sticky Header', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'colorpicker',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'header_layout:is(header15),header_layout:is(header17)',
                'operator'     => 'or'
            ),
            array(
                'id'           => 'vh_header',
                'label'        => __( 'Display Vertical Menu Items', 'wiz' ),
                'desc'         => '',
                'std'          => 'on',
                'type'         => 'on-off',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'clear-both',
                'condition'    => 'header_layout:is(header16)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'accordion_header_layout_end',
                'label'        => __( 'General Settings End', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_end',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'accordion_logo_settings',
                'label'        => __( 'Logo Settings', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_start',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'logo',
                'label'        => __( 'Logo Image', 'wiz' ),
                'desc'         => __( 'If you would like to use your own custom logo image click the Upload Image button.', 'wiz' ),
                'std'          => '',
                'type'         => 'upload',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'logo_retina',
                'label'        => __( 'Logo Image (Retina Version @2x)', 'wiz' ),
                'desc'         => __( 'Please choose an image file for the retina version of the logo. It should be 2x the size of main logo.', 'wiz' ),
                'std'          => '',
                'type'         => 'upload',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'logo_retina_dimensions',
                'label'        => __( 'Normal Logo Dimensions for Retina Logo', 'wiz' ),
                'desc'         => __( 'If retina logo is uploaded, please enter the normal logo (1x) version width and height. Do not enter the retina logo width or height.', 'wiz' ),
                'std'          => '',
                'type'         => 'dimension',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'logo_spacing',
                'label'        => __( 'Logo Spacing', 'wiz' ),
                'desc'         => '',
                'std'          => __('Defult values are 35px 0px 35px 0px.', 'wiz'),
                'type'         => 'spacing',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'accordion_logo_settings_end',
                'label'        => __( 'Logo Settings End', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_end',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'clear-both',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'accordion_header',
                'label'        => __( 'Header Settings', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_start',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'header_bg',
                'label'        => __( 'Header Background', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'background',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'ot-colorpicker-opacity clear-both',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'main_menu_logo_style',
                'label'        => __( 'Main Menu &amp; Logo Container Style', 'wiz' ),
                'desc'         => __( 'For Headers 8 &amp; 9 only', 'wiz' ),
                'std'          => 'boxed',
                'type'         => 'radio',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'ot-colorpicker-opacity',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'boxed',
                        'label' => __( 'Boxed', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'wide',
                        'label' => __( 'Wide', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'main_menu_boxed_bg',
                'label'        => __( 'Main Menu &amp; Logo Container backgoround', 'wiz' ),
                'desc'         => __( 'For Headers 8 &amp; 9 only', 'wiz' ),
                'std'          => '',
                'type'         => 'background',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'ot-colorpicker-opacity',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'main_menu_logo_spacing',
                'label'        => __( 'Main Menu &amp; Logo Container Spacing', 'wiz' ),
                'desc'         => __( 'For Headers 8 &amp; 9 only', 'wiz' ),
                'std'          => array(
                    'top'    => '0',
                    'bottom' => '100',
                    'unit'   => 'px'
                ),
                'type'         => 'spacing',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'header_search',
                'label'        => __( 'Display Search on Header', 'wiz' ),
                'desc'         => '',
                'std'          => 'on',
                'type'         => 'on-off',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'clear-both',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'display_cart_icon_on_main_menu',
                'label'        => __( 'Display Cart Icon on Main Menu', 'wiz' ),
                'desc'         => __( 'Show Woocommerce Cart Icon in main menu.', 'wiz' ),
                'std'          => 'off',
                'type'         => 'on-off',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'slider__shadow',
                'label'        => __( 'Display Slider Shadow', 'wiz' ),
                'desc'         => '',
                'std'          => 'off',
                'type'         => 'on-off',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'clear-both',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'header_search_bg_color',
                'label'        => __( 'Header Search Field Background Color', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'colorpicker',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'accordion_header_end',
                'label'        => __( 'Header End', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_end',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'accordion_menu_start',
                'label'        => __( 'Main Menu Settings', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_start',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'main_menu_bg',
                'label'        => __( 'Main Menu backgoround', 'wiz' ),
                'desc'         => __( 'For Headers 4, 5, 6 &amp; 14.', 'wiz' ),
                'std'          => '',
                'type'         => 'background',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'ot-colorpicker-opacity',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'main_menu_typography',
                'label'        => __( 'Main Menu Typography', 'wiz' ),
                'desc'         => '',
                'std'          => array(
                    'font-family' => 'roboto'
                ),
                'type'         => 'typography',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'main_menu_colors',
                'label'        => __( 'Main Menu Color Options', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'main_menu_sep',
                'label'        => __( 'Main Menu Separator', 'wiz' ),
                'desc'         => '',
                'std'          => 'on',
                'type'         => 'on-off',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'main_menu_sub_typography',
                'label'        => __( 'Main Menu Sublevels Typography', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'typography',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'main_sub_colors',
                'label'        => __( 'Main Menu Sublevels Color Options', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'main_sub_width',
                'label'        => __( 'Main Submenu Width', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'measurement',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'vertical_menu_items_typography',
                'label'        => __( 'Vertical Menu Items Typography', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'typography',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'vertical_menu_items_hover_color',
                'label'        => __( 'Vertical Menu Items Hover Color', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'colorpicker',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'accordion_menu_end',
                'label'        => __( 'Main Menu Settings End', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_end',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'accordion_stick_header_start',
                'label'        => __( 'Sticky Header Settings', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_start',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'sticky_header',
                'label'        => __( 'Enable Sticky Header', 'wiz' ),
                'desc'         => __( 'Enable a fixed header when scrolling.', 'wiz' ),
                'std'          => 'yes',
                'type'         => 'radio',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'yes',
                        'label' => __( 'Yes', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'no',
                        'label' => __( 'No', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'sticky_header_bg',
                'label'        => __( 'Sticky Header Background', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'background',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'ot-colorpicker-opacity',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'sticky_logo',
                'label'        => __( 'Sticky and Responsive Logo Image', 'wiz' ),
                'desc'         => __( 'Use a custom logo for sticky header option and responsive layouts(phones and tablets).', 'wiz' ),
                'std'          => '',
                'type'         => 'upload',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'sticky_menu_colors',
                'label'        => __( 'Sticky Menu Color Options', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'sticky_sub_colors',
                'label'        => __( 'Sticky Menu Sublevels Color Options', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'sticky_header_border_bottom_color',
                'label'        => __( 'Sticky Header Border Bottom Color', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'colorpicker',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'sticky_header_shadow',
                'label'        => __( 'Sticky Header shadow', 'wiz' ),
                'desc'         => '',
                'std'          => 'off',
                'type'         => 'on-off',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'accordion_stick_header_end',
                'label'        => __( 'Sticky Header End', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_end',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'accordion_top_header',
                'label'        => __( 'Top Header Settings', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_start',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'top_header_bg',
                'label'        => __( 'Top Header Background', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'background',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'ot-colorpicker-opacity',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'header_phone',
                'label'        => __( 'Header Phone Number', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'text',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'clear-both one_half',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'header_email',
                'label'        => __( 'Header Email Address', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'text',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'one_half last',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'top_header_border_color',
                'label'        => __( 'Top Header Border Color', 'wiz' ),
                'desc'         => __( 'Only for headers 1, 2, 4, 5 &amp; 6', 'wiz' ),
                'std'          => '',
                'type'         => 'colorpicker',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'top_social_icons_colors',
                'label'        => __( 'Top social icons colors', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'contact_details_typography',
                'label'        => __( 'Contact Details Typography', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'typography',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'clear-both',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'top_menu_typography',
                'label'        => __( 'Top Menu Typography', 'wiz' ),
                'desc'         => __( 'For Header 5 only.', 'wiz' ),
                'std'          => '',
                'type'         => 'typography',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'top_menu_colors',
                'label'        => __( 'Top Menu Color Options', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'top_menu_sep',
                'label'        => __( 'Top Menu Separator', 'wiz' ),
                'desc'         => '',
                'std'          => 'on',
                'type'         => 'on-off',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'top_menu_sub_typography',
                'label'        => __( 'Top Menu Sublevels Typography', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'typography',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'top_sub_colors',
                'label'        => __( 'Top Menu Sublevels Color Options', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'accordion_top_header_end',
                'label'        => __( 'Top Header End', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_end',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'accordion_pt_layout_start',
                'label'        => __( 'Page Title Bar Layout', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_start',
                'section'      => 'page_title',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'page_title_layout',
                'label'        => __( 'Select a Page Title Layout', 'wiz' ),
                'desc'         => '',
                'std'          => 'title1',
                'type'         => 'radio-image',
                'section'      => 'page_title',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'title1',
                        'label' => __( 'Title 1', 'wiz' ),
                        'src'   => 'titles/title1.png'
                    ),
                    array(
                        'value' => 'title2',
                        'label' => __( 'Title 2', 'wiz' ),
                        'src'   => 'titles/title2.png'
                    ),
                    array(
                        'value' => 'title3',
                        'label' => __( 'Title 3', 'wiz' ),
                        'src'   => 'titles/title3.png'
                    ),
                    array(
                        'value' => 'none',
                        'label' => __( 'None', 'wiz' ),
                        'src'   => 'titles/none.png'
                    )
                )
            ),
            array(
                'id'           => 'accordion_pt_layout_end',
                'label'        => __( 'Page Title Bar Layout End', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_end',
                'section'      => 'page_title',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'accordion_page_title',
                'label'        => __( 'Page Title Bar Settings', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_start',
                'section'      => 'page_title',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'page_title_typography',
                'label'        => __( 'Page Title Typography', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'typography',
                'section'      => 'page_title',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'page_title_bg',
                'label'        => __( 'Page Title Bar Background', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'background',
                'section'      => 'page_title',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'clear-both',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'parallax_page_title_bg',
                'label'        => __( 'Parallax Page Title Bar Background', 'wiz' ),
                'desc'         => '',
                'std'          => 'off',
                'type'         => 'on-off',
                'section'      => 'page_title',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'clear-both',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'page_title_bg_retina',
                'label'        => __( 'Page Title Bar Background (Retina Version @2x)', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'upload',
                'section'      => 'page_title',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'page_title_bg_retina_dimensions',
                'label'        => __( 'Normal Page Title background Dimensions for Retina', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'dimension',
                'section'      => 'page_title',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'title_spacing',
                'label'        => __( 'Title Top & Bottom Spacing', 'wiz' ),
                'desc'         => '',
                'std'          => array(
                    'top'    => '30',
                    'bottom' => '30',
                    'unit'   => 'px'
                ),
                'type'         => 'spacing',
                'section'      => 'page_title',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'page_title_bar_shadow',
                'label'        => __( 'Page Title Bar Shadow', 'wiz' ),
                'desc'         => '',
                'std'          => 'off',
                'type'         => 'on-off',
                'section'      => 'page_title',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'clear-both',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'subtitle_typography',
                'label'        => __( 'Subtitle Typography', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'typography',
                'section'      => 'page_title',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'title_separator_color',
                'label'        => __( 'Separator Color', 'wiz' ),
                'desc'         => __( 'For page titles 2 & 3.', 'wiz' ),
                'std'          => '',
                'type'         => 'colorpicker',
                'section'      => 'page_title',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'accordion_page_title_end',
                'label'        => __( 'Page Title Bar End', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_end',
                'section'      => 'page_title',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'accordion_bread_settings_start',
                'label'        => __( 'Breadcrumbs Settings', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_start',
                'section'      => 'page_title',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'enable_breadcrumbs',
                'label'        => __( 'Enable breadcrumbs', 'wiz' ),
                'desc'         => '',
                'std'          => 'yes',
                'type'         => 'radio',
                'section'      => 'page_title',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'yes',
                        'label' => __( 'Yes', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'no',
                        'label' => __( 'No', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'breadcrumbs_you_are_here',
                'label'        => __( 'Breadcrumbs Prefix Text', 'wiz' ),
                'desc'         => '',
                'std'          => 'You are here',
                'type'         => 'text',
                'section'      => 'page_title',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'breadcrumbs_show_on_home',
                'label'        => __( 'Show on home', 'wiz' ),
                'desc'         => __( 'Show breadcrumbs on the homepage', 'wiz' ),
                'std'          => 'no',
                'type'         => 'radio',
                'section'      => 'page_title',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'yes',
                        'label' => __( 'Yes', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'no',
                        'label' => __( 'No', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'breadcrumbs_delimiter',
                'label'        => __( 'Delimiter', 'wiz' ),
                'desc'         => __( 'Delimiter between crumbs', 'wiz' ),
                'std'          => '&raquo;',
                'type'         => 'text',
                'section'      => 'page_title',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'breadcrumbs_home_text',
                'label'        => __( 'Homepage Link Name', 'wiz' ),
                'desc'         => __( 'Text for the \'Home\' link', 'wiz' ),
                'std'          => 'Home',
                'type'         => 'text',
                'section'      => 'page_title',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'breadcrumbs_show_current',
                'label'        => __( 'Show Current', 'wiz' ),
                'desc'         => __( 'Show current post/page title in breadcrumbs', 'wiz' ),
                'std'          => 'yes',
                'type'         => 'radio',
                'section'      => 'page_title',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'yes',
                        'label' => __( 'Yes', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'no',
                        'label' => __( 'No', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'breadcrumbs_typography',
                'label'        => __( 'Breadcrumbs Typography', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'typography',
                'section'      => 'page_title',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'clear-both',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'breadcrumbs_links_hover',
                'label'        => __( 'Breadcrumbs Links hover Color', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'colorpicker',
                'section'      => 'page_title',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'accordion_bread_settings_end',
                'label'        => __( 'Breadcrumbs Settings End', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_end',
                'section'      => 'page_title',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'accordion_footer',
                'label'        => __( 'Footer', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_start',
                'section'      => 'footer',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'footer_bg',
                'label'        => __( 'Footer Background', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'background',
                'section'      => 'footer',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'footer_typography',
                'label'        => __( 'Footer Typography', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'typography',
                'section'      => 'footer',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'footer_spacing',
                'label'        => __( 'Footer Top & Bottom Spacing', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'spacing',
                'section'      => 'footer',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'footer_widgets_titles_typography',
                'label'        => __( 'Footer Widgets Titles', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'typography',
                'section'      => 'footer',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'footer_colors',
                'label'        => __( 'Footer Color Options', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'footer',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'footer_button_colors',
                'label'        => __( 'Footer Button Color Options', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'footer',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'ot-colorpicker-opacity',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'footer_button_radius',
                'label'        => __( 'Footer Button Radius', 'wiz' ),
                'desc'         => '',
                'std'          => 'on',
                'type'         => 'on-off',
                'section'      => 'footer',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'footer_input_colors',
                'label'        => __( 'Footer Input Color Options', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'footer',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'go_top',
                'label'        => __( '\'Go To Top\' Icon', 'wiz' ),
                'desc'         => __( 'Display \'Go To Top\' Icon on footer of the page.', 'wiz' ),
                'std'          => 'yes',
                'type'         => 'radio',
                'section'      => 'footer',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'yes',
                        'label' => __( 'Yes', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'no',
                        'label' => __( 'No', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'go_top_colors',
                'label'        => __( 'Go top Icon Color Options', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'footer',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'go_top_spacing',
                'label'        => __( 'Go top Icon Spacing', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'spacing',
                'section'      => 'footer',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'accordion_footer_end',
                'label'        => __( 'Footer End', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_end',
                'section'      => 'footer',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'accordion_copyright',
                'label'        => __( 'Copyright', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_start',
                'section'      => 'footer',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'copyright_area',
                'label'        => __( 'Display Copyright Area', 'wiz' ),
                'desc'         => '',
                'std'          => 'on',
                'type'         => 'on-off',
                'section'      => 'footer',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'copyright_top_border',
                'label'        => 'Copyright Top Border',
                'desc'         => '',
                'std'          => '',
                'type'         => 'border',
                'section'      => 'footer',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'footer_social_icons',
                'label'        => __( 'Social Icons', 'wiz' ),
                'desc'         => __( 'Display Social Icons on Footer of the Page.', 'wiz' ),
                'std'          => 'yes',
                'type'         => 'radio',
                'section'      => 'footer',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'yes',
                        'label' => __( 'Yes', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'no',
                        'label' => __( 'No', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'copyright_social_icons_colors',
                'label'        => __( 'Copyright social color Options', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'footer',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'copyright',
                'label'        => __( 'Copyright', 'wiz' ),
                'desc'         => __( 'Enter the text that displays in the copyright bar. HTML markup can be used.', 'wiz' ),
                'std'          => '',
                'type'         => 'textarea-simple',
                'section'      => 'footer',
                'rows'         => '7',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'copyright_typography',
                'label'        => __( 'Copyright Typography', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'typography',
                'section'      => 'footer',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'copyright_colors',
                'label'        => __( 'Copyright Color Options', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'footer',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'one_half',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'accordion_copyright_end',
                'label'        => __( 'Copyright End', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_end',
                'section'      => 'footer',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'accordion_general',
                'label'        => __( 'General', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_start',
                'section'      => 'content',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'body_typography',
                'label'        => __( 'Body Typography', 'wiz' ),
                'desc'         => '',
                'std'          => array(
                    'font-family' => 'opensans'
                ),
                'type'         => 'typography',
                'section'      => 'content',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'links_color',
                'label'        => __( 'Links Color', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'content',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'button_typography',
                'label'        => esc_html__( 'Button Typography', 'wiz' ),
                'std'          => '',
                'type'         => 'typography',
                'section'      => 'content',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),       
            array(
                'id'           => 'button_spacing',
                'label'        => esc_html__( 'Button Content Spacing', 'wiz' ),
                 'std'          => '',
                'type'         => 'spacing',
                'section'      => 'content',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'button_radius_size',
                'label'        => __( 'Button Radius Size', 'wiz' ),
                'std'          => '',
                'type'         => 'measurement',
                'section'      => 'content',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'button_border',
                'label'        => __( 'Button Border', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'border',
                'section'      => 'content',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'operator'     => 'or'
            ),
            array(
                'id'           => 'button_color_options',
                'label'        => __( 'Button Color Options', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'content',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'ot-colorpicker-opacity ',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'image_overlay_color_options',
                'label'        => __( 'Image Overlay Color Options', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'content',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'overlay_opacity',
                'label'        => __( 'Image Overlay Opacity', 'wiz' ),
                'desc'         => __( 'From 0 to 1.', 'wiz' ),
                'std'          => '',
                'type'         => 'text',
                'section'      => 'content',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '0, 1.01, 0.01',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'input_color_options',
                'label'        => __( 'Input Color Options', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'content',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'display_titles_strip_image',
                'label'        => __( 'Display Titles Strip Image', 'wiz' ),
                'desc'         => '',
                'std'          => 'on',
                'type'         => 'on-off',
                'section'      => 'content',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'titles_strip_image',
                'label'        => __( 'Titles Custom Strip Image', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'upload',
                'section'      => 'content',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'clear-both',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'page_content_spacing',
                'label'        => __( 'Page Content Top & Bottom Spacing', 'wiz' ),
                'desc'         => '',
                'std'          => array(
                    'top'    => '25',
                    'bottom' => '25',
                    'unit'   => 'px'
                ),
                'type'         => 'spacing',
                'section'      => 'content',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'content_bg',
                'label'        => __( 'Content Background', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'background',
                'section'      => 'content',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'clear-both',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'content_meta_color',
                'label'        => __( 'Main Content Meta Color', 'wiz' ),
                'desc'         => __( 'Used for the following meta date, author, categories, tags, comments,... etc.', 'wiz' ),
                'std'          => '',
                'type'         => 'colorpicker',
                'section'      => 'content',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'content_entry_typography',
                'label'        => __( 'Main Content Entry Typography', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'typography',
                'section'      => 'content',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'sharing_box_colors',
                'label'        => __( 'Sharing Box Color Options', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'content',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'accordion_general_end',
                'label'        => __( 'General End', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_end',
                'section'      => 'content',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'accordion_content_headings_start',
                'label'        => __( 'Content Headings', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_start',
                'section'      => 'content',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'title-block',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'h1_typography',
                'label'        => __( 'H1 Typography', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'typography',
                'section'      => 'content',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'h2_typography',
                'label'        => __( 'H2 Typography', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'typography',
                'section'      => 'content',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'h3_typography',
                'label'        => __( 'H3 Typography', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'typography',
                'section'      => 'content',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'h4_typography',
                'label'        => __( 'H4 Typography', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'typography',
                'section'      => 'content',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'h5_typography',
                'label'        => __( 'H5 Typography', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'typography',
                'section'      => 'content',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'h6_typography',
                'label'        => __( 'H6 Typography', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'typography',
                'section'      => 'content',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'accordion_content_headings_end',
                'label'        => __( 'Content Headings End', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_end',
                'section'      => 'content',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'disable_responsive',
                'label'        => __( 'Disable Responsive', 'wiz' ),
                'desc'         => __( 'Disable responsive design features.', 'wiz' ),
                'std'          => 'no',
                'type'         => 'radio',
                'section'      => 'responsive',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'yes',
                        'label' => __( 'Yes', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'no',
                        'label' => __( 'No', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'mobile_menu_width',
                'label'        => __( 'Display Responsive Menu at Width', 'wiz' ),
                'desc'         => __( 'Enter the width at which you would like to begin displaying the Responsive menu.', 'wiz' ),
                'std'          => array( 767, 'px' ),
                'type'         => 'measurement',
                'section'      => 'responsive',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'mobile_display_top_header',
                'label'        => __( 'Display Top Header on Responsive View', 'wiz' ),
                'desc'         => '',
                'std'          => 'off',
                'type'         => 'on-off',
                'section'      => 'responsive',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'accordion_sidebar_generator',
                'label'        => __( 'Sidebar Generator', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_start',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'sidebar_generator',
                'label'        => __( 'Sidebar Generator', 'wiz' ),
                'desc'         => __( 'You can create as many sidebars as you need for any page you want.', 'wiz' ),
                'std'          => '',
                'type'         => 'list-item',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'not-sortable remove-border',
                'condition'    => '',
                'operator'     => 'and',
                'settings'     => array(
                    array(
                        'id'           => 'class',
                        'label'        => __( 'Class', 'wiz' ),
                        'desc'         => '',
                        'std'          => '',
                        'type'         => 'text',
                        'rows'         => '',
                        'post_type'    => '',
                        'taxonomy'     => '',
                        'min_max_step' => '',
                        'class'        => '',
                        'condition'    => '',
                        'operator'     => 'and'
                    )
                )
            ),
            array(
                'id'           => 'aaccordion_sidebar_generator_end',
                'label'        => __( 'End Sidebar Generator', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_end',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'accordion_main_sidebar',
                'label'        => __( 'Main Sidebar', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_start',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'title-block',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'sticky_main_sidebar',
                'label'        => __( 'Sticky Main Sidebar', 'wiz' ),
                'desc'         => '',
                'std'          => 'off',
                'type'         => 'on-off',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'main_sidebar_bg',
                'label'        => __( 'Main Sidebar Background', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'background',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'main_sidebar_typography',
                'label'        => __( 'Main Sidebar Typography', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'typography',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'main_sidebar_widgets_titles_typography',
                'label'        => __( 'Main Sidebar Widgets Titles Typography', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'typography',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'main_sidebar_colors',
                'label'        => __( 'Main Sidebar Color Options', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'link-color',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'main_sidebar_spacing',
                'label'        => __( 'Main Sidebar Top & Bottom Spacing', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'spacing',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'accordion_main_sidebar_end',
                'label'        => __( 'Main Sidebar End', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_end',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'title-block',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'accordion_pages_sidebar',
                'label'        => __( 'Pages Main Sidebar', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_start',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'pages_sidebar',
                'label'        => __( 'Pages Sidebar', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'sidebar-select',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'pages_sidebar_position',
                'label'        => __( 'Pages Sidebar Position', 'wiz' ),
                'desc'         => '',
                'std'          => 'right',
                'type'         => 'select',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'pages_sidebar:not()',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'right',
                        'label' => __( 'Right', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'left',
                        'label' => __( 'Left', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'accordion_pages_sidebar_end',
                'label'        => __( 'End Pages', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_end',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'accordion_blog_archive_sidebar',
                'label'        => __( 'Blog Archive/Category Main Sidebar', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_start',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'blog_archive_sidebar',
                'label'        => __( 'Blog Archive/Category Sidebar', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'sidebar-select',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'blog_archive_sidebar_position',
                'label'        => __( 'Blog Archive/Category Sidebar Position', 'wiz' ),
                'desc'         => '',
                'std'          => 'right',
                'type'         => 'select',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'blog_archive_sidebar:not()',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'right',
                        'label' => __( 'Right', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'left',
                        'label' => __( 'Left', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'accordion_blog_archive_sidebar_end',
                'label'        => __( 'End Blog Archive/Category', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_end',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'accordion_blog_posts_sidebar',
                'label'        => __( 'Blog Posts Main Sidebar', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_start',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'blog_posts_sidebar',
                'label'        => __( 'Blog Posts Sidebar', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'sidebar-select',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'blog_posts_sidebar_position',
                'label'        => __( 'Blog Posts Sidebar Position', 'wiz' ),
                'desc'         => '',
                'std'          => 'right',
                'type'         => 'select',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'blog_posts_sidebar:not()',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'right',
                        'label' => __( 'Right', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'left',
                        'label' => __( 'Left', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'accordion_blog_posts_sidebar_end',
                'label'        => __( 'End Pages', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_end',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'accordion_portfolio_archive_sidebar',
                'label'        => __( 'Portfolio Archive/Category Main Sidebar', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_start',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'portfolio_archive_sidebar',
                'label'        => __( 'Portfolio Archive/Category Sidebar', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'sidebar-select',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'portfolio_archive_sidebar_position',
                'label'        => __( 'Portfolio Archive/Category Sidebar Position', 'wiz' ),
                'desc'         => '',
                'std'          => 'right',
                'type'         => 'select',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'portfolio_archive_sidebar:not()',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'right',
                        'label' => __( 'Right', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'left',
                        'label' => __( 'Left', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'accordion_portfolio_archive_sidebar_end',
                'label'        => __( 'End Portfolio Archive/Category', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_end',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'accordion_portfolio_posts_sidebar',
                'label'        => __( 'Portfolio Posts Main Sidebar', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_start',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'portfolio_posts_sidebar',
                'label'        => __( 'Portfolio Posts Sidebar', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'sidebar-select',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'portfolio_posts_sidebar_position',
                'label'        => __( 'Portfolio Posts Sidebar Position', 'wiz' ),
                'desc'         => '',
                'std'          => 'right',
                'type'         => 'select',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'portfolio_posts_sidebar:not()',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'right',
                        'label' => __( 'Right', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'left',
                        'label' => __( 'Left', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'accordion_portfolio_posts_sidebar_end',
                'label'        => __( 'End Pages', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_end',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'accordion_woocommerce_archive_sidebar',
                'label'        => __( 'WooCommerce Archive/Category Main Sidebar', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_start',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'woocommerce_archive_sidebar',
                'label'        => __( 'WooCommerce Archive/Category Sidebar', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'sidebar-select',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'woocommerce_archive_sidebar_position',
                'label'        => __( 'WooCommerce Archive/Category Sidebar Position', 'wiz' ),
                'desc'         => '',
                'std'          => 'right',
                'type'         => 'select',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'woocommerce_archive_sidebar:not()',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'right',
                        'label' => __( 'Right', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'left',
                        'label' => __( 'Left', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'accordion_woocommerce_archive_sidebar_end',
                'label'        => __( 'End WooCommerce Archive/Category', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_end',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'accordion_woocommerce_products_sidebar',
                'label'        => __( 'WooCommerce Products Main Sidebar', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_start',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'woocommerce_products_sidebar',
                'label'        => __( 'WooCommerce Products Sidebar', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'sidebar-select',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'woocommerce_products_sidebar_position',
                'label'        => __( 'WooCommerce Products Sidebar Position', 'wiz' ),
                'desc'         => '',
                'std'          => 'right',
                'type'         => 'select',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'woocommerce_products_sidebar:not()',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'right',
                        'label' => __( 'Right', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'left',
                        'label' => __( 'Left', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'accordion_woocommerce_products_sidebar_end',
                'label'        => __( 'End WooCommerce Products', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_end',
                'section'      => 'sidebars',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'widget_positions',
                'label'        => __( 'Widget Positions', 'wiz' ),
                'desc'         => '<img src="../wp-content/themes/wiz/functions/images/sidebar/positions.jpg" />',
                'std'          => '',
                'type'         => 'textblock',
                'section'      => 'widget_positions',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'enable_header_sidebar',
                'label'        => __( 'Header Position', 'wiz' ),
                'desc'         => '',
                'std'          => 'off',
                'type'         => 'on-off',
                'section'      => 'widget_positions',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'header_sidebar',
                'label'        => __( 'Header Position Columns', 'wiz' ),
                'desc'         => '',
                'std'          => 'none',
                'type'         => 'radio-image',
                'section'      => 'widget_positions',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'enable_header_sidebar:is(on)',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'none',
                        'label' => __( 'No Columns', 'wiz' ),
                        'src'   => 'col/none.jpg'
                    ),
                    array(
                        'value' => '12',
                        'label' => __( '1/1', 'wiz' ),
                        'src'   => 'col/12.jpg'
                    ),
                    array(
                        'value' => '6-6',
                        'label' => __( '1/2-1/2', 'wiz' ),
                        'src'   => 'col/6-6.jpg'
                    ),
                    array(
                        'value' => '4-4-4',
                        'label' => __( '1/3-1/3-1/3', 'wiz' ),
                        'src'   => 'col/4-4-4.jpg'
                    ),
                    array(
                        'value' => '4-8',
                        'label' => __( '1/3-2/3', 'wiz' ),
                        'src'   => 'col/4-8.jpg'
                    ),
                    array(
                        'value' => '8-4',
                        'label' => __( '2/3-1/3', 'wiz' ),
                        'src'   => 'col/8-4.jpg'
                    ),
                    array(
                        'value' => '3-3-3-3',
                        'label' => __( '1/4-1/4-1/4-1/4', 'wiz' ),
                        'src'   => 'col/3-3-3-3.jpg'
                    ),
                    array(
                        'value' => '3-9',
                        'label' => __( '1/4-3/4', 'wiz' ),
                        'src'   => 'col/3-9.jpg'
                    ),
                    array(
                        'value' => '9-3',
                        'label' => __( '3/4-1/4', 'wiz' ),
                        'src'   => 'col/9-3.jpg'
                    ),
                    array(
                        'value' => '3-6-3',
                        'label' => __( '1/4-1/2-1/4', 'wiz' ),
                        'src'   => 'col/3-6-3.jpg'
                    ),
                    array(
                        'value' => '3-3-6',
                        'label' => __( '1/4-1/4-1/2', 'wiz' ),
                        'src'   => 'col/3-3-6.jpg'
                    ),
                    array(
                        'value' => '6-3-3',
                        'label' => __( '1/2-1/4-1/4', 'wiz' ),
                        'src'   => 'col/6-3-3.jpg'
                    )
                )
            ),
            array(
                'id'           => 'enable_main_top_sidebar',
                'label'        => __( 'Main Top Position', 'wiz' ),
                'desc'         => '',
                'std'          => 'off',
                'type'         => 'on-off',
                'section'      => 'widget_positions',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'main_top_sidebar',
                'label'        => __( 'Main Top Position Columns', 'wiz' ),
                'desc'         => '',
                'std'          => 'none',
                'type'         => 'radio-image',
                'section'      => 'widget_positions',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'enable_main_top_sidebar:is(on)',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'none',
                        'label' => __( 'No Columns', 'wiz' ),
                        'src'   => 'col/none.jpg'
                    ),
                    array(
                        'value' => '12',
                        'label' => __( '1/1', 'wiz' ),
                        'src'   => 'col/12.jpg'
                    ),
                    array(
                        'value' => '6-6',
                        'label' => __( '1/2-1/2', 'wiz' ),
                        'src'   => 'col/6-6.jpg'
                    ),
                    array(
                        'value' => '4-4-4',
                        'label' => __( '1/3-1/3-1/3', 'wiz' ),
                        'src'   => 'col/4-4-4.jpg'
                    ),
                    array(
                        'value' => '4-8',
                        'label' => __( '1/3-2/3', 'wiz' ),
                        'src'   => 'col/4-8.jpg'
                    ),
                    array(
                        'value' => '8-4',
                        'label' => __( '2/3-1/3', 'wiz' ),
                        'src'   => 'col/8-4.jpg'
                    ),
                    array(
                        'value' => '3-3-3-3',
                        'label' => __( '1/4-1/4-1/4-1/4', 'wiz' ),
                        'src'   => 'col/3-3-3-3.jpg'
                    ),
                    array(
                        'value' => '3-9',
                        'label' => __( '1/4-3/4', 'wiz' ),
                        'src'   => 'col/3-9.jpg'
                    ),
                    array(
                        'value' => '9-3',
                        'label' => __( '3/4-1/4', 'wiz' ),
                        'src'   => 'col/9-3.jpg'
                    ),
                    array(
                        'value' => '3-6-3',
                        'label' => __( '1/4-1/2-1/4', 'wiz' ),
                        'src'   => 'col/3-6-3.jpg'
                    ),
                    array(
                        'value' => '3-3-6',
                        'label' => __( '1/4-1/4-1/2', 'wiz' ),
                        'src'   => 'col/3-3-6.jpg'
                    ),
                    array(
                        'value' => '6-3-3',
                        'label' => __( '1/2-1/4-1/4', 'wiz' ),
                        'src'   => 'col/6-3-3.jpg'
                    )
                )
            ),
            array(
                'id'           => 'enable_header_full_width_sidebar',
                'label'        => __( 'Header Full Width Position', 'wiz' ),
                'desc'         => '',
                'std'          => 'off',
                'type'         => 'on-off',
                'section'      => 'widget_positions',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'header_full_width_sidebar',
                'label'        => __( 'Header Full Width Position Columns', 'wiz' ),
                'desc'         => '',
                'std'          => 'none',
                'type'         => 'radio-image',
                'section'      => 'widget_positions',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'enable_header_full_width_sidebar:is(on)',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'none',
                        'label' => __( 'No Columns', 'wiz' ),
                        'src'   => 'col/none.jpg'
                    ),
                    array(
                        'value' => '12',
                        'label' => __( '1/1', 'wiz' ),
                        'src'   => 'col/12.jpg'
                    ),
                    array(
                        'value' => '6-6',
                        'label' => __( '1/2-1/2', 'wiz' ),
                        'src'   => 'col/6-6.jpg'
                    ),
                    array(
                        'value' => '4-4-4',
                        'label' => __( '1/3-1/3-1/3', 'wiz' ),
                        'src'   => 'col/4-4-4.jpg'
                    ),
                    array(
                        'value' => '4-8',
                        'label' => __( '1/3-2/3', 'wiz' ),
                        'src'   => 'col/4-8.jpg'
                    ),
                    array(
                        'value' => '8-4',
                        'label' => __( '2/3-1/3', 'wiz' ),
                        'src'   => 'col/8-4.jpg'
                    ),
                    array(
                        'value' => '3-3-3-3',
                        'label' => __( '1/4-1/4-1/4-1/4', 'wiz' ),
                        'src'   => 'col/3-3-3-3.jpg'
                    ),
                    array(
                        'value' => '3-9',
                        'label' => __( '1/4-3/4', 'wiz' ),
                        'src'   => 'col/3-9.jpg'
                    ),
                    array(
                        'value' => '9-3',
                        'label' => __( '3/4-1/4', 'wiz' ),
                        'src'   => 'col/9-3.jpg'
                    ),
                    array(
                        'value' => '3-6-3',
                        'label' => __( '1/4-1/2-1/4', 'wiz' ),
                        'src'   => 'col/3-6-3.jpg'
                    ),
                    array(
                        'value' => '3-3-6',
                        'label' => __( '1/4-1/4-1/2', 'wiz' ),
                        'src'   => 'col/3-3-6.jpg'
                    ),
                    array(
                        'value' => '6-3-3',
                        'label' => __( '1/2-1/4-1/4', 'wiz' ),
                        'src'   => 'col/6-3-3.jpg'
                    )
                )
            ),
            array(
                'id'           => 'enable_main_content_top_sidebar',
                'label'        => __( 'Main Content Top Position', 'wiz' ),
                'desc'         => '',
                'std'          => 'off',
                'type'         => 'on-off',
                'section'      => 'widget_positions',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'main_content_top_sidebar',
                'label'        => __( 'Main Content Top Position Columns', 'wiz' ),
                'desc'         => '',
                'std'          => 'none',
                'type'         => 'radio-image',
                'section'      => 'widget_positions',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'enable_main_content_top_sidebar:is(on)',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'none',
                        'label' => __( 'No Columns', 'wiz' ),
                        'src'   => 'col/none.jpg'
                    ),
                    array(
                        'value' => '12',
                        'label' => __( '1/1', 'wiz' ),
                        'src'   => 'col/12.jpg'
                    ),
                    array(
                        'value' => '6-6',
                        'label' => __( '1/2-1/2', 'wiz' ),
                        'src'   => 'col/6-6.jpg'
                    ),
                    array(
                        'value' => '4-4-4',
                        'label' => __( '1/3-1/3-1/3', 'wiz' ),
                        'src'   => 'col/4-4-4.jpg'
                    ),
                    array(
                        'value' => '4-8',
                        'label' => __( '1/3-2/3', 'wiz' ),
                        'src'   => 'col/4-8.jpg'
                    ),
                    array(
                        'value' => '8-4',
                        'label' => __( '2/3-1/3', 'wiz' ),
                        'src'   => 'col/8-4.jpg'
                    ),
                    array(
                        'value' => '3-3-3-3',
                        'label' => __( '1/4-1/4-1/4-1/4', 'wiz' ),
                        'src'   => 'col/3-3-3-3.jpg'
                    ),
                    array(
                        'value' => '3-9',
                        'label' => __( '1/4-3/4', 'wiz' ),
                        'src'   => 'col/3-9.jpg'
                    ),
                    array(
                        'value' => '9-3',
                        'label' => __( '3/4-1/4', 'wiz' ),
                        'src'   => 'col/9-3.jpg'
                    ),
                    array(
                        'value' => '3-6-3',
                        'label' => __( '1/4-1/2-1/4', 'wiz' ),
                        'src'   => 'col/3-6-3.jpg'
                    ),
                    array(
                        'value' => '3-3-6',
                        'label' => __( '1/4-1/4-1/2', 'wiz' ),
                        'src'   => 'col/3-3-6.jpg'
                    ),
                    array(
                        'value' => '6-3-3',
                        'label' => __( '1/2-1/4-1/4', 'wiz' ),
                        'src'   => 'col/6-3-3.jpg'
                    )
                )
            ),
            array(
                'id'           => 'enable_content_top_sidebar',
                'label'        => __( 'Content Top Position', 'wiz' ),
                'desc'         => '',
                'std'          => 'off',
                'type'         => 'on-off',
                'section'      => 'widget_positions',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'content_top_sidebar',
                'label'        => __( 'Content Top Position Columns', 'wiz' ),
                'desc'         => '',
                'std'          => 'none',
                'type'         => 'radio-image',
                'section'      => 'widget_positions',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'enable_content_top_sidebar:is(on)',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'none',
                        'label' => __( 'No Columns', 'wiz' ),
                        'src'   => 'col/none.jpg'
                    ),
                    array(
                        'value' => '12',
                        'label' => __( '1/1', 'wiz' ),
                        'src'   => 'col/12.jpg'
                    ),
                    array(
                        'value' => '6-6',
                        'label' => __( '1/2-1/2', 'wiz' ),
                        'src'   => 'col/6-6.jpg'
                    ),
                    array(
                        'value' => '4-4-4',
                        'label' => __( '1/3-1/3-1/3', 'wiz' ),
                        'src'   => 'col/4-4-4.jpg'
                    ),
                    array(
                        'value' => '4-8',
                        'label' => __( '1/3-2/3', 'wiz' ),
                        'src'   => 'col/4-8.jpg'
                    ),
                    array(
                        'value' => '8-4',
                        'label' => __( '2/3-1/3', 'wiz' ),
                        'src'   => 'col/8-4.jpg'
                    ),
                    array(
                        'value' => '3-3-3-3',
                        'label' => __( '1/4-1/4-1/4-1/4', 'wiz' ),
                        'src'   => 'col/3-3-3-3.jpg'
                    ),
                    array(
                        'value' => '3-9',
                        'label' => __( '1/4-3/4', 'wiz' ),
                        'src'   => 'col/3-9.jpg'
                    ),
                    array(
                        'value' => '9-3',
                        'label' => __( '3/4-1/4', 'wiz' ),
                        'src'   => 'col/9-3.jpg'
                    ),
                    array(
                        'value' => '3-6-3',
                        'label' => __( '1/4-1/2-1/4', 'wiz' ),
                        'src'   => 'col/3-6-3.jpg'
                    ),
                    array(
                        'value' => '3-3-6',
                        'label' => __( '1/4-1/4-1/2', 'wiz' ),
                        'src'   => 'col/3-3-6.jpg'
                    ),
                    array(
                        'value' => '6-3-3',
                        'label' => __( '1/2-1/4-1/4', 'wiz' ),
                        'src'   => 'col/6-3-3.jpg'
                    )
                )
            ),
            array(
                'id'           => 'enable_content_bottom_sidebar',
                'label'        => __( 'Content Bottom Position', 'wiz' ),
                'desc'         => '',
                'std'          => 'off',
                'type'         => 'on-off',
                'section'      => 'widget_positions',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'content_bottom_sidebar',
                'label'        => __( 'Content Bottom Position Columns', 'wiz' ),
                'desc'         => '',
                'std'          => 'none',
                'type'         => 'radio-image',
                'section'      => 'widget_positions',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'enable_content_bottom_sidebar:is(on)',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'none',
                        'label' => __( 'No Columns', 'wiz' ),
                        'src'   => 'col/none.jpg'
                    ),
                    array(
                        'value' => '12',
                        'label' => __( '1/1', 'wiz' ),
                        'src'   => 'col/12.jpg'
                    ),
                    array(
                        'value' => '6-6',
                        'label' => __( '1/2-1/2', 'wiz' ),
                        'src'   => 'col/6-6.jpg'
                    ),
                    array(
                        'value' => '4-4-4',
                        'label' => __( '1/3-1/3-1/3', 'wiz' ),
                        'src'   => 'col/4-4-4.jpg'
                    ),
                    array(
                        'value' => '4-8',
                        'label' => __( '1/3-2/3', 'wiz' ),
                        'src'   => 'col/4-8.jpg'
                    ),
                    array(
                        'value' => '8-4',
                        'label' => __( '2/3-1/3', 'wiz' ),
                        'src'   => 'col/8-4.jpg'
                    ),
                    array(
                        'value' => '3-3-3-3',
                        'label' => __( '1/4-1/4-1/4-1/4', 'wiz' ),
                        'src'   => 'col/3-3-3-3.jpg'
                    ),
                    array(
                        'value' => '3-9',
                        'label' => __( '1/4-3/4', 'wiz' ),
                        'src'   => 'col/3-9.jpg'
                    ),
                    array(
                        'value' => '9-3',
                        'label' => __( '3/4-1/4', 'wiz' ),
                        'src'   => 'col/9-3.jpg'
                    ),
                    array(
                        'value' => '3-6-3',
                        'label' => __( '1/4-1/2-1/4', 'wiz' ),
                        'src'   => 'col/3-6-3.jpg'
                    ),
                    array(
                        'value' => '3-3-6',
                        'label' => __( '1/4-1/4-1/2', 'wiz' ),
                        'src'   => 'col/3-3-6.jpg'
                    ),
                    array(
                        'value' => '6-3-3',
                        'label' => __( '1/2-1/4-1/4', 'wiz' ),
                        'src'   => 'col/6-3-3.jpg'
                    )
                )
            ),
            array(
                'id'           => 'enable_main_content_bottom_sidebar',
                'label'        => __( 'Main Content Bottom Position', 'wiz' ),
                'desc'         => '',
                'std'          => 'off',
                'type'         => 'on-off',
                'section'      => 'widget_positions',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'main_content_bottom_sidebar',
                'label'        => __( 'Main Content Bottom Position Columns', 'wiz' ),
                'desc'         => '',
                'std'          => 'none',
                'type'         => 'radio-image',
                'section'      => 'widget_positions',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'enable_main_content_bottom_sidebar:is(on)',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'none',
                        'label' => __( 'No Columns', 'wiz' ),
                        'src'   => 'col/none.jpg'
                    ),
                    array(
                        'value' => '12',
                        'label' => __( '1/1', 'wiz' ),
                        'src'   => 'col/12.jpg'
                    ),
                    array(
                        'value' => '6-6',
                        'label' => __( '1/2-1/2', 'wiz' ),
                        'src'   => 'col/6-6.jpg'
                    ),
                    array(
                        'value' => '4-4-4',
                        'label' => __( '1/3-1/3-1/3', 'wiz' ),
                        'src'   => 'col/4-4-4.jpg'
                    ),
                    array(
                        'value' => '4-8',
                        'label' => __( '1/3-2/3', 'wiz' ),
                        'src'   => 'col/4-8.jpg'
                    ),
                    array(
                        'value' => '8-4',
                        'label' => __( '2/3-1/3', 'wiz' ),
                        'src'   => 'col/8-4.jpg'
                    ),
                    array(
                        'value' => '3-3-3-3',
                        'label' => __( '1/4-1/4-1/4-1/4', 'wiz' ),
                        'src'   => 'col/3-3-3-3.jpg'
                    ),
                    array(
                        'value' => '3-9',
                        'label' => __( '1/4-3/4', 'wiz' ),
                        'src'   => 'col/3-9.jpg'
                    ),
                    array(
                        'value' => '9-3',
                        'label' => __( '3/4-1/4', 'wiz' ),
                        'src'   => 'col/9-3.jpg'
                    ),
                    array(
                        'value' => '3-6-3',
                        'label' => __( '1/4-1/2-1/4', 'wiz' ),
                        'src'   => 'col/3-6-3.jpg'
                    ),
                    array(
                        'value' => '3-3-6',
                        'label' => __( '1/4-1/4-1/2', 'wiz' ),
                        'src'   => 'col/3-3-6.jpg'
                    ),
                    array(
                        'value' => '6-3-3',
                        'label' => __( '1/2-1/4-1/4', 'wiz' ),
                        'src'   => 'col/6-3-3.jpg'
                    )
                )
            ),
            array(
                'id'           => 'enable_footer_full_width_sidebar',
                'label'        => __( 'Footer Full Width Position', 'wiz' ),
                'desc'         => '',
                'std'          => 'off',
                'type'         => 'on-off',
                'section'      => 'widget_positions',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'footer_full_width_sidebar',
                'label'        => __( 'Footer Full Width Position Columns', 'wiz' ),
                'desc'         => '',
                'std'          => 'none',
                'type'         => 'radio-image',
                'section'      => 'widget_positions',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'enable_footer_full_width_sidebar:is(on)',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'none',
                        'label' => __( 'No Columns', 'wiz' ),
                        'src'   => 'col/none.jpg'
                    ),
                    array(
                        'value' => '12',
                        'label' => __( '1/1', 'wiz' ),
                        'src'   => 'col/12.jpg'
                    ),
                    array(
                        'value' => '6-6',
                        'label' => __( '1/2-1/2', 'wiz' ),
                        'src'   => 'col/6-6.jpg'
                    ),
                    array(
                        'value' => '4-4-4',
                        'label' => __( '1/3-1/3-1/3', 'wiz' ),
                        'src'   => 'col/4-4-4.jpg'
                    ),
                    array(
                        'value' => '4-8',
                        'label' => __( '1/3-2/3', 'wiz' ),
                        'src'   => 'col/4-8.jpg'
                    ),
                    array(
                        'value' => '8-4',
                        'label' => __( '2/3-1/3', 'wiz' ),
                        'src'   => 'col/8-4.jpg'
                    ),
                    array(
                        'value' => '3-3-3-3',
                        'label' => __( '1/4-1/4-1/4-1/4', 'wiz' ),
                        'src'   => 'col/3-3-3-3.jpg'
                    ),
                    array(
                        'value' => '3-9',
                        'label' => __( '1/4-3/4', 'wiz' ),
                        'src'   => 'col/3-9.jpg'
                    ),
                    array(
                        'value' => '9-3',
                        'label' => __( '3/4-1/4', 'wiz' ),
                        'src'   => 'col/9-3.jpg'
                    ),
                    array(
                        'value' => '3-6-3',
                        'label' => __( '1/4-1/2-1/4', 'wiz' ),
                        'src'   => 'col/3-6-3.jpg'
                    ),
                    array(
                        'value' => '3-3-6',
                        'label' => __( '1/4-1/4-1/2', 'wiz' ),
                        'src'   => 'col/3-3-6.jpg'
                    ),
                    array(
                        'value' => '6-3-3',
                        'label' => __( '1/2-1/4-1/4', 'wiz' ),
                        'src'   => 'col/6-3-3.jpg'
                    )
                )
            ),
            array(
                'id'           => 'enable_main_bottom_sidebar',
                'label'        => __( 'Main Bottom Position', 'wiz' ),
                'desc'         => '',
                'std'          => 'off',
                'type'         => 'on-off',
                'section'      => 'widget_positions',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'main_bottom_sidebar',
                'label'        => __( 'Main Bottom Position Columns', 'wiz' ),
                'desc'         => '',
                'std'          => 'none',
                'type'         => 'radio-image',
                'section'      => 'widget_positions',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'enable_main_bottom_sidebar:is(on)',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'none',
                        'label' => __( 'No Columns', 'wiz' ),
                        'src'   => 'col/none.jpg'
                    ),
                    array(
                        'value' => '12',
                        'label' => __( '1/1', 'wiz' ),
                        'src'   => 'col/12.jpg'
                    ),
                    array(
                        'value' => '6-6',
                        'label' => __( '1/2-1/2', 'wiz' ),
                        'src'   => 'col/6-6.jpg'
                    ),
                    array(
                        'value' => '4-4-4',
                        'label' => __( '1/3-1/3-1/3', 'wiz' ),
                        'src'   => 'col/4-4-4.jpg'
                    ),
                    array(
                        'value' => '4-8',
                        'label' => __( '1/3-2/3', 'wiz' ),
                        'src'   => 'col/4-8.jpg'
                    ),
                    array(
                        'value' => '8-4',
                        'label' => __( '2/3-1/3', 'wiz' ),
                        'src'   => 'col/8-4.jpg'
                    ),
                    array(
                        'value' => '3-3-3-3',
                        'label' => __( '1/4-1/4-1/4-1/4', 'wiz' ),
                        'src'   => 'col/3-3-3-3.jpg'
                    ),
                    array(
                        'value' => '3-9',
                        'label' => __( '1/4-3/4', 'wiz' ),
                        'src'   => 'col/3-9.jpg'
                    ),
                    array(
                        'value' => '9-3',
                        'label' => __( '3/4-1/4', 'wiz' ),
                        'src'   => 'col/9-3.jpg'
                    ),
                    array(
                        'value' => '3-6-3',
                        'label' => __( '1/4-1/2-1/4', 'wiz' ),
                        'src'   => 'col/3-6-3.jpg'
                    ),
                    array(
                        'value' => '3-3-6',
                        'label' => __( '1/4-1/4-1/2', 'wiz' ),
                        'src'   => 'col/3-3-6.jpg'
                    ),
                    array(
                        'value' => '6-3-3',
                        'label' => __( '1/2-1/4-1/4', 'wiz' ),
                        'src'   => 'col/6-3-3.jpg'
                    )
                )
            ),
            array(
                'id'           => 'enable_footer_sidebar',
                'label'        => __( 'Footer Position', 'wiz' ),
                'desc'         => '',
                'std'          => 'on',
                'type'         => 'on-off',
                'section'      => 'widget_positions',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'footer_sidebar',
                'label'        => __( 'Footer Position Columns', 'wiz' ),
                'desc'         => '',
                'std'          => '3-3-3-3',
                'type'         => 'radio-image',
                'section'      => 'widget_positions',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'enable_footer_sidebar:is(on)',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'none',
                        'label' => __( 'No Columns', 'wiz' ),
                        'src'   => 'col/none.jpg'
                    ),
                    array(
                        'value' => '12',
                        'label' => __( '1/1', 'wiz' ),
                        'src'   => 'col/12.jpg'
                    ),
                    array(
                        'value' => '6-6',
                        'label' => __( '1/2-1/2', 'wiz' ),
                        'src'   => 'col/6-6.jpg'
                    ),
                    array(
                        'value' => '4-4-4',
                        'label' => __( '1/3-1/3-1/3', 'wiz' ),
                        'src'   => 'col/4-4-4.jpg'
                    ),
                    array(
                        'value' => '4-8',
                        'label' => __( '1/3-2/3', 'wiz' ),
                        'src'   => 'col/4-8.jpg'
                    ),
                    array(
                        'value' => '8-4',
                        'label' => __( '2/3-1/3', 'wiz' ),
                        'src'   => 'col/8-4.jpg'
                    ),
                    array(
                        'value' => '3-3-3-3',
                        'label' => __( '1/4-1/4-1/4-1/4', 'wiz' ),
                        'src'   => 'col/3-3-3-3.jpg'
                    ),
                    array(
                        'value' => '3-9',
                        'label' => __( '1/4-3/4', 'wiz' ),
                        'src'   => 'col/3-9.jpg'
                    ),
                    array(
                        'value' => '9-3',
                        'label' => __( '3/4-1/4', 'wiz' ),
                        'src'   => 'col/9-3.jpg'
                    ),
                    array(
                        'value' => '3-6-3',
                        'label' => __( '1/4-1/2-1/4', 'wiz' ),
                        'src'   => 'col/3-6-3.jpg'
                    ),
                    array(
                        'value' => '3-3-6',
                        'label' => __( '1/4-1/4-1/2', 'wiz' ),
                        'src'   => 'col/3-3-6.jpg'
                    ),
                    array(
                        'value' => '6-3-3',
                        'label' => __( '1/2-1/4-1/4', 'wiz' ),
                        'src'   => 'col/6-3-3.jpg'
                    )
                )
            ),
            array(
                'id'           => 'override_widget_positions',
                'label'        => __( 'Override Widget Positions on', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'checkbox',
                'section'      => 'widget_positions',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'post',
                        'label' => __( 'Post', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'page',
                        'label' => __( 'Page', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'leap-portfolio',
                        'label' => __( 'Portfolio', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'blog_title',
                'label'        => __( 'Blog Page Title', 'wiz' ),
                'desc'         => '',
                'std'          => 'Blog',
                'type'         => 'text',
                'section'      => 'blog',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'display_blog_title_posts',
                'label'        => __( 'Display Blog Title on Posts', 'wiz' ),
                'desc'         => __( 'This will display blog title on all posts except the posts that excluded from blog categories.', 'wiz' ),
                'std'          => 'no',
                'type'         => 'radio',
                'section'      => 'blog',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'yes',
                        'label' => __( 'Yes', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'no',
                        'label' => __( 'No', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'blog_exclude_categories',
                'label'        => __( 'Exclude Categories from Blog', 'wiz' ),
                'desc'         => __( 'By default the blog displays a list of all of your most recent posts. However, if you would like to exlcude certain category from the list you can do so here.', 'wiz' ),
                'std'          => '',
                'type'         => 'category-checkbox',
                'section'      => 'blog',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'blog_layout',
                'label'        => __( 'Blog Layout', 'wiz' ),
                'desc'         => '',
                'std'          => 'large',
                'type'         => 'select',
                'section'      => 'blog',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'grid',
                        'label' => __( 'Grid', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'classic',
                        'label' => __( 'Classic', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'large',
                        'label' => __( 'Large', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'large-modern',
                        'label' => __( 'Large Modern', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'rightleft-image',
                        'label' => __( 'Right/Left Image', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'medium',
                        'label' => __( 'Medium', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'postformat',
                        'label' => __( 'Post Format', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'blog_display_format',
                'label'        => __( 'Blog Display Format', 'wiz' ),
                'desc'         => '',
                'std'          => 'content',
                'type'         => 'radio',
                'section'      => 'blog',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'excerpt',
                        'label' => __( 'Excerpt', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'content',
                        'label' => __( 'Content', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'blog_meta_settings',
                'label'        => __( 'Blog Meta Settings', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'checkbox',
                'section'      => 'blog',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'sticky',
                        'label' => __( 'Sticky Meta', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'author',
                        'label' => __( 'Author Meta', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'date',
                        'label' => __( 'Date Meta', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'categories',
                        'label' => __( 'Categories Meta', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'comments',
                        'label' => __( 'Comments Meta', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'tags',
                        'label' => __( 'Tags Meta', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'post_display_post_formats',
                'label'        => __( 'Display Featured Image &amp; Post Formats', 'wiz' ),
                'desc'         => '',
                'std'          => 'yes',
                'type'         => 'radio',
                'section'      => 'single_post',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'yes',
                        'label' => __( 'Yes', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'no',
                        'label' => __( 'No', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'post_formats_position',
                'label'        => __( 'Featured Image &amp; Post Formats Position', 'wiz' ),
                'desc'         => '',
                'std'          => 'above-title',
                'type'         => 'select',
                'section'      => 'single_post',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'above-title',
                        'label' => __( 'Above Title', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'below-title',
                        'label' => __( 'Below Title', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'display_post_title',
                'label'        => __( 'Display Post Title on Content Area', 'wiz' ),
                'desc'         => '',
                'std'          => 'no',
                'type'         => 'select',
                'section'      => 'single_post',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'yes',
                        'label' => __( 'Yes', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'no',
                        'label' => __( 'No', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'post_title_link',
                'label'        => __( 'Title Link', 'wiz' ),
                'desc'         => '',
                'std'          => 'off',
                'type'         => 'on-off',
                'section'      => 'single_post',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'author_info',
                'label'        => __( 'Display Author Information', 'wiz' ),
                'desc'         => '',
                'std'          => 'yes',
                'type'         => 'select',
                'section'      => 'single_post',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'yes',
                        'label' => __( 'Yes', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'no',
                        'label' => __( 'No', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'posts_nav',
                'label'        => __( 'Display Posts Navigation', 'wiz' ),
                'desc'         => '',
                'std'          => 'yes',
                'type'         => 'select',
                'section'      => 'single_post',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'yes',
                        'label' => __( 'Yes', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'no',
                        'label' => __( 'No', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'related_posts',
                'label'        => __( 'Display Related Posts', 'wiz' ),
                'desc'         => '',
                'std'          => 'yes',
                'type'         => 'select',
                'section'      => 'single_post',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'yes',
                        'label' => __( 'Yes', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'no',
                        'label' => __( 'No', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'post_meta_settings',
                'label'        => __( 'Post Meta Settings', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'checkbox',
                'section'      => 'single_post',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'date',
                        'label' => __( 'Date Meta', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'author',
                        'label' => __( 'Author Meta', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'categories',
                        'label' => __( 'Categories Meta', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'tags',
                        'label' => __( 'Tags Meta', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'comments',
                        'label' => __( 'Comments Meta', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'listing_post_title_typography',
                'label'        => __( 'Listing Post Title Typography', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'typography',
                'section'      => 'archive_category',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'posts_list_separator',
                'label'        => 'Posts List Separator',
                'desc'         => '',
                'std'          => '',
                'type'         => 'border',
                'section'      => 'archive_category',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'archive_layout',
                'label'        => __( 'Archive/Category Layout', 'wiz' ),
                'desc'         => '',
                'std'          => 'large',
                'type'         => 'select',
                'section'      => 'archive_category',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'grid',
                        'label' => __( 'Grid', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'classic',
                        'label' => __( 'Classic', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'large',
                        'label' => __( 'Large', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'large-modern',
                        'label' => __( 'Large Modern', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'rightleft-image',
                        'label' => __( 'Right/Left Image', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'medium',
                        'label' => __( 'Medium', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'postformat',
                        'label' => __( 'Post Format', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'archive_display_format',
                'label'        => __( 'Archive Display Format', 'wiz' ),
                'desc'         => '',
                'std'          => 'content',
                'type'         => 'radio',
                'section'      => 'archive_category',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'excerpt',
                        'label' => __( 'Excerpt', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'content',
                        'label' => __( 'Content', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'category_page_settings',
                'label'        => __( 'Category Page Settings', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'checkbox',
                'section'      => 'archive_category',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'category_desc',
                        'label' => __( 'Category Description', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'category_rss',
                        'label' => __( 'RSS Icon', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'tag_page_settings',
                'label'        => __( 'Tag Page Settings', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'checkbox',
                'section'      => 'archive_category',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'tag_desc',
                        'label' => __( 'Tag Description', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'tag_rss',
                        'label' => __( 'RSS Icon', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'author_page_settings',
                'label'        => __( 'Author Page Settings', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'checkbox',
                'section'      => 'archive_category',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'author_bio',
                        'label' => __( 'Author Bio', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'author_rss',
                        'label' => __( 'RSS Icon', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'archive_meta_settings',
                'label'        => __( 'Archive Meta settings', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'checkbox',
                'section'      => 'archive_category',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'sticky',
                        'label' => __( 'Sticky Meta', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'author',
                        'label' => __( 'Author Meta', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'date',
                        'label' => __( 'Date Meta', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'categories',
                        'label' => __( 'Categories Meta', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'comments',
                        'label' => __( 'Comments Meta', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'tags',
                        'label' => __( 'Tags Meta', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'posts_comment',
                'label'        => __( 'Allow comments on posts', 'wiz' ),
                'desc'         => '',
                'std'          => 'yes',
                'type'         => 'radio',
                'section'      => 'comments',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'yes',
                        'label' => __( 'Yes', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'no',
                        'label' => __( 'No', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'pages_comment',
                'label'        => __( 'Allow comments on pages', 'wiz' ),
                'desc'         => '',
                'std'          => 'no',
                'type'         => 'radio',
                'section'      => 'comments',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'yes',
                        'label' => __( 'Yes', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'no',
                        'label' => __( 'No', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'fb_details',
                'label'        => __( 'FaceBook comments settings', 'wiz' ),
                'desc'         => __( 'FaceBook comments settings', 'wiz' ),
                'std'          => '',
                'type'         => 'textblock',
                'section'      => 'comments',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'title-block',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'fb_comments',
                'label'        => __( 'Enable Facebook Comments', 'wiz' ),
                'desc'         => __( 'You should enable "Include JavaScript SDK" on "Advanced" section.', 'wiz' ),
                'std'          => 'no',
                'type'         => 'radio',
                'section'      => 'comments',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'yes',
                        'label' => __( 'Yes', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'no',
                        'label' => __( 'No', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'fb_app_id',
                'label'        => __( 'Comments Application ID', 'wiz' ),
                'desc'         => __( 'Specify a Facebook app id as the administrator (all administrators of the app will be able to moderate comments).', 'wiz' ),
                'std'          => '',
                'type'         => 'text',
                'section'      => 'comments',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'fb_comments:is(yes)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'fb_width',
                'label'        => __( 'Width', 'wiz' ),
                'desc'         => __( 'the width of the plugin in pixels. Minimum recommended width: 400px.', 'wiz' ),
                'std'          => array( 100, '%' ),
                'type'         => 'measurement',
                'section'      => 'comments',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'fb_comments:is(yes)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'fb_colorscheme',
                'label'        => __( 'Colors Sheme', 'wiz' ),
                'desc'         => __( 'The color scheme for the plugin. Options: \'light\', \'dark\'', 'wiz' ),
                'std'          => 'light',
                'type'         => 'radio',
                'section'      => 'comments',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'fb_comments:is(yes)',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'light',
                        'label' => __( 'Light', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'dark',
                        'label' => __( 'Dark', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'fb_lang',
                'label'        => __( 'Language', 'wiz' ),
                'desc'         => '',
                'std'          => 'en_US',
                'type'         => 'text',
                'section'      => 'comments',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'fb_comments:is(yes)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'fb_comments_num',
                'label'        => __( 'Number of Comments', 'wiz' ),
                'desc'         => __( 'The number of comments to show by default. Default: 10 Minimum: 1.', 'wiz' ),
                'std'          => '10',
                'type'         => 'text',
                'section'      => 'comments',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'fb_comments:is(yes)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'fb_order_by',
                'label'        => __( 'Comments Order', 'wiz' ),
                'desc'         => __( 'The order to use when displaying comments. Options: \'social\', \'reverse_time\', \'time\'. Default: \'social\'', 'wiz' ),
                'std'          => 'social',
                'type'         => 'radio',
                'section'      => 'comments',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'fb_comments:is(yes)',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'social',
                        'label' => __( 'Social', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'reverse_time',
                        'label' => __( 'Reverse Time', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'time',
                        'label' => __( 'Time', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'search_layout',
                'label'        => __( 'Search Results Layout', 'wiz' ),
                'desc'         => '',
                'std'          => 'large',
                'type'         => 'select',
                'section'      => 'search_page',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'grid',
                        'label' => __( 'Grid', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'classic',
                        'label' => __( 'Classic', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'large',
                        'label' => __( 'Large', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'medium',
                        'label' => __( 'Medium', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'postformat',
                        'label' => __( 'Post Format', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'search_sidebar',
                'label'        => __( 'Search Page Sidebar', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'sidebar-select',
                'section'      => 'search_page',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'search_sidebar_position',
                'label'        => __( 'Search Sidebar Position', 'wiz' ),
                'desc'         => '',
                'std'          => 'right',
                'type'         => 'select',
                'section'      => 'search_page',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'right',
                        'label' => __( 'Right', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'left',
                        'label' => __( 'Left', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'search_display_format',
                'label'        => __( 'Search Display Format', 'wiz' ),
                'desc'         => '',
                'std'          => 'content',
                'type'         => 'radio',
                'section'      => 'search_page',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'excerpt',
                        'label' => __( 'Excerpt', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'content',
                        'label' => __( 'Content', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'search_meta_settings',
                'label'        => __( 'Search Meta Settings', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'checkbox',
                'section'      => 'search_page',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'sticky',
                        'label' => __( 'Sticky Meta', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'author',
                        'label' => __( 'Author Meta', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'date',
                        'label' => __( 'Date Meta', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'categories',
                        'label' => __( 'Categories Meta', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'comments',
                        'label' => __( 'Comments Meta', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'tags',
                        'label' => __( 'Tags Meta', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'accordion_portfolio_brand_start',
                'label'        => __( 'Portfolio Branding', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_start',
                'section'      => 'portfolio',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'title-block',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'portfolio_menu_name',
                'label'        => __( 'Dashboard Menu Name', 'wiz' ),
                'desc'         => __( 'Change dashboard menu name. Default is <i>Portfolio</i>', 'wiz' ),
                'std'          => 'Portfolio',
                'type'         => 'text',
                'section'      => 'portfolio',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'portfolio_url_slug',
                'label'        => __( 'Portfolio URL Slug', 'wiz' ),
                'desc'         => __( 'After Changing it you need to save your permalink settings again so it takes effect by navigating to Settings -> Permalinks and click on Save Changes button.<br>Ex. http://domain.com/<b style="font-size:115%;">SLUG</b>/your-project-name/', 'wiz' ),
                'std'          => 'leap-portfolio-project',
                'type'         => 'text',
                'section'      => 'portfolio',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'portfolio_category_slug',
                'label'        => __( 'Portfolio Category Slug', 'wiz' ),
                'desc'         => __( 'After Changing it you need to save your permalink settings again so it takes effect by navigating to Settings -> Permalinks and click on Save Changes button.<br>Ex. http://domain.com/<b style="font-size:115%;">CATEGORY-SLUG</b>/your-project-name/', 'wiz' ),
                'std'          => 'leap-portfolio-category',
                'type'         => 'text',
                'section'      => 'portfolio',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'portfolio_tag_slug',
                'label'        => __( 'Portfolio Tag Slug', 'wiz' ),
                'desc'         => __( 'After Changing it you need to save your permalink settings again so it takes effect by navigating to Settings -> Permalinks and click on Save Changes button.<br>Ex. http://domain.com/<b style="font-size:115%;">TAG-SLUG</b>/your-project-name/', 'wiz' ),
                'std'          => 'leap-portfolio-tag',
                'type'         => 'text',
                'section'      => 'portfolio',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'portfolio_fields',
                'label'        => __( 'Portfolio Fields Generator', 'wiz' ),
                'desc'         => '',
                'std'          => array(
                    array(
                        'title'    => __( 'URL', 'wiz' ),
                        'id'       => 'project_link',
                        'type'     => 'leap_link',
                        'options'  => '',
                        'position' => 'right'
                    ),
                    array(
                        'title'    => __( 'Date', 'wiz' ),
                        'id'       => 'leap_project_date',
                        'type'     => 'text',
                        'options'  => '',
                        'position' => 'right'
                    ),
                    array(
                        'title'    => __( 'Client', 'wiz' ),
                        'id'       => 'leap_project_client',
                        'type'     => 'text',
                        'options'  => '',
                        'position' => 'right'
                    ),
                    array(
                        'title'    => __( 'Copyright', 'wiz' ),
                        'id'       => 'leap_project_copyright',
                        'type'     => 'text',
                        'options'  => '',
                        'position' => 'right'
                    ),
                    array(
                        'title'    => __( 'Video', 'wiz' ),
                        'id'       => 'leap_project_video_code',
                        'type'     => 'textarea-simple',
                        'options'  => '',
                        'position' => 'bottom'
                    ),
                ),
                'type'         => 'list-item',
                'section'      => 'portfolio',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'settings'     => array(
                    array(
                        'id'           => 'id',
                        'label'        => __( 'Unique ID', 'wiz' ),
                        'desc'         => '',
                        'std'          => '',
                        'type'         => 'text',
                        'rows'         => '',
                        'post_type'    => '',
                        'taxonomy'     => '',
                        'min_max_step' => '',
                        'class'        => '',
                        'condition'    => '',
                        'operator'     => 'and'
                    ),
                    array(
                        'id'           => 'type',
                        'label'        => __( 'Field Type', 'wiz' ),
                        'desc'         => '',
                        'std'          => '',
                        'type'         => 'select',
                        'rows'         => '',
                        'post_type'    => '',
                        'taxonomy'     => '',
                        'min_max_step' => '',
                        'class'        => '',
                        'condition'    => '',
                        'operator'     => 'and',
                        'choices'      => array(
                            array(
                                'value' => 'text',
                                'label' => __( 'Text Field', 'wiz' ),
                                'src'   => ''
                            ),
                            array(
                                'value' => 'textarea-simple',
                                'label' => __( 'Text Area', 'wiz' ),
                                'src'   => ''
                            ),
                            array(
                                'value' => 'radio',
                                'label' => __( 'Radio', 'wiz' ),
                                'src'   => ''
                            ),
                            array(
                                'value' => 'select',
                                'label' => __( 'Dropdown', 'wiz' ),
                                'src'   => ''
                            ),
                            array(
                                'value' => 'date-picker',
                                'label' => __( 'Date', 'wiz' ),
                                'src'   => ''
                            ),
                            array(
                                'value' => 'leap_link',
                                'label' => __( 'Link', 'wiz' ),
                                'src'   => ''
                            )
                        )
                    ),
                    array(
                        'id'           => 'options',
                        'label'        => __( 'Options', 'wiz' ),
                        'desc'         => '',
                        'std'          => '',
                        'type'         => 'textarea-simple',
                        'rows'         => '',
                        'post_type'    => '',
                        'taxonomy'     => '',
                        'min_max_step' => '',
                        'class'        => '',
                        'condition'    => '',
                        'operator'     => 'and'
                    ),
                    array(
                        'id'           => 'position',
                        'label'        => __( 'Position', 'wiz' ),
                        'desc'         => '',
                        'std'          => '',
                        'type'         => 'select',
                        'rows'         => '',
                        'post_type'    => '',
                        'taxonomy'     => '',
                        'min_max_step' => '',
                        'class'        => '',
                        'condition'    => '',
                        'operator'     => 'and',
                        'choices'      => array(
                            array(
                                'value' => 'right',
                                'label' => __( 'Right', 'wiz' ),
                                'src'   => ''
                            ),
                            array(
                                'value' => 'bottom',
                                'label' => __( 'Bottom', 'wiz' ),
                                'src'   => ''
                            )
                        )
                    )
                )
            ),
            array(
                'id'           => 'accordion_portfolio_brand_end',
                'label'        => __( 'Portfolio Branding End', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_end',
                'section'      => 'portfolio',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'title-block',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'accordion_portfolio_options',
                'label'        => __( 'Portfolio Options', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_start',
                'section'      => 'portfolio',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'title-block',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'portfolio_category_page_settings',
                'label'        => __( 'Category Page Settings', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'checkbox',
                'section'      => 'portfolio',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'portfolio_category_desc',
                        'label' => __( 'Category Description', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'portfolio_category_image',
                        'label' => __( 'Category Image', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'portfolio_category_rss',
                        'label' => __( 'RSS Icon', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'related_porjects',
                'label'        => __( 'Display Related Porjects', 'wiz' ),
                'desc'         => '',
                'std'          => 'yes',
                'type'         => 'select',
                'section'      => 'portfolio',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'yes',
                        'label' => __( 'Yes', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'no',
                        'label' => __( 'No', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'portfolio_as_catalog',
                'label'        => __( 'Display Portfolio as a Catalog', 'wiz' ),
                'desc'         => '',
                'std'          => 'off',
                'type'         => 'on-off',
                'section'      => 'portfolio',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'catalog_columns',
                'label'        => __( 'Catalog columns', 'wiz' ),
                'desc'         => '',
                'std'          => '3',
                'type'         => 'select',
                'section'      => 'portfolio',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'portfolio_as_catalog:is(on)',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => '1',
                        'label' => __( '1', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => '2',
                        'label' => __( '2', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => '3',
                        'label' => __( '3', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => '4',
                        'label' => __( '4', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'portfolio_archive_layout',
                'label'        => __( 'Portfolio Category Layout', 'wiz' ),
                'desc'         => '',
                'std'          => '1col',
                'type'         => 'select',
                'section'      => 'portfolio',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'grid',
                        'label' => __( 'Grid', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => '1col',
                        'label' => __( 'One Column', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => '2col',
                        'label' => __( 'Two Column', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => '3col',
                        'label' => __( 'Three Column', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => '4col',
                        'label' => __( 'Four Column', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'portfolio_archive_display_format',
                'label'        => __( 'Portfolio Archive Display Format', 'wiz' ),
                'desc'         => '',
                'std'          => 'content',
                'type'         => 'radio',
                'section'      => 'portfolio',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'excerpt',
                        'label' => __( 'Excerpt', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'content',
                        'label' => __( 'Content', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'accordion_portfolio_options_end',
                'label'        => __( 'Portfolio Options End', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_accordion_end',
                'section'      => 'portfolio',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'title-block',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'social_links',
                'label'        => __( 'Social Media Links', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'list-item',
                'section'      => 'social_media',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'settings'     => array(
                    array(
                        'id'           => 'media_network',
                        'label'        => __( 'Choose Media Network', 'wiz' ),
                        'desc'         => '',
                        'std'          => '',
                        'type'         => 'select',
                        'rows'         => '',
                        'post_type'    => '',
                        'taxonomy'     => '',
                        'min_max_step' => '',
                        'class'        => '',
                        'condition'    => '',
                        'operator'     => 'and',
                        'choices'      => array(
                            array(
                                'value' => 'rss',
                                'label' => __( 'RSS', 'wiz' ),
                                'src'   => ''
                            ),
                            array(
                                'value' => 'facebook',
                                'label' => __( 'Facebook', 'wiz' ),
                                'src'   => ''
                            ),
                            array(
                                'value' => 'twitter',
                                'label' => __( 'Twitter', 'wiz' ),
                                'src'   => ''
                            ),
                            array(
                                'value' => 'instagram',
                                'label' => __( 'Instagram', 'wiz' ),
                                'src'   => ''
                            ),
                            array(
                                'value' => 'linkedin',
                                'label' => __( 'LinkedIn', 'wiz' ),
                                'src'   => ''
                            ),
                            array(
                                'value' => 'googleplus',
                                'label' => __( 'Google+', 'wiz' ),
                                'src'   => ''
                            ),
                            array(
                                'value' => 'pinterest',
                                'label' => __( 'Pinterest', 'wiz' ),
                                'src'   => ''
                            ),
                            array(
                                'value' => 'flickr',
                                'label' => __( 'Flickr', 'wiz' ),
                                'src'   => ''
                            ),
                            array(
                                'value' => 'vimeo',
                                'label' => __( 'Vimeo', 'wiz' ),
                                'src'   => ''
                            ),
                            array(
                                'value' => 'youtube',
                                'label' => __( 'YouTube', 'wiz' ),
                                'src'   => ''
                            ),
                            array(
                                'value' => 'tumblr',
                                'label' => __( 'Tumblr', 'wiz' ),
                                'src'   => ''
                            ),
                            array(
                                'value' => 'dribble',
                                'label' => __( 'Dribbble', 'wiz' ),
                                'src'   => ''
                            ),
                            array(
                                'value' => 'digg',
                                'label' => __( 'Digg', 'wiz' ),
                                'src'   => ''
                            ),
                            array(
                                'value' => 'vk',
                                'label' => __( 'Vkontakte', 'wiz' ),
                                'src'   => ''
                            )
                        )
                    ),
                    array(
                        'id'           => 'media_network_url',
                        'label'        => __( 'URL', 'wiz' ),
                        'desc'         => '',
                        'std'          => '',
                        'type'         => 'text',
                        'rows'         => '',
                        'post_type'    => '',
                        'taxonomy'     => '',
                        'min_max_step' => '',
                        'class'        => '',
                        'condition'    => '',
                        'operator'     => 'and'
                    )
                )
            ),
            array(
                'id'           => 'share_buttons',
                'label'        => __( 'Social Share Buttons', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'list-item',
                'section'      => 'social_media',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'settings'     => array(
                    array(
                        'id'           => 'share_button',
                        'label'        => __( 'Choose Share Button', 'wiz' ),
                        'desc'         => '',
                        'std'          => '',
                        'type'         => 'select',
                        'rows'         => '',
                        'post_type'    => '',
                        'taxonomy'     => '',
                        'min_max_step' => '',
                        'class'        => '',
                        'condition'    => '',
                        'operator'     => 'and',
                        'choices'      => array(
                            array(
                                'value' => 'facebook',
                                'label' => __( 'FaceBook', 'wiz' ),
                                'src'   => ''
                            ),
                            array(
                                'value' => 'twitter',
                                'label' => __( 'Twitter', 'wiz' ),
                                'src'   => ''
                            ),
                            array(
                                'value' => 'linkedin',
                                'label' => __( 'Linkedin', 'wiz' ),
                                'src'   => ''
                            ),
                            array(
                                'value' => 'reddit',
                                'label' => __( 'Reddit', 'wiz' ),
                                'src'   => ''
                            ),
                            array(
                                'value' => 'tumblr',
                                'label' => __( 'Tumblr', 'wiz' ),
                                'src'   => ''
                            ),
                            array(
                                'value' => 'google-plus',
                                'label' => __( 'Google+', 'wiz' ),
                                'src'   => ''
                            ),
                            array(
                                'value' => 'pinterest',
                                'label' => __( 'Pinterest', 'wiz' ),
                                'src'   => ''
                            ),
                            array(
                                'value' => 'digg',
                                'label' => __( 'Digg', 'wiz' ),
                                'src'   => ''
                            ),
                            array(
                                'value' => 'stumbleupon',
                                'label' => __( 'Stumbleupon', 'wiz' ),
                                'src'   => ''
                            ),
                            array(
                                'value' => 'delicious',
                                'label' => __( 'Delicious', 'wiz' ),
                                'src'   => ''
                            ),
                            array(
                                'value' => 'vk',
                                'label' => __( 'Vkontakte', 'wiz' ),
                                'src'   => ''
                            ),
                            array(
                                'value' => 'email',
                                'label' => __( 'E-mail', 'wiz' ),
                                'src'   => ''
                            )
                        )
                    )
                )
            ),
            array(
                'id'           => 'show_share_buttons',
                'label'        => __( 'Show share buttons on', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'checkbox',
                'section'      => 'social_media',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'blog',
                        'label' => __( 'Blog', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'archive',
                        'label' => __( 'Archives', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'post',
                        'label' => __( 'Post', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'page',
                        'label' => __( 'Page', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'facebook_og',
                'label'        => __( 'Add Open Graph meta data', 'wiz' ),
                'desc'         => __( 'Add Open Graph meta data to your site\'s head section.', 'wiz' ),
                'std'          => 'on',
                'type'         => 'on-off',
                'section'      => 'seo',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'twitter_card',
                'label'        => __( 'Add Twitter card meta data', 'wiz' ),
                'desc'         => __( 'Add Twitter card meta data to your site\'s head section.', 'wiz' ),
                'std'          => 'on',
                'type'         => 'on-off',
                'section'      => 'seo',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'enable_seo',
                'label'        => __( 'Enable SEO For', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'checkbox',
                'section'      => 'seo',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'post',
                        'label' => __( 'Post', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'page',
                        'label' => __( 'Page', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'leap-portfolio',
                        'label' => __( 'Portfolio', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'product',
                        'label' => __( 'WooCommerce', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'seo_description',
                'label'        => __( 'Default Meta Description', 'wiz' ),
                'desc'         => __( 'Will be used by default for home page and pages that don\'t have SEO description', 'wiz' ),
                'std'          => '',
                'type'         => 'textarea-simple',
                'section'      => 'seo',
                'rows'         => '7',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'seo_keywords',
                'label'        => __( 'Default Meta Keywords', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'textarea-simple',
                'section'      => 'seo',
                'rows'         => '7',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'google_analytics_ua_code',
                'label'        => __( 'Google Analytics UA Code', 'wiz' ),
                'desc'         => __( 'Enter your UA code', 'wiz' ),
                'std'          => '',
                'type'         => 'text',
                'section'      => 'webmaster_tools',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'google_webmaster_tools',
                'label'        => __( 'Google Webmaster Tools', 'wiz' ),
                'desc'         => __( 'Enter the verify meta value.', 'wiz' ),
                'std'          => '',
                'type'         => 'text',
                'section'      => 'webmaster_tools',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'bing_webmaster_tools',
                'label'        => __( 'Bing Webmaster Tools', 'wiz' ),
                'desc'         => __( 'Enter the verify meta value.', 'wiz' ),
                'std'          => '',
                'type'         => 'text',
                'section'      => 'webmaster_tools',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'alexa_verification_id',
                'label'        => __( 'Alexa Verification ID', 'wiz' ),
                'desc'         => __( 'Enter the verify meta value.', 'wiz' ),
                'std'          => '',
                'type'         => 'text',
                'section'      => 'webmaster_tools',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'favicon',
                'label'        => __( 'Favicon', 'wiz' ),
                'desc'         => __( 'You can put url of an ico image that will represent your website\'s favicon (16px x 16px).', 'wiz' ),
                'std'          => '',
                'type'         => 'upload',
                'section'      => 'favicons',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'iphone_icon',
                'label'        => __( 'Apple iPhone Icon Upload', 'wiz' ),
                'desc'         => __( 'Icon for Apple iPhone (57px x 57px).', 'wiz' ),
                'std'          => '',
                'type'         => 'upload',
                'section'      => 'favicons',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'iphone_icon_retina',
                'label'        => __( 'Apple iPhone Retina Icon Upload', 'wiz' ),
                'desc'         => __( 'Icon for Apple iPhone Retina Version (114px x 114px).', 'wiz' ),
                'std'          => '',
                'type'         => 'upload',
                'section'      => 'favicons',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'ipad_icon',
                'label'        => __( 'Apple iPad Icon Upload', 'wiz' ),
                'desc'         => __( 'Icon for Apple iPhone (72px x 72px).', 'wiz' ),
                'std'          => '',
                'type'         => 'upload',
                'section'      => 'favicons',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'ipad_icon_retina',
                'label'        => __( 'Apple iPad Retina Icon Upload', 'wiz' ),
                'desc'         => __( 'Icon for Apple iPad Retina Version (144px x 144px).', 'wiz' ),
                'std'          => '',
                'type'         => 'upload',
                'section'      => 'favicons',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'desc_top_banner',
                'label'        => __( 'Top Banner Settings', 'wiz' ),
                'desc'         => __( 'Top Banner Settings', 'wiz' ),
                'std'          => '',
                'type'         => 'textblock',
                'section'      => 'banners',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'title-block',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'top_banner',
                'label'        => __( 'Top Banner', 'wiz' ),
                'desc'         => __( 'Displayed on header 6 only.', 'wiz' ),
                'std'          => 'none',
                'type'         => 'select',
                'section'      => 'banners',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'none',
                        'label' => __( 'None', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'image',
                        'label' => __( 'Image', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'code',
                        'label' => __( 'Custom Code', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'top_banner_image',
                'label'        => __( 'Image', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'upload',
                'section'      => 'banners',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'top_banner:is(image)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'top_banner_link',
                'label'        => __( 'Link', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'text',
                'section'      => 'banners',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'top_banner:is(image)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'top_banner_target',
                'label'        => __( 'Open Link In a new Tab', 'wiz' ),
                'desc'         => '',
                'std'          => 'on',
                'type'         => 'on-off',
                'section'      => 'banners',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'top_banner:is(image)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'top_banner_code',
                'label'        => __( 'Code', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'textarea-simple',
                'section'      => 'banners',
                'rows'         => '7',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'top_banner:is(code)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'desc_above_post_banner',
                'label'        => __( 'Above Post Banner Settings', 'wiz' ),
                'desc'         => __( 'Above Post Banner Settings', 'wiz' ),
                'std'          => '',
                'type'         => 'textblock',
                'section'      => 'banners',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'title-block',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'above_post_banner',
                'label'        => __( 'Above Post Banner', 'wiz' ),
                'desc'         => '',
                'std'          => 'none',
                'type'         => 'select',
                'section'      => 'banners',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'none',
                        'label' => __( 'None', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'image',
                        'label' => __( 'Image', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'code',
                        'label' => __( 'Custom Code', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'above_post_banner_image',
                'label'        => __( 'Image', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'upload',
                'section'      => 'banners',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'above_post_banner:is(image)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'above_post_banner_link',
                'label'        => __( 'Link', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'text',
                'section'      => 'banners',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'above_post_banner:is(image)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'above_post_banner_target',
                'label'        => __( 'Open Link In a new Tab', 'wiz' ),
                'desc'         => '',
                'std'          => 'on',
                'type'         => 'on-off',
                'section'      => 'banners',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'above_post_banner:is(image)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'above_post_banner_code',
                'label'        => __( 'Code', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'textarea-simple',
                'section'      => 'banners',
                'rows'         => '7',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'above_post_banner:is(code)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'desc_below_post_banner',
                'label'        => __( 'Below Post Banner Settings', 'wiz' ),
                'desc'         => __( 'Below Post Banner Settings', 'wiz' ),
                'std'          => '',
                'type'         => 'textblock',
                'section'      => 'banners',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'title-block',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'below_post_banner',
                'label'        => __( 'Below Post Banner', 'wiz' ),
                'desc'         => '',
                'std'          => 'none',
                'type'         => 'select',
                'section'      => 'banners',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'none',
                        'label' => __( 'None', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'image',
                        'label' => __( 'Image', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'code',
                        'label' => __( 'Custom Code', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'below_post_banner_image',
                'label'        => __( 'Image', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'upload',
                'section'      => 'banners',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'below_post_banner:is(image)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'below_post_banner_link',
                'label'        => __( 'Link', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'text',
                'section'      => 'banners',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'below_post_banner:is(image)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'below_post_banner_target',
                'label'        => __( 'Open Link In a new Tab', 'wiz' ),
                'desc'         => '',
                'std'          => 'on',
                'type'         => 'on-off',
                'section'      => 'banners',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'below_post_banner:is(image)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'below_post_banner_code',
                'label'        => __( 'Code', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'textarea-simple',
                'section'      => 'banners',
                'rows'         => '7',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'below_post_banner:is(code)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'desc_contact_form',
                'label'        => __( 'Contact Form Settings', 'wiz' ),
                'desc'         => __( 'Contact Form Settings', 'wiz' ),
                'std'          => '',
                'type'         => 'textblock',
                'section'      => 'contacts',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'title-block',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'contact_email_to',
                'label'        => __( 'Recipient Email Address', 'wiz' ),
                'desc'         => __( 'Enter the email address the form will be sent to.', 'wiz' ),
                'std'          => '',
                'type'         => 'text',
                'section'      => 'contacts',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'enable_recaptcha',
                'label'        => __( 'Enable reCAPTCHA', 'wiz' ),
                'desc'         => '',
                'std'          => 'off',
                'type'         => 'on-off',
                'section'      => 'contacts',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'recaptcha_site_key',
                'label'        => __( 'reCAPTCHA Site key', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'text',
                'section'      => 'contacts',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'enable_recaptcha:is(on)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'recaptcha_secret_key',
                'label'        => __( 'reCAPTCHA Secret key', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'text',
                'section'      => 'contacts',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'enable_recaptcha:is(on)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'recaptcha_theme',
                'label'        => __( 'reCAPTCHA Theme', 'wiz' ),
                'desc'         => '',
                'std'          => 'light',
                'type'         => 'radio',
                'section'      => 'contacts',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'enable_recaptcha:is(on)',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'light',
                        'label' => __( 'Light', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'dark',
                        'label' => __( 'Dark', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'desc_contact_info',
                'label'        => __( 'Contact Information', 'wiz' ),
                'desc'         => __( 'Contact Information', 'wiz' ),
                'std'          => '',
                'type'         => 'textblock',
                'section'      => 'contacts',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'title-block',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'contact_address',
                'label'        => __( 'Address', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'text',
                'section'      => 'contacts',
                'rows'         => '3',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'contact_phone',
                'label'        => __( 'Phone', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'text',
                'section'      => 'contacts',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'contact_mobile',
                'label'        => __( 'Mobile', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'text',
                'section'      => 'contacts',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'contact_fax',
                'label'        => __( 'Fax', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'text',
                'section'      => 'contacts',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'contact_email',
                'label'        => __( 'Email', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'text',
                'section'      => 'contacts',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'remove-border',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'desc_google_map',
                'label'        => __( 'Google Map Settings', 'wiz' ),
                'desc'         => __( 'Google Map Settings', 'wiz' ),
                'std'          => '',
                'type'         => 'textblock',
                'section'      => 'contacts',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'title-block',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'display_google_map',
                'label'        => __( 'Display Google Map', 'wiz' ),
                'desc'         => '',
                'std'          => 'off',
                'type'         => 'on-off',
                'section'      => 'contacts',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'map_api_key',
                'label'        => __( 'Google Map API Key', 'wiz' ),
                'desc'         => __( 'Click <a href="https://developers.google.com/maps/documentation/javascript/get-api-key#get-an-api-key" target="_blank">here</a> to get your API key', 'wiz' ),
                'std'          => '',
                'type'         => 'text',
                'section'      => 'contacts',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'display_google_map:is(on)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'google_map_type',
                'label'        => __( 'Google Map Type', 'wiz' ),
                'desc'         => __( 'Select the type of google map to show on the contact page.', 'wiz' ),
                'std'          => 'roadmap',
                'type'         => 'select',
                'section'      => 'contacts',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'display_google_map:is(on)',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'roadmap',
                        'label' => __( 'Roadmap', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'satellite',
                        'label' => __( 'Satellite', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'hybrid',
                        'label' => __( 'Hybrid', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'terrain',
                        'label' => __( 'Terrain', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'google_map_width',
                'label'        => __( 'Google Map Width', 'wiz' ),
                'desc'         => '',
                'std'          => array( '100', '%' ),
                'type'         => 'measurement',
                'section'      => 'contacts',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'display_google_map:is(on)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'google_map_height',
                'label'        => __( 'Google Map Height', 'wiz' ),
                'desc'         => '',
                'std'          => array( '350', 'px' ),
                'type'         => 'measurement',
                'section'      => 'contacts',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'display_google_map:is(on)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'google_map_zoom',
                'label'        => __( 'Google Map Zoom', 'wiz' ),
                'desc'         => __( 'Higher number will be more zoomed in.', 'wiz' ),
                'std'          => '13',
                'type'         => 'text',
                'section'      => 'contacts',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'display_google_map:is(on)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'google_map_lat',
                'label'        => __( 'Google Map Latitude', 'wiz' ),
                'desc'         => __( '<a href="http://universimmedia.pagesperso-orange.fr/geo/loc.htm" target="_blank">Here is a tool</a> where you can find Latitude &amp; Longitude of your location', 'wiz' ),
                'std'          => '',
                'type'         => 'text',
                'section'      => 'contacts',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'display_google_map:is(on)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'google_map_lng',
                'label'        => __( 'Google Map Longitude', 'wiz' ),
                'desc'         => __( '<a href="http://universimmedia.pagesperso-orange.fr/geo/loc.htm" target="_blank">Here is a tool</a> where you can find Latitude &amp; Longitude of your location', 'wiz' ),
                'std'          => '',
                'type'         => 'text',
                'section'      => 'contacts',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'display_google_map:is(on)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'info_box_title',
                'label'        => __( 'Info Box Title', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'text',
                'section'      => 'contacts',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'display_google_map:is(on)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'info_box_content',
                'label'        => __( 'Info Box Content', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'textarea-simple',
                'section'      => 'contacts',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'display_google_map:is(on)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'global_css',
                'label'        => __( 'Global CSS', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'css',
                'section'      => 'custom_css',
                'rows'         => '7',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'tablets_css',
                'label'        => __( 'Tablets CSS', 'wiz' ),
                'desc'         => __( 'Width from 768px to 985px', 'wiz' ),
                'std'          => '',
                'type'         => 'css',
                'section'      => 'custom_css',
                'rows'         => '7',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'wide_phones_css',
                'label'        => __( 'Wide Phones CSS', 'wiz' ),
                'desc'         => __( 'Width from 480px to 767px', 'wiz' ),
                'std'          => '',
                'type'         => 'css',
                'section'      => 'custom_css',
                'rows'         => '7',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'phones_css',
                'label'        => __( 'Phones CSS', 'wiz' ),
                'desc'         => __( 'Width from 320px to 479px', 'wiz' ),
                'std'          => '',
                'type'         => 'css',
                'section'      => 'custom_css',
                'rows'         => '7',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'excerpt_length',
                'label'        => __( 'Excerpt Length(number of words)', 'wiz' ),
                'desc'         => __( 'By default, excerpt length is set to 55 words.', 'wiz' ),
                'std'          => '',
                'type'         => 'text',
                'section'      => 'advanced',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'excerpt_more_string',
                'label'        => __( 'Excerpt more string', 'wiz' ),
                'desc'         => __( 'By default, excerpt more string at the end is set to \'[...]\'.', 'wiz' ),
                'std'          => '',
                'type'         => 'text',
                'section'      => 'advanced',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'remove_generator',
                'label'        => __( 'Remove generator', 'wiz' ),
                'desc'         => '',
                'std'          => 'no',
                'type'         => 'radio',
                'section'      => 'advanced',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'yes',
                        'label' => __( 'Yes', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'no',
                        'label' => __( 'No', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'wp_login_logo',
                'label'        => __( 'Wordpress Login page Logo', 'wiz' ),
                'desc'         => __( 'The size of your logo should be no bigger than 80 x 80 pixels.', 'wiz' ),
                'std'          => '',
                'type'         => 'upload',
                'section'      => 'advanced',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'wp_login_logo_link',
                'label'        => __( 'Wordpress Login page Logo Link', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'text',
                'section'      => 'advanced',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'wp_login_logo_link_title',
                'label'        => __( 'Wordpress Login page Logo Title', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'text',
                'section'      => 'advanced',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'change_admin_footer_text',
                'label'        => __( 'Change Admin Footer Text', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'textarea-simple',
                'section'      => 'advanced',
                'rows'         => '5',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'update_your_theme_from_the_wordpress_dashboard',
                'label'        => __( 'Update your Theme from the WordPress Dashboard', 'wiz' ),
                'desc'         => __( 'If you want to get update notifications for Wiz theme and if you want to be able to update your theme from your WordPress backend you need to enter your Themeforest account name as well as your Themeforest Secret API Key below.', 'wiz' ),
                'std'          => '',
                'type'         => 'textblock',
                'section'      => 'theme_updates',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'tf_username',
                'label'        => __( 'ThemeForest Username', 'wiz' ),
                'desc'         => __( 'Enter the Name of the User you used to purchase this theme', 'wiz' ),
                'std'          => '',
                'type'         => 'text',
                'section'      => 'theme_updates',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'tf_api',
                'label'        => __( 'ThemeForest Secret API Key', 'wiz' ),
                'desc'         => __( 'Enter the API Key of your Account here.', 'wiz' ),
                'std'          => '',
                'type'         => 'text',
                'section'      => 'theme_updates',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'tf_pc',
                'label'        => __( 'ThemeForest Purchase Code', 'wiz' ),
                'desc'         => __( 'Enter the Purchase Code.', 'wiz' ),
                'std'          => '',
                'type'         => 'text',
                'section'      => 'theme_updates',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'export_data_text',
                'label'        => __( 'Export Theme Options', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_export_data',
                'section'      => 'export_import',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'import_data_text',
                'label'        => __( 'Import Theme Options', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_import_data',
                'section'      => 'export_import',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'system_info',
                'label'        => '',
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_system_info',
                'section'      => 'system_info',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'remove-border',
                'condition'    => '',
                'operator'     => 'and'
            )
        )
    );

    /* allow settings to be filtered before saving */
    $custom_settings = apply_filters( ot_settings_id() . '_args', $custom_settings );

    /* settings are not the same update the DB */
    if ( $saved_settings !== $custom_settings ) {
        update_option( ot_settings_id(), $custom_settings );
    }

    /* Lets OptionTree know the UI Builder is being overridden */
    global $ot_has_custom_theme_options;
    $ot_has_custom_theme_options = true;
}
