<?php

if ( !defined( 'ABSPATH' ) ) {
    die( 'No direct access allowed' );
}

require get_template_directory() . '/functions/tax-meta/tax-meta-class.php';

if ( is_admin() ) {
    /*
     * prefix of meta keys, optional
     */
    $prefix = 'leap_';
    /*
     * configure your meta box
     */
    $args   = array(
        'id'             => 'portfolio_category_meta_box', // meta box id, unique per meta box
        'title'          => 'Portfolio Category Meta Box', // meta box title
        'pages'          => array( 'leap-portfolio-category' ), // taxonomy name, accept categories, post_tag and custom taxonomies
        'context'        => 'normal', // where the meta box appear: normal (default), advanced, side; optional
        'fields'         => array(), // list of meta fields (can be added by field arrays)
        'local_images'   => true, // Use local or hosted images (meta box images for add/remove)
        'use_with_theme' => get_template_directory_uri() . '/functions/tax-meta' //change path if used with theme set to true, false for a plugin or anything else for a custom path(default false).
    );


    /*
     * Initiate your meta box
     */
    $portfolio_meta = new Tax_Meta_Class( $args );

    $portfolio_meta->addImage( $prefix . 'portfolio_cat_image', array( 'name' => __( 'Category Image', 'wiz' ) ) );

    $portfolio_meta->Finish();
}

