<?php

if ( !defined( 'ABSPATH' ) ) {
    die( 'No direct access allowed' );
}

/**
 * Enqueue styles for front-end.
 */
function leap_safely_add_stylesheets() {

    // Load WordPress′s dashicons
    wp_enqueue_style( 'dashicons' );

    if ( is_rtl() ) {
        // https://github.com/AbdullahDiaa/Bootstrap-RTL
        // Bootstrap CSS 
        wp_enqueue_style( 'bootstrap', get_template_directory_uri() . '/vendor/bootstrap/rtl/css/bootstrap-arabic.css', array( 'leap-font-awesome' ), THEME_VERSION, 'all' );
    } else {
        // Bootstrap CSS 
        wp_enqueue_style( 'bootstrap', get_template_directory_uri() . '/vendor/bootstrap/ltr/css/bootstrap.min.css', array( 'leap-font-awesome' ), THEME_VERSION, 'all' );
    }

    // jQuery UI Core 
    wp_enqueue_style( 'jquery-ui-core', get_template_directory_uri() . '/vendor/jquery/jquery-ui/jquery.ui.core.min.css', array(), THEME_VERSION, 'all' );

    // jQuery Accordion 
    wp_enqueue_style( 'jquery-ui-accordion', get_template_directory_uri() . '/vendor/jquery/jquery-ui/jquery.ui.accordion.min.css', array( 'jquery-ui-core' ), THEME_VERSION, 'all' );

    // Font Awesome 
    wp_enqueue_style( 'leap-font-awesome', get_template_directory_uri() . '/vendor/font-awesome/css/font-awesome.min.css', array(), THEME_VERSION, 'screen' );

    // Load Superfish CSS 
    wp_enqueue_style( 'superfish', get_template_directory_uri() . '/vendor/superfish/css/superfish.css', array(), THEME_VERSION, 'all' );

    // Load slicknav CSS 
    wp_enqueue_style( 'slicknav', get_template_directory_uri() . '/vendor/slicknav/slicknav.min.css', array(), THEME_VERSION, 'all' );

    // Load isotope CSS 
    wp_enqueue_style( 'leap-masonry', get_template_directory_uri() . '/vendor/masonry/masonry.css', array(), THEME_VERSION, 'all' );

    // prettyPhoto
    wp_enqueue_style( 'jquery-prettyPhoto', get_template_directory_uri() . '/vendor/prettyPhoto/css/prettyPhoto.css', array(), THEME_VERSION, 'screen' );

    // flexslider
    wp_enqueue_style( 'flexslider', get_template_directory_uri() . '/vendor/flexslider/flexslider.css', array(), THEME_VERSION, 'screen' );

    // Load CarouFredSel
    wp_enqueue_style( 'jquery-carouFredSel', get_template_directory_uri() . '/vendor/caroufredsel/jquery.carouFredSel.css', array(), THEME_VERSION, 'all' );

    // animate.css
    wp_enqueue_style( 'leap-animate', get_template_directory_uri() . '/vendor/animation/animate.min.css', array(), THEME_VERSION, 'all' );
    
    // Load custom-scrollbar
    wp_enqueue_style( 'jquery-custom-scrollbar', get_template_directory_uri() . '/vendor/custom-scrollbar/jquery.mCustomScrollbar.min.css', array(), THEME_VERSION, 'all' );

    // Load theme CSS 
    wp_enqueue_style( 'leap-theme', get_template_directory_uri() . '/css/theme.css', array(), THEME_VERSION, 'all' );

    // Load woocommerce CSS 
    if ( class_exists( 'woocommerce' ) ) {
        wp_enqueue_style( 'leap-woocommerce', get_template_directory_uri() . '/css/woocommerce.css', array( 'leap-theme' ), THEME_VERSION, 'all' );
        if ( is_rtl() ) {
            wp_enqueue_style( 'leap-woocommerce-rtl', get_template_directory_uri() . '/css/woocommerce-rtl.css', array( 'leap-theme', 'leap-woocommerce' ), THEME_VERSION, 'all' );
        }
    }

    // Style RTL
    if ( is_rtl() ) {
        wp_enqueue_style( 'style-rtl', get_template_directory_uri() . '/css/style-rtl.css', array(), THEME_VERSION, 'all' );
    }

    // Style responsive

    if ( ot_get_option( 'disable_responsive', 'no' ) == 'no' ) {
        wp_enqueue_style( 'style-responsive', get_template_directory_uri() . '/css/style-responsive.css', array(), THEME_VERSION, 'all' );
    }

    // Retina
    wp_enqueue_style( 'leap-retina', get_template_directory_uri() . '/css/retina.css', array(), THEME_VERSION, 'all' );

    // Style CSS 
    wp_enqueue_style( 'style', get_stylesheet_uri(), array(), THEME_VERSION, 'all' );
}

add_action( 'wp_enqueue_scripts', 'leap_safely_add_stylesheets', 10 );

/**
 * Enqueue scripts for front-end.
 */
function leap_safely_add_scripts() {

    wp_enqueue_script( 'jquery' );
    wp_enqueue_script( 'jquery-ui-core' );
    wp_enqueue_script( 'jquery-ui-accordion' );
    wp_enqueue_script( 'jquery-effects-drop' );
    wp_enqueue_script( 'jquery-ui-tabs' );
    wp_enqueue_script( 'hoverIntent' );
    if ( is_singular() ) {
        wp_enqueue_script( 'comment-reply' );
    }


    // Bootstrap 
    if ( is_rtl() ) {
        wp_enqueue_script( 'bootstrap', get_template_directory_uri() . '/vendor/bootstrap/rtl/js/bootstrap-arabic.js', array(), THEME_VERSION, true );
    } else {
        wp_enqueue_script( 'bootstrap', get_template_directory_uri() . '/vendor/bootstrap/ltr/js/bootstrap.min.js', array(), THEME_VERSION, true );
    }

    // Load Cycle JS 
    wp_enqueue_script( 'jquery-cycle-lite', get_template_directory_uri() . '/vendor/jquery.cycle.lite.js', array( 'jquery' ), THEME_VERSION, true );

    // Load CarouFredSel
    wp_enqueue_script( 'jquery-carouFredSel', get_template_directory_uri() . '/vendor/caroufredsel/jquery.carouFredSel-6.2.1-packed.js', array( 'jquery' ), THEME_VERSION, true );

    // Load Superfish JS 
    wp_enqueue_script( 'superfish', get_template_directory_uri() . '/vendor/superfish/js/superfish.js', array( 'jquery', 'hoverIntent' ), THEME_VERSION, true );

    // Load slicknav JS 
    wp_enqueue_script( 'slicknav', get_template_directory_uri() . '/vendor/slicknav/jquery.slicknav.min.js', array( 'jquery' ), THEME_VERSION, true );

    // prettyPhoto
    wp_enqueue_script( 'jquery-prettyPhoto', get_template_directory_uri() . '/vendor/prettyPhoto/js/jquery.prettyPhoto.js', array( 'jquery' ), THEME_VERSION, true );

    // flexslider
    wp_enqueue_script( 'flexslider', get_template_directory_uri() . '/vendor/flexslider/jquery.flexslider.js', array( 'jquery' ), THEME_VERSION, true );

    // Load isotope JS 
    wp_enqueue_script( 'leap-masonry', get_template_directory_uri() . '/vendor/masonry/jquery.masonry.min.js', array( 'jquery' ), THEME_VERSION, true );

    // Load wow JS 
    wp_enqueue_script( 'wow', get_template_directory_uri() . '/vendor/animation/wow.min.js', array(), THEME_VERSION, true );

    // parallax
    wp_enqueue_script( 'jquery.parallax', get_template_directory_uri() . '/vendor/parallax/jquery.parallax.js', array(), THEME_VERSION, true );
    
    // SmoothScroll
    $smooth_scroll = (ot_get_option( 'smooth_scroll', 'on' ) == 'on') && (get_option( 'ultimate_smooth_scroll', 'disable' ) == 'disable') ? true : false ;
    if ( $smooth_scroll ) {
        wp_enqueue_script( 'jquery.SmoothScroll', get_template_directory_uri() . '/vendor/SmoothScroll/SmoothScroll.min.js', array(), THEME_VERSION, true );
    }
    
    // stickUp
    wp_enqueue_script( 'jquery.stickUp', get_template_directory_uri() . '/vendor/stickUp/stickUp.min.js', array(), THEME_VERSION, true );
    
    // custom-scrollbar
    wp_enqueue_script( 'jquery.custom-scrollbar', get_template_directory_uri() . '/vendor/custom-scrollbar/jquery.mCustomScrollbar.concat.min.js', array(), THEME_VERSION, true );
    
    // jquery.easing
    wp_enqueue_script( 'jquery.easing', get_template_directory_uri() . '/vendor/jquery/jquery.easing.min.js', array(), THEME_VERSION, true );

    if ( is_page_template( 'page-contact-template.php' ) ) {
        // Google maps
        $leap_map_api_key = apply_filters( 'leap_map_api_key', ot_get_option( 'map_api_key', '' ) );
        wp_enqueue_script( 'google.maps', '//maps.googleapis.com/maps/api/js?key='. $leap_map_api_key, array(), THEME_VERSION, false );
        wp_enqueue_script( 'recaptcha', '//www.google.com/recaptcha/api.js', array(), THEME_VERSION, true );
    }


    wp_register_script( 'theme', get_template_directory_uri() . '/js/theme.js', array(), THEME_VERSION, true );
    // Pass vars to js file

    $mobile_menu_width = ot_get_option( 'mobile_menu_width', array( '767', 'px' ) );
    if ( empty( $mobile_menu_width[ '0' ] ) ) {
        $mobile_menu_width[ '0' ] = 767;
    }

    $theme_vars = array(
        'logo_url'          => ot_get_option( 'logo', '' ),
        'sticky_logo_url'   => ot_get_option( 'sticky_logo', '' ),
        'mobile_menu_width' => $mobile_menu_width[ '0' ],
        'smooth_scroll'     => $smooth_scroll
    );
    wp_localize_script( 'theme', 'theme_vars', $theme_vars );
    wp_enqueue_script( 'theme' );
}

add_action( 'wp_enqueue_scripts', 'leap_safely_add_scripts', 10 );

function leap_html5shiv() {
    echo '<!--[if lt IE 9]><script src="' . get_template_directory_uri() . '/js/html5shiv-printshiv.min.js"></script><![endif]-->';
}

add_action( 'wp_head', 'leap_html5shiv', 10 );
