<?php

if ( !defined( 'ABSPATH' ) ) {
    die( 'No direct access allowed' );
}

if ( function_exists( 'register_sidebar' ) ) {

    /**
     * Register All sidebars
     */
    function leap_register_sidebars() {

        $sidebars = ot_get_option( 'sidebar_generator', array() );
        foreach ( $sidebars as $key => $sidebar ) {
            register_sidebar( array(
                'id'            => 'leap-sidebar-' . $key,
                'name'          => $sidebar[ 'title' ],
                'class'         => $sidebar[ 'class' ],
                'before_widget' => '<div id="%1$s" class="widget %2$s">',
                'after_widget'  => '</div>',
                'before_title'  => '<div class="widget-head"><div class="title"><h4 class="widget-title">',
                'after_title'   => '</h4></div></div>',
            ) );
        }

        if ( ot_get_option( 'enable_header_sidebar', 'off' ) == 'on' ) {
            for ( $i = 1; $i <= 4; $i++ ) {
                register_sidebar( array(
                    'id'            => 'header' . $i,
                    'name'          => 'Header Column ' . $i,
                    'before_widget' => '<div id="%1$s" class="widget %2$s">',
                    'after_widget'  => '</div>',
                    'before_title'  => '<div class="widget-head"><div class="title"><h4 class="widget-title">',
                    'after_title'   => '</h4></div></div>',
                ) );
            }
        }

        if ( ot_get_option( 'enable_main_top_sidebar', 'off' ) == 'on' ) {
            for ( $i = 1; $i <= 4; $i++ ) {
                register_sidebar( array(
                    'id'            => 'main-top' . $i,
                    'name'          => 'Main Top Column ' . $i,
                    'before_widget' => '<div id="%1$s" class="widget %2$s">',
                    'after_widget'  => '</div>',
                    'before_title'  => '<div class="widget-head"><div class="title"><h4 class="widget-title">',
                    'after_title'   => '</h4></div></div>',
                ) );
            }
        }

        if ( ot_get_option( 'enable_header_full_width_sidebar', 'off' ) == 'on' ) {
            for ( $i = 1; $i <= 4; $i++ ) {
                register_sidebar( array(
                    'id'            => 'header-full-width' . $i,
                    'name'          => 'Header Full Width Column ' . $i,
                    'before_widget' => '<div id="%1$s" class="widget %2$s">',
                    'after_widget'  => '</div>',
                    'before_title'  => '<div class="widget-head"><div class="title"><h4 class="widget-title">',
                    'after_title'   => '</h4></div></div>',
                ) );
            }
        }

        if ( ot_get_option( 'enable_main_content_top_sidebar', 'off' ) == 'on' ) {
            for ( $i = 1; $i <= 4; $i++ ) {
                register_sidebar( array(
                    'id'            => 'main-content-top' . $i,
                    'name'          => 'Main Content Top Column ' . $i,
                    'before_widget' => '<div id="%1$s" class="widget %2$s">',
                    'after_widget'  => '</div>',
                    'before_title'  => '<div class="widget-head"><div class="title"><h4 class="widget-title">',
                    'after_title'   => '</h4></div></div>',
                ) );
            }
        }

        if ( ot_get_option( 'enable_content_top_sidebar', 'off' ) == 'on' ) {
            for ( $i = 1; $i <= 4; $i++ ) {
                register_sidebar( array(
                    'id'            => 'content-top' . $i,
                    'name'          => 'Content Top Column ' . $i,
                    'before_widget' => '<div id="%1$s" class="widget %2$s">',
                    'after_widget'  => '</div>',
                    'before_title'  => '<div class="widget-head"><div class="title"><h4 class="widget-title">',
                    'after_title'   => '</h4></div></div>',
                ) );
            }
        }

        if ( ot_get_option( 'enable_content_bottom_sidebar', 'off' ) == 'on' ) {
            for ( $i = 1; $i <= 4; $i++ ) {
                register_sidebar( array(
                    'id'            => 'content-bottom' . $i,
                    'name'          => 'Content bottom Column ' . $i,
                    'before_widget' => '<div id="%1$s" class="widget %2$s">',
                    'after_widget'  => '</div>',
                    'before_title'  => '<div class="widget-head"><div class="title"><h4 class="widget-title">',
                    'after_title'   => '</h4></div></div>',
                ) );
            }
        }

        register_sidebar( array(
            'id'            => 'sidebar-1',
            'name'          => 'Main Sidebar',
            'description'   => '',
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<div class="widget-head"><div class="title"><h4 class="widget-title">',
            'after_title'   => '</h4></div></div>',
        ) );

        if ( class_exists( 'woocommerce' ) ) {
            register_sidebar( array(
                'id'            => 'shop-sidebar',
                'name'          => 'Shop Sidebar',
                'description'   => '',
                'before_widget' => '<div id="%1$s" class="widget %2$s">',
                'after_widget'  => '</div>',
                'before_title'  => '<div class="widget-head"><div class="title"><h4 class="widget-title">',
                'after_title'   => '</h4></div></div>',
            ) );
        }
        
        if ( class_exists( 'bbPress' ) ) {
            register_sidebar( array(
                'id'            => 'bbpress-sidebar',
                'name'          => 'bbPress Sidebar',
                'description'   => '',
                'before_widget' => '<div id="%1$s" class="widget %2$s">',
                'after_widget'  => '</div>',
                'before_title'  => '<div class="widget-head"><div class="title"><h4 class="widget-title">',
                'after_title'   => '</h4></div></div>',
            ) );
        }

        if ( ot_get_option( 'enable_main_content_bottom_sidebar', 'off' ) == 'on' ) {
            for ( $i = 1; $i <= 4; $i++ ) {
                register_sidebar( array(
                    'id'            => 'main-content-bottom' . $i,
                    'name'          => 'Main Content Bottom Column ' . $i,
                    'before_widget' => '<div id="%1$s" class="widget %2$s">',
                    'after_widget'  => '</div>',
                    'before_title'  => '<div class="widget-head"><div class="title"><h4 class="widget-title">',
                    'after_title'   => '</h4></div></div>',
                ) );
            }
        }

        if ( ot_get_option( 'enable_footer_full_width_sidebar', 'off' ) == 'on' ) {
            for ( $i = 1; $i <= 4; $i++ ) {
                register_sidebar( array(
                    'id'            => 'footer-full-width' . $i,
                    'name'          => 'Footer Full Width Column ' . $i,
                    'before_widget' => '<div id="%1$s" class="widget %2$s">',
                    'after_widget'  => '</div>',
                    'before_title'  => '<div class="widget-head"><div class="title"><h4 class="widget-title">',
                    'after_title'   => '</h4></div></div>',
                ) );
            }
        }

        if ( ot_get_option( 'enable_main_bottom_sidebar', 'off' ) == 'on' ) {
            for ( $i = 1; $i <= 4; $i++ ) {
                register_sidebar( array(
                    'id'            => 'main-bottom' . $i,
                    'name'          => 'Main Bottom Column ' . $i,
                    'before_widget' => '<div id="%1$s" class="widget %2$s">',
                    'after_widget'  => '</div>',
                    'before_title'  => '<div class="widget-head"><div class="title"><h4 class="widget-title">',
                    'after_title'   => '</h4></div></div>',
                ) );
            }
        }

        if ( ot_get_option( 'enable_footer_sidebar', 'off' ) == 'on' ) {
            for ( $i = 1; $i <= 4; $i++ ) {
                register_sidebar( array(
                    'id'            => 'footer' . $i,
                    'name'          => 'Footer Column ' . $i,
                    'before_widget' => '<div id="%1$s" class="widget %2$s">',
                    'after_widget'  => '</div>',
                    'before_title'  => '<div class="widget-head"><div class="title"><h4 class="widget-title">',
                    'after_title'   => '</h4></div></div>',
                ) );
            }
        }
    }

    add_action( 'widgets_init', 'leap_register_sidebars', 10 );
}

/**
 * Adds a box to the main column on the Post and Page edit screens.
 */
function leap_sidebar_replacement_meta_box() {

    $screens = array( 'post', 'page', 'product' );

    foreach ( $screens as $screen ) {

        add_meta_box(
        'leap-sidebar-generator', 'Leap Sidebar Replacement', 'leap_sidebar_replacement_meta_box_details', $screen
        );
    }
}

add_action( 'add_meta_boxes', 'leap_sidebar_replacement_meta_box', 10 );

/**
 * Prints the sidebar replacement meta box
 * 
 * @param WP_Post $post The object for the current post/page.
 */
function leap_sidebar_replacement_meta_box_details( $post ) {

    // Add an nonce field so we can check for it later.
    wp_nonce_field( 'leap_sidebar_meta_box_details', 'leap_sidebar_meta_box_details_nonce' );

    global $wp_registered_sidebars;
    $wp_sidebars      = $wp_registered_sidebars;
    $default_sidebars = array();
    $leap_sidebars    = array();

    foreach ( $wp_sidebars as $wp_sidebar ) {
        if ( substr( $wp_sidebar[ 'id' ], 0, 13 ) === 'leap-sidebar-' ) {
            //$leap_sidebars[] = $wp_sidebar;		// Display only generator sidebars
        } else {
            $default_sidebars[] = $wp_sidebar;
        }
    }
    // Display all sidebars
    $leap_sidebars = $wp_sidebars;

    //array_unshift($default_sidebars, array('id' => '', 'name' => 'Choose Sidebar'));

    /*
     * Use get_post_meta() to retrieve an existing value
     * from the database and use the value for the form.
     */
    $leap_selected_sidebar = get_post_meta( $post->ID, 'leap_selected_sidebar', true );
    if ( !is_array( $leap_selected_sidebar ) ) {
        $tmp                        = $leap_selected_sidebar;
        $leap_selected_sidebar      = array();
        $leap_selected_sidebar[ 0 ] = $tmp;
    }
    $leap_selected_sidebar_replacement = get_post_meta( $post->ID, 'leap_selected_sidebar_replacement', true );
    if ( !is_array( $leap_selected_sidebar_replacement ) ) {
        $tmp                                    = $leap_selected_sidebar_replacement;
        $leap_selected_sidebar_replacement      = array();
        $leap_selected_sidebar_replacement[ 0 ] = $tmp;
    }

    echo '<ul>';
    for ( $i = 0; $i < count( $default_sidebars ); $i++ ) {
        echo '<li>';
        echo 'Replace ';
        echo '<select name="leap_selected_sidebar[' . $i . ']">';
        if ( !isset( $leap_selected_sidebar[ $i ] ) ) {
            $leap_selected_sidebar[ $i ] = '';
        }
        $empty_selected = '';
        if ( $leap_selected_sidebar[ $i ] == "" ) {
            $empty_selected = "selected";
        }
        echo '<option value="" ' . $empty_selected . '>Select Sidebar</option>';
        foreach ( $default_sidebars as $default_sidebar ) {
            if ( $leap_selected_sidebar[ $i ] == $default_sidebar[ 'id' ] ) {
                echo '<option value="' . $default_sidebar[ 'id' ] . '" selected>' . $default_sidebar[ 'name' ] . '</option>';
            } else {
                echo '<option value="' . $default_sidebar[ 'id' ] . '">' . $default_sidebar[ 'name' ] . '</option>';
            }
        }
        echo '</select>';
        echo ' with ';
        echo '<select name="leap_selected_sidebar_replacement[' . $i . ']">';
        if ( !isset( $leap_selected_sidebar_replacement[ $i ] ) ) {
            $leap_selected_sidebar_replacement[ $i ] = '';
        }
        $empty_selected = '';
        if ( $leap_selected_sidebar_replacement[ $i ] == "" ) {
            $empty_selected = "selected";
        }
        echo '<option value="" ' . $empty_selected . '>Select Sidebar</option>';
        foreach ( $leap_sidebars as $leap_sidebar ) {
            if ( $leap_selected_sidebar_replacement[ $i ] == $leap_sidebar[ 'id' ] ) {
                echo '<option value="' . $leap_sidebar[ 'id' ] . '" selected>' . $leap_sidebar[ 'name' ] . '</option>';
            } else {
                echo '<option value="' . $leap_sidebar[ 'id' ] . '">' . $leap_sidebar[ 'name' ] . '</option>';
            }
        }
        echo '</select>';
        echo '</li>';
    }
    echo '</ul>';
}

/**
 * When the post is saved, saves our sidebar replacement
 *
 * @param int $post_id The ID of the post being saved.
 */
function leap_sidebar_replacement_save_postdata( $post_id ) {

    /*
     * We need to verify this came from the our screen and with proper authorization,
     * because save_post can be triggered at other times.
     */

    // Check if our nonce is set.
    if ( !isset( $_POST[ 'leap_sidebar_meta_box_details_nonce' ] ) )
        return $post_id;

    $nonce = $_POST[ 'leap_sidebar_meta_box_details_nonce' ];

    // Verify that the nonce is valid.
    if ( !wp_verify_nonce( $nonce, 'leap_sidebar_meta_box_details' ) )
        return $post_id;

    // If this is an autosave, our form has not been submitted, so we don't want to do anything.
    if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE )
        return $post_id;

    // Check the user's permissions.
    if ( 'page' == $_POST[ 'post_type' ] ) {

        if ( !current_user_can( 'edit_page', $post_id ) )
            return $post_id;
    } else {

        if ( !current_user_can( 'edit_post', $post_id ) )
            return $post_id;
    }

    /* OK, its safe for us to save the data now. */

    // Sanitize user input.

    $leap_selected_sidebar             = array_map( 'sanitize_text_field', $_POST[ 'leap_selected_sidebar' ] );
    $leap_selected_sidebar_replacement = array_map( 'sanitize_text_field', $_POST[ 'leap_selected_sidebar_replacement' ] );

    // Update the meta field in the database.
    update_post_meta( $post_id, 'leap_selected_sidebar', $leap_selected_sidebar );
    update_post_meta( $post_id, 'leap_selected_sidebar_replacement', $leap_selected_sidebar_replacement );
}

add_action( 'save_post', 'leap_sidebar_replacement_save_postdata', 10 );

/**
 * Alter sidebar params to add our custom styles
 * http://wordpress.stackexchange.com/a/74744/28527
 * @param array $params
 * @return array
 */
function leap_alter_sidebar_params( $params ) {
    global $wp_registered_widgets;

    $settings_getter = $wp_registered_widgets[ $params[ 0 ][ 'widget_id' ] ][ 'callback' ][ 0 ];
    $settings        = $settings_getter->get_settings();
    $settings        = $settings[ $params[ 1 ][ 'number' ] ];

    //pr($settings);

    if ( isset( $settings[ 'title' ] ) && empty( $settings[ 'title' ] ) ) {
        $params[ 0 ][ 'before_widget' ] .= '<div class="widget-content">';
        $params[ 0 ][ 'after_widget' ] = '</div>' . $params[ 0 ][ 'after_widget' ];
    } elseif ( isset( $settings[ 'rev_slider_title' ] ) && empty( $settings[ 'rev_slider_title' ] ) ) {
        $params[ 0 ][ 'before_widget' ] .= '<div class="widget-content">';
        $params[ 0 ][ 'after_widget' ] = '</div>' . $params[ 0 ][ 'after_widget' ];
    } elseif ( isset( $settings[ 'title' ] ) && !empty( $settings[ 'title' ] ) ) {
        if ( !empty( $settings[ "widget-icon" ] ) ) {
            $params[ 0 ][ 'before_title' ] .= '<i class="' . $settings[ "widget-icon" ] . '"></i> ';
        }
        $params[ 0 ][ 'after_title' ] .= '<div class="widget-content">';
        $params[ 0 ][ 'after_widget' ] = '</div>' . $params[ 0 ][ 'after_widget' ];
    } else {
        $params[ 0 ][ 'before_widget' ] .= '<div class="widget-content">';
        $params[ 0 ][ 'after_widget' ] = '</div>' . $params[ 0 ][ 'after_widget' ];
    }

    return $params;
}

add_filter( 'dynamic_sidebar_params', 'leap_alter_sidebar_params', 10, 1 );

/**
 * Remove empty titles
 * http://wordpress.stackexchange.com/a/124500/28527
 * @param string $title
 * @param array $instance
 * @param string $base
 * @return string
 */
function leap_remove_empty_title( $title, $instance = array(), $base = '' ) {
    if ( $base == 'categories' || $base == 'tag_cloud' ) {
        if ( trim( $instance[ 'title' ] ) == '' )
            return '';
    }
    return $title;
}

add_filter( 'widget_title', 'leap_remove_empty_title', 10, 3 );


if ( !function_exists( 'leap_sidebar_position' ) ) {

    /**
     * Get sidebar position for the current page
     * 
     * @return string Sidebar Position
     */
    function leap_sidebar_position() {
        $page_id = leap_get_current_page_id();

        $sidebar_position = ot_get_option( 'sidebar_position', 'right' );

        if ( is_page() ) {
            $pages_sidebar          = ot_get_option( 'pages_sidebar', '' );
            $pages_sidebar_position = ot_get_option( 'pages_sidebar_position', 'right' );
            if ( $pages_sidebar ) {
                $sidebar_position = $pages_sidebar_position;
            }
        } elseif ( is_tax( 'leap-portfolio-category' ) || is_tax( 'leap-portfolio-tag' ) ) {
            $portfolio_archive_sidebar          = ot_get_option( 'portfolio_archive_sidebar', '' );
            $portfolio_archive_sidebar_position = ot_get_option( 'portfolio_archive_sidebar_position', 'right' );
            if ( $portfolio_archive_sidebar ) {
                $sidebar_position = $portfolio_archive_sidebar_position;
            }
        } elseif ( is_singular( 'leap-portfolio' ) ) {
            $portfolio_posts_sidebar          = ot_get_option( 'portfolio_posts_sidebar', '' );
            $portfolio_posts_sidebar_position = ot_get_option( 'portfolio_posts_sidebar_position', 'right' );
            if ( $portfolio_posts_sidebar ) {
                $sidebar_position = $portfolio_posts_sidebar_position;
            }
        } elseif ( class_exists( 'Woocommerce' ) && (is_shop() || is_product_category() || is_product_tag()) ) {
            $woocommerce_archive_sidebar          = ot_get_option( 'woocommerce_archive_sidebar', '' );
            $woocommerce_archive_sidebar_position = ot_get_option( 'woocommerce_archive_sidebar_position', 'right' );
            if ( $woocommerce_archive_sidebar ) {
                $sidebar_position = $woocommerce_archive_sidebar_position;
            }
        } elseif ( class_exists( 'Woocommerce' ) && is_product() ) {
            $woocommerce_products_sidebar          = ot_get_option( 'woocommerce_products_sidebar', '' );
            $woocommerce_products_sidebar_position = ot_get_option( 'woocommerce_products_sidebar_position', 'right' );
            if ( $woocommerce_products_sidebar ) {
                $sidebar_position = $woocommerce_products_sidebar_position;
            }
        } elseif ( is_archive() ) {
            $blog_archive_sidebar          = ot_get_option( 'blog_archive_sidebar', '' );
            $blog_archive_sidebar_position = ot_get_option( 'blog_archive_sidebar_position', 'right' );
            if ( $blog_archive_sidebar ) {
                $sidebar_position = $blog_archive_sidebar_position;
            }
            
        } elseif ( is_home()  ) {
            $blog_archive_sidebar          = ot_get_option( 'blog_archive_sidebar', '' );
            $blog_archive_sidebar_position = ot_get_option( 'blog_archive_sidebar_position', 'right' );
            if ( $blog_archive_sidebar ) {
                $sidebar_position = $blog_archive_sidebar_position;
            }
            
        }          
        
        elseif ( is_single() ) {
            $blog_posts_sidebar          = ot_get_option( 'blog_posts_sidebar', '' );
            $blog_posts_sidebar_position = ot_get_option( 'blog_posts_sidebar_position', 'right' );
            if ( $blog_posts_sidebar ) {
                $sidebar_position = $blog_posts_sidebar_position;
            }
        } elseif ( is_search() ) {
            $search_sidebar          = ot_get_option( 'search_sidebar', '' );
            $search_sidebar_position = ot_get_option( 'search_sidebar_position', 'right' );
            if ( $search_sidebar ) {
                $sidebar_position = $search_sidebar_position;
            }
        }

        $leap_sidebar_position = get_post_meta( $page_id, 'leap_sidebar_position', TRUE );
        if ( $leap_sidebar_position && ($leap_sidebar_position != 'default') ) {
            $sidebar_position = $leap_sidebar_position;
        }

        if ( class_exists( 'Woocommerce' ) && ( is_shop() || is_product_category() || is_product_tag() || is_product() ) ) {
            $page_id               = get_option( 'woocommerce_shop_page_id' );
            $leap_sidebar_position = get_post_meta( $page_id, 'leap_sidebar_position', TRUE );
            if ( $leap_sidebar_position && ($leap_sidebar_position != 'default') ) {
                $sidebar_position = $leap_sidebar_position;
            }
        }

        return $sidebar_position;
    }

}

if ( !function_exists( 'leap_override_widget_position' ) ) {

    /**
     * Override widget position if the current post has a custom widget position 
     * @param string $general
     * @param string $custom
     * @return string
     */
    function leap_override_widget_position( $general, $custom ) {
        $general_sidebar = ot_get_option( $general );
        $page_id         = leap_get_current_page_id();
        $custom_sidebar  = get_post_meta( $page_id, $custom, TRUE );

        if ( (!empty( $custom_sidebar )) && ($custom_sidebar != 'default') ) {
            $general_sidebar = $custom_sidebar;
        }
        return $general_sidebar;
    }

}

if ( !function_exists( 'leap_dynamic_sidebar' ) ) {

    /**
     *  Print sidebar markup
     * @param string $name
     */
    function leap_dynamic_sidebar( $name ) {
        $page_id = leap_get_current_page_id();

        $leap_selected_sidebar             = get_post_meta( $page_id, 'leap_selected_sidebar', true );
        $leap_selected_sidebar_replacement = get_post_meta( $page_id, 'leap_selected_sidebar_replacement', true );

        if ( is_array( $leap_selected_sidebar ) && is_array( $leap_selected_sidebar_replacement ) && !empty( $name ) ) {
            if ( in_array( $name, $leap_selected_sidebar ) ) {
                $selected_key     = array_search( $name, $leap_selected_sidebar );
                $replacement_name = $leap_selected_sidebar_replacement[ $selected_key ];
                if ( !empty( $replacement_name ) ) {
                    dynamic_sidebar( $replacement_name );
                    return;
                } else {
                    dynamic_sidebar( $name );
                    return;
                }
            } else {
                dynamic_sidebar( $name );
                return;
            }
        } else {
            dynamic_sidebar( $name );
            return;
        }
    }

}

if ( !function_exists( 'leap_get_replacement_sidebar' ) ) {

    /**
     * Get the replacement sidebar if the current page has one
     * @param string $name
     * @return string
     */
    function leap_get_replacement_sidebar( $name ) {
        if ( is_singular() || is_home() || ( class_exists( 'Woocommerce' ) && is_woocommerce() ) ) {
            $page_id = leap_get_current_page_id();

            $leap_selected_sidebar             = get_post_meta( $page_id, 'leap_selected_sidebar', true );
            $leap_selected_sidebar_replacement = get_post_meta( $page_id, 'leap_selected_sidebar_replacement', true );
            if ( is_array( $leap_selected_sidebar ) && is_array( $leap_selected_sidebar_replacement ) && !empty( $name ) ) {
                if ( in_array( $name, $leap_selected_sidebar ) ) {
                    $selected_key     = array_search( $name, $leap_selected_sidebar );
                    $replacement_name = $leap_selected_sidebar_replacement[ $selected_key ];
                    if ( !empty( $replacement_name ) ) {
                        return $replacement_name;
                    } else {
                        return $name;
                    }
                } else {
                    return $name;
                }
            } else {
                return $name;
            }
        } else {
            return $name;
        }
    }

}

if ( !function_exists( 'leap_get_main_sidebar' ) ) {

    /**
     * Display main sidebar
     */
    function leap_get_main_sidebar() {
        $replacement_sidebar       = leap_get_replacement_sidebar( 'sidebar-1' );
        $pages_sidebar             = ot_get_option( 'pages_sidebar', '' );
        $portfolio_archive_sidebar = ot_get_option( 'portfolio_archive_sidebar', '' );
        $portfolio_posts_sidebar   = ot_get_option( 'portfolio_posts_sidebar', '' );
        $blog_archive_sidebar      = ot_get_option( 'blog_archive_sidebar', '' );
        $blog_posts_sidebar        = ot_get_option( 'blog_posts_sidebar', '' );
        $search_sidebar            = ot_get_option( 'search_sidebar', '' );

        if ( is_active_sidebar( $replacement_sidebar ) && $replacement_sidebar != 'sidebar-1' ) {
            dynamic_sidebar( $replacement_sidebar );
        } elseif ( is_page() && $pages_sidebar ) {
            dynamic_sidebar( $pages_sidebar );
        } elseif ( ( is_tax( 'leap-portfolio-category' ) || is_tax( 'leap-portfolio-tag' ) ) && $portfolio_archive_sidebar ) {
            dynamic_sidebar( $portfolio_archive_sidebar );
        } elseif ( is_singular( 'leap-portfolio' ) && $portfolio_posts_sidebar ) {
            leap_dynamic_sidebar( $portfolio_posts_sidebar );
        } elseif ( is_archive() && $blog_archive_sidebar ) {
            dynamic_sidebar( $blog_archive_sidebar );
        } elseif ( is_home() && $blog_archive_sidebar ) {
            dynamic_sidebar( $blog_archive_sidebar );
        } elseif ( is_single() && $blog_posts_sidebar ) {
            leap_dynamic_sidebar( $blog_posts_sidebar );
        } elseif ( is_search() && $search_sidebar ) {
            dynamic_sidebar( $search_sidebar );
        } else {
            dynamic_sidebar( 'sidebar-1' );
        }
    }

}
	