<?php
add_action( 'wp_head', 'leap_sidebars_css', 1000 );

function leap_sidebars_css() {
    ?>
    <style type="text/css" >
    <?php
    $page_id    = leap_get_current_page_id();
    $sidebar_id = leap_get_current_sidebar_style();

    if ( !empty( $sidebar_id ) ) {
        ?>

            /***** header-sidebar  *****/


            #header-sidebar {
        <?php echo leap_get_post_background_value( 'leap_header_sidebar_background', $sidebar_id ); ?>
        <?php
        $leap_header_sidebar_top_border      = (array) leap_get_post_option_value( 'leap_header_sidebar_top_border', $sidebar_id );
        $leap_header_sidebar_top_border_unit = (!empty( $leap_header_sidebar_top_border[ 'unit' ] )) ? $leap_header_sidebar_top_border[ 'unit' ] : 'px';

        if ( !empty( $leap_header_sidebar_top_border[ 'color' ] ) ) {
            ?>
                    border-top-color: <?php echo $leap_header_sidebar_top_border[ 'color' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_header_sidebar_top_border[ 'style' ] ) ) { ?>
                    border-top-style: <?php echo $leap_header_sidebar_top_border[ 'style' ]; ?>;
        <?php } ?>
        <?php if ( isset( $leap_header_sidebar_top_border[ 'width' ] ) && strlen( $leap_header_sidebar_top_border[ 'width' ] ) > 0 ) { ?>
                    border-top-width: <?php echo $leap_header_sidebar_top_border[ 'width' ] . $leap_header_sidebar_top_border_unit; ?>;
        <?php } ?>

        <?php
        $leap_header_sidebar_bottom_border      = (array) leap_get_post_option_value( 'leap_header_sidebar_bottom_border', $sidebar_id );
        $leap_header_sidebar_bottom_border_unit = (!empty( $leap_header_sidebar_bottom_border[ 'unit' ] )) ? $leap_header_sidebar_bottom_border[ 'unit' ] : 'px';

        if ( !empty( $leap_header_sidebar_bottom_border[ 'color' ] ) ) {
            ?>
                    border-bottom-color: <?php echo $leap_header_sidebar_bottom_border[ 'color' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_header_sidebar_bottom_border[ 'style' ] ) ) { ?>
                    border-bottom-style: <?php echo $leap_header_sidebar_bottom_border[ 'style' ]; ?>;
        <?php } ?>
        <?php if ( isset( $leap_header_sidebar_bottom_border[ 'width' ] ) && strlen( $leap_header_sidebar_bottom_border[ 'width' ] ) > 0 ) { ?>
                    border-bottom-width: <?php echo $leap_header_sidebar_bottom_border[ 'width' ] . $leap_header_sidebar_bottom_border_unit; ?>;
        <?php } ?>

            }
            #header-sidebar, #header-sidebar div, #header-sidebar p, #header-sidebar li {
        <?php echo leap_get_post_typography_value( 'leap_header_sidebar_typography', $sidebar_id ); ?>
            }
            #header-sidebar .widget-title, #header-sidebar h4.widget-title {
        <?php echo leap_get_post_typography_value( 'leap_header_sidebar_widget_title_typography', $sidebar_id ); ?>
            }

            #header-sidebar .widget span.date, #header-sidebar .widget small.small, #header-sidebar .widget_recent_entries ul li span.post-date, #header-sidebar .widget.woocommerce ul li del, #header-sidebar .widget.woocommerce ul li del span.amount {
                color: <?php echo leap_get_post_option_value( 'leap_header_sidebar_meta_color', $sidebar_id ); ?>;
            }


        <?php
        $leap_header_sidebar_links_color = (array) leap_get_post_option_value( 'leap_header_sidebar_links_color', $sidebar_id );
        ?>
            #header-sidebar a {
        <?php if ( !empty( $leap_header_sidebar_links_color[ 'link' ] ) ) { ?>
                    color: <?php echo $leap_header_sidebar_links_color[ 'link' ]; ?>;
        <?php } ?>
            }
            #header-sidebar a:hover {
        <?php if ( !empty( $leap_header_sidebar_links_color[ 'hover' ] ) ) { ?>
                    color: <?php echo $leap_header_sidebar_links_color[ 'hover' ]; ?>;
        <?php } ?>
            }
            #header-sidebar .widget ul li {
        <?php
        $leap_header_sidebar_list_divider_color = leap_get_post_option_value( 'leap_header_sidebar_list_divider_color', $sidebar_id );
        if ( $leap_header_sidebar_list_divider_color ) :
            ?>
                    border-color: <?php echo $leap_header_sidebar_list_divider_color; ?>;
        <?php endif; ?>
            }


        <?php
        $leap_header_sidebar_button_color_options = (array) leap_get_post_option_value( 'leap_header_sidebar_button_color_options', $sidebar_id );
        ?>
            #header-sidebar .btn-leap, #header-sidebar .btn-leap:hover, #header-sidebar .btn-leap:focus, #header-sidebar .btn-leap.disabled, #header-sidebar .btn-leap[disabled], #header-sidebar a.btn-leap, #header-sidebar a.btn-leap:hover, #header-sidebar a.btn-leap:focus, #header-sidebar .widget a.btn-leap, #header-sidebar .widget a.btn-leap:hover, #header-sidebar .widget a.btn-leap:focus, #header-sidebar input[type="submit"], #header-sidebar input[type="reset"], #header-sidebar input[type="button"], #header-sidebar input[type="submit"]:hover, #header-sidebar input[type="reset"]:hover, #header-sidebar input[type="button"]:hover, #header-sidebar input[type="submit"]:focus, #header-sidebar input[type="reset"]:focus, #header-sidebar input[type="button"]:focus {
        <?php if ( !empty( $leap_header_sidebar_button_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_header_sidebar_button_color_options[ 'text' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_header_sidebar_button_color_options[ 'bg' ] ) ) { ?>
                    background-color: <?php echo $leap_header_sidebar_button_color_options[ 'bg' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_header_sidebar_button_color_options[ 'border' ] ) ) { ?>
                    border-color: <?php echo $leap_header_sidebar_button_color_options[ 'border' ]; ?>;
        <?php } ?>
            }
            #header-sidebar .btn-leap:hover, #header-sidebar .btn-leap:focus, #header-sidebar a.btn-leap:hover, #header-sidebar a.btn-leap:focus, #header-sidebar .widget a.btn-leap:hover, #header-sidebar .widget a.btn-leap:focus, #header-sidebar input[type="submit"]:hover, #header-sidebar input[type="reset"]:hover, #header-sidebar input[type="button"]:hover, #header-sidebar input[type="submit"]:focus, #header-sidebar input[type="reset"]:focus, #header-sidebar input[type="button"]:focus {
        <?php if ( !empty( $leap_header_sidebar_button_color_options[ 'bg-hover' ] ) ) { ?>
                    background-color: <?php echo $leap_header_sidebar_button_color_options[ 'bg-hover' ]; ?>;
        <?php } ?>
            }

            #header-sidebar .btn-leap, #header-sidebar .btn-leap:hover, #header-sidebar .btn-leap:focus, #header-sidebar .btn-leap.disabled, #header-sidebar .btn-leap[disabled], #header-sidebar a.btn-leap, #header-sidebar a.btn-leap:hover, #header-sidebar a.btn-leap:focus, #header-sidebar .widget a.btn-leap, #header-sidebar .widget a.btn-leap:hover, #header-sidebar .widget a.btn-leap:focus, #header-sidebar input[type="submit"], #header-sidebar input[type="reset"], #header-sidebar input[type="button"], #header-sidebar input[type="submit"]:hover, #header-sidebar input[type="reset"]:hover, #header-sidebar input[type="button"]:hover, #header-sidebar input[type="submit"]:focus, #header-sidebar input[type="reset"]:focus, #header-sidebar input[type="button"]:focus  {
        <?php if ( leap_get_sidebar_option_with_default( 'leap_header_sidebar_button_radius', $sidebar_id ) == 'on' ) : ?>
                    border-radius: 3px;
                    -webkit-border-radius: 3px;
        <?php endif; ?>
        <?php if ( leap_get_sidebar_option_with_default( 'leap_header_sidebar_button_radius', $sidebar_id ) == 'off' ) : ?>
                    border-radius: 0;
                    -webkit-border-radius: 0;
        <?php endif; ?>
            }

        <?php
        $leap_header_sidebar_input_color_options = (array) leap_get_post_option_value( 'leap_header_sidebar_input_color_options', $sidebar_id );
        ?>
            #header-sidebar input[type="text"], #header-sidebar input[type="text"]:focus, #header-sidebar .form-control, #header-sidebar .form-control:focus, #header-sidebar textarea, #header-sidebar textarea:focus, #header-sidebar input[type="password"], #header-sidebar input[type="password"]:focus, #header-sidebar .widget_search .input-group-addon:last-child, #header-sidebar .leap-search-form .input-group-addon:last-child, #header-sidebar input[type="email"], #header-sidebar input[type="date"], #header-sidebar input[type="number"], #header-sidebar input[type="email"]:focus, #header-sidebar input[type="date"]:focus, #header-sidebar input[type="number"]:focus
            {
        <?php if ( !empty( $leap_header_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_header_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_header_sidebar_input_color_options[ 'bg' ] ) ) { ?>
                    background-color: <?php echo $leap_header_sidebar_input_color_options[ 'bg' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_header_sidebar_input_color_options[ 'border' ] ) ) { ?>
                    border-color: <?php echo $leap_header_sidebar_input_color_options[ 'border' ]; ?>;
        <?php } ?>
            }
            #header-sidebar input:focus:invalid:focus, #header-sidebar textarea:focus:invalid:focus,#header-sidebar select:focus:invalid:focus  {
        <?php if ( !empty( $leap_header_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_header_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_header_sidebar_input_color_options[ 'bg' ] ) ) { ?>
                    background-color: <?php echo $leap_header_sidebar_input_color_options[ 'bg' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_header_sidebar_input_color_options[ 'border' ] ) ) { ?>
                    border-color: <?php echo $leap_header_sidebar_input_color_options[ 'border' ]; ?>;
        <?php } ?>
            }
            #header-sidebar .form-control::-moz-placeholder {
        <?php if ( !empty( $leap_header_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_header_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
            }
            #header-sidebar .form-control:-ms-input-placeholder {
        <?php if ( !empty( $leap_header_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_header_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
            }
            #header-sidebar .form-control::-webkit-input-placeholder {
        <?php if ( !empty( $leap_header_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_header_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
            }


        <?php
        $leap_header_sidebar_spacing      = (array) leap_get_post_option_value( 'leap_header_sidebar_spacing', $sidebar_id );
        $leap_header_sidebar_spacing_unit = (!empty( $leap_header_sidebar_spacing[ 'unit' ] )) ? $leap_header_sidebar_spacing[ 'unit' ] : 'px';
        ?>
            #header-sidebar .container-fluid, #header-sidebar > .container {
        <?php if ( isset( $leap_header_sidebar_spacing[ 'top' ] ) && strlen( $leap_header_sidebar_spacing[ 'top' ] ) > 0 ) { ?>
                    padding-top: <?php echo $leap_header_sidebar_spacing[ 'top' ] . $leap_header_sidebar_spacing_unit; ?>;
        <?php } ?>
        <?php if ( isset( $leap_header_sidebar_spacing[ 'bottom' ] ) && strlen( $leap_header_sidebar_spacing[ 'bottom' ] ) > 0 ) { ?>
                    padding-bottom: <?php echo $leap_header_sidebar_spacing[ 'bottom' ] . $leap_header_sidebar_spacing_unit; ?>;
        <?php } ?>
            }



            /***** leap_maintop_sidebar  *****/
            #main-top-sidebar {
        <?php echo leap_get_post_background_value( 'leap_maintop_sidebar_background', $sidebar_id ); ?>
        <?php
        $leap_maintop_sidebar_top_border      = (array) leap_get_post_option_value( 'leap_maintop_sidebar_top_border', $sidebar_id );
        $leap_maintop_sidebar_top_border_unit = (!empty( $leap_maintop_sidebar_top_border[ 'unit' ] )) ? $leap_maintop_sidebar_top_border[ 'unit' ] : 'px';

        if ( !empty( $leap_maintop_sidebar_top_border[ 'color' ] ) ) {
            ?>
                    border-top-color: <?php echo $leap_maintop_sidebar_top_border[ 'color' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_maintop_sidebar_top_border[ 'style' ] ) ) { ?>
                    border-top-style: <?php echo $leap_maintop_sidebar_top_border[ 'style' ]; ?>;
        <?php } ?>
        <?php if ( isset( $leap_maintop_sidebar_top_border[ 'width' ] ) && strlen( $leap_maintop_sidebar_top_border[ 'width' ] ) > 0 ) { ?>
                    border-top-width: <?php echo $leap_maintop_sidebar_top_border[ 'width' ] . $leap_maintop_sidebar_top_border_unit; ?>;
        <?php } ?>

        <?php
        $leap_maintop_sidebar_bottom_border      = (array) leap_get_post_option_value( 'leap_maintop_sidebar_bottom_border', $sidebar_id );
        $leap_maintop_sidebar_bottom_border_unit = (!empty( $leap_maintop_sidebar_bottom_border[ 'unit' ] )) ? $leap_maintop_sidebar_bottom_border[ 'unit' ] : 'px';

        if ( !empty( $leap_maintop_sidebar_bottom_border[ 'color' ] ) ) {
            ?>
                    border-bottom-color: <?php echo $leap_maintop_sidebar_bottom_border[ 'color' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_maintop_sidebar_bottom_border[ 'style' ] ) ) { ?>
                    border-bottom-style: <?php echo $leap_maintop_sidebar_bottom_border[ 'style' ]; ?>;
        <?php } ?>
        <?php if ( isset( $leap_maintop_sidebar_bottom_border[ 'width' ] ) && strlen( $leap_maintop_sidebar_bottom_border[ 'width' ] ) > 0 ) { ?>
                    border-bottom-width: <?php echo $leap_maintop_sidebar_bottom_border[ 'width' ] . $leap_maintop_sidebar_bottom_border_unit; ?>;
        <?php } ?>

            }

            #main-top-sidebar, #main-top-sidebar div, #main-top-sidebar p, #main-top-sidebar li {
        <?php echo leap_get_post_typography_value( 'leap_maintop_sidebar_typography', $sidebar_id ); ?>
            }
            #main-top-sidebar .widget-title, #main-top-sidebar h4.widget-title {
        <?php echo leap_get_post_typography_value( 'leap_maintop_sidebar_widget_title_typography', $sidebar_id ); ?>
            }
            #main-top-sidebar .widget span.date, #main-top-sidebar .widget small.small, #main-top-sidebar .widget_recent_entries ul li span.post-date, #main-top-sidebar .widget.woocommerce ul li del, #main-top-sidebar .widget.woocommerce ul li del span.amount {
                color: <?php echo leap_get_post_option_value( 'leap_maintop_sidebar_meta_color', $sidebar_id ); ?>;
            }

        <?php
        $leap_maintop_sidebar_links_color = (array) leap_get_post_option_value( 'leap_maintop_sidebar_links_color', $sidebar_id );
        ?>
            #main-top-sidebar a {
        <?php if ( !empty( $leap_maintop_sidebar_links_color[ 'link' ] ) ) { ?>
                    color: <?php echo $leap_maintop_sidebar_links_color[ 'link' ]; ?>;
        <?php } ?>
            }
            #main-top-sidebar a:hover {
        <?php if ( !empty( $leap_maintop_sidebar_links_color[ 'hover' ] ) ) { ?>
                    color: <?php echo $leap_maintop_sidebar_links_color[ 'hover' ]; ?>;
        <?php } ?>
            }
            #main-top-sidebar .widget ul li {
        <?php
        $leap_maintop_sidebar_list_divider_color = leap_get_post_option_value( 'leap_maintop_sidebar_list_divider_color', $sidebar_id );
        if ( $leap_maintop_sidebar_list_divider_color ) :
            ?>
                    border-color: <?php echo $leap_maintop_sidebar_list_divider_color; ?>;
        <?php endif; ?>
            }

        <?php
        $leap_maintop_sidebar_button_color_options = (array) leap_get_post_option_value( 'leap_maintop_sidebar_button_color_options', $sidebar_id );
        ?>
            #main-top-sidebar .btn-leap, #main-top-sidebar .btn-leap:hover, #main-top-sidebar .btn-leap:focus, #main-top-sidebar .btn-leap.disabled, #main-top-sidebar .btn-leap[disabled], #main-top-sidebar a.btn-leap, #main-top-sidebar a.btn-leap:hover, #main-top-sidebar a.btn-leap:focus, #main-top-sidebar .widget a.btn-leap, #main-top-sidebar .widget a.btn-leap:hover, #main-top-sidebar .widget a.btn-leap:focus, #main-top-sidebar input[type="submit"], #main-top-sidebar input[type="reset"], #main-top-sidebar input[type="button"], #main-top-sidebar input[type="submit"]:hover, #main-top-sidebar input[type="reset"]:hover, #main-top-sidebar input[type="button"]:hover, #main-top-sidebar input[type="submit"]:focus, #main-top-sidebar input[type="reset"]:focus, #main-top-sidebar input[type="button"]:focus {
        <?php if ( !empty( $leap_maintop_sidebar_button_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_maintop_sidebar_button_color_options[ 'text' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_maintop_sidebar_button_color_options[ 'bg' ] ) ) { ?>
                    background-color: <?php echo $leap_maintop_sidebar_button_color_options[ 'bg' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_maintop_sidebar_button_color_options[ 'border' ] ) ) { ?>
                    border-color: <?php echo $leap_maintop_sidebar_button_color_options[ 'border' ]; ?>;
        <?php } ?>
            }

            #main-top-sidebar .btn-leap:hover, #main-top-sidebar .btn-leap:focus, #main-top-sidebar a.btn-leap:hover, #main-top-sidebar a.btn-leap:focus, #main-top-sidebar .widget a.btn-leap:hover, #main-top-sidebar .widget a.btn-leap:focus, #main-top-sidebar input[type="submit"]:hover, #main-top-sidebar input[type="reset"]:hover, #main-top-sidebar input[type="button"]:hover, #main-top-sidebar input[type="submit"]:focus, #main-top-sidebar input[type="reset"]:focus, #main-top-sidebar input[type="button"]:focus {
        <?php if ( !empty( $leap_maintop_sidebar_button_color_options[ 'bg-hover' ] ) ) { ?>
                    background-color: <?php echo $leap_maintop_sidebar_button_color_options[ 'bg-hover' ]; ?>;
        <?php } ?>
            }

            #main-top-sidebar .btn-leap, #main-top-sidebar .btn-leap:hover, #main-top-sidebar .btn-leap:focus, #main-top-sidebar .btn-leap.disabled, #main-top-sidebar .btn-leap[disabled], #main-top-sidebar a.btn-leap, #main-top-sidebar a.btn-leap:hover, #main-top-sidebar a.btn-leap:focus, #main-top-sidebar .widget a.btn-leap, #main-top-sidebar .widget a.btn-leap:hover, #main-top-sidebar .widget a.btn-leap:focus, #main-top-sidebar input[type="submit"], #main-top-sidebar input[type="reset"], #main-top-sidebar input[type="button"], #main-top-sidebar input[type="submit"]:hover, #main-top-sidebar input[type="reset"]:hover, #main-top-sidebar input[type="button"]:hover, #main-top-sidebar input[type="submit"]:focus, #main-top-sidebar input[type="reset"]:focus, #main-top-sidebar input[type="button"]:focus {
        <?php if ( leap_get_sidebar_option_with_default( 'leap_maintop_sidebar_button_radius', $sidebar_id ) == 'on' ) : ?>
                    border-radius: 3px;
                    -webkit-border-radius: 3px;
        <?php endif; ?>
        <?php if ( leap_get_sidebar_option_with_default( 'leap_maintop_sidebar_button_radius', $sidebar_id ) == 'off' ) : ?>
                    border-radius: 0;
                    -webkit-border-radius: 0;
        <?php endif; ?>
            }

        <?php
        $leap_maintop_sidebar_input_color_options = (array) leap_get_post_option_value( 'leap_maintop_sidebar_input_color_options', $sidebar_id );
        ?>
            #main-top-sidebar input[type="text"], #main-top-sidebar input[type="text"]:focus, #main-top-sidebar .form-control, #main-top-sidebar .form-control:focus, #main-top-sidebar textarea, #main-top-sidebar textarea:focus, #main-top-sidebar input[type="password"], #main-top-sidebar input[type="password"]:focus, #main-top-sidebar .widget_search .input-group-addon:last-child, #main-top-sidebar .leap-search-form .input-group-addon:last-child, #main-top-sidebar input[type="email"], #main-top-sidebar input[type="date"], #main-top-sidebar input[type="number"], #main-top-sidebar input[type="email"]:focus, #main-top-sidebar input[type="date"]:focus, #main-top-sidebar input[type="number"]:focus {
        <?php if ( !empty( $leap_maintop_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_maintop_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_maintop_sidebar_input_color_options[ 'bg' ] ) ) { ?>
                    background-color: <?php echo $leap_maintop_sidebar_input_color_options[ 'bg' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_maintop_sidebar_input_color_options[ 'border' ] ) ) { ?>
                    border-color: <?php echo $leap_maintop_sidebar_input_color_options[ 'border' ]; ?>;
        <?php } ?>
            }
            #main-top-sidebar input:focus:invalid:focus, #main-top-sidebar textarea:focus:invalid:focus, #main-top-sidebar select:focus:invalid:focus  {
        <?php if ( !empty( $leap_maintop_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_maintop_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_maintop_sidebar_input_color_options[ 'bg' ] ) ) { ?>
                    background-color: <?php echo $leap_maintop_sidebar_input_color_options[ 'bg' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_maintop_sidebar_input_color_options[ 'border' ] ) ) { ?>
                    border-color: <?php echo $leap_maintop_sidebar_input_color_options[ 'border' ]; ?>;
        <?php } ?>
            }
            #main-top-sidebar .form-control::-moz-placeholder {
        <?php if ( !empty( $leap_maintop_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_maintop_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
            }
            #main-top-sidebar .form-control:-ms-input-placeholder {
        <?php if ( !empty( $leap_maintop_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_maintop_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
            }
            #main-top-sidebar .form-control::-webkit-input-placeholder {
        <?php if ( !empty( $leap_maintop_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_maintop_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
            }

        <?php
        $leap_maintop_sidebar_spacing      = (array) leap_get_post_option_value( 'leap_maintop_sidebar_spacing', $sidebar_id );
        $leap_maintop_sidebar_spacing_unit = (!empty( $leap_maintop_sidebar_spacing[ 'unit' ] )) ? $leap_maintop_sidebar_spacing[ 'unit' ] : 'px';
        ?>
            #main-top-sidebar .container-fluid, #main-top-sidebar > .container {
        <?php if ( isset( $leap_maintop_sidebar_spacing[ 'top' ] ) && strlen( $leap_maintop_sidebar_spacing[ 'top' ] ) > 0 ) { ?>
                    padding-top: <?php echo $leap_maintop_sidebar_spacing[ 'top' ] . $leap_maintop_sidebar_spacing_unit; ?>;
        <?php } ?>
        <?php if ( isset( $leap_maintop_sidebar_spacing[ 'bottom' ] ) && strlen( $leap_maintop_sidebar_spacing[ 'bottom' ] ) > 0 ) { ?>
                    padding-bottom: <?php echo $leap_maintop_sidebar_spacing[ 'bottom' ] . $leap_maintop_sidebar_spacing_unit; ?>;
        <?php } ?>
            }



            /***** header-full-width-sidebar  *****/
            #header-full-width-sidebar {
        <?php echo leap_get_post_background_value( 'leap_headerfull_sidebar_background', $sidebar_id ); ?>
        <?php
        $leap_headerfull_sidebar_top_border      = (array) leap_get_post_option_value( 'leap_headerfull_sidebar_top_border', $sidebar_id );
        $leap_headerfull_sidebar_top_border_unit = (!empty( $leap_headerfull_sidebar_top_border[ 'unit' ] )) ? $leap_headerfull_sidebar_top_border[ 'unit' ] : 'px';

        if ( !empty( $leap_headerfull_sidebar_top_border[ 'color' ] ) ) {
            ?>
                    border-top-color: <?php echo $leap_headerfull_sidebar_top_border[ 'color' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_headerfull_sidebar_top_border[ 'style' ] ) ) { ?>
                    border-top-style: <?php echo $leap_headerfull_sidebar_top_border[ 'style' ]; ?>;
        <?php } ?>
        <?php if ( isset( $leap_headerfull_sidebar_top_border[ 'width' ] ) && strlen( $leap_headerfull_sidebar_top_border[ 'width' ] ) > 0 ) { ?>
                    border-top-width: <?php echo $leap_headerfull_sidebar_top_border[ 'width' ] . $leap_headerfull_sidebar_top_border_unit; ?>;
        <?php } ?>

        <?php
        $leap_headerfull_sidebar_bottom_border      = (array) leap_get_post_option_value( 'leap_headerfull_sidebar_bottom_border', $sidebar_id );
        $leap_headerfull_sidebar_bottom_border_unit = (!empty( $leap_headerfull_sidebar_bottom_border[ 'unit' ] )) ? $leap_headerfull_sidebar_bottom_border[ 'unit' ] : 'px';

        if ( !empty( $leap_headerfull_sidebar_bottom_border[ 'color' ] ) ) {
            ?>
                    border-bottom-color: <?php echo $leap_headerfull_sidebar_bottom_border[ 'color' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_headerfull_sidebar_bottom_border[ 'style' ] ) ) { ?>
                    border-bottom-style: <?php echo $leap_headerfull_sidebar_bottom_border[ 'style' ]; ?>;
        <?php } ?>
        <?php if ( isset( $leap_headerfull_sidebar_bottom_border[ 'width' ] ) && strlen( $leap_headerfull_sidebar_bottom_border[ 'width' ] ) > 0 ) { ?>
                    border-bottom-width: <?php echo $leap_headerfull_sidebar_bottom_border[ 'width' ] . $leap_headerfull_sidebar_bottom_border_unit; ?>;
        <?php } ?>

            }

            #header-full-width-sidebar , #header-full-width-sidebar div, #header-full-width-sidebar p, #header-full-width-sidebar li {
        <?php echo leap_get_post_typography_value( 'leap_headerfull_sidebar_typography', $sidebar_id ); ?>
            }
            #header-full-width-sidebar .widget-title, #header-full-width-sidebar h4.widget-title {
        <?php echo leap_get_post_typography_value( 'leap_headerfull_sidebar_widget_title_typography', $sidebar_id ); ?>
            }
            #header-full-width-sidebar .widget span.date, #header-full-width-sidebar .widget small.small, #header-full-width-sidebar .widget_recent_entries ul li span.post-date, #header-full-width-sidebar .widget.woocommerce ul li del, #header-full-width-sidebar .widget.woocommerce ul li del span.amount {
                color: <?php echo leap_get_post_option_value( 'leap_headerfull_sidebar_meta_color', $sidebar_id ); ?>;
            }

        <?php
        $leap_headerfull_sidebar_links_color = (array) leap_get_post_option_value( 'leap_headerfull_sidebar_links_color', $sidebar_id );
        ?>
            #header-full-width-sidebar a {
        <?php if ( !empty( $leap_headerfull_sidebar_links_color[ 'link' ] ) ) { ?>
                    color: <?php echo $leap_headerfull_sidebar_links_color[ 'link' ]; ?>;
        <?php } ?>
            }
            #header-full-width-sidebar a:hover {
        <?php if ( !empty( $leap_headerfull_sidebar_links_color[ 'hover' ] ) ) { ?>
                    color: <?php echo $leap_headerfull_sidebar_links_color[ 'hover' ]; ?>;
        <?php } ?>
            }

            #header-full-width-sidebar .widget ul li {
        <?php
        $leap_headerfull_sidebar_list_divider_color = leap_get_post_option_value( 'leap_headerfull_sidebar_list_divider_color', $sidebar_id );
        if ( $leap_headerfull_sidebar_list_divider_color ) {
            ?>
                    border-color: <?php echo $leap_headerfull_sidebar_list_divider_color; ?>;
        <?php } ?>
            }

        <?php
        $leap_headerfull_sidebar_button_color_options = (array) leap_get_post_option_value( 'leap_headerfull_sidebar_button_color_options', $sidebar_id );
        ?>
            #header-full-width-sidebar .btn-leap, #header-full-width-sidebar .btn-leap:hover, #header-full-width-sidebar .btn-leap:focus, #header-full-width-sidebar .btn-leap.disabled, #header-full-width-sidebar .btn-leap[disabled], #header-full-width-sidebar a.btn-leap, #header-full-width-sidebar a.btn-leap:hover, #header-full-width-sidebar a.btn-leap:focus, #header-full-width-sidebar .widget a.btn-leap, #header-full-width-sidebar .widget a.btn-leap:hover, #header-full-width-sidebar .widget a.btn-leap:focus, #header-full-width-sidebar input[type="submit"], #header-full-width-sidebar input[type="reset"], #header-full-width-sidebar input[type="button"], #header-full-width-sidebar input[type="submit"]:hover, #header-full-width-sidebar input[type="reset"]:hover, #header-full-width-sidebar input[type="button"]:hover, #header-full-width-sidebar input[type="submit"]:focus, #header-full-width-sidebar input[type="reset"]:focus, #header-full-width-sidebar input[type="button"]:focus {
        <?php if ( !empty( $leap_headerfull_sidebar_button_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_headerfull_sidebar_button_color_options[ 'text' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_headerfull_sidebar_button_color_options[ 'bg' ] ) ) { ?>
                    background-color: <?php echo $leap_headerfull_sidebar_button_color_options[ 'bg' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_headerfull_sidebar_button_color_options[ 'border' ] ) ) { ?>
                    border-color: <?php echo $leap_headerfull_sidebar_button_color_options[ 'border' ]; ?>;
        <?php } ?>
            }

            #header-full-width-sidebar .btn-leap:hover, #header-full-width-sidebar .btn-leap:focus, #header-full-width-sidebar a.btn-leap:hover, #header-full-width-sidebar a.btn-leap:focus, #header-full-width-sidebar .widget a.btn-leap:hover, #header-full-width-sidebar .widget a.btn-leap:focus, #header-full-width-sidebar input[type="submit"]:hover, #header-full-width-sidebar input[type="reset"]:hover, #header-full-width-sidebar input[type="button"]:hover, #header-full-width-sidebar input[type="submit"]:focus, #header-full-width-sidebar input[type="reset"]:focus, #header-full-width-sidebar input[type="button"]:focus {
        <?php if ( !empty( $leap_headerfull_sidebar_button_color_options[ 'bg-hover' ] ) ) { ?>
                    background-color: <?php echo $leap_headerfull_sidebar_button_color_options[ 'bg-hover' ]; ?>;
        <?php } ?>
            }

            #header-full-width-sidebar .btn-leap, #header-full-width-sidebar .btn-leap:hover, #header-full-width-sidebar .btn-leap:focus, #header-full-width-sidebar .btn-leap.disabled, #header-full-width-sidebar .btn-leap[disabled], #header-full-width-sidebar a.btn-leap, #header-full-width-sidebar a.btn-leap:hover, #header-full-width-sidebar a.btn-leap:focus, #header-full-width-sidebar .widget a.btn-leap, #header-full-width-sidebar .widget a.btn-leap:hover, #header-full-width-sidebar .widget a.btn-leap:focus, #header-full-width-sidebar input[type="submit"], #header-full-width-sidebar input[type="reset"], #header-full-width-sidebar input[type="button"], #header-full-width-sidebar input[type="submit"]:hover, #header-full-width-sidebar input[type="reset"]:hover, #header-full-width-sidebar input[type="button"]:hover, #header-full-width-sidebar input[type="submit"]:focus, #header-full-width-sidebar input[type="reset"]:focus, #header-full-width-sidebar input[type="button"]:focus {
        <?php if ( leap_get_sidebar_option_with_default( 'leap_headerfull_sidebar_button_radius', $sidebar_id ) == 'on' ) { ?>
                    border-radius: 3px;
                    -webkit-border-radius: 3px;
        <?php } ?>
        <?php if ( leap_get_sidebar_option_with_default( 'leap_headerfull_sidebar_button_radius', $sidebar_id ) == 'off' ) { ?>
                    border-radius: 0;
                    -webkit-border-radius: 0;
        <?php } ?>
            }

        <?php
        $leap_headerfull_sidebar_input_color_options = (array) leap_get_post_option_value( 'leap_headerfull_sidebar_input_color_options', $sidebar_id );
        ?>
            #header-full-width-sidebar input[type="text"], #header-full-width-sidebar input[type="text"]:focus, #header-full-width-sidebar .form-control, #header-full-width-sidebar .form-control:focus, #header-full-width-sidebar textarea, #header-full-width-sidebar textarea:focus, #header-full-width-sidebar input[type="password"], #header-full-width-sidebar input[type="password"]:focus, #header-full-width-sidebar .widget_search .input-group-addon:last-child, #header-full-width-sidebar .leap-search-form .input-group-addon:last-child, #header-full-width-sidebar input[type="email"], #header-full-width-sidebar input[type="date"], #header-full-width-sidebar input[type="number"], #header-full-width-sidebar input[type="email"]:focus, #header-full-width-sidebar input[type="date"]:focus, #header-full-width-sidebar input[type="number"]:focus {
        <?php if ( !empty( $leap_headerfull_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_headerfull_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_headerfull_sidebar_input_color_options[ 'bg' ] ) ) { ?>
                    background-color: <?php echo $leap_headerfull_sidebar_input_color_options[ 'bg' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_headerfull_sidebar_input_color_options[ 'border' ] ) ) { ?>
                    border-color: <?php echo $leap_headerfull_sidebar_input_color_options[ 'border' ]; ?>;
        <?php } ?>
            }

            #header-full-width-sidebar input:focus:invalid:focus, #header-full-width-sidebar textarea:focus:invalid:focus, #header-full-width-sidebar select:focus:invalid:focus  {
        <?php if ( !empty( $leap_headerfull_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_headerfull_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_headerfull_sidebar_input_color_options[ 'bg' ] ) ) { ?>
                    background-color: <?php echo $leap_headerfull_sidebar_input_color_options[ 'bg' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_headerfull_sidebar_input_color_options[ 'border' ] ) ) { ?>
                    border-color: <?php echo $leap_headerfull_sidebar_input_color_options[ 'border' ]; ?>;
        <?php } ?>
            }
            #header-full-width-sidebar .form-control::-moz-placeholder {
        <?php if ( !empty( $leap_headerfull_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_headerfull_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
            }
            #header-full-width-sidebar .form-control:-ms-input-placeholder {
        <?php if ( !empty( $leap_headerfull_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_headerfull_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
            }
            #header-full-width-sidebar .form-control::-webkit-input-placeholder {
        <?php if ( !empty( $leap_headerfull_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_headerfull_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
            }

        <?php
        $leap_headerfull_sidebar_spacing      = (array) leap_get_post_option_value( 'leap_headerfull_sidebar_spacing', $sidebar_id );
        $leap_headerfull_sidebar_spacing_unit = (!empty( $leap_headerfull_sidebar_spacing[ 'unit' ] )) ? $leap_headerfull_sidebar_spacing[ 'unit' ] : 'px';
        ?>
            #header-full-width-sidebar .container-fluid, #header-full-width-sidebar > .container {
        <?php if ( isset( $leap_headerfull_sidebar_spacing[ 'top' ] ) && strlen( $leap_headerfull_sidebar_spacing[ 'top' ] ) > 0 ) { ?>
                    padding-top: <?php echo $leap_headerfull_sidebar_spacing[ 'top' ] . $leap_headerfull_sidebar_spacing_unit; ?>;
        <?php } ?>
        <?php if ( isset( $leap_headerfull_sidebar_spacing[ 'bottom' ] ) && strlen( $leap_headerfull_sidebar_spacing[ 'bottom' ] ) > 0 ) { ?>
                    padding-bottom: <?php echo $leap_headerfull_sidebar_spacing[ 'bottom' ] . $leap_headerfull_sidebar_spacing_unit; ?>;
        <?php } ?>
            }



            /***** main-content-top-sidebar  *****/
            #main-content-top-sidebar {
        <?php echo leap_get_post_background_value( 'leap_maincontenttop_sidebar_background', $sidebar_id ); ?>
        <?php
        $leap_maincontenttop_sidebar_top_border      = (array) leap_get_post_option_value( 'leap_maincontenttop_sidebar_top_border', $sidebar_id );
        $leap_maincontenttop_sidebar_top_border_unit = (!empty( $leap_maincontenttop_sidebar_top_border[ 'unit' ] )) ? $leap_maincontenttop_sidebar_top_border[ 'unit' ] : 'px';

        if ( !empty( $leap_maincontenttop_sidebar_top_border[ 'color' ] ) ) {
            ?>
                    border-top-color: <?php echo $leap_maincontenttop_sidebar_top_border[ 'color' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_maincontenttop_sidebar_top_border[ 'style' ] ) ) { ?>
                    border-top-style: <?php echo $leap_maincontenttop_sidebar_top_border[ 'style' ]; ?>;
        <?php } ?>
        <?php if ( isset( $leap_maincontenttop_sidebar_top_border[ 'width' ] ) && strlen( $leap_maincontenttop_sidebar_top_border[ 'width' ] ) > 0 ) { ?>
                    border-top-width: <?php echo $leap_maincontenttop_sidebar_top_border[ 'width' ] . $leap_maincontenttop_sidebar_top_border_unit; ?>;
        <?php } ?>

        <?php
        $leap_maincontenttop_sidebar_bottom_border      = (array) leap_get_post_option_value( 'leap_maincontenttop_sidebar_bottom_border', $sidebar_id );
        $leap_maincontenttop_sidebar_bottom_border_unit = (!empty( $leap_maincontenttop_sidebar_bottom_border[ 'unit' ] )) ? $leap_maincontenttop_sidebar_bottom_border[ 'unit' ] : 'px';

        if ( !empty( $leap_maincontenttop_sidebar_bottom_border[ 'color' ] ) ) {
            ?>
                    border-bottom-color: <?php echo $leap_maincontenttop_sidebar_bottom_border[ 'color' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_maincontenttop_sidebar_bottom_border[ 'style' ] ) ) { ?>
                    border-bottom-style: <?php echo $leap_maincontenttop_sidebar_bottom_border[ 'style' ]; ?>;
        <?php } ?>
        <?php if ( isset( $leap_maincontenttop_sidebar_bottom_border[ 'width' ] ) && strlen( $leap_maincontenttop_sidebar_bottom_border[ 'width' ] ) > 0 ) { ?>
                    border-bottom-width: <?php echo $leap_maincontenttop_sidebar_bottom_border[ 'width' ] . $leap_maincontenttop_sidebar_bottom_border_unit; ?>;
        <?php } ?>
            }

            #main-content-top-sidebar, #main-content-top-sidebar div, #main-content-top-sidebar p, #main-content-top-sidebar li {
        <?php echo leap_get_post_typography_value( 'leap_maincontenttop_sidebar_typography', $sidebar_id ); ?>
            }
            #main-content-top-sidebar .widget-title, #main-content-top-sidebar h4.widget-title {
        <?php echo leap_get_post_typography_value( 'leap_maincontenttop_sidebar_widget_title_typography', $sidebar_id ); ?>
            }
            #main-content-top-sidebar .widget span.date, #main-content-top-sidebar .widget small.small, #main-content-top-sidebar .widget_recent_entries ul li span.post-date, #main-content-top-sidebar .widget.woocommerce ul li del, #main-content-top-sidebar .widget.woocommerce ul li del span.amount {
                color: <?php echo leap_get_post_option_value( 'leap_maincontenttop_sidebar_meta_color', $sidebar_id ); ?>;
            }

        <?php
        $leap_maincontenttop_sidebar_links_color = (array) leap_get_post_option_value( 'leap_maincontenttop_sidebar_links_color', $sidebar_id );
        ?>
            #main-content-top-sidebar a {
        <?php if ( !empty( $leap_maincontenttop_sidebar_links_color[ 'link' ] ) ) { ?>
                    color: <?php echo $leap_maincontenttop_sidebar_links_color[ 'link' ]; ?>;
        <?php } ?>
            }
            #main-content-top-sidebar a:hover {
        <?php if ( !empty( $leap_maincontenttop_sidebar_links_color[ 'hover' ] ) ) { ?>
                    color: <?php echo $leap_maincontenttop_sidebar_links_color[ 'hover' ]; ?>;
        <?php } ?>
            }

            #main-content-top-sidebar .widget ul li {
        <?php
        $leap_maincontenttop_sidebar_list_divider_color = leap_get_post_option_value( 'leap_maincontenttop_sidebar_list_divider_color', $sidebar_id );
        if ( $leap_maincontenttop_sidebar_list_divider_color ) :
            ?>
                    border-color: <?php echo $leap_maincontenttop_sidebar_list_divider_color; ?>;
        <?php endif; ?>
            }

        <?php
        $leap_maincontenttop_sidebar_button_color_options = (array) leap_get_post_option_value( 'leap_maincontenttop_sidebar_button_color_options', $sidebar_id );
        ?>
            #main-content-top-sidebar .btn-leap, #main-content-top-sidebar .btn-leap:hover, #main-content-top-sidebar .btn-leap:focus, #main-content-top-sidebar .btn-leap.disabled, #main-content-top-sidebar .btn-leap[disabled], #main-content-top-sidebar a.btn-leap, #main-content-top-sidebar a.btn-leap:hover, #main-content-top-sidebar a.btn-leap:focus, #main-content-top-sidebar .widget a.btn-leap, #main-content-top-sidebar .widget a.btn-leap:hover, #main-content-top-sidebar .widget a.btn-leap:focus, #main-content-top-sidebar input[type="submit"], #main-content-top-sidebar input[type="reset"], #main-content-top-sidebar input[type="button"], #main-content-top-sidebar input[type="submit"]:hover, #main-content-top-sidebar input[type="reset"]:hover, #main-content-top-sidebar input[type="button"]:hover, #main-content-top-sidebar input[type="submit"]:focus, #main-content-top-sidebar input[type="reset"]:focus, #main-content-top-sidebar input[type="button"]:focus {
        <?php if ( !empty( $leap_maincontenttop_sidebar_button_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_maincontenttop_sidebar_button_color_options[ 'text' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_maincontenttop_sidebar_button_color_options[ 'bg' ] ) ) { ?>
                    background-color: <?php echo $leap_maincontenttop_sidebar_button_color_options[ 'bg' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_maincontenttop_sidebar_button_color_options[ 'border' ] ) ) { ?>
                    border-color: <?php echo $leap_maincontenttop_sidebar_button_color_options[ 'border' ]; ?>;
        <?php } ?>
            }

            #main-content-top-sidebar .btn-leap:hover, #main-content-top-sidebar .btn-leap:focus, #main-content-top-sidebar a.btn-leap:hover, #main-content-top-sidebar a.btn-leap:focus, #main-content-top-sidebar .widget a.btn-leap:hover, #main-content-top-sidebar .widget a.btn-leap:focus, #main-content-top-sidebar input[type="submit"]:hover, #main-content-top-sidebar input[type="reset"]:hover, #main-content-top-sidebar input[type="button"]:hover, #main-content-top-sidebar input[type="submit"]:focus, #main-content-top-sidebar input[type="reset"]:focus, #main-content-top-sidebar input[type="button"]:focus {
        <?php if ( !empty( $leap_maincontenttop_sidebar_button_color_options[ 'bg-hover' ] ) ) { ?>
                    background-color: <?php echo $leap_maincontenttop_sidebar_button_color_options[ 'bg-hover' ]; ?>;
        <?php } ?>
            }

            #main-content-top-sidebar .btn-leap, #main-content-top-sidebar .btn-leap:hover, #main-content-top-sidebar .btn-leap:focus, #main-content-top-sidebar .btn-leap.disabled, #main-content-top-sidebar .btn-leap[disabled], #main-content-top-sidebar a.btn-leap, #main-content-top-sidebar a.btn-leap:hover, #main-content-top-sidebar a.btn-leap:focus, #main-content-top-sidebar .widget a.btn-leap, #main-content-top-sidebar .widget a.btn-leap:hover, #main-content-top-sidebar .widget a.btn-leap:focus, #main-content-top-sidebar input[type="submit"], #main-content-top-sidebar input[type="reset"], #main-content-top-sidebar input[type="button"], #main-content-top-sidebar input[type="submit"]:hover, #main-content-top-sidebar input[type="reset"]:hover, #main-content-top-sidebar input[type="button"]:hover, #main-content-top-sidebar input[type="submit"]:focus, #main-content-top-sidebar input[type="reset"]:focus, #main-content-top-sidebar input[type="button"]:focus  {
        <?php if ( leap_get_sidebar_option_with_default( 'leap_maincontenttop_sidebar_button_radius', $sidebar_id ) == 'on' ) : ?>
                    border-radius: 3px;
                    -webkit-border-radius: 3px;
        <?php endif; ?>
        <?php if ( leap_get_sidebar_option_with_default( 'leap_maincontenttop_sidebar_button_radius', $sidebar_id ) == 'off' ) : ?>
                    border-radius: 0;
                    -webkit-border-radius: 0;
        <?php endif; ?>
            }


        <?php
        $leap_maincontenttop_sidebar_input_color_options = (array) leap_get_post_option_value( 'leap_maincontenttop_sidebar_input_color_options', $sidebar_id );
        ?>
            #main-content-top-sidebar input[type="text"], #main-content-top-sidebar input[type="text"]:focus, #main-content-top-sidebar .form-control, #main-content-top-sidebar .form-control:focus, #main-content-top-sidebar textarea, #main-content-top-sidebar textarea:focus, #main-content-top-sidebar input[type="password"], #main-content-top-sidebar input[type="password"]:focus, #main-content-top-sidebar .widget_search .input-group-addon:last-child, #main-content-top-sidebar .leap-search-form .input-group-addon:last-child, #main-content-top-sidebar input[type="email"], #main-content-top-sidebar input[type="date"], #main-content-top-sidebar input[type="number"], #main-content-top-sidebar input[type="email"]:focus, #main-content-top-sidebar input[type="date"]:focus, #main-content-top-sidebar input[type="number"]:focus {
        <?php if ( !empty( $leap_maincontenttop_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_maincontenttop_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_maincontenttop_sidebar_input_color_options[ 'bg' ] ) ) { ?>
                    background-color: <?php echo $leap_maincontenttop_sidebar_input_color_options[ 'bg' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_maincontenttop_sidebar_input_color_options[ 'border' ] ) ) { ?>
                    border-color: <?php echo $leap_maincontenttop_sidebar_input_color_options[ 'border' ]; ?>;
        <?php } ?>
            }
            #main-content-top-sidebar input:focus:invalid:focus, #main-content-top-sidebar textarea:focus:invalid:focus, #main-content-top-sidebar select:focus:invalid:focus  {
        <?php if ( !empty( $leap_maincontenttop_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_maincontenttop_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_maincontenttop_sidebar_input_color_options[ 'bg' ] ) ) { ?>
                    background-color: <?php echo $leap_maincontenttop_sidebar_input_color_options[ 'bg' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_maincontenttop_sidebar_input_color_options[ 'border' ] ) ) { ?>
                    border-color: <?php echo $leap_maincontenttop_sidebar_input_color_options[ 'border' ]; ?>;
        <?php } ?>
            }
            #main-content-top-sidebar .form-control::-moz-placeholder {
        <?php if ( !empty( $leap_maincontenttop_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_maincontenttop_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
            }
            #main-content-top-sidebar .form-control:-ms-input-placeholder {
        <?php if ( !empty( $leap_maincontenttop_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_maincontenttop_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
            }
            #main-content-top-sidebar .form-control::-webkit-input-placeholder {
        <?php if ( !empty( $leap_maincontenttop_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_maincontenttop_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
            }

        <?php
        $leap_maincontenttop_sidebar_spacing      = (array) leap_get_post_option_value( 'leap_maincontenttop_sidebar_spacing', $sidebar_id );
        $leap_maincontenttop_sidebar_spacing_unit = (!empty( $leap_maincontenttop_sidebar_spacing[ 'unit' ] )) ? $leap_maincontenttop_sidebar_spacing[ 'unit' ] : 'px';
        ?>
            #main-content-top-sidebar .container-fluid, #main-content-top-sidebar > .container {
        <?php if ( isset( $leap_maincontenttop_sidebar_spacing[ 'top' ] ) && strlen( $leap_maincontenttop_sidebar_spacing[ 'top' ] ) > 0 ) { ?>
                    padding-top: <?php echo $leap_maincontenttop_sidebar_spacing[ 'top' ] . $leap_maincontenttop_sidebar_spacing_unit; ?>;
        <?php } ?>
        <?php if ( isset( $leap_maincontenttop_sidebar_spacing[ 'bottom' ] ) && strlen( $leap_maincontenttop_sidebar_spacing[ 'bottom' ] ) > 0 ) { ?>
                    padding-bottom: <?php echo $leap_maincontenttop_sidebar_spacing[ 'bottom' ] . $leap_maincontenttop_sidebar_spacing_unit; ?>;
        <?php } ?>
            }


            /***** content-top-sidebar  *****/
            #content-top-sidebar {
        <?php echo leap_get_post_background_value( 'leap_contenttop_sidebar_background', $sidebar_id ); ?>
        <?php
        $leap_contenttop_sidebar_top_border      = (array) leap_get_post_option_value( 'leap_contenttop_sidebar_top_border', $sidebar_id );
        $leap_contenttop_sidebar_top_border_unit = (!empty( $leap_contenttop_sidebar_top_border[ 'unit' ] )) ? $leap_contenttop_sidebar_top_border[ 'unit' ] : 'px';

        if ( !empty( $leap_contenttop_sidebar_top_border[ 'color' ] ) ) {
            ?>
                    border-top-color: <?php echo $leap_contenttop_sidebar_top_border[ 'color' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_contenttop_sidebar_top_border[ 'style' ] ) ) { ?>
                    border-top-style: <?php echo $leap_contenttop_sidebar_top_border[ 'style' ]; ?>;
        <?php } ?>
        <?php if ( isset( $leap_contenttop_sidebar_top_border[ 'width' ] ) && strlen( $leap_contenttop_sidebar_top_border[ 'width' ] ) > 0 ) { ?>
                    border-top-width: <?php echo $leap_contenttop_sidebar_top_border[ 'width' ] . $leap_contenttop_sidebar_top_border_unit; ?>;
        <?php } ?>

        <?php
        $leap_contenttop_sidebar_bottom_border      = (array) leap_get_post_option_value( 'leap_contenttop_sidebar_bottom_border', $sidebar_id );
        $leap_contenttop_sidebar_bottom_border_unit = (!empty( $leap_contenttop_sidebar_bottom_border[ 'unit' ] )) ? $leap_contenttop_sidebar_bottom_border[ 'unit' ] : 'px';

        if ( !empty( $leap_contenttop_sidebar_bottom_border[ 'color' ] ) ) {
            ?>
                    border-bottom-color: <?php echo $leap_contenttop_sidebar_bottom_border[ 'color' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_contenttop_sidebar_bottom_border[ 'style' ] ) ) { ?>
                    border-bottom-style: <?php echo $leap_contenttop_sidebar_bottom_border[ 'style' ]; ?>;
        <?php } ?>
        <?php if ( isset( $leap_contenttop_sidebar_bottom_border[ 'width' ] ) && strlen( $leap_contenttop_sidebar_bottom_border[ 'width' ] ) > 0 ) { ?>
                    border-bottom-width: <?php echo $leap_contenttop_sidebar_bottom_border[ 'width' ] . $leap_contenttop_sidebar_bottom_border_unit; ?>;
        <?php } ?>
            }
            #content-top-sidebar, #content-top-sidebar div, #content-top-sidebar p, #content-top-sidebar li {
        <?php echo leap_get_post_typography_value( 'leap_contenttop_sidebar_typography', $sidebar_id ); ?>
            }
            #content-top-sidebar .widget-title, #content-top-sidebar h4.widget-title {
        <?php echo leap_get_post_typography_value( 'leap_contenttop_sidebar_widget_title_typography', $sidebar_id ); ?>
            }
            #content-top-sidebar .widget span.date, #content-top-sidebar .widget small.small, #content-top-sidebar .widget_recent_entries ul li span.post-date, #content-top-sidebar .widget.woocommerce ul li del, #content-top-sidebar .widget.woocommerce ul li del span.amount {
                color: <?php echo leap_get_post_option_value( 'leap_contenttop_sidebar_meta_color', $sidebar_id ); ?>;
            }

        <?php
        $leap_contenttop_sidebar_links_color = (array) leap_get_post_option_value( 'leap_contenttop_sidebar_links_color', $sidebar_id );
        ?>
            #content-top-sidebar a {
        <?php if ( !empty( $leap_contenttop_sidebar_links_color[ 'link' ] ) ) { ?>
                    color: <?php echo $leap_contenttop_sidebar_links_color[ 'link' ]; ?>;
        <?php } ?>
            }
            #content-top-sidebar a:hover {
        <?php if ( !empty( $leap_contenttop_sidebar_links_color[ 'hover' ] ) ) { ?>
                    color: <?php echo $leap_contenttop_sidebar_links_color[ 'hover' ]; ?>;
        <?php } ?>
            }
            #content-top-sidebar .widget ul li {
        <?php
        $leap_contenttop_sidebar_list_divider_color = leap_get_post_option_value( 'leap_contenttop_sidebar_list_divider_color', $sidebar_id );
        if ( $leap_contenttop_sidebar_list_divider_color ) :
            ?>
                    border-color: <?php echo $leap_contenttop_sidebar_list_divider_color; ?>;
        <?php endif; ?>
            }

        <?php
        $leap_contenttop_sidebar_button_color_options = (array) leap_get_post_option_value( 'leap_contenttop_sidebar_button_color_options', $sidebar_id );
        ?>
            #content-top-sidebar .btn-leap, #content-top-sidebar .btn-leap:hover, #content-top-sidebar .btn-leap:focus, #content-top-sidebar .btn-leap.disabled, #content-top-sidebar .btn-leap[disabled], #content-top-sidebar a.btn-leap, #content-top-sidebar a.btn-leap:hover, #content-top-sidebar a.btn-leap:focus, #content-top-sidebar .widget a.btn-leap, #content-top-sidebar .widget a.btn-leap:hover, #content-top-sidebar .widget a.btn-leap:focus, #content-top-sidebar input[type="submit"], #content-top-sidebar input[type="reset"], #content-top-sidebar input[type="button"], #content-top-sidebar input[type="submit"]:hover, #content-top-sidebar input[type="reset"]:hover, #content-top-sidebar input[type="button"]:hover, #content-top-sidebar input[type="submit"]:focus, #content-top-sidebar input[type="reset"]:focus, #content-top-sidebar input[type="button"]:focus {
        <?php if ( !empty( $leap_contenttop_sidebar_button_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_contenttop_sidebar_button_color_options[ 'text' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_contenttop_sidebar_button_color_options[ 'bg' ] ) ) { ?>
                    background-color: <?php echo $leap_contenttop_sidebar_button_color_options[ 'bg' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_contenttop_sidebar_button_color_options[ 'border' ] ) ) { ?>
                    border-color: <?php echo $leap_contenttop_sidebar_button_color_options[ 'border' ]; ?>;
        <?php } ?>
            }

            #content-top-sidebar .btn-leap:hover, #content-top-sidebar .btn-leap:focus, #content-top-sidebar a.btn-leap:hover, #content-top-sidebar a.btn-leap:focus, #content-top-sidebar .widget a.btn-leap:hover, #content-top-sidebar .widget a.btn-leap:focus, #content-top-sidebar input[type="submit"]:hover, #content-top-sidebar input[type="reset"]:hover, #content-top-sidebar input[type="button"]:hover, #content-top-sidebar input[type="submit"]:focus, #content-top-sidebar input[type="reset"]:focus, #content-top-sidebar input[type="button"]:focus  {
        <?php if ( !empty( $leap_contenttop_sidebar_button_color_options[ 'bg-hover' ] ) ) { ?>
                    background-color: <?php echo $leap_contenttop_sidebar_button_color_options[ 'bg-hover' ]; ?>;
        <?php } ?>
            }


            #content-top-sidebar .btn-leap, #content-top-sidebar .btn-leap:hover, #content-top-sidebar .btn-leap:focus, #content-top-sidebar .btn-leap.disabled, #content-top-sidebar .btn-leap[disabled], #content-top-sidebar a.btn-leap, #content-top-sidebar a.btn-leap:hover, #content-top-sidebar a.btn-leap:focus, #content-top-sidebar .widget a.btn-leap, #content-top-sidebar .widget a.btn-leap:hover, #content-top-sidebar .widget a.btn-leap:focus, #content-top-sidebar input[type="submit"], #content-top-sidebar input[type="reset"], #content-top-sidebar input[type="button"], #content-top-sidebar input[type="submit"]:hover, #content-top-sidebar input[type="reset"]:hover, #content-top-sidebar input[type="button"]:hover, #content-top-sidebar input[type="submit"]:focus, #content-top-sidebar input[type="reset"]:focus, #content-top-sidebar input[type="button"]:focus  {
        <?php if ( leap_get_sidebar_option_with_default( 'leap_contenttop_sidebar_button_radius', $sidebar_id ) == 'on' ) : ?>
                    border-radius: 3px;
                    -webkit-border-radius: 3px;
        <?php endif; ?>
        <?php if ( leap_get_sidebar_option_with_default( 'leap_contenttop_sidebar_button_radius', $sidebar_id ) == 'off' ) : ?>
                    border-radius: 0;
                    -webkit-border-radius: 0;
        <?php endif; ?>
            }

        <?php
        $leap_contenttop_sidebar_input_color_options = (array) leap_get_post_option_value( 'leap_contenttop_sidebar_input_color_options', $sidebar_id );
        ?>
            #content-top-sidebar input[type="text"], #content-top-sidebar input[type="text"]:focus, #content-top-sidebar .form-control, #content-top-sidebar .form-control:focus, #content-top-sidebar textarea, #content-top-sidebar textarea:focus, #content-top-sidebar input[type="password"], #content-top-sidebar input[type="password"]:focus, #content-top-sidebar .widget_search .input-group-addon:last-child, #content-top-sidebar .leap-search-form .input-group-addon:last-child, #content-top-sidebar input[type="email"], #content-top-sidebar input[type="date"], #content-top-sidebar input[type="number"], #content-top-sidebar input[type="email"]:focus, #content-top-sidebar input[type="date"]:focus, #content-top-sidebar input[type="number"]:focus {
        <?php if ( !empty( $leap_contenttop_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_contenttop_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_contenttop_sidebar_input_color_options[ 'bg' ] ) ) { ?>
                    background-color: <?php echo $leap_contenttop_sidebar_input_color_options[ 'bg' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_contenttop_sidebar_input_color_options[ 'border' ] ) ) { ?>
                    border-color: <?php echo $leap_contenttop_sidebar_input_color_options[ 'border' ]; ?>;
        <?php } ?>
            }
            #content-top-sidebar :focus:invalid:focus, #content-top-sidebar:focus:invalid:focus, #content-top-sidebar  select:focus:invalid:focus  {
        <?php if ( !empty( $leap_contenttop_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_contenttop_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_contenttop_sidebar_input_color_options[ 'bg' ] ) ) { ?>
                    background-color: <?php echo $leap_contenttop_sidebar_input_color_options[ 'bg' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_contenttop_sidebar_input_color_options[ 'border' ] ) ) { ?>
                    border-color: <?php echo $leap_contenttop_sidebar_input_color_options[ 'border' ]; ?>;
        <?php } ?>
            }

            #content-top-sidebar .form-control::-moz-placeholder {
        <?php if ( !empty( $leap_contenttop_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_contenttop_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
            }
            #content-top-sidebar .form-control:-ms-input-placeholder {
        <?php if ( !empty( $leap_contenttop_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_contenttop_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
            }
            #content-top-sidebar .form-control::-webkit-input-placeholder {
        <?php if ( !empty( $leap_contenttop_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_contenttop_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
            }


        <?php
        $leap_contenttop_sidebar_spacing      = (array) leap_get_post_option_value( 'leap_contenttop_sidebar_spacing', $sidebar_id );
        $leap_contenttop_sidebar_spacing_unit = (!empty( $leap_contenttop_sidebar_spacing[ 'unit' ] )) ? $leap_contenttop_sidebar_spacing[ 'unit' ] : 'px';
        ?>
            #content-top-sidebar .container-fluid, #content-top-sidebar > .container {
        <?php if ( isset( $leap_contenttop_sidebar_spacing[ 'top' ] ) && strlen( $leap_contenttop_sidebar_spacing[ 'top' ] ) > 0 ) { ?>
                    padding-top: <?php echo $leap_contenttop_sidebar_spacing[ 'top' ] . $leap_contenttop_sidebar_spacing_unit; ?>;
        <?php } ?>
        <?php if ( isset( $leap_contenttop_sidebar_spacing[ 'bottom' ] ) && strlen( $leap_contenttop_sidebar_spacing[ 'bottom' ] ) > 0 ) { ?>
                    padding-bottom: <?php echo $leap_contenttop_sidebar_spacing[ 'bottom' ] . $leap_contenttop_sidebar_spacing_unit; ?>;
        <?php } ?>
            }


            /***** content-bottom-sidebar  *****/
            #content-bottom-sidebar {
        <?php echo leap_get_post_background_value( 'leap_contentbottom_sidebar_background', $sidebar_id ); ?>
        <?php
        $leap_contentbottom_sidebar_top_border      = (array) leap_get_post_option_value( 'leap_contentbottom_sidebar_top_border', $sidebar_id );
        $leap_contentbottom_sidebar_top_border_unit = (!empty( $leap_contentbottom_sidebar_top_border[ 'unit' ] )) ? $leap_contentbottom_sidebar_top_border[ 'unit' ] : 'px';

        if ( !empty( $leap_contentbottom_sidebar_top_border[ 'color' ] ) ) {
            ?>
                    border-top-color: <?php echo $leap_contentbottom_sidebar_top_border[ 'color' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_contentbottom_sidebar_top_border[ 'style' ] ) ) { ?>
                    border-top-style: <?php echo $leap_contentbottom_sidebar_top_border[ 'style' ]; ?>;
        <?php } ?>
        <?php if ( isset( $leap_contentbottom_sidebar_top_border[ 'width' ] ) && strlen( $leap_contentbottom_sidebar_top_border[ 'width' ] ) > 0 ) { ?>
                    border-top-width: <?php echo $leap_contentbottom_sidebar_top_border[ 'width' ] . $leap_contentbottom_sidebar_top_border_unit; ?>;
        <?php } ?>

        <?php
        $leap_contentbottom_sidebar_bottom_border      = (array) leap_get_post_option_value( 'leap_contentbottom_sidebar_bottom_border', $sidebar_id );
        $leap_contentbottom_sidebar_bottom_border_unit = (!empty( $leap_contentbottom_sidebar_bottom_border[ 'unit' ] )) ? $leap_contentbottom_sidebar_bottom_border[ 'unit' ] : 'px';

        if ( !empty( $leap_contentbottom_sidebar_bottom_border[ 'color' ] ) ) {
            ?>
                    border-bottom-color: <?php echo $leap_contentbottom_sidebar_bottom_border[ 'color' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_contentbottom_sidebar_bottom_border[ 'style' ] ) ) { ?>
                    border-bottom-style: <?php echo $leap_contentbottom_sidebar_bottom_border[ 'style' ]; ?>;
        <?php } ?>
        <?php if ( isset( $leap_contentbottom_sidebar_bottom_border[ 'width' ] ) && strlen( $leap_contentbottom_sidebar_bottom_border[ 'width' ] ) > 0 ) { ?>
                    border-bottom-width: <?php echo $leap_contentbottom_sidebar_bottom_border[ 'width' ] . $leap_contentbottom_sidebar_bottom_border_unit; ?>;
        <?php } ?>
            }


            #content-bottom-sidebar ,#content-bottom-sidebar div, #content-bottom-sidebar li, #content-bottom-sidebar p {
        <?php echo leap_get_post_typography_value( 'leap_contentbottom_sidebar_typography', $sidebar_id ); ?>
            }
            #content-bottom-sidebar .widget-title, #content-bottom-sidebar h4.widget-title {
        <?php echo leap_get_post_typography_value( 'leap_contentbottom_sidebar_widget_title_typography', $sidebar_id ); ?>
            }
            #content-bottom-sidebar .widget span.date, #content-bottom-sidebar .widget small.small, #content-bottom-sidebar .widget_recent_entries ul li span.post-date, #content-bottom-sidebar .widget.woocommerce ul li del, #content-bottom-sidebar .widget.woocommerce ul li del span.amount {
                color: <?php echo leap_get_post_option_value( 'leap_contentbottom_sidebar_meta_color', $sidebar_id ); ?>;
            }

        <?php
        $leap_contentbottom_sidebar_links_color = (array) leap_get_post_option_value( 'leap_contentbottom_sidebar_links_color', $sidebar_id );
        ?>
            #content-bottom-sidebar a {
        <?php if ( !empty( $leap_contentbottom_sidebar_links_color[ 'link' ] ) ) { ?>
                    color: <?php echo $leap_contentbottom_sidebar_links_color[ 'link' ]; ?>;
        <?php } ?>
            }
            #content-bottom-sidebar a:hover {
        <?php if ( !empty( $leap_contentbottom_sidebar_links_color[ 'hover' ] ) ) { ?>
                    color: <?php echo $leap_contentbottom_sidebar_links_color[ 'hover' ]; ?>;
        <?php } ?>
            }

            #content-bottom-sidebar .widget ul li {	
        <?php
        $leap_contentbottom_sidebar_list_divider_color = leap_get_post_option_value( 'leap_contentbottom_sidebar_list_divider_color', $sidebar_id );
        if ( $leap_contentbottom_sidebar_list_divider_color ) :
            ?>
                    border-color: <?php echo $leap_contentbottom_sidebar_list_divider_color; ?>;
        <?php endif; ?>
            }

        <?php
        $leap_contentbottom_sidebar_button_color_options = (array) leap_get_post_option_value( 'leap_contentbottom_sidebar_button_color_options', $sidebar_id );
        ?>
            #content-bottom-sidebar .btn-leap, #content-bottom-sidebar .btn-leap:hover, #content-bottom-sidebar .btn-leap:focus, #content-bottom-sidebar .btn-leap.disabled, #content-bottom-sidebar .btn-leap[disabled], #content-bottom-sidebar a.btn-leap, #content-bottom-sidebar a.btn-leap:hover, #content-bottom-sidebar a.btn-leap:focus, #content-bottom-sidebar .widget a.btn-leap, #content-bottom-sidebar .widget a.btn-leap:hover, #content-bottom-sidebar .widget a.btn-leap:focus, #content-bottom-sidebar input[type="submit"], #content-bottom-sidebar input[type="reset"], #content-bottom-sidebar input[type="button"], #content-bottom-sidebar input[type="submit"]:hover, #content-bottom-sidebar input[type="reset"]:hover, #content-bottom-sidebar input[type="button"]:hover, #content-bottom-sidebar input[type="submit"]:focus, #content-bottom-sidebar input[type="reset"]:focus, #content-bottom-sidebar input[type="button"]:focus {
        <?php if ( !empty( $leap_contentbottom_sidebar_button_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_contentbottom_sidebar_button_color_options[ 'text' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_contentbottom_sidebar_button_color_options[ 'bg' ] ) ) { ?>
                    background-color: <?php echo $leap_contentbottom_sidebar_button_color_options[ 'bg' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_contentbottom_sidebar_button_color_options[ 'border' ] ) ) { ?>
                    border-color: <?php echo $leap_contentbottom_sidebar_button_color_options[ 'border' ]; ?>;
        <?php } ?>
            }

            #content-bottom-sidebar .btn-leap:hover, #content-bottom-sidebar .btn-leap:focus, #content-bottom-sidebar a.btn-leap:hover, #content-bottom-sidebar a.btn-leap:focus, #content-bottom-sidebar .widget a.btn-leap:hover, #content-bottom-sidebar .widget a.btn-leap:focus, #content-bottom-sidebar input[type="submit"]:hover, #content-bottom-sidebar input[type="reset"]:hover, #content-bottom-sidebar input[type="button"]:hover, #content-bottom-sidebar input[type="submit"]:focus, #content-bottom-sidebar input[type="reset"]:focus, #content-bottom-sidebar input[type="button"]:focus {
        <?php if ( !empty( $leap_contentbottom_sidebar_button_color_options[ 'bg-hover' ] ) ) { ?>
                    background-color: <?php echo $leap_contentbottom_sidebar_button_color_options[ 'bg-hover' ]; ?>;
        <?php } ?>
            }

            #content-bottom-sidebar .btn-leap, #content-bottom-sidebar .btn-leap:hover, #content-bottom-sidebar .btn-leap:focus, #content-bottom-sidebar .btn-leap.disabled, #content-bottom-sidebar .btn-leap[disabled], #content-bottom-sidebar a.btn-leap, #content-bottom-sidebar a.btn-leap:hover, #content-bottom-sidebar a.btn-leap:focus, #content-bottom-sidebar .widget a.btn-leap, #content-bottom-sidebar .widget a.btn-leap:hover, #content-bottom-sidebar .widget a.btn-leap:focus, #content-bottom-sidebar input[type="submit"], #content-bottom-sidebar input[type="reset"], #content-bottom-sidebar input[type="button"], #content-bottom-sidebar input[type="submit"]:hover, #content-bottom-sidebar input[type="reset"]:hover, #content-bottom-sidebar input[type="button"]:hover, #content-bottom-sidebar input[type="submit"]:focus, #content-bottom-sidebar input[type="reset"]:focus, #content-bottom-sidebar input[type="button"]:focus {
        <?php if ( leap_get_sidebar_option_with_default( 'leap_contentbottom_sidebar_button_radius', $sidebar_id ) == 'on' ) : ?>
                    border-radius: 3px;
                    -webkit-border-radius: 3px;
        <?php endif; ?>
        <?php if ( leap_get_sidebar_option_with_default( 'leap_contentbottom_sidebar_button_radius', $sidebar_id ) == 'off' ) : ?>
                    border-radius: 0;
                    -webkit-border-radius: 0;
        <?php endif; ?>
            }

        <?php
        $leap_contentbottom_sidebar_input_color_options = (array) leap_get_post_option_value( 'leap_contentbottom_sidebar_input_color_options', $sidebar_id );
        ?>
            #content-bottom-sidebar input[type="text"], #content-bottom-sidebar input[type="text"]:focus, #content-bottom-sidebar .form-control, #content-bottom-sidebar .form-control:focus, #content-bottom-sidebar textarea, #content-bottom-sidebar textarea:focus, #content-bottom-sidebar input[type="password"], #content-bottom-sidebar input[type="password"]:focus, #content-bottom-sidebar .widget_search .input-group-addon:last-child, #content-bottom-sidebar .leap-search-form .input-group-addon:last-child, #content-bottom-sidebar input[type="email"], #content-bottom-sidebar input[type="date"], #content-bottom-sidebar input[type="number"], #content-bottom-sidebar input[type="email"]:focus, #content-bottom-sidebar input[type="date"]:focus, #content-bottom-sidebar input[type="number"]:focus {
        <?php if ( !empty( $leap_contentbottom_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_contentbottom_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_contentbottom_sidebar_input_color_options[ 'bg' ] ) ) { ?>
                    background-color: <?php echo $leap_contentbottom_sidebar_input_color_options[ 'bg' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_contentbottom_sidebar_input_color_options[ 'border' ] ) ) { ?>
                    border-color: <?php echo $leap_contentbottom_sidebar_input_color_options[ 'border' ]; ?>;
        <?php } ?>
            }
            #content-bottom-sidebar input:focus:invalid:focus, #content-bottom-sidebar textarea:focus:invalid:focus, #content-bottom-sidebar select:focus:invalid:focus  {
        <?php if ( !empty( $leap_contentbottom_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_contentbottom_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_contentbottom_sidebar_input_color_options[ 'bg' ] ) ) { ?>
                    background-color: <?php echo $leap_contentbottom_sidebar_input_color_options[ 'bg' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_contentbottom_sidebar_input_color_options[ 'border' ] ) ) { ?>
                    border-color: <?php echo $leap_contentbottom_sidebar_input_color_options[ 'border' ]; ?>;
        <?php } ?>
            }
            #content-bottom-sidebar .form-control::-moz-placeholder {
        <?php if ( !empty( $leap_contentbottom_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_contentbottom_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
            }
            #content-bottom-sidebar .form-control:-ms-input-placeholder {
        <?php if ( !empty( $leap_contentbottom_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_contentbottom_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
            }
            #content-bottom-sidebar .form-control::-webkit-input-placeholder {
        <?php if ( !empty( $leap_contentbottom_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_contentbottom_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
            }

        <?php
        $leap_contentbottom_sidebar_spacing      = (array) leap_get_post_option_value( 'leap_contentbottom_sidebar_spacing', $sidebar_id );
        $leap_contentbottom_sidebar_spacing_unit = (!empty( $leap_contentbottom_sidebar_spacing[ 'unit' ] )) ? $leap_contentbottom_sidebar_spacing[ 'unit' ] : 'px';
        ?>
            #content-bottom-sidebar .container-fluid, #content-bottom-sidebar > .container {
        <?php if ( isset( $leap_contentbottom_sidebar_spacing[ 'top' ] ) && strlen( $leap_contentbottom_sidebar_spacing[ 'top' ] ) > 0 ) { ?>
                    padding-top: <?php echo $leap_contentbottom_sidebar_spacing[ 'top' ] . $leap_contentbottom_sidebar_spacing_unit; ?>;
        <?php } ?>
        <?php if ( isset( $leap_contentbottom_sidebar_spacing[ 'bottom' ] ) && strlen( $leap_contentbottom_sidebar_spacing[ 'bottom' ] ) > 0 ) { ?>
                    padding-bottom: <?php echo $leap_contentbottom_sidebar_spacing[ 'bottom' ] . $leap_contentbottom_sidebar_spacing_unit; ?>;
        <?php } ?>
            }


            /***** main-content-bottom-sidebar  *****/
            #main-content-bottom-sidebar {
        <?php echo leap_get_post_background_value( 'leap_maincontentbottom_sidebar_background', $sidebar_id ); ?>
        <?php
        $leap_maincontentbottom_sidebar_top_border      = (array) leap_get_post_option_value( 'leap_maincontentbottom_sidebar_top_border', $sidebar_id );
        $leap_maincontentbottom_sidebar_top_border_unit = (!empty( $leap_maincontentbottom_sidebar_top_border[ 'unit' ] )) ? $leap_maincontentbottom_sidebar_top_border[ 'unit' ] : 'px';

        if ( !empty( $leap_maincontentbottom_sidebar_top_border[ 'color' ] ) ) {
            ?>
                    border-top-color: <?php echo $leap_maincontentbottom_sidebar_top_border[ 'color' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_maincontentbottom_sidebar_top_border[ 'style' ] ) ) { ?>
                    border-top-style: <?php echo $leap_maincontentbottom_sidebar_top_border[ 'style' ]; ?>;
        <?php } ?>
        <?php if ( isset( $leap_maincontentbottom_sidebar_top_border[ 'width' ] ) && strlen( $leap_maincontentbottom_sidebar_top_border[ 'width' ] ) > 0 ) { ?>
                    border-top-width: <?php echo $leap_maincontentbottom_sidebar_top_border[ 'width' ] . $leap_maincontentbottom_sidebar_top_border_unit; ?>;
        <?php } ?>

        <?php
        $leap_maincontentbottom_sidebar_bottom_border      = (array) leap_get_post_option_value( 'leap_maincontentbottom_sidebar_bottom_border', $sidebar_id );
        $leap_maincontentbottom_sidebar_bottom_border_unit = (!empty( $leap_maincontentbottom_sidebar_bottom_border[ 'unit' ] )) ? $leap_maincontentbottom_sidebar_bottom_border[ 'unit' ] : 'px';

        if ( !empty( $leap_maincontentbottom_sidebar_bottom_border[ 'color' ] ) ) {
            ?>
                    border-bottom-color: <?php echo $leap_maincontentbottom_sidebar_bottom_border[ 'color' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_maincontentbottom_sidebar_bottom_border[ 'style' ] ) ) { ?>
                    border-bottom-style: <?php echo $leap_maincontentbottom_sidebar_bottom_border[ 'style' ]; ?>;
        <?php } ?>
        <?php if ( isset( $leap_maincontentbottom_sidebar_bottom_border[ 'width' ] ) && strlen( $leap_maincontentbottom_sidebar_bottom_border[ 'width' ] ) > 0 ) { ?>
                    border-bottom-width: <?php echo $leap_maincontentbottom_sidebar_bottom_border[ 'width' ] . $leap_maincontentbottom_sidebar_bottom_border_unit; ?>;
        <?php } ?>

            }
            #main-content-bottom-sidebar, #main-content-bottom-sidebar div, #main-content-bottom-sidebar p, #main-content-bottom-sidebar li {
        <?php echo leap_get_post_typography_value( 'leap_maincontentbottom_sidebar_typography', $sidebar_id ); ?>
            }
            #main-content-bottom-sidebar .widget-title, #main-content-bottom-sidebar h4.widget-title {
        <?php echo leap_get_post_typography_value( 'leap_maincontentbottom_sidebar_widget_title_typography', $sidebar_id ); ?>
            }
            #main-content-bottom-sidebar .widget span.date, #main-content-bottom-sidebar .widget small.small, #main-content-bottom-sidebar .widget_recent_entries ul li span.post-date, #main-content-bottom-sidebar .widget.woocommerce ul li del, #main-content-bottom-sidebar .widget.woocommerce ul li del span.amount {
                color: <?php echo leap_get_post_option_value( 'leap_maincontentbottom_sidebar_meta_color', $sidebar_id ); ?>;
            }

        <?php
        $leap_maincontentbottom_sidebar_links_color = (array) leap_get_post_option_value( 'leap_maincontentbottom_sidebar_links_color', $sidebar_id );
        ?>
            #main-content-bottom-sidebar a {
        <?php if ( !empty( $leap_maincontentbottom_sidebar_links_color[ 'link' ] ) ) { ?>
                    color: <?php echo $leap_maincontentbottom_sidebar_links_color[ 'link' ]; ?>;
        <?php } ?>
            }
            #main-content-bottom-sidebar a:hover {
        <?php if ( !empty( $leap_maincontentbottom_sidebar_links_color[ 'hover' ] ) ) { ?>
                    color: <?php echo $leap_maincontentbottom_sidebar_links_color[ 'hover' ]; ?>;
        <?php } ?>
            }
            #main-content-bottom-sidebar .widget ul li {
        <?php
        $leap_maincontentbottom_sidebar_list_divider_color = leap_get_post_option_value( 'leap_maincontentbottom_sidebar_list_divider_color', $sidebar_id );
        if ( $leap_maincontentbottom_sidebar_list_divider_color ) :
            ?>
                    border-color: <?php echo $leap_maincontentbottom_sidebar_list_divider_color; ?>;
        <?php endif; ?>
            }

        <?php
        $leap_maincontentbottom_sidebar_button_color_options = (array) leap_get_post_option_value( 'leap_maincontentbottom_sidebar_button_color_options', $sidebar_id );
        ?>
            #main-content-bottom-sidebar .btn-leap, #main-content-bottom-sidebar .btn-leap:hover, #main-content-bottom-sidebar .btn-leap:focus, #main-content-bottom-sidebar .btn-leap.disabled, #main-content-bottom-sidebar .btn-leap[disabled], #main-content-bottom-sidebar a.btn-leap, #main-content-bottom-sidebar a.btn-leap:hover, #main-content-bottom-sidebar a.btn-leap:focus, #main-content-bottom-sidebar .widget a.btn-leap, #main-content-bottom-sidebar .widget a.btn-leap:hover, #main-content-bottom-sidebar .widget a.btn-leap:focus, #main-content-bottom-sidebar input[type="submit"], #main-content-bottom-sidebar input[type="reset"], #main-content-bottom-sidebar input[type="button"], #main-content-bottom-sidebar input[type="submit"]:hover, #main-content-bottom-sidebar input[type="reset"]:hover, #main-content-bottom-sidebar input[type="button"]:hover, #main-content-bottom-sidebar input[type="submit"]:focus, #main-content-bottom-sidebar input[type="reset"]:focus, #main-content-bottom-sidebar input[type="button"]:focus {
        <?php if ( !empty( $leap_maincontentbottom_sidebar_button_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_maincontentbottom_sidebar_button_color_options[ 'text' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_maincontentbottom_sidebar_button_color_options[ 'bg' ] ) ) { ?>
                    background-color: <?php echo $leap_maincontentbottom_sidebar_button_color_options[ 'bg' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_maincontentbottom_sidebar_button_color_options[ 'border' ] ) ) { ?>
                    border-color: <?php echo $leap_maincontentbottom_sidebar_button_color_options[ 'border' ]; ?>;
        <?php } ?>

            }

            #main-content-bottom-sidebar .btn-leap:hover, #main-content-bottom-sidebar .btn-leap:focus, #main-content-bottom-sidebar a.btn-leap:hover, #main-content-bottom-sidebar a.btn-leap:focus, #main-content-bottom-sidebar .widget a.btn-leap:hover, #main-content-bottom-sidebar .widget a.btn-leap:focus, #main-content-bottom-sidebar input[type="submit"]:hover, #main-content-bottom-sidebar input[type="reset"]:hover, #main-content-bottom-sidebar input[type="button"]:hover, #main-content-bottom-sidebar input[type="submit"]:focus, #main-content-bottom-sidebar input[type="reset"]:focus, #main-content-bottom-sidebar input[type="button"]:focus {
        <?php if ( !empty( $leap_maincontentbottom_sidebar_button_color_options[ 'bg-hover' ] ) ) { ?>
                    background-color: <?php echo $leap_maincontentbottom_sidebar_button_color_options[ 'bg-hover' ]; ?>;
        <?php } ?>
            }

            #main-content-bottom-sidebar .btn-leap, #main-content-bottom-sidebar .btn-leap:hover, #main-content-bottom-sidebar .btn-leap:focus, #main-content-bottom-sidebar .btn-leap.disabled, #main-content-bottom-sidebar .btn-leap[disabled], #main-content-bottom-sidebar a.btn-leap, #main-content-bottom-sidebar a.btn-leap:hover, #main-content-bottom-sidebar a.btn-leap:focus, #main-content-bottom-sidebar .widget a.btn-leap, #main-content-bottom-sidebar .widget a.btn-leap:hover, #main-content-bottom-sidebar .widget a.btn-leap:focus, #main-content-bottom-sidebar input[type="submit"], #main-content-bottom-sidebar input[type="reset"], #main-content-bottom-sidebar input[type="button"], #main-content-bottom-sidebar input[type="submit"]:hover, #main-content-bottom-sidebar input[type="reset"]:hover, #main-content-bottom-sidebar input[type="button"]:hover, #main-content-bottom-sidebar input[type="submit"]:focus, #main-content-bottom-sidebar input[type="reset"]:focus, #main-content-bottom-sidebar input[type="button"]:focus  {
        <?php if ( leap_get_sidebar_option_with_default( 'leap_maincontentbottom_sidebar_button_radius', $sidebar_id ) == 'on' ) : ?>
                    border-radius: 3px;
                    -webkit-border-radius: 3px;
        <?php endif; ?>
        <?php if ( leap_get_sidebar_option_with_default( 'leap_maincontentbottom_sidebar_button_radius', $sidebar_id ) == 'off' ) : ?>
                    border-radius: 0;
                    -webkit-border-radius: 0;
        <?php endif; ?>
            }

        <?php
        $leap_maincontentbottom_sidebar_input_color_options = (array) leap_get_post_option_value( 'leap_maincontentbottom_sidebar_input_color_options', $sidebar_id );
        ?>
            #main-content-bottom-sidebar input[type="text"], #main-content-bottom-sidebar input[type="text"]:focus, #main-content-bottom-sidebar .form-control, #main-content-bottom-sidebar .form-control:focus, #main-content-bottom-sidebar textarea, #main-content-bottom-sidebar textarea:focus, #main-content-bottom-sidebar input[type="password"], #main-content-bottom-sidebar input[type="password"]:focus, #main-content-bottom-sidebar .widget_search .input-group-addon:last-child, #main-content-bottom-sidebar .leap-search-form .input-group-addon:last-child, #main-content-bottom-sidebar input[type="email"], #main-content-bottom-sidebar input[type="date"], #main-content-bottom-sidebar input[type="number"], #main-content-bottom-sidebar input[type="email"]:focus, #main-content-bottom-sidebar input[type="date"]:focus, #main-content-bottom-sidebar input[type="number"]:focus {
        <?php if ( !empty( $leap_maincontentbottom_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_maincontentbottom_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_maincontentbottom_sidebar_input_color_options[ 'bg' ] ) ) { ?>
                    background-color: <?php echo $leap_maincontentbottom_sidebar_input_color_options[ 'bg' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_maincontentbottom_sidebar_input_color_options[ 'border' ] ) ) { ?>
                    border-color: <?php echo $leap_maincontentbottom_sidebar_input_color_options[ 'border' ]; ?>;
        <?php } ?>
            }
            #main-content-bottom-sidebar input:focus:invalid:focus, #main-content-bottom-sidebar textarea:focus:invalid:focus, #main-content-bottom-sidebar select:focus:invalid:focus  {
        <?php if ( !empty( $leap_maincontentbottom_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_maincontentbottom_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_maincontentbottom_sidebar_input_color_options[ 'bg' ] ) ) { ?>
                    background-color: <?php echo $leap_maincontentbottom_sidebar_input_color_options[ 'bg' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_maincontentbottom_sidebar_input_color_options[ 'border' ] ) ) { ?>
                    border-color: <?php echo $leap_maincontentbottom_sidebar_input_color_options[ 'border' ]; ?>;
        <?php } ?>
            }
            #main-content-bottom-sidebar .form-control::-moz-placeholder {
        <?php if ( !empty( $leap_maincontentbottom_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_maincontentbottom_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
            }
            #main-content-bottom-sidebar .form-control:-ms-input-placeholder {
        <?php if ( !empty( $leap_maincontentbottom_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_maincontentbottom_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
            }
            #main-content-bottom-sidebar .form-control::-webkit-input-placeholder {
        <?php if ( !empty( $leap_maincontentbottom_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_maincontentbottom_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
            }

        <?php
        $leap_maincontentbottom_sidebar_spacing      = (array) leap_get_post_option_value( 'leap_maincontentbottom_sidebar_spacing', $sidebar_id );
        $leap_maincontentbottom_sidebar_spacing_unit = (!empty( $leap_maincontentbottom_sidebar_spacing[ 'unit' ] )) ? $leap_maincontentbottom_sidebar_spacing[ 'unit' ] : 'px';
        ?>
            #main-content-bottom-sidebar .container-fluid, #main-content-bottom-sidebar > .container {
        <?php if ( isset( $leap_maincontentbottom_sidebar_spacing[ 'top' ] ) && strlen( $leap_maincontentbottom_sidebar_spacing[ 'top' ] ) > 0 ) { ?>
                    padding-top: <?php echo $leap_maincontentbottom_sidebar_spacing[ 'top' ] . $leap_maincontentbottom_sidebar_spacing_unit; ?>;
        <?php } ?>
        <?php if ( isset( $leap_maincontentbottom_sidebar_spacing[ 'bottom' ] ) && strlen( $leap_maincontentbottom_sidebar_spacing[ 'bottom' ] ) > 0 ) { ?>
                    padding-bottom: <?php echo $leap_maincontentbottom_sidebar_spacing[ 'bottom' ] . $leap_maincontentbottom_sidebar_spacing_unit; ?>;
        <?php } ?>
            }


            /***** footer-full-width-sidebar  *****/
            #footer-full-width-sidebar {
        <?php echo leap_get_post_background_value( 'leap_footerfull_sidebar_background', $sidebar_id ); ?>
        <?php
        $leap_footerfull_sidebar_top_border      = (array) leap_get_post_option_value( 'leap_footerfull_sidebar_top_border', $sidebar_id );
        $leap_footerfull_sidebar_top_border_unit = (!empty( $leap_footerfull_sidebar_top_border[ 'unit' ] )) ? $leap_footerfull_sidebar_top_border[ 'unit' ] : 'px';

        if ( !empty( $leap_footerfull_sidebar_top_border[ 'color' ] ) ) {
            ?>
                    border-top-color: <?php echo $leap_footerfull_sidebar_top_border[ 'color' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_footerfull_sidebar_top_border[ 'style' ] ) ) { ?>
                    border-top-style: <?php echo $leap_footerfull_sidebar_top_border[ 'style' ]; ?>;
        <?php } ?>
        <?php if ( isset( $leap_footerfull_sidebar_top_border[ 'width' ] ) && strlen( $leap_footerfull_sidebar_top_border[ 'width' ] ) > 0 ) { ?>
                    border-top-width: <?php echo $leap_footerfull_sidebar_top_border[ 'width' ] . $leap_footerfull_sidebar_top_border_unit; ?>;
        <?php } ?>

        <?php
        $leap_footerfull_sidebar_bottom_border      = (array) leap_get_post_option_value( 'leap_footerfull_sidebar_bottom_border', $sidebar_id );
        $leap_footerfull_sidebar_bottom_border_unit = (!empty( $leap_footerfull_sidebar_bottom_border[ 'unit' ] )) ? $leap_footerfull_sidebar_bottom_border[ 'unit' ] : 'px';

        if ( !empty( $leap_footerfull_sidebar_bottom_border[ 'color' ] ) ) {
            ?>
                    border-bottom-color: <?php echo $leap_footerfull_sidebar_bottom_border[ 'color' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_footerfull_sidebar_bottom_border[ 'style' ] ) ) { ?>
                    border-bottom-style: <?php echo $leap_footerfull_sidebar_bottom_border[ 'style' ]; ?>;
        <?php } ?>
        <?php if ( isset( $leap_footerfull_sidebar_bottom_border[ 'width' ] ) && strlen( $leap_footerfull_sidebar_bottom_border[ 'width' ] ) > 0 ) { ?>
                    border-bottom-width: <?php echo $leap_footerfull_sidebar_bottom_border[ 'width' ] . $leap_footerfull_sidebar_bottom_border_unit; ?>;
        <?php } ?>
            }

            #footer-full-width-sidebar, #footer-full-width-sidebar div, #footer-full-width-sidebar p, #footer-full-width-sidebar li , #footer-full-width-sidebar h1 , #footer-full-width-sidebar h2, #footer-full-width-sidebar h3{
        <?php echo leap_get_post_typography_value( 'leap_footerfull_sidebar_typography', $sidebar_id ); ?>
            }
            #footer-full-width-sidebar .widget-title, #footer-full-width-sidebar h4.widget-title {
        <?php echo leap_get_post_typography_value( 'leap_footerfull_sidebar_widget_title_typography', $sidebar_id ); ?>
            }
            #footer-full-width-sidebar .widget span.date, #footer-full-width-sidebar .widget small.small, #footer-full-width-sidebar .widget_recent_entries ul li span.post-date, #footer-full-width-sidebar .widget.woocommerce ul li del, #footer-full-width-sidebar .widget.woocommerce ul li del span.amount {
                color: <?php echo leap_get_post_option_value( 'leap_footerfull_sidebar_meta_color', $sidebar_id ); ?>;
            }

        <?php
        $leap_footerfull_sidebar_links_color = (array) leap_get_post_option_value( 'leap_footerfull_sidebar_links_color', $sidebar_id );
        ?>
            #footer-full-width-sidebar a, #leap-footer #inner-footer #footer-full-width-sidebar a, #leap-footer #inner-footer #footer-full-width-sidebar a:visited, #leap-footer #inner-footer #footer-full-width-sidebar .widget a, #leap-footer #inner-footer #footer-full-width-sidebar div.widget_recent_entries ul li span, #leap-footer #inner-footer #footer-full-width-sidebar div.widget_rss ul li span.rss-date, #leap-footer #inner-footer #footer-full-width-sidebar .widget span.date {
        <?php if ( !empty( $leap_footerfull_sidebar_links_color[ 'link' ] ) ) { ?>
                    color: <?php echo $leap_footerfull_sidebar_links_color[ 'link' ]; ?>;
        <?php } ?>
            }
            #footer-full-width-sidebar a:hover, #leap-footer #inner-footer #footer-full-width-sidebar a:hover, #leap-footer #inner-footer #footer-full-width-sidebar .widget a:hover {
        <?php if ( !empty( $leap_footerfull_sidebar_links_color[ 'hover' ] ) ) { ?>
                    color: <?php echo $leap_footerfull_sidebar_links_color[ 'hover' ]; ?>;
        <?php } ?>
            }

            #footer-full-width-sidebar .widget ul li {
        <?php
        $leap_footerfull_sidebar_list_divider_color = leap_get_post_option_value( 'leap_footerfull_sidebar_list_divider_color', $sidebar_id );
        if ( $leap_footerfull_sidebar_list_divider_color ) :
            ?>
                    border-color: <?php echo $leap_footerfull_sidebar_list_divider_color; ?>;
        <?php endif; ?>
            }

        <?php
        $leap_footerfull_sidebar_button_color_options = (array) leap_get_post_option_value( 'leap_footerfull_sidebar_button_color_options', $sidebar_id );
        ?>
            #footer-full-width-sidebar .btn-leap, #footer-full-width-sidebar .btn-leap:hover, #footer-full-width-sidebar .btn-leap:focus, #footer-full-width-sidebar .btn-leap.disabled, #footer-full-width-sidebar .btn-leap[disabled], #footer-full-width-sidebar a.btn-leap, #footer-full-width-sidebar a.btn-leap:hover, #footer-full-width-sidebar a.btn-leap:focus, #footer-full-width-sidebar .widget a.btn-leap, #footer-full-width-sidebar .widget a.btn-leap:hover, #footer-full-width-sidebar .widget a.btn-leap:focus , #footer-full-width-sidebar input[type="submit"], #footer-full-width-sidebar input[type="reset"], #footer-full-width-sidebar input[type="button"], #footer-full-width-sidebar input[type="submit"]:hover, #footer-full-width-sidebar input[type="reset"]:hover, #footer-full-width-sidebar input[type="button"]:hover, #footer-full-width-sidebar input[type="submit"]:focus, #footer-full-width-sidebar input[type="reset"]:focus, #footer-full-width-sidebar input[type="button"]:focus {
        <?php if ( !empty( $leap_footerfull_sidebar_button_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_footerfull_sidebar_button_color_options[ 'text' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_footerfull_sidebar_button_color_options[ 'bg' ] ) ) { ?>
                    background-color: <?php echo $leap_footerfull_sidebar_button_color_options[ 'bg' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_footerfull_sidebar_button_color_options[ 'border' ] ) ) { ?>
                    border-color: <?php echo $leap_footerfull_sidebar_button_color_options[ 'border' ]; ?>;
        <?php } ?>
            }

            #footer-full-width-sidebar .btn-leap:hover, #footer-full-width-sidebar .btn-leap:focus, #footer-full-width-sidebar a.btn-leap:hover, #footer-full-width-sidebar a.btn-leap:focus, #footer-full-width-sidebar .widget a.btn-leap:hover, #footer-full-width-sidebar .widget a.btn-leap:focus, #footer-full-width-sidebar input[type="submit"]:hover, #footer-full-width-sidebar input[type="reset"]:hover, #footer-full-width-sidebar input[type="button"]:hover, #footer-full-width-sidebar input[type="submit"]:focus, #footer-full-width-sidebar input[type="reset"]:focus, #footer-full-width-sidebar input[type="button"]:focus {
        <?php if ( !empty( $leap_footerfull_sidebar_button_color_options[ 'bg-hover' ] ) ) { ?>
                    background-color: <?php echo $leap_footerfull_sidebar_button_color_options[ 'bg-hover' ]; ?>;
        <?php } ?>
            }

            #footer-full-width-sidebar .btn-leap, #footer-full-width-sidebar .btn-leap:hover, #footer-full-width-sidebar .btn-leap:focus, #footer-full-width-sidebar .btn-leap.disabled, #footer-full-width-sidebar .btn-leap[disabled], #footer-full-width-sidebar a.btn-leap, #footer-full-width-sidebar a.btn-leap:hover, #footer-full-width-sidebar a.btn-leap:focus, #footer-full-width-sidebar .widget a.btn-leap, #footer-full-width-sidebar .widget a.btn-leap:hover, #footer-full-width-sidebar .widget a.btn-leap:focus, #footer-full-width-sidebar input[type="submit"], #footer-full-width-sidebar input[type="reset"], #footer-full-width-sidebar input[type="button"], #footer-full-width-sidebar input[type="submit"]:hover, #footer-full-width-sidebar input[type="reset"]:hover, #footer-full-width-sidebar input[type="button"]:hover, #footer-full-width-sidebar input[type="submit"]:focus, #footer-full-width-sidebar input[type="reset"]:focus, #footer-full-width-sidebar input[type="button"]:focus {
        <?php if ( leap_get_sidebar_option_with_default( 'leap_footerfull_sidebar_button_radius', $sidebar_id ) == 'on' ) : ?>
                    border-radius: 3px;
                    -webkit-border-radius: 3px;
        <?php endif; ?>
        <?php if ( leap_get_sidebar_option_with_default( 'leap_footerfull_sidebar_button_radius', $sidebar_id ) == 'off' ) : ?>
                    border-radius: 0;
                    -webkit-border-radius: 0;
        <?php endif; ?>
            }


        <?php
        $leap_footerfull_sidebar_input_color_options = (array) leap_get_post_option_value( 'leap_footerfull_sidebar_input_color_options', $sidebar_id );
        ?>
            #footer-full-width-sidebar input[type="text"], #footer-full-width-sidebar input[type="text"]:focus, #footer-full-width-sidebar .form-control, #footer-full-width-sidebar .form-control:focus, #footer-full-width-sidebar textarea, #footer-full-width-sidebar textarea:focus, #footer-full-width-sidebar input[type="password"], #footer-full-width-sidebar input[type="password"]:focus, #footer-full-width-sidebar .widget_search .input-group-addon:last-child, #footer-full-width-sidebar .leap-search-form .input-group-addon:last-child, #footer-full-width-sidebar input[type="email"], #footer-full-width-sidebar input[type="date"], #footer-full-width-sidebar input[type="number"], #footer-full-width-sidebar input[type="email"]:focus, #footer-full-width-sidebar input[type="date"]:focus, #footer-full-width-sidebar input[type="number"]:focus {
        <?php if ( !empty( $leap_footerfull_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_footerfull_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_footerfull_sidebar_input_color_options[ 'bg' ] ) ) { ?>
                    background-color: <?php echo $leap_footerfull_sidebar_input_color_options[ 'bg' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_footerfull_sidebar_input_color_options[ 'border' ] ) ) { ?>
                    border-color: <?php echo $leap_footerfull_sidebar_input_color_options[ 'border' ]; ?>;
        <?php } ?>
            }
            #footer-full-width-sidebar input:focus:invalid:focus, #footer-full-width-sidebar textarea:focus:invalid:focus, #footer-full-width-sidebar select:focus:invalid:focus  {
        <?php if ( !empty( $leap_footerfull_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_footerfull_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_footerfull_sidebar_input_color_options[ 'bg' ] ) ) { ?>
                    background-color: <?php echo $leap_footerfull_sidebar_input_color_options[ 'bg' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_footerfull_sidebar_input_color_options[ 'border' ] ) ) { ?>
                    border-color: <?php echo $leap_footerfull_sidebar_input_color_options[ 'border' ]; ?>;
        <?php } ?>
            }

            #footer-full-width-sidebar .form-control::-moz-placeholder {
        <?php if ( !empty( $leap_footerfull_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_footerfull_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
            }
            #footer-full-width-sidebar .form-control:-ms-input-placeholder {
        <?php if ( !empty( $leap_footerfull_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_footerfull_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
            }
            #footer-full-width-sidebar .form-control::-webkit-input-placeholder {
        <?php if ( !empty( $leap_footerfull_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_footerfull_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
            }

        <?php
        $leap_footerfull_sidebar_spacing      = (array) leap_get_post_option_value( 'leap_footerfull_sidebar_spacing', $sidebar_id );
        $leap_footerfull_sidebar_spacing_unit = (!empty( $leap_footerfull_sidebar_spacing[ 'unit' ] )) ? $leap_footerfull_sidebar_spacing[ 'unit' ] : 'px';
        ?>
            #footer-full-width-sidebar .container-fluid, #footer-full-width-sidebar > .container {
        <?php if ( isset( $leap_footerfull_sidebar_spacing[ 'top' ] ) && strlen( $leap_footerfull_sidebar_spacing[ 'top' ] ) > 0 ) { ?>
                    padding-top: <?php echo $leap_footerfull_sidebar_spacing[ 'top' ] . $leap_footerfull_sidebar_spacing_unit; ?>;
        <?php } ?>
        <?php if ( isset( $leap_footerfull_sidebar_spacing[ 'bottom' ] ) && strlen( $leap_footerfull_sidebar_spacing[ 'bottom' ] ) > 0 ) { ?>
                    padding-bottom: <?php echo $leap_footerfull_sidebar_spacing[ 'bottom' ] . $leap_footerfull_sidebar_spacing_unit; ?>;
        <?php } ?>
            }


            /***** main-bottom-sidebar  *****/
            #main-bottom-sidebar {
        <?php echo leap_get_post_background_value( 'leap_mainbottom_sidebar_background', $sidebar_id ); ?>
        <?php
        $leap_mainbottom_sidebar_top_border      = (array) leap_get_post_option_value( 'leap_mainbottom_sidebar_top_border', $sidebar_id );
        $leap_mainbottom_sidebar_top_border_unit = (!empty( $leap_mainbottom_sidebar_top_border[ 'unit' ] )) ? $leap_mainbottom_sidebar_top_border[ 'unit' ] : 'px';

        if ( !empty( $leap_mainbottom_sidebar_top_border[ 'color' ] ) ) {
            ?>
                    border-top-color: <?php echo $leap_mainbottom_sidebar_top_border[ 'color' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_mainbottom_sidebar_top_border[ 'style' ] ) ) { ?>
                    border-top-style: <?php echo $leap_mainbottom_sidebar_top_border[ 'style' ]; ?>;
        <?php } ?>
        <?php if ( isset( $leap_mainbottom_sidebar_top_border[ 'width' ] ) && strlen( $leap_mainbottom_sidebar_top_border[ 'width' ] ) > 0 ) { ?>
                    border-top-width: <?php echo $leap_mainbottom_sidebar_top_border[ 'width' ] . $leap_mainbottom_sidebar_top_border_unit; ?>;
        <?php } ?>

        <?php
        $leap_mainbottom_sidebar_bottom_border      = (array) leap_get_post_option_value( 'leap_mainbottom_sidebar_bottom_border', $sidebar_id );
        $leap_mainbottom_sidebar_bottom_border_unit = (!empty( $leap_mainbottom_sidebar_bottom_border[ 'unit' ] )) ? $leap_mainbottom_sidebar_bottom_border[ 'unit' ] : 'px';

        if ( !empty( $leap_mainbottom_sidebar_bottom_border[ 'color' ] ) ) {
            ?>
                    border-bottom-color: <?php echo $leap_mainbottom_sidebar_bottom_border[ 'color' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_mainbottom_sidebar_bottom_border[ 'style' ] ) ) { ?>
                    border-bottom-style: <?php echo $leap_mainbottom_sidebar_bottom_border[ 'style' ]; ?>;
        <?php } ?>
        <?php if ( isset( $leap_mainbottom_sidebar_bottom_border[ 'width' ] ) && strlen( $leap_mainbottom_sidebar_bottom_border[ 'width' ] ) > 0 ) { ?>
                    border-bottom-width: <?php echo $leap_mainbottom_sidebar_bottom_border[ 'width' ] . $leap_mainbottom_sidebar_bottom_border_unit; ?>;
        <?php } ?>
            }


            #main-bottom-sidebar, #main-bottom-sidebar div, #main-bottom-sidebar p, #main-bottom-sidebar li {
        <?php echo leap_get_post_typography_value( 'leap_mainbottom_sidebar_typography', $sidebar_id ); ?>
            }
            #main-bottom-sidebar .widget-title, #main-bottom-sidebar h4.widget-title {
        <?php echo leap_get_post_typography_value( 'leap_mainbottom_sidebar_widget_title_typography', $sidebar_id ); ?>
            }
            #main-bottom-sidebar .widget span.date, #main-bottom-sidebar .widget small.small, #main-bottom-sidebar .widget_recent_entries ul li span.post-date, #main-bottom-sidebar .widget.woocommerce ul li del, #main-bottom-sidebar .widget.woocommerce ul li del span.amount {
                color: <?php echo leap_get_post_option_value( 'leap_mainbottom_sidebar_meta_color', $sidebar_id ); ?>;
            }

        <?php
        $leap_mainbottom_sidebar_links_color = (array) leap_get_post_option_value( 'leap_mainbottom_sidebar_links_color', $sidebar_id );
        ?>
            #main-bottom-sidebar a, #leap-footer #inner-footer #main-bottom-sidebar a, #leap-footer #inner-footer #main-bottom-sidebar a:visited, #leap-footer #inner-footer #main-bottom-sidebar .widget a ,  #leap-footer #inner-footer #main-bottom-sidebar div.widget_recent_entries ul li span,  #leap-footer #inner-footer #main-bottom-sidebar div.widget_rss ul li span.rss-date,  #leap-footer #inner-footer #main-bottom-sidebar .widget span.date {
        <?php if ( !empty( $leap_mainbottom_sidebar_links_color[ 'link' ] ) ) { ?>
                    color: <?php echo $leap_mainbottom_sidebar_links_color[ 'link' ]; ?>;
        <?php } ?>
            }
            #main-bottom-sidebar a:hover, #leap-footer #inner-footer #main-bottom-sidebar a:hover, #leap-footer #inner-footer #main-bottom-sidebar .widget a:hover {
        <?php if ( !empty( $leap_mainbottom_sidebar_links_color[ 'hover' ] ) ) { ?>
                    color: <?php echo $leap_mainbottom_sidebar_links_color[ 'hover' ]; ?>;
        <?php } ?>
            }

            #main-bottom-sidebar .widget ul li {
        <?php
        $leap_mainbottom_sidebar_list_divider_color = leap_get_post_option_value( 'leap_mainbottom_sidebar_list_divider_color', $sidebar_id );
        if ( $leap_mainbottom_sidebar_list_divider_color ) :
            ?>
                    border-color: <?php echo $leap_mainbottom_sidebar_list_divider_color; ?>;
        <?php endif; ?>
            }

        <?php
        $leap_mainbottom_sidebar_button_color_options = (array) leap_get_post_option_value( 'leap_mainbottom_sidebar_button_color_options', $sidebar_id );
        ?>
            #main-bottom-sidebar .btn-leap, #main-bottom-sidebar .btn-leap:hover, #main-bottom-sidebar .btn-leap:focus, #main-bottom-sidebar .btn-leap.disabled, #main-bottom-sidebar .btn-leap[disabled], #main-bottom-sidebar a.btn-leap, #main-bottom-sidebar a.btn-leap:hover, #main-bottom-sidebar a.btn-leap:focus, #main-bottom-sidebar .widget a.btn-leap, #main-bottom-sidebar .widget a.btn-leap:hover, #main-bottom-sidebar .widget a.btn-leap:focus, #main-bottom-sidebar input[type="submit"], #main-bottom-sidebar input[type="reset"], #main-bottom-sidebar input[type="button"], #main-bottom-sidebar input[type="submit"]:hover, #main-bottom-sidebar input[type="reset"]:hover, #main-bottom-sidebar input[type="button"]:hover, #main-bottom-sidebar input[type="submit"]:focus, #main-bottom-sidebar input[type="reset"]:focus, #main-bottom-sidebar input[type="button"]:focus {
        <?php if ( !empty( $leap_mainbottom_sidebar_button_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_mainbottom_sidebar_button_color_options[ 'text' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_mainbottom_sidebar_button_color_options[ 'bg' ] ) ) { ?>
                    background-color: <?php echo $leap_mainbottom_sidebar_button_color_options[ 'bg' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_mainbottom_sidebar_button_color_options[ 'border' ] ) ) { ?>
                    border-color: <?php echo $leap_mainbottom_sidebar_button_color_options[ 'border' ]; ?>;
        <?php } ?>
            }

            #main-bottom-sidebar .btn-leap:hover, #main-bottom-sidebar .btn-leap:focus, #main-bottom-sidebar a.btn-leap:hover, #main-bottom-sidebar a.btn-leap:focus, #main-bottom-sidebar .widget a.btn-leap:hover, #main-bottom-sidebar .widget a.btn-leap:focus, #main-bottom-sidebar input[type="submit"]:hover, #main-bottom-sidebar input[type="reset"]:hover, #main-bottom-sidebar input[type="button"]:hover, #main-bottom-sidebar input[type="submit"]:focus, #main-bottom-sidebar input[type="reset"]:focus, #main-bottom-sidebar input[type="button"]:focus {
        <?php if ( !empty( $leap_mainbottom_sidebar_button_color_options[ 'bg-hover' ] ) ) { ?>
                    background-color: <?php echo $leap_mainbottom_sidebar_button_color_options[ 'bg-hover' ]; ?>;
        <?php } ?>
            }

            #main-bottom-sidebar .btn-leap, #main-bottom-sidebar .btn-leap:hover, #main-bottom-sidebar .btn-leap:focus, #main-bottom-sidebar .btn-leap.disabled, #main-bottom-sidebar .btn-leap[disabled], #main-bottom-sidebar a.btn-leap, #main-bottom-sidebar a.btn-leap:hover, #main-bottom-sidebar a.btn-leap:focus, #main-bottom-sidebar .widget a.btn-leap, #main-bottom-sidebar .widget a.btn-leap:hover, #main-bottom-sidebar .widget a.btn-leap:focus, #main-bottom-sidebar input[type="submit"], #main-bottom-sidebar input[type="reset"], #main-bottom-sidebar input[type="button"], #main-bottom-sidebar input[type="submit"]:hover, #main-bottom-sidebar input[type="reset"]:hover, #main-bottom-sidebar input[type="button"]:hover, #main-bottom-sidebar input[type="submit"]:focus, #main-bottom-sidebar input[type="reset"]:focus, #main-bottom-sidebar input[type="button"]:focus {
        <?php if ( leap_get_sidebar_option_with_default( 'leap_mainbottom_sidebar_button_radius', $sidebar_id ) == 'on' ) : ?>
                    border-radius: 3px;
                    -webkit-border-radius: 3px;
        <?php endif; ?>
        <?php if ( leap_get_sidebar_option_with_default( 'leap_mainbottom_sidebar_button_radius', $sidebar_id ) == 'off' ) : ?>
                    border-radius: 0;
                    -webkit-border-radius: 0;
        <?php endif; ?>

            }

        <?php
        $leap_mainbottom_sidebar_input_color_options = (array) leap_get_post_option_value( 'leap_mainbottom_sidebar_input_color_options', $sidebar_id );
        ?>
            #main-bottom-sidebar input[type="text"], #main-bottom-sidebar input[type="text"]:focus, #main-bottom-sidebar .form-control, #main-bottom-sidebar .form-control:focus, #main-bottom-sidebar textarea, #main-bottom-sidebar textarea:focus, #main-bottom-sidebar input[type="password"], #main-bottom-sidebar input[type="password"]:focus, #main-bottom-sidebar .widget_search .input-group-addon:last-child, #main-bottom-sidebar .leap-search-form .input-group-addon:last-child, #main-bottom-sidebar input[type="email"], #main-bottom-sidebar input[type="date"], #main-bottom-sidebar input[type="number"], #main-bottom-sidebar input[type="email"]:focus, #main-bottom-sidebar input[type="date"]:focus, #main-bottom-sidebar input[type="number"]:focus {
        <?php if ( !empty( $leap_mainbottom_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_mainbottom_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_mainbottom_sidebar_input_color_options[ 'bg' ] ) ) { ?>
                    background-color: <?php echo $leap_mainbottom_sidebar_input_color_options[ 'bg' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_mainbottom_sidebar_input_color_options[ 'border' ] ) ) { ?>
                    border-color: <?php echo $leap_mainbottom_sidebar_input_color_options[ 'border' ]; ?>;
        <?php } ?>
            }
            #main-bottom-sidebar input:focus:invalid:focus, #main-bottom-sidebar textarea:focus:invalid:focus, #main-bottom-sidebar select:focus:invalid:focus  {
        <?php if ( !empty( $leap_mainbottom_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_mainbottom_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_mainbottom_sidebar_input_color_options[ 'bg' ] ) ) { ?>
                    background-color: <?php echo $leap_mainbottom_sidebar_input_color_options[ 'bg' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_mainbottom_sidebar_input_color_options[ 'border' ] ) ) { ?>
                    border-color: <?php echo $leap_mainbottom_sidebar_input_color_options[ 'border' ]; ?>;
        <?php } ?>
            }
            #main-bottom-sidebar .form-control::-moz-placeholder {
        <?php if ( !empty( $leap_mainbottom_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_mainbottom_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
            }
            #main-bottom-sidebar .form-control:-ms-input-placeholder {
        <?php if ( !empty( $leap_mainbottom_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_mainbottom_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
            }
            #main-bottom-sidebar .form-control::-webkit-input-placeholder {
        <?php if ( !empty( $leap_mainbottom_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_mainbottom_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
            }

        <?php
        $leap_mainbottom_sidebar_spacing      = (array) leap_get_post_option_value( 'leap_mainbottom_sidebar_spacing', $sidebar_id );
        $leap_mainbottom_sidebar_spacing_unit = (!empty( $leap_mainbottom_sidebar_spacing[ 'unit' ] )) ? $leap_mainbottom_sidebar_spacing[ 'unit' ] : 'px';
        ?>
            #main-bottom-sidebar .container-fluid, #main-bottom-sidebar > .container {
        <?php if ( isset( $leap_mainbottom_sidebar_spacing[ 'top' ] ) && strlen( $leap_mainbottom_sidebar_spacing[ 'top' ] ) > 0 ) { ?>
                    padding-top: <?php echo $leap_mainbottom_sidebar_spacing[ 'top' ] . $leap_mainbottom_sidebar_spacing_unit; ?>;
        <?php } ?>
        <?php if ( isset( $leap_mainbottom_sidebar_spacing[ 'bottom' ] ) && strlen( $leap_mainbottom_sidebar_spacing[ 'bottom' ] ) > 0 ) { ?>
                    padding-bottom: <?php echo $leap_mainbottom_sidebar_spacing[ 'bottom' ] . $leap_mainbottom_sidebar_spacing_unit; ?>;
        <?php } ?>
            }


            /***** footer-sidebar  *****/
            #footer-sidebar {
        <?php echo leap_get_post_background_value( 'leap_footer_sidebar_background', $sidebar_id ); ?>
        <?php
        $leap_footer_sidebar_top_border      = (array) leap_get_post_option_value( 'leap_footer_sidebar_top_border', $sidebar_id );
        $leap_footer_sidebar_top_border_unit = (!empty( $leap_footer_sidebar_top_border[ 'unit' ] )) ? $leap_footer_sidebar_top_border[ 'unit' ] : 'px';

        if ( !empty( $leap_footer_sidebar_top_border[ 'color' ] ) ) {
            ?>
                    border-top-color: <?php echo $leap_footer_sidebar_top_border[ 'color' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_footer_sidebar_top_border[ 'style' ] ) ) { ?>
                    border-top-style: <?php echo $leap_footer_sidebar_top_border[ 'style' ]; ?>;
        <?php } ?>
        <?php if ( isset( $leap_footer_sidebar_top_border[ 'width' ] ) && strlen( $leap_footer_sidebar_top_border[ 'width' ] ) > 0 ) { ?>
                    border-top-width: <?php echo $leap_footer_sidebar_top_border[ 'width' ] . $leap_footer_sidebar_top_border_unit; ?>;
        <?php } ?>

        <?php
        $leap_footer_sidebar_bottom_border      = (array) leap_get_post_option_value( 'leap_footer_sidebar_bottom_border', $sidebar_id );
        $leap_footer_sidebar_bottom_border_unit = (!empty( $leap_footer_sidebar_bottom_border[ 'unit' ] )) ? $leap_footer_sidebar_bottom_border[ 'unit' ] : 'px';

        if ( !empty( $leap_footer_sidebar_bottom_border[ 'color' ] ) ) {
            ?>
                    border-bottom-color: <?php echo $leap_footer_sidebar_bottom_border[ 'color' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_footer_sidebar_bottom_border[ 'style' ] ) ) { ?>
                    border-bottom-style: <?php echo $leap_footer_sidebar_bottom_border[ 'style' ]; ?>;
        <?php } ?>
        <?php if ( isset( $leap_footer_sidebar_bottom_border[ 'width' ] ) && strlen( $leap_footer_sidebar_bottom_border[ 'width' ] ) > 0 ) { ?>
                    border-bottom-width: <?php echo $leap_footer_sidebar_bottom_border[ 'width' ] . $leap_footer_sidebar_bottom_border_unit; ?>;
        <?php } ?>
            }


            #footer-sidebar, #footer-sidebar div, #footer-sidebar p, #footer-sidebar li , #footer-sidebar div.contact_info .widget-content div i {
        <?php echo leap_get_post_typography_value( 'leap_footer_sidebar_typography', $sidebar_id ); ?>
            }
            #footer-sidebar .widget-title, #footer-sidebar h4.widget-title {
        <?php echo leap_get_post_typography_value( 'leap_footer_sidebar_widget_title_typography', $sidebar_id ); ?>
            }
            #footer-sidebar .widget span.date, #footer-sidebar .widget small.small, #footer-sidebar .widget_recent_entries ul li span.post-date, #footer-sidebar .widget.woocommerce ul li del, #footer-sidebar .widget.woocommerce ul li del span.amount {
                color: <?php echo leap_get_post_option_value( 'leap_footer_sidebar_meta_color', $sidebar_id ); ?>;
            }

        <?php
        $leap_footer_sidebar_links_color = (array) leap_get_post_option_value( 'leap_footer_sidebar_links_color', $sidebar_id );
        ?>
            #footer-sidebar a, #footer-sidebar a:visited, #footer-sidebar .widget a , #footer-sidebar div.widget_recent_entries ul li span, #footer-sidebar div.widget_rss ul li span.rss-date, #footer-sidebar .widget span.date {
        <?php if ( !empty( $leap_footer_sidebar_links_color[ 'link' ] ) ) { ?>
                    color: <?php echo $leap_footer_sidebar_links_color[ 'link' ]; ?>;
        <?php } ?>
            }
            #footer-sidebar a:hover, #footer-sidebar .widget a:hover {
        <?php if ( !empty( $leap_footer_sidebar_links_color[ 'hover' ] ) ) { ?>
                    color: <?php echo $leap_footer_sidebar_links_color[ 'hover' ]; ?>;
        <?php } ?>
            }

            #footer-sidebar .widget ul li, #footer-sidebar .woocommerce ul.product_list_widget li, #footer-sidebar .widget_archive ul li, #footer-sidebar .widget_categories ul li, #footer-sidebar .widget_nav_menu ul li, #footer-sidebar .widget_meta ul li, #footer-sidebar .widget_pages ul li, #footer-sidebar .widget_recent_comments ul li, #footer-sidebar .widget_recent_entries ul li, #footer-sidebar .widget_rss ul li, #footer-sidebar .widget.comments-avatar ul li, #footer-sidebar div.category-posts ul li, #footer-sidebar .widget_author_posts ul li, #footer-sidebar .widget.posts-list ul li, #footer-sidebar .widget.tweets ul li, #footer-sidebar .leap-widget-style3 .widget-head, #footer-sidebar ol.commentlist li {
        <?php
        $leap_footer_sidebar_list_divider_color = leap_get_post_option_value( 'leap_footer_sidebar_list_divider_color', $sidebar_id );
        if ( $leap_footer_sidebar_list_divider_color ) :
            ?>
                    border-color: <?php echo $leap_footer_sidebar_list_divider_color; ?>;
        <?php endif; ?>
            }

        <?php
        $leap_footer_sidebar_button_color_options = (array) leap_get_post_option_value( 'leap_footer_sidebar_button_color_options', $sidebar_id );
        ?>
            #footer-sidebar .btn-leap, #footer-sidebar .btn-leap:hover, #footer-sidebar .btn-leap:focus, #footer-sidebar .btn-leap.disabled, #footer-sidebar .btn-leap[disabled], #footer-sidebar a.btn-leap, #footer-sidebar a.btn-leap:hover, #footer-sidebar a.btn-leap:focus, #footer-sidebar .widget a.btn-leap, #footer-sidebar .widget a.btn-leap:hover, #footer-sidebar .widget a.btn-leap:focus, #footer-sidebar input[type="submit"], #footer-sidebar input[type="reset"], #footer-sidebar input[type="button"], #footer-sidebar input[type="submit"]:hover, #footer-sidebar input[type="reset"]:hover, #footer-sidebar input[type="button"]:hover, #footer-sidebar input[type="submit"]:focus, #footer-sidebar input[type="reset"]:focus, #footer-sidebar input[type="button"]:focus  {
        <?php if ( !empty( $leap_footer_sidebar_button_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_footer_sidebar_button_color_options[ 'text' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_footer_sidebar_button_color_options[ 'bg' ] ) ) { ?>
                    background-color: <?php echo $leap_footer_sidebar_button_color_options[ 'bg' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_footer_sidebar_button_color_options[ 'border' ] ) ) { ?>
                    border-color: <?php echo $leap_footer_sidebar_button_color_options[ 'border' ]; ?>;
        <?php } ?>
            }
            #footer-sidebar .btn-leap:hover, #footer-sidebar .btn-leap:focus, #footer-sidebar a.btn-leap:hover, #footer-sidebar a.btn-leap:focus, #footer-sidebar .widget a.btn-leap:hover, #footer-sidebar .widget a.btn-leap:focus, #footer-sidebar input[type="submit"]:hover, #footer-sidebar input[type="reset"]:hover, #footer-sidebar input[type="button"]:hover, #footer-sidebar input[type="submit"]:focus, #footer-sidebar input[type="reset"]:focus, #footer-sidebar input[type="button"]:focus {
        <?php if ( !empty( $leap_footer_sidebar_button_color_options[ 'bg-hover' ] ) ) { ?>
                    background-color: <?php echo $leap_footer_sidebar_button_color_options[ 'bg-hover' ]; ?>;
        <?php } ?>
            }

            #footer-sidebar .btn-leap, #footer-sidebar .btn-leap:hover, #footer-sidebar .btn-leap:focus, #footer-sidebar .btn-leap.disabled, #footer-sidebar .btn-leap[disabled], #footer-sidebar a.btn-leap, #footer-sidebar a.btn-leap:hover, #footer-sidebar a.btn-leap:focus, #footer-sidebar .widget a.btn-leap, #footer-sidebar .widget a.btn-leap:hover, #footer-sidebar .widget a.btn-leap:focus, #footer-sidebar input[type="submit"], #footer-sidebar input[type="reset"], #footer-sidebar input[type="button"], #footer-sidebar input[type="submit"]:hover, #footer-sidebar input[type="reset"]:hover, #footer-sidebar input[type="button"]:hover, #footer-sidebar input[type="submit"]:focus, #footer-sidebar input[type="reset"]:focus, #footer-sidebar input[type="button"]:focus {
        <?php if ( leap_get_sidebar_option_with_default( 'leap_footer_sidebar_button_radius', $sidebar_id ) == 'on' ) : ?>
                    border-radius: 3px;
                    -webkit-border-radius: 3px;
        <?php endif; ?>

        <?php if ( leap_get_sidebar_option_with_default( 'leap_footer_sidebar_button_radius', $sidebar_id ) == 'off' ) : ?>
                    border-radius: 0;
                    -webkit-border-radius: 0;
        <?php endif; ?>
            }

        <?php
        $leap_footer_sidebar_input_color_options = (array) leap_get_post_option_value( 'leap_footer_sidebar_input_color_options', $sidebar_id );
        ?>
            #footer-sidebar input[type="text"], #footer-sidebar input[type="text"]:focus, #footer-sidebar .form-control, #footer-sidebar .form-control:focus, #footer-sidebar textarea, #footer-sidebar textarea:focus, #footer-sidebar input[type="password"], #footer-sidebar input[type="password"]:focus, #footer-sidebar .widget_search .input-group-addon:last-child, #footer-sidebar .leap-search-form .input-group-addon:last-child, #footer-sidebar input[type="email"], #footer-sidebar input[type="date"], #footer-sidebar input[type="number"], #footer-sidebar input[type="email"]:focus, #footer-sidebar input[type="date"]:focus, #footer-sidebar input[type="number"]:focus {
        <?php if ( !empty( $leap_footer_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_footer_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_footer_sidebar_input_color_options[ 'bg' ] ) ) { ?>
                    background-color: <?php echo $leap_footer_sidebar_input_color_options[ 'bg' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_footer_sidebar_input_color_options[ 'border' ] ) ) { ?>
                    border-color: <?php echo $leap_footer_sidebar_input_color_options[ 'border' ]; ?>;
        <?php } ?>
            }
            #footer-sidebar input:focus:invalid:focus, #footer-sidebar textarea:focus:invalid:focus, #footer-sidebar select:focus:invalid:focus {
        <?php if ( !empty( $leap_footer_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_footer_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_footer_sidebar_input_color_options[ 'bg' ] ) ) { ?>
                    background-color: <?php echo $leap_footer_sidebar_input_color_options[ 'bg' ]; ?>;
        <?php } ?>
        <?php if ( !empty( $leap_footer_sidebar_input_color_options[ 'border' ] ) ) { ?>
                    border-color: <?php echo $leap_footer_sidebar_input_color_options[ 'border' ]; ?>;
        <?php } ?>
            }
            #footer-sidebar .form-control::-moz-placeholder {
        <?php if ( !empty( $leap_footer_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_footer_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
            }
            #footer-sidebar .form-control:-ms-input-placeholder {
        <?php if ( !empty( $leap_footer_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_footer_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
            }
            #footer-sidebar .form-control::-webkit-input-placeholder {
        <?php if ( !empty( $leap_footer_sidebar_input_color_options[ 'text' ] ) ) { ?>
                    color: <?php echo $leap_footer_sidebar_input_color_options[ 'text' ]; ?>;
        <?php } ?>
            }

        <?php
        $leap_footer_sidebar_spacing      = (array) leap_get_post_option_value( 'leap_footer_sidebar_spacing', $sidebar_id );
        $leap_footer_sidebar_spacing_unit = (!empty( $leap_footer_sidebar_spacing[ 'unit' ] )) ? $leap_footer_sidebar_spacing[ 'unit' ] : 'px';
        ?>
            #footer-sidebar .container-fluid, #footer-sidebar > .container {
        <?php if ( isset( $leap_footer_sidebar_spacing[ 'top' ] ) && strlen( $leap_footer_sidebar_spacing[ 'top' ] ) > 0 ) { ?>
                    padding-top: <?php echo $leap_footer_sidebar_spacing[ 'top' ] . $leap_footer_sidebar_spacing_unit; ?>;
        <?php } ?>
        <?php if ( isset( $leap_footer_sidebar_spacing[ 'bottom' ] ) && strlen( $leap_footer_sidebar_spacing[ 'bottom' ] ) > 0 ) { ?>
                    padding-bottom: <?php echo $leap_footer_sidebar_spacing[ 'bottom' ] . $leap_footer_sidebar_spacing_unit; ?>;
        <?php } ?>
            }


    <?php } ?>
    		
    		
    </style>

    <?php
}
