<?php

if ( !defined( 'ABSPATH' ) ) {
    die( 'No direct access allowed' );
}

if ( !function_exists( 'leap_page_navi' ) ) {

    /**
     * Display page navigation
     * @param string $before
     * @param string $after
     */
    function leap_page_navi( $before = '', $after = '' ) {
        global $wpdb, $wp_query;
        $request        = $wp_query->request;
        $posts_per_page = intval( get_query_var( 'posts_per_page' ) );
        $paged          = intval( get_query_var( 'paged' ) );
        $numposts       = $wp_query->found_posts;
        $max_page       = $wp_query->max_num_pages;
        if ( $numposts <= $posts_per_page ) {
            return;
        }
        if ( empty( $paged ) || $paged == 0 ) {
            $paged = 1;
        }
        $pages_to_show         = 7;
        $pages_to_show_minus_1 = $pages_to_show - 1;
        $half_page_start       = floor( $pages_to_show_minus_1 / 2 );
        $half_page_end         = ceil( $pages_to_show_minus_1 / 2 );
        $start_page            = $paged - $half_page_start;
        if ( $start_page <= 0 ) {
            $start_page = 1;
        }
        $end_page = $paged + $half_page_end;
        if ( ($end_page - $start_page) != $pages_to_show_minus_1 ) {
            $end_page = $start_page + $pages_to_show_minus_1;
        }
        if ( $end_page > $max_page ) {
            $start_page = $max_page - $pages_to_show_minus_1;
            $end_page   = $max_page;
        }
        if ( $start_page <= 0 ) {
            $start_page = 1;
        }

        echo $before . '<div class="pagination"><ul class="clearfix">' . "";
        if ( $paged > 1 ) {
            echo '<li class="first"><a href="' . get_pagenum_link() . '" title="' . esc_attr__( 'First', 'wiz' ) . '"></a></li>';
        }

        $prevposts = get_previous_posts_link( '' );
        if ( $prevposts ) {
            echo '<li class="previous">' . $prevposts . '</li>';
        } else {
            echo '<li class="previous disabled"><a href="javascript:void(0)"></a></li>';
        }

        for ( $i = $start_page; $i <= $end_page; $i++ ) {
            if ( $i == $paged ) {
                echo '<li class="active"><a href="javascript:void(0)"><span>' . $i . '</span></a></li>';
            } else {
                echo '<li><a href="' . get_pagenum_link( $i ) . '"><span>' . $i . '</span></a></li>';
            }
        }
        echo '<li class="next">';
        next_posts_link( '' );
        echo '</li>';
        if ( $end_page < $max_page ) {
            echo '<li class="last"><a href="' . get_pagenum_link( $max_page ) . '" title="' . esc_attr__( 'Last', 'wiz' ) . '"></a></li>';
        }
        echo '</ul></div>' . $after . "";
    }

}