<?php
if ( !defined( 'ABSPATH' ) ) {
    die( 'No direct access allowed' );
}

function ot_type_leap_select_menu( $args = array() ) {

    /* turns arguments array into variables */
    extract( $args );

    /* verify a description */
    $has_desc = $field_desc ? true : false;

    /* format setting outer wrapper */
    echo '<div class="format-setting type-custom-post-type-select ' . ( $has_desc ? 'has-desc' : 'no-desc' ) . '">';

    /* description */
    echo $has_desc ? '<div class="description">' . htmlspecialchars_decode( $field_desc ) . '</div>' : '';

    /* format setting inner wrapper */
    echo '<div class="format-setting-inner">';

    /* build category */
    echo '<select name="' . esc_attr( $field_name ) . '" id="' . esc_attr( $field_id ) . '" class="option-tree-ui-select ' . $field_class . '">';

    /* query post types array */
    $menus = get_terms( 'nav_menu', array( 'hide_empty' => false ) );
    /* has posts */
    if ( is_array( $menus ) && !empty( $menus ) ) {
        echo '<option value="">-- ' . __( 'Choose One', 'option-tree' ) . ' --</option>';
        foreach ( $menus as $menu ) {
            echo '<option value="' . esc_attr( $menu->slug ) . '"' . selected( $field_value, $menu->slug, false ) . '>' . esc_html( $menu->name ) . '</option>';
        }
    } else {
        echo '<option value="">' . __( 'No Menus Found', 'wiz' ) . '</option>';
    }


    echo '</select>';

    echo '</div>';

    echo '</div>';
}

function ot_type_leap_select_post_type_checkbox( $args = array() ) {

    /* turns arguments array into variables */
    extract( $args );

    /* verify a description */
    $has_desc = $field_desc ? true : false;

    /* format setting outer wrapper */
    echo '<div class="format-setting type-post-type-checkbox type-checkbox ' . ( $has_desc ? 'has-desc' : 'no-desc' ) . '">';

    /* description */
    echo $has_desc ? '<div class="description">' . htmlspecialchars_decode( $field_desc ) . '</div>' : '';

    /* format setting inner wrapper */
    echo '<div class="format-setting-inner">';

    /* query post types array */
    $post_types = get_post_types( array( 'public' => true ) );

    /* has posts */
    if ( is_array( $post_types ) && !empty( $post_types ) ) {
        foreach ( $post_types as $post_type ) {
            echo '<p>';
            echo '<input type="checkbox" name="' . esc_attr( $field_name ) . '[' . esc_attr( $post_type ) . ']" id="' . esc_attr( $field_id ) . '-' . esc_attr( $post_type ) . '" value="' . esc_attr( $post_type ) . '" ' . ( isset( $field_value[ $post_type ] ) ? checked( $field_value[ $post_type ], $post_type, false ) : '' ) . ' class="option-tree-ui-checkbox ' . esc_attr( $field_class ) . '" />';
            echo '<label for="' . esc_attr( $field_id ) . '-' . esc_attr( $post_type ) . '">' . $post_type . '</label>';
            echo '</p>';
        }
    } else {
        echo '<p>' . __( 'No Post Types Found', 'wiz' ) . '</p>';
    }

    echo '</div>';

    echo '</div>';
}

/**
 * Revolution Slider Select option type.
 *
 * @param     array     An array of arguments.
 * @return    string
 */
function ot_type_leap_select_revolution_slider( $args = array() ) {

    /* turns arguments array into variables */
    extract( $args );

    /* verify a description */
    $has_desc = $field_desc ? true : false;

    /* format setting outer wrapper */
    echo '<div class="format-setting type-sidebar-select ' . ( $has_desc ? 'has-desc' : 'no-desc' ) . '">';

    /* description */
    echo $has_desc ? '<div class="description">' . htmlspecialchars_decode( $field_desc ) . '</div>' : '';

    /* format setting inner wrapper */
    echo '<div class="format-setting-inner">';

    if ( class_exists( 'RevSlider' ) ) {
        $slider     = new RevSlider();
        $arrSliders = $slider->getArrSlidersShort();

        $rev_sliders = $slider->getArrSliders();

        $all_sliders = array();

        foreach ( $rev_sliders as $slider ) {
            $id            = $slider->getID();
            $title         = $slider->getTitle();
            $alias         = $slider->getAlias();
            $all_sliders[] = array(
                'id'    => $id,
                'title' => $title,
                'alias' => $alias
            );
        }

        if ( empty( $arrSliders ) ) {
            echo __( 'No sliders found, Please create a slider', 'wiz' );
        } else {
            /*
              $select = UniteFunctionsRev::getHTMLSelect($arrSliders, $field_value, 'name="' . esc_attr($field_name) . '" id="' . esc_attr($field_id) . '" class="option-tree-ui-select ' . $field_class . '"', true);
              echo $select;
             */
            ?>
            <select id="<?php echo esc_attr( $field_id ); ?>" name="<?php echo esc_attr( $field_name ); ?>" class="option-tree-ui-select <?php echo $field_class; ?>">
                <?php foreach ( $all_sliders as $slider ) : ?>

                    <?php $name = empty( $slider[ 'title' ] ) ? '' : $slider[ 'title' ]; ?>
                    <?php if ( ($slider[ 'alias' ]) == $field_value ) { ?>
                        <option value="<?php echo $slider[ 'alias' ] ?>" selected="selected"><?php echo $name ?> | #<?php echo $slider[ 'id' ] ?></option>
                    <?php } else { ?>
                        <option value="<?php echo $slider[ 'alias' ] ?>"><?php echo $name ?> | #<?php echo $slider[ 'id' ] ?></option>
                    <?php } ?>
                <?php endforeach; ?>
            </select>
            <?php
        }
    } else {
        echo __( "Please, Install and activate Revolution Slider", "wiz" );
    }

    echo '</div>';
    echo '</div>';
}

/**
 * LayerSlider Slider Select option type.
 *
 * @param     array     An array of arguments.
 * @return    string
 */
function ot_type_leap_select_layerslider_slider( $args = array() ) {

    /* turns arguments array into variables */
    extract( $args );

    /* verify a description */
    $has_desc = $field_desc ? true : false;

    /* format setting outer wrapper */
    echo '<div class="format-setting type-sidebar-select ' . ( $has_desc ? 'has-desc' : 'no-desc' ) . '">';

    /* description */
    echo $has_desc ? '<div class="description">' . htmlspecialchars_decode( $field_desc ) . '</div>' : '';

    /* format setting inner wrapper */
    echo '<div class="format-setting-inner">';



    if ( is_plugin_active( 'LayerSlider/layerslider.php' ) ) {

        // Get WPDB Object
        global $wpdb;

        // Table name
        $table_name = $wpdb->prefix . "layerslider";

        // Get sliders
        $sliders = $wpdb->get_results( "SELECT id, name FROM $table_name
													WHERE flag_hidden = '0' AND flag_deleted = '0'
													ORDER BY date_c ASC" );
        ?>
        <?php if ( $sliders != null && !empty( $sliders ) ) { ?>
            <select id="<?php echo esc_attr( $field_id ); ?>" name="<?php echo esc_attr( $field_name ); ?>" class="option-tree-ui-select <?php echo $field_class; ?>">
                <?php foreach ( $sliders as $item ) : ?>

                    <?php $name = empty( $item->name ) ? 'Unnamed' : $item->name; ?>
                    <?php if ( ($item->id) == $field_value ) { ?>
                        <option value="<?php echo $item->id ?>" selected="selected"><?php echo $name ?> | #<?php echo $item->id ?></option>
                    <?php } else { ?>
                        <option value="<?php echo $item->id ?>"><?php echo $name ?> | #<?php echo $item->id ?></option>
                    <?php } ?>
                <?php endforeach; ?>
            </select>
        <?php } else { ?>
            <?php _e( "You didn't create any slider yet.", "wiz" ) ?>
        <?php } ?>

        <?php
    } else {
        echo __( "Please, Install and activate LayerSlider Slider", "wiz" );
    }

    echo '</div>';
    echo '</div>';
}

/**
 * 
 * @param array $args
 */
function ot_type_leap_link( $args = array() ) {

    /* turns arguments array into variables */
    extract( $args );

    /* verify a description */
    $has_desc = $field_desc ? true : false;

    /* format setting outer wrapper */
    echo '<div class="format-setting type-leap-link ' . ( $has_desc ? 'has-desc' : 'no-desc' ) . '">';

    /* description */
    echo $has_desc ? '<div class="description">' . htmlspecialchars_decode( $field_desc ) . '</div>' : '';

    /* format setting inner wrapper */
    echo '<div class="format-setting-inner">';

    /* build text input */
    $link_text = isset( $field_value[ 'text' ] ) ? esc_attr( $field_value[ 'text' ] ) : '';
    echo '<div class="ot-option-group"><input type="text" placeholder="Text" name="' . esc_attr( $field_name ) . '[text]" id="' . esc_attr( $field_id ) . '-text" value="' . $link_text . '" class="widefat option-tree-ui-input ' . esc_attr( $field_class ) . '" /></div>';

    $link_url = isset( $field_value[ 'url' ] ) ? esc_attr( $field_value[ 'url' ] ) : '';
    echo '<div class="ot-option-group"><input type="text" placeholder="URL" name="' . esc_attr( $field_name ) . '[url]" id="' . esc_attr( $field_id ) . '-url" value="' . $link_url . '" class="widefat option-tree-ui-input ' . esc_attr( $field_class ) . '" /></div>';

    echo '</div>';

    echo '</div>';
}

/**
 * Accordion start option type.
 *
 * @param     array     An array of arguments.
 * @return    string
 */
function ot_type_leap_accordion_start( $args = array() ) {

    extract( $args );

    $label = leap_get_setting_label_by_id( $field_id );

    echo '<div class="panel-toggle">';
    echo '<h3>' . $label . '</h3>';
    echo '<div>';
}

/**
 * Accordion end option type.
 *
 * @param     array     An array of arguments.
 * @return    string
 */
function ot_type_leap_accordion_end( $args = array() ) {

    extract( $args );

    echo '</div></div><div style="clear: both;"></div>';
}

/**
 * System Info option type.
 *
 * @param     array     An array of arguments.
 * @return    string
 */
function ot_type_leap_system_info( $args = array() ) {

    extract( $args );
    ?>

    <table class="widefat" cellspacing="0">
        <thead>
            <tr>
                <th colspan="2"><?php _e( 'WordPress Environment', 'wiz' ); ?></th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td><?php _e( 'Home URL', 'wiz' ); ?>:</td>
                <td><?php form_option( 'home' ); ?></td>
            </tr>
            <tr>
                <td><?php _e( 'Site URL', 'wiz' ); ?>:</td>
                <td><?php form_option( 'siteurl' ); ?></td>
            </tr>
            <tr>
                <td><?php _e( 'Theme Version', 'wiz' ); ?>:</td>
                <td><?php echo esc_html( THEME_VERSION ); ?></td>
            </tr>
            <tr>
                <td><?php _e( 'WP Version', 'wiz' ); ?>:</td>
                <td><?php bloginfo( 'version' ); ?></td>
            </tr>
            <tr>
                <td><?php _e( 'WP Path', 'wiz' ); ?>:</td>
                <td><?php echo ABSPATH; ?></td>
            </tr>
            <tr>
                <td><?php _e( 'WP Multisite', 'wiz' ); ?>:</td>
                <td><?php
                    if ( is_multisite() )
                        echo '&#10004;';
                    else
                        echo '&ndash;';
                    ?></td>
            </tr>
            <tr>
                <td><?php _e( 'WP Memory Limit', 'wiz' ); ?>:</td>
                <td><?php
                    $memory = wp_convert_hr_to_bytes( WP_MEMORY_LIMIT );

                    echo size_format( $memory );
                    ?></td>
            </tr>
            <tr>
                <td><?php _e( 'WP Debug Mode', 'wiz' ); ?>:</td>
                <td><?php
                    if ( defined( 'WP_DEBUG' ) && WP_DEBUG )
                        echo '&#10004;';
                    else
                        echo '&ndash;';
                    ?></td>
            </tr>
            <tr>
                <td><?php _e( 'Language', 'wiz' ); ?>:</td>
                <td><?php echo get_locale() ?></td>
            </tr>
        </tbody>
    </table>
<br>
    <table class="widefat" cellspacing="0">
        <thead>
            <tr>
                <th colspan="2" data-export-label="Server Environment"><?php _e( 'Server Environment', 'wiz' ); ?></th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td><?php _e( 'Server Info', 'wiz' ); ?>:</td>
                <td><?php echo esc_html( $_SERVER[ 'SERVER_SOFTWARE' ] ); ?></td>
            </tr>
            <tr>
                <td><?php _e( 'PHP Version', 'wiz' ); ?>:</td>
                <td><?php
                    // Check if phpversion function exists
                    if ( function_exists( 'phpversion' ) ) {
                        $php_version = phpversion();

                        echo esc_html( $php_version );
                    } else {
                        _e( "Couldn't determine PHP version because phpversion() doesn't exist.", 'wiz' );
                    }
                    ?></td>
            </tr>
            <?php if ( function_exists( 'ini_get' ) ) : ?>
                <tr>
                    <td><?php _e( 'PHP Memory Limit', 'wiz' ); ?>:</td>
                    <td><?php echo size_format( wp_convert_hr_to_bytes( ini_get( 'memory_limit' ) ) ); ?></td>
                </tr>
                <tr>
                    <td><?php _e( 'PHP Post Max Size', 'wiz' ); ?>:</td>
                    <td><?php echo size_format( wp_convert_hr_to_bytes( ini_get( 'post_max_size' ) ) ); ?></td>
                </tr>
                <tr>
                    <td ><?php _e( 'PHP Time Limit', 'wiz' ); ?>:</td>
                    <td><?php echo ini_get( 'max_execution_time' ); ?></td>
                </tr>
                <tr>
                    <td><?php _e( 'PHP Max Input Vars', 'wiz' ); ?>:</td>
                    <td><?php echo ini_get( 'max_input_vars' ); ?></td>
                </tr>
                <tr>
                    <td ><?php _e( 'SUHOSIN Installed', 'wiz' ); ?>:</td>
                    <td><?php echo extension_loaded( 'suhosin' ) ? '&#10004;' : '&ndash;'; ?></td>
                </tr>
            <?php endif; ?>
            <tr>
                <td><?php _e( 'MySQL Version', 'wiz' ); ?>:</td>
                <td>
                    <?php
                    /** @global wpdb $wpdb */
                    global $wpdb;
                    echo $wpdb->db_version();
                    ?>
                </td>
            </tr>
            <tr>
                <td><?php _e( 'Max Upload Size', 'wiz' ); ?>:</td>
            <td><?php echo size_format( wp_max_upload_size() ); ?></td>
            </tr>
            </tbody>
    </table>
<br>
    <table class="widefat" cellspacing="0">
        <thead>
            <tr>
                <th colspan="2"><?php _e( 'Active Plugins', 'wiz' ); ?> (<?php echo count( (array) get_option( 'active_plugins' ) ); ?>)</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $active_plugins = (array) get_option( 'active_plugins', array() );

            if ( is_multisite() ) {
                $network_activated_plugins = array_keys( get_site_option( 'active_sitewide_plugins', array() ) );
                $active_plugins            = array_merge( $active_plugins, $network_activated_plugins );
            }

            foreach ( $active_plugins as $plugin ) {

                $plugin_data    = @get_plugin_data( WP_PLUGIN_DIR . '/' . $plugin );
                $dirname        = dirname( $plugin );
                $version_string = '';
                $network_string = '';

                if ( !empty( $plugin_data[ 'Name' ] ) ) {

                    // link the plugin name to the plugin url if available
                    $plugin_name = esc_html( $plugin_data[ 'Name' ] );

                    if ( !empty( $plugin_data[ 'PluginURI' ] ) ) {
                        $plugin_name = '<a href="' . esc_url( $plugin_data[ 'PluginURI' ] ) . '" title="' . esc_attr__( 'Visit plugin homepage', 'woocommerce' ) . '" target="_blank">' . $plugin_name . '</a>';
                    }
                    ?>
                    <tr>
                        <td><?php echo $plugin_name; ?></td>
                        <td><?php echo sprintf( _x( 'by %s', 'by author', 'wiz' ), $plugin_data[ 'Author' ] ) . ' &ndash; ' . esc_html( $plugin_data[ 'Version' ] ) . $version_string . $network_string; ?></td>
                    </tr>
                    <?php
                }
            }
            ?>
        </tbody>
    </table>

    <?php
}

/**
 * Filter to add custom option types.
 *
 * @param     array     An array of option types.
 * @return    array
 */
function leap_custom_option_types( $types ) {
    $types[ 'leap_select_menu' ]               = 'Select Menu';
    $types[ 'leap_select_post_type_checkbox' ] = 'Post Type Checkbox';
    $types[ 'leap_select_revolution_slider' ]  = 'Revolution Slider';
    $types[ 'leap_select_layerslider_slider' ] = 'LayerSlider Slider';
    $types[ 'leap_link' ]                      = 'Link';
    $types[ 'leap_accordion_start' ]           = 'Accordion Start';
    $types[ 'leap_accordion_end' ]             = 'Accordion End';
    return $types;
}

add_filter( 'ot_option_types_array', 'leap_custom_option_types' );

