<?php

if ( !defined( 'ABSPATH' ) ) {
    die( 'No direct access allowed' );
}

function leap_portfolio_fields_choices() {
    $portfolio_fields = ot_get_option( 'portfolio_fields', array() );
    $fields           = array();
    foreach ( $portfolio_fields as $key => $portfolio_field ) {
        $fields[ $key ] = array(
            'label'     => $portfolio_field[ 'title' ],
            'id'        => $portfolio_field[ 'id' ],
            'type'      => $portfolio_field[ 'type' ],
            'desc'      => '',
            'std'       => '',
            'rows'      => '5',
            'post_type' => '',
            'taxonomy'  => '',
            'class'     => ''
        );

        $options_types = array( 'radio', 'select' );
        $choices       = array();
        if ( in_array( $portfolio_field[ 'type' ], $options_types ) ) {
            $options = explode( ',', $portfolio_field[ 'options' ] );
            foreach ( $options as $option ) {
                $option_pieces = explode( ':', $option );
                $choices[]     = array(
                    'value' => $option_pieces[ 0 ],
                    'label' => $option_pieces[ 1 ],
                    'src'   => ''
                );
            }
        }

        $fields[ $key ][ 'choices' ] = $choices;
    }
    return $fields;
}

/**
 * Register leap meta boxes.
 */
function leap_meta_boxes() {

    $leap_portfolio_meta_box = array(
        'id'       => 'leap_portfolio_meta_box ',
        'title'    => 'Portfolio Details',
        'desc'     => '',
        'pages'    => array( 'leap-portfolio' ),
        'context'  => 'normal',
        'priority' => 'high',
        'fields'   => leap_portfolio_fields_choices()
    );

    $leap_seo_meta_box = array(
        'id'       => 'leap_seo_meta_box',
        'title'    => 'SEO Meta Box',
        'desc'     => '',
        'pages'    => ot_get_option( 'enable_seo', array() ),
        'context'  => 'normal',
        'priority' => 'high',
        'fields'   => array(
            array(
                'label'     => 'SEO Description',
                'id'        => 'leap_seo_description',
                'type'      => 'textarea-simple',
                'desc'      => 'The META description for this page. This will override any autogenerated descriptions. Most search engines use a maximum of 160 chars for the description.',
                'std'       => '',
                'rows'      => '5',
                'post_type' => '',
                'taxonomy'  => '',
                'class'     => ''
            ),
            array(
                'label'     => 'SEO Keywords (comma separated)',
                'id'        => 'leap_seo_keywords',
                'type'      => 'textarea-simple',
                'desc'      => 'A comma separated list of your most important keywords for this page that will be written as META keywords.',
                'std'       => '',
                'rows'      => '5',
                'post_type' => '',
                'taxonomy'  => '',
                'class'     => ''
            )
        )
    );

    $leap_page_options_meta_box = array(
        'id'       => 'leap_page_options_meta_box',
        'title'    => 'Page Options',
        'desc'     => '',
        'pages'    => array( 'page' ),
        'context'  => 'normal',
        'priority' => 'high',
        'fields'   => array(
            array(
                'id'           => 'leap_sidebar_position',
                'label'        => 'Sidebar Position',
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'radio-image',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Inherit from Theme Options',
                        'src'   => 'sidebar/default.png'
                    ),
                    array(
                        'value' => 'right',
                        'label' => __( 'Right', 'wiz' ),
                        'src'   => 'sidebar/right-sidebar.png'
                    ),
                    array(
                        'value' => 'left',
                        'label' => __( 'Left', 'wiz' ),
                        'src'   => 'sidebar/left-sidebar.png'
                    ),
                    array(
                        'value' => 'full',
                        'label' => __( 'Full Width', 'wiz' ),
                        'src'   => 'sidebar/no-sidebar.png'
                    )
                ),
            ),
            array(
                'id'           => 'leap_slider_type',
                'label'        => 'Slider Type',
                'desc'         => '',
                'std'          => 'none',
                'type'         => 'select',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'none',
                        'label' => 'None',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'rev_slider',
                        'label' => 'Revolution Slider',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'ls_slider',
                        'label' => 'LayerSlider Slider',
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'leap_revolution_slider',
                'label'        => 'Select Revolution Slider',
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_select_revolution_slider',
                'section'      => 'slider',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_slider_type:is(rev_slider)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_layerslider_slider',
                'label'        => 'Select LayerSlider Slider',
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_select_layerslider_slider',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_slider_type:is(ls_slider)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_page_content_spacing',
                'label'        => 'Page Content Top & Bottom Spacing',
                'desc'         => 'Leave empty for default value.',
                'std'          => '',
                'type'         => 'spacing',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_display_title',
                'label'        => 'Display Title',
                'desc'         => '',
                'std'          => 'yes',
                'type'         => 'select',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'choices'      => array(
                    array(
                        'value' => 'yes',
                        'label' => 'Yes',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'no',
                        'label' => 'No',
                        'src'   => ''
                    )
                ),
            ),
            array(
                'id'           => 'leap_page_title_bar_custom_text',
                'label'        => 'Page Title Bar Custom Text',
                'desc'         => '',
                'std'          => '',
                'type'         => 'text',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_display_title:is(yes)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_subtitle_text',
                'label'        => 'Page Title Bar Subtitle Text',
                'desc'         => '',
                'std'          => '',
                'type'         => 'text',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_display_title:is(yes)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_title_spacing',
                'label'        => 'Title Top & Bottom Spacing',
                'desc'         => '',
                'std'          => '',
                'type'         => 'spacing',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_display_title:is(yes)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_page_title_bg',
                'label'        => 'Page Title Bar Background',
                'desc'         => '',
                'std'          => '',
                'type'         => 'background',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_display_title:is(yes)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_page_title_bg_retina',
                'label'        => 'Page Title Bar Background (Retina Version @2x)',
                'desc'         => '',
                'std'          => '',
                'type'         => 'upload',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_display_title:is(yes)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_page_title_bg_retina_dimensions',
                'label'        => 'Normal Page Title background Dimensions for Retina',
                'desc'         => '',
                'std'          => '',
                'type'         => 'dimension',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_display_title:is(yes)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_parallax_page_title_bg',
                'label'        => 'Parallax Page Title Bar Background',
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'select',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Inherit from Theme Options',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'on',
                        'label' => 'On',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'off',
                        'label' => 'Off',
                        'src'   => ''
                    )
                ),
                'condition'    => 'leap_display_title:is(yes)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_sticky_header',
                'label'        => 'Enable Sticky Header',
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'select',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Inherit from Theme Options',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'yes',
                        'label' => 'Yes',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'no',
                        'label' => 'No',
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'leap_top_banner',
                'label'        => __( 'Top Banner', 'wiz' ),
                'desc'         => 'Displayed on header 6 only.',
                'std'          => 'default',
                'type'         => 'select',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Inherit from Theme Options',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'none',
                        'label' => __( 'None', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'image',
                        'label' => __( 'Image', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'code',
                        'label' => __( 'Custom Code', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'leap_top_banner_image',
                'label'        => __( 'Image', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'upload',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_top_banner:is(image)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_top_banner_link',
                'label'        => __( 'Link', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'text',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_top_banner:is(image)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_top_banner_target',
                'label'        => __( 'Open Link In a new Tab', 'wiz' ),
                'desc'         => '',
                'std'          => 'on',
                'type'         => 'on-off',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_top_banner:is(image)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_top_banner_code',
                'label'        => __( 'Code', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'textarea-simple',
                'rows'         => '7',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_top_banner:is(code)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_above_post_banner',
                'label'        => __( 'Above Post Banner', 'wiz' ),
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'select',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Inherit from Theme Options',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'none',
                        'label' => __( 'None', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'image',
                        'label' => __( 'Image', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'code',
                        'label' => __( 'Custom Code', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'leap_above_post_banner_image',
                'label'        => __( 'Image', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'upload',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_above_post_banner:is(image)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_above_post_banner_link',
                'label'        => __( 'Link', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'text',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_above_post_banner:is(image)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_above_post_banner_target',
                'label'        => __( 'Open Link In a new Tab', 'wiz' ),
                'desc'         => '',
                'std'          => 'on',
                'type'         => 'on-off',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_above_post_banner:is(image)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_above_post_banner_code',
                'label'        => __( 'Code', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'textarea-simple',
                'rows'         => '7',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_above_post_banner:is(code)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_below_post_banner',
                'label'        => __( 'Below Post Banner', 'wiz' ),
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'select',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Inherit from Theme Options',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'none',
                        'label' => __( 'None', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'image',
                        'label' => __( 'Image', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'code',
                        'label' => __( 'Custom Code', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'leap_below_post_banner_image',
                'label'        => __( 'Image', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'upload',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_below_post_banner:is(image)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_below_post_banner_link',
                'label'        => __( 'Link', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'text',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_below_post_banner:is(image)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_below_post_banner_target',
                'label'        => __( 'Open Link In a new Tab', 'wiz' ),
                'desc'         => '',
                'std'          => 'on',
                'type'         => 'on-off',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_below_post_banner:is(image)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_below_post_banner_code',
                'label'        => __( 'Code', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'textarea-simple',
                'rows'         => '7',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_below_post_banner:is(code)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_top_menu',
                'label'        => 'Top Menu',
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_select_menu',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_main_menu',
                'label'        => 'Main Menu',
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_select_menu',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_footer_menu',
                'label'        => 'Footer Menu',
                'desc'         => '',
                'std'          => '',
                'type'         => 'leap_select_menu',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_copyright_area',
                'label'        => 'Display Copyright Area',
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'select',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Inherit from Theme Options',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'on',
                        'label' => 'On',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'off',
                        'label' => 'Off',
                        'src'   => ''
                    )
                ),
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_header_layout',
                'label'        => __( 'Select a Header Layout', 'wiz' ),
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'radio-image',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => __( 'Inherit from Theme Options', 'wiz' ),
                        'src'   => 'headers/default.png'
                    ),
                    array(
                        'value' => 'header1',
                        'label' => __( 'Header1', 'wiz' ),
                        'src'   => 'headers/header1.png'
                    ),
                    array(
                        'value' => 'header2',
                        'label' => __( 'Header 2', 'wiz' ),
                        'src'   => 'headers/header2.png'
                    ),
                    array(
                        'value' => 'header3',
                        'label' => __( 'Header 3', 'wiz' ),
                        'src'   => 'headers/header3.png'
                    ),
                    array(
                        'value' => 'header4',
                        'label' => __( 'Header 4', 'wiz' ),
                        'src'   => 'headers/header4.png'
                    ),
                    array(
                        'value' => 'header5',
                        'label' => __( 'Header 5', 'wiz' ),
                        'src'   => 'headers/header5.png'
                    ),
                    array(
                        'value' => 'header6',
                        'label' => __( 'Header 6', 'wiz' ),
                        'src'   => 'headers/header6.png'
                    ),
                    array(
                        'value' => 'header7',
                        'label' => __( 'Header 7', 'wiz' ),
                        'src'   => 'headers/header7.png'
                    ),
                    array(
                        'value' => 'header8',
                        'label' => __( 'Header 8', 'wiz' ),
                        'src'   => 'headers/header8.png'
                    ),
                    array(
                        'value' => 'header9',
                        'label' => __( 'Header 9', 'wiz' ),
                        'src'   => 'headers/header9.png'
                    ),
                    array(
                        'value' => 'header10',
                        'label' => __( 'Header 10', 'wiz' ),
                        'src'   => 'headers/header10.png'
                    ),
                    array(
                        'value' => 'header11',
                        'label' => __( 'Header 11', 'wiz' ),
                        'src'   => 'headers/header11.png'
                    ),
                    array(
                        'value' => 'header12',
                        'label' => __( 'Header 12', 'wiz' ),
                        'src'   => 'headers/header12.png'
                    ),
                    array(
                        'value' => 'header13',
                        'label' => __( 'Header 13', 'wiz' ),
                        'src'   => 'headers/header13.png'
                    ),
                    array(
                        'value' => 'header14',
                        'label' => __( 'Header 14', 'wiz' ),
                        'src'   => 'headers/header14.png'
                    ),
                    array(
                        'value' => 'header15',
                        'label' => esc_html__( 'Header 15', 'wiz' ),
                        'src'   => 'headers/header15.png'
                    ),
                    array(
                        'value' => 'header16',
                        'label' => esc_html__( 'Header 16', 'wiz' ),
                        'src'   => 'headers/header16.png'
                    ),
                    array(
                        'value' => 'header17',
                        'label' => esc_html__( 'Header 17', 'wiz' ),
                        'src'   => 'headers/header17.png'
                    ),
                    array(
                        'value' => 'none',
                        'label' => __( 'None', 'wiz' ),
                        'src'   => 'headers/none.png'
                    )
                )
            ),
            array(
                'id'           => 'leap_header_position',
                'label'        => __( 'Header Position', 'wiz' ),
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'select',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'or',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => __( 'Inherit from Theme Options', 'wiz' )
                    ),
                    array(
                        'value' => 'absolute',
                        'label' => __( 'Absolute', 'wiz' )
                    ),
                    array(
                        'value' => 'static',
                        'label' => __( 'Static', 'wiz' )
                    )
                )
            ),
            array(
                'id'           => 'vh_header_page',
                'label'        => __( 'Display Vertical Menu Items', 'wiz' ),
                'desc'         => '',
                'std'          => 'on',
                'type'         => 'on-off',
                'section'      => 'header',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => 'clear-both',
                'condition'    => '',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_slider_position',
                'label'        => __( 'Slider Position', 'wiz' ),
                'desc'         => __('Select if the slider shows below or above the header. This will not be effective on vertical headers.', 'wiz'),
                'std'          => 'default',
                'type'         => 'select',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'or',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => __( 'Inherit from Theme Options', 'wiz' )
                    ),
                    array(
                        'value' => 'above',
                        'label' => __( 'Above Header', 'wiz' )
                    ),
                    array(
                        'value' => 'below',
                        'label' => __( 'Below Header', 'wiz' )
                    )
                )
            ),
            array(
                'id'           => 'leap_custom_css',
                'label'        => __( 'Custom CSS', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'css',
                'rows'         => '7',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            )
        )
    );

    $leap_portfolio_options_meta_box = array(
        'id'       => 'leap_portfolio_options_meta_box',
        'title'    => 'Portfolio Options',
        'desc'     => '',
        'pages'    => array( 'leap-portfolio' ),
        'context'  => 'normal',
        'priority' => 'high',
        'fields'   => array(
            array(
                'id'           => 'leap_sidebar_position',
                'label'        => 'Sidebar Position',
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'radio-image',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Inherit from Theme Options',
                        'src'   => 'sidebar/default.png'
                    ),
                    array(
                        'value' => 'right',
                        'label' => __( 'Right', 'wiz' ),
                        'src'   => 'sidebar/right-sidebar.png'
                    ),
                    array(
                        'value' => 'left',
                        'label' => __( 'Left', 'wiz' ),
                        'src'   => 'sidebar/left-sidebar.png'
                    ),
                    array(
                        'value' => 'full',
                        'label' => __( 'Full Width', 'wiz' ),
                        'src'   => 'sidebar/no-sidebar.png'
                    )
                ),
            ),
            array(
                'id'           => 'leap_top_banner',
                'label'        => __( 'Top Banner', 'wiz' ),
                'desc'         => 'Displayed on header 6 only.',
                'std'          => 'default',
                'type'         => 'select',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Inherit from Theme Options',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'none',
                        'label' => __( 'None', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'image',
                        'label' => __( 'Image', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'code',
                        'label' => __( 'Custom Code', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'leap_top_banner_image',
                'label'        => __( 'Image', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'upload',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_top_banner:is(image)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_top_banner_link',
                'label'        => __( 'Link', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'text',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_top_banner:is(image)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_top_banner_target',
                'label'        => __( 'Open Link In a new Tab', 'wiz' ),
                'desc'         => '',
                'std'          => 'on',
                'type'         => 'on-off',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_top_banner:is(image)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_top_banner_code',
                'label'        => __( 'Code', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'textarea-simple',
                'rows'         => '7',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_top_banner:is(code)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_above_post_banner',
                'label'        => __( 'Above Post Banner', 'wiz' ),
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'select',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Inherit from Theme Options',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'none',
                        'label' => __( 'None', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'image',
                        'label' => __( 'Image', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'code',
                        'label' => __( 'Custom Code', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'leap_above_post_banner_image',
                'label'        => __( 'Image', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'upload',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_above_post_banner:is(image)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_above_post_banner_link',
                'label'        => __( 'Link', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'text',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_above_post_banner:is(image)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_above_post_banner_target',
                'label'        => __( 'Open Link In a new Tab', 'wiz' ),
                'desc'         => '',
                'std'          => 'on',
                'type'         => 'on-off',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_above_post_banner:is(image)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_above_post_banner_code',
                'label'        => __( 'Code', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'textarea-simple',
                'rows'         => '7',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_above_post_banner:is(code)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_below_post_banner',
                'label'        => __( 'Below Post Banner', 'wiz' ),
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'select',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Inherit from Theme Options',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'none',
                        'label' => __( 'None', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'image',
                        'label' => __( 'Image', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'code',
                        'label' => __( 'Custom Code', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'leap_below_post_banner_image',
                'label'        => __( 'Image', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'upload',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_below_post_banner:is(image)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_below_post_banner_link',
                'label'        => __( 'Link', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'text',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_below_post_banner:is(image)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_below_post_banner_target',
                'label'        => __( 'Open Link In a new Tab', 'wiz' ),
                'desc'         => '',
                'std'          => 'on',
                'type'         => 'on-off',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_below_post_banner:is(image)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_below_post_banner_code',
                'label'        => __( 'Code', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'textarea-simple',
                'rows'         => '7',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_below_post_banner:is(code)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_custom_css',
                'label'        => __( 'Custom CSS', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'css',
                'rows'         => '7',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            )
        )
    );

    $leap_post_options_meta_box = array(
        'id'       => 'leap_post_options_meta_box',
        'title'    => 'Post Options',
        'desc'     => '',
        'pages'    => array( 'post', 'product' ),
        'context'  => 'normal',
        'priority' => 'high',
        'fields'   => array(
            array(
                'id'           => 'leap_sidebar_position',
                'label'        => 'Sidebar Position',
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'radio-image',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Inherit from Theme Options',
                        'src'   => 'sidebar/default.png'
                    ),
                    array(
                        'value' => 'right',
                        'label' => __( 'Right', 'wiz' ),
                        'src'   => 'sidebar/right-sidebar.png'
                    ),
                    array(
                        'value' => 'left',
                        'label' => __( 'Left', 'wiz' ),
                        'src'   => 'sidebar/left-sidebar.png'
                    ),
                    array(
                        'value' => 'full',
                        'label' => __( 'Full Width', 'wiz' ),
                        'src'   => 'sidebar/no-sidebar.png'
                    )
                ),
            ),
            array(
                'id'           => 'leap_top_banner',
                'label'        => __( 'Top Banner', 'wiz' ),
                'desc'         => 'Displayed on header 6 only.',
                'std'          => 'default',
                'type'         => 'select',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Inherit from Theme Options',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'none',
                        'label' => __( 'None', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'image',
                        'label' => __( 'Image', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'code',
                        'label' => __( 'Custom Code', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'leap_top_banner_image',
                'label'        => __( 'Image', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'upload',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_top_banner:is(image)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_top_banner_link',
                'label'        => __( 'Link', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'text',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_top_banner:is(image)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_top_banner_target',
                'label'        => __( 'Open Link In a new Tab', 'wiz' ),
                'desc'         => '',
                'std'          => 'on',
                'type'         => 'on-off',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_top_banner:is(image)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_top_banner_code',
                'label'        => __( 'Code', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'textarea-simple',
                'rows'         => '7',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_top_banner:is(code)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_above_post_banner',
                'label'        => __( 'Above Post Banner', 'wiz' ),
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'select',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Inherit from Theme Options',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'none',
                        'label' => __( 'None', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'image',
                        'label' => __( 'Image', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'code',
                        'label' => __( 'Custom Code', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'leap_above_post_banner_image',
                'label'        => __( 'Image', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'upload',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_above_post_banner:is(image)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_above_post_banner_link',
                'label'        => __( 'Link', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'text',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_above_post_banner:is(image)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_above_post_banner_target',
                'label'        => __( 'Open Link In a new Tab', 'wiz' ),
                'desc'         => '',
                'std'          => 'on',
                'type'         => 'on-off',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_above_post_banner:is(image)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_above_post_banner_code',
                'label'        => __( 'Code', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'textarea-simple',
                'rows'         => '7',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_above_post_banner:is(code)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_below_post_banner',
                'label'        => __( 'Below Post Banner', 'wiz' ),
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'select',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Inherit from Theme Options',
                        'src'   => ''
                    ),
                    array(
                        'value' => 'none',
                        'label' => __( 'None', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'image',
                        'label' => __( 'Image', 'wiz' ),
                        'src'   => ''
                    ),
                    array(
                        'value' => 'code',
                        'label' => __( 'Custom Code', 'wiz' ),
                        'src'   => ''
                    )
                )
            ),
            array(
                'id'           => 'leap_below_post_banner_image',
                'label'        => __( 'Image', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'upload',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_below_post_banner:is(image)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_below_post_banner_link',
                'label'        => __( 'Link', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'text',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_below_post_banner:is(image)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_below_post_banner_target',
                'label'        => __( 'Open Link In a new Tab', 'wiz' ),
                'desc'         => '',
                'std'          => 'on',
                'type'         => 'on-off',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_below_post_banner:is(image)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_below_post_banner_code',
                'label'        => __( 'Code', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'textarea-simple',
                'rows'         => '7',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => 'leap_below_post_banner:is(code)',
                'operator'     => 'and'
            ),
            array(
                'id'           => 'leap_custom_css',
                'label'        => __( 'Custom CSS', 'wiz' ),
                'desc'         => '',
                'std'          => '',
                'type'         => 'css',
                'rows'         => '7',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and'
            )
        )
    );

    $leap_widget_positions_meta_box = array(
        'id'       => 'leap_widget_positions_meta_box',
        'title'    => 'Widget Positions',
        'desc'     => '',
        //'pages' => array('post', 'page', 'leap-portfolio'),
        'pages'    => ot_get_option( 'override_widget_positions', array() ),
        'context'  => 'normal',
        'priority' => 'default',
        'fields'   => array(
            array(
                'id'           => 'leap_header_sidebar',
                'label'        => 'Header Position',
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'radio-image',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Inherit from Theme Options',
                        'src'   => 'col/default.jpg'
                    ),
                    array(
                        'value' => 'none',
                        'label' => __( 'No Columns', 'wiz' ),
                        'src'   => 'col/none.jpg'
                    ),
                    array(
                        'value' => '12',
                        'label' => __( '1/1', 'wiz' ),
                        'src'   => 'col/12.jpg'
                    ),
                    array(
                        'value' => '6-6',
                        'label' => __( '1/2-1/2', 'wiz' ),
                        'src'   => 'col/6-6.jpg'
                    ),
                    array(
                        'value' => '4-4-4',
                        'label' => __( '1/3-1/3-1/3', 'wiz' ),
                        'src'   => 'col/4-4-4.jpg'
                    ),
                    array(
                        'value' => '4-8',
                        'label' => __( '1/3-2/3', 'wiz' ),
                        'src'   => 'col/4-8.jpg'
                    ),
                    array(
                        'value' => '8-4',
                        'label' => __( '2/3-1/3', 'wiz' ),
                        'src'   => 'col/8-4.jpg'
                    ),
                    array(
                        'value' => '3-3-3-3',
                        'label' => __( '1/4-1/4-1/4-1/4', 'wiz' ),
                        'src'   => 'col/3-3-3-3.jpg'
                    ),
                    array(
                        'value' => '3-9',
                        'label' => __( '1/4-3/4', 'wiz' ),
                        'src'   => 'col/3-9.jpg'
                    ),
                    array(
                        'value' => '9-3',
                        'label' => __( '3/4-1/4', 'wiz' ),
                        'src'   => 'col/9-3.jpg'
                    ),
                    array(
                        'value' => '3-6-3',
                        'label' => __( '1/4-1/2-1/4', 'wiz' ),
                        'src'   => 'col/3-6-3.jpg'
                    ),
                    array(
                        'value' => '3-3-6',
                        'label' => __( '1/4-1/4-1/2', 'wiz' ),
                        'src'   => 'col/3-3-6.jpg'
                    ),
                    array(
                        'value' => '6-3-3',
                        'label' => __( '1/2-1/4-1/4', 'wiz' ),
                        'src'   => 'col/6-3-3.jpg'
                    )
                )
            ),
            array(
                'id'           => 'leap_main_top_sidebar',
                'label'        => 'Main Top Position',
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'radio-image',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Inherit from Theme Options',
                        'src'   => 'col/default.jpg'
                    ),
                    array(
                        'value' => 'none',
                        'label' => __( 'No Columns', 'wiz' ),
                        'src'   => 'col/none.jpg'
                    ),
                    array(
                        'value' => '12',
                        'label' => __( '1/1', 'wiz' ),
                        'src'   => 'col/12.jpg'
                    ),
                    array(
                        'value' => '6-6',
                        'label' => __( '1/2-1/2', 'wiz' ),
                        'src'   => 'col/6-6.jpg'
                    ),
                    array(
                        'value' => '4-4-4',
                        'label' => __( '1/3-1/3-1/3', 'wiz' ),
                        'src'   => 'col/4-4-4.jpg'
                    ),
                    array(
                        'value' => '4-8',
                        'label' => __( '1/3-2/3', 'wiz' ),
                        'src'   => 'col/4-8.jpg'
                    ),
                    array(
                        'value' => '8-4',
                        'label' => __( '2/3-1/3', 'wiz' ),
                        'src'   => 'col/8-4.jpg'
                    ),
                    array(
                        'value' => '3-3-3-3',
                        'label' => __( '1/4-1/4-1/4-1/4', 'wiz' ),
                        'src'   => 'col/3-3-3-3.jpg'
                    ),
                    array(
                        'value' => '3-9',
                        'label' => __( '1/4-3/4', 'wiz' ),
                        'src'   => 'col/3-9.jpg'
                    ),
                    array(
                        'value' => '9-3',
                        'label' => __( '3/4-1/4', 'wiz' ),
                        'src'   => 'col/9-3.jpg'
                    ),
                    array(
                        'value' => '3-6-3',
                        'label' => __( '1/4-1/2-1/4', 'wiz' ),
                        'src'   => 'col/3-6-3.jpg'
                    ),
                    array(
                        'value' => '3-3-6',
                        'label' => __( '1/4-1/4-1/2', 'wiz' ),
                        'src'   => 'col/3-3-6.jpg'
                    ),
                    array(
                        'value' => '6-3-3',
                        'label' => __( '1/2-1/4-1/4', 'wiz' ),
                        'src'   => 'col/6-3-3.jpg'
                    )
                )
            ),
            array(
                'id'           => 'leap_header_full_width_sidebar',
                'label'        => 'Header Full Width Position',
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'radio-image',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Inherit from Theme Options',
                        'src'   => 'col/default.jpg'
                    ),
                    array(
                        'value' => 'none',
                        'label' => __( 'No Columns', 'wiz' ),
                        'src'   => 'col/none.jpg'
                    ),
                    array(
                        'value' => '12',
                        'label' => __( '1/1', 'wiz' ),
                        'src'   => 'col/12.jpg'
                    ),
                    array(
                        'value' => '6-6',
                        'label' => __( '1/2-1/2', 'wiz' ),
                        'src'   => 'col/6-6.jpg'
                    ),
                    array(
                        'value' => '4-4-4',
                        'label' => __( '1/3-1/3-1/3', 'wiz' ),
                        'src'   => 'col/4-4-4.jpg'
                    ),
                    array(
                        'value' => '4-8',
                        'label' => __( '1/3-2/3', 'wiz' ),
                        'src'   => 'col/4-8.jpg'
                    ),
                    array(
                        'value' => '8-4',
                        'label' => __( '2/3-1/3', 'wiz' ),
                        'src'   => 'col/8-4.jpg'
                    ),
                    array(
                        'value' => '3-3-3-3',
                        'label' => __( '1/4-1/4-1/4-1/4', 'wiz' ),
                        'src'   => 'col/3-3-3-3.jpg'
                    ),
                    array(
                        'value' => '3-9',
                        'label' => __( '1/4-3/4', 'wiz' ),
                        'src'   => 'col/3-9.jpg'
                    ),
                    array(
                        'value' => '9-3',
                        'label' => __( '3/4-1/4', 'wiz' ),
                        'src'   => 'col/9-3.jpg'
                    ),
                    array(
                        'value' => '3-6-3',
                        'label' => __( '1/4-1/2-1/4', 'wiz' ),
                        'src'   => 'col/3-6-3.jpg'
                    ),
                    array(
                        'value' => '3-3-6',
                        'label' => __( '1/4-1/4-1/2', 'wiz' ),
                        'src'   => 'col/3-3-6.jpg'
                    ),
                    array(
                        'value' => '6-3-3',
                        'label' => __( '1/2-1/4-1/4', 'wiz' ),
                        'src'   => 'col/6-3-3.jpg'
                    )
                )
            ),
            array(
                'id'           => 'leap_main_content_top_sidebar',
                'label'        => 'Main Content Top Position',
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'radio-image',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Inherit from Theme Options',
                        'src'   => 'col/default.jpg'
                    ),
                    array(
                        'value' => 'none',
                        'label' => __( 'No Columns', 'wiz' ),
                        'src'   => 'col/none.jpg'
                    ),
                    array(
                        'value' => '12',
                        'label' => __( '1/1', 'wiz' ),
                        'src'   => 'col/12.jpg'
                    ),
                    array(
                        'value' => '6-6',
                        'label' => __( '1/2-1/2', 'wiz' ),
                        'src'   => 'col/6-6.jpg'
                    ),
                    array(
                        'value' => '4-4-4',
                        'label' => __( '1/3-1/3-1/3', 'wiz' ),
                        'src'   => 'col/4-4-4.jpg'
                    ),
                    array(
                        'value' => '4-8',
                        'label' => __( '1/3-2/3', 'wiz' ),
                        'src'   => 'col/4-8.jpg'
                    ),
                    array(
                        'value' => '8-4',
                        'label' => __( '2/3-1/3', 'wiz' ),
                        'src'   => 'col/8-4.jpg'
                    ),
                    array(
                        'value' => '3-3-3-3',
                        'label' => __( '1/4-1/4-1/4-1/4', 'wiz' ),
                        'src'   => 'col/3-3-3-3.jpg'
                    ),
                    array(
                        'value' => '3-9',
                        'label' => __( '1/4-3/4', 'wiz' ),
                        'src'   => 'col/3-9.jpg'
                    ),
                    array(
                        'value' => '9-3',
                        'label' => __( '3/4-1/4', 'wiz' ),
                        'src'   => 'col/9-3.jpg'
                    ),
                    array(
                        'value' => '3-6-3',
                        'label' => __( '1/4-1/2-1/4', 'wiz' ),
                        'src'   => 'col/3-6-3.jpg'
                    ),
                    array(
                        'value' => '3-3-6',
                        'label' => __( '1/4-1/4-1/2', 'wiz' ),
                        'src'   => 'col/3-3-6.jpg'
                    ),
                    array(
                        'value' => '6-3-3',
                        'label' => __( '1/2-1/4-1/4', 'wiz' ),
                        'src'   => 'col/6-3-3.jpg'
                    )
                )
            ),
            array(
                'id'           => 'leap_content_top_sidebar',
                'label'        => 'Content Top Position',
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'radio-image',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Inherit from Theme Options',
                        'src'   => 'col/default.jpg'
                    ),
                    array(
                        'value' => 'none',
                        'label' => __( 'No Columns', 'wiz' ),
                        'src'   => 'col/none.jpg'
                    ),
                    array(
                        'value' => '12',
                        'label' => __( '1/1', 'wiz' ),
                        'src'   => 'col/12.jpg'
                    ),
                    array(
                        'value' => '6-6',
                        'label' => __( '1/2-1/2', 'wiz' ),
                        'src'   => 'col/6-6.jpg'
                    ),
                    array(
                        'value' => '4-4-4',
                        'label' => __( '1/3-1/3-1/3', 'wiz' ),
                        'src'   => 'col/4-4-4.jpg'
                    ),
                    array(
                        'value' => '4-8',
                        'label' => __( '1/3-2/3', 'wiz' ),
                        'src'   => 'col/4-8.jpg'
                    ),
                    array(
                        'value' => '8-4',
                        'label' => __( '2/3-1/3', 'wiz' ),
                        'src'   => 'col/8-4.jpg'
                    ),
                    array(
                        'value' => '3-3-3-3',
                        'label' => __( '1/4-1/4-1/4-1/4', 'wiz' ),
                        'src'   => 'col/3-3-3-3.jpg'
                    ),
                    array(
                        'value' => '3-9',
                        'label' => __( '1/4-3/4', 'wiz' ),
                        'src'   => 'col/3-9.jpg'
                    ),
                    array(
                        'value' => '9-3',
                        'label' => __( '3/4-1/4', 'wiz' ),
                        'src'   => 'col/9-3.jpg'
                    ),
                    array(
                        'value' => '3-6-3',
                        'label' => __( '1/4-1/2-1/4', 'wiz' ),
                        'src'   => 'col/3-6-3.jpg'
                    ),
                    array(
                        'value' => '3-3-6',
                        'label' => __( '1/4-1/4-1/2', 'wiz' ),
                        'src'   => 'col/3-3-6.jpg'
                    ),
                    array(
                        'value' => '6-3-3',
                        'label' => __( '1/2-1/4-1/4', 'wiz' ),
                        'src'   => 'col/6-3-3.jpg'
                    )
                )
            ),
            array(
                'id'           => 'leap_content_bottom_sidebar',
                'label'        => 'Content Bottom Position',
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'radio-image',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Inherit from Theme Options',
                        'src'   => 'col/default.jpg'
                    ),
                    array(
                        'value' => 'none',
                        'label' => __( 'No Columns', 'wiz' ),
                        'src'   => 'col/none.jpg'
                    ),
                    array(
                        'value' => '12',
                        'label' => __( '1/1', 'wiz' ),
                        'src'   => 'col/12.jpg'
                    ),
                    array(
                        'value' => '6-6',
                        'label' => __( '1/2-1/2', 'wiz' ),
                        'src'   => 'col/6-6.jpg'
                    ),
                    array(
                        'value' => '4-4-4',
                        'label' => __( '1/3-1/3-1/3', 'wiz' ),
                        'src'   => 'col/4-4-4.jpg'
                    ),
                    array(
                        'value' => '4-8',
                        'label' => __( '1/3-2/3', 'wiz' ),
                        'src'   => 'col/4-8.jpg'
                    ),
                    array(
                        'value' => '8-4',
                        'label' => __( '2/3-1/3', 'wiz' ),
                        'src'   => 'col/8-4.jpg'
                    ),
                    array(
                        'value' => '3-3-3-3',
                        'label' => __( '1/4-1/4-1/4-1/4', 'wiz' ),
                        'src'   => 'col/3-3-3-3.jpg'
                    ),
                    array(
                        'value' => '3-9',
                        'label' => __( '1/4-3/4', 'wiz' ),
                        'src'   => 'col/3-9.jpg'
                    ),
                    array(
                        'value' => '9-3',
                        'label' => __( '3/4-1/4', 'wiz' ),
                        'src'   => 'col/9-3.jpg'
                    ),
                    array(
                        'value' => '3-6-3',
                        'label' => __( '1/4-1/2-1/4', 'wiz' ),
                        'src'   => 'col/3-6-3.jpg'
                    ),
                    array(
                        'value' => '3-3-6',
                        'label' => __( '1/4-1/4-1/2', 'wiz' ),
                        'src'   => 'col/3-3-6.jpg'
                    ),
                    array(
                        'value' => '6-3-3',
                        'label' => __( '1/2-1/4-1/4', 'wiz' ),
                        'src'   => 'col/6-3-3.jpg'
                    )
                )
            ),
            array(
                'id'           => 'leap_main_content_bottom_sidebar',
                'label'        => 'Main Content Bottom Position',
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'radio-image',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Inherit from Theme Options',
                        'src'   => 'col/default.jpg'
                    ),
                    array(
                        'value' => 'none',
                        'label' => __( 'No Columns', 'wiz' ),
                        'src'   => 'col/none.jpg'
                    ),
                    array(
                        'value' => '12',
                        'label' => __( '1/1', 'wiz' ),
                        'src'   => 'col/12.jpg'
                    ),
                    array(
                        'value' => '6-6',
                        'label' => __( '1/2-1/2', 'wiz' ),
                        'src'   => 'col/6-6.jpg'
                    ),
                    array(
                        'value' => '4-4-4',
                        'label' => __( '1/3-1/3-1/3', 'wiz' ),
                        'src'   => 'col/4-4-4.jpg'
                    ),
                    array(
                        'value' => '4-8',
                        'label' => __( '1/3-2/3', 'wiz' ),
                        'src'   => 'col/4-8.jpg'
                    ),
                    array(
                        'value' => '8-4',
                        'label' => __( '2/3-1/3', 'wiz' ),
                        'src'   => 'col/8-4.jpg'
                    ),
                    array(
                        'value' => '3-3-3-3',
                        'label' => __( '1/4-1/4-1/4-1/4', 'wiz' ),
                        'src'   => 'col/3-3-3-3.jpg'
                    ),
                    array(
                        'value' => '3-9',
                        'label' => __( '1/4-3/4', 'wiz' ),
                        'src'   => 'col/3-9.jpg'
                    ),
                    array(
                        'value' => '9-3',
                        'label' => __( '3/4-1/4', 'wiz' ),
                        'src'   => 'col/9-3.jpg'
                    ),
                    array(
                        'value' => '3-6-3',
                        'label' => __( '1/4-1/2-1/4', 'wiz' ),
                        'src'   => 'col/3-6-3.jpg'
                    ),
                    array(
                        'value' => '3-3-6',
                        'label' => __( '1/4-1/4-1/2', 'wiz' ),
                        'src'   => 'col/3-3-6.jpg'
                    ),
                    array(
                        'value' => '6-3-3',
                        'label' => __( '1/2-1/4-1/4', 'wiz' ),
                        'src'   => 'col/6-3-3.jpg'
                    )
                )
            ),
            array(
                'id'           => 'leap_footer_full_width_sidebar',
                'label'        => 'Footer Full Width Position',
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'radio-image',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Inherit from Theme Options',
                        'src'   => 'col/default.jpg'
                    ),
                    array(
                        'value' => 'none',
                        'label' => __( 'No Columns', 'wiz' ),
                        'src'   => 'col/none.jpg'
                    ),
                    array(
                        'value' => '12',
                        'label' => __( '1/1', 'wiz' ),
                        'src'   => 'col/12.jpg'
                    ),
                    array(
                        'value' => '6-6',
                        'label' => __( '1/2-1/2', 'wiz' ),
                        'src'   => 'col/6-6.jpg'
                    ),
                    array(
                        'value' => '4-4-4',
                        'label' => __( '1/3-1/3-1/3', 'wiz' ),
                        'src'   => 'col/4-4-4.jpg'
                    ),
                    array(
                        'value' => '4-8',
                        'label' => __( '1/3-2/3', 'wiz' ),
                        'src'   => 'col/4-8.jpg'
                    ),
                    array(
                        'value' => '8-4',
                        'label' => __( '2/3-1/3', 'wiz' ),
                        'src'   => 'col/8-4.jpg'
                    ),
                    array(
                        'value' => '3-3-3-3',
                        'label' => __( '1/4-1/4-1/4-1/4', 'wiz' ),
                        'src'   => 'col/3-3-3-3.jpg'
                    ),
                    array(
                        'value' => '3-9',
                        'label' => __( '1/4-3/4', 'wiz' ),
                        'src'   => 'col/3-9.jpg'
                    ),
                    array(
                        'value' => '9-3',
                        'label' => __( '3/4-1/4', 'wiz' ),
                        'src'   => 'col/9-3.jpg'
                    ),
                    array(
                        'value' => '3-6-3',
                        'label' => __( '1/4-1/2-1/4', 'wiz' ),
                        'src'   => 'col/3-6-3.jpg'
                    ),
                    array(
                        'value' => '3-3-6',
                        'label' => __( '1/4-1/4-1/2', 'wiz' ),
                        'src'   => 'col/3-3-6.jpg'
                    ),
                    array(
                        'value' => '6-3-3',
                        'label' => __( '1/2-1/4-1/4', 'wiz' ),
                        'src'   => 'col/6-3-3.jpg'
                    )
                )
            ),
            array(
                'id'           => 'leap_main_bottom_sidebar',
                'label'        => 'Main Bottom Position',
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'radio-image',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Inherit from Theme Options',
                        'src'   => 'col/default.jpg'
                    ),
                    array(
                        'value' => 'none',
                        'label' => __( 'No Columns', 'wiz' ),
                        'src'   => 'col/none.jpg'
                    ),
                    array(
                        'value' => '12',
                        'label' => __( '1/1', 'wiz' ),
                        'src'   => 'col/12.jpg'
                    ),
                    array(
                        'value' => '6-6',
                        'label' => __( '1/2-1/2', 'wiz' ),
                        'src'   => 'col/6-6.jpg'
                    ),
                    array(
                        'value' => '4-4-4',
                        'label' => __( '1/3-1/3-1/3', 'wiz' ),
                        'src'   => 'col/4-4-4.jpg'
                    ),
                    array(
                        'value' => '4-8',
                        'label' => __( '1/3-2/3', 'wiz' ),
                        'src'   => 'col/4-8.jpg'
                    ),
                    array(
                        'value' => '8-4',
                        'label' => __( '2/3-1/3', 'wiz' ),
                        'src'   => 'col/8-4.jpg'
                    ),
                    array(
                        'value' => '3-3-3-3',
                        'label' => __( '1/4-1/4-1/4-1/4', 'wiz' ),
                        'src'   => 'col/3-3-3-3.jpg'
                    ),
                    array(
                        'value' => '3-9',
                        'label' => __( '1/4-3/4', 'wiz' ),
                        'src'   => 'col/3-9.jpg'
                    ),
                    array(
                        'value' => '9-3',
                        'label' => __( '3/4-1/4', 'wiz' ),
                        'src'   => 'col/9-3.jpg'
                    ),
                    array(
                        'value' => '3-6-3',
                        'label' => __( '1/4-1/2-1/4', 'wiz' ),
                        'src'   => 'col/3-6-3.jpg'
                    ),
                    array(
                        'value' => '3-3-6',
                        'label' => __( '1/4-1/4-1/2', 'wiz' ),
                        'src'   => 'col/3-3-6.jpg'
                    ),
                    array(
                        'value' => '6-3-3',
                        'label' => __( '1/2-1/4-1/4', 'wiz' ),
                        'src'   => 'col/6-3-3.jpg'
                    )
                )
            ),
            array(
                'id'           => 'leap_footer_sidebar',
                'label'        => 'Footer Position',
                'desc'         => '',
                'std'          => 'default',
                'type'         => 'radio-image',
                'rows'         => '',
                'post_type'    => '',
                'taxonomy'     => '',
                'min_max_step' => '',
                'class'        => '',
                'condition'    => '',
                'operator'     => 'and',
                'choices'      => array(
                    array(
                        'value' => 'default',
                        'label' => 'Inherit from Theme Options',
                        'src'   => 'col/default.jpg'
                    ),
                    array(
                        'value' => 'none',
                        'label' => __( 'No Columns', 'wiz' ),
                        'src'   => 'col/none.jpg'
                    ),
                    array(
                        'value' => '12',
                        'label' => __( '1/1', 'wiz' ),
                        'src'   => 'col/12.jpg'
                    ),
                    array(
                        'value' => '6-6',
                        'label' => __( '1/2-1/2', 'wiz' ),
                        'src'   => 'col/6-6.jpg'
                    ),
                    array(
                        'value' => '4-4-4',
                        'label' => __( '1/3-1/3-1/3', 'wiz' ),
                        'src'   => 'col/4-4-4.jpg'
                    ),
                    array(
                        'value' => '4-8',
                        'label' => __( '1/3-2/3', 'wiz' ),
                        'src'   => 'col/4-8.jpg'
                    ),
                    array(
                        'value' => '8-4',
                        'label' => __( '2/3-1/3', 'wiz' ),
                        'src'   => 'col/8-4.jpg'
                    ),
                    array(
                        'value' => '3-3-3-3',
                        'label' => __( '1/4-1/4-1/4-1/4', 'wiz' ),
                        'src'   => 'col/3-3-3-3.jpg'
                    ),
                    array(
                        'value' => '3-9',
                        'label' => __( '1/4-3/4', 'wiz' ),
                        'src'   => 'col/3-9.jpg'
                    ),
                    array(
                        'value' => '9-3',
                        'label' => __( '3/4-1/4', 'wiz' ),
                        'src'   => 'col/9-3.jpg'
                    ),
                    array(
                        'value' => '3-6-3',
                        'label' => __( '1/4-1/2-1/4', 'wiz' ),
                        'src'   => 'col/3-6-3.jpg'
                    ),
                    array(
                        'value' => '3-3-6',
                        'label' => __( '1/4-1/4-1/2', 'wiz' ),
                        'src'   => 'col/3-3-6.jpg'
                    ),
                    array(
                        'value' => '6-3-3',
                        'label' => __( '1/2-1/4-1/4', 'wiz' ),
                        'src'   => 'col/6-3-3.jpg'
                    )
                )
            )
        )
    );




    ot_register_meta_box( $leap_widget_positions_meta_box );
    ot_register_meta_box( $leap_seo_meta_box );
    ot_register_meta_box( $leap_post_options_meta_box );
    ot_register_meta_box( $leap_page_options_meta_box );


    if ( is_plugin_active( 'leap-port/leap-port.php' ) ) {
        ot_register_meta_box( $leap_portfolio_meta_box );
        ot_register_meta_box( $leap_portfolio_options_meta_box );
    }
}

add_action( 'admin_init', 'leap_meta_boxes' );

/**
 * Register quote post format meta box
 * @return array
 */
function leap_quote_post_format_meta_box() {
    $options = array(
        'id'       => 'ot-post-format-quote',
        'title'    => __( 'Quote', 'wiz' ),
        'desc'     => '',
        'pages'    => 'post',
        'context'  => 'side',
        'priority' => 'low',
        'fields'   => array(
            array(
                'id'    => '_format_quote',
                'label' => '',
                'desc'  => 'blockquote tag and quote short code are allowed.',
                'std'   => '',
                'type'  => 'textarea'
            )
        )
    );
    return $options;
}

/*
 * ot_meta_box_post_format_gallery
 * ot_meta_box_post_format_link
 * ot_meta_box_post_format_quote
 * ot_meta_box_post_format_video
 * ot_meta_box_post_format_audio
 * 
 */
add_filter( 'ot_meta_box_post_format_quote', 'leap_quote_post_format_meta_box', 10 );
