<?php
if ( !defined( 'ABSPATH' ) ) {
    die( 'No direct access allowed' );
}

require trailingslashit( get_template_directory() ) . 'functions/mega-menu/edit-walker.php';
require trailingslashit( get_template_directory() ) . 'functions/mega-menu/walker.php';

if ( !class_exists( 'Leap_Mega_Menu' ) ) {

    class Leap_Mega_Menu {

        function __construct() {

            // add custom menu fields to menu
            add_filter( 'wp_setup_nav_menu_item', array( $this, 'add_custom_nav_fields' ) );

            // save menu custom fields
            add_action( 'wp_update_nav_menu_item', array( $this, 'update_custom_nav_fields' ), 10, 3 );

            // edit menu walker
            add_filter( 'wp_edit_nav_menu_walker', array( $this, 'edit_walker' ), 10, 2 );

            // add custom fields to edit menu
            add_action( 'wp_nav_menu_item_custom_fields', array( $this, 'custom_fields' ), 10, 4 );
        }

        /**
         * Add custom fields to $item nav object
         * in order to be used in custom Walker
         *
         * @access      public
         * @return      void
         */
        function add_custom_nav_fields( $menu_item ) {

            $menu_item->leap_megamenu_status = get_post_meta( $menu_item->ID, '_menu_item_leap_megamenu_status', true );

            $menu_item->leap_megamenu_columns = get_post_meta( $menu_item->ID, '_menu_item_leap_megamenu_columns', true );

            $menu_item->leap_megamenu_title = get_post_meta( $menu_item->ID, '_menu_item_leap_megamenu_title', true );

            $menu_item->leap_megamenu_icon = get_post_meta( $menu_item->ID, '_menu_item_leap_megamenu_icon', true );

            return $menu_item;
        }

        /**
         * Save menu custom fields
         *
         * @access      public
         * @return      void
         */
        function update_custom_nav_fields( $menu_id, $menu_item_db_id, $args ) {


            $field_name_suffix = array( 'status', 'width', 'columns', 'title', 'icon' );

            foreach ( $field_name_suffix as $key ) {
                if ( !isset( $_REQUEST[ 'menu-item-leap-megamenu-' . $key ][ $menu_item_db_id ] ) ) {
                    $_REQUEST[ 'menu-item-leap-megamenu-' . $key ][ $menu_item_db_id ] = '';
                }

                $value = $_REQUEST[ 'menu-item-leap-megamenu-' . $key ][ $menu_item_db_id ];
                update_post_meta( $menu_item_db_id, '_menu_item_leap_megamenu_' . $key, $value );
            }
        }

        /**
         * Define new Walker edit
         *
         * @access      public
         * @return      void
         */
        function edit_walker( $walker, $menu_id ) {

            return 'Leap_Mega_Edit_Walker';
        }

        /**
         * Add custom fields to menu
         * @param int $item_id
         * @param array $item
         * @param int $depth
         * @param array $args
         */
        function custom_fields( $item_id, $item, $depth, $args ) {
            ?>
            <div class="clear"></div>
            <div class="leap-mega-menu-options">
                <?php if ( $depth == 0 ) { ?>
                    <p class="field-megamenu-status description description-wide">
                        <label for="edit-menu-item-megamenu-status-<?php echo $item_id; ?>">
                            <input type="checkbox" id="edit-menu-item-megamenu-status-<?php echo $item_id; ?>" class="widefat code edit-menu-item-megamenu-status" name="menu-item-leap-megamenu-status[<?php echo $item_id; ?>]" value="enabled" <?php checked( $item->leap_megamenu_status, 'enabled' ); ?> />
                            <strong><?php _e( 'Enable Mega Menu', 'wiz' ); ?></strong>
                        </label>
                    </p>
                    <p class="field-megamenu-columns description description-wide">
                        <label for="edit-menu-item-megamenu-columns-<?php echo $item_id; ?>">
                            <?php _e( 'Mega Menu Number of Columns', 'wiz' ); ?>
                            <select id="edit-menu-item-megamenu-columns-<?php echo $item_id; ?>" class="widefat code edit-menu-item-megamenu-columns" name="menu-item-leap-megamenu-columns[<?php echo $item_id; ?>]">
                                <option value="1" <?php selected( $item->leap_megamenu_columns, '1' ); ?>>1</option>
                                <option value="2" <?php selected( $item->leap_megamenu_columns, '2' ); ?>>2</option>
                                <option value="3" <?php selected( $item->leap_megamenu_columns, '3' ); ?>>3</option>
                                <option value="4" <?php selected( $item->leap_megamenu_columns, '4' ); ?>>4</option>
                                <option value="5" <?php selected( $item->leap_megamenu_columns, '5' ); ?>>5</option>
                                <option value="6" <?php selected( $item->leap_megamenu_columns, '6' ); ?>>6</option>
                            </select>
                        </label>
                    </p>
                <?php } ?>

                <?php if ( $depth == 1 ) { ?>
                    <p class="field-megamenu-title description description-wide">
                        <label for="edit-menu-item-megamenu-title-<?php echo $item_id; ?>">
                            <input type="checkbox" id="edit-menu-item-megamenu-title-<?php echo $item_id; ?>" class="widefat code edit-menu-item-megamenu-title" name="menu-item-leap-megamenu-title[<?php echo $item_id; ?>]" value="disabled" <?php checked( $item->leap_megamenu_title, 'disabled' ); ?> />
                            <?php _e( 'Disable Mega Menu Column Title', 'wiz' ); ?>
                        </label>
                    </p>
                <?php } ?>
                <p class="field-megamenu-icon description description-wide">
                    <label for="edit-menu-item-megamenu-icon-<?php echo $item_id; ?>">
                        <?php _e( 'Menu Icon (use icon full name like <b>fa fa-magic</b> or <b>glyphicon glyphicon-home</b>)', 'wiz' ); ?>
                        <input type="text" id="edit-menu-item-megamenu-icon-<?php echo $item_id; ?>" class="widefat code edit-menu-item-megamenu-icon iconpicker-input" name="menu-item-leap-megamenu-icon[<?php echo $item_id; ?>]" value="<?php echo $item->leap_megamenu_icon; ?>" />
                    </label>
                </p>
            </div>
            <?php
        }

    }

}

// instantiate plugin's class
new Leap_Mega_Menu();

