( function ( $ ) {
    "use strict";

    function init_icon_picker( selector ) {
        jQuery( selector ).iconpicker( {
            placement: 'right',
            selectedCustomClass: 'bg-primary',
            /*
             icons: jQuery.merge( [
             'glyphicon-home',
             'glyphicon-repeat',
             'glyphicon-search',
             'glyphicon-arrow-left',
             'glyphicon-arrow-right',
             'glyphicon-star' ],
             jQuery.iconpicker.defaultOptions.icons ),
             */
            fullClassFormatter: function ( val ) {
                if ( val.match( /^fa-/ ) ) {
                    return 'fa ' + val;
                } else {
                    return 'glyphicon ' + val;
                }
            }

        } ).on( "iconpickerSetSourceValue", function ( event ) {
            var icon_val = event.iconpickerValue;
            var new_icon = '';

            if ( icon_val.match( /^fa-/ ) ) {
                new_icon = 'fa ' + icon_val;
            } else {
                new_icon = 'glyphicon ' + icon_val;
            }

            jQuery( this ).val( new_icon );


        } );
    }


    jQuery( document ).ready( function ( $ ) {

        init_icon_picker( 'input.iconpicker-input' );

        jQuery( document ).on( 'widget-updated', function ( e, widget ) {
            init_icon_picker( 'input.iconpicker-input' );
        } );


        jQuery( "#setting_import_data_text" ).on( "click", "a", function ( event ) {
            event.preventDefault( );
            jQuery( this ).attr( "disabled", "disabled" );
            var import_setting = jQuery( this ).closest( "#setting_import_data_text" );
            var import_data = jQuery( import_setting ).find( '#leap_import_data' ).val( );
            var import_nonce = jQuery( import_setting ).find( '#leap_import_options_nonce' ).val( );
            var wp_http_referer = jQuery( import_setting ).find( 'input[name=_wp_http_referer]' ).val( );
            jQuery.ajax( {
                url: translations.ajax_url,
                type: 'post',
                data: {
                    action: 'leap_import_options',
                    import_data: import_data,
                    nonce: import_nonce,
                    _wp_http_referer: wp_http_referer
                },
                success: function ( message ) {
                    if ( message === 'success' ) {
                        alert( "Theme options have been imported successfully." );
                        location.reload( );
                    } else if ( message === 'empty' ) {
                        alert( "Please copy and paste what appears to be a random string of alpha numeric characters into import textarea" );
                        jQuery( '#setting_import_data_text a' ).removeAttr( "disabled" );
                    } else {
                        alert( "Error: Can't import" );
                        jQuery( '#setting_import_data_text a' ).removeAttr( "disabled" );
                    }
                }
            } );
        } );
    } );
    jQuery( document ).ready( function ( $ ) {

        var img_preview_classes = '#setting_light_ready_made_smart_skins .type-radio-image .option-tree-ui-radio-images img, #setting_dark_ready_made_smart_skins .type-radio-image .option-tree-ui-radio-images img';
        if ( jQuery( img_preview_classes ).length ) {
            jQuery( img_preview_classes ).imgPreview( {
                containerID: 'imgPreviewWithStyles3',
                srcAttr: 'data-preview',
                imgCSS: { width: 400 }
            } );
        }




        jQuery( ".panel-toggle" ).each( function ( index ) {

            jQuery( this ).accordion( {
                collapsible: true,
                heightStyle: "content",
                //active: false
                //set localStorage for current index on activate event
                activate: function ( event, ui ) {
                    localStorage.setItem( "accordion-" + translations.blog_id + '-' + index, jQuery( this ).accordion( "option", "active" ) );
                },
                active: parseInt( localStorage.getItem( "accordion-" + translations.blog_id + '-' + index ) )
            } );
        } );
        jQuery( "#setting_light_ready_made_smart_skins .option-tree-ui-radio" ).change( function ( ) {
            
            var colors = [ '#ffffff', '#ffffff', '#ffffff', '#ffffff', '#ffffff', '#ffffff', '#ffffff', '#ffffff', '#ffffff' ];
            if ( this.value === 'ss1' ) {
                colors = [ '#f67207', '#1c1c1c', '#4c4c4c', '#6c6c6c', '#e3e3e3', '#f7f7f7', '#fcfcfc', '#ffffff', '#2c2c2c' ];
            } else if ( this.value === 'ss2' ) {
                colors = [ '#85773e', '#393420', '#544d2f', '#675e3b', '#cfc4ac', '#e6dfcf', '#eee8da', '#eee8da', '#452e18' ];
            } else if ( this.value === 'ss3' ) {
                colors = [ '#618000', '#405500', '#044c29', '#69a25b', '#d6e5d3', '#e5f2e2', '#f4f9f3', '#f4f9f3', '#044c29' ];
            } else if ( this.value === 'ss4' ) {
                colors = [ '#95c500', '#597600', '#295f26', '#417a3e', '#eaeddf', '#fefefe', '#f4f6ee', '#417a3e', '#f3f5e6' ];
            } else if ( this.value === 'ss5' ) {
                colors = [ '#b7d800', '#1d3e93', '#626262', '#6c81b9', '#ebeef6', '#ebf3f7', '#f9fafb', '#f9fafb', '#151a36' ];
            } else if ( this.value === 'ss6' ) {
                colors = [ '#1997e6', '#333333', '#777777', '#fcfcfc', '#f1f1f1', '#2f2f2f', '#f9f9f9', '#fcfcfc', '#333e48' ];
            } else if ( this.value === 'ss7' ) {
                colors = [ '#3ea9f5', '#363945', '#61636d', '#fcfcfc', '#E8EAED', '#75C4FC', '#f9f9f9', '#fcfcfc', '#42444f' ];
            } else if ( this.value === 'ss8' ) {
                colors = [ '#df75da', '#923e8f', '#752a5c', '#c94591', '#edded5', '#f6ede9', '#fefefe', '#fefefe', '#923e8f' ];
            } else if ( this.value === 'ss9' ) {
                colors = [ '#e49135', '#a63131', '#4c4c4c', '#c57979', '#f4e6e6', '#fcf7f7', '#fcfcfc', '#ffffff', '#a63131' ];
            }

            jQuery( '#primary_color' ).iris( 'color', colors[0] );
            jQuery( '#smart_skin_typography-picker-t1' ).iris( 'color', colors[1] );
            jQuery( '#smart_skin_typography-picker-t2' ).iris( 'color', colors[2] );
            jQuery( '#smart_skin_typography-picker-t3' ).iris( 'color', colors[3] );
            jQuery( '#smart_skin_backgrounds-picker-b1' ).iris( 'color', colors[4] );
            jQuery( '#smart_skin_backgrounds-picker-b2' ).iris( 'color', colors[5] );
            jQuery( '#smart_skin_backgrounds-picker-b3' ).iris( 'color', colors[6] );
            jQuery( '#smart_skin_footer-picker-ft' ).iris( 'color', colors[7] );
            jQuery( '#smart_skin_footer-picker-fb' ).iris( 'color', colors[8] );
        } );
        /**
         * Dark Skins
         */

        jQuery( "#setting_dark_ready_made_smart_skins .option-tree-ui-radio" ).change( function ( ) {
            
            var colors = [ '#ffffff', '#ffffff', '#ffffff', '#ffffff', '#ffffff', '#ffffff', '#ffffff', '#ffffff', '#ffffff' ];
            if ( this.value === 'ssd1' ) {
                colors = [ '#f67206', '#f7f7f7', '#c6c6c6', '#a1a1a1', '#4d4d4d', '#4d4d4d', '#3b3b3b', '#cfcfcf', '#2c2c2c' ];
            } else if ( this.value === 'ssd2' ) {
                colors = [ '#ca965d', '#ddcf9d', '#f0e9d3', '#8cb598', '#585452', '#433b36', '#2b2623', '#c6c0a9', '#37302c' ];
            } else if ( this.value === 'ssd3' ) {
                colors = [ '#8abf3b', '#ffffff', '#898d92', '#969a9f', '#2f3940', '#1e252b', '#131b21', '#898d92', '#0e121c' ];
            } else if ( this.value === 'ssd4' ) {
                colors = [ '#f0db00', '#ffffff', '#f1f1f1', '#fcfcfc', '#3c3c3c', '#2d2d2d', '#222222', '#ffffff', '#1b1b1b' ];
            }

            jQuery( '#primary_color' ).iris( 'color', colors[0] );
            jQuery( '#smart_skin_typography-picker-t1' ).iris( 'color', colors[1] );
            jQuery( '#smart_skin_typography-picker-t2' ).iris( 'color', colors[2] );
            jQuery( '#smart_skin_typography-picker-t3' ).iris( 'color', colors[3] );
            jQuery( '#smart_skin_backgrounds-picker-b1' ).iris( 'color', colors[4] );
            jQuery( '#smart_skin_backgrounds-picker-b2' ).iris( 'color', colors[5] );
            jQuery( '#smart_skin_backgrounds-picker-b3' ).iris( 'color', colors[6] );
            jQuery( '#smart_skin_footer-picker-ft' ).iris( 'color', colors[7] );
            jQuery( '#smart_skin_footer-picker-fb' ).iris( 'color', colors[8] );
        } );
    } );
} )( jQuery );