<?php
add_action( 'wp_head', 'leap_internal_css', 999 );

function leap_internal_css() {
    ?>
    <style type="text/css">

        <?php
        $page_id    = leap_get_current_page_id();
        $sidebar_id = leap_get_current_sidebar_style();

        $container_width = ot_get_option( 'container_width', array() );
        if ( empty( $container_width[ 0 ] ) ) {
            $container_width[ 0 ] = '1140';
        }
        if ( empty( $container_width[ 1 ] ) ) {
            $container_width[ 1 ] = 'px';
        }
        $container_width[ 0 ] = intval( ($container_width[ 0 ]) ? $container_width[ 0 ] : '1140'  );
        $container_width[ 1 ] = ($container_width[ 1 ]) ? $container_width[ 1 ] : 'px';
        ?>
        .container-fluid, .container {
            max-width: <?php echo $container_width[ 0 ] . $container_width[ 1 ]; ?>;
        }
        @media (min-width: 1200px) {
            .container-fluid, .container {
                width: auto;
            }
        }
        <?php if ( ot_get_option( 'disable_responsive', 'no' ) == 'yes' ) { ?>
            .container-fluid, .container, body.boxed #leap-wrapper  {
                width: <?php echo $container_width[ 0 ] . $container_width[ 1 ]; ?> !important;
                max-width: none !important;
            }
        <?php } ?>

        #leap-wrapper.container {
            padding: 0;
        }

        .sf-menu .container-fluid.sf-mega.menu-fullwidth {
            max-width: <?php echo $container_width[ 0 ] . $container_width[ 1 ]; ?>;
        }

        /******************* skin ***********************/

        <?php
        $theme_skin             = ot_get_option( 'theme_skin', 'light' );
        $primary_color          = ot_get_option( 'primary_color', '#F67207' );
        $smart_skin_typography  = ot_get_option( 'smart_skin_typography', array( 't1' => '#1c1c1c', 't2' => '#4c4c4c', 't3' => '#6c6c6c' ) );
        $smart_skin_backgrounds = ot_get_option( 'smart_skin_backgrounds', array( 'b1' => '#e3e3e3', 'b2' => '#f7f7f7', 'b3' => '#fcfcfc' ) );
        $smart_skin_footer      = ot_get_option( 'smart_skin_footer', array( 'ft' => '#ffffff', 'fb' => '#2c2c2c' ) );
        ?>
        /******** primary color ***********/

        /******* Buttons ****/
        .btn-leap, a.btn-leap, input[type="submit"], input[type="reset"], input[type="button"] {
            background-color: <?php echo $primary_color; ?>;
            border: 1px solid <?php echo leap_color_brightness( $primary_color, 0.9, 'dark' ); ?>;
        }
        .btn-leap:hover, .btn-leap:focus, .btn-leap:active, .btn-leap:active:focus, input[type="submit"]:hover, 
        input[type="reset"]:hover, input[type="button"]:hover {
            background-color: <?php echo leap_color_brightness( $primary_color, 0.9, 'dark' ); ?>;
            border-color: <?php echo leap_color_brightness( $primary_color, 0.9, 'dark' ); ?>;
        }
        #footer-sidebar .btn-leap, #footer-sidebar input[type="submit"], #footer-sidebar  input[type="reset"], 
        #footer-sidebar input[type="button"], #footer-sidebar .btn-leap:hover, #footer-sidebar .btn-leap:focus, 
        #footer-sidebar .btn-leap:active, #footer-sidebar .btn-leap:active:focus, #footer-sidebar input[type="submit"]:hover, 
        #footer-sidebar input[type="reset"]:hover, #footer-sidebar input[type="button"]:hover {
            color: <?php echo leap_hex2rgba( $smart_skin_footer[ 'ft' ], '0.7', true ) ?>; 
        }
        a:hover, a:focus, a:active, .main-menu li a:hover, .main-menu li a:focus, .main-menu li a:active, .main-menu li.sfHover > a,
        .main-menu li a:hover span, .main-menu li a:focus span, .main-menu li a:active span,
        div.entry-title h1, .item-overlay .item-links a:hover:before, 
        .leap-post-details .post-type, .entry-meta a:hover, .entry-meta a:active, .entry-meta a:focus, 
        .entry-meta a:hover span, .leap-share-buttons a:hover i, .header a#searchbutton:hover, 
        .header a#searchbutton:focus, .header a#searchbutton:active, p.social-networks a:hover i, 
        p.social-networks a:focus i, .main-menu li.current-menu-item > a, 
        .main-menu li.current-page-ancestor > a, 
        .main-menu li.current-page-ancestor > a:hover,
        .main-menu li.current-menu-ancestor > a, 
        .main-menu li.current-menu-ancestor > a:hover, 
        .main-menu li.current-menu-parent > a, 
        .main-menu li.current-menu-parent > a:hover, 
        .main-menu li.current_page_ancestor > a, 
        .main-menu li.current_page_ancestor > a:hover,.top-menu li > a:hover, .top-menu a:focus,
        .top-menu a:active, .top-men li.current_page_item > a, .top-menu li.current_page_ancestor > a, 
        .top-menu ul li.current_page_item a, #crumbs a:hover, #crumbs a:active, #crumbs a:focus, 
        .ui-accordion .ui-accordion-header:hover, 
        .ui-accordion .ui-accordion-header .ui-accordion-header-icon:before, 
        .ui-accordion h3.ui-accordion-header-active, .price em.exact_price, .price sup, ul.ul-leap li:before,
        .sc-rposts .leap-content .post-title a:hover, .sc-rposts .leap-content .post-title a:active, 
        .sc-rposts .leap-content .post-title a:focus, .sc-rposts .post-comment a:hover, 
        .style-1.table tr th, .style-2.table tr th, .list_carousel .cfs-nav span:hover:before, 
        .widget a:hover, .widget a:focus, .widget a:active, ol.commentlist div.comment-author a:hover ,
        ol.commentlist div.comment-author a:active ,ol.commentlist div.comment-author a:focus, 
        .pagination ul > .active > a, .pagination ul > .active > span, ul.portfolio-tabs li a:hover, 
        ul.portfolio-tabs li.active a, #footer-sidebar .widget a:hover, #footer-sidebar .widget a:active,
        #footer-sidebar .widget a:focus, .post-navigation div:hover span, .post-navigation div:hover a, 
        .archive-info .author-links i:hover, #tag-cloud a:hover, .tags a:hover, 
        #leap-contact .contact-info div strong, .widget.widget_rss h4.widget-title a, 
        .leap-widget-style2 .widget.widget_rss h4.widget-title a, 
        .leap-widget-style8 .widget.widget_rss h4.widget-title a, 
        .leap-widget-style7 .widget.widget_rss h4.widget-title a,
        .widget.widget_rss h4.widget-title a:hover, 
        .leap-widget-style2 .widget.widget_rss h4.widget-title a:hover, 
        .leap-widget-style8 .widget.widget_rss h4.widget-title a:hover, 
        .leap-widget-style9 .widget.widget_rss h4.widget-title a:hover, 
        ul.products li.product .price, .cart-loading:hover, .entry-summary .price .amount, 
        .woocommerce .price .amount, .widget.woocommerce .price ins, .widget.woocommerce ins span.amount,
        .widget.woocommerce ins, .widget.woocommerce span.amount, 
        .yith-woocompare-widget ul.products-list a.remove, .cart_totals.calculated_shipping table td .amount,
        .shipping_calculator h2 a, .cart-collaterals h2, .cross-sells h2, table.shop_table .order-total th, 
        table.shop_table .order-total td, .woocommerce .login span.required, .myaccount_user strong, 
        .myaccount_user a, .woocommerce-account .woocommerce > h2, .header.title h3, 
        .single_variation_wrap .single_variation span span, .woocommerce-tabs ul.tabs li.active a, 
        .yith-woocompare-widget a.clear-all:after, .yith-woocompare-widget a.clear-all:before,
        ul.order_details li:before, .shop_table.order_details tfoot tr:last-child .amount, 
        .customer_details dt, .woocommerce-tabs ul.tabs li a:hover, ul.products li.product h3:hover, 
        ul.products li.product h3:focus,
        #leap-footer .footer-block a:hover, #leap-footer .footer-block a:focus, 
        #leap-footer .footer-block a:active, #leap-footer .footer-block a:hover span, 
        .sc-rposts.style-2 .leap-post-entry .post-type:hover a.item-icon, 
        .woocommerce #content table.wishlist_table.cart a.remove:hover, 
        .ui-tabs .ui-tabs-nav li.ui-tabs-active .ui-tabs-anchor, 
        .ui-tabs .ui-tabs-nav li.ui-state-disabled .ui-tabs-anchor, 
        .ui-tabs .ui-tabs-nav li.ui-tabs-loading .ui-tabs-anchor , 
        .leap-sc-tabs.horizontal.style-3 .ui-tabs-nav .ui-state-active .ui-tabs-anchor, 
        .leap-sc-tabs.vertical.style-3 .ui-tabs-nav .ui-state-active .ui-tabs-anchor, 
        .slicknav_nav li a:hover, .slicknav_nav li.slicknav_parent:hover > a, 
        .slicknav_nav .slicknav_item a:hover a, .slicknav_nav .slicknav_row:hover, 
        .slicknav_nav .slicknav_open > .slicknav_row a, .slicknav_nav li.slicknav_open:hover > *, 
        .pagination ul > li > a:hover, span.bbp-admin-links a:hover,
        span.bbp-admin-links a:focus, span.bbp-admin-links a:active , 
        .status-publish .bbp-topic-meta a:hover , .status-publish .bbp-topic-meta a:focus, 
        #lang_sel a.lang_sel_sel:hover, #lang_sel a.lang_sel_sel:focus, .icon-box2:hover .main-icon i,
        .header12 .menu-icon:hover, .header12 .menu-icon:focus:hover,.header13 .menu-icon:hover, .header13 .menu-icon:focus:hover,
        .header14 a.menu-icon:hover .fa-bars, .header14 a.menu-icon:focus:hover .fa-bars, .woocommerce-MyAccount-navigation li.is-active a {
            color: <?php echo $primary_color; ?>;
        }
        .leap-post-details .post-type, .post-icon a:hover, .post-icon a:hover, .leap-pricing-table .featured ul li.title-row, 
        .leap-pricing-table .column:hover ul li.title-row, .sep-boxed-pricing.leap-pricing-table .column:hover ul li.title-row, 
        .pagination ul > li.active > a span, .pagination ul > li.active > a:hover span, a.scrollup:hover, 
        .leap-overlay .item-img-color, .leap-widget-style3 .widget-title, .leap-widget-style6 .widget-head, 
        .leap-widget-style7 .widget-head, .woocommerce-pagination ul li span.current, 
        .yith-woocompare-widget ul.products-list a.remove:hover, .price_slider_wrapper .ui-slider .ui-slider-range, 
        .widget.woocommerce.widget_layered_nav_filters ul li a, .chosen-container .chosen-results li:hover, 
        .chosen-container .chosen-results li:focus, .chosen-container .chosen-results li:active, 
        .chosen-container .chosen-results li.highlighted, .searchform form button.btn, div.static-search form button.btn, .onsale, 
        .leap-sc-tabs.horizontal.style-3 .ui-tabs-nav .ui-tabs-anchor, .leap-sc-tabs.vertical.style-3 .ui-tabs-nav .ui-tabs-anchor, 
        .pagination-page ul > li > span, .pagetitle2 div.entry-title h1:after, #bbpress-forums div.bbp-forum-author .bbp-author-role,
        div.title.title-style3 .title-heading, div.title.title-style4 .title-heading, .leap-widget-style11 div.title .widget-title:after , 
        .header #nav-icon.icon-close span, .header #nav-icon.active span ,.title-style8 .strip:before, .header16 #v-menu li a:after  {
            background-color: <?php echo $primary_color; ?>;
        }
        blockquote, .topbar-block, .main-menu li:hover, .main-menu li:active, .main-menu li:focus, .main-menu li.sfHover, 
        .header2, 
        .leap-pricing-table ul li.footer-row, .tagline-box.tagline-4, .wdg-counter li a:hover i, .pagination ul > li.active > a span, 
        .pagination ul > li.active > a:hover span, ul.portfolio-tabs li.active a, .leap-widget-style3 .widget-head, 
        .leap-widget-style4 .widget-title, .leap-widget-style8 .widget-head, .leap-widget-style9 div.title .widget-title, 
        .sf-menu .menu-item-cart .widget_shopping_cart_content, .woocommerce-pagination ul li span.current, .header .topbar-block, 
        .header4 .topbar-block, .header5 .topbar-block, .header6 .topbar-block, .slicknav_nav li:hover, 
        .pagination-page ul > li > span, .pagetitle3 .entry-title, div.title.title-style3, div.title.title-style5, 
        div.title.title-style6 .title-heading, div.title.title-style7 .title-heading, .main-menu ul li a:hover, 
        .leap-testimonials-2 .person-image img {
            border-color: <?php echo $primary_color; ?>;
        }
        .leap-widget-style5 .widget-content, .leap-widget-style9 .widget-title:before, 
        div.title.title-style7 .title-heading:before,
        .header-vh .sf-menu > li:hover, .header-vh .sf-menu > li:focus, .header-vh .sf-menu > li:active {
            border-bottom-color: <?php echo $primary_color; ?>;
        }
        div.title.title-style2 .title-heading , div.title.title-style2.alignright .title-heading, 
        div.title.title-style2.title-center .title-heading{
            border-left-color: <?php echo $primary_color; ?>;
            border-right-color: <?php echo $primary_color; ?>;
        }
        /******** smart skin ***********/	
        a, .main-menu a, .main-menu .mega-section-head a, .main-menu .mega-section-head > span, a#searchbutton, .widget-title, 
        .widget a, .ui-accordion .ui-accordion-header, .ui-accordion .ui-accordion-header-active span.ui-accordion-header-icon:before, 
        .leap-icon-box .col .heading h4, h1, h2, h3, h4, h5, h6, .pagination a, .item-overlay a, 
        .woocommerce #content table.wishlist_table.cart a.remove, .slicknav_nav a, .main-menu > li a:hover span.menu-item-description, 
        .main-menu > li a:active span.menu-item-description, .main-menu > li a:focus span.menu-item-description, 
        .main-menu > li:visited a span.menu-item-description, .main-menu > li.current-menu-item a span.menu-item-description, 
        .header.header-vh .contact-info, .header.header-vh .contact-info span, 
        .header.header-vh .contact-info a, .header.header-vh p.social-networks a, 
        .header12 .menu-icon, .header12 .menu-icon:focus,.header13 .menu-icon, .header13 .menu-icon:focus,
        .menu-icon .fa-close, .menu-icon:focus .fa-close, .menu-icon:hover .fa-close , 
        .menu-icon:focus:hover .fa-close {
            color: <?php echo $smart_skin_typography[ 't1' ]; ?>;
        }
        .slicknav_btn {
            background-color: <?php echo leap_hex2rgba( $smart_skin_typography[ 't1' ], '0.7', true ) ?>;
        }
        body, caption, select, textarea, .widget.woocommerce ul li del span.amount, 
        .entry-summary .price del .amount, .product-price-rate .price del .amount, 
        .woocommerce .price del, .chosen-container-single .chosen-single, 
        #reviews .stars a, #reviews .stars a:hover, 
        .wishlist_table tr td.product-stock-status span.wishlist-in-stock, 
        input[type="text"], input[type="text"]:focus, .form-control, .form-control:focus, 
        textarea, textarea:focus, input[type="password"], input[type="password"]:focus, 
        input[type="email"], input[type="date"], input[type="number"], input[type="email"]:focus,
        input[type="date"]:focus, input[type="number"]:focus, input[type="tel"],
        input[type="tel"]:focus, .variations .label, div.bbp-template-notice, div.indicator-hint,
        .select2-container .select2-choice, .select2-container .select2-choice:focus,
        #lang_sel a.lang_sel_sel, #lang_sel ul ul a, #lang_sel ul ul a:hover, #lang_sel ul ul a:focus, legend {
            color: <?php echo $smart_skin_typography[ 't2' ]; ?>;
        }
        ::-moz-placeholder , .form-control::-moz-placeholder {
            color: <?php echo $smart_skin_typography[ 't2' ]; ?>;
        }
        ::-ms-input-placeholder, .form-control::-ms-input-placeholder {
            color: <?php echo $smart_skin_typography[ 't2' ]; ?>;
        }
        ::-webkit-input-placeholder, .form-control::-webkit-input-placeholder {
            color: <?php echo $smart_skin_typography[ 't2' ]; ?>;
        }
        .main-menu > li:before, ul.portfolio-tabs li:before, .post-not-found-head h1, .post-not-found-head p , 
        small.small, .widget span.date, .widget_recent_entries ul li span.post-date, .widget .rss-date, small a, 
        .commentmetadata a , .wp-caption, .wp-caption a, .widget_display_topics li div, .widget_display_replies li div {
            color: <?php echo leap_hex2rgba( $smart_skin_typography[ 't2' ], '0.6', true ) ?>;
        }
        .header-vh .sf-menu > li {
            border-color: <?php echo leap_hex2rgba( $smart_skin_typography[ 't2' ], '0.6', true ) ?>;
        } 
        #nav-icon, .header17 .logo a:after {
            background-color: <?php echo leap_hex2rgba( $smart_skin_typography[ 't2' ], '0.9', true ) ?>;
        }
        .header14 .menu-icon {
            background-color: <?php echo leap_hex2rgba( $smart_skin_typography[ 't2' ], '0.9', true ) ?>;
        }
        div.entry-title h1, #crumbs span, #crumbs a {
            color: <?php echo $smart_skin_typography[ 't3' ]; ?>;
        }
        h5.subtitle {
            color: <?php echo leap_hex2rgba( $smart_skin_typography[ 't3' ], '0.7', true ) ?>;
        }
        .leap-testimonials-2 .testimonial-text-container > .fa {
            color: <?php echo leap_hex2rgba( $smart_skin_typography[ 't3' ], '0.3', true ) ?>;
        }
        blockquote p, .single-quotes-bg, .double-quotes-bg, .highlight, .leap-share-buttons i, .header.header2 .contact-info, 
        .header.header2 .contact-info span, .header.header2 .contact-info a, .archive-info .author-links i, .archive-info .author-links, 
        .post-icon a:before, mark, .header.header2 p.social-networks a, .header.header15 p.social-networks a {
            color: <?php echo leap_color_brightness( $smart_skin_typography[ 't2' ], 0.7, $theme_skin ); ?>;
        }
        #bbpress-forums ul.bbp-topics, #bbpress-forums .bbp-forum-info .bbp-forum-content, 
        #bbpress-forums .status-publish p.bbp-topic-meta, #bbpress-forums ul.bbp-forums, .bbp-reply-content, .bbp-forum-freshness a, 
        .bbp-topic-freshness a , .bbp-pagination-count, #bbpress-forums ul.bbp-lead-topic, .status-publish .bbp-topic-meta a {
            color: <?php echo leap_color_brightness( $smart_skin_typography[ 't2' ], 0.8, $theme_skin ); ?>;
        }
        #bbpress-forums li.bbp-header, #bbpress-forums li.bbp-footer, #bbpress-forums .status-closed, 
        #bbpress-forums .status-closed a, #bbpress-forums li.bbp-header .bbp-reply-content, 
        #bbpress-forums li.bbp-footer .bbp-reply-content, span.bbp-admin-links a, .bbp-reply-post-date, 
        .bbp-forum-header a.bbp-forum-permalink, .bbp-topic-header a.bbp-topic-permalink, .bbp-reply-header a.bbp-reply-permalink {
            color: <?php echo leap_color_brightness( $smart_skin_typography[ 't2' ], 0.4, $theme_skin ); ?>;
        }
        .pagination ul > li > a span, .wdg-post img , #calendar_wrap , #wp-calendar tr, 
        .post_tags .label , select , .leap-widget-style5 .widget-content, .leap-widget-style8 .widget, 
        img.avatar, .avatar > img , .commentlist .thread-even .comment-text em, 
        .blog-grid .hentry .entry-wrapper, .archive-grid .hentry .entry-wrapper, 
        #main .ui-accordion .ui-accordion-content img, .style-2 .ui-accordion-header:hover, 
        .style-2 .ui-accordion-header .ui-accordion-header-icon:before, 
        .style-2 .ui-accordion-header-active , .style-3 .ui-accordion-header:hover, 
        .style-3 .ui-accordion-header .ui-accordion-header-icon:before, 
        .style-3 .ui-accordion-header-active , .style-3 .ui-accordion-header-active, 
        .dropcap.style-2, .testimonial .company-details .person-image img , 
        .testimonial .testimonial-content, .flickr-wrapper .flickr_badge_image img, 
        .leap-pricing-table .column > ul, .tagline-box.tagline-4 , .sc-rposts .item-img, .table-responsive
        .table>thead>tr>th, .table>thead>tr>th, .table>tbody>tr>th, .table>tfoot>tr>th, 
        .table>thead>tr>td, .table>tbody>tr>td, .table>tfoot>tr>td, .leap-table,
        .woocommerce.widget_product_categories ul li, .woocommerce .widget_layered_nav ul li, 
        .woocommerce .widget_layered_nav ul li, .woocommerce-page .widget_layered_nav ul li, 
        .woocommerce-page .widget_layered_nav ul li , .woocommerce ul.cart_list li img, 
        .woocommerce ul.product_list_widget li img, .woocommerce-page ul.cart_list li img, 
        .woocommerce-page ul.product_list_widget li img, .main-menu .menu-item-cart ul.cart_list li, 
        .main-menu .menu-item-cart ul.cart_list li:first-child, .product-container, .product-list-hover,
        ul.products .product-list-hover .button.add_to_cart_button, 
        ul.products .product-list-hover .button.product_type_simple, 
        ul.products .product-list-hover .button.product_type_grouped, div.product div.images img, 
        .woocommerce-tabs .entry-content, .woocommerce-tabs ul.tabs li.active a, 
        .main-menu .widget_shopping_cart_content .buttons, .main-menu .menu-item-cart ul.cart_list li a img, 
        .woocommerce-message, .woocommerce-info, .chosen-container-active.chosen-with-drop .chosen-single, 
        #reviews .comment_container img,
        .woocommerce-billing-fields .chosen-container-single .chosen-single, 
        .chosen-container-single .chosen-single, table.shop_table th, div table.shop_table td, 
        .cart_totals table td , .cart_totals table th, .woocommerce table.wishlist_table thead th, 
        .woocommerce table.wishlist_table tbody td, .shop_attributes tr , .leap-separator span, 
        .leap-sc-tabs.horizontal.style-1 .ui-tabs-nav .ui-state-active .ui-tabs-anchor, 
        .leap-sc-tabs.horizontal.style-1 .ui-tabs-panel, 
        .leap-sc-tabs.horizontal.style-2 .ui-tabs-nav .ui-state-active .ui-tabs-anchor, 
        .leap-sc-tabs.horizontal.style-2 .ui-tabs-panel, 
        .leap-sc-tabs.horizontal.style-2 .ui-tabs-nav .ui-tabs-anchor, 
        .leap-sc-tabs.vertical.style-1 .ui-tabs-nav .ui-state-active .ui-tabs-anchor, 
        .leap-sc-tabs.vertical.style-1 .ui-tabs-panel, 
        .leap-sc-tabs.vertical.style-2 .ui-tabs-nav .ui-state-active .ui-tabs-anchor, 
        .leap-sc-tabs.vertical.style-2 .ui-tabs-panel , .widget.leatabs .ui-tabs-panel li, 
        .comment-body, input[type="text"], input[type="text"]:focus, .form-control, .form-control:focus,
        textarea, textarea:focus, input[type="password"], input[type="password"]:focus, input[type="email"],
        input[type="date"], input[type="number"], input[type="email"]:focus, input[type="tel"],
        input[type="tel"]:focus, input[type="date"]:focus, input[type="number"]:focus, 
        .select2-container .select2-choice, #bbpress-forums .hentry div.bbp-reply-content, 
        #bbpress-forums .hentry div.bbp-topic-content, #bbpress-forums .hentry div.bbp-reply-content:before,
        #bbpress-forums .hentry div.bbp-topic-content:before, #lang_sel a.lang_sel_sel, 
        #lang_sel a.lang_sel_sel:hover, #lang_sel a.lang_sel_sel:focus, #lang_sel ul ul a, 
        #lang_sel ul ul a:hover, #lang_sel ul ul a:focus, #lang_sel ul ul, #main-menu .menu-item-cart ul.cart_list li a img,
        .yith-woocompare-widget ul li, #bbpress-forums #bbp-your-profile fieldset input, 
        #bbpress-forums #bbp-your-profile fieldset textarea, form#new-post, .comment.list li img,
        .blog-large-modern .entry-content, .archive-large-modern .entry-content,
        .blog-large-modern .entry-content .post-content, .archive-large-modern .entry-content .post-content,
        .blog-large-modern .entry-content, .archive-large-modern .entry-content, .woocommerce-MyAccount-navigation li, .woocommerce-MyAccount-content,
        .leap-widget-style11 > div.widget {
            border-color: <?php echo $smart_skin_backgrounds[ 'b1' ]; ?>;
        }
        .rtl .leap-sc-tabs.horizontal.style-2 .ui-tabs-nav .ui-tabs-anchor, #bbpress-forums .bbp-forums-list {
            border-left-color: <?php echo $smart_skin_backgrounds[ 'b1' ]; ?>;
        }
        .header2 .topbar-block, .main-menu ul li a, .widget_archive ul li, .widget_categories ul li, .widget_nav_menu ul li, 
        .widget_meta ul li , .widget_pages ul li, .widget_recent_comments ul li, .widget_recent_entries ul li, .widget_rss ul li, 
        div.category-posts ul li , .widget.comments-avatar ul li, .widget_author_posts ul li, .widget.posts-list ul li, .widget.leap-tabs .ui-tabs-panel li, div.widget.category-posts ul li,
        .widget.tweets ul li, .leap-widget-style4 .widget-head, .leap-widget-style9 .widget-head, ol.commentlist li , 
        .post-entry, .style-2 .ui-accordion-content, .accordion.style-3, .toggle-open.style-3:last-child, .toggle.style-3:last-child , 
        .toggle.style-3 , ul.feedlist > li, div.sep1, div.sep2 , .sc-rposts.style-2 .leap-date .sc-recent-posts-date-day, 
        .portfolio-sep, .project-details .box, .slicknav_nav li, .widget_display_forums li, .widget_display_replies li, 
        .widget_display_topics li, .widget_display_views li , .woocommerce ul.product_list_widget li , 
        .main-menu .menu-item-cart .widget_shopping_cart_content, .navbar-fixed-top.fixed-header, 
        .blog-wrapper .hentry, .archive-wrapper .hentry, #main-menu .menu-item-cart ul.cart_list li, 
        #main-menu .menu-item-cart ul.cart_list li:first-child, #main-menu .menu-item-cart .widget_shopping_cart_content,
        div.title.title-style6, div.title.title-style7, .header-vh .sf-menu > li , .woocommerce-MyAccount-navigation li, .person2 .person-img {
            border-bottom-color: <?php echo $smart_skin_backgrounds[ 'b1' ]; ?>;
        }
        .header2 .topbar-block, .header4 .navbar-inner, .header5 .navbar-inner, .header6 .navbar-inner, .separator-widget, 
        ol.commentlist ul.children li, .ui-accordion .ui-accordion-header, .ui-accordion .ui-accordion-content , 
        .style-3 .ui-accordion-header, .toggle-open.style-3, .toggle.style-3, .testimonial .testimonial-content:before, 
        table>thead>tr>th, table>tbody>tr>th, table>tfoot>tr>th, table>thead>tr>td, table>tbody>tr>td, table>tfoot>tr>td, 
        #bbpress-forums li.bbp-body ul.forum, #bbpress-forums li.bbp-body ul.topic {
            border-top-color: <?php echo $smart_skin_backgrounds[ 'b1' ]; ?>;
        }
        .style-2 .ui-accordion-content, .style-3 .ui-accordion-header , .style-3 .ui-accordion-content, .toggle-open.style-3, .toggle.style-3 {
            border-left-color: <?php echo $smart_skin_backgrounds[ 'b1' ]; ?>;
            border-right-color: <?php echo $smart_skin_backgrounds[ 'b1' ]; ?>;
        }
        #post-not-found .input-prepend.input-append .add-on:first-child {
            border-right-color: <?php echo $smart_skin_backgrounds[ 'b1' ]; ?>;
        }
        span.bbp-admin-links {
            color: <?php echo $smart_skin_backgrounds[ 'b1' ]; ?>;
        }
        .icon-box2 {
            background-color: <?php echo esc_attr($smart_skin_backgrounds[ 'b1' ]); ?>;
        }
        .searchform .navbar-search, .leap-sc-tabs.horizontal.style-1 .ui-tabs-nav .ui-tabs-anchor, 
        .leap-sc-tabs.vertical.style-1 .ui-tabs-nav .ui-tabs-anchor, #bbpress-forums p.bbp-topic-meta img.avatar, 
        #bbpress-forums ul.bbp-reply-revision-log img.avatar, #bbpress-forums ul.bbp-topic-revision-log img.avatar, 
        #bbpress-forums div.bbp-template-notice img.avatar, #bbpress-forums .widget_display_topics img.avatar, 
        #bbpress-forums .widget_display_replies img.avatar, #bbpress-forums div.bbp-forum-author img.avatar, 
        #bbpress-forums div.bbp-topic-author img.avatar, #bbpress-forums div.bbp-reply-author img.avatar, 
        div.bbp-template-notice, div.indicator-hint {
            border-color:  <?php echo leap_color_brightness( $smart_skin_backgrounds[ 'b1' ], 0.5, $theme_skin ); ?>;
        }
        blockquote, .main-menu ul li, .main-menu ul ul li, .main-menu ul li:hover, .main-menu ul li:focus, .main-menu ul li.sfHover, 
        span.mega-section-head, .sf-menu .sf-mega, .sf-menu .sf-mega.menu-fullwidth .row, span:hover.mega-section-head, .main-menu .menu-item-has-megamenu ul ul li, 
        .searchform .navbar-search, .static-search .navbar-search, .widget_calendar a, .wdg-counter li a i, .leap-widget-style7 .widget,
        .leap-widget-style8 .widget, .leap-share-buttons , .hentry .leap-share-buttons, .post-icon a, .archive-info .author-links, 
        .ui-accordion .ui-accordion-header-active, .ui-accordion .ui-accordion-header:hover, .single-quotes-bg, .double-quotes-bg, 
        .layout-icon-boxed .col, .testimonial .testimonial-content, .highlight , .leap-pricing-table ul li, .tagline-box.tagline-2, 
        .leap-post-details .post-type:hover, .style-2.table tr th, .list_carousel .cfs-nav span:before, .portfolio-tabs, 
        .woocommerce .widget_shopping_cart .buttons, .woocommerce-page .widget_shopping_cart .buttons, 
        .woocommerce.widget_shopping_cart .buttons, .ui-accordion .ui-accordion-content, .style-3.ui-accordion .ui-accordion-content, 
        .style-2.ui-accordion .ui-accordion-header, .cart-loading, .woocommerce-tabs ul.tabs li a, table.shop_table thead tr, 
        table.shop_table tr:nth-child(even), ul.payment_methods li div p , 
        .entry-summary .product-buttons .leap-yith-wcwl-add-to-wishlist a:before, 
        .entry-summary .product-buttons a.compare.button:before, .leap-sc-tabs.horizontal.style-1 .ui-tabs-nav .ui-tabs-anchor, 
        .leap-sc-tabs.horizontal.style-3 .ui-tabs-nav .ui-state-active .ui-tabs-anchor, 
        .leap-sc-tabs.horizontal.style-3 .ui-tabs-panel , .leap-sc-tabs.vertical.style-1 .ui-tabs-nav .ui-tabs-anchor, 
        .leap-sc-tabs.vertical.style-3 .ui-tabs-nav .ui-state-active .ui-tabs-anchor, .leap-sc-tabs.vertical.style-3 .ui-tabs-panel, 
        .slicknav_nav , .slicknav_nav li a:hover, .slicknav_nav li.slicknav_parent:hover a a, .slicknav_nav .slicknav_item a:hover a, 
        .slicknav_nav .slicknav_row:hover, .slicknav_nav .slicknav_open > .slicknav_row a, .slicknav_nav li.slicknav_open:hover > *, 
        .slicknav_nav a, #bbpress-forums #bbp-single-user-details #bbp-user-navigation li.current a, div.bbp-template-notice, 
        div.indicator-hint, .quicktags-toolbar, mark, .leap-widget-style10 .widget, .entry-summary .product-buttons .leap-yith-wcwl-add-to-wishlist a:after, 
        .entry-summary .product-buttons a.compare.button:after  {
            background-color: <?php echo leap_color_brightness( $smart_skin_backgrounds[ 'b1' ], 0.5, $theme_skin ); ?>;
        }
        .searchform .navbar-search:before , .quicktags-toolbar {
            border-bottom-color: <?php echo leap_color_brightness( $smart_skin_backgrounds[ 'b1' ], 0.5, $theme_skin ); ?>;
        }
        .testimonial .testimonial-content:after {
            border-top-color: <?php echo leap_color_brightness( $smart_skin_backgrounds[ 'b1' ], 0.5, $theme_skin ); ?>;
        }
        .person2 .person-data {
            background-color: <?php echo esc_attr($smart_skin_backgrounds[ 'b1' ]); ?>;
        }
        div#title {
            background-color: <?php echo $smart_skin_backgrounds[ 'b2' ]; ?>;
        }
        .framed #leap-wrapper {
            border-color: <?php echo $smart_skin_backgrounds[ 'b2' ]; ?>;
        }
        #leap-wrapper, .navbar-inner, .boxed .header8 .mainmenu-logo-container .nav-container ,.wide .header8 .mainmenu-logo-container , 
        .header8 .mainmenu-logo-container.boxed-header .mainmenu-logo, .boxed .header9 .mainmenu-logo-container .nav-container ,
        .wide .header9 .mainmenu-logo-container , .header9 .mainmenu-logo-container.boxed-header .mainmenu-logo, 
        .header7 .navbar-inner.navbar-fixed-top.fixed-header, 
        .header8 .navbar-inner.navbar-fixed-top.fixed-header, .header9 .navbar-inner.navbar-fixed-top.fixed-header, 
        .ui-accordion .ui-accordion-header, .style-2 .ui-accordion-content, .style-3 .ui-accordion-header-active, 
        .style-3 .ui-accordion-header:hover , .leap-pricing-table ul li:nth-child(2n+1), .navbar-inner.navbar-fixed-top.fixed-header, 
        .leap-sc-tabs.horizontal.style-1 .ui-tabs-nav .ui-state-active .ui-tabs-anchor, 
        .leap-sc-tabs.horizontal.style-1 .ui-tabs-panel, 
        .leap-sc-tabs.horizontal.style-2 .ui-tabs-nav .ui-state-active .ui-tabs-anchor, 
        .leap-sc-tabs.horizontal.style-2 .ui-tabs-panel, .leap-sc-tabs.vertical.style-1 .ui-tabs-nav .ui-state-active .ui-tabs-anchor, 
        .leap-sc-tabs.vertical.style-1 .ui-tabs-panel , .leap-sc-tabs.vertical.style-2 .ui-tabs-nav .ui-state-active .ui-tabs-anchor,
        .leap-sc-tabs.vertical.style-2 .ui-tabs-panel, .leap-sc-tabs.vertical.style-2 .ui-tabs-nav .ui-tabs-anchor, 
        .slicknav_menu .slicknav_icon-bar, #bbpress-forums .hentry div.bbp-reply-content:before, 
        #bbpress-forums .hentry div.bbp-topic-content:before, .header10 , 
        .header11 , .header12 .header-vh-wrapper, .header13 .header-vh-wrapper , .header15 .icon-header {
            background-color: <?php echo $smart_skin_backgrounds[ 'b3' ]; ?>;
        }
        .header14 .header-vh-wrapper .header-content {
            background-color: <?php echo leap_hex2rgba( $smart_skin_backgrounds[ 'b3' ], '0.9', true ) ?>;
        }
        .icon-box2 .icon-box-details {
            background-color: <?php echo leap_hex2rgba( $smart_skin_backgrounds[ 'b3' ], '0.6', true ) ?>;
        }
        .header14 a.menu-icon .fa-bars, .header14 a.menu-icon:focus .fa-bars {
            color: <?php echo $smart_skin_backgrounds[ 'b3' ]; ?>;
        }
        .header #nav-icon span {
            background-color: <?php echo esc_attr($smart_skin_backgrounds[ 'b3' ]); ?>;
        }
.product-container , .product-list-details, .product-list-hover, .woocommerce-tabs ul.tabs li.active a, .woocommerce-tabs .entry-content {
            background-color: <?php echo leap_color_brightness( $smart_skin_backgrounds[ 'b3' ], 1, 'dark' ); ?>;
}
        .leap-sc-tabs.vertical.style-2 .ui-tabs-nav .ui-tabs-anchor {
            border-color: <?php echo $smart_skin_backgrounds[ 'b3' ]; ?>;
        }
        .leap-sc-tabs.vertical.style-2 .ui-tabs-nav .ui-tabs-anchor {
            border-bottom-color: <?php echo $smart_skin_backgrounds[ 'b1' ]; ?>;
        }
        .header.header7 .contact-info , .header.header7 .contact-info span, .header.header7 .contact-info a,
        .header.header8 .contact-info , .header.header8 .contact-info span, .header.header8 .contact-info a,
        .header.header9 .contact-info , .header.header9 .contact-info span, .header.header9 .contact-info a,
        .header.header7 p.social-networks a, .header.header8 p.social-networks a, .header.header9 p.social-networks a
        {
            color: <?php echo $smart_skin_backgrounds[ 'b3' ]; ?>;
        }
        input[type="text"], input[type="text"]:focus, .form-control, .form-control:focus, textarea, 
        textarea:focus, input[type="password"], input[type="password"]:focus, input[type="email"], 
        input[type="date"], input[type="number"], input[type="email"]:focus, input[type="tel"], 
        input[type="tel"]:focus, input[type="date"]:focus, input[type="number"]:focus, 
        .select2-container .select2-choice, select, #lang_sel a.lang_sel_sel, #lang_sel a.lang_sel_sel:hover,
        #lang_sel a.lang_sel_sel:focus, #lang_sel ul ul a, #lang_sel ul ul a:hover, #lang_sel ul ul a:focus, 
        #bbpress-forums #bbp-your-profile fieldset input, #bbpress-forums #bbp-your-profile fieldset textarea {
            background-color: <?php echo leap_color_brightness( $smart_skin_backgrounds[ 'b3' ], 0.8, $theme_skin ); ?>;
        }
        .leap-sc-tabs.horizontal.style-2 .ui-tabs-nav .ui-tabs-anchor {
            border-top-color: <?php echo $smart_skin_backgrounds[ 'b3' ]; ?>;
            border-bottom-color: <?php echo $smart_skin_backgrounds[ 'b3' ]; ?>;
            border-left-color: <?php echo $smart_skin_backgrounds[ 'b3' ]; ?>;
        }
        .rtl .leap-sc-tabs.horizontal.style-2 .ui-tabs-nav .ui-tabs-anchor {
            border-right-color: <?php echo $smart_skin_backgrounds[ 'b3' ]; ?>;
        }
        .blog-large-modern .entry-content, .archive-large-modern .entry-content {
            background-color: <?php echo leap_color_brightness( $smart_skin_backgrounds[ 'b3' ], 0.9, $theme_skin ); ?>;
        }        
        .dark-skin .btn-leap, .dark-skin a.btn-leap, .dark-skin .btn-leap:hover, .dark-skin a.btn-leap:hover, .dark-skin .btn-leap:focus, 
        .dark-skin a.btn-leap:focus, .dark-skin .btn-leap:active, .dark-skin .btn-leap:active:focus, .dark-skin input[type="submit"], 
        .dark-skin input[type="reset"], .dark-skin input[type="button"], .dark-skin input[type="submit"]:hover, 
        .dark-skin input[type="reset"]:hover, .dark-skin input[type="button"]:hover, .dark-skin input[type="submit"]:focus, 
        .dark-skin input[type="reset"]:focus, .dark-skin input[type="button"]:focus, .dark-skin .btn-default.btn-leap:active:hover, 
        .dark-skin .btn-default.btn-leap:active, .dark-skin .pp_details {
            color: <?php echo $smart_skin_backgrounds[ 'b3' ]; ?>;
        }
        .rtl .leap-sc-tabs.horizontal.style-2 .ui-tabs-nav .ui-state-active .ui-tabs-anchor {
            border-right-color: <?php echo $smart_skin_backgrounds[ 'b1' ]; ?>;
        }
        #footer-sidebar a, #footer-sidebar .widget-title, #footer-sidebar .widget a, #footer-sidebar h1, #footer-sidebar h2, 
        #footer-sidebar h3, #footer-sidebar h4, #footer-sidebar h5, #footer-sidebar h6, .header .contact-info, 
        .header .contact-info span, .header .contact-info a, #leap-footer a, #leap-footer .widget a, .header p.social-networks a,
        .top-menu li a {
            color: <?php echo $smart_skin_footer[ 'ft' ]; ?>;
        } 
        #footer-sidebar , #footer-sidebar caption, #footer-sidebar select, #footer-sidebar textarea, 
        #footer-sidebar .form-control, #footer-sidebar .footer-block p, #leap-footer .footer-block p, ul#footer-menu li:before {
            color: <?php echo leap_hex2rgba( $smart_skin_footer[ 'ft' ], '0.7', true ) ?>;
        }
        #footer-sidebar .form-control::-moz-placeholder {
            color: <?php echo leap_hex2rgba( $smart_skin_footer[ 'ft' ], '0.7', true ) ?>;
        }
        #footer-sidebar .form-control:-ms-input-placeholder {
            color: <?php echo leap_hex2rgba( $smart_skin_footer[ 'ft' ], '0.7', true ) ?>;
        }
        #footer-sidebar .form-control::-webkit-input-placeholder {
            color: <?php echo leap_hex2rgba( $smart_skin_footer[ 'ft' ], '0.7', true ) ?>;
        }	
        #footer-sidebar small.small, #footer-sidebar .widget span.date, #footer-sidebar .widget_recent_entries ul li span.post-date, 
        #footer-sidebar .widget .rss-date, #footer-sidebar small a , #footer-sidebar .wp-caption, #footer-sidebar .wp-caption a, 
        #footer-sidebar .widget_display_replies li div, #footer-sidebar .widget_display_topics li div {
            color: <?php echo leap_hex2rgba( $smart_skin_footer[ 'ft' ], '0.5', true ) ?>;
        }
        .top-menu ul li, .top-menu ul li:hover, .top-menu ul li.sfHover {
            border-bottom-color: <?php echo $smart_skin_footer[ 'ft' ]; ?>;
        }
        #footer-sidebar input[type="text"], #footer-sidebar input[type="text"]:focus, 
        #footer-sidebar .form-control, #footer-sidebar .form-control:focus, #footer-sidebar textarea, 
        #footer-sidebar textarea:focus, #footer-sidebar input[type="password"], #footer-sidebar input[type="password"]:focus, 
        #footer-sidebar #calendar_wrap , #footer-sidebar #wp-calendar tr, 
        #footer-sidebar .post_tags .label , #footer-sidebar .leap-widget-style5 .widget-content, 
        #footer-sidebar .leap-widget-style8 .widget, #footer-sidebar img.avatar, 
        #footer-sidebar .avatar > img , #footer-sidebar .woocommerce.widget_product_categories ul li, 
        #footer-sidebar .woocommerce .widget_layered_nav ul li, 
        #footer-sidebar .woocommerce .widget_layered_nav ul li, 
        #footer-sidebar .woocommerce-page .widget_layered_nav ul li,
        #footer-sidebar .woocommerce-page .widget_layered_nav ul li , 
        #footer-sidebar .woocommerce ul.cart_list li img, 
        #footer-sidebar .woocommerce ul.product_list_widget li img, 
        #footer-sidebar .woocommerce-page ul.cart_list li img, 
        #footer-sidebar .woocommerce-page ul.product_list_widget li img, #footer-sidebar .wdg-post img, 
        #footer-sidebar input[type="email"], #footer-sidebar input[type="date"], 
        #footer-sidebar input[type="number"], #footer-sidebar input[type="email"]:focus, 
        #footer-sidebar input[type="date"]:focus, #footer-sidebar input[type="number"]:focus, 
        #footer-sidebar #lang_sel a.lang_sel_sel, #footer-sidebar #lang_sel a.lang_sel_sel:hover, 
        #footer-sidebar #lang_sel a.lang_sel_sel:focus, #footer-sidebar #lang_sel ul ul a, 
        #footer-sidebar #lang_sel ul ul a:hover, #footer-sidebar #lang_sel ul ul a:focus, 
        #footer-sidebar #lang_sel ul ul, .woocommerce-MyAccount-content {
            border-color: <?php echo leap_color_brightness( $smart_skin_footer[ 'fb' ], 0.9, 'light' ); ?>;
        }
        #footer-sidebar .woocommerce ul.product_list_widget li, #footer-sidebar .widget_archive ul li, 
        #footer-sidebar .widget_categories ul li, #footer-sidebar .widget_nav_menu ul li, #footer-sidebar .widget_meta ul li , 
        #footer-sidebar .widget_pages ul li, #footer-sidebar .widget_recent_comments ul li, #footer-sidebar .widget_recent_entries ul li, 
        #footer-sidebar .widget_rss ul li , #footer-sidebar .widget.comments-avatar ul li, #footer-sidebar div.category-posts ul li, 
        #footer-sidebar .widget_author_posts ul li, #footer-sidebar .widget.posts-list ul li, #footer-sidebar div.widget.category-posts ul li ,#footer-sidebar .widget.leap-tabs .ui-tabs-panel li, #footer-sidebar .widget.tweets ul li, 
        #footer-sidebar .leap-widget-style4 .widget-head, #footer-sidebar .leap-widget-style9 .widget-head, 
        #footer-sidebar ol.commentlist li, .woocommerce-MyAccount-navigation li  {  
            border-bottom-color: <?php echo leap_color_brightness( $smart_skin_footer[ 'fb' ], 0.9, 'light' ); ?>;
        }
        #footer-sidebar .separator-widget, #footer-sidebar ol.commentlist ul.children li {
            border-top-color: <?php echo leap_color_brightness( $smart_skin_footer[ 'fb' ], 0.9, 'light' ); ?>;
        }
        #footer-sidebar .widget_calendar a, #footer-sidebar .wdg-counter li a i, #footer-sidebar .leap-widget-style7 .widget, 
        #footer-sidebar .leap-widget-style8 .widget, #footer-sidebar .leap-widget-style10 .widget {
            background-color: <?php echo leap_color_brightness( $smart_skin_footer[ 'fb' ], 0.9, 'dark' ); ?>;
        }
        .header1 .topbar-block, .header4 .topbar-block, .header5 .topbar-block, .header6 .topbar-block, #leap-footer, 
        .top-menu.sf-menu ul li, .top-menu.sf-menu ul li:hover, .top-menu.sf-menu ul li.sfHover,
        .top-menu ul {
            background-color: <?php echo $smart_skin_footer[ 'fb' ]; ?>;
        }
        a.scrollup {
            background-color: <?php echo leap_color_brightness( $smart_skin_footer[ 'fb' ], 0.8, 'light' ); ?>;
        }
        #footer-sidebar input[type="text"], #footer-sidebar input[type="text"]:focus, 
        #footer-sidebar .form-control, #footer-sidebar .form-control:focus, #footer-sidebar textarea, 
        #footer-sidebar textarea:focus, #footer-sidebar input[type="password"], 
        #footer-sidebar input[type="password"]:focus, #footer-sidebar input[type="email"], 
        #footer-sidebar input[type="date"], #footer-sidebar input[type="number"], 
        #footer-sidebar input[type="email"]:focus, #footer-sidebar input[type="date"]:focus, 
        #footer-sidebar input[type="number"]:focus, #footer-sidebar #lang_sel a.lang_sel_sel, 
        #footer-sidebar #lang_sel a.lang_sel_sel:hover, #footer-sidebar #lang_sel a.lang_sel_sel:focus, 
        #footer-sidebar #lang_sel ul ul a, #footer-sidebar #lang_sel ul ul a:hover, 
        #footer-sidebar #lang_sel ul ul a:focus  {
            background-color: rgba(0, 0, 0, 0.1);
        }	
        #footer-sidebar .btn-leap, #footer-sidebar a.btn-leap, #footer-sidebar .widget a.btn-leap, #footer-sidebar .btn-leap:hover, 
        #footer-sidebar .btn-leap:focus, #footer-sidebar .btn-leap:active, #footer-sidebar .btn-leap.active, 
        #footer-sidebar .btn-leap.disabled, #footer-sidebar .btn-leap[disabled], #footer-sidebar a.btn-leap:hover, 
        #footer-sidebar a.btn-leap:focus, #footer-sidebar a.btn-leap:active, #footer-sidebar a.btn-leap.active, 
        #footer-sidebar a.btn-leap.disabled, #footer-sidebar a.btn-leap[disabled], #footer-sidebar .widget a.btn-leap.disabled, 
        #footer-sidebar .widget a.btn-leap[disabled] , #footer-sidebar input[type="submit"], #footer-sidebar input[type="reset"], 
        #footer-sidebar input[type="button"], #footer-sidebar input[type="submit"]:hover, #footer-sidebar input[type="reset"]:hover, 
        #footer-sidebar input[type="button"]:hover, #footer-sidebar input[type="submit"]:focus, 
        #footer-sidebar input[type="reset"]:focus, #footer-sidebar input[type="button"]:focus {
            background-color: rgba(0, 0, 0, 0.1);
            border-color: <?php echo leap_color_brightness( $smart_skin_footer[ 'fb' ], 0.8, 'dark' ); ?>;
        }	
        #footer-sidebar .btn-leap:hover, #footer-sidebar .btn-leap:focus, #footer-sidebar .widget a.btn-leap:hover, 
        #footer-sidebar .widget a.btn-leap:focus, #footer-sidebar .widget a.btn-leap:active, 
        #footer-sidebar .widget a.btn-leap.active , #footer-sidebar input[type="submit"]:hover, 
        #footer-sidebar input[type="reset"]:hover, #footer-sidebar input[type="button"]:hover, 
        #footer-sidebar input[type="submit"]:focus, #footer-sidebar input[type="reset"]:focus, 
        #footer-sidebar input[type="button"]:focus{
            background-color: rgba(0, 0, 0, 0.2);
        }	
        /************* copyright *****************/
        #leap-footer div.footer-block {
            border-color: <?php echo leap_color_brightness( $smart_skin_footer[ 'fb' ], 0.9, 'light' ); ?>;
            background-color: <?php echo leap_color_brightness( $smart_skin_footer[ 'fb' ], 0.9, 'dark' ); ?>;
        }

        /**************** header options ***********/
        
        <?php
        $vh_width = ot_get_option( 'vh_width', array( '250', 'px' ) );
        $vh_width_unit      = (!empty( $vh_width[ 1 ] )) ? $vh_width[ 1 ] : 'px';
        ?>
        
        .header-vh.header10, .header-vh.header11, .header-vh #main-menu .menu-item-cart > ul {
            width: <?php echo $vh_width[ 0 ] . $vh_width_unit; ?>;
        }      
        .header-vh.header12.side-header, .header-vh.header13.side-header,
        .header12 .header-content, .header13 .header-content{
            width: <?php echo $vh_width[ 0 ] . $vh_width_unit; ?>;
        }  
        .header10-layout  {
            padding-left: <?php echo $vh_width[ 0 ] . $vh_width_unit; ?>;
        }
        .header11-layout  {
            padding-right: <?php echo $vh_width[ 0 ] . $vh_width_unit; ?>;
        }
        .header11-layout a.scrollup {
            margin-right: <?php echo $vh_width[ 0 ] . $vh_width_unit; ?>;
        }
        <?php if ( ot_get_option( 'vh_shadow' ) == 'off' ) : ?>
            .header-vh .header-vh-wrapper {
                box-shadow: none;
            }
        <?php endif; ?>
        <?php
        $vh_border     = ot_get_option( 'vh_border', array() );
        $vh_border_unit = (!empty( $vh_border[ 'unit' ] )) ? $vh_border[ 'unit' ] : 'px';
        ?>
        .header10, .header11 , .header12 .header-vh-wrapper , .header13 .header-vh-wrapper {
            <?php if ( isset( $vh_border[ 'width' ] ) && strlen( $vh_border[ 'width' ] ) > 0 ) { ?>
                border-width: <?php echo $vh_border[ 'width' ] . $vh_border_unit; ?>;
            <?php } ?>
            <?php if ( !empty( $vh_border[ 'style' ] ) ) { ?>
                border-style: <?php echo $vh_border[ 'style' ]; ?>;
            <?php } ?>
            <?php if ( !empty( $vh_border[ 'color' ] ) ) { ?>
                border-color: <?php echo $vh_border[ 'color' ]; ?>;
            <?php } ?>
        }   
        <?php $vh_icon_colors = ot_get_option( 'vh_icon_colors', array() ); ?>
        .header #nav-icon span, .header17 .logo a:after {
            <?php if ( !empty( $vh_icon_colors[ 'icon' ] ) ) { ?>
                background-color: <?php echo $vh_icon_colors[ 'icon' ]; ?>;
            <?php } ?>
        }
        header #nav-icon.icon-close span, .header #nav-icon.active span {
            <?php if ( !empty( $vh_icon_colors[ 'icon-hover' ] ) ) { ?>
                background-color: <?php echo esc_attr($vh_icon_colors[ 'icon-hover' ]); ?>;
            <?php } ?>
        }
        #nav-icon  {
            <?php if ( !empty( $vh_icon_colors[ 'bg' ] ) ) { ?>
                background-color: <?php echo esc_attr($vh_icon_colors[ 'bg' ]); ?>;
            <?php } ?>
        } 
        .menu-icon , .header14 .menu-icon{
            <?php if ( !empty( $vh_icon_colors[ 'bg' ] ) ) { ?>
                background-color: <?php echo $vh_icon_colors[ 'bg' ]; ?>;
            <?php } ?>
        }     
        
        .header14 .menu-icon, .admin-bar .header14 .menu-icon {
            <?php
            $icon_spacing           = ot_get_option( 'icon_spacing', array() );
            $icon_spacing_unit      = (!empty( $icon_spacing[ 'unit' ] )) ? $icon_spacing[ 'unit' ] : 'px';
            ?>
            <?php if ( isset( $icon_spacing[ 'top' ] ) && strlen( $icon_spacing[ 'top' ] ) > 0 ) { ?>
                top: <?php echo $icon_spacing[ 'top' ] . $icon_spacing_unit; ?>;
            <?php } ?>
            <?php if ( isset( $icon_spacing[ 'right' ] ) && strlen( $icon_spacing[ 'right' ] ) > 0 ) { ?>
                right: <?php echo $icon_spacing[ 'right' ] . $icon_spacing_unit; ?>;
            <?php } ?>
            <?php if ( isset( $icon_spacing[ 'bottom' ] ) && strlen( $icon_spacing[ 'bottom' ] ) > 0 ) { ?>
                bottom: <?php echo $icon_spacing[ 'bottom' ] . $icon_spacing_unit; ?>;
            <?php } ?>
            <?php if ( isset( $icon_spacing[ 'left' ] ) && strlen( $icon_spacing[ 'left' ] ) > 0 ) { ?>
                left: <?php echo $icon_spacing[ 'left' ] . $icon_spacing_unit; ?>;
            <?php } ?>
        }
        .header15 .icon-header, .header17 .icon-header, .header16 {
            <?php
            $header_spacing           = ot_get_option( 'header_spacing', array() );
            $header_spacing_unit      = (!empty( $header_spacing[ 'unit' ] )) ? $header_spacing[ 'unit' ] : 'px';
            ?>
            <?php if ( isset( $header_spacing[ 'top' ] ) && strlen( $header_spacing[ 'top' ] ) > 0 ) { ?>
                padding-top: <?php echo $header_spacing[ 'top' ] . $header_spacing_unit; ?>;
            <?php } ?>
            <?php if ( isset( $header_spacing[ 'right' ] ) && strlen( $header_spacing[ 'right' ] ) > 0 ) { ?>
                padding-right: <?php echo $header_spacing[ 'right' ] . $header_spacing_unit; ?>;
            <?php } ?>
            <?php if ( isset( $header_spacing[ 'bottom' ] ) && strlen( $header_spacing[ 'bottom' ] ) > 0 ) { ?>
                padding-bottom: <?php echo $header_spacing[ 'bottom' ] . $header_spacing_unit; ?>;
            <?php } ?>
            <?php if ( isset( $header_spacing[ 'left' ] ) && strlen( $header_spacing[ 'left' ] ) > 0 ) { ?>
                padding-left: <?php echo $header_spacing[ 'left' ] . $header_spacing_unit; ?>;
            <?php } ?>
        }

        
        
        #leap-header.header15 .fixed-header p.social-networks a, #leap-header.header17 .fixed-header p.social-networks a,
        #leap-header.header17 .fixed-header .contact-info, #leap-header.header17 .fixed-header .contact-info span {
            <?php
            $sticky_text_color = ot_get_option( 'sticky_text_color' );
            if ( $sticky_text_color ) :
                ?>
                color: <?php echo $sticky_text_color; ?>;
            <?php endif; ?>
        }	
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        .framed #leap-wrapper {
            <?php
            $framed_size           = ot_get_option( 'framed_size', array() );
            $framed_size_unit      = (!empty( $framed_size[ 'unit' ] )) ? $framed_size[ 'unit' ] : 'px';
            ?>
            <?php if ( isset( $framed_size[ 'top' ] ) && strlen( $framed_size[ 'top' ] ) > 0 ) { ?>
                border-top-width: <?php echo $framed_size[ 'top' ] . $framed_size_unit; ?>;
            <?php } ?>
            <?php if ( isset( $framed_size[ 'right' ] ) && strlen( $framed_size[ 'right' ] ) > 0 ) { ?>
                border-right-width: <?php echo $framed_size[ 'right' ] . $framed_size_unit; ?>;
            <?php } ?>
            <?php if ( isset( $framed_size[ 'bottom' ] ) && strlen( $framed_size[ 'bottom' ] ) > 0 ) { ?>
                border-bottom-width: <?php echo $framed_size[ 'bottom' ] . $framed_size_unit; ?>;
            <?php } ?>
            <?php if ( isset( $framed_size[ 'left' ] ) && strlen( $framed_size[ 'left' ] ) > 0 ) { ?>
                border-left-width: <?php echo $framed_size[ 'left' ] . $framed_size_unit; ?>;
            <?php } ?>
        }
        <?php $frame_color = ot_get_option( 'frame_color', array() ); ?>
        .framed #leap-wrapper {
            <?php if ( !empty( $frame_color ) ) { ?>
                border-color: <?php echo $frame_color; ?>;
            <?php } ?>
        }
        
        
        
        
        #nav-icon.icon-close, #nav-icon.active {
            <?php if ( !empty( $vh_icon_colors[ 'bg-hover' ] ) ) { ?>
                background-color: <?php echo esc_attr($vh_icon_colors[ 'bg-hover' ]); ?>;
            <?php } ?>
        } 

        
        <?php $links_color = ot_get_option( 'links_color', array() ); ?>
        a, .sc-rposts .post-title a, .sc-rposts .post-comment a, .list_carousel .cfs-nav span:before, .widget a, 
        ol.commentlist div.comment-author a, .pagination ul > .active > a, .pagination ul > .active > span, .post-navigation div span, 
        .post-navigation div a, #tag-cloud a, .shipping_calculator h2 a, .woocommerce-info a, .myaccount_user a, 
        .woocommerce-tabs ul.tabs li.active a, .yith-woocompare-widget a.clear-all:after, .yith-woocompare-widget a.clear-all:before, 
        .woocommerce-tabs ul.tabs li a {
            <?php if ( !empty( $links_color[ 'link' ] ) ) { ?>
                color: <?php echo $links_color[ 'link' ]; ?>;
            <?php } ?>
        }
        a:hover, a:focus, a:active, .entry-meta a:hover, .entry-meta a:active, .entry-meta a:focus, .entry-meta a:hover span, 
        .sc-rposts .post-title a:hover, .sc-rposts .post-title a:active, .sc-rposts .post-title a:focus, .sc-rposts .post-comment a:hover,  
        .list_carousel .cfs-nav span:hover:before, .widget a:hover, .widget a:focus, 
        .widget a:active, ol.commentlist div.comment-author a:hover, ol.commentlist div.comment-author a:active, 
        ol.commentlist div.comment-author a:focus, .pagination ul > .active > a:hover, .pagination ul > .active > span:hover, 
        ul.portfolio-tabs li a:hover, ul.portfolio-tabs li.active a:hover, .post-navigation div:hover span, 
        .post-navigation div:hover a, #tag-cloud a:hover, .tags a:hover, .shipping_calculator h2 a:hover, 
        .woocommerce-info a:hover, .myaccount_user a:hover, .woocommerce-tabs ul.tabs li.active a:hover, 
        .yith-woocompare-widget a.clear-all:hover:after, .yith-woocompare-widget a.clear-all:hover:before , 
        .woocommerce-tabs ul.tabs li a:hover, .woocommerce-MyAccount-navigation li.is-active a {
            <?php if ( !empty( $links_color[ 'hover' ] ) ) { ?>
                color: <?php echo $links_color[ 'hover' ]; ?>;
            <?php } ?>
        }

        /*****************styling ******************/
        /******* Custom Background *******/
        <?php
        $retina_2x = '';
        if ( isset( $_COOKIE[ "isRetina" ] ) && ($_COOKIE[ "isRetina" ] == 'true') ) {
            $retina_2x = '@2x';
        }

        if ( ot_get_option( 'layout', 'wide' ) == 'boxed' ) {

            $choose_pattern = ot_get_option( 'choose_pattern_outer', 'pattern1' );
            if ( (ot_get_option( 'background_type_outer', 'pattern' ) == 'pattern') && $choose_pattern ) {
                ?>
                body {
                    <?php /* ?>
                      background-image: url("<?php echo get_template_directory_uri() . '/functions/images/pattern/' . $choose_pattern . $retina_2x . '.png' ?>");
                      <?php */ ?>
                    background-image: url("<?php echo get_template_directory_uri() . '/functions/images/pattern/' . $choose_pattern . '.png' ?>");
                    background-position: top left;
                    background-repeat: repeat;
                }
            <?php } ?>
            <?php if ( ot_get_option( 'background_type_outer', 'pattern' ) == 'custom_background' ) { ?>
                body {
                    <?php echo leap_get_background_value( 'custom_background_outer' ); ?>
                }
                <?php
                if ( isset( $_COOKIE[ "isRetina" ] ) && ($_COOKIE[ "isRetina" ] == 'true') ) {
                    $custom_retina_background           = ot_get_option( 'custom_retina_background_outer', '' );
                    $retina_background_dimensions_outer = ot_get_option( 'retina_background_dimensions_outer', array() );
                    $retina_background_width            = (!empty( $retina_background_dimensions_outer[ 'width' ] )) ? $retina_background_dimensions_outer[ 'width' ] . 'px' : '';
                    $retina_background_height           = (!empty( $retina_background_dimensions_outer[ 'height' ] )) ? $retina_background_dimensions_outer[ 'height' ] . 'px' : '';

                    if ( !empty( $custom_retina_background ) && !empty( $retina_background_width ) && !empty( $retina_background_height ) ) {
                        ?>
                        body {
                            background-image: url("<?php echo esc_url( $custom_retina_background ); ?>");
                            background-size: <?php echo $retina_background_width; ?> <?php echo $retina_background_height; ?>;
                        }
                        <?php
                    }
                }
            }
        } // end if(ot_get_option('layout', 'wide') == 'boxed' )
        ?>

        #leap-wrapper {
            <?php echo leap_get_background_value( 'background_inner' ); ?>
        }

        <?php
        $choose_pattern        = ot_get_option( 'choose_pattern_outer', 'pattern1' );
        ?>

        /********************* overlay ***************************/
        <?php $overlay_color_options = ot_get_option( 'image_overlay_color_options', array() ); ?>
        .leap-overlay .item-img-color {
            <?php if ( !empty( $overlay_color_options[ 'main-color' ] ) ) { ?>
                background-color: <?php echo $overlay_color_options[ 'main-color' ]; ?>;
            <?php } ?>
            <?php
            $overlay_opacity = intval( ot_get_option( 'overlay_opacity', '' ) );
            if ( !empty( $overlay_opacity ) ) {
                ?>
                opacity: <?php echo $overlay_opacity; ?>;
            <?php } ?>
        }
        .item-img .item-overlay .item-title a, .item-overlay .item-category, .item-overlay .item-category a, .item-overlay .item-category a:hover, .item-overlay .item-category a:focus, .item-overlay .item-category a:active {
            <?php if ( !empty( $overlay_color_options[ 'text-color' ] ) ) { ?>
                color: <?php echo $overlay_color_options[ 'text-color' ]; ?>;
            <?php } ?>
        }
        .item-overlay .item-links a:before {
            <?php if ( !empty( $overlay_color_options[ 'icon-color' ] ) ) { ?>
                color: <?php echo $overlay_color_options[ 'icon-color' ]; ?>;
            <?php } ?>
        }
        .item-overlay .item-links a:hover:before {
            <?php if ( !empty( $overlay_color_options[ 'icon-hover-color' ] ) ) { ?>
                color: <?php echo $overlay_color_options[ 'icon-hover-color' ]; ?>;
            <?php } ?>
        }
        .item-overlay .item-links a {
            <?php if ( !empty( $overlay_color_options[ 'icon-bg-color' ] ) ) { ?>
                background-color: <?php echo $overlay_color_options[ 'icon-bg-color' ]; ?>;
            <?php } ?>
        }

        div.title h1:after, div.title h2:after, div.title h3:after, div.title h4:after, 
        div.title h5:after, div.title h6:after, div.title.title-strip.title-center h1:before, 
        div.title.title-strip.title-center h2:before, div.title.title-strip.title-center h3:before, 
        div.title.title-strip.title-center h4:before, div.title.title-strip.title-center h5:before, 
        div.title.title-strip.title-center h6:before, div.title.title-strip.title-center h1:after, 
        div.title.title-strip.title-center h2:after, div.title.title-strip.title-center h3:after, 
        div.title.title-strip.title-center h4:after, div.title.title-strip.title-center h5:after, 
        div.title.title-strip.title-center h6:after, div.title.title-strip h1:after, div.title.title-strip h2:after, 
        div.title.title-strip h3:after, div.title.title-strip h4:after, div.title.title-strip h5:after, 
        div.title.title-strip h6:after {
            <?php
            $titles_strip_image = ot_get_option( 'titles_strip_image' );
            if ( !empty( $titles_strip_image ) ) {
                ?>
                background: url("<?php echo $titles_strip_image; ?>") repeat-x scroll left 50% / 5px 5px rgba(0, 0, 0, 0);
            <?php } ?>
        }

        /******** header *********/

        <?php $top_header_border_color = ot_get_option( 'top_header_border_color' ); ?>
        .header .topbar-block, .header2 .topbar-block, .header7 .topbar-block, .header8 .topbar-block, .header9 .topbar-block, 
        .header4 .topbar-block, .header5 .topbar-block, .header6 .topbar-block {
            <?php echo leap_get_background_value( 'top_header_bg' ); ?> 
            <?php if ( !empty( $top_header_border_color ) ) { ?>
                border-color: <?php echo $top_header_border_color; ?>;
            <?php } ?>
        }
        .header2 {
            <?php if ( !empty( $top_header_border_color ) ) { ?>
                border-color: <?php echo $top_header_border_color; ?>;
            <?php } ?>
        }
        #leap-header p.social-networks a {
            <?php
            $top_social_icons_colors = ot_get_option( 'top_social_icons_colors', array() );
            if ( !empty( $top_social_icons_colors[ 'icon' ] ) ) :
                ?>
                color: <?php echo $top_social_icons_colors[ 'icon' ]; ?>;
            <?php endif; ?>
        }
        #leap-header.header p.social-networks a:hover i, #leap-header.header p.social-networks a:focus i {
            <?php
            if ( !empty( $top_social_icons_colors[ 'icon-hover' ] ) ) :
                ?>
                color: <?php echo $top_social_icons_colors[ 'icon-hover' ]; ?>;
            <?php endif; ?>
        }
        .header1 .navbar-inner, .header2 .navbar-inner, .header3 .navbar-inner, .header4 .logo-block, 
        .header5 .logo-block, .header6 .logo-block, .header7, .header8, .header9, 
        .header10 , .header11 , 
        .header12 .header-vh-wrapper, .header13 .header-vh-wrapper , .header15 .icon-header {
            <?php echo leap_get_background_value( 'header_bg' ); ?>
        }
        .header .navbar-inner.navbar-fixed-top.fixed-header, .header15 .fixed-header .icon-header {
            <?php echo leap_get_background_value( 'sticky_header_bg' ); ?>
        }
        <?php if ( ot_get_option( 'sticky_header_shadow' ) == 'off' ) : ?>
            .navbar-fixed-top.fixed-header {
                box-shadow: none;
            }
        <?php endif; ?>
        .navbar-fixed-top.fixed-header {
            <?php
            $sticky_header_border_bottom_color = ot_get_option( 'sticky_header_border_bottom_color' );
            if ( $sticky_header_border_bottom_color ) :
                ?>
                border-bottom: 1px solid <?php echo $sticky_header_border_bottom_color; ?>;
            <?php endif; ?>
        }
        .header4 .navbar-inner, .header5 .navbar-inner, .header6 .navbar-inner, 
        .header14 .header-vh-wrapper .header-content, .header15 #main-menu-container {
            <?php echo leap_get_background_value( 'main_menu_bg' ); ?>
        }
        .wide .header8 .mainmenu-logo-container , .boxed .header8 .mainmenu-logo-container .nav-container,
        .header8 .mainmenu-logo-container.boxed-header .mainmenu-logo, .wide .header9 .mainmenu-logo-container , 
        .boxed .header9 .mainmenu-logo-container .nav-container, .header9 .mainmenu-logo-container.boxed-header .mainmenu-logo  {
            <?php echo leap_get_background_value( 'main_menu_boxed_bg' ); ?>
        }

        <?php
        $main_menu_logo_spacing      = ot_get_option( 'main_menu_logo_spacing', array() );
        $main_menu_logo_spacing_unit = (!empty( $main_menu_logo_spacing[ 'unit' ] )) ? $main_menu_logo_spacing[ 'unit' ] : 'px';
        ?>
        .header7 .nav-container .transparent-header, .header8 .navbar-inner, .header9 .navbar-inner {
            <?php if ( isset( $main_menu_logo_spacing[ 'top' ] ) && strlen( $main_menu_logo_spacing[ 'top' ] ) > 0 ) { ?>
                padding-top: <?php echo $main_menu_logo_spacing[ 'top' ] . $main_menu_logo_spacing_unit; ?>;
            <?php } ?>
            <?php if ( isset( $main_menu_logo_spacing[ 'bottom' ] ) && strlen( $main_menu_logo_spacing[ 'bottom' ] ) > 0 ) { ?>
                padding-bottom: <?php echo $main_menu_logo_spacing[ 'bottom' ] . $main_menu_logo_spacing_unit; ?>;
            <?php } ?>
        }
        .header .main-menu > li > a, .header a#searchbutton, .header15 .main-menu > li, .header15 .main-menu > li.sfHove {
            <?php echo leap_get_typography_value( 'main_menu_typography' ); ?>
        }
        .header12 .menu-icon, .header12 .menu-icon:focus,.header13 .menu-icon, .header13 .menu-icon:focus,
        .menu-icon .fa-close, .menu-icon:focus .fa-close, .menu-icon:hover .fa-close , 
        .menu-icon:focus:hover .fa-close {
            <?php
            $main_menu_typography = ot_get_option( 'main_menu_typography', array() );
            ?>
            <?php if ( !empty( $main_menu_typography[ 'font-color' ] ) ) { ?>
                color: <?php echo $main_menu_typography[ 'font-color' ]; ?>;
            <?php } ?>
        }
        .header .main-menu > li:before {
            <?php
            $main_menu_typography = ot_get_option( 'main_menu_typography', array() );
            ?>
            <?php if ( !empty( $main_menu_typography[ 'line-height' ] ) ) { ?>
                line-height: <?php echo $main_menu_typography[ 'line-height' ]; ?>;
            <?php } ?>
        }
        .header15 .top-header-content {
            <?php if ( !empty( $main_menu_typography[ 'line-height' ] ) ) { ?>
                height: <?php echo esc_attr($main_menu_typography[ 'line-height' ]); ?>;
            <?php } ?>
        }
        .main-menu > li a:hover span.menu-item-description, .main-menu > li a:active span.menu-item-description, 
        .main-menu > li a:focus span.menu-item-description, .main-menu > li:hover a span.menu-item-description, 
        .main-menu > li:active a span.menu-item-description, .main-menu > li:focus a span.menu-item-description, 
        .main-menu > li:visited a span.menu-item-description, .main-menu > li.current-menu-item a span.menu-item-description {
            <?php if ( !empty( $main_menu_typography[ 'font-color' ] ) ) { ?>
                color: <?php echo $main_menu_typography[ 'font-color' ]; ?>;
            <?php } ?>
        }

        <?php
        $main_menu_colors = ot_get_option( 'main_menu_colors', array() );
        ?>
        .main-menu > li > a:hover, .main-menu > li > a:focus, .main-menu > li > a:active, .main-menu > li.sfHover > a,
        .main-menu > li > a:hover span, .main-menu > li > a:focus span, .main-menu > li > a:active span,.main-menu > li.current-menu-item > a, 
        .main-menu > li.current-page-ancestor > a, 
        .main-menu > li.current-page-ancestor > a:hover,
        .main-menu > li.current-menu-ancestor > a, 
        .main-menu > li.current-menu-ancestor > a:hover, 
        .main-menu > li.current-menu-parent > a, 
        .main-menu > li.current-menu-parent > a:hover, 
        .main-menu > li.current_page_ancestor > a, 
        .main-menu > li.current_page_ancestor > a:hover,
        .header12 .menu-icon:hover, .header12 .menu-icon:focus:hover, .header13 .menu-icon:hover, .header13 .menu-icon:focus:hover,
        .header a#searchbutton:hover, .header a#searchbutton:focus, .header a#searchbutton:active {
            <?php if ( !empty( $main_menu_colors[ 'text-hover' ] ) ) { ?>
                color: <?php echo $main_menu_colors[ 'text-hover' ]; ?>;
            <?php } ?>
        }
        .header-vh .sf-menu > li:hover, .header-vh .sf-menu > li:focus, .header-vh .sf-menu > li:active {
            <?php if ( !empty( $main_menu_colors[ 'text-hover' ] ) ) { ?>
                border-color: <?php echo $main_menu_colors[ 'text-hover' ]; ?>;
            <?php } ?>
        }
        .main-menu > li:hover, .main-menu > li:active, .main-menu > li:focus, .main-menu > li.sfHover, .main-menu > li > a:hover, 
        .main-menu > li.sfHover > a.sf-with-ul,
        .main-menu > ul > li > a:hover, .main-menu > ul > li > a:focus, .main-menu > ul > li > a:active {
            <?php if ( !empty( $main_menu_colors[ 'text-hover' ] ) ) { ?>
                border-color: <?php echo $main_menu_colors[ 'text-hover' ]; ?>;
            <?php } ?>
        }
        .header16 #v-menu li a:after {
            <?php if ( !empty( $main_menu_colors[ 'text-hover' ] ) ) { ?>
                background-color: <?php echo $main_menu_colors[ 'text-hover' ]; ?>;
            <?php } ?>
        }

        <?php
        $main_menu_sep = ot_get_option( 'main_menu_sep' );
        if ( $main_menu_sep == 'off' ) {
            ?>
            .main-menu > li:before {
                display:none ;
            }
            .header-vh .sf-menu > li {
                border-bottom-width: 0px;
            }
        <?php } else { ?>
            <?php if ( !empty( $main_menu_colors[ 'sep' ] ) ) { ?>
                .main-menu > li:before {
                    color: <?php echo $main_menu_colors[ 'sep' ] ?> ;
                }
                .header-vh .sf-menu > li {
                border-bottom-color: <?php echo $main_menu_colors[ 'sep' ] ?> ;
                }
            <?php } ?>
        <?php } ?>

        <?php $main_sub_colors = ot_get_option( 'main_sub_colors', array() ); ?>
        .main-menu ul li, .main-menu ul ul li, .main-menu ul li:hover, .main-menu ul li:focus, .main-menu ul li.sfHover, 
        .sf-menu .sf-mega, .sf-menu .sf-mega.menu-fullwidth .row , span.mega-section-head, span:hover.mega-section-head, .main-menu ul li.sfHover, 
        span.mega-section-head, span:hover.mega-section-head, .main-menu .menu-item-has-megamenu ul ul li, .searchform .navbar-search, 
        .slicknav_nav, .slicknav_nav li a:hover, .slicknav_nav li.slicknav_parent:hover a a, .slicknav_nav .slicknav_item a:hover a, 
        .slicknav_nav .slicknav_row:hover, .slicknav_nav .slicknav_open > .slicknav_row a, .slicknav_nav li.slicknav_open:hover > *, .slicknav_nav a {
            <?php if ( !empty( $main_sub_colors[ 'bg' ] ) ) { ?>
                background-color: <?php echo $main_sub_colors[ 'bg' ]; ?>;
            <?php } ?>
        }
        .searchform .navbar-search {
            <?php if ( !empty( $main_sub_colors[ 'bg' ] ) ) { ?>
                border-color: <?php echo $main_sub_colors[ 'bg' ]; ?>;
            <?php } ?>
        }
        .searchform .navbar-search:before {
            <?php if ( !empty( $main_sub_colors[ 'bg' ] ) ) { ?>
                border-bottom-color: <?php echo $main_sub_colors[ 'bg' ]; ?>;
            <?php } ?>
        }
        .main-menu ul li a, #main-menu .menu-item-cart ul.cart_list li, #main-menu .menu-item-cart ul.cart_list li:first-child, 
        #main-menu .menu-item-cart .widget_shopping_cart_content, #main-menu .widget_shopping_cart_content .buttons , .slicknav_nav li {
            <?php if ( !empty( $main_sub_colors[ 'divider' ] ) ) { ?>
                border-color: <?php echo $main_sub_colors[ 'divider' ]; ?>;
            <?php } ?>
        }

        .main-menu ul li > a:hover, .main-menu ul li a:active, .main-menu ul li a:focus, 
        .main-menu li ul a:hover span, .main-menu ul li a:active span, .main-menu ul li a:focus span, .main-menu ul li.sfHover > a,
        .main-menu li .mega-section-head a:hover, .main-menu li .mega-section-head a:hover span,
        .header ul.main-menu ul li.current-menu-item > a, .header ul.main-menu ul li.current-menu-item > a span, 
        .header ul.main-menu ul li.current-menu-item > a:hover, .header ul.main-menu ul li.current-page-ancestor > a, 
        .header ul.main-menu ul li.current-page-ancestor > a:hover, 
        .header ul.main-menu ul li.current-menu-ancestor > a,
        .slicknav_nav li:hover,
        .slicknav_nav li a:hover, .slicknav_nav li.slicknav_parent:hover > a, .slicknav_nav .slicknav_item a:hover a, .slicknav_nav .slicknav_row:hover, 
        .slicknav_nav .slicknav_open > .slicknav_row > a, .slicknav_nav li.slicknav_open:hover > *, .slicknav_nav li:hover {
            <?php if ( !empty( $main_sub_colors[ 'text-hover' ] ) ) { ?>
                border-color: <?php echo $main_sub_colors[ 'text-hover' ]; ?>;
                color: <?php echo $main_sub_colors[ 'text-hover' ] ?>;
            <?php } ?>
        }

        .main-menu ul li a, .main-menu ul li span, .main-menu ul li strong, .main-menu .mega-section-head a, 
        .main-menu .mega-section-head > span, .slicknav_nav a {
            <?php echo leap_get_typography_value( 'main_menu_sub_typography' ); ?>
        }

        .sf-menu .menu-item-no-megamenu ul, .sub-menu.submenu-languages {
            <?php
            $main_sub_width      = ot_get_option( 'main_sub_width', array( '0' => '', '1' => '' ) );
            $main_sub_width[ 0 ] = ( isset( $main_sub_width[ 0 ] ) && strlen( $main_sub_width[ 0 ] ) > 0 ) ? $main_sub_width[ 0 ] : '180';
            $main_sub_width[ 1 ] = ($main_sub_width[ 1 ]) ? $main_sub_width[ 1 ] : 'px';
            ?>
            width: <?php echo $main_sub_width[ 0 ] . $main_sub_width[ 1 ]; ?>;
        }
        #v-menu li a, #v-menu li span, #v-menu li strong {
            <?php echo leap_get_typography_value( 'vertical_menu_items_typography' ); ?>
        }
        #v-menu li:hover a, #v-menu li:focus a, #v-menu li:active a,
        #v-menu li:hover a span, #v-menu li:focus a span, #v-menu li:active a span {
            <?php
            $vertical_menu_items_hover_color = ot_get_option( 'vertical_menu_items_hover_color' );
            if ( $vertical_menu_items_hover_color ) :
                ?>
                color: <?php echo $vertical_menu_items_hover_color; ?>;
            <?php endif; ?>
        }
        .header16 #v-menu li a:after {
            <?php
            $vertical_menu_items_hover_color = ot_get_option( 'vertical_menu_items_hover_color' );
            if ( $vertical_menu_items_hover_color ) :
                ?>
                background-color: <?php echo $vertical_menu_items_hover_color; ?>;
            <?php endif; ?>
        }
        <?php if ( ot_get_option( 'slider__shadow' ) == 'off' ) : ?>
            .leap-slider:before, .leap-slider:after {
                background: none;
            }
        <?php endif; ?>
        .navbar-search input[type="text"].search-query {
            <?php
            $header_search_bg_color = ot_get_option( 'header_search_bg_color' );
            if ( $header_search_bg_color ) :
                ?>
                background-color: <?php echo $header_search_bg_color; ?>;
            <?php endif; ?>
        }	
        /****** page top/bottom padding ********/
        <?php
        $page_content_spacing      = (array) leap_general_post_option( 'page_content_spacing', 'leap_page_content_spacing', $page_id );
        $page_content_spacing_unit = (!empty( $page_content_spacing[ 'unit' ] )) ? $page_content_spacing[ 'unit' ] : 'px';
        ?>
        #content {
            <?php if ( isset( $page_content_spacing[ 'top' ] ) && strlen( $page_content_spacing[ 'top' ] ) > 0 ) { ?>
                padding-top: <?php echo $page_content_spacing[ 'top' ] . $page_content_spacing_unit; ?>;
            <?php } ?>
            <?php if ( isset( $page_content_spacing[ 'bottom' ] ) && strlen( $page_content_spacing[ 'bottom' ] ) > 0 ) { ?>
                padding-bottom: <?php echo $page_content_spacing[ 'bottom' ] . $page_content_spacing_unit; ?>;
            <?php } ?>

        }

        /****** page title ********/
        <?php if ( ot_get_option( 'page_title_bar_shadow', 'off' ) == 'off' ) : ?>
            #title:before, #title:after {
                background: none;
            }
        <?php endif; ?>
        div#title {
            <?php
            if ( leap_general_or_custom( 'page_title_bg', 'leap_page_title_bg', $page_id ) == 'custom' ) {
                echo leap_get_post_background_value( 'leap_page_title_bg', $page_id );
            } else {
                echo leap_get_background_value( 'page_title_bg' );
            }
            ?>
        }
        <?php if ( isset( $_COOKIE[ "isRetina" ] ) && ($_COOKIE[ "isRetina" ] == 'true') ) : ?>

            <?php
            $page_title_bg_retina            = ot_get_option( 'page_title_bg_retina', '' );
            $page_title_bg_retina_dimensions = (array) leap_general_post_option( 'page_title_bg_retina_dimensions', 'leap_page_title_bg_retina_dimensions', $page_id );
            if ( !empty( $page_title_bg_retina ) && isset( $page_title_bg_retina_dimensions[ 'width' ] ) && isset( $page_title_bg_retina_dimensions[ 'height' ] ) ) :
                ?>
                div#title {
                    background-image: url("<?php echo esc_url( $page_title_bg_retina ); ?>");
                    background-size: <?php echo $page_title_bg_retina_dimensions[ 'width' ]; ?>px <?php echo $page_title_bg_retina_dimensions[ 'height' ]; ?>px;
                }
            <?php endif; ?>
        <?php endif; ?>
        #title .row {
            <?php
            $title_spacing      = (array) leap_general_post_option( 'title_spacing', 'leap_title_spacing', $page_id );
            $title_spacing_unit = (!empty( $title_spacing[ 'unit' ] )) ? $title_spacing[ 'unit' ] : 'px';
            if ( isset( $title_spacing[ 'top' ] ) && strlen( $title_spacing[ 'top' ] ) > 0 ) {
                ?>
                margin-top: <?php echo $title_spacing[ 'top' ] . $title_spacing_unit; ?>;
            <?php } ?>
            <?php if ( isset( $title_spacing[ 'bottom' ] ) && strlen( $title_spacing[ 'bottom' ] ) > 0 ) { ?>
                margin-bottom: <?php echo $title_spacing[ 'bottom' ] . $title_spacing_unit ?>;
            <?php } ?>
        }

        #title h5.subtitle {
            <?php echo leap_get_typography_value( 'subtitle_typography' ); ?>
        }
        .pagetitle2 div.entry-title h1:after {
            background-color: <?php echo ot_get_option( 'title_separator_color', $primary_color ) ?>;
        }
        .pagetitle3 .entry-title {
            border-color: <?php echo ot_get_option( 'title_separator_color', $primary_color ) ?>;
        }

        /****** content *************/
        #main {
            <?php echo leap_get_background_value( 'content_bg' ); ?>
        }
        /********* divider ***********/
        /************* Social Sharing Box **********************/
        <?php $sharing_box_colors = ot_get_option( 'sharing_box_colors', array() ); ?>
        .leap-share-buttons, .archive-info .author-links, .hentry .leap-share-buttons {
            <?php if ( !empty( $sharing_box_colors[ 'bg' ] ) ) { ?>
                background-color: <?php echo $sharing_box_colors[ 'bg' ]; ?>;
            <?php } ?>
        }
        .leap-share-buttons i, .leap-share-buttons .pull-left, .archive-info .author-links i {
            <?php if ( !empty( $sharing_box_colors[ 'icon' ] ) ) { ?>
                color: <?php echo $sharing_box_colors[ 'icon' ]; ?>;
            <?php } ?>
        }
        .leap-share-buttons a:hover i {
            <?php if ( !empty( $sharing_box_colors[ 'icon-hover' ] ) ) { ?>
                color: <?php echo $sharing_box_colors[ 'icon-hover' ]; ?>;
            <?php } ?>
        }
        /******************* Sidebar ***************/
        #main-sidebar .main-sidebar-content {
            <?php echo leap_get_typography_value( 'main_sidebar_typography' ); ?>
            <?php echo leap_get_background_value( 'main_sidebar_bg' ); ?>
            <?php
            $main_sidebar_spacing      = ot_get_option( 'main_sidebar_spacing', array() );
            $main_sidebar_spacing_unit = (!empty( $main_sidebar_spacing[ 'unit' ] )) ? $main_sidebar_spacing[ 'unit' ] : 'px';
            ?>

            <?php if ( isset( $main_sidebar_spacing[ 'top' ] ) && strlen( $main_sidebar_spacing[ 'top' ] ) > 0 ) { ?>
                padding-top: <?php echo $main_sidebar_spacing[ 'top' ] . $main_sidebar_spacing_unit; ?>;
            <?php } ?>

            <?php if ( isset( $main_sidebar_spacing[ 'bottom' ] ) && strlen( $main_sidebar_spacing[ 'bottom' ] ) > 0 ) { ?>
                padding-bottom: <?php echo $main_sidebar_spacing[ 'bottom' ] . $main_sidebar_spacing_unit; ?>;
            <?php } ?>
        }

        #main-sidebar .widget-title {
            <?php echo leap_get_typography_value( 'main_sidebar_widgets_titles_typography' ); ?>
        }

        <?php $main_sidebar_colors = ot_get_option( 'main_sidebar_colors', array() ); ?>
        #main-sidebar .widget span.date, #main-sidebar .widget small.small, #main-sidebar .widget_recent_entries ul li span.post-date ,  
        #main-sidebar .widget small a, #main-sidebar .wp-caption , #main-sidebar .wp-caption a, 
        #main-sidebar .widget_display_topics li div, #main-sidebar .widget_display_replies li div {
            <?php if ( !empty( $main_sidebar_colors[ 'meta' ] ) ) { ?>
                color: <?php echo $main_sidebar_colors[ 'meta' ]; ?>;
            <?php } ?>
        }	
        #main-sidebar a {
            <?php if ( !empty( $main_sidebar_colors[ 'link' ] ) ) { ?>
                color: <?php echo $main_sidebar_colors[ 'link' ]; ?>;
            <?php } ?>
        }
        #main-sidebar a:hover {
            <?php if ( !empty( $main_sidebar_colors[ 'link-hover' ] ) ) { ?>
                color: <?php echo $main_sidebar_colors[ 'link-hover' ]; ?>;
            <?php } ?>
        }
        .sidebar .widget ul li  {
            <?php if ( !empty( $main_sidebar_colors[ 'divider' ] ) ) { ?>
                border-color: <?php echo $main_sidebar_colors[ 'divider' ]; ?>;
            <?php } ?>
        }
        /********** element option *************/
        .btn-leap, a.btn-leap, .btn-leap.disabled, 
        .btn-leap[disabled] , a.btn-leap.disabled, 
        a.btn-leap[disabled],  .widget a.btn-leap, input[type="submit"], 
        input[type="reset"], input[type="button"] {
            <?php echo leap_get_typography_value( 'button_typography' ); ?>
            <?php
            $button_spacing           = ot_get_option( 'button_spacing', array() );
            $button_spacing_unit      = (!empty( $button_spacing[ 'unit' ] )) ? $button_spacing[ 'unit' ] : 'px';
            ?>
            <?php if ( isset( $button_spacing[ 'top' ] ) && strlen( $button_spacing[ 'top' ] ) > 0 ) { ?>
                padding-top: <?php echo esc_attr($button_spacing[ 'top' ]) . esc_attr($button_spacing_unit); ?>;
            <?php } ?>
            <?php if ( isset( $button_spacing[ 'right' ] ) && strlen( $button_spacing[ 'right' ] ) > 0 ) { ?>
                padding-right: <?php echo esc_attr($button_spacing[ 'right' ]) . esc_attr($button_spacing_unit); ?>;
            <?php } ?>
            <?php if ( isset( $button_spacing[ 'bottom' ] ) && strlen( $button_spacing[ 'bottom' ] ) > 0 ) { ?>
                padding-bottom: <?php echo esc_attr($button_spacing[ 'bottom' ]) . esc_attr($button_spacing_unit); ?>;
            <?php } ?>
            <?php if ( isset( $button_spacing[ 'left' ] ) && strlen( $button_spacing[ 'left' ] ) > 0 ) { ?>
                padding-left: <?php echo esc_attr($button_spacing[ 'left' ]) . esc_attr($button_spacing_unit); ?>;
            <?php } ?>
            <?php
            $button_border      = ot_get_option( 'button_border', array() );
            $button_border_unit = (!empty( $button_border[ 'unit' ] )) ? $button_border[ 'unit' ] : 'px';

            if ( !empty( $button_border[ 'color' ] ) ) {
                ?>
                border-color: <?php echo esc_attr($button_border[ 'color' ]); ?>;
            <?php } ?>
            <?php if ( !empty( $button_border[ 'style' ] ) ) { ?>
                border-style: <?php echo esc_attr($button_border[ 'style' ]); ?>;
            <?php } ?>
            <?php if ( isset( $button_border[ 'width' ] ) && strlen( $button_border[ 'width' ] ) > 0 ) { ?>
                border-width: <?php echo esc_attr($button_border[ 'width' ]) . esc_attr($button_border_unit); ?>;
            <?php } ?>
                <?php $button_options = ot_get_option( 'button_color_options', array() ); ?>
            <?php if ( !empty( $button_options[ 'bg' ] ) ) { ?>
                background-color: <?php echo esc_attr($button_options[ 'bg' ]); ?>;
            <?php } ?>
        <?php
        $button_radius_size = ot_get_option( 'button_radius_size', array( '0', 'px' ) );
        $button_radius_size_unit      = (!empty( $button_radius_size[ 1 ] )) ? $button_radius_size[ 1 ] : 'px';
        ?>
            border-radius: <?php echo esc_attr($button_radius_size[ 0 ]) . esc_attr($button_radius_size_unit); ?>;
        }           
        <?php $button_options = ot_get_option( 'button_color_options', array() ); ?>
        .btn-leap:hover, .btn-leap:focus, .btn-leap:active, .btn-leap.active,  
        a.btn-leap:hover, a.btn-leap:focus, a.btn-leap:active, a.btn-leap.active, 
        .widget a.btn-leap:hover, .widget a.btn-leap:focus, input[type="submit"]:hover, input[type="reset"]:hover, 
        input[type="button"]:hover, input[type="submit"]:focus, input[type="reset"]:focus, input[type="button"]:focus {
            <?php if ( !empty( $button_options[ 'text-hover' ] ) ) { ?>
                color: <?php echo esc_attr($button_options[ 'text-hover' ]); ?>;
            <?php } ?>
            <?php if ( !empty( $button_options[ 'bg-hover' ] ) ) { ?>
                background-color: <?php echo esc_attr($button_options[ 'bg-hover' ]); ?>;
            <?php } ?>
            <?php if ( !empty( $button_options[ 'border-hover' ] ) ) { ?>
                border-color: <?php echo esc_attr($button_options[ 'border-hover' ]); ?>;
            <?php } ?>
            
        }
        .header .logo,  .header15-layout .header .fixed-header .logo {
            <?php
            $logo_spacing           = ot_get_option( 'logo_spacing', array() );
            $logo_spacing_unit      = (!empty( $logo_spacing[ 'unit' ] )) ? $logo_spacing[ 'unit' ] : 'px';
            ?>
            <?php if ( isset( $logo_spacing[ 'top' ] ) && strlen( $logo_spacing[ 'top' ] ) > 0 ) { ?>
                margin-top: <?php echo esc_attr($logo_spacing[ 'top' ]) . esc_attr($logo_spacing_unit); ?>;
            <?php } ?>
            <?php if ( isset( $logo_spacing[ 'right' ] ) && strlen( $logo_spacing[ 'right' ] ) > 0 ) { ?>
                margin-right: <?php echo esc_attr($logo_spacing[ 'right' ]) . esc_attr($logo_spacing_unit); ?>;
            <?php } ?>
            <?php if ( isset( $logo_spacing[ 'bottom' ] ) && strlen( $logo_spacing[ 'bottom' ] ) > 0 ) { ?>
                margin-bottom: <?php echo esc_attr($logo_spacing[ 'bottom' ]) . esc_attr($logo_spacing_unit); ?>;
            <?php } ?>
            <?php if ( isset( $logo_spacing[ 'left' ] ) && strlen( $logo_spacing[ 'left' ] ) > 0 ) { ?>
                margin-left: <?php echo esc_attr($logo_spacing[ 'left' ]) . esc_attr($logo_spacing_unit); ?>;
            <?php } ?>
        }
        <?php $input_options = ot_get_option( 'input_color_options', array() ); ?>
        input[type="text"], input[type="text"]:focus, .form-control, .form-control:focus, textarea, 
        textarea:focus, input[type="password"], input[type="password"]:focus, 
        .select2-container .select2-choice, .select2-container .select2-choice:focus, 
        .select2-results .select2-highlighted, .select2-results, input[type="email"], 
        input[type="date"], input[type="number"], input[type="email"]:focus, input[type="tel"], 
        input[type="tel"]:focus, input[type="date"]:focus, input[type="number"]:focus, 
        .select2-container .select2-choice, #lang_sel a.lang_sel_sel, 
        #lang_sel a.lang_sel_sel:hover, #lang_sel a.lang_sel_sel:focus , #lang_sel ul ul a ,
        #lang_sel ul ul a:hover, #lang_sel ul ul a:focus
        {<?php if ( !empty( $input_options[ 'text' ] ) ) { ?>
                color: <?php echo $input_options[ 'text' ]; ?>;
            <?php } ?>
            <?php if ( !empty( $input_options[ 'bg' ] ) ) { ?>
                background-color: <?php echo $input_options[ 'bg' ]; ?>;
            <?php } ?>
            <?php if ( !empty( $input_options[ 'border' ] ) ) { ?>
                border-color: <?php echo $input_options[ 'border' ]; ?>;
            <?php } ?>
        }
        .form-control::-moz-placeholder {
            <?php if ( !empty( $input_options[ 'text' ] ) ) { ?>
                color: <?php echo $input_options[ 'text' ]; ?>;
            <?php } ?>
        }
        .form-control::-ms-input-placeholder {
            <?php if ( !empty( $input_options[ 'text' ] ) ) { ?>
                color: <?php echo $input_options[ 'text' ]; ?>;
            <?php } ?>
        }
        .form-control::-webkit-input-placeholder {
            <?php if ( !empty( $input_options[ 'text' ] ) ) { ?>
                color: <?php echo $input_options[ 'text' ]; ?>;
            <?php } ?>
        }
        .searchform .navbar-search:before {
            <?php if ( !empty( $input_options[ 'bg' ] ) ) { ?>
                border-bottom-color: <?php echo $input_options[ 'bg' ]; ?>;
            <?php } ?>
        }
        .searchform .navbar-search, .static-search .navbar-search {
            <?php if ( !empty( $input_options[ 'bg' ] ) ) { ?>
                border-color: <?php echo $input_options[ 'bg' ]; ?>;
            <?php } ?>
        }         
        <?php if ( ot_get_option( 'display_titles_strip_image' ) == 'off' ) : ?>
            div.title h1:after, div.title h2:after, div.title h3:after, div.title h4:after, div.title h5:after, 
            div.title h6:after, div.title.title-strip.title-center h1:before, div.title.title-strip.title-center h2:before, 
            div.title.title-strip.title-center h3:before, div.title.title-strip.title-center h4:before, 
            div.title.title-strip.title-center h5:before, div.title.title-strip.title-center h6:before, 
            div.title.title-strip.title-center h1:after, div.title.title-strip.title-center h2:after, 
            div.title.title-strip.title-center h3:after, div.title.title-strip.title-center h4:after, 
            div.title.title-strip.title-center h5:after, div.title.title-strip.title-center h6:after, 
            div.title.title-strip h1:after, div.title.title-strip h2:after, div.title.title-strip h3:after, 
            div.title.title-strip h4:after, div.title.title-strip h5:after, div.title.title-strip h6:after {
                display: none;
            }
        <?php endif; ?>

        .portfolio-sep, .blog-wrapper .hentry, .archive-wrapper .hentry {
            <?php
            $posts_list_separator      = ot_get_option( 'posts_list_separator', array() );
            $posts_list_separator_unit = (!empty( $posts_list_separator[ 'unit' ] )) ? $posts_list_separator[ 'unit' ] : 'px';

            if ( !empty( $posts_list_separator[ 'color' ] ) ) {
                ?>
                border-bottom-color: <?php echo $posts_list_separator[ 'color' ]; ?>;
            <?php } ?>
            <?php if ( !empty( $posts_list_separator[ 'style' ] ) ) { ?>
                border-bottom-style: <?php echo $posts_list_separator[ 'style' ]; ?>;
            <?php } ?>
            <?php if ( isset( $posts_list_separator[ 'width' ] ) && strlen( $posts_list_separator[ 'width' ] ) > 0 ) { ?>
                border-bottom-width: <?php echo $posts_list_separator[ 'width' ] . $posts_list_separator_unit; ?>;
            <?php } ?>
        } 


        /********************************************************************************/
        /***********************************  typography ***************************************/
        body, caption, .variations .label, legend {
            <?php echo leap_get_typography_value( 'body_typography' ); ?>
        }
        .top-menu > li > a {
            <?php echo leap_get_typography_value( 'top_menu_typography' ); ?>
        }
        .top-menu > li:before {
            <?php
            $top_menu_typography = ot_get_option( 'top_menu_typography', array() );
            ?>
            <?php if ( !empty( $top_menu_typography[ 'line-height' ] ) ) { ?>
                line-height: <?php echo $top_menu_typography[ 'line-height' ]; ?>;
            <?php } ?>
        }
        <?php
        $top_menu_colors = ot_get_option( 'top_menu_colors', array() );
        ?>
        .top-menu.sf-menu > li > a:hover , .top-menu.sf-menu > li.current_page_ancestor > a, .top-menu ul > li.current_page_item a,
        .top-menu.sf-menu > li > a:active, .top-menu.sf-menu > li > a:focus  {
            <?php if ( !empty( $top_menu_colors[ 'text-hover' ] ) ) { ?>
                color: <?php echo $top_menu_colors[ 'text-hover' ]; ?>;
            <?php } ?>
        }
        <?php
        $top_menu_sep = ot_get_option( 'top_menu_sep' );
        if ( $top_menu_sep == 'off' ) {
            ?>
            .top-menu.sf-menu > li:before {
                display:none ;
            }
        <?php } else { ?>
            <?php if ( !empty( $top_menu_colors[ 'sep' ] ) ) { ?>
                .top-menu.sf-menu > li:before {
                    color: <?php echo $top_menu_colors[ 'sep' ] ?> !important;
                }
            <?php } ?>
        <?php } ?>
        .top-menu.sf-menu ul li a , .top-menu.sf-menu ul li:before {
            <?php echo leap_get_typography_value( 'top_menu_sub_typography' ); ?>
        }

        <?php
        $top_sub_colors = ot_get_option( 'top_sub_colors', array() );
        ?>
        .top-menu ul, .top-menu.sf-menu ul li, .top-menu.sf-menu ul li:hover, .top-menu.sf-menu ul li.sfHover {
            <?php if ( !empty( $top_sub_colors[ 'bg' ] ) ) { ?>
                background-color: <?php echo $top_sub_colors[ 'bg' ]; ?>;
            <?php } ?>
            <?php if ( !empty( $top_sub_colors[ 'divider' ] ) ) { ?>
                border-bottom-color: <?php echo $top_sub_colors[ 'divider' ]; ?>;
            <?php } ?>
        }
        .top-menu.sf-menu ul > li:hover > a , .top-menu.sf-menu ul > li.current_page_item > a {
            <?php if ( !empty( $top_sub_colors[ 'text-hover' ] ) ) { ?>
                color: <?php echo $top_sub_colors[ 'text-hover' ]; ?>;
            <?php } ?>
        }


        #leap-header.header .contact-info, #leap-header.header .contact-info span, #leap-header.header .contact-info a {
            <?php echo leap_get_typography_value( 'contact_details_typography' ); ?>
        }
        <?php $sticky_menu_colors = ot_get_option( 'sticky_menu_colors', array() ); ?>
        .fixed-header .main-menu > li > a , .fixed-header a#searchbutton {
            <?php if ( !empty( $sticky_menu_colors[ 'text' ] ) ) { ?>
                color: <?php echo $sticky_menu_colors[ 'text' ]; ?>;
            <?php } ?>
        }
        .fixed-header .main-menu li a:hover, .fixed-header .main-menu li a:focus, .fixed-header .main-menu li a:active, 
        .fixed-header .main-menu li.sfHover > a,
        .fixed-header .main-menu li a:hover span, .fixed-header .main-menu li a:focus span, .fixed-header .main-menu li a:active span,
        .fixed-header .main-menu li.current-menu-item > a, 
        .fixed-header .main-menu li.current-page-ancestor > a, 
        .fixed-header .main-menu li.current-page-ancestor > a:hover,
        .fixed-header .main-menu li.current-menu-ancestor > a, 
        .fixed-header .main-menu li.current-menu-ancestor > a:hover, 
        .fixed-header .main-menu li.current-menu-parent > a, 
        .fixed-header .main-menu li.current-menu-parent > a:hover, 
        .fixed-header .main-menu li.current_page_ancestor > a, 
        .fixed-header .main-menu li.current_page_ancestor > a:hover {
            <?php if ( !empty( $sticky_menu_colors[ 'text-hover' ] ) ) { ?>
                color: <?php echo $sticky_menu_colors[ 'text-hover' ]; ?>;
            <?php } ?>
        }
        .fixed-header .main-menu > li:hover, .fixed-header .main-menu > li:active, .fixed-header .main-menu > li:focus, 
        .fixed-header .main-menu > li.sfHover, .fixed-header .main-menu > li a:hover, 
        .fixed-header .main-menu > li.sfHover > a.sf-with-ul,
        .fixed-header .main-menu ul li a:hover, .fixed-header .main-menu ul li a:focus, .fixed-header .main-menu ul li a:active {
            <?php if ( !empty( $sticky_menu_colors[ 'text-hover' ] ) ) { ?>
                border-color: <?php echo $sticky_menu_colors[ 'text-hover' ]; ?>;
            <?php } ?>
        }
        .fixed-header .main-menu > li:before {
            <?php if ( !empty( $sticky_menu_colors[ 'sep' ] ) ) { ?>
                color: <?php echo $sticky_menu_colors[ 'sep' ]; ?>;
            <?php } ?>
        }


        <?php $sticky_sub_colors = ot_get_option( 'sticky_sub_colors', array() ); ?>
        .fixed-header .main-menu ul li, .fixed-header .main-menu ul ul li, .fixed-header .main-menu ul li:hover, 
        .fixed-header .main-menu ul li:focus, .fixed-header .sf-menu ul li.sfHover, .fixed-header .sf-menu .sf-mega, .fixed-header .sf-menu .sf-mega.menu-fullwidth .row,
        .fixed-header span.mega-section-head, .fixed-header span:hover.mega-section-head, .fixed-header .main-menu ul li.sfHover, 
        .fixed-header span.mega-section-head, .fixed-header span:hover.mega-section-head, 
        .fixed-header .main-menu .menu-item-has-megamenu ul ul li {
            <?php if ( !empty( $sticky_sub_colors[ 'bg' ] ) ) { ?>
                background-color: <?php echo $sticky_sub_colors[ 'bg' ]; ?>;
            <?php } ?>
        }
        .fixed-header .main-menu ul li a, .fixed-header .main-menu ul li span, .fixed-header .main-menu ul li strong, 
        .fixed-header .main-menu .mega-section-head a, .fixed-header .main-menu .mega-section-head > span {
            <?php if ( !empty( $sticky_sub_colors[ 'text' ] ) ) { ?>
                color: <?php echo $sticky_sub_colors[ 'text' ]; ?>;
            <?php } ?>
        }
        .fixed-header .main-menu ul li a, .fixed-header #main-menu .menu-item-cart ul.cart_list li, 
        .fixed-header #main-menu .menu-item-cart ul.cart_list li:first-child, 
        .fixed-header #main-menu .menu-item-cart .widget_shopping_cart_content, 
        .fixed-header #main-menu .widget_shopping_cart_content .buttons {
            <?php if ( !empty( $sticky_sub_colors[ 'divider' ] ) ) { ?>
                border-color: <?php echo $sticky_sub_colors[ 'divider' ]; ?>;
            <?php } ?>
        }
        .fixed-header .main-menu ul li a:hover, .fixed-header .main-menu > li.sfHover ul li a:hover, 
        .fixed-header .main-menu .mega-section-head a:hover, .header .fixed-header ul.main-menu ul li.current-menu-item > a, 
        .header .fixed-header ul.main-menu ul li.current-menu-item > a:hover, 
        .header .fixed-header ul.main-menu ul li.current-page-ancestor > a, 
        .header .fixed-header ul.main-menu ul li.current-page-ancestor > a:hover, 
        .header .fixed-header ul.main-menu ul li.current-menu-ancestor > a,
        .fixed-header .main-menu ul li a:hover span {
            <?php if ( !empty( $sticky_sub_colors[ 'text-hover' ] ) ) { ?>
                border-color: <?php echo $sticky_sub_colors[ 'text-hover' ]; ?>;
                color: <?php echo $sticky_sub_colors[ 'text-hover' ] ?>;
            <?php } ?>
        }
        #crumbs, #crumbs span, #crumbs a {
            <?php echo leap_get_typography_value( 'breadcrumbs_typography' ); ?>
        }
        <?php $breadcrumbs_links_hover = ot_get_option( 'breadcrumbs_links_hover', '' ); ?>
        #crumbs a:hover, #crumbs a:active, #crumbs a:focus {
            <?php if ( !empty( $breadcrumbs_links_hover ) ) { ?>
                color: <?php echo $breadcrumbs_links_hover; ?>;
            <?php } ?>
        }
        div.entry-title h1, .pagetitle3 .entry-title h1 {
            <?php echo leap_get_typography_value( 'page_title_typography' ); ?>
        }
        <?php $content_meta_color = ot_get_option( 'content_meta_color', '' ); ?>
        .content-section small.small, .content-section a:hover small.small, .content-section small a, 
        .content-section small a:hover, .commentmetadata a, .content-section .wp-caption , .content-section .wp-caption a {
            <?php if ( !empty( $content_meta_color ) ) { ?>
                color: <?php echo $content_meta_color; ?>;
            <?php } ?>
        }
        .content-section {
            <?php echo leap_get_typography_value( 'content_entry_typography' ); ?>
        }
        /*** post entry ***/
        /*****************************************************/
        h2.entry-title, .content-section h2.entry-title , h2.entry-title a, .portfolio-wrapper h2.entry-title a , 
        .content-section .portfolio-wrapper h2.entry-title {
            <?php echo leap_get_typography_value( 'listing_post_title_typography' ); ?>
        }
        /***** headers ********/
        .content-section h1{
            <?php echo leap_get_typography_value( 'h1_typography' ); ?>
        }
        .content-section h2{
            <?php echo leap_get_typography_value( 'h2_typography' ); ?>
        }
        .content-section h3{
            <?php echo leap_get_typography_value( 'h3_typography' ); ?>
        }
        .content-section h4{
            <?php echo leap_get_typography_value( 'h4_typography' ); ?>
        }
        .content-section h5{
            <?php echo leap_get_typography_value( 'h5_typography' ); ?>
        }
        .content-section h6{
            <?php echo leap_get_typography_value( 'h6_typography' ); ?>
        }
        /************* footer *********/
        /************* footer *****************/
        #leap-footer {
            <?php echo leap_get_background_value( 'footer_bg' ); ?>
        }
        <?php $copyright_social_icons_colors = ot_get_option( 'copyright_social_icons_colors', array() ); ?>
        #leap-footer p.social-networks a {
            <?php if ( !empty( $copyright_social_icons_colors[ 'icon' ] ) ) { ?>
                color: <?php echo $copyright_social_icons_colors[ 'icon' ]; ?>;
            <?php } ?>
        }
        #leap-footer p.social-networks a:hover i {
            <?php if ( !empty( $copyright_social_icons_colors[ 'icon-hover' ] ) ) { ?>
                color: <?php echo $copyright_social_icons_colors[ 'icon-hover' ]; ?>;
            <?php } ?>
        }


        <?php $go_top_colors = ot_get_option( 'go_top_colors', array() ); ?>
        a.scrollup span {
            <?php if ( !empty( $go_top_colors[ 'icon' ] ) ) { ?>
                color: <?php echo $go_top_colors[ 'icon' ]; ?>;
            <?php } ?>
        }
        a.scrollup {
            <?php if ( !empty( $go_top_colors[ 'bg' ] ) ) { ?>
                background-color:  <?php echo $go_top_colors[ 'bg' ]; ?>;
            <?php } ?>
        }
        a.scrollup {
            <?php
            $go_top_spacing           = ot_get_option( 'go_top_spacing', array() );
            $go_top_spacing_unit      = (!empty( $go_top_spacing[ 'unit' ] )) ? $go_top_spacing[ 'unit' ] : 'px';
            ?>
            <?php if ( isset( $go_top_spacing[ 'top' ] ) && strlen( $go_top_spacing[ 'top' ] ) > 0 ) { ?>
                top: <?php echo $go_top_spacing[ 'top' ] . $go_top_spacing_unit; ?>;
            <?php } ?>
            <?php if ( isset( $go_top_spacing[ 'right' ] ) && strlen( $go_top_spacing[ 'right' ] ) > 0 ) { ?>
                right: <?php echo $go_top_spacing[ 'right' ] . $go_top_spacing_unit; ?>;
            <?php } ?>
            <?php if ( isset( $go_top_spacing[ 'bottom' ] ) && strlen( $go_top_spacing[ 'bottom' ] ) > 0 ) { ?>
                bottom: <?php echo $go_top_spacing[ 'bottom' ] . $go_top_spacing_unit; ?>;
            <?php } ?>
            <?php if ( isset( $go_top_spacing[ 'left' ] ) && strlen( $go_top_spacing[ 'left' ] ) > 0 ) { ?>
                left: <?php echo $go_top_spacing[ 'left' ] . $go_top_spacing_unit; ?>;
            <?php } ?>
        }

        <?php $footer_input_colors = ot_get_option( 'footer_input_colors', array() ); ?> 
        #footer-sidebar input[type="text"], #footer-sidebar input[type="text"]:focus, #footer-sidebar .form-control, 
        #footer-sidebar .form-control:focus, #footer-sidebar textarea, #footer-sidebar textarea:focus, 
        #footer-sidebar input[type="password"], #footer-sidebar input[type="password"]:focus, 
        #footer-sidebar input[type="email"], #footer-sidebar input[type="date"], #footer-sidebar input[type="number"], 
        #footer-sidebar input[type="email"]:focus, #footer-sidebar input[type="date"]:focus, 
        #footer-sidebar input[type="number"]:focus {
        <?php if ( !empty( $footer_input_colors[ 'text' ] ) ) { ?>
                color: <?php echo $footer_input_colors[ 'text' ]; ?>;
            <?php } ?>
            <?php if ( !empty( $footer_input_colors[ 'bg' ] ) ) { ?>
                background-color: <?php echo $footer_input_colors[ 'bg' ]; ?>;
            <?php } ?>
            <?php if ( !empty( $footer_input_colors[ 'border' ] ) ) { ?>
                border-color: <?php echo $footer_input_colors[ 'border' ]; ?>;
            <?php } ?>
        }
        #footer-sidebar .form-control::-moz-placeholder {
            <?php if ( !empty( $footer_input_colors[ 'text' ] ) ) { ?>
                color: <?php echo $footer_input_colors[ 'text' ]; ?>;
            <?php } ?>
        }
        #footer-sidebar .form-control:-ms-input-placeholder {
            <?php if ( !empty( $footer_input_colors[ 'text' ] ) ) { ?>
                color: <?php echo $footer_input_colors[ 'text' ]; ?>;
            <?php } ?>
        }
        #footer-sidebar .form-control::-webkit-input-placeholder {
            <?php if ( !empty( $footer_input_colors[ 'text' ] ) ) { ?>
                color: <?php echo $footer_input_colors[ 'text' ]; ?>;
            <?php } ?>
        }

     <?php $footer_button_colors = ot_get_option( 'footer_button_colors', array() ); ?>
        #footer-sidebar input:focus:invalid:focus, #footer-sidebar textarea:focus:invalid:focus, #footer-sidebar select:focus:invalid:focus  {
            <?php if ( !empty( $footer_button_colors[ 'text' ] ) ) { ?>
                color: <?php echo esc_attr($footer_button_colors[ 'text' ]); ?>;
            <?php } ?>
            <?php if ( !empty( $footer_button_colors[ 'border' ] ) ) { ?>
                border-color: <?php echo esc_attr($footer_button_colors[ 'border' ]); ?>;
            <?php } ?>
            <?php if ( !empty( $footer_button_colors[ 'bg' ] ) ) { ?>
                background-color: <?php echo esc_attr($footer_button_colors[ 'bg' ]); ?>;
            <?php } ?>    
        }

        #footer-sidebar .form-control::-moz-placeholder {
            <?php if ( !empty( $footer_input_colors[ 'text' ] ) ) { ?>
                color: <?php echo $footer_input_colors[ 'text' ]; ?>;
            <?php } ?>
        }
        #footer-sidebar .form-control:-ms-input-placeholder {
            <?php if ( !empty( $footer_input_colors[ 'text' ] ) ) { ?>
                color: <?php echo $footer_input_colors[ 'text' ]; ?>;
            <?php } ?>
        }
        #footer-sidebar .form-control::-webkit-input-placeholder {
            <?php if ( !empty( $footer_input_colors[ 'text' ] ) ) { ?>
                color: <?php echo $footer_input_colors[ 'text' ]; ?>;
            <?php } ?>
        }

        <?php $footer_button_colors = ot_get_option( 'footer_button_colors', array() ); ?>
        #footer-sidebar .btn-leap, #footer-sidebar .btn-leap:hover, #footer-sidebar .btn-leap:focus, 
        #footer-sidebar .btn-leap.disabled, #footer-sidebar .btn-leap[disabled], #footer-sidebar a.btn-leap, 
        #footer-sidebar a.btn-leap:hover, #footer-sidebar a.btn-leap:focus, #footer-sidebar .widget a.btn-leap, 
        #footer-sidebar .widget a.btn-leap:hover, #footer-sidebar .widget a.btn-leap:focus, 
        #footer-sidebar input[type="submit"], #footer-sidebar input[type="reset"], #footer-sidebar input[type="button"], 
        #footer-sidebar input[type="submit"]:hover, #footer-sidebar input[type="reset"]:hover, 
        #footer-sidebar input[type="button"]:hover, #footer-sidebar input[type="submit"]:focus, 
        #footer-sidebar input[type="reset"]:focus, #footer-sidebar input[type="button"]:focus {
            <?php if ( !empty( $footer_button_colors[ 'text' ] ) ) { ?>
                color: <?php echo $footer_button_colors[ 'text' ]; ?>;
            <?php } ?>

            <?php if ( !empty( $footer_button_colors[ 'bg' ] ) ) { ?>
                background-color: <?php echo $footer_button_colors[ 'bg' ]; ?>;
            <?php } ?>

            <?php if ( !empty( $footer_button_colors[ 'border' ] ) ) { ?>
                border-color: <?php echo $footer_button_colors[ 'border' ]; ?>;
            <?php } ?>
        }
        #footer-sidebar .btn-leap:hover, #footer-sidebar .btn-leap:focus, #footer-sidebar .btn-leap.disabled, 
        #footer-sidebar .btn-leap[disabled], #footer-sidebar a.btn-leap:hover, #footer-sidebar a.btn-leap:focus, 
        #footer-sidebar .widget a.btn-leap:hover, #footer-sidebar .widget a.btn-leap:focus, #footer-sidebar input[type="submit"]:hover, 
        #footer-sidebar input[type="reset"]:hover, #footer-sidebar input[type="button"]:hover, 
        #footer-sidebar input[type="submit"]:focus, #footer-sidebar input[type="reset"]:focus, 
        #footer-sidebar input[type="button"]:focus {
            <?php if ( !empty( $footer_button_colors[ 'text-hover' ] ) ) { ?>
                color: <?php echo esc_attr($footer_button_colors[ 'text-hover' ]); ?>;
            <?php } ?>
            <?php if ( !empty( $footer_button_colors[ 'border-hover' ] ) ) { ?>
                 border-color: <?php echo esc_attr($footer_button_colors[ 'border-hover' ]); ?>;
            <?php } ?>
            <?php if ( !empty( $footer_button_colors[ 'bg-hover' ] ) ) { ?>
                background-color: <?php echo esc_attr($footer_button_colors[ 'bg-hover' ]); ?>;
            <?php } ?>     
        }
        #footer-sidebar .container-fluid, #footer-sidebar > .container {
            <?php
            $footer_spacing      = ot_get_option( 'footer_spacing', array() );
            $footer_spacing_unit = (!empty( $footer_spacing[ 'unit' ] )) ? $footer_spacing[ 'unit' ] : 'px';
            if ( isset( $footer_spacing[ 'top' ] ) && strlen( $footer_spacing[ 'top' ] ) > 0 ) :
                ?>
                padding-top: <?php echo $footer_spacing[ 'top' ] . $footer_spacing_unit; ?>;
            <?php endif; ?>
            <?php if ( isset( $footer_spacing[ 'bottom' ] ) && strlen( $footer_spacing[ 'bottom' ] ) > 0 ) : ?>
                padding-bottom: <?php echo $footer_spacing[ 'bottom' ] . $footer_spacing_unit; ?>;
            <?php endif; ?>
        }

        <?php $footer_colors = ot_get_option( 'footer_colors', array() ); ?>
        #footer-sidebar .widget span.date, #footer-sidebar .widget small.small, #footer-sidebar .widget small a, 
        #footer-sidebar .widget_recent_entries ul li span.post-date, #footer-sidebar .widget.woocommerce ul li del, 
        #footer-sidebar .widget.woocommerce ul li del span.amount, #footer-sidebar .wp-caption , 
        #footer-sidebar .wp-caption a, #footer-sidebar .widget_display_topics li div, 
        #footer-sidebar .widget_display_replies li div {
            <?php if ( !empty( $footer_colors[ 'meta' ] ) ) { ?>
                color: <?php echo $footer_colors[ 'meta' ]; ?>;
            <?php } ?>
        }

        #footer-sidebar a, #footer-sidebar .entry-meta a, #footer-sidebar div.entry-meta a span, 
        #footer-sidebar #crumbs a, #footer-sidebar a.more-link span.meta-nav:after, 
        #footer-sidebar a.readmore:after, #footer-sidebar a.readmore, #footer-sidebar a.more-link, 
        #footer-sidebar .leap-icon-box .more, #footer-sidebar .leap-icon-box .more a, #footer-sidebar .leap-icon-box .more a:after, 
        #footer-sidebar .more a span, #footer-sidebar .more a span:before, #footer-sidebar .more a span:after, 
        #footer-sidebar a.readmore:after, #footer-sidebar .sc-rposts .post-title a, #footer-sidebar .sc-rposts .post-comment a, 
        #footer-sidebar .list_carousel .cfs-nav span:before, #footer-sidebar .widget a, 
        #footer-sidebar ol.commentlist div.comment-author a, #footer-sidebar .pagination ul > .active > a, 
        #footer-sidebar .pagination ul > .active > span, #footer-sidebar ul.portfolio-tabs li.active a, 
        #footer-sidebar .post-navigation div span, #footer-sidebar .post-navigation div a, #footer-sidebar #tag-cloud a, 
        #footer-sidebar .tags a, #footer-sidebar .shipping_calculator h2 a, #footer-sidebar .woocommerce-info a, 
        #footer-sidebar .myaccount_user a, #footer-sidebar .woocommerce-tabs ul.tabs li.active a, 
        #footer-sidebar .yith-woocompare-widget a.clear-all:after, #footer-sidebar .yith-woocompare-widget a.clear-all:before, 
        #footer-sidebar .woocommerce-tabs ul.tabs li a {
            <?php if ( !empty( $footer_colors[ 'link' ] ) ) { ?>
                color: <?php echo $footer_colors[ 'link' ]; ?>;
            <?php } ?>
        }
        #footer-sidebar a:hover, #footer-sidebar a:focus, #footer-sidebar a:active, #footer-sidebar .widget a:hover, 
        #footer-sidebar .widget a:focus, #footer-sidebar .widget a:active, #footer-sidebar .entry-meta a:hover, 
        #footer-sidebar .entry-meta a:active, #footer-sidebar .entry-meta a:focus, #footer-sidebar .entry-meta a:hover span, 
        #footer-sidebar a.more-link:hover span.meta-nav:after, #footer-sidebar a.readmore:hover, 
        #footer-sidebar a.readmore:hover:after, #footer-sidebar a.more-link:hover, #footer-sidebar .more a:hover span, 
        #footer-sidebar .more a:hover span:before, #footer-sidebar .more a:hover span:after, 
        #footer-sidebar .leap-icon-box .more:hover, #footer-sidebar .leap-icon-box .more a:hover, 
        #footer-sidebar .leap-icon-box .more:hover a:after, #footer-sidebar .sc-rposts .post-title a:hover, 
        #footer-sidebar .sc-rposts .post-title a:active, #footer-sidebar .sc-rposts .post-title a:focus, 
        #footer-sidebar .sc-rposts .post-comment a:hover, #footer-sidebar ol.commentlist div.comment-author a:hover, 
        #footer-sidebar ol.commentlist div.comment-author a:active, #footer-sidebar ol.commentlist div.comment-author a:focus, 
        #footer-sidebar .pagination ul > .active > a:hover, #footer-sidebar .pagination ul > .active > span:hover, 
        #footer-sidebar ul.portfolio-tabs li a:hover, #footer-sidebar ul.portfolio-tabs li.active a:hover, 
        #footer-sidebar .post-navigation div:hover span, #footer-sidebar .post-navigation div:hover a, 
        #footer-sidebar #tag-cloud a:hover, #footer-sidebar .tags a:hover, #footer-sidebar .shipping_calculator h2 a:hover, 
        #footer-sidebar .woocommerce-info a:hover, #footer-sidebar .myaccount_user a:hover, 
        #footer-sidebar .woocommerce-tabs ul.tabs li.active a:hover, #footer-sidebar .woocommerce-tabs ul.tabs li a:hover, 
        #footer-sidebar .list_carousel .cfs-nav span:hover:before, #footer-sidebar .yith-woocompare-widget a.clear-all:hover:after {
            <?php if ( !empty( $footer_colors[ 'link-hover' ] ) ) { ?>
                color: <?php echo $footer_colors[ 'link-hover' ]; ?>;
            <?php } ?>
        }
        #footer-sidebar .woocommerce.widget_product_categories ul li, #footer-sidebar .woocommerce .widget_layered_nav ul li, 
        #footer-sidebar .woocommerce .widget_layered_nav ul li, #footer-sidebar .woocommerce-page .widget_layered_nav ul li, 
        #footer-sidebar .woocommerce-page .widget_layered_nav ul li, #footer-sidebar .woocommerce ul.product_list_widget li, 
        #footer-sidebar .widget_archive ul li, #footer-sidebar .widget_categories ul li, #footer-sidebar .widget_nav_menu ul li, 
        #footer-sidebar .widget_meta ul li , #footer-sidebar .widget_pages ul li, #footer-sidebar .widget_recent_comments ul li, 
        #footer-sidebar .widget_recent_entries ul li, #footer-sidebar .widget_rss ul li , 
        #footer-sidebar .widget.comments-avatar ul li, #footer-sidebar div.category-posts ul li, 
        #footer-sidebar .widget_author_posts ul li, #footer-sidebar .widget.posts-list ul li,#footer-sidebar div.widget.category-posts ul li, #footer-sidebar .widget.leap-tabs .ui-tabs-panel li,
        #footer-sidebar .widget.tweets ul li, #footer-sidebar ol.commentlist li, 
        #footer-sidebar ol.commentlist ul.children li, .woocommerce-MyAccount-navigation li {
            <?php if ( !empty( $footer_colors[ 'divider' ] ) ) { ?>
                border-color: <?php echo $footer_colors[ 'divider' ]; ?>;
            <?php } ?>
        }

        <?php $copyright_colors          = ot_get_option( 'copyright_colors', array() ); ?>
        <?php
        $copyright_top_border      = ot_get_option( 'copyright_top_border', array() );
        $copyright_top_border_unit = (!empty( $copyright_top_border[ 'unit' ] )) ? $copyright_top_border[ 'unit' ] : 'px';
        ?>
        #leap-footer div.footer-block {
            <?php if ( !empty( $copyright_colors[ 'bg' ] ) ) { ?>
                background-color: <?php echo $copyright_colors[ 'bg' ]; ?>;
            <?php } ?>
            <?php if ( isset( $copyright_top_border[ 'width' ] ) && strlen( $copyright_top_border[ 'width' ] ) > 0 ) { ?>
                border-top-width: <?php echo $copyright_top_border[ 'width' ] . $copyright_top_border_unit; ?>;
            <?php } ?>
            <?php if ( !empty( $copyright_top_border[ 'style' ] ) ) { ?>
                border-top-style: <?php echo $copyright_top_border[ 'style' ]; ?>;
            <?php } ?>
            <?php if ( !empty( $copyright_top_border[ 'color' ] ) ) { ?>
                border-top-color: <?php echo $copyright_top_border[ 'color' ]; ?>;
            <?php } ?>

        }

        #leap-footer .footer-block a, ul#footer-menu li:before {
            <?php if ( !empty( $copyright_colors[ 'link' ] ) ) { ?>
                color: <?php echo $copyright_colors[ 'link' ]; ?>;
            <?php } ?>
        }
        #leap-footer .footer-block a:hover {
            <?php if ( !empty( $copyright_colors[ 'link-hover' ] ) ) { ?>
                color: <?php echo $copyright_colors[ 'link-hover' ]; ?>;
            <?php } ?>
        }

        #footer-sidebar p, #footer-sidebar div, #footer-sidebar li {
            <?php echo leap_get_typography_value( 'footer_typography' ); ?>
        }
        #footer-sidebar .widget-title {
            <?php echo leap_get_typography_value( 'footer_widgets_titles_typography' ); ?>
        }
        #leap-footer .footer-block p {
            <?php echo leap_get_typography_value( 'copyright_typography' ); ?>
        }
        /*********************************************/
        /********** Mobile options ****************/
        <?php
        $mobile_menu_width = ot_get_option( 'mobile_menu_width', array( '768', 'px' ) );
        ?>
        @media screen and (max-width: <?php echo $mobile_menu_width[ 0 ]; ?>px) {
            #mobile-menu {
                display: block;
            }
            .header15 #main-menu-container, .header15 .icon-social-block {
                display: none;
            }
            .header15 .top-header-content {
                display: block;
                position: absolute;
                z-index: 10;
            }
            .header15 #nav-icon {
                display: none;
            }
           .header15 .top-header-content {
                height: auto;
            }
            .header15 .slicknav_btn {
                margin-right: 18px;
            }
            .rtl .header15 .slicknav_btn {
                float: left;
                margin-left: 18px;
            }
            .rtl .header15 .icon-header .logo {
                margin-right: 18px;
            }
            .header15 .icon-header .logo {
                position: absolute;
                top: 0px;
                z-index: 1000;
                margin-left: 18px;
            }
            .header16 .social-icons {
                display: none;
            }
            .header16 {
                padding: 0px;
            }
            .header16 .navbar-inner {
                padding: 0px 20px;
            }
            .header .col-sm-6 {
                width: 100%;
                float: none;
            }
            .header4 .logo-block, .header5 .logo-block , .header6 .logo-block {
                display: none;
            }
            .header-vh .logo {
                position: relative;
                z-index: 101;
            }
            .header .logo a, .header .logo, .header-vh .logo a, .header-vh .logo {
                float: left
            }
            .rtl .header .logo a, .rtl .header .logo {
                float: right;
            }
            .header4 .navbar-inner .logo-block , .header6 .navbar-inner .logo-block {
                display: block;
            }
            .header4 .navbar-inner .logo , .header5 .navbar-inner .logo , .header6 .navbar-inner .logo  {
                display: block;
            }
            .header5 #top-menu.sf-menu > li {
                display: inline-block;
                float: none;
            }
            .header .row [class*="col-sm-"] {
                margin-bottom: 0px;
            }
            .header .pull-right, .header div.social-icons, .header .pull-left {
                float: none !important;
            }
            .header .logo.pull-left  {
                float: left;
                text-align: left;
            }
            .topbar-block .contact-info, .topbar-block .social-networks {
                width: 100%;
            }
            p.social-networks a {
                float: none;
            }
            .logo a {
                float: none;
                clear: both;
            }
            .header .pull-right, .header .pull-left {
                float: none;
                text-align: center;
                width: 100%;
            }
            .header .main-menu, .header .search, a#searchbutton:before, .header .static-search {
                display: none;
            }
            .fixed-header .main-menu-container, .main-menu-container {
                float: none;
            }
            .navbar-fixed-top.fixed-header {
                display: none;
            }
            .header .col-sm-8, .header .col-sm-4 {
                width: 100%;
                float: none;
            }
            /*.header6 .logo img, .header6 .logo h1 {
                margin: 35px 0px;
            }*/
            .header-vh .header-vh-wrapper {
                position: relative;
                width: 100%;
                left: auto;
                right: auto;
                padding: 0px 15px;
                border: none;
                box-shadow: none;
            }
            .admin-bar .header-vh .header-vh-wrapper {
                padding-top: 0px;
            }
            .header-vh .bottom-bar {
                display: none;
            }
            .header10 .header-vh-wrapper, .header-vh.header10 {
                height: auto !important;
            } 
            .header10-layout .header-vh {
                float: none;
            }
            .header10-layout #leap-wrapper, .header11-layout #leap-wrapper  {
                margin: 0px;
            }
            .slicknav_btn {
                margin-top: 18px;
                margin-bottom: 18px;
            }
            #leap-wrapper .header .logo , .header .logo  {
                margin: 0px;
            }
            #leap-wrapper .logo a , .logo a {
                margin: 16px 0px;
            }
            #leap-wrapper .logo a img, #leap-wrapper .logo a h1 , .logo a img, .logo a h1 {
                
                max-height: 31px;
                height: 31px;  /*** for spa demo ****/
            }
            .header7 .nav-container .transparent-header {
                padding-bottom: 0px;
            }
            .header8 .navbar-inner, .header9 .navbar-inner {
                padding-top: 15px;
                padding-bottom: 15px;
            }
            .header9 .logo.text-center {
                text-align: left;
            }
            .header8 .nav-container .mainmenu-logo > .pull-right, 
            .header8 .nav-container .mainmenu-logo> .pull-left, 
            .header9 .nav-container .mainmenu-logo > .pull-right, 
            .header9 .nav-container .mainmenu-logo > .pull-left {
                padding-left: 0px;
                padding-right: 0px;
            }
            .header9 .nav-container .mainmenu-logo > .logo {
                width: 50%;
            }
            .header9 .nav-container .mainmenu-logo > .logo a {
                margin-left: 15px !important;
                position: relative;
            }
            .header-vh.header10, .header-vh.header11, .header-vh.header12, .header-vh.header13 {
                width: 100% !important;
            }
            .boxed.header10-layout, .boxed.header11-layout  {
                padding: 0px;
            }
            .header-vh.header10, .header-vh.header11 {
                position: relative;
                margin-top: 0px;
            }
            .header14.side-header .header-vh-wrapper {
                display: block;
            }
            .header12 .header-content, .header13 .header-content {
                opacity: 1;
            }
            .header12-layout #leap-wrapper {
                margin-left: 0px;
            }
            .header13-layout #leap-wrapper, .header13-layout a.scrollup {
                margin-right: 0px;
            }
            .header-vh.header12 {
                left: 0px;
            }
            .header-vh.header13 {
                right: 0px;
            }
            .header12 .header-content, .header13 .header-content {
                width: 100%;
            }
            .header-vh-wrapper .menu-icon {
                display: none;
            }
            .header14 {
                position: relative;
            }
            .header-vh.header14 .header-vh-wrapper {
                display: block !important;
                padding: 0px;
                position: relative;
            }
            .header-vh.header14 .header-vh-wrapper, .header-vh.header14 .header-vh-wrapper .header-content {
                opacity: 1;
            }
            .header14 .header-vh-wrapper .header-content {
                padding: 0px 15px;
            }
            .header14 .nav-container {
                display: block;
            }
            .header14 a.menu-icon {
                display: none;
            }
            <?php if ( ot_get_option( 'mobile_display_top_header', 'off' ) == 'off' ) : ?>
                .topbar-block {
                    display: none;
                }
            <?php endif; ?>
        }



        /***************************************************************/
        /****** Custom CSS ********/

        <?php echo ot_get_option( 'global_css' ); ?>

        @media screen and (min-width: 768px) and (max-width:985px) {
            <?php echo ot_get_option( 'tablets_css' ); ?>	
        }
        @media screen and (min-width: 480px) and (max-width:767px) {
            <?php echo ot_get_option( 'wide_phones_css' ); ?>	
        }
        @media screen and (min-width: 320px) and (max-width:479px) {
            <?php echo ot_get_option( 'phones_css' ); ?>	
        }
    </style>
    <?php
}
