<?php

if ( class_exists( 'ulp_admin_class' ) ) {

    class leap_ulp_class extends ulp_admin_class {


        function import_zip( $_filename, $_title = '' ) {
            global $wpdb, $ulp;
            error_reporting( 0 );
            //$str_id = $ulp->random_string(16);
            $str_id     = basename( $_filename, '.zip' );
            //if (!class_exists('ZipArchive')) {
            //	return new WP_Error('ulp_no_required_classes', __('This operation <strong>requires</strong> <em>ZipArchive</em> class. It is <strong>not found</strong>.', 'ulp'));
            //}
            $upload_dir = wp_upload_dir();
            if ( !file_exists( $upload_dir[ "basedir" ] . '/' . ULP_UPLOADS_DIR . '/temp' ) ) {
                return new WP_Error( 'ulp_no_temp_folder', __( 'Please <strong>re-activate</strong> the plugin and try again.', 'ulp' ) );
            }
            $temp_dir = $upload_dir[ "basedir" ] . '/' . ULP_UPLOADS_DIR . '/' . $str_id;
            if ( !wp_mkdir_p( $temp_dir ) ) {
                return new WP_Error( 'ulp_no_temp_folder', __( 'Make sure that the following folder has write permission:', 'ulp' ) . ' ' . $upload_dir[ "basedir" ] . '/' . ULP_UPLOADS_DIR );
            }
            require_once(ABSPATH . 'wp-admin/includes/file.php');
            WP_Filesystem();
            $result = unzip_file( $_filename, $temp_dir );
            if ( is_wp_error( $result ) ) {
                $zip = new ZipArchive;
                if ( $zip->open( $_filename ) === TRUE ) {
                    $zip->extractTo( $temp_dir );
                    $zip->close();
                } else {
                    return new WP_Error( 'ulp_cant_unzip', __( 'Can not unzip archive into folder', 'ulp' ) . ' ' . $temp_dir );
                }
            }
            if ( !file_exists( $temp_dir . '/popup.txt' ) ) {
                $this->remove_dir( $temp_dir );
                return new WP_Error( 'ulp_invalid_archive', __( 'Please make sure that you uploaded valid popup file. Error #1.', 'ulp' ) );
            }
            $lines = file( $temp_dir . '/popup.txt' );
            if ( sizeof( $lines ) != 3 ) {
                $this->remove_dir( $temp_dir );
                return new WP_Error( 'ulp_invalid_archive', __( 'Please make sure that you uploaded valid popup file. Error #2.', 'ulp' ) );
            }
            $version = intval( trim( $lines[ 0 ] ) );
            if ( $version > intval( ULP_EXPORT_VERSION ) ) {
                $this->remove_dir( $temp_dir );
                return new WP_Error( 'ulp_invalid_archive', __( 'Please make sure that you uploaded valid popup file. Error #3.', 'ulp' ) );
            }
            $md5_hash   = trim( $lines[ 1 ] );
            $popup_data = trim( $lines[ 2 ] );
            $popup_data = base64_decode( $popup_data );
            if ( !$popup_data || md5( $popup_data ) != $md5_hash ) {
                $this->remove_dir( $temp_dir );
                return new WP_Error( 'ulp_invalid_archive', __( 'Please make sure that you uploaded valid popup file. Error #4.', 'ulp' ) );
            }
            $popup = unserialize( $popup_data );
            if ( $popup === false ) {
                $this->remove_dir( $temp_dir );
                return new WP_Error( 'ulp_invalid_archive', __( 'Please make sure that you uploaded valid popup file. Error #5.', 'ulp' ) );
            }
            $popup_details          = $popup[ 'popup' ];
            if ( !empty( $_title ) )
                $popup_details[ 'title' ] = $_title;

            $upload_url = trailingslashit( $upload_dir[ 'baseurl' ] ) . ULP_UPLOADS_DIR . '/' . $str_id;
            if ( strtolower( substr( $upload_url, 0, 7 ) ) == 'http://' )
                $upload_url = substr( $upload_url, 5 );
            else if ( strtolower( substr( $upload_url, 0, 8 ) ) == 'https://' )
                $upload_url = substr( $upload_url, 6 );

            $sql      = "INSERT INTO " . $wpdb->prefix . "ulp_popups (str_id, title, width, height, options, created, blocked, deleted) VALUES (
			'" . $str_id . "', 
			'" . esc_sql( $popup_details[ 'title' ] ) . "', 
			'" . intval( $popup_details[ 'width' ] ) . "', 
			'" . intval( $popup_details[ 'height' ] ) . "', 
			'" . esc_sql( $popup_details[ 'options' ] ) . "', 
			'" . time() . "', '0', '0')";
            $wpdb->query( $sql );
            $popup_id = $wpdb->insert_id;
            $layers   = $popup[ 'layers' ];
            if ( sizeof( $layers ) > 0 ) {
                foreach ( $layers as $layer ) {
                    $layer_options                     = unserialize( $layer[ 'details' ] );
                    if ( is_array( $layer_options ) )
                        $layer_options                     = array_merge( $ulp->default_layer_options, $layer_options );
                    else
                        $layer_options                     = $ulp->default_layer_options;
                    $layer_options[ 'content' ]          = str_replace( 'ULP-UPLOADS-DIR', $upload_url, $layer_options[ 'content' ] );
                    $layer_options[ 'background_image' ] = str_replace( 'ULP-UPLOADS-DIR', $upload_url, $layer_options[ 'background_image' ] );
                    $layer[ 'content' ]                  = str_replace( 'ULP-UPLOADS-DIR', $upload_url, $layer[ 'content' ] );
                    $layer[ 'details' ]                  = serialize( $layer_options );
                    $sql                               = "INSERT INTO " . $wpdb->prefix . "ulp_layers (popup_id, title, content, zindex, details, created, deleted) VALUES (
					'" . $popup_id . "',
					'" . esc_sql( $layer[ 'title' ] ) . "',
					'" . esc_sql( $layer[ 'content' ] ) . "',
					'" . esc_sql( $layer[ 'zindex' ] ) . "',
					'" . esc_sql( $layer[ 'details' ] ) . "',
					'" . time() . "', '0')";
                    $wpdb->query( $sql );
                }
            }
            return true;
        }

    }

}