<?php

if ( !defined( 'ABSPATH' ) ) {
    die( 'No direct access allowed' );
}

if ( !function_exists( 'ot_type_export_data' ) ) {

    /**
     * Export Data option type.
     */
    function ot_type_leap_export_data() {

        /* format setting outer wrapper */
        echo '<div class="format-setting type-textarea simple">';

        /* get theme options data */
        $data = get_option( ot_options_id() );
        $data = !empty( $data ) ? ot_encode( serialize( $data ) ) : '';

        echo '<div class="format-setting-inner">';
        echo '<textarea rows="10" cols="40" name="export_data" id="export_data" class="textarea">' . $data . '</textarea>';
        echo '</div>';

        echo '</div>';
    }

}

/**
 * Import Data option type.
 */
function ot_type_leap_import_data() {

    /* form nonce */
    wp_nonce_field( 'leap_import_options', 'leap_import_options_nonce' );

    /* format setting outer wrapper */
    echo '<div class="format-setting type-textarea has-desc">';

    /* description */
    echo '<div class="description">';

    echo '<p>' . __( 'To import your Theme Options copy and paste what appears to be a random string of alpha numeric characters into this textarea and press the "Import Theme Options" button.', 'option-tree' ) . '</p>';

    echo '</div>';

    /* textarea */
    echo '<div class="format-setting-inner">';

    echo '<textarea rows="10" cols="40" name="leap_import_data" id="leap_import_data" class="textarea"></textarea>';

    echo '</div>';

    /* button */
    echo '<a class="option-tree-ui-button button button-primary right hug-right" href="#">' . __( 'Import Theme Options', 'option-tree' ) . '</a>';

    echo '</div>';
}

add_action( 'after_setup_theme', 'leap_set_google_fonts_after_manual_import' );

function leap_set_google_fonts_after_manual_import() {
    $page   = isset( $_REQUEST[ 'page' ] ) ? $_REQUEST[ 'page' ] : '';
    $action = isset( $_REQUEST[ 'action' ] ) ? $_REQUEST[ 'action' ] : '';

    if ( ($page == 'leap-options-export-import') && ($action == 'import-data') ) {
        // Fetch Google fonts
        if ( is_admin() ) {
            ot_fetch_google_fonts();
            $google_fonts = ot_get_option( 'google_fonts', array() );
            ot_set_google_fonts( 'google_fonts', $google_fonts );
        }
    }
}

add_action( 'wp_ajax_leap_import_options', 'leap_import_options' );

function leap_import_options() {

    $message = 'failed';

    if ( empty( $_POST[ 'import_data' ] ) ) {
        $message = 'empty';
        die( $message );
    }

    if ( isset( $_POST[ 'nonce' ] ) && wp_verify_nonce( $_POST[ 'nonce' ], 'leap_import_options' ) ) {

        /* textarea value */
        $options = isset( $_POST[ 'import_data' ] ) ? unserialize( ot_decode( $_POST[ 'import_data' ] ) ) : '';

        /* get settings array */
        $settings = get_option( ot_settings_id() );

        /* has options */
        if ( is_array( $options ) ) {

            /* validate options */
            if ( is_array( $settings ) ) {

                foreach ( $settings[ 'settings' ] as $setting ) {

                    if ( isset( $options[ $setting[ 'id' ] ] ) ) {

                        $content = ot_stripslashes( $options[ $setting[ 'id' ] ] );

                        $options[ $setting[ 'id' ] ] = ot_validate_setting( $content, $setting[ 'type' ], $setting[ 'id' ] );
                    }
                }
            }

            /* update the option tree array */
            update_option( ot_options_id(), $options );

            $message = 'success';
        }
        die( $message );
    }
    die( $message );
}
