<?php

if ( !defined( 'ABSPATH' ) ) {
    die( 'No direct access allowed' );
}

/**
 * Set default units for spacing option
 * @param array $array Default units
 * @param string $field_id
 * @return array filtered units
 */
function leap_recognized_spacing_unit_types( $array, $field_id ) {
    $array = array(
        'px' => 'px',
        '%'  => '%'
    );
    return $array;
}

add_filter( 'ot_recognized_spacing_unit_types', 'leap_recognized_spacing_unit_types', 10, 2 );

/**
 * Set default units for measurement option
 * @param array $array Default units
 * @param string $field_id
 * @return array filtered units
 */
function leap_measurement_unit_types( $array, $field_id ) {
    $array = array(
        'px' => 'px',
        '%'  => '%'
    );
    return $array;
}

add_filter( 'ot_measurement_unit_types', 'leap_measurement_unit_types', 10, 2 );

/**
 * Set px as a default unit for some measurement options
 * @param array $array Default units
 * @param string $field_id
 * @return array filtered units
 */
function leap_measurement_px_unit( $array, $field_id ) {
    $fields = array( 'mobile_menu_width', 'sticky_scroll_offset', 'vh_width' ,'button_radius_size' );
    if ( in_array( $field_id, $fields ) ) {
        $array = array(
            'px' => 'px'
        );
    }
    return $array;
}

add_filter( 'ot_measurement_unit_types', 'leap_measurement_px_unit', 10, 2 );

/**
 * Set dimension fields to be width and height only
 * @param array $array
 * @param string $field_id
 * @return array
 */
function leap_recognized_dimension_fields( $array, $field_id ) {
    $array = array(
        'width',
        'height'
    );
    return $array;
}

add_filter( 'ot_recognized_dimension_fields', 'leap_recognized_dimension_fields', 10, 2 );

/**
 * Set spacing fields to be top and bottom only for certain options
 * @param array $array
 * @param string $field_id
 * @return array
 */
function leap_recognized_spacing_top_bottom_fields( $array, $field_id ) {

    /**
     * Display Top & Bottom only for dome spacing options
     */
    $fields = array( 'add_to_top_bottom', 'title_spacing', 'leap_title_spacing', 'main_menu_logo_spacing', 'page_content_spacing', 'leap_page_content_spacing', 'main_sidebar_spacing', 'footer_spacing', 'leap_header_sidebar_spacing', 'leap_maintop_sidebar_spacing', 'leap_headerfull_sidebar_spacing', 'leap_maincontenttop_sidebar_spacing', 'leap_contenttop_sidebar_spacing', 'leap_contentbottom_sidebar_spacing', 'leap_maincontentbottom_sidebar_spacing', 'leap_footerfull_sidebar_spacing', 'leap_mainbottom_sidebar_spacing', 'leap_footer_sidebar_spacing' );
    if ( in_array( $field_id, $fields ) ) {
        $array = array(
            'top',
            'bottom',
            'unit'
        );
    }
    return $array;
}

add_filter( 'ot_recognized_spacing_fields', 'leap_recognized_spacing_top_bottom_fields', 10, 2 );

/**
 * Add preview ability to samrt skins
 * @param string $attributes
 * @param string $field_id
 * @param array $choice
 * @return string new add attributes
 */
function leap_type_radio_image_attributes( $attributes, $field_id, $choice ) {
    $fields = array( 'light_ready_made_smart_skins', 'dark_ready_made_smart_skins' );
    if ( in_array( $field_id, $fields ) ) {
        $attributes .= ' data-preview="' . get_template_directory_uri() . '/functions/images/skins/preview/' . $choice[ 'value' ] . '-preview.jpg"';
    }
    return $attributes;
}

add_filter( 'ot_type_radio_image_attributes', 'leap_type_radio_image_attributes', 10, 3 );

/**
 * Recognized Link Color Fields
 * @param array $array
 * @param string $field_id
 * @return array Color fields
 */
function leap_recognized_link_color_fields( $array, $field_id ) {

    /**
     * Content & Widget Typography Color Options
     */
    if ( $field_id == 'smart_skin_typography' ) {
        $array = array(
            't1' => __( 'T1', 'wiz' ),
            't2' => __( 'T2', 'wiz' ),
            't3' => __( 'T3', 'wiz' )
        );
    }

    /**
     * Content & Widget Backgrounds, Borders & Separator Color Options
     */
    if ( $field_id == 'smart_skin_backgrounds' ) {
        $array = array(
            'b1' => __( 'B1', 'wiz' ),
            'b2' => __( 'B2', 'wiz' ),
            'b3' => __( 'B3', 'wiz' )
        );
    }

    /**
     * Footer Typography & Backgrounds Color Options
     */
    if ( $field_id == 'smart_skin_footer' ) {
        $array = array(
            'ft' => __( 'FT', 'wiz' ),
            'fb' => __( 'FB', 'wiz' )
        );
    }
    
    /**
     * Vertical Header Icon Color Options
     */
    if ( $field_id == 'vh_icon_colors' ) {
        $array = array(
            'icon' => __( 'Icon', 'wiz' ),
            'icon-hover' => __( 'Icon Hover', 'wiz' ),
            'bg' => __( 'Background', 'wiz' ),
            'bg-hover' => __( 'Background Hover', 'wiz' )
        );
    }

    /**
     * Links Color Options
     */
    $fields = array( 'links_color', 'leap_header_sidebar_links_color', 'leap_maintop_sidebar_links_color', 'leap_headerfull_sidebar_links_color', 'leap_maincontenttop_sidebar_links_color', 'leap_contenttop_sidebar_links_color', 'leap_contentbottom_sidebar_links_color', 'leap_maincontentbottom_sidebar_links_color', 'leap_footerfull_sidebar_links_color', 'leap_mainbottom_sidebar_links_color', 'leap_footer_sidebar_links_color' );
    if ( in_array( $field_id, $fields ) ) {
        $array = array(
            'link'  => __( 'Standard', 'wiz' ),
            'hover' => __( 'Hover', 'wiz' )
        );
    }

    /**
     * Button Color Options for sidebars
     */
    $fields = array( 'button_color_options', 'footer_button_colors', 'leap_header_sidebar_button_color_options', 'leap_maintop_sidebar_button_color_options', 'leap_headerfull_sidebar_button_color_options', 'leap_maincontenttop_sidebar_button_color_options', 'leap_contenttop_sidebar_button_color_options', 'leap_contentbottom_sidebar_button_color_options', 'leap_maincontentbottom_sidebar_button_color_options', 'leap_footerfull_sidebar_button_color_options', 'leap_mainbottom_sidebar_button_color_options', 'leap_footer_sidebar_button_color_options' );
    if ( in_array( $field_id, $fields ) ) {
        $array = array(
            'text'     => __( 'Text Color', 'wiz' ),
            'bg'       => __( 'Background Color', 'wiz' ),
            'bg-hover' => __( 'Background Hover Color', 'wiz' ),
            'border'   => __( 'Border Color', 'wiz' ),
            'text-hover' => esc_html__('Text Hover Color', 'wiz'),
            'border-hover'   => esc_html__('Border Hover Color', 'wiz')

        );
    }
    /**
     * Button Color Options
     */
    $fields = array( 'button_color_options' );
    if ( in_array( $field_id, $fields ) ) {
        $array = array(
            'text-hover' => esc_html__('Text Hover Color', 'eternity'),
            'bg'         => esc_html__('Background Color', 'eternity'),
            'bg-hover'   => esc_html__('Background Hover Color', 'eternity'),
            'border-hover'   => esc_html__('Border Hover Color', 'eternity')
        );
    }
         /**
     * Footer Button Color Options
     */
    $fields = array( 'footer_button_colors' );
    if ( in_array( $field_id, $fields ) ) {
        $array = array(
            'text' => esc_html__('Text Color', 'wiz'),
            'text-hover' => esc_html__('Text Hover Color', 'wiz'),
            'bg'         => esc_html__('Background Color', 'wiz'),
            'bg-hover'   => esc_html__('Background Hover Color', 'wiz'),
            'border'   => esc_html__('Border Color', 'wiz'),
            'border-hover'   => esc_html__('Border Hover Color', 'wiz')
              );
    }

    /**
     * Image Overlay Color Options
     */
    if ( $field_id == 'image_overlay_color_options' ) {
        $array = array(
            'main-color'       => __( 'Main Color', 'wiz' ),
            'text-color'       => __( 'Text Color', 'wiz' ),
            'icon-color'       => __( 'Icon Color', 'wiz' ),
            'icon-hover-color' => __( 'Hover Icon Color', 'wiz' ),
            'icon-bg-color'    => __( 'Icon Background Color', 'wiz' )
        );
    }

    /**
     * Input Color Options
     */
    $fields = array( 'input_color_options', 'footer_input_colors', 'leap_header_sidebar_input_color_options', 'leap_maintop_sidebar_input_color_options', 'leap_headerfull_sidebar_input_color_options', 'leap_maincontenttop_sidebar_input_color_options', 'leap_contenttop_sidebar_input_color_options', 'leap_contentbottom_sidebar_input_color_options', 'leap_maincontentbottom_sidebar_input_color_options', 'leap_footerfull_sidebar_input_color_options', 'leap_mainbottom_sidebar_input_color_options', 'leap_footer_sidebar_input_color_options' );
    if ( in_array( $field_id, $fields ) ) {
        $array = array(
            'bg'     => __( 'Background Color', 'wiz' ),
            'border' => __( 'Border Color', 'wiz' ),
            'text'   => __( 'Text Color', 'wiz' )
        );
    }

    /**
     * Top Menu Color Options
     * Main Menu Color Options
     */
    $fields = array( 'top_menu_colors', 'main_menu_colors' );
    if ( in_array( $field_id, $fields ) ) {
        $array = array(
            'text-hover' => __( 'Text Hover', 'wiz' ),
            'sep'        => __( 'Separator Color', 'wiz' )
        );
    }

    /**
     * Top Submenu Color Options
     */
    if ( 'top_sub_colors' == $field_id ) {
        $array = array(
            'bg'         => __( 'Background', 'wiz' ),
            'text-hover' => __( 'Text Hover', 'wiz' ),
            'divider'    => __( 'Divider', 'wiz' )
        );
    }

    /**
     * Main Menu Sublevels Color Options
     */
    if ( 'main_sub_colors' == $field_id ) {
        $array = array(
            'bg'         => __( 'Background', 'wiz' ),
            'text-hover' => __( 'Text Hover', 'wiz' ),
            'divider'    => __( 'Divider', 'wiz' )
        );
    }

    /**
     * Sticky Menu Color Options
     */
    if ( 'sticky_menu_colors' == $field_id ) {
        $array = array(
            'text'       => __( 'Text', 'wiz' ),
            'text-hover' => __( 'Text Hover', 'wiz' ),
            'sep'        => __( 'Separator', 'wiz' )
        );
    }

    /**
     * Sticky Menu Sublevels Color Options
     */
    if ( 'sticky_sub_colors' == $field_id ) {
        $array = array(
            'bg'         => __( 'Background', 'wiz' ),
            'text'       => __( 'Text', 'wiz' ),
            'text-hover' => __( 'text Hover', 'wiz' ),
            'divider'    => __( 'Divider', 'wiz' )
        );
    }

    /**
     * Sharing Box Color Options
     */
    if ( 'sharing_box_colors' == $field_id ) {
        $array = array(
            'bg'         => __( 'Background', 'wiz' ),
            'icon'       => __( 'Icon Color', 'wiz' ),
            'icon-hover' => __( 'Icon Hover', 'wiz' )
        );
    }

    /**
     * Main Sidebar Color Options
     * Footer Color Options
     */
    $fields_2 = array( 'main_sidebar_colors', 'footer_colors' );
    if ( in_array( $field_id, $fields_2 ) ) {
        $array = array(
            'meta'       => __( 'Meta', 'wiz' ),
            'link'       => __( 'Links', 'wiz' ),
            'link-hover' => __( 'Links Hover', 'wiz' ),
            'divider'    => __( 'List Divider', 'wiz' )
        );
    }

    /**
     * Header social icons colors
     * Footer social color Options
     */
    $fields_3 = array( 'copyright_social_icons_colors', 'top_social_icons_colors' );
    if ( in_array( $field_id, $fields_3 ) ) {
        $array = array(
            'icon'       => __( 'Icon Color', 'wiz' ),
            'icon-hover' => __( 'Icon Hover Color', 'wiz' )
        );
    }

    /**
     * Go top Icon Color Options
     */
    if ( 'go_top_colors' == $field_id ) {
        $array = array(
            'icon' => __( 'Icon Color', 'wiz' ),
            'bg'   => __( 'Background Color', 'wiz' )
        );
    }

    /**
     * Copyright Color Options
     */
    if ( 'copyright_colors' == $field_id ) {
        $array = array(
            'bg'         => __( 'Background Color', 'wiz' ),
            'link'       => __( 'Link Color', 'wiz' ),
            'link-hover' => __( 'Link Hover Color', 'wiz' )
        );
    }

    return $array;
}

add_filter( 'ot_recognized_link_color_fields', 'leap_recognized_link_color_fields', 10, 2 );

/**
 * Filter line height high range
 * @param int $high_range
 * @param string $field_id
 * @return int
 */
function leap_line_height_high_range( $high_range, $field_id ) {
    return 300;
}

add_filter( 'ot_line_height_high_range', 'leap_line_height_high_range', 10, 2 );
