<?php

if ( !defined( 'ABSPATH' ) ) {
    die( 'No direct access allowed' );
}

if ( !function_exists( 'leap_breadcrumbs' ) ) {

    /**
     * Display breadcrumbs
     * http://www.qualitytuts.com/wordpress-custom-breadcrumbs-without-plugin/
     */
    function leap_breadcrumbs() {
        if ( ot_get_option( 'enable_breadcrumbs', 'no' ) == 'yes' ) {

            $showOnHome  = ot_get_option( 'breadcrumbs_show_on_home', 'no' );
            $delimiter   = ot_get_option( 'breadcrumbs_delimiter', __( '&raquo;', 'wiz' ) );
            $delimiter   = '<span class="crumbs-delimiter">' . $delimiter . '</span>';
            $home        = esc_html( ot_get_option( 'breadcrumbs_home_text', __( 'Home', 'wiz' ) ) );
            $showCurrent = ot_get_option( 'breadcrumbs_show_current', 'yes' );
            $before      = '<span class="current">';
            $after       = '</span>';

            $you_are_here_text = ot_get_option( "breadcrumbs_you_are_here", __( 'You are here', 'wiz' ) );
            $you_are_here      = '';
            if ( !empty( $you_are_here_text ) ) {
                $you_are_here = '<span>' . $you_are_here_text . ': </span>';
            }

            global $post;
            $homeLink       = home_url();
            $queried_object = get_queried_object();

            if ( is_front_page() ) {
                if ( $showOnHome == 'yes' ) {
                    echo '<div id="crumbs">' . $you_are_here . '<a href="' . $homeLink . '">' . $home . '</a></div>';
                }
            } else {
                echo '<div id="crumbs">' . $you_are_here . '<a href="' . $homeLink . '">' . $home . '</a> ' . $delimiter . ' ';

                if ( class_exists( 'Woocommerce' ) && is_woocommerce() && ( is_product() || is_shop() ) && !is_search() ) {
                    woocommerce_breadcrumb( $args = array() );
                } elseif ( class_exists( 'bbPress' ) && (is_bbpress()) ) {
                    echo bbp_breadcrumb();
                } elseif ( is_archive() ) {

                    if ( is_search() ) {
                        echo $before . __( 'Search results for:', 'wiz' ) . get_search_query() . $after;
                    } elseif ( is_category() ) {
                        // Category
                        $thisCat = get_category( get_query_var( 'cat' ), false );
                        if ( $thisCat->parent != 0 ) {
                            echo get_category_parents( $thisCat->parent, TRUE, ' ' . $delimiter . ' ' );
                        }
                        echo $before . esc_html( single_cat_title( '', false ) ) . $after;
                    } elseif ( is_day() ) {
                        // Day
                        echo '<a href="' . get_year_link( get_the_time( 'Y' ) ) . '">' . get_the_date( 'Y' ) . '</a> ' . $delimiter . ' ';
                        echo '<a href="' . get_month_link( get_the_time( 'Y' ), get_the_time( 'm' ) ) . '">' . get_the_date( 'F' ) . '</a> ' . $delimiter . ' ';
                        echo $before . get_the_date( 'd' ) . $after;
                    } elseif ( is_month() ) {
                        // Month
                        echo '<a href="' . get_year_link( get_the_time( 'Y' ) ) . '">' . get_the_date( 'Y' ) . '</a> ' . $delimiter . ' ';
                        echo $before . get_the_date( 'F' ) . $after;
                    } elseif ( is_year() ) {
                        // Year
                        echo $before . get_the_date( 'Y' ) . $after;
                    } elseif ( is_tag() ) {
                        echo $before . 'Tag "' . esc_html( single_tag_title( '', false ) ) . '"' . $after;
                    } elseif ( is_author() ) {
                        global $author;
                        $userdata = get_userdata( $author );
                        echo $before . 'Author "' . esc_html( $userdata->display_name ) . '"' . $after;
                    } else {
                        echo $before . single_cat_title( '', false ) . $after;
                    }
                } elseif ( is_single() && !is_attachment() ) {
                    if ( get_post_type() == 'leap-portfolio' ) {
                        $post_type = get_post_type_object( get_post_type() );
                        $terms     = get_the_terms( $post->ID, 'leap-portfolio-category' );
                        if ( $terms ) {
                            $cat = $terms[ 0 ];
                            echo '<a href="' . get_term_link( $cat ) . '">' . $cat->name . '</a>';
                            if ( $showCurrent == 'yes' ) {
                                echo ' ' . $delimiter . ' ';
                            }
                        }
                        if ( $showCurrent == 'yes' ) {
                            echo $before . get_the_title() . $after;
                        }
                    } elseif ( get_post_type() == 'post' ) {
                        $cat  = get_the_category();
                        $cat  = $cat[ 0 ];
                        $cats = get_category_parents( $cat, TRUE, ' ' . $delimiter . ' ' );
                        if ( $showCurrent == 'no' )
                            $cats = preg_replace( "#^(.+)\s$delimiter\s$#", "$1", $cats );
                        echo $cats;
                        if ( $showCurrent == 'yes' ) {
                            echo $before . esc_html( get_the_title() ) . $after;
                        }
                    } else {
                        $post_type = get_post_type_object( get_post_type() );
                        echo '<a href="' . get_post_type_archive_link( get_post_type() ) . '">' . $post_type->labels->singular_name . '</a>';
                        if ( $showCurrent == 'yes' ) {
                            echo ' ' . $delimiter . ' ' . $before . esc_html( get_the_title() ) . $after;
                        }
                    }
                } elseif ( is_attachment() ) {
                    $parent_id = $post->post_parent;
                    if ( $parent_id ) {
                        echo '<a href="' . get_permalink( $parent_id ) . '">' . get_the_title( $parent_id ) . '</a>';
                        if ( $showCurrent == 'yes' ) {
                            echo ' ' . $delimiter . ' ';
                        }
                    }
                    if ( $showCurrent == 'yes' ) {
                        echo $before . get_the_title() . $after;
                    }
                } elseif ( is_home() ) {
                    if ( $showCurrent == 'yes' ) {
                        echo $before . leap_get_current_page_title() . $after;
                    }
                } elseif ( is_page() && !$post->post_parent ) {
                    if ( $showCurrent == 'yes' ) {
                        echo $before . get_the_title() . $after;
                    }
                } elseif ( is_page() && $post->post_parent ) {
                    $parent_id   = $post->post_parent;
                    $breadcrumbs = array();
                    while ( $parent_id ) {
                        $page          = get_page( $parent_id );
                        $breadcrumbs[] = '<a href="' . get_permalink( $page ) . '">' . esc_html( get_the_title( $page ) ) . '</a>';
                        $parent_id     = $page->post_parent;
                    }
                    $breadcrumbs = array_reverse( $breadcrumbs );
                    for ( $i = 0; $i < count( $breadcrumbs ); $i++ ) {
                        echo $breadcrumbs[ $i ];
                        if ( $i != count( $breadcrumbs ) - 1 )
                            echo ' ' . $delimiter . ' ';
                    }
                    if ( $showCurrent == 'yes' )
                        echo ' ' . $delimiter . ' ' . $before . esc_html( get_the_title() ) . $after;
                } elseif ( is_404() ) {
                    echo $before . esc_html__( 'Error 404', 'wiz' ) . $after;
                }

                echo '</div>';
            }
        }
    }

}

