<?php

/**
 * Allow breadcrumb on theme only and remove default one
 */
function leap_bbp_no_breadcrumb() {
    static $bbp_breadcrumb = 0;
    ++$bbp_breadcrumb;
    if ( $bbp_breadcrumb == 1 ) {
        return true;
    }
    return false;
}

add_filter( 'bbp_no_breadcrumb', 'leap_bbp_no_breadcrumb' );

/**
 * Add theme default wrapps for breadcrumb
 * @param array $args
 * @return array
 */
function leap_bbp_breadcrumb_parse_args( $args = array() ) {
    $args[ 'before' ]          = '';
    $args[ 'after' ]           = '';
    $args[ 'sep' ]             = ot_get_option( 'delimiter', __( '&raquo;', 'wiz' ) );
    $args[ 'sep_before' ]      = '<span class="crumbs-delimiter">';
    $args[ 'sep_after' ]       = '</span>';
    $args[ 'include_home' ]    = false;
    $args[ 'include_current' ] = (ot_get_option( 'breadcrumbs_show_current', 'yes' ) == 'yes') ? true : false;
    return $args;
}

add_filter( 'bbp_after_get_breadcrumb_parse_args', 'leap_bbp_breadcrumb_parse_args' );

