<?php

/**
 * Wiz functions and definitions
 *
 * Set up the theme and provides some helper functions, which are used in the
 * theme as custom template tags. Others are attached to action and filter
 * hooks in WordPress to change core functionality.
 *
 * When using a child theme you can override certain functions (those wrapped
 * in a function_exists() call) by defining them first in your child theme's
 * functions.php file. The child theme's functions.php file is included before
 * the parent theme's file, so the child theme functions would be used.
 *
 * @link https://codex.wordpress.org/Theme_Development
 * @link https://codex.wordpress.org/Child_Themes
 *
 * Functions that are not pluggable (not wrapped in function_exists()) are
 * instead attached to a filter or action hook.
 *
 * For more information on hooks, actions, and filters,
 * {@link https://codex.wordpress.org/Plugin_API}
 *
 */
define( 'THEME_VERSION', '3.0.4' );


/*
 * Set the content width based on the theme's design and stylesheet.
 */
if ( !isset( $content_width ) ) {
	$content_width = 847;
}


if ( !function_exists( 'leap_theme_support' ) ) {

	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 */
	function leap_theme_support() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 */
		load_theme_textdomain( 'wiz', get_template_directory() . '/languages' );

		/*
		 * Add default posts and comments RSS feed links to head.
		 */
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'search-form', 'comment-form', 'comment-list', 'gallery', 'caption'
		) );

		/*
		 * Enable support for Post Formats.
		 */
		add_theme_support( 'post-formats', array(
			'aside', 'audio', 'chat', 'gallery', 'image', 'link', 'quote', 'status', 'video'
		) );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 */
		add_theme_support( 'post-thumbnails' );

		/*
		 * Setup the WordPress core custom header feature.
		 */
		$header_args = array(
			'flex-width'	 => true,
			'flex-height'	 => true,
			'header-text'	 => false,
		);
		add_theme_support( 'custom-header', $header_args );

		/*
		 * Setup the WordPress core custom background feature.
		 */
		add_theme_support( 'custom-background' );

		/*
		 * Enable support for woocommerce.
		 */
		add_theme_support( 'woocommerce' );

		/*
		 * This theme uses wp_nav_menu() in four locations.
		 */
		register_nav_menus( array(
			'top-menu'			 => __( 'Top Menu(Used with Header 5 only)', 'wiz' ),
			'main-menu'			 => __( 'Main Menu', 'wiz' ),
			'mobile-main-menu'	 => __( 'Responsive Main Menu', 'wiz' ),
			'footer-menu'		 => __( 'Footer Menu', 'wiz' ),
			'404-menu'			 => __( '404 Menu', 'wiz' ),
			'left-menu'			 => __( 'Left Menu(Used with Header 9 only)', 'wiz' ),
			'right-menu'		 => __( 'Right Menu(Used with Header 9 only)', 'wiz' ),
         'v-menu'		 => __( 'Vertical Menu(Used with Header 16 only)', 'wiz' )
		) );
	}

}

add_action( 'after_setup_theme', 'leap_theme_support' );


// Load framework
require get_template_directory() . '/functions/framework.php';

// Theme auto update
require get_template_directory() . '/functions/update/theme-update.php';

// Theme Widgets
require get_template_directory() . '/functions/widgets/widgets.php';

// Widget Positions options
require get_template_directory() . '/functions/widget-positions.php';

// Import & Export options
require get_template_directory() . '/functions/import-export.php';

// Demo Data Importer
require get_template_directory() . '/functions/importer/import.php';

// Add our shortcodes as addons for Visual Composer
require get_template_directory() . '/functions/vc/addons.php';

// Add meta boxes to taxonomies
require get_template_directory() . '/functions/tax-meta-boxes.php';

// Widget Attributes
require get_template_directory() . '/functions/widget-attributes.php';

// Meta Boxes
require get_template_directory() . '/functions/meta-boxes.php';

// Enqueue styles and scripts
require get_template_directory() . '/functions/styles-scripts.php';

// Mega Menu support
require get_template_directory() . '/functions/mega-menu/mega-menu.php';

// bundled plugins
require get_template_directory() . '/functions/tgm/bundled-plugins.php';

// Breadcrumbs
require get_template_directory() . '/functions/breadcrumbs.php';

// Page Navigation
require get_template_directory() . '/functions/page-navi.php';

// Sidebar functions
require get_template_directory() . '/functions/sidebars.php';

// WooCommerce support
if ( class_exists( 'woocommerce' ) ) {
	require get_template_directory() . '/functions/woocommerce-config.php';
}

// bbPress support
if ( class_exists( 'bbPress' ) ) {
	require get_template_directory() . '/functions/bbpress-config.php';
}

// Load theme functions
require get_template_directory() . '/functions/theme-functions.php';

// Load theme options CSS
require get_template_directory() . '/functions/internal-css.php';

// Load widget positions css
require get_template_directory() . '/functions/sidebars-css.php';
