<?php
$page_id = leap_get_current_page_id();

if ( (get_page_template_slug( $page_id ) != 'page-100-width-template.php') && !is_404() ) {
    if ( leap_sidebar_position() != 'full' ) {
        if ( class_exists( 'Woocommerce' ) && ( is_shop() || is_product_category() || is_product_tag() || is_product() ) ) {
            get_sidebar( 'shop' );
        } elseif ( class_exists( 'bbPress' ) && is_bbpress() ) {
            get_sidebar( 'bbpress' );
        } else {
            get_sidebar();
        }
    }
}
?>
</div> <!-- end row -->
</div> <!-- end container -->
</div> <!-- end #content -->

<?php
// Main Content Bottom widget position
get_template_part( 'includes/sidebar/main-content-bottom' );
?>

</div><!-- end #leap-content - wrap -->


<?php
// Footer Full Width widget position
get_template_part( 'includes/sidebar/footer-full-width' );
?>

<?php
//  Main Bottom widget position
get_template_part( 'includes/sidebar/main-bottom' );
?>


<div id="leap-footer">
    <div id="inner-footer">

        <?php
        // Footer widget position
        get_template_part( 'includes/sidebar/footer' );
        ?>

    </div> <!-- end #inner-footer -->

    <?php if ( leap_get_option_with_default( 'copyright_area', 'leap_copyright_area' ) == 'on' ) : ?>
        <div class="footer-block">
            <div class="<?php echo apply_filters( 'leap_container_class', 'container-fluid' ); ?>">
                <div class="row">
                <div class="col-sm-12">
                <div class="pull-right">
                    <?php
                    $footer_menu      = leap_get_assigned_menu_on_theme_location( 'footer-menu' );
                    $page_footer_menu = get_post_meta( $page_id, 'leap_footer_menu', TRUE );
                    if ( $page_footer_menu ) {
                        $footer_menu = $page_footer_menu;
                    }

                    $footer_menu_obj = wp_get_nav_menu_object( $footer_menu );
                    if ( !empty( $footer_menu_obj ) && $footer_menu_obj->count > 0 ) {
                        wp_nav_menu( array(
                            'theme_location' => 'footer-menu',
                            'menu'           => $footer_menu,
                            'container'      => 'div',
                            'container_id'   => 'footer-menu-container',
                            'menu_id'        => 'footer-menu',
                            'depth'          => 1,
                            'fallback_cb'    => false
                        ) );
                    }
                    ?>
                </div>
                <div class="pull-left">
                    <?php // Social icons    ?>
                    <?php if ( ot_get_option( 'footer_social_icons' ) == 'yes' ) : ?>
                        <?php get_template_part( 'includes/social', 'icons' ); ?>
                    <?php endif; ?>

                    <?php // Copyright    ?>
                    <?php
                    $copyright = ot_get_option( 'copyright', '' );
                    if ( !empty( $copyright ) ) {
                        echo '<p class="copyright">' . $copyright . '</p>';
                    }
                    ?>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div></div>
    </div><!-- end footer -->

</div> <!-- end #leap-wrapper -->

<?php wp_footer(); ?>

</body>

</html>
<?php do_action( 'leap_after_html_end_tag' ); ?>
