<?php
// Do not delete these lines
if ( !empty( $_SERVER[ 'SCRIPT_FILENAME' ] ) && 'comments.php' == basename( $_SERVER[ 'SCRIPT_FILENAME' ] ) ) {
	die( 'Please do not load this page directly. Thanks!' );
}

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() )
	return;
?>

<div class="clearfix"></div>

<div id="comments" class="comments-area">

	<!-- You can start editing here. -->

	<?php if ( comments_open() ) { ?>
		<?php if ( ot_get_option( 'fb_comments', 'no' ) == 'yes' ) { ?>
			<div class="fb-comments">
				<div class="title"><h4><?php _e( 'Facebook Comments', 'wiz' ); ?></h4></div>

				<div id="fb-root"></div>
				<script>( function ( d, s, id ) {
						var js, fjs = d.getElementsByTagName( s )[0];
						if ( d.getElementById( id ) )
							return;
						js = d.createElement( s );
						js.id = id;
						js.src = "//connect.facebook.net/<?php echo ot_get_option( 'fb_lang', 'en_US' ) ?>/sdk.js#xfbml=1&appId=<?php echo ot_get_option( 'fb_app_id', '' ); ?>&version=v2.0";
						fjs.parentNode.insertBefore( js, fjs );
					}( document, 'script', 'facebook-jssdk' ) );</script>

				<?php
				$fb_width = ot_get_option( 'fb_width', array( '100', '%' ) );
				?>
				<div class="fb-comments" data-href="<?php the_permalink() ?>" data-width="<?php echo $fb_width[ '0' ] . $fb_width[ '1' ]; ?>" data-colorscheme="<?php echo ot_get_option( 'fb_colorscheme', 'light' ); ?>" data-num-posts="<?php echo ot_get_option( 'fb_comments_num', '10' ); ?>" data-order-by="<?php echo ot_get_option( 'fb_order_by', 'social' ); ?>" ></div>
			</div>
		<?php } ?>
	<?php } ?>



	<?php if ( have_comments() ) : ?>

		<div class="comments-container">
			<h3><?php comments_number( __( 'No Comments', 'wiz' ), __( 'One Comment', 'wiz' ), '% ' . __( 'Comments', 'wiz' ) ); ?></h3>

			<ul class="comment list">
				<?php
				wp_list_comments( array(
					'style'			 => 'ul',
					'format'		 => 'xhtml',
					'avatar_size'	 => 50,
				) );
				?>
			</ul>

			<div class="comments-navigation">
				<div class="pull-left prev-comments"><?php previous_comments_link(); ?></div>
				<div class="pull-right next_comments"><?php next_comments_link(); ?></div>
			</div>
		</div>

	<?php endif; ?>

	<?php
	// If comments are closed and there are comments, let's leave a little note, shall we?
	if ( !comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) :
		?>
		<p class="no-comments"><?php echo __( 'Comments are closed.', 'wiz' ); ?></p>
	<?php endif; ?>



	<?php
	if ( comments_open() ) {
		$comments_args = array(
			'title_reply'			 => __( "Leave a comment", "wiz" ),
			'title_reply_to'		 => __( "Leave a comment", "wiz" ),
			'must_log_in'			 => '<p class="must-log-in">' . sprintf( __( "You must be %slogged in%s to post a comment.", "wiz" ), '<a href="' . wp_login_url( apply_filters( 'the_permalink', get_permalink() ) ) . '">', '</a>' ) . '</p>',
			'logged_in_as'			 => '<p class="logged-in-as">' . __( "Logged in as", " wiz" ) . ' <a href="' . admin_url( "profile.php" ) . '">' . $user_identity . '</a>. <a href="' . wp_logout_url( get_permalink() ) . '" title="' . __( "Log out of this account", "wiz" ) . '">' . __( "Log out &raquo;", "wiz" ) . '</a></p>',
			'comment_notes_before'	 => '',
			'comment_notes_after'	 => '',
			'comment_field'			 => '<div class="row">'
			. '<div class="' . leap_bws_col_class( 12 ) . '">'
			. '<div class="form-group">'
			. '<label class="sr-only" for="comment">' . __( "Comment...", "wiz" ) . '</label>'
			. '<textarea name="comment" id="comment" class="form-control" rows="8" placeholder="' . __( "Comment...", "wiz" ) . '"></textarea>'
			. '</div>'
			. '</div>'
			. '</div>',
			'id_submit'				 => 'comment-submit',
			'label_submit'			 => __( "Post Comment", "wiz" ),
		);

		comment_form( $comments_args );
	}
	?>

</div><!-- #comments -->