<?php get_header(); ?>	

<div id="main" class="<?php echo leap_main_col_class(); ?>">

	<?php
	// Content top widget position
	get_template_part( 'includes/sidebar/content-top' );
	?>

	<div class="content-section">

		<?php if ( have_posts() ) { ?>
			<div class="archive-info">
				<?php
				$category_id			 = get_query_var( 'cat' );
				$category_page_settings	 = ot_get_option( 'category_page_settings', array() );
				if ( in_array( 'category_rss', $category_page_settings ) ) {
					?>
					<div class="archive-rss"><a title="<?php esc_html_e( 'Feed Subscription', 'wiz' ); ?>" href="<?php echo get_category_feed_link( $category_id ) ?>"><i class="fa fa-rss-square fa-lg"></i></a></div>
				<?php } ?>

				<?php
				if ( in_array( 'category_desc', $category_page_settings ) ) {
					$category_description = category_description();
					if ( $category_description )
						echo '<div class="archive-description">' . $category_description . '</div>';
				}
				?>

			</div>
			<?php
			$blog_layout = ot_get_option( 'archive_layout', 'medium' );
			?>
			<div class="archive-wrapper">
				<div class="entry-layout archive-<?php echo $blog_layout ?>">
					<?php while ( have_posts() ) : the_post(); ?>
						<?php get_template_part( 'includes/content/archive' ); ?>
					<?php endwhile; ?>
				</div>
			</div>
			<?php leap_page_navi(); ?>

			<?php
		} else {
			get_template_part( 'includes/content/none' );
		}
		?>

	</div>

	<?php
	// Content bottom widget position
	get_template_part( 'includes/sidebar/content-bottom' );
	?>

</div> <!-- end #main -->

<?php get_footer(); ?>
