<?php get_header(); ?>	

<div id="main" class="<?php echo leap_main_col_class(); ?>">

	<?php
	// Content top widget position
	get_template_part( 'includes/sidebar/content-top' );
	?>

	<div class="content-section">

		<?php if ( have_posts() ) { ?>
			<div class="archive-info">
				<?php
				$author_page_settings = ot_get_option( 'author_page_settings', array() );

				if ( in_array( 'author_bio', $author_page_settings ) ) {
					$author_bio = get_the_author_meta( 'description' );
					if ( !empty( $author_bio ) ) {
						?>

						<div class="author-avatar">
							<?php echo get_avatar( get_the_author_meta( 'email' ), '80' ); ?>
						</div>
						<div class="author-description">
							<?php echo $author_bio; ?>
						</div>

						<div class="author-links">
							<a data-toggle="tooltip" data-placement="top" href="<?php echo esc_url( get_the_author_meta( 'author_facebook' ) ); ?>" target="_blank" data-original-title="<?php esc_html_e( 'Facebook', 'wiz' ) ?>"><i class="fa fa-facebook"></i></a>
							<a data-toggle="tooltip" data-placement="top" href="<?php echo esc_url( get_the_author_meta( 'author_twitter' ) ); ?>" target="_blank" data-original-title="<?php esc_html_e( 'Twitter', 'wiz' ) ?>"><i class="fa fa-twitter"></i></a>
							<a data-toggle="tooltip" data-placement="top" href="<?php echo esc_url( get_the_author_meta( 'author_linkedin' ) ); ?>" target="_blank" data-original-title="<?php esc_html_e( 'Linkedin', 'wiz' ) ?>"><i class="fa fa-linkedin"></i></a>
							<a data-toggle="tooltip" data-placement="top" href="<?php echo esc_url( get_the_author_meta( 'author_dribble' ) ); ?>" target="_blank" data-original-title="<?php esc_html_e( 'Dribble', 'wiz' ) ?>"><i class="fa fa-dribbble"></i></a>
							<a data-toggle="tooltip" data-placement="top" href="<?php echo esc_url( get_the_author_meta( 'author_gplus' ) ); ?>" target="_blank" data-original-title="<?php esc_html_e( 'Google +', 'wiz' ) ?>"><i class="fa fa-google-plus"></i></a>
							<a data-toggle="tooltip" data-placement="top" href="<?php echo esc_url( get_author_feed_link( get_the_author_meta( 'ID' ) ) ); ?>" target="_blank" data-original-title="<?php esc_html_e( 'RSS', 'wiz' ) ?>"><i class="fa fa-rss"></i></a>
						</div>

						<?php
					}
				}
				?>
			</div>
			<?php
			$blog_layout = ot_get_option( 'archive_layout', 'medium' );
			?>
			<div class="archive-wrapper">
				<div class="entry-layout archive-<?php echo $blog_layout ?>">
					<?php while ( have_posts() ) : the_post(); ?>
						<?php get_template_part( 'includes/content/archive' ); ?>
					<?php endwhile; ?>
				</div>
			</div>
			<?php leap_page_navi(); ?>

			<?php
		} else {
			get_template_part( 'includes/content/none' );
		}
		?>


	</div>

	<?php
	// Content bottom widget position
	get_template_part( 'includes/sidebar/content-bottom' );
	?>


</div> <!-- end #main -->

<?php get_footer(); ?>
